/*
 * Decompiled with CFR 0.152.
 */
package rpg.basic.scene;

import java.io.DataInputStream;
import rpg.basic.script.ScriptUnit;

public class UnitData {
    private boolean _isValidFlag;
    private int _id;
    private int _x;
    private int _y;
    private int _picId;
    private boolean[] _checkFlag;
    private byte[] _checkValue;
    private byte[] _actorData;
    private short[] _captorData;
    private int _eventSpringKind;
    private byte[] _parameter;
    private ScriptUnit[] _scriptData;
    private boolean _updateFlag;

    public final boolean isValid() {
        return this._isValidFlag;
    }

    public final void setInvalid() {
        this._isValidFlag = false;
    }

    public final void setValid() {
        this._isValidFlag = true;
    }

    public final boolean isValidActor() {
        return true;
    }

    public final short[] getArea() {
        return this._captorData;
    }

    private final void calculateCaptorArea() {
        this._captorData[0] = (short)(this._captorData[0] + this._x);
        this._captorData[1] = (short)(this._captorData[1] + this._x);
        this._captorData[2] = (short)(this._captorData[2] + this._y);
        this._captorData[3] = (short)(this._captorData[3] + this._y);
    }

    public final int GetTriggerKind() {
        return this._eventSpringKind;
    }

    public final byte[] getParameter() {
        return this._parameter;
    }

    public final void setUpdateFlag() {
        this._updateFlag = true;
    }

    public final int getId() {
        return this._id;
    }

    public final int getPosX() {
        return this._x;
    }

    public final int getPosY() {
        return this._y;
    }

    public final int getActionIndex() {
        return this._actorData[0];
    }

    public final boolean isFlipX() {
        return this._actorData[3] == 1;
    }

    public final boolean isFlipY() {
        return this._actorData[4] == 1;
    }

    public final int getPicId() {
        return this._picId;
    }

    public static final UnitData produceUnitData(DataInputStream dataInputStream) {
        try {
            int n;
            UnitData unitData = new UnitData();
            unitData._id = dataInputStream.readInt();
            unitData._x = dataInputStream.readShort();
            unitData._y = dataInputStream.readShort();
            unitData._picId = dataInputStream.readShort();
            if (unitData._picId >= 0) {
                unitData._actorData = new byte[5];
                dataInputStream.read(unitData._actorData);
                unitData._checkFlag = new boolean[3];
                unitData._checkValue = new byte[3];
                n = 0;
                while (n < 3) {
                    unitData._checkFlag[n] = dataInputStream.readBoolean();
                    if (unitData._checkFlag[n]) {
                        unitData._checkValue[n] = dataInputStream.readByte();
                    }
                    ++n;
                }
            } else {
                unitData._captorData = new short[4];
                n = 0;
                while (n < 4) {
                    unitData._captorData[n] = dataInputStream.readShort();
                    ++n;
                }
                unitData.calculateCaptorArea();
            }
            unitData._eventSpringKind = dataInputStream.readByte();
            if (dataInputStream.readBoolean()) {
                unitData._parameter = new byte[6];
                dataInputStream.read(unitData._parameter);
            }
            n = dataInputStream.readByte();
            unitData._scriptData = new ScriptUnit[n];
            int n2 = 0;
            while (n2 < n) {
                unitData._scriptData[n2] = ScriptUnit.produceScriptUnit(dataInputStream);
                ++n2;
            }
            unitData.setUpdateFlag();
            return unitData;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private UnitData() {
    }
}

