/*
 * Decompiled with CFR 0.152.
 */
package rpg.basic.scene;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import module.ekernel.animation.Animation;
import module.ekernel.container.GamePage;
import module.ekernel.map.mutilayers.Map;
import module.utils.R;
import pzg.extend.game.CaptorValid;
import pzg.extend.game.GameInterface;
import rpg.basic.actor.Actor;
import rpg.basic.actor.CreatActorInterface;
import rpg.basic.gameUtil.MessageBoxHandler;
import rpg.basic.scene.UnitData;

public class Scene
implements MessageBoxHandler,
CreatActorInterface {
    CreatActorInterface _creatInstance;
    public static Scene _scene = null;
    public static DataInputStream _is = null;
    public static int produceProcess = 0;
    public static Hashtable _activeContainer = new Hashtable(120);
    public int _dynamicIdCounter = 0xFFFFFFF;
    public Actor[][] _actorPool;
    public Actor[] _executeInsts;
    public int _executeNum;
    public int[] _newIds;
    public int[][] _typesLoad;
    public int _sectorNum;
    public int _sectorWidth;
    public int _sectorHeight;
    public int _curSector;
    public int[][] _sectorCaptorId;
    public int[][] _sectorActorId;
    public int _types = 0;
    public static int _curSceneID;
    public static int _nextSceneID;
    public int _state;
    public static int _globalActorNum;
    public static int[] _globalActorId;
    public static GamePage _gamePage;
    public static Map _map;
    public Actor _focus;
    public Actor _mainActor;
    public Actor _followActor;
    public int _camx;
    public int _camy;
    public int _camw;
    public int _camh;
    public int _camvx;
    public int _camvy;
    public int _lockCx;
    public int _lockCy;
    public boolean _isLock;
    public int _shakeTime;
    public int _shakeRange;
    public int _cameraOffsetX;
    public int _cameraOffsetY;
    Actor _trapActor;
    public boolean _isValidInsts;
    public static Hashtable _captorContent;
    public UnitData[] _unitData;

    public Scene() {
        _curSceneID = -1;
        this._actorPool = new Actor[100][];
        this._typesLoad = new int[100][2];
        this._newIds = new int[40];
        this._executeInsts = new Actor[60];
        this._camw = 327680;
        this._camh = 245760;
        this._creatInstance = this;
    }

    public void updateCaptors() {
        if (this._sectorCaptorId[this._curSector] == null) {
            return;
        }
        int[] nArray = this._sectorCaptorId[this._curSector];
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            this.checkCaptor(nArray[n2]);
            ++n2;
        }
    }

    public void updateZone() {
        Actor actor = this.getFocusActor();
        this.updateCamera(actor, this.getWidth(), this.getHeight());
        if (this.isOpenShake()) {
            this.updateCameraOffset();
        }
        this.updateSector();
    }

    public void updateSector() {
        int n;
        int n2 = this._camx >> 10;
        int n3 = this._camy >> 10;
        _map.setPositionInMap(n2, n3);
        int n4 = n3 / this._sectorHeight * (_map.getMapWidth() / this._sectorWidth) + n2 / this._sectorWidth;
        if (n4 == this._curSector) {
            return;
        }
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        while (this._sectorActorId[this._curSector] != null && this._sectorActorId[n4] != null && n5 < this._sectorActorId[this._curSector].length && n6 < this._sectorActorId[n4].length) {
            n = this._sectorActorId[this._curSector][n5];
            int n8 = this._sectorActorId[n4][n6];
            if (n < n8) {
                this.disposeActor(n);
                ++n5;
                continue;
            }
            if (n > n8) {
                this._newIds[n7++] = this._sectorActorId[n4][n6++];
                continue;
            }
            ++n5;
            ++n6;
        }
        while (this._sectorActorId[this._curSector] != null && n5 < this._sectorActorId[this._curSector].length) {
            this.disposeActor(this._sectorActorId[this._curSector][n5]);
            ++n5;
        }
        while (this._sectorActorId[n4] != null && n6 < this._sectorActorId[n4].length) {
            if (this._sectorActorId[n4][n6] != 0) {
                this._newIds[n7++] = this._sectorActorId[n4][n6];
            }
            ++n6;
        }
        n = 0;
        while (n < n7) {
            this.fetchActorFromPool(-1, this._newIds[n]);
            ++n;
        }
        this._curSector = n4;
    }

    public Actor fetchActorFromPool(int n, int n2) {
        Actor actor = null;
        UnitData unitData = null;
        Actor[][] actorArray = this._actorPool;
        if (n < 0) {
            unitData = this.getUnitData(n2);
            if (unitData == null) {
                return null;
            }
            n = unitData.getPicId();
        }
        try {
            int n3 = actorArray[n].length;
            int n4 = 0;
            while (n4 < n3) {
                actor = actorArray[n][n4];
                if (!actor._active) break;
                ++n4;
            }
            if (n4 < n3) {
                if (n2 >= 0) {
                    if (unitData.isValid()) {
                        unitData.setInvalid();
                        actor.activate(this, n2);
                        actor.init(unitData);
                        this.addActorToActiveContainer(actor, n2);
                        return actor;
                    }
                } else if (n2 == -1) {
                    n2 = this.getDynamicID();
                    actor.activate(this, n2);
                    actor.resetData();
                    this.addActorToActiveContainer(actor, n2);
                    return actor;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return null;
    }

    public Actor fetchActorFromPool_Sms(int n, int n2) {
        Actor actor = null;
        UnitData unitData = null;
        Actor[][] actorArray = this._actorPool;
        if (n < 0) {
            unitData = this.getUnitData(n2);
            if (unitData == null) {
                return null;
            }
            n = unitData.getPicId();
        }
        try {
            int n3 = actorArray[n].length;
            int n4 = 0;
            while (n4 < n3) {
                actor = actorArray[n][n4];
                if (!actor._active) break;
                ++n4;
            }
            if (actor.getAniInx() == 0) {
                return null;
            }
            if (n4 < n3) {
                if (n2 >= 0) {
                    if (unitData.isValid()) {
                        unitData.setInvalid();
                        actor.activate(this, n2);
                        actor.init(unitData);
                        this.addActorToActiveContainer(actor, n2);
                        return actor;
                    }
                } else if (n2 == -1) {
                    n2 = this.getDynamicID();
                    actor.activate(this, n2);
                    actor.resetData();
                    this.addActorToActiveContainer(actor, n2);
                    return actor;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return null;
    }

    public void checkCaptor(int n) {
        UnitData unitData = this.getUnitData(n);
        if (unitData == null) {
            return;
        }
        if (unitData.isValid() && this._focus.collide(unitData)) {
            this.triggerCaptor(unitData);
        }
    }

    public void triggerCaptor(UnitData unitData) {
    }

    public void lockCamera(int n, int n2) {
        this._lockCx = n;
        this._lockCy = n2;
        this._isLock = true;
    }

    public void unlockCamera() {
        this._isLock = false;
    }

    public void initCamera(Actor actor, int n, int n2) {
        this._isLock = false;
        this._camx = actor.getXDirLocation(this._camw);
        this._camy = actor.getYDirLocation(this._camh);
        this._camvy = 0;
        this._camvx = 0;
        this.validityCheckCamera(n, n2);
    }

    public void updateCamera(Actor actor, int n, int n2) {
        int n3;
        int n4;
        if (this._isLock) {
            n4 = this._lockCx;
            n3 = this._lockCy;
        } else {
            n4 = actor.getXDirLocation(this._camw);
            n3 = actor.getYDirLocation(this._camh);
        }
        this._camvy = 0;
        this._camvx = 0;
        if (this._camx < n4) {
            if (n4 - this._camx > 10240) {
                this._camvx = 10240;
            } else {
                this._camx = n4;
            }
        } else if (this._camx > n4) {
            if (this._camx - n4 > 10240) {
                this._camvx = -10240;
            } else {
                this._camx = n4;
            }
        }
        if (this._camy < n3) {
            if (n3 - this._camy > 10240) {
                this._camvy = 10240;
            } else {
                this._camy = n3;
            }
        } else if (this._camy > n3) {
            if (this._camy - n3 > 10240) {
                this._camvy = -10240;
            } else {
                this._camy = n3;
            }
        }
        this._camx += this._camvx;
        this._camy += this._camvy;
        this.validityCheckCamera(n, n2);
    }

    public void validityCheckCamera(int n, int n2) {
        int n3 = this._camx >> 10;
        int n4 = this._camy >> 10;
        n3 = Math.min(n3, n - 320 - 1);
        n3 = Math.max(n3, 0);
        n4 = Math.min(n4, n2 - 240 - 1);
        n4 = Math.max(n4, 0);
        this._camx = n3 << 10;
        this._camy = n4 << 10;
    }

    public void startUpShake(int n, int n2) {
        this._shakeRange = n;
        this._shakeTime = n2;
    }

    public void clearShake() {
        this._shakeTime = -1;
        this._cameraOffsetX = 0;
        this._cameraOffsetY = 0;
    }

    public void updateCameraOffset() {
    }

    public boolean isOpenShake() {
        return this._shakeTime != -1;
    }

    public void dispose() {
        int n;
        _map.dispose();
        _map = null;
        this.clearActiveContainer();
        int n2 = 0;
        while (n2 < this._executeInsts.length) {
            this._executeInsts[n2] = null;
            ++n2;
        }
        this._executeInsts = null;
        int n3 = 0;
        while (n3 < this._actorPool.length) {
            if (this._actorPool[n3] != null) {
                n = 0;
                while (n < this._actorPool[n3].length) {
                    this._actorPool[n3][n] = null;
                    ++n;
                }
                this._actorPool[n3] = null;
            }
            ++n3;
        }
        n = 0;
        while (n < this._sectorCaptorId.length) {
            this._sectorCaptorId[n] = null;
            ++n;
        }
        this._sectorCaptorId = null;
        int n4 = 0;
        while (n4 < this._sectorActorId.length) {
            this._sectorActorId[n4] = null;
            ++n4;
        }
        this._sectorActorId = null;
        _globalActorId = null;
        System.gc();
    }

    public Actor getFocusActor() {
        return this._focus;
    }

    public Actor getMainActor() {
        return this._mainActor;
    }

    public Actor getFollowActor() {
        return this._followActor;
    }

    public void setMainActor(Actor actor) {
        this._mainActor = actor;
    }

    public void setFollowActor(Actor actor) {
        this._followActor = actor;
    }

    public void setTrapActor(Actor actor) {
        this._trapActor = actor;
    }

    public int getWidth() {
        return _map.getMapWidth();
    }

    public int getHeight() {
        return _map.getMapHeight();
    }

    public Map getBackground() {
        return _map;
    }

    public void setFocusActor(Actor actor) {
        this._focus = actor;
    }

    public void resetDynamicCounter() {
        this._dynamicIdCounter = 0xFFFFFFF;
    }

    public int getDynamicID() {
        return ++this._dynamicIdCounter;
    }

    public boolean isDynamicID(int n) {
        return n >= 0xFFFFFFF;
    }

    public void addActorToActiveContainer(Actor actor, int n) {
        this.setInstsInvalid();
        _activeContainer.put(String.valueOf(n), actor);
    }

    public void setInstsInvalid() {
        this._isValidInsts = false;
    }

    public void updateActors() {
        this.updateInsts();
        Actor[] actorArray = this._executeInsts;
        int n = this._executeNum;
        int n2 = 0;
        while (n2 < n) {
            actorArray[n2].step();
            actorArray[n2].ai();
            ++n2;
        }
    }

    public void updateInsts() {
        if (this._isValidInsts) {
            return;
        }
        this._isValidInsts = true;
        Actor[] actorArray = this._executeInsts;
        int n = 0;
        Enumeration enumeration = _activeContainer.elements();
        while (enumeration.hasMoreElements()) {
            Actor actor = (Actor)enumeration.nextElement();
            if (!actor.isValid()) continue;
            actorArray[n++] = actor;
        }
        this._executeNum = n;
    }

    public void disActiveInst(int n) {
        this.setInstsInvalid();
        Actor actor = (Actor)_activeContainer.remove(String.valueOf(n));
        if (actor != null) {
            actor._active = false;
        }
        if (!this.isDynamicID(n)) {
            UnitData unitData = this.getUnitData(n);
            unitData.setValid();
        }
    }

    public void disLifeInst(int n) {
        this.setInstsInvalid();
        Actor actor = (Actor)_activeContainer.remove(String.valueOf(n));
        if (actor != null) {
            actor._active = false;
        }
    }

    public Actor getActiveActor(int n) {
        Actor actor = n >= 0xFFFFFFF ? this.getActorByComplex(n) : (Actor)_activeContainer.get(String.valueOf(n));
        return actor;
    }

    public Actor getActorByComplex(int n) {
        n -= 0xFFFFFFF;
        Enumeration enumeration = _activeContainer.elements();
        while (enumeration.hasMoreElements()) {
            Actor actor = (Actor)enumeration.nextElement();
            if (!actor.isValid() || actor.getAniInx() != n) continue;
            return actor;
        }
        return null;
    }

    public Actor[] getActiveInsts(int[] nArray) {
        nArray[0] = this._executeNum;
        return this._executeInsts;
    }

    public void disposeActor(int n) {
        Actor actor = (Actor)_activeContainer.get(String.valueOf(n));
        if (actor != null) {
            actor.disActive();
        }
    }

    public void clearActiveContainer() {
        _activeContainer.clear();
    }

    public boolean produceScene(GamePage gamePage) {
        try {
            switch (produceProcess) {
                case 0: {
                    Scene.produceStream(gamePage);
                    produceProcess = 1;
                    break;
                }
                case 1: {
                    this.produceMap();
                    produceProcess = 2;
                    break;
                }
                case 2: {
                    this.produceSector();
                    produceProcess = 3;
                    break;
                }
                case 3: {
                    this.produceUnit();
                    produceProcess = 4;
                    break;
                }
                case 4: {
                    this.produceActor();
                    this.produceNeedActor();
                    produceProcess = 5;
                    break;
                }
                case 5: {
                    produceProcess = 0;
                    this.produceInitParameter();
                    return true;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        return false;
    }

    public static void produceStream(GamePage gamePage) {
        _curSceneID = _nextSceneID;
        if (GameInterface._isZuoBi && !GameInterface._closePartInfo && GameInterface._paraValue[0] >= 0) {
            _curSceneID = GameInterface._paraValue[0];
            GameInterface._closePartInfo = true;
        }
        _map = new Map(320, 240);
        _gamePage = gamePage;
        int n = _curSceneID / 10;
        int n2 = _curSceneID % 10;
        try {
            _is = R.openDataInputStream("/res/scene" + n + ".bin", n2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void produceMap() throws IOException {
        this._sectorWidth = _is.readShort();
        this._sectorHeight = _is.readShort();
        String string = _is.readUTF();
        int n = _is.read();
        byte by = _is.readByte();
        byte by2 = _is.readByte();
        DataInputStream dataInputStream = R.openDataInputStream("/res/m" + by2 + ".tlmbin", -1);
        _map.loadData(dataInputStream);
        dataInputStream.close();
    }

    public void saveCaptorFromPool(int n, CaptorValid captorValid) {
        _captorContent.put(new Integer(n), captorValid);
    }

    public CaptorValid checkIsSave() {
        CaptorValid captorValid = null;
        captorValid = (CaptorValid)_captorContent.get(new Integer(_curSceneID));
        if (captorValid != null) {
            return captorValid;
        }
        return null;
    }

    public static void saveCaptorAction(DataOutputStream dataOutputStream) {
        try {
            if (_captorContent == null) {
                dataOutputStream.writeByte(0);
                return;
            }
            dataOutputStream.writeByte(1);
            int n = _captorContent.size();
            dataOutputStream.writeByte(n);
            Enumeration enumeration = _captorContent.keys();
            while (enumeration.hasMoreElements()) {
                Integer n2 = (Integer)enumeration.nextElement();
                dataOutputStream.writeByte(n2.byteValue());
                CaptorValid captorValid = (CaptorValid)_captorContent.get(n2);
                dataOutputStream.writeInt(captorValid._id[0]);
                dataOutputStream.writeInt(captorValid._id[1]);
                dataOutputStream.writeInt(captorValid._id[2]);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void loadCptorAction(DataInputStream dataInputStream) {
        try {
            byte by = dataInputStream.readByte();
            if (by == 0) {
                return;
            }
            if (_captorContent == null) {
                _captorContent = new Hashtable();
            } else {
                _captorContent.clear();
            }
            int n = dataInputStream.readByte();
            int n2 = 0;
            while (n2 < n) {
                byte by2 = dataInputStream.readByte();
                CaptorValid captorValid = new CaptorValid();
                int n3 = 0;
                while (n3 < 3) {
                    captorValid.add(n3, dataInputStream.readInt());
                    ++n3;
                }
                _captorContent.put(new Integer(by2), captorValid);
                ++n2;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void produceSector() throws IOException {
        int n;
        int n2;
        this._types = _is.read();
        int n3 = 0;
        while (n3 < this._types) {
            this._typesLoad[n3][0] = _is.readByte();
            if (this._typesLoad[n3][0] < 0) {
                int[] nArray = this._typesLoad[n3];
                nArray[0] = nArray[0] + 256;
            }
            byte by = _is.readByte();
            this._typesLoad[n3][1] = _is.readByte() + by;
            ++n3;
        }
        this._executeInsts = new Actor[60];
        this._sectorNum = _map.getMapHeight() / this._sectorHeight * (_map.getMapWidth() / this._sectorWidth);
        this._sectorCaptorId = new int[this._sectorNum][];
        n3 = 0;
        while (n3 < this._sectorNum) {
            n2 = _is.readByte();
            if (n2 > 0) {
                this._sectorCaptorId[n3] = new int[n2];
                n = 0;
                while (n < n2) {
                    this._sectorCaptorId[n3][n] = _is.readInt();
                    if (this.checkIsSave() != null) {
                        int n4 = 0;
                        while (n4 < 3) {
                            if (this.checkIsSave()._id[n4] == this._sectorCaptorId[n3][n]) {
                                this._sectorCaptorId[n3][n] = -1;
                            }
                            ++n4;
                        }
                    }
                    ++n;
                }
            }
            ++n3;
        }
        _globalActorNum = _is.readByte();
        _globalActorId = new int[_globalActorNum];
        n3 = 0;
        while (n3 < _globalActorNum) {
            Scene._globalActorId[n3] = _is.readInt();
            ++n3;
        }
        this._sectorActorId = new int[this._sectorNum][];
        n3 = 0;
        while (n3 < this._sectorNum) {
            n2 = _is.read();
            if (n2 > 0) {
                this._sectorActorId[n3] = new int[n2];
                n = 0;
                while (n < n2) {
                    this._sectorActorId[n3][n] = _is.readInt();
                    ++n;
                }
            }
            ++n3;
        }
    }

    public void produceUnit() throws IOException {
        this.loadUnitData(_is);
        _is.close();
        _is = null;
    }

    public void produceActor() {
        int n = 0;
        while (n < this._types) {
            Animation.load("/res/ani.bin", this._typesLoad[n][0], 2);
            this.createActorPool(this._typesLoad[n][0], this._typesLoad[n][1]);
            ++n;
        }
    }

    public void produceInitParameter() {
    }

    public void createActorPool(int n, int n2) {
        if (n < 0) {
            n += 256;
        }
        if (this._actorPool[n] != null) {
            return;
        }
        if (n2 == 50) {
            n2 -= 40;
        }
        this._actorPool[n] = new Actor[n2];
        int n3 = 0;
        while (n3 < n2) {
            this._actorPool[n][n3] = this._creatInstance.creatActor(n, Animation.getAnimation(n));
            ++n3;
        }
    }

    public void produceNeedActor() {
    }

    public void loadUnitData(DataInputStream dataInputStream) {
        try {
            int n = _is.readByte();
            this._unitData = new UnitData[n];
            int n2 = 0;
            while (n2 < n) {
                this._unitData[n2] = UnitData.produceUnitData(dataInputStream);
                ++n2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public UnitData getUnitData(int n) {
        UnitData[] unitDataArray = this._unitData;
        int n2 = 0;
        int n3 = unitDataArray.length - 1;
        while (n2 <= n3) {
            int n4 = n2 + n3 >> 1;
            int n5 = unitDataArray[n4].getId();
            if (n5 == n) {
                return unitDataArray[n4];
            }
            if (n5 < n) {
                n2 = ++n4;
                continue;
            }
            n3 = --n4;
        }
        return null;
    }

    public void finishHandle() {
    }

    public void save(DataOutputStream dataOutputStream) {
        try {
            dataOutputStream.writeByte(_curSceneID);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void load(DataInputStream dataInputStream) {
        try {
            byte by = dataInputStream.readByte();
            _nextSceneID = by;
            _curSceneID = by;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public Actor creatActor(int n, Animation animation) {
        return null;
    }

    static {
        _captorContent = new Hashtable(30);
    }
}

