/*
 * Decompiled with CFR 0.152.
 */
package rpg.basic.gameUtil;

import java.util.Random;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import module.sound.EngineSound;

public final class Function {
    private static Random rand = new Random();
    public static final Font C_GAME_FONT = Font.getFont((int)0, (int)0, (int)8);
    public static final Font BIG_C_GAME_FONT = Font.getFont((int)0, (int)0, (int)16);
    public static final int C_WORD_W = C_GAME_FONT.charWidth('\u4ed9');
    public static final int BIG_C_WORD_W = BIG_C_GAME_FONT.charWidth('\u4ed9');
    public static final int C_WORD_H = C_GAME_FONT.getHeight() + 1;
    public static int DRAW_RGB_NUMBER = 0;
    private static final int[] SIN_ANGLE = new int[]{0, 17, 35, 53, 71, 89, 107, 124, 142, 160, 177, 195, 212, 230, 247, 265, 282, 299, 316, 333, 350, 366, 383, 400, 416, 432, 448, 464, 480, 496, 511, 527, 542, 557, 572, 587, 601, 616, 630, 644, 658, 671, 685, 698, 711, 724, 736, 748, 760, 772, 784, 795, 806, 817, 828, 838, 848, 858, 868, 877, 886, 895, 904, 912, 920, 928, 935, 942, 949, 955, 962, 968, 973, 979, 984, 989, 993, 997, 1001, 1005, 1008, 1011, 1014, 1016, 1018, 1020, 1021, 1022, 1023, 1023, 1024};
    private static EngineSound _sound;
    private static boolean _isSound;
    private static int _curSoundId;
    public static boolean _isContinue;
    private static StringBuffer info;
    public static int _speed;
    static int time;

    public static void fillScreen(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        graphics.setClip(n, n2, n3, n4);
        graphics.setColor(n5);
        graphics.fillRect(n, n2, n3, n4);
    }

    public static final int Random(int n, boolean bl) {
        int n2 = rand.nextInt();
        if (bl) {
            n2 &= Integer.MAX_VALUE;
        }
        return n2 % n;
    }

    public static final int sin(int n) {
        if ((n %= 360) < 0) {
            n = 360 + n;
        }
        if (n <= 90) {
            return SIN_ANGLE[n];
        }
        if (n <= 180) {
            return SIN_ANGLE[180 - n];
        }
        if (n <= 270) {
            return -SIN_ANGLE[n - 180];
        }
        return -SIN_ANGLE[360 - n];
    }

    public static final int cos(int n) {
        return Function.sin(90 + n);
    }

    private Function() {
    }

    public static final int getSoundKind() {
        return 7;
    }

    public static final void loadSound(String[] stringArray) {
        _sound = EngineSound.createEngineSound(Function.getSoundKind(), stringArray);
    }

    public static final boolean isSound() {
        return _isSound;
    }

    public static final void startupSound(boolean bl, int n) {
        _isSound = bl;
        _sound.enablePlaySound(bl, n);
    }

    public static final void changeSound(int n) {
        _isSound = !_isSound;
        _sound.enablePlaySound(_isSound, n);
        Function.changeSoundState(_curSoundId, -1);
    }

    public static final void changeSoundState(int n, int n2) {
        _curSoundId = n;
        if (_isSound) {
            Function.playSound(n, n2);
        } else {
            Function.stopSound();
        }
    }

    public static final void playSound(int n, int n2) {
        _sound.stopSound();
        if (n >= 0) {
            _isContinue = false;
            _sound.playSound(n, n2);
        }
    }

    public static final void stopSound() {
        _sound.stopSound();
    }

    public static final void setSoundValue(int n, int n2) {
        _sound.changeSoundVolume(n);
        if (n <= 0 && Function.isSound() || n > 0 && !Function.isSound()) {
            Function.changeSound(n2);
        }
    }

    public static final void continuePlaySound() {
        Function.changeSoundState(_curSoundId, -1);
    }

    public static boolean drawHelpAboutString(Graphics graphics, String string, int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = 0;
        int n8 = 0;
        do {
            n8 = string.indexOf(13, n7);
            if (--n < 0) {
                --n2;
                if (n8 == -1) {
                    graphics.drawString(string.substring(n7), n3, n4, n6);
                } else {
                    graphics.drawString(string.substring(n7, n8), n3, n4, n6);
                }
                n4 += n5;
            }
            n7 = n8 + 2;
        } while (n8 >= 0 && n2 > 0);
        return n8 < 0;
    }

    public static String[] subString(String string, int n) {
        int n2 = 0;
        n2 = string.length() % n == 0 ? string.length() / n : string.length() / n + 1;
        String[] stringArray = new String[n2];
        int n3 = 0;
        while (n3 < n2) {
            stringArray[n3] = (n3 + 1) * n > string.length() ? string.substring(n3 * n, string.length()) : string.substring(n3 * n, (n3 + 1) * n);
            ++n3;
        }
        return stringArray;
    }

    public static final void draw3DString(Graphics graphics, String string, int n, int n2, int n3, int n4, int n5) {
        graphics.setClip(0, 0, 320, 240);
        graphics.setColor(n4);
        graphics.drawString(string, n, n2 - 1, n3);
        graphics.drawString(string, n - 1, n2 - 1, n3);
        graphics.drawString(string, n - 1, n2, n3);
        graphics.drawString(string, n - 1, n2 + 1, n3);
        graphics.drawString(string, n, n2 + 1, n3);
        graphics.drawString(string, n + 1, n2 + 1, n3);
        graphics.drawString(string, n + 1, n2, n3);
        graphics.drawString(string, n + 1, n2 - 1, n3);
        graphics.setColor(n5);
        graphics.drawString(string, n, n2, n3);
    }

    public static boolean drawRollStrings(Graphics graphics, String string, int n, int n2, int n3, int n4) {
        int n5;
        int n6 = C_WORD_H + 1;
        int n7 = C_WORD_W;
        int n8 = (320 - (n << 1)) / n7;
        String[] stringArray = Function.subString(string, n8);
        int n9 = stringArray.length;
        if (n9 <= (n5 = n3 / n6)) {
            _speed = n3;
        }
        graphics.setClip(n - 5, n2, 320 - n * 2 + 10, n3);
        int n10 = 0;
        while (n10 < n9) {
            graphics.setColor(n4);
            graphics.drawString(stringArray[n10], n, n2 + n3 + n10 * n6 - _speed, 0x10 | 4);
            ++n10;
        }
        graphics.setClip(0, 0, 320, 240);
        if (n9 > n5) {
            if (time % 3 == 0) {
                ++_speed;
                time = 0;
            }
            if (_speed > n6 * n9 + n3) {
                _speed = 1;
                return true;
            }
            time += 3;
        }
        return false;
    }

    public static boolean drawRollStringAnalyze(Graphics graphics, String string, int n, int n2, int n3, int n4) {
        int n5 = C_WORD_H + 1;
        int n6 = C_WORD_W;
        int n7 = (320 - (n << 1)) / n6;
        String[] stringArray = Function.subString(string, n7);
        int n8 = stringArray.length;
        graphics.setClip(n - 5, n2, 320 - n * 2 + 10, n3);
        int n9 = 0;
        while (n9 < n8) {
            graphics.setColor(n4);
            graphics.drawString(stringArray[n9], n, n2 + n3 + n9 * n5 - _speed, 0x10 | 4);
            ++n9;
        }
        graphics.setClip(0, 0, 320, 240);
        if (time % 3 == 0) {
            ++_speed;
            time = 0;
        }
        if (_speed > n5 * n8 + n3) {
            _speed = 1;
            return true;
        }
        time += 3;
        return false;
    }

    static {
        _curSoundId = 0;
        info = new StringBuffer();
        _speed = C_WORD_H;
        time = 0;
    }
}

