/*
 * Decompiled with CFR 0.152.
 */
package rpg.basic.actor;

import javax.microedition.lcdui.Graphics;
import module.ekernel.animation.Animation;
import module.ekernel.input.KeyHandler;
import module.ekernel.map.mutilayers.Map;
import pzg.basic.puzzle.AnalyzePropsList;
import pzg.extend.game.PzgScene;
import pzg.extend.gameUtil.ActorInfo;
import pzg.extend.gameUtil.SceneActorInfo;
import rpg.basic.gameUtil.Function;
import rpg.basic.gameUtil.Searcher;
import rpg.basic.scene.Scene;
import rpg.basic.scene.UnitData;

public class Actor {
    public boolean _active;
    protected boolean _isFlip;
    protected static boolean _enableAI = true;
    protected boolean _validFlag;
    public boolean _loopAction;
    protected boolean _actionEnd;
    public int _loopNumber;
    protected int _type;
    protected int _actionNum;
    public int _curAction;
    protected int _action;
    protected int _flipFlag;
    protected int _curFrame;
    protected short _actFrmNum;
    public int _l;
    public int _r;
    public int _t;
    public int _b;
    protected int _vl;
    protected int _vr;
    protected int _vt;
    protected int _vb;
    protected int _al;
    protected int _ar;
    protected int _at;
    protected int _ab;
    public int _id;
    public int _x;
    public int _y;
    public int _vx;
    public int _vy;
    public int _avx;
    public int _avy;
    public int _palNo;
    public int _trace;
    public int _dx;
    public int _dy;
    public int _ox;
    public int _oy;
    protected Animation _anim;
    protected Map _map;
    protected Scene _scene;
    protected UnitData _data;
    private boolean arriveDesFlagForMove;
    private int _autoPathOffsetX;
    private int _autoPathOffsetY;
    protected byte[][] path;
    private int pathIndex;
    private boolean arriveDesFlag;
    private int destinationX;
    private int destinationY;
    int[] _result = new int[1];
    private int _current;
    private int _sum;
    private int _contortStyle;
    private boolean _openContort;
    private boolean _contortEnd;
    private int _disAction;
    public boolean _openSpecialDisActor = false;
    public int _offsetX;
    public int _maxOffsetX;
    public int _offsetY;
    public int _maxOffsetY;
    private int _tempActorX;
    private int _tempDistanceX;
    private ActorInfo _actorInfo;

    public Actor(int n, Animation animation) {
        this._type = n;
        this._anim = animation;
        this._actionNum = animation.getActionNum();
        this._active = false;
    }

    public boolean isActor() {
        int n = this._isFlip ? this._curAction & 0xFF : this._curAction;
        return this._type <= 23 && n != Animation.getAnimation(this._type).getActionNum() - 1;
    }

    public boolean isXieActor() {
        int n = this._isFlip ? this._curAction & 0xFF : this._curAction;
        switch (this._type) {
            case 3: {
                return n == 0;
            }
            case 11: {
                return n == 0;
            }
            case 12: {
                return n == 0;
            }
            case 14: {
                return n == 0;
            }
            case 15: {
                return n == 0;
            }
            case 16: {
                return n == 6;
            }
            case 17: {
                return n == 0;
            }
            case 18: {
                return n == 1;
            }
            case 19: {
                return n == 0;
            }
            case 20: {
                return n == 0;
            }
            case 22: {
                return n == 0;
            }
            case 23: {
                return n == 0;
            }
        }
        return false;
    }

    public boolean isSitDownAcotr() {
        int n = this._isFlip ? this._curAction & 0xFF : this._curAction;
        switch (this._type) {
            case 23: {
                return n == 1 || n == 2;
            }
            case 22: {
                return n == 1 || n == 2;
            }
            case 21: {
                return n == 0;
            }
            case 20: {
                return n == 1;
            }
            case 13: {
                return n == 1;
            }
            case 3: {
                return n == 1;
            }
            case 0: {
                return n == 10;
            }
        }
        return false;
    }

    public int getAniInx() {
        return this._type;
    }

    public boolean init(UnitData unitData) {
        this._data = unitData;
        this.resetData();
        this._x = unitData.getPosX() << 10;
        this._y = unitData.getPosY() << 10;
        this._ox = this._x;
        this._oy = this._y;
        this._palNo = 0;
        int n = unitData.getActionIndex();
        if (unitData.isFlipX()) {
            n |= Integer.MIN_VALUE;
        }
        if (unitData.isFlipY()) {
            n |= 0x40000000;
        }
        this._validFlag = unitData.isValidActor();
        this.changeAction(n);
        ActorInfo actorInfo = SceneActorInfo.checkIsHaveCurActor(Scene._curSceneID, this._id);
        if (actorInfo != null) {
            this.changeAction(actorInfo.getCurAction());
            this._x = actorInfo.getCurX();
            this._y = actorInfo.getCurY();
        }
        return true;
    }

    public void resetData() {
        this._validFlag = true;
        this._vy = 0;
        this._vx = 0;
        this._loopAction = true;
    }

    public void init(int n, int n2, int n3) {
        this._x = n;
        this._y = n2;
        this._ox = n;
        this._oy = n2;
        this.changeAction(n3);
    }

    public void enableAI(boolean bl) {
        _enableAI = bl;
        this.changeToWait();
    }

    public Actor activate(Scene scene, int n) {
        this._id = n;
        this._active = true;
        this._scene = scene;
        this._map = Scene._map;
        return this;
    }

    public void disActive() {
        this._data = null;
        this._scene.disActiveInst(this._id);
    }

    public void disLife() {
        this._data = null;
        this._scene.disLifeInst(this._id);
    }

    public void changeAction(int n) {
        this._curAction = n;
        n &= 0xFFFF;
        if ((this._curAction & Integer.MIN_VALUE) == 0) {
            if (this._anim._isHaveCbox) {
                this._l = this._anim._l[n];
                this._r = this._anim._r[n];
            }
            if (this._anim._isHaveAbox) {
                this._al = this._anim._al[n];
                this._ar = this._anim._ar[n];
            }
            this._vl = this._anim._vl;
            this._vr = this._anim._vr;
        } else {
            if (this._anim._isHaveCbox) {
                this._l = -this._anim._r[n];
                this._r = -this._anim._l[n];
            }
            if (this._anim._isHaveAbox) {
                this._al = -this._anim._ar[n];
                this._ar = -this._anim._al[n];
            }
            this._vl = -this._anim._vr;
            this._vr = -this._anim._vl;
        }
        if ((this._curAction & 0x40000000) == 0) {
            if (this._anim._isHaveCbox) {
                this._t = this._anim._t[n];
                this._b = this._anim._b[n];
            }
            if (this._anim._isHaveAbox) {
                this._at = this._anim._at[n];
                this._ab = this._anim._ab[n];
            }
            this._vt = this._anim._vt;
            this._vb = this._anim._vb;
        } else {
            if (this._anim._isHaveCbox) {
                this._t = -this._anim._b[n];
                this._b = -this._anim._t[n];
            }
            if (this._anim._isHaveAbox) {
                this._at = -this._anim._ab[n];
                this._ab = -this._anim._at[n];
            }
            this._vt = -this._anim._vb;
            this._vb = -this._anim._vt;
        }
        this._actFrmNum = this._anim.getActFrmNum(n);
        this._curFrame = 0;
        this._action = n;
        this._actionEnd = false;
        this._flipFlag = this._curAction & 0xF0000000;
        this._isFlip = (this._curAction & 0xF0000000) != 0;
    }

    public final void nextFrame() {
        ++this._curFrame;
        if (this._curFrame >= this._actFrmNum) {
            if (this._loopAction) {
                this._curFrame = 0;
                this._actionEnd = false;
            } else if (--this._loopNumber > 0) {
                this._curFrame = 0;
                this._actionEnd = false;
            } else {
                --this._curFrame;
                if (this._id > 0xFFFFFFF) {
                    this.disActive();
                }
            }
        }
        if (this._curFrame == this._actFrmNum - 1) {
            this._actionEnd = true;
        }
    }

    public void step() {
        if (this.isExecuteStep()) {
            this.nextFrame();
            this._vx += this._avx;
            this._vy += this._avy;
            this._x += this._vx;
            this._y += this._vy;
        }
    }

    public void ai() {
    }

    public final boolean isValid() {
        return this._validFlag;
    }

    public final boolean isExecuteAI() {
        return !this.hasAutoPassAI() && _enableAI;
    }

    public final boolean isExecuteStep() {
        return !this.hasAutoPassStep() && !this.hasAutoMoveStep();
    }

    /*
     * Unable to fully structure code
     */
    public void draw(Graphics var1_1, int var2_2, int var3_3, int var4_4, int var5_5) {
        block11: {
            block13: {
                block12: {
                    var6_6 = (this._x >> 10) - var2_2 - var4_4;
                    var7_7 = (this._y >> 10) - var3_3 - var5_5;
                    if (var6_6 + this._vr < 0 || var6_6 + this._vl > 320) {
                        return;
                    }
                    if (var7_7 + this._vb < 0 || var7_7 + this._vt > 240) {
                        return;
                    }
                    if (!this.isActor() || this.isSitDownAcotr() || this.isXieActor()) break block11;
                    if (this._type != 1 || this._curAction != 5) break block12;
                    Animation.getAnimation(29).draw(var1_1, var6_6 + 1, var7_7 + 2, 0, 0, 0);
                    break block11;
                }
                if (this._type != 0 || !PzgScene.getInstance()._startRun) break block13;
                Animation.getAnimation(32).draw(var1_1, var6_6, var7_7 - 1, 0, 0, 0);
                break block11;
            }
            if (this._type != 0) ** GOTO lbl-1000
            AnalyzePropsList.getInstance();
            if (AnalyzePropsList.checkIsCanUsePros(9)) {
                Animation.getAnimation(28).draw(var1_1, var6_6, var7_7 + 1, 0, 0, 0);
            } else lbl-1000:
            // 2 sources

            {
                Animation.getAnimation(29).draw(var1_1, var6_6 + 1, var7_7 + 1, 0, 0, 0);
            }
        }
        if (this.isXieActor() && !this._isFlip) {
            Animation.getAnimation(29).draw(var1_1, var6_6, var7_7 + 2, 1, 0, 0);
        } else if (this.isXieActor() && this._isFlip) {
            Animation.getAnimation(29).draw(var1_1, var6_6, var7_7 + 2, -2147483647, 0, 0);
        }
        if (this._openContort) {
            this.drawEffectProcess(var1_1, var6_6, var7_7, this._curAction, this._curFrame, this._palNo, -this._vl + this._vr, -this._vt + this._vb);
        } else if (this._openSpecialDisActor) {
            this.drawSpecialDisActor(var1_1, var6_6, var7_7, this._curAction, this._curFrame, this._palNo);
        } else {
            this._anim.draw(var1_1, var6_6, var7_7, this._curAction, this._curFrame, this._palNo);
        }
    }

    public void drawShelter(Graphics graphics) {
        if (this._map == null) {
            return;
        }
        int n = this._x >> 10;
        int n2 = this._y >> 10;
        int n3 = n + this._vl;
        int n4 = n + this._vr;
        int n5 = n2 + this._vt;
        int n6 = n2 + this._vb;
        this._map.directDrawShelter(graphics, n3, n5, n4, n6);
        this._map.lastDrawShlter(graphics);
    }

    public boolean collide(int n, int n2, int n3, int n4) {
        if (this._l == this._r || this._t == this._b || n == n3 || n2 == n4) {
            return false;
        }
        int n5 = (this._x >> 10) + this._l;
        int n6 = (this._x >> 10) + this._r;
        int n7 = (this._y >> 10) + this._t;
        int n8 = (this._y >> 10) + this._b;
        return n6 > n && n5 < n3 && n8 > n2 && n7 < n4;
    }

    public final boolean collide(UnitData unitData) {
        short[] sArray = unitData.getArea();
        short s = sArray[0];
        short s2 = sArray[1];
        short s3 = sArray[2];
        short s4 = sArray[3];
        return this.collide(s, s3, s2, s4);
    }

    public boolean collide(Actor actor) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        n = this._l;
        n2 = this._r;
        n3 = this._t;
        n4 = this._b;
        if (n == n2 || n3 == n4) {
            return false;
        }
        return actor.collide(n += this._x >> 10, n3 += this._y >> 10, n2 += this._x >> 10, n4 += this._y >> 10);
    }

    public int getXDirLocation(int n) {
        return this._x - (n >> 1);
    }

    public int getYDirLocation(int n) {
        return this._y - (n >> 1);
    }

    public int getXDirOtherActor(int n) {
        return this._x - n;
    }

    public int getYDirOtherActor(int n) {
        return this._y - n;
    }

    public void paintInfo(Graphics graphics) {
    }

    protected final void setSkin(int n) {
        int n2 = this._anim.getSkinNum();
        this._palNo = n < n2 ? n : n2 - 1;
    }

    public final int getCol() {
        return (this._x >> 10) / Map._bktw;
    }

    public final int getRow() {
        return (this._y >> 10) / Map._bkth;
    }

    protected void changeToWalk(int n) {
    }

    public final void stop() {
        this.changeToWait();
    }

    public void changeToWait() {
    }

    public boolean hasAutoMoveStep() {
        if (this._trace == 1) {
            this.nextFrame();
            this._vx += this._avx;
            this._vy += this._avy;
            this._x += this._vx;
            this._y += this._vy;
            this.updateForMoveTo();
            return true;
        }
        return false;
    }

    private void updateForMoveTo() {
        if (this.checkPassDestination()) {
            this._vx = 0;
            this._vy = 0;
        }
    }

    public void setPosByTile(int n, int n2) {
        int n3 = n * Map._bktw + (Map._bktw >> 1);
        int n4 = n2 * Map._bkth + (Map._bkth >> 1);
        this._x = n3 << 10;
        this._y = n4 << 10;
    }

    private final boolean hasAutoPathOffset() {
        return this._autoPathOffsetX != 0 || this._autoPathOffsetY != 0;
    }

    private boolean hasAutoPassStep() {
        if (this.path != null) {
            this.nextFrame();
            this._x += this._vx;
            this._y += this._vy;
            this.checkPassDestination();
            return true;
        }
        return false;
    }

    private boolean hasAutoPassAI() {
        if (this.path == null) {
            return false;
        }
        if (this.arriveDesFlag) {
            if (this.hasAutoPathOffset()) {
                this.nextOffset();
            } else {
                this.nextDestination();
            }
            this.startNextDestination();
        }
        return true;
    }

    private final void nextOffset() {
        if (this._autoPathOffsetX != 0) {
            this.destinationX = this._x + this._autoPathOffsetX;
            this.destinationY = this._y;
            this._autoPathOffsetX = 0;
        } else if (this._autoPathOffsetY != 0) {
            this.destinationX = this._x;
            this.destinationY = this._y + this._autoPathOffsetY;
            this._autoPathOffsetY = 0;
        }
    }

    public final byte[][] getPath() {
        return this.path;
    }

    public final boolean isFinishWalk() {
        return this.path == null;
    }

    public final void walkTo(int n, int n2) {
        Searcher searcher = Searcher.getInstance();
        Map map = this._map;
        int n3 = (this._x >> 10) / Map._bktw;
        int n4 = (this._y >> 10) / Map._bkth;
        this.path = searcher.getPath(n3, n4, n, n2, map);
        try {
            this.calculateOffset();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.arriveDesFlagForMove = false;
        this.destinationX = this._x;
        this.destinationY = this._y;
        this.arriveDesFlag = true;
        this.pathIndex = 1;
        if (this._type == 31) {
            this.changeAction(this._curAction & 0xFF | Integer.MIN_VALUE);
            this.setActorInfo(this._curAction & 0xFF | Integer.MIN_VALUE, this._x - 16384, this._y);
            SceneActorInfo.recordSceneActorID(this._id, this.getCurActorInfo());
        }
    }

    private final void calculateOffset() {
        if (this.path.length < 2) {
            return;
        }
        Map map = this._map;
        int n = this._x >> 10;
        int n2 = this._y >> 10;
        int n3 = this.path[0][0] * Map._bktw + (Map._bktw >> 1);
        int n4 = this.path[0][1] * Map._bkth + (Map._bkth >> 1);
        int n5 = this.path[1][0] * Map._bktw + (Map._bktw >> 1);
        int n6 = this.path[1][1] * Map._bkth + (Map._bkth >> 1);
        this._autoPathOffsetX = n3 < n5 ? n5 - n : (n3 > n5 ? n5 - n : 0);
        this._autoPathOffsetY = n4 < n6 ? n6 - n2 : (n4 > n6 ? n6 - n2 : 0);
        this._autoPathOffsetX <<= 10;
        this._autoPathOffsetY <<= 10;
    }

    public boolean getArriveDesFlagForMove() {
        return this.arriveDesFlagForMove;
    }

    private final void nextDestination() {
        ++this.pathIndex;
        if (this.pathIndex >= this.path.length) {
            this.changeToWait();
            this.path = null;
            this.arriveDesFlagForMove = true;
            return;
        }
        Map map = this._map;
        this.destinationX = this.path[this.pathIndex][0] * Map._bktw + (Map._bktw >> 1) << 10;
        this.destinationY = this.path[this.pathIndex][1] * Map._bkth + (Map._bkth >> 1) << 10;
    }

    private final void startNextDestination() {
        this.arriveDesFlag = false;
        if (this._x > this.destinationX) {
            this.changeToWalk(-2147483644);
        } else if (this._x < this.destinationX) {
            this.changeToWalk(4);
        } else if (this._y > this.destinationY) {
            this.changeToWalk(5);
        } else if (this._y < this.destinationY) {
            this.changeToWalk(3);
        } else {
            this.changeToWait();
        }
    }

    private final boolean checkPassDestination() {
        if (this._vx > 0) {
            if (this._x < this.destinationX) {
                return false;
            }
        } else if (this._vx < 0) {
            if (this._x > this.destinationX) {
                return false;
            }
        } else if (this._vy > 0) {
            if (this._y < this.destinationY) {
                return false;
            }
        } else if (this._vy < 0) {
            if (this._y > this.destinationY) {
                return false;
            }
        } else {
            return false;
        }
        this._x = this.destinationX;
        this._y = this.destinationY;
        this._trace = 0;
        this.arriveDesFlag = true;
        return true;
    }

    public void resetWalkTo() {
        this.changeToWait();
        this.path = null;
        this.arriveDesFlagForMove = true;
    }

    protected Actor() {
    }

    public int getPriority() {
        return 1;
    }

    public final boolean isPressConfirmKey() {
        return KeyHandler.instance().getCurKey() == 16;
    }

    public final boolean isCollideMain() {
        if (this._l == 0 && this._r == 0 && this._t == 0 && this._b == 0) {
            return false;
        }
        Actor actor = this._scene.getMainActor();
        int n = (actor._x >> 10) + actor._l;
        int n2 = (actor._x >> 10) + actor._r;
        int n3 = (actor._y >> 10) + actor._t;
        int n4 = (actor._y >> 10) + actor._b;
        if (n == n2 || n3 == n4) {
            return false;
        }
        int n5 = (this._x >> 10) + this._l;
        int n6 = (this._x >> 10) + this._r;
        int n7 = (this._y >> 10) + this._t;
        int n8 = (this._y >> 10) + this._b;
        return n6 >= n && n5 <= n2 && n8 >= n3 && n7 <= n4;
    }

    public final int conversionTileIndexLeft(int n) {
        int n2 = n / Map._bktw;
        return n < 0 ? n2 - 1 : n2;
    }

    public final int conversionTileIndexRight(int n) {
        return --n / Map._bktw;
    }

    public final int conversionTileIndexTop(int n) {
        return n / Map._bkth;
    }

    public final int conversionTileIndexBottom(int n) {
        return --n / Map._bkth;
    }

    public boolean issolid(int n) {
        return n == 1 || n == 30;
    }

    public boolean checkLeftWall() {
        if (this._dx >= 0) {
            return false;
        }
        int n = this._l;
        int n2 = this._r;
        Map map = this._map;
        int n3 = Map._bktw;
        int n4 = Map._bkth;
        int n5 = this.conversionTileIndexLeft((this._x >> 10) + n) * n3;
        int n6 = this.conversionTileIndexLeft((this._x + this._dx >> 10) + n) * n3;
        int n7 = this.conversionTileIndexTop((this._y >> 10) + this._t) * n4;
        int n8 = this.conversionTileIndexBottom((this._y >> 10) + this._b) * n4;
        int n9 = n7;
        while (n9 <= n8) {
            if (this.checkLineSolid(n5, n9, n6, n9, -n3, 0, this._result)) {
                this._vx = 0;
                this._dx = (this._result[0] + n3 << 10) - (this._x + (this._l - 1 << 10));
                this.isTurnUpDown(n7, n8, n6);
                return true;
            }
            n9 += n4;
        }
        return false;
    }

    public boolean checkRightWall() {
        int n = this._l;
        int n2 = this._r;
        if (this._dx <= 0) {
            return false;
        }
        Map map = this._map;
        int n3 = Map._bktw;
        int n4 = Map._bkth;
        int n5 = this.conversionTileIndexRight((this._x >> 10) + n2) * n3;
        int n6 = this.conversionTileIndexRight((this._x + this._dx >> 10) + n2) * n3;
        int n7 = this.conversionTileIndexTop((this._y >> 10) + this._t) * n4;
        int n8 = this.conversionTileIndexBottom((this._y >> 10) + this._b) * n4;
        int n9 = n7;
        while (n9 <= n8) {
            if (this.checkLineSolid(n5, n9, n6, n9, n3, 0, this._result)) {
                this._vx = 0;
                this._dx = (this._result[0] << 10) - (this._x + (this._r + 1 << 10));
                this.isTurnUpDown(n7, n8, n6);
                return true;
            }
            n9 += n4;
        }
        return false;
    }

    public boolean checkUpWall() {
        int n = this._l;
        int n2 = this._r;
        if (this._dy >= 0) {
            return false;
        }
        Map map = this._map;
        int n3 = Map._bktw;
        int n4 = Map._bkth;
        int n5 = this.conversionTileIndexLeft((this._x >> 10) + n) * n3;
        int n6 = this.conversionTileIndexRight((this._x >> 10) + n2) * n3;
        int n7 = this.conversionTileIndexTop((this._y >> 10) + this._t) * n4;
        int n8 = this.conversionTileIndexTop((this._y + this._dy >> 10) + this._t) * n4;
        int n9 = n5;
        while (n9 <= n6) {
            if (this.checkLineSolid(n9, n7, n9, n8, 0, -n4, this._result)) {
                this._vy = 0;
                this._dy = (this._result[0] + n4 << 10) - (this._y + (this._t - 1 << 10));
                this.isTurnLeftRight(n5, n6, n8);
                return true;
            }
            n9 += n3;
        }
        return false;
    }

    public boolean checkBottomWall() {
        int n = this._l;
        int n2 = this._r;
        if (this._dy <= 0) {
            return false;
        }
        Map map = this._map;
        int n3 = Map._bktw;
        int n4 = Map._bkth;
        int n5 = this.conversionTileIndexLeft((this._x >> 10) + n) * n3;
        int n6 = this.conversionTileIndexRight((this._x >> 10) + n2) * n3;
        int n7 = this.conversionTileIndexBottom((this._y >> 10) + this._b) * n4;
        int n8 = this.conversionTileIndexBottom((this._y + this._dy >> 10) + this._b) * n4;
        int n9 = n5;
        while (n9 <= n6) {
            if (this.checkLineSolid(n9, n7, n9, n8, 0, n4, this._result)) {
                this._vy = 0;
                this._dy = (this._result[0] << 10) - (this._y + (this._b + 1 << 10));
                this.isTurnLeftRight(n5, n6, n8);
                return true;
            }
            n9 += n3;
        }
        return false;
    }

    public void isTurnLeftRight(int n, int n2, int n3) {
        int n4 = (this._x >> 10) + this._l / 2;
        int n5 = (this._x >> 10) + this._r / 2;
        int n6 = ((this._x >> 10) + this._r) / Map._bktw * Map._bktw;
        int n7 = ((this._x >> 10) + this._l) / Map._bktw * Map._bktw + Map._bktw;
        if (this._vx == 0) {
            if (!this.checkLineSolid(n, n3, n - Map._bktw, n3, -Map._bktw, 0, this._result) && n4 < n6) {
                this._dx = -((this._x >> 10) + this._r - n6) << 10;
            }
            if (!this.checkLineSolid(n2, n3, n2 + Map._bktw, n3, Map._bktw, 0, this._result) && n5 > n7) {
                this._dx = -((this._x >> 10) + this._l - n7) << 10;
            }
        }
    }

    public void isTurnUpDown(int n, int n2, int n3) {
        int n4 = (this._y >> 10) + this._t / 2;
        int n5 = (this._y >> 10) + this._b - 1;
        int n6 = ((this._y >> 10) + this._b) / Map._bktw * Map._bktw;
        int n7 = ((this._y >> 10) + this._t) / Map._bktw * Map._bktw + Map._bktw;
        if (this._vy == 0) {
            if (!this.checkLineSolid(n3, n, n3, n - Map._bktw, -Map._bkth, 0, this._result) && n4 < n6) {
                this._dy = -((this._y >> 10) + this._b - n6) << 10;
            }
            if (!this.checkLineSolid(n3, n2, n3, n2 + Map._bktw, Map._bktw, 0, this._result) && n5 > n7) {
                this._dy = -((this._y >> 10) + this._t - n7) << 10;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public boolean checkLineSolid(int var1_1, int var2_2, int var3_3, int var4_4, int var5_5, int var6_6, int[] var7_7) {
        block9: {
            block8: {
                var8_8 = this._map;
                var10_9 = var1_1;
                var11_10 = var2_2;
                if (var5_5 == 0) break block8;
                if (var5_5 >= 0) ** GOTO lbl19
                while (var10_9 >= var3_3) {
                    var9_11 = var8_8.getPhyBlock(var10_9, var2_2);
                    if (this.issolid(var9_11)) {
                        var7_7[0] = var10_9;
                        return true;
                    }
                    var10_9 += var5_5;
                }
                break block9;
lbl-1000:
                // 1 sources

                {
                    var9_12 = var8_8.getPhyBlock(var10_9, var2_2);
                    if (this.issolid(var9_12)) {
                        var7_7[0] = var10_9;
                        return true;
                    }
                    var10_9 += var5_5;
lbl19:
                    // 2 sources

                    ** while (var10_9 <= var3_3)
                }
lbl20:
                // 1 sources

                break block9;
            }
            if (var6_6 >= 0) ** GOTO lbl36
            while (var11_10 >= var4_4) {
                var9_13 = var8_8.getPhyBlock(var1_1, var11_10);
                if (this.issolid(var9_13)) {
                    var7_7[0] = var11_10;
                    return true;
                }
                var11_10 += var6_6;
            }
            break block9;
lbl-1000:
            // 1 sources

            {
                var9_14 = var8_8.getPhyBlock(var1_1, var11_10);
                if (this.issolid(var9_14)) {
                    var7_7[0] = var11_10;
                    return true;
                }
                var11_10 += var6_6;
lbl36:
                // 2 sources

                ** while (var11_10 <= var4_4)
            }
        }
        return false;
    }

    public int getCurAction() {
        return this._curAction;
    }

    public void drawEffectProcess(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        switch (this._contortStyle) {
            case 1: {
                if (this._current < 10) {
                    ++this._current;
                    this.drawEffect(graphics, this._current, this._sum, 0, this._anim, n3, n4, n5, n, n2, n6, n7, 5);
                    break;
                }
                this._contortEnd = true;
                break;
            }
            case 2: {
                if (this._current > 0) {
                    --this._current;
                    this.drawEffect(graphics, this._current, this._sum, 0, this._anim, n3, n4, n5, n, n2, n6, n7, 5);
                    break;
                }
                this._contortEnd = true;
                this.changeAction(this._disAction);
                this._scene.disActiveInst(this._id);
            }
        }
        if (this._contortEnd) {
            this._contortEnd = false;
            this._openContort = false;
        }
    }

    public void drawEffect(Graphics graphics, int n, int n2, int n3, Animation animation, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11) {
        int n12;
        int n13;
        if (n3 == 0) {
            n13 = n9;
            n12 = n10;
        } else {
            n12 = n10;
            n13 = n9;
        }
        int n14 = n13 / 2;
        int n15 = n12 / 1;
        int n16 = n13 * n / n2;
        int n17 = n13 * (n2 - n) / (n2 * 4);
        int n18 = 360 * n / n2;
        int n19 = 360 * n11 / n15;
        int n20 = 0;
        while (n20 < n15) {
            int n21 = n17 * Function.cos(n18) >> 10;
            if (n20 >= 50) {
                // empty if block
            }
            if (n3 == 0) {
                animation.drawClip(graphics, n7 + n21, n8, n4, n5, n6, n7 + this._vl + n14 - n16 / 2 + n21, n8 + this._vt + n20 * 1, n16, 1);
            } else {
                animation.drawClip(graphics, n7, n8 + n21, n4, n5, n6, n7 + this._vl + n20 * 1, n8 + this._vt + n14 - n16 / 2 + n21, 1, n16);
            }
            n18 += n19;
            ++n20;
        }
    }

    public void drawSpecialDisActor(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        if (this._maxOffsetX > 0) {
            this._offsetX += 2;
        } else if (this._maxOffsetY > 0) {
            this._offsetY += 2;
        }
        if (this._offsetX > this._maxOffsetX || this._offsetY > this._maxOffsetY) {
            this._openSpecialDisActor = false;
            this.disActive();
        }
    }

    public boolean isArrive() {
        int n = this._tempDistanceX;
        int n2 = this._tempActorX;
        int n3 = this._x >> 10;
        if (n > 0) {
            return Math.abs(n3 - n2) > n || this.checkRightWall() || this.checkLeftWall() || n3 - n2 == 0 && this._vx == 0;
        }
        return false;
    }

    public static void openAI() {
        _enableAI = true;
    }

    public static void closeAI() {
        _enableAI = false;
        PzgScene.getInstance().getFocusActor().changeToWait();
    }

    public ActorInfo getCurActorInfo() {
        return this._actorInfo;
    }

    public void setActorInfo(int n, int n2, int n3) {
        if (this._actorInfo == null) {
            this._actorInfo = SceneActorInfo.checkIsHaveCurActor(Scene._curSceneID, this._id);
            if (this._actorInfo == null) {
                this._actorInfo = new ActorInfo();
            }
        }
        this._actorInfo.setCurAction(n);
        this._actorInfo.setCurCoordinate(n2, n3);
    }
}

