/*
 * Decompiled with CFR 0.152.
 */
package pzg.extend.gameUtil;

import javax.microedition.lcdui.Graphics;
import module.ekernel.animation.Animation;
import module.ekernel.input.KeyHandler;
import pzg.extend.game.GameMainLogic;
import pzg.extend.game.PzgScene;
import pzg.extend.gameUtil.GameFunction;
import rpg.basic.gameUtil.Function;
import rpg.basic.gameUtil.MessageBox;
import rpg.basic.gameUtil.MessageBoxHandler;

public class GameMessageBox
extends MessageBox {
    public int _style;
    public static GameMessageBox _instance;
    private int _dialogHeadInx;
    private String _dialogRoleName;
    private int _dialogRolexpression;
    private int _dialog_frame_index;
    private String[] _dialogContext = new String[100];
    private int _dialogPageNum;
    private int _dialogPage;
    private int _dialogWordOffset;
    private boolean _isCurrentPageFinish;
    private int _dialogFrameX;
    public int _dialogFrameY;
    private int _dialogFrameW;
    public int _dialogFrameH;
    private int _dialogWordNumInLine;
    private int _dialogX;
    private int _dialogY;
    private int _dialogLineNum;
    private int _dialogNameX;
    private int _dialogNameY;
    private int _dialogNameW;
    private int _dialogNameH;
    private boolean _sheltKeyFlag;
    private int _roleAniW;
    private int _roleAniX;
    private int _roleHeadLastInx = -1;
    private int _singlePageFrameW;
    private int _singlePageFrameH;
    private int _singlePageInfoX;
    private int _singlePageInfoY;
    private int _singleBKX;
    private int _singleBKY;
    private int _stayTime = 0;
    private boolean _isPressKeyDis = false;
    private Animation _imageAni;
    private int _imageAction;
    private int _imageFrame;
    private String[] _tempStr;
    private int _multiStartX;
    private int _multiStartY;
    private int _multiSpace;
    private String[] _multiMessage;
    private int _validMultiNum;

    private GameMessageBox() {
        this.format();
    }

    private final void format() {
        this.calculateFormatForDialog();
        this.calculateFormatForSinglePage();
    }

    public final void draw(Graphics graphics) {
        switch (this._style) {
            case 0: {
                this.paintForDialogStyle(graphics);
                this.keyRespondForDialogStyle();
                break;
            }
            case 1: {
                this.paintForSinglePageStyle(graphics);
                this.keyRespondForSinglePageStyle();
                break;
            }
            case 2: {
                this.drawMultiRow(graphics);
                this.keyRespondForMultiRow();
            }
        }
    }

    public static final GameMessageBox getInstance(MessageBoxHandler messageBoxHandler) {
        if (_instance == null) {
            _instance = new GameMessageBox();
        }
        _instance.init(messageBoxHandler);
        return _instance;
    }

    public final void initDialogStyle(int n, String string, String string2, int n2, int n3) {
        this._style = 0;
        this._dialogX = 25;
        this._dialogWordNumInLine = (320 - this._dialogX * 2) / Function.C_WORD_W;
        this._dialogHeadInx = n;
        this._dialogRoleName = string.trim();
        this._dialogNameY = this._dialogFrameY - 2;
        this._dialogNameW = string.length() * Function.C_WORD_W + 10;
        if (this._dialogHeadInx > 0) {
            this._dialogRolexpression = n2;
        }
        switch (n3) {
            case 1: 
            case 2: {
                this._dialog_frame_index = 2;
                this._dialogNameX = 320 - this._dialogNameW;
                if (this.isSameOnePersonSpeak()) break;
                this._roleAniX = 0;
                break;
            }
            case 3: 
            case 4: {
                this._dialog_frame_index = 4;
                this._dialogNameX = 5;
                if (this.isSameOnePersonSpeak()) break;
                this._roleAniX = 320;
                break;
            }
            default: {
                this._dialogNameX = 320 - this._dialogNameW;
                if (this.isSameOnePersonSpeak()) break;
                this._roleAniX = 0;
            }
        }
        this.deivideDialog(string2);
        this.startupDialog();
        this.clearKey();
        this.setsheltKeys(false);
    }

    private boolean isSameOnePersonSpeak() {
        int n = this._roleHeadLastInx;
        this._roleHeadLastInx = this._dialogHeadInx;
        return n == this._dialogHeadInx;
    }

    private final void deivideDialog(String string) {
        int n;
        string = GameFunction.initWordOffset(string);
        this._dialogPageNum = 0;
        int n2 = string.length();
        int n3 = this._dialogWordNumInLine * this._dialogLineNum;
        int n4 = 0;
        do {
            n = Math.min(n4 + n3, n2);
            this._dialogContext[this._dialogPageNum++] = string.substring(n4, n);
        } while ((n4 = n) < n2);
    }

    private final void startupDialog() {
        this._dialogPage = -1;
        this.nextPage();
    }

    private final void nextPage() {
        ++this._dialogPage;
        this._dialogWordOffset = 0;
        this._isCurrentPageFinish = false;
    }

    public final void setsheltKeys(boolean bl) {
        this._sheltKeyFlag = bl;
    }

    private final boolean isExistNextPage() {
        return this._dialogPage < this._dialogPageNum - 1;
    }

    private final void calculateFormatForDialog() {
        try {
            this._roleAniW = 80;
            int n = 2;
            int n2 = Function.C_WORD_H * 2 + 6 + n * 2 + 2 - 3;
            int n3 = 0;
            this._dialogFrameH = n2;
            this._dialogFrameY = 240 - this._dialogFrameH;
            this._dialogFrameW = 320 - n3 * 2;
            this._dialogFrameX = n3;
            this._dialogLineNum = (this._dialogFrameH - this._dialogNameH - 4) / Function.C_WORD_H;
            this._dialogY = this._dialogFrameY + n;
            this._dialogNameH = Function.C_WORD_H + 4;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private final void paintForDialogStyle(Graphics graphics) {
        this.drawDialogContent(graphics);
    }

    private final void drawDialogContent(Graphics graphics) {
        int n = this._dialogX;
        switch (this._dialog_frame_index) {
            case 1: {
                this._isCurrentPageFinish = GameFunction.drawWordOffset(graphics, n, 80 - (240 - this._dialogY), Function.C_WORD_W, Function.C_WORD_H, this._dialogContext[this._dialogPage], this._dialogWordOffset, this._dialogWordNumInLine, 0xFDFDFD, this._dialogPage);
                break;
            }
            case 2: {
                this._isCurrentPageFinish = GameFunction.drawWordOffset(graphics, n, this._dialogY - 3, Function.C_WORD_W, Function.C_WORD_H, this._dialogContext[this._dialogPage], this._dialogWordOffset, this._dialogWordNumInLine, 0xFDFDFD, this._dialogPage);
                break;
            }
            case 3: {
                this._isCurrentPageFinish = GameFunction.drawWordOffset(graphics, n, 80 - (240 - this._dialogY), Function.C_WORD_W, Function.C_WORD_H, this._dialogContext[this._dialogPage], this._dialogWordOffset, this._dialogWordNumInLine, 0xFDFDFD, this._dialogPage);
                break;
            }
            case 4: {
                this._isCurrentPageFinish = GameFunction.drawWordOffset(graphics, n, this._dialogY, Function.C_WORD_W, Function.C_WORD_H, this._dialogContext[this._dialogPage], this._dialogWordOffset, this._dialogWordNumInLine, 0xFDFDFD, this._dialogPage);
                break;
            }
            default: {
                this._isCurrentPageFinish = GameFunction.drawWordOffset(graphics, n, this._dialogY, Function.C_WORD_W, Function.C_WORD_H, this._dialogContext[this._dialogPage], this._dialogWordOffset, this._dialogWordNumInLine, 0xFDFDFD, this._dialogPage);
            }
        }
    }

    private final void keyRespondForDialogStyle() {
        ++this._dialogWordOffset;
        if (this._sheltKeyFlag) {
            return;
        }
        int n = GameMainLogic.getCurKey();
        switch (n) {
            case 16: {
                this._dialogWordOffset += 5;
                if (this._isCurrentPageFinish) {
                    if (this.isExistNextPage()) {
                        this.nextPage();
                    } else {
                        this.finishShowHandler();
                    }
                }
                KeyHandler.instance().resetKeyBuff();
            }
        }
    }

    private final void calculateFormatForSinglePage() {
        this._singlePageFrameW = 320;
        this._singleBKX = 160;
        this._singlePageInfoX = 160;
        this._singlePageInfoY = 240 - Function.C_WORD_H >> 1;
    }

    public final void initSinglePageStyle(int n, int n2, String string, int n3) {
        n3 = 0;
        this._imageFrame = 0;
        int n4 = 0;
        if (n != 0) {
            this._imageAni = Animation.getAnimation(n);
            if (this._imageAni == null) {
                this._imageAni = Animation.load("/res/ani.bin", n, 0);
            }
            this._imageAction = n2;
            n4 = this._imageAni._b[this._imageAction] - this._imageAni._t[this._imageAction];
        } else {
            this._imageAni = null;
        }
        int n5 = (320 - 2 * Function.C_WORD_W) / Function.C_WORD_W;
        this._tempStr = Function.subString(string, n5);
        this._singlePageFrameH = (Function.C_WORD_H + 1) * this._tempStr.length + 20 + n4;
        this._singleBKY = 120 - this._singlePageFrameH / 2;
        this._singlePageInfoY = this._singleBKY + 10 + n4;
        this._stayTime = n3;
        this._isPressKeyDis = n3 <= 0;
        this._style = 1;
        GameFunction.initAlphaArray(3159100, 70, 2);
        this.clearKey();
    }

    private final void paintForSinglePageStyle(Graphics graphics) {
        graphics.setClip(0, 0, 320, 240);
        GameFunction.drawFrameBox(graphics, this._singleBKY, this._singlePageFrameH);
        if (this._imageAni != null) {
            this._imageAni.draw(graphics, 133, this._singlePageInfoY - 10, this._imageAction, this._imageFrame, 0);
            ++this._imageFrame;
            if (this._imageFrame > this._imageAni.getActFrmNum(this._imageAction) - 1) {
                this._imageFrame = 0;
            }
        }
        graphics.setClip(0, 0, 320, 240);
        graphics.setColor(0xFFFFFF);
        int n = 0;
        while (n < this._tempStr.length) {
            graphics.drawString(this._tempStr[n], this._singlePageInfoX, this._singlePageInfoY + n * (Function.C_WORD_H + 1), 1 | 0x10);
            ++n;
        }
        PzgScene.getInstance()._analyzePuzzle.paintdialogTipPoint(graphics, 0, this._singlePageInfoY + this._tempStr.length * (Function.C_WORD_H + 2));
    }

    private final void keyRespondForSinglePageStyle() {
        int n = GameMainLogic.getCurKey();
        this.clearKey();
        if (this._isPressKeyDis) {
            if (n == 16) {
                this._imageAni = null;
                this.finishShowHandler();
            }
        } else if (--this._stayTime < 0) {
            this._stayTime = 0;
            this._imageAni = null;
            this.finishShowHandler();
        }
    }

    private void drawMultiRow(Graphics graphics) {
        GameFunction.drawFrameBox(graphics, this._multiStartY - 5, this._validMultiNum * Function.C_WORD_H + 10);
        int n = 0;
        while (n < this._validMultiNum) {
            Function.draw3DString(graphics, this._multiMessage[n], this._multiStartX, this._multiStartY + n * this._multiSpace, 0x10 | 1, 0, 0xFFFFFF);
            ++n;
        }
    }

    private void keyRespondForMultiRow() {
        if (GameMainLogic.isPressConfirmKey()) {
            this.finishShowHandler();
        }
        GameMainLogic.resetCurKey();
    }
}

