/*
 * Decompiled with CFR 0.152.
 */
package pzg.extend.game;

import javax.microedition.lcdui.Graphics;
import module.ekernel.animation.Animation;
import module.ekernel.container.GameMidlet;
import module.ekernel.container.GamePage;
import module.ekernel.input.KeyHandler;
import module.ekernel.input.PointHandler;
import module.ekernel.sptset.midp2image.SptSet;
import pzg.basic.puzzle.Adjudgment;
import pzg.basic.puzzle.AnalyzePuzzle;
import pzg.extend.game.GameInterface;
import pzg.extend.game.GameRms;
import pzg.extend.game.Police;
import pzg.extend.game.PzgGameMidlet;
import pzg.extend.game.PzgScene;
import pzg.extend.game.SmsUi;
import rpg.basic.gameUtil.Function;
import rpg.basic.scene.Scene;

public class GameMainLogic
implements GamePage {
    private static GameMainLogic _inst;
    protected static KeyHandler _keyHandler;
    protected static PointHandler _pointHandler;
    private byte _pageIndex;
    private byte _prePageIndex;
    private byte _loadWordProcess;
    private static Graphics _gh;
    public static boolean _continue;
    public static PzgGameMidlet _midlet;
    public GameInterface _interface;
    public static PzgScene _pzgScene;
    public static int _gameScenario;
    public static SmsUi _smsUi;
    public static boolean _isDrawN97Key;
    private int _loadState = 0;
    public static boolean WHILT_BACK_FALG;
    public static boolean CMD_ONLY_ONE;
    private long _gameStartTime;
    private long _gamePlayTime;

    protected GameMainLogic(GameMidlet gameMidlet) {
    }

    static final GameMainLogic produceGameMainLogic(GameMidlet gameMidlet) {
        _inst = new GameMainLogic(gameMidlet);
        _midlet = (PzgGameMidlet)gameMidlet;
        _inst.initMainLogic();
        _pzgScene = PzgScene.getInstance();
        return _inst;
    }

    public void draw(Graphics graphics) {
        try {
            _gh = graphics;
            switch (this._pageIndex) {
                case 0: {
                    this._interface.paint(graphics);
                    break;
                }
                case 2: {
                    _pzgScene.update();
                    _pzgScene.paint(graphics);
                    break;
                }
                case 3: {
                    this.drawStopFrame(graphics);
                    break;
                }
                case 4: {
                    _smsUi.draw(graphics);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected void initMainLogic() {
        _inst.changePage((byte)0);
        GameMainLogic._inst._interface = new GameInterface(_inst);
        _keyHandler = KeyHandler.instance();
        _pointHandler = PointHandler.instance();
        _smsUi = new SmsUi(this);
    }

    public void changePage(byte by) {
        this._prePageIndex = this._pageIndex;
        this._pageIndex = by;
    }

    public final void changeToInterface(int n) {
        this._prePageIndex = this._pageIndex;
        this._interface.changeState(n);
        if (n == 19) {
            if (this._prePageIndex == 0) {
                this._interface.initGameLoad();
            } else {
                this._interface.initGameSave();
            }
        } else if (n == 13) {
            GameInterface._isInMenu = true;
        }
        this.changePage((byte)0);
        this.resetLoadLevel();
    }

    public boolean loadGlobalData() {
        switch (this._loadState) {
            case 0: {
                AnalyzePuzzle.loadCast("/res/r.bin");
                ++this._loadState;
                break;
            }
            case 1: {
                AnalyzePuzzle.getInstance();
                ++this._loadState;
                break;
            }
            case 2: {
                GameRms.loadRmsUIProperty();
                ++this._loadState;
                break;
            }
            case 3: {
                if (GameInterface.C_HANDSET_KIND == 2) {
                    int n = 0;
                    while (n < 9) {
                        Adjudgment.load("/res/Adjudgment" + n + ".xaz", n);
                        ++n;
                    }
                }
                return true;
            }
        }
        return false;
    }

    protected boolean loadLevelData() {
        switch (this._loadWordProcess) {
            case 0: {
                if (_continue) {
                    _pzgScene.dispose();
                    this._loadWordProcess = 1;
                } else {
                    this._loadWordProcess = 1;
                }
                if (CMD_ONLY_ONE) {
                    CMD_ONLY_ONE = false;
                    Animation.setAnimationNull(33);
                    SptSet.setBaseSptSetNull(33);
                }
                Police._bell = null;
                break;
            }
            case 1: {
                WHILT_BACK_FALG = _gameScenario == 0 && Scene._curSceneID == 41;
                if (!_pzgScene.produceScene(this)) break;
                this._loadWordProcess = (byte)2;
                break;
            }
            case 2: {
                _continue = true;
                _pzgScene.startup();
                _pzgScene.startUpCamera();
                this._loadWordProcess = (byte)3;
                break;
            }
            case 3: {
                this._loadWordProcess = (byte)(this._loadWordProcess + 1);
                break;
            }
            case 15: {
                this.changePage((byte)2);
                return true;
            }
            default: {
                this._loadWordProcess = (byte)(this._loadWordProcess + 1);
            }
        }
        return false;
    }

    public void resetLoadLevel() {
        this._loadWordProcess = 0;
    }

    public void onKey(KeyHandler keyHandler) {
        _keyHandler = keyHandler;
    }

    public void onPoint(PointHandler pointHandler) {
        _pointHandler = pointHandler;
    }

    public void hideNotify() {
        this.notifyHide();
        this.changeToStopFrame();
    }

    public void notifyHide() {
        Function.stopSound();
    }

    public void changeToStopFrame() {
        if (this._pageIndex != 3) {
            if (this._pageIndex == 4) {
                if (GameMainLogic._smsUi._type != 0) {
                    this._prePageIndex = this._pageIndex;
                    this._pageIndex = (byte)3;
                }
            } else {
                this._prePageIndex = this._pageIndex;
                this._pageIndex = (byte)3;
            }
        }
    }

    public boolean finish() {
        return false;
    }

    public static GameMainLogic getInstance() {
        return _inst;
    }

    public final void exitGame() {
        try {
            _midlet.destroyApp();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static final boolean isPressCallMenuKey() {
        switch (0) {
            case 0: 
            case 1: 
            case 4: 
            case 5: {
                return _keyHandler.getCurKey() == 262144;
            }
            case 2: 
            case 3: {
                return _keyHandler.getCurKey() == 524288;
            }
        }
        return false;
    }

    public static final boolean isPressCallAttributeKey() {
        switch (0) {
            case 0: 
            case 1: 
            case 4: 
            case 5: {
                return _keyHandler.getCurKey() == 524288;
            }
            case 2: 
            case 3: {
                return _keyHandler.getCurKey() == 262144;
            }
        }
        return false;
    }

    public static final boolean isPressConfirmKey() {
        return GameMainLogic.isPressFireKey() || GameMainLogic.isPressConfirmSoftKey();
    }

    public static final boolean isPressCancelKey() {
        return GameMainLogic.isPressCancelSoftKey();
    }

    public static boolean isPressCancelSoftKey() {
        switch (0) {
            case 0: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return _keyHandler.getCurKey() == 524288;
            }
            case 1: {
                return _keyHandler.getCurKey() == 262144;
            }
        }
        return false;
    }

    public static boolean isMoto() {
        switch (0) {
            case 0: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return false;
            }
            case 1: {
                return true;
            }
        }
        return false;
    }

    public static final boolean isPressFireKey() {
        return _keyHandler.getCurKey() == 16;
    }

    public static final boolean isPressConfirmSoftKey() {
        switch (0) {
            case 0: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return _keyHandler.getCurKey() == 262144;
            }
            case 1: {
                return _keyHandler.getCurKey() == 524288;
            }
        }
        return false;
    }

    public final int getConfirmPos() {
        switch (0) {
            case 0: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                return 0;
            }
            case 1: {
                return 1;
            }
        }
        return 0;
    }

    public static void resetCurKey() {
        _keyHandler.resetKeyBuff();
    }

    public static int getCurKey() {
        return _keyHandler.getCurKey();
    }

    public void startRecordGameTime() {
        this._gameStartTime = System.currentTimeMillis() / 1000L;
    }

    public void resetGamePlayingTime() {
        this._gameStartTime = 0L;
        this._gamePlayTime = 0L;
    }

    public void countPlayGameTime() {
        this._gamePlayTime += System.currentTimeMillis() / 1000L - this._gameStartTime;
        this.startRecordGameTime();
    }

    public byte[] returnTimeArray() {
        byte[] byArray = new byte[]{0, 0};
        this.countPlayGameTime();
        byArray[0] = (byte)(this._gamePlayTime / 60L / 60L);
        byArray[1] = (byte)(this._gamePlayTime / 60L % 60L);
        return byArray;
    }

    public void setContinueGameTime(int[] nArray) {
        this._gamePlayTime = (nArray[0] * 60 + nArray[1]) * 60;
        this.startRecordGameTime();
    }

    private void drawStopFrame(Graphics graphics) {
        Function.fillScreen(graphics, 0, 0, 320, 240, 0);
        Function.draw3DString(graphics, "\u6682\u505c\u6e38\u620f", 160, 120, 0x10 | 1, 0xFFFFFF, 0);
        Function.draw3DString(graphics, "\u8fd4\u56de", 310, 232, 8 | 0x20, 0xFFFFFF, 0);
        boolean bl = false;
        if (GameMainLogic.isPressCancelKey()) {
            bl = true;
        }
        if (bl) {
            GameMainLogic.resetCurKey();
            this.backGameState();
        }
    }

    public void backGameState() {
        this._pageIndex = this._prePageIndex;
        switch (this._pageIndex) {
            default: 
        }
        if (!Function._isContinue) {
            Function.continuePlaySound();
        }
    }

    static {
        _isDrawN97Key = false;
        WHILT_BACK_FALG = false;
        CMD_ONLY_ONE = false;
    }
}

