/*
 * Decompiled with CFR 0.152.
 */
package pzg.extend.game;

import java.io.IOException;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import module.ekernel.animation.Animation;
import module.ekernel.input.KeyHandler;
import module.ekernel.sptset.midp2image.SptSet;
import module.utils.R;
import pzg.basic.puzzle.AnalyzePuzzle;
import pzg.basic.puzzle.ClueList;
import pzg.extend.game.CaseCG;
import pzg.extend.game.ColorFather;
import pzg.extend.game.GameMainLogic;
import pzg.extend.game.GameRms;
import pzg.extend.game.PzgScene;
import pzg.extend.gameUI.PromptInterface;
import pzg.extend.gameUI.UIHandler;
import pzg.extend.gameUtil.GameFunction;
import pzg.extend.gameUtil.GameMenu;
import pzg.extend.gameUtil.SceneActorInfo;
import pzg.extend.glogo.Logo;
import pzg.extend.glogo.LogoListener;
import rpg.basic.gameUtil.Function;
import rpg.basic.gameUtil.Menu;
import rpg.basic.gameUtil.MenuHandler;
import rpg.basic.gameUtil.MessageBoxHandler;
import rpg.basic.scene.Scene;

public class GameInterface
implements MenuHandler,
MessageBoxHandler,
LogoListener {
    private int _loadProcess;
    private int _progressBar;
    private int _pageIndex;
    GameMainLogic _mainLogic;
    public static boolean _isInMenu;
    private long _ctime;
    private long _stime;
    private static Image[] _image;
    private GameMenu _gameMenu;
    private static final String[] C_GAME_MENU;
    private int _menuItem;
    private static boolean _isOpenSound;
    private int _soundButtonX;
    private int _soundButtonY;
    private int _soundButtonSpace;
    public static SptSet C_GAME_PANEL;
    public static SptSet C_GAME_LOAD;
    public static SptSet C_GAME_LOAD_NAME;
    public static SptSet C_GAME_CLUE;
    public static SptSet C_GAME_PROPS;
    public static SptSet C_GAME_CHEST_LOOKING;
    public static Animation C_GAME_JUDGE;
    public static Animation C_GAME_SURVEY;
    public static SptSet S_GAME_MENU;
    public static String[] sound;
    private ColorFather _colorFather;
    private boolean _isStartOverture;
    private int _drawOne;
    public static Font _font1;
    public static Font _font2;
    public static Font _font3;
    private int _tisk;
    private long _startTime;
    private int _namex = -100;
    private int _flagx = 440;
    private int _namey = 160;
    private int _flagy = 160;
    private int _colorAlph = 100;
    private int _roleX;
    private int _roleY;
    private boolean _insetMenu;
    private boolean _startPress;
    private static int _alpha;
    private static final String[] YESORNO;
    private static String[] _gameM;
    public static int C_HANDSET_KIND;
    private static int[] _info;
    private int _next;
    private String _text;
    private String _helpAboutTitle;
    public int _executeProcess;
    private int _point = 0;
    private static final String[] CLWE;
    private String _sceneTip;
    private int _gameOverTime = 20;
    private int _rmsPageTimeX;
    private int _roleStartX;
    private int _roleStartY;
    private int _roleSpace;
    private int _loadState = 0;
    Menu _menu;
    public static final String[] TITLES;
    private String[] _title;
    private int _titleX;
    private int _titleY;
    private int _curRmsIndex = 0;
    private int _drawStartX;
    private int _drawStartY;
    private int _drawW;
    private int _drawH;
    private int _space;
    public static int _soundNum;
    private int _curLifeLength = 0;
    public int _palyType = -1;
    private static int[] _menuSpt;
    private static int[] _menuSptOffX;
    private static String[] _paraInfo;
    public static int[] _paraValue;
    public static boolean _openPramInfo;
    public static boolean _closePartInfo;
    private int _infoItem;
    private int _valueIndex;
    private int _infoX;
    private int _infoY;
    public static boolean _isZuoBi;
    int _zuobi = 0;
    int _num = 0;
    private CaseCG _caseCG;
    private int _gLogoProcess;
    private Logo _gLogo;
    private static final String[] str_exit;
    private static final String[] str_into;
    private static final String[] str_lr_tip;
    Image _img_last;

    public GameInterface(GameMainLogic gameMainLogic) {
        this._mainLogic = gameMainLogic;
        this._loadProcess = 0;
        this._pageIndex = 0;
        _soundNum = 5;
        this._colorFather = new ColorFather();
        Animation.createAnimationMaxBuff(300);
        SptSet.createSptSetMaxBuff(300);
        Function.loadSound(sound);
    }

    public final void paint(Graphics graphics) {
        switch (this._pageIndex) {
            case 27: {
                this.gLogo(graphics);
                break;
            }
            case 0: {
                this.qqSmsGameTitle(graphics);
                break;
            }
            case 1: {
                this.gameLoadGlobal(graphics);
                break;
            }
            case 2: {
                break;
            }
            case 14: {
                this.gamePressKey(graphics);
                this.updataPressKey();
                break;
            }
            case 5: {
                this.gameConfirmClearRecord(graphics);
                break;
            }
            case 4: {
                this.gameLoading(graphics);
                break;
            }
            case 11: {
                this.gamePlaySoundTip(graphics);
                break;
            }
            case 3: {
                this.drawMenu(graphics);
                if (this._gameMenu != null) {
                    this._gameMenu.draw(graphics);
                    break;
                }
                this.gameMenu(graphics);
                break;
            }
            case 6: {
                this.gamePassLevel(graphics);
                break;
            }
            case 12: {
                this.drawMenuBK(graphics);
                this.paintInMenu(graphics);
                this.gamePlaySoundSel(graphics);
                UIHandler.drawReturnMenu(graphics);
                break;
            }
            case 9: {
                this.gameHelpAbout(graphics);
                this.returnFromHelpAbout();
                UIHandler.drawReturnMenu(graphics);
                break;
            }
            case 10: {
                this.gameHelpAbout(graphics);
                this.returnFromHelpAbout();
                UIHandler.drawReturnMenu(graphics);
                break;
            }
            case 7: {
                this.gameOver(graphics);
                break;
            }
            case 13: {
                this.gameExit(graphics);
                break;
            }
            case 28: {
                this.mortGameExit(graphics);
                break;
            }
            case 29: {
                this.mortGameTip(graphics);
                break;
            }
            case 16: {
                this.gameSound(graphics);
                break;
            }
            case 17: {
                break;
            }
            case 18: {
                this.gameItemSelect(graphics);
                break;
            }
            case 19: {
                this.drawMenuBK(graphics);
                this.paintInMenu(graphics);
                this.gameRmsPage(graphics);
                UIHandler.drawMenu(graphics);
                this.updateForRmsPage();
                break;
            }
            case 20: {
                break;
            }
            case 21: {
                this._caseCG.draw(graphics);
                graphics.setColor(0xFFFFFF);
                graphics.setFont(_font3);
                graphics.drawString("\u8df3\u8fc7", 320, 240, 8 | 0x20);
                if (!this._caseCG.getAllFinish() && !GameMainLogic.isPressCancelKey()) break;
                this.startNewGame();
                this._caseCG.disCG();
            }
        }
    }

    private void gameHeadProcess(Graphics graphics) {
        graphics.setColor(0);
        graphics.fillRect(0, 0, 320, 240);
        this._colorFather.setColor();
        graphics.setColor(this._colorFather._curColor, this._colorFather._curColor, this._colorFather._curColor);
        if (this._colorFather._curColor < 20) {
            ++this._drawOne;
            if (this._drawOne == 3) {
                this._colorFather._curColor = 0;
                this._isStartOverture = true;
                PzgScene._curSoundId = 6;
                Function.changeSoundState(PzgScene._curSoundId, -1);
            }
        }
        if (this._drawOne == 0) {
            graphics.drawString("\u6d41\u52a8\u7684\u6c34\u6ca1\u6709\u5f62\u72b6", 160, 120, 0x10 | 1);
        } else if (this._drawOne == 1) {
            graphics.drawString("\u6f02\u6d41\u7684\u98ce\u627e\u4e0d\u5230\u8e2a\u8ff9", 160, 120, 0x10 | 1);
        } else if (this._drawOne == 2) {
            graphics.drawString("\u4efb\u4f55\u6848\u4ef6\u7684\u63a8\u7406\u90fd\u53d6\u51b3\u4e8e\u5fc3", 160, 120, 0x10 | 1);
        }
    }

    private void updataPressKey() {
        if (GameMainLogic.isPressCancelKey()) {
            if (!this._startPress) {
                this.changeState(3);
                this._insetMenu = true;
                PzgScene._curSoundId = 6;
                Function.setSoundValue(_soundNum * 20, _soundNum);
                Function.changeSoundState(PzgScene._curSoundId, -1);
                _alpha = 0;
                this._namex = 160;
                this._flagx = 160;
                this._namey = 97;
                this._flagy = 97;
            }
            return;
        }
        int n = KeyHandler.instance().getCurKey();
        switch (n) {
            case 16: {
                if (!this._startPress || this._insetMenu) break;
                this._insetMenu = true;
                _alpha = 255;
                KeyHandler.instance().resetKeyBuff();
            }
        }
    }

    private void gamePressKey(Graphics graphics) {
        Function.fillScreen(graphics, 0, 0, 320, 240, 0);
        if (PzgScene._w1Image == null) {
            try {
                PzgScene._w1Image = Image.createImage((String)"/res/w1.png");
                PzgScene._w2Image = Image.createImage((String)"/res/w2.png");
                PzgScene._w3Image = Image.createImage((String)"/res/w3.png");
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        graphics.drawImage(PzgScene._w1Image, 320 - PzgScene._w1Image.getWidth() >> 1, 0, 0);
        if (!this._insetMenu) {
            if (this._isStartOverture) {
                this._colorAlph -= 10;
                if (!this._insetMenu && this._colorAlph <= 0) {
                    this._colorAlph = 0;
                    this._roleX += PzgScene._w4Image.getWidth() / 6;
                    this._roleY += PzgScene._w4Image.getHeight() / 6;
                }
                if (!this._insetMenu && this._roleX >= PzgScene._w4Image.getWidth()) {
                    this._roleX = PzgScene._w4Image.getWidth();
                    this._roleY = PzgScene._w4Image.getHeight();
                    this._namex += 20;
                    this._flagx -= 20;
                    if (!this._insetMenu && this._namex >= 150) {
                        this._namex = 150;
                        this._flagx = 150;
                        this._startPress = true;
                        ++this._tisk;
                    }
                }
                graphics.drawImage(PzgScene._w4Image, 69, 260, 0x20 | 1);
                GameFunction.initAlphaArray(0xFFFFFF, this._colorAlph, 1);
                GameFunction.drawAlpha1(graphics, 0, 0, 320, 240);
            } else {
                this.gameHeadProcess(graphics);
            }
        }
        if (this._insetMenu && this._colorAlph <= 0) {
            this._namey -= 10;
            this._flagy -= 10;
            this._colorAlph = 0;
            if (this._flagy <= 97) {
                this._namey = 97;
                this._flagy = 97;
                this.changeState(3);
            }
        }
        if (this._insetMenu) {
            graphics.drawImage(PzgScene._w4Image, 69, 260, 0x20 | 1);
        }
        graphics.drawImage(PzgScene._w3Image, this._namex - 17, this._namey, 17);
        graphics.drawImage(PzgScene._w2Image, this._flagx + 56, this._flagy - 5, 17);
        if (this._startPress && !this._insetMenu && this._tisk % 5 == 0) {
            graphics.setColor(0xFFFFFF);
            graphics.setFont(_font3);
            graphics.drawString("\u63095\u952e\u7ee7\u7eed", 160, 220, 17);
        } else if (!this._startPress && !this._insetMenu) {
            graphics.setColor(0xFFFFFF);
            graphics.setFont(_font3);
            graphics.drawString("\u8df3\u8fc7", 320, 240, 8 | 0x20);
        }
    }

    private void gameSound(Graphics graphics) {
    }

    private void gameMenu(Graphics graphics) {
        int n = KeyHandler.instance().getCurKey();
        if (GameMainLogic.isPressConfirmSoftKey()) {
            this.menuConfirmHandle(this._menuItem);
        }
        int n2 = _menuSpt.length;
        KeyHandler.instance().resetKeyBuff();
        switch (n) {
            case 1: {
                --this._menuItem;
                if (this._menuItem >= 0) break;
                this._menuItem = n2 - 1;
                break;
            }
            case 2: {
                ++this._menuItem;
                if (this._menuItem < n2) break;
                this._menuItem = 0;
                break;
            }
            case 16: {
                this.menuConfirmHandle(this._menuItem);
            }
        }
    }

    private final void startNewGame() {
        GameMainLogic.getInstance().startRecordGameTime();
        this.startupLoadLevel();
        PzgScene.resetFoucsPro();
        GameMainLogic._gameScenario = 0;
        PzgScene.getInstance().unlockCamera();
        PzgScene.getInstance();
        Scene._curSceneID = 1;
        PzgScene.getInstance();
        Scene._nextSceneID = 1;
        PzgScene.getInstance()._isSetCamaraFoucs = false;
        SceneActorInfo.resetAllRecordSceneActorID();
        AnalyzePuzzle.resetLifeNumber();
    }

    private final void menuConfirmHandle(int n) {
        switch (n) {
            case 0: {
                if (GameRms.isExistRecord()) {
                    this._gameMenu = GameMenu.getInstance(this);
                    this._gameMenu.initChooseStyle("\u662f\u5426\u8bfb\u53d6\u5b58\u6863", _gameM);
                    break;
                }
                this.initGamePara();
                PzgScene._curSoundId = 1;
                Function.changeSoundState(PzgScene._curSoundId, -1);
                break;
            }
            case 1: {
                this._pageIndex = 19;
                this.initGameLoad();
                break;
            }
            case 2: {
                this._pageIndex = 12;
                this.initSoundPage();
                break;
            }
            case 4: {
                this.changeState(9);
                break;
            }
            case 5: {
                this.changeState(10);
                break;
            }
            case 6: {
                Function._isContinue = true;
                Function.stopSound();
                this._pageIndex = 13;
                _isInMenu = false;
                break;
            }
            case 3: {
                Function._isContinue = true;
                Function.stopSound();
                this.changeState(29);
            }
        }
    }

    public final void qqSmsGameTitle(Graphics graphics) {
        if (this._loadProcess == 0) {
            this.loadGameLogo();
            ++this._loadProcess;
            this._stime = System.currentTimeMillis();
        } else if (this._loadProcess == 1) {
            graphics.setClip(0, 0, 320, 240);
            graphics.setColor(16749568);
            graphics.fillRect(0, 0, 320, 240);
            graphics.drawImage(_image[0], 160, (240 - _image[0].getHeight()) / 2, 1 | 0x10);
            this._ctime = System.currentTimeMillis();
            if (this._ctime - this._stime > 1700L) {
                ++this._loadProcess;
                this._stime = System.currentTimeMillis();
                GameInterface._image[0] = null;
            }
        } else if (this._loadProcess == 2) {
            graphics.setClip(0, 0, 320, 240);
            graphics.setColor(0xFFFFFF);
            graphics.fillRect(0, 0, 320, 240);
            graphics.drawImage(_image[1], 160, 120 - (_image[1].getHeight() >> 1), 1 | 0x10);
            this._ctime = System.currentTimeMillis();
            if (this._ctime - this._stime > 1700L) {
                ++this._loadProcess;
                this._stime = System.currentTimeMillis();
                GameInterface._image[1] = null;
            }
        } else if (this._loadProcess == 3) {
            Function.fillScreen(graphics, 0, 0, 320, 240, 0);
            this.callEnterGame();
        }
    }

    private final void loadGameLogo() {
        _image = new Image[2];
        int n = 0;
        while (n < _image.length) {
            try {
                GameInterface._image[n] = R.loadPng("/res/logo.bin", n);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            ++n;
        }
    }

    private void loadGlobalData() {
        if (this._mainLogic.loadGlobalData()) {
            this.initialize();
        }
    }

    private final void initialize() {
        this._menuItem = 0;
        C_GAME_LOAD = SptSet.load("/res/spt.bin", 80, 1);
        C_GAME_LOAD_NAME = SptSet.load("/res/spt.bin", 81, 1);
        C_GAME_PANEL = SptSet.load("/res/spt.bin", 73, 1);
        S_GAME_MENU = SptSet.load("/res/spt.bin", 91, 1);
        Animation.load("/res/ani.bin", 29, 1);
        Animation.load("/res/ani.bin", 10, 1);
        Animation.load("/res/ani.bin", 28, 1);
        Animation.load("/res/ani.bin", 32, 1);
        if (C_HANDSET_KIND == 2) {
            int n = 50;
            while (n < 65) {
                Animation.load("/res/ani.bin", n, 1);
                ++n;
            }
        }
        PzgScene._positionAni = Animation.load("/res/ani.bin", 48, 1);
        try {
            PzgScene._mapImage = Image.createImage((String)"/res/lmap.png");
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        if (C_HANDSET_KIND == 1) {
            Animation.load("/res/ani.bin", 70, 1);
        }
        int n = 71;
        while (n < 73) {
            Animation.load("/res/ani.bin", n, 1);
            ++n;
        }
        int n2 = 76;
        while (n2 < 80) {
            Animation.load("/res/ani.bin", n2, 1);
            ++n2;
        }
        Animation.load("/res/ani.bin", 83, 1);
        C_GAME_CLUE = SptSet.getBaseSptSet(71);
        C_GAME_PROPS = SptSet.getBaseSptSet(72);
        C_GAME_SURVEY = Animation.getAnimation(76);
        C_GAME_JUDGE = Animation.getAnimation(77);
        try {
            PzgScene._w1Image = Image.createImage((String)"/res/w1.png");
            PzgScene._w2Image = Image.createImage((String)"/res/w2.png");
            PzgScene._w3Image = Image.createImage((String)"/res/w3.png");
            PzgScene._w4Image = Image.createImage((String)"/res/w4.png");
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this._pageIndex = 11;
    }

    public void initGameHelp() {
        this._helpAboutTitle = "\u5e2e\u52a9";
        this._text = GameFunction.readTextFile("/res/string.bin", 0, _info);
        this._titleY = 30;
        this._next = 0;
    }

    public final void paintInMenu(Graphics graphics) {
        GameFunction.initAlphaArray(14141108, 80, 1);
        GameFunction.drawAlpha1(graphics, 8, 25, 300, 190);
        graphics.setClip(0, 0, 320, 240);
        graphics.setColor(5127214);
        graphics.drawRoundRect(6, 23, 303, 193, 10, 10);
        graphics.drawRoundRect(7, 24, 301, 191, 10, 10);
    }

    public final void gameHelpAbout(Graphics graphics) {
        int n;
        int n2;
        this.drawMenuBK(graphics);
        this.paintInMenu(graphics);
        Function.draw3DString(graphics, this._helpAboutTitle, 160, this._titleY, 0x10 | 1, 0xFFFFFF, 0);
        if (_info[0] > _info[1]) {
            n2 = this._next / _info[1] + 1;
            n = 1 + _info[0] / _info[1];
            StringBuffer stringBuffer = new StringBuffer().append(n2).append("/").append(n);
            graphics.setClip(0, 0, 320, 240);
            graphics.setColor(0xFFFFFF);
            graphics.drawString(stringBuffer.toString(), 160, 240 - Function.C_WORD_H - 13, 0x20 | 1);
        }
        graphics.setClip(0, 0, 320, 240);
        graphics.setColor(0xFFFFFF);
        n2 = Function.drawHelpAboutString(graphics, this._text, this._next, _info[1], 160, _info[3], _info[4], 1 | 0x10) ? 1 : 0;
        n = GameMainLogic.getCurKey();
        if (n == 2) {
            if (n2 == 0) {
                this._next += _info[1];
            }
        } else if (n == 1 && this._next > 0) {
            this._next -= _info[1];
        }
    }

    private void returnFromHelpAbout() {
        if (GameMainLogic.isPressCancelKey()) {
            this.changeState(3);
        }
        GameMainLogic.resetCurKey();
    }

    public void initGameAbout() {
        this._helpAboutTitle = "\u5173\u4e8e";
        this._text = GameFunction.readTextFile("/res/string.bin", 1, _info);
        this._next = 0;
        this._titleY = 30;
    }

    private final void resetExecuteProcess() {
        this._executeProcess = 0;
        this.resetLoad();
    }

    private void gameLoadGlobal(Graphics graphics) {
        ++this._point;
        if (this._point > 6) {
            this._point = 0;
        }
        Function.fillScreen(graphics, 0, 0, 320, 240, 0);
        graphics.setColor(0xFFFFFF);
        graphics.drawString("\u52a0\u8f7d\u6570\u636e\u4e2d", 160, 180, 1 | 0x10);
        int n = 0;
        while (n < this._point) {
            graphics.drawString(".", 160 + Function.C_WORD_W * 5 / 2 + n * Function.C_WORD_W / 2, 180, 4 | 0x10);
            ++n;
        }
        this.loadGlobalData();
    }

    private void gameLoading(Graphics graphics) {
        this.drawMenuBK(graphics);
        this._mainLogic.loadLevelData();
        this.drawProcess(graphics);
        this.drawClwe(graphics);
    }

    private void upDateLoadPrecoss() {
        this._progressBar += 4;
        if (this._progressBar >= 100) {
            this._progressBar = 100;
        }
        this._loadProcess = this._progressBar;
    }

    public void resetLoad() {
        this._progressBar = 0;
        this._loadProcess = 0;
    }

    private final void drawProcess(Graphics graphics) {
        this.upDateLoadPrecoss();
        if (C_GAME_LOAD_NAME != null) {
            C_GAME_LOAD_NAME.draw(graphics, 40, 180, 0, 0);
            Function.fillScreen(graphics, 0, 180, 13 + 240 * this._progressBar / 100 + 15, 30, 0);
            Function.fillScreen(graphics, 13 + C_GAME_LOAD.getSptWidth(0) - 10 + 160 * this._progressBar / 100, 180, 160, 30, 0);
            graphics.setClip(0, 0, 320, 240);
            int n = 0;
            n = -15;
            C_GAME_LOAD.draw(graphics, 13 + 240 * this._progressBar / 100, 150 + n, 0, 0);
        }
    }

    private void drawClwe(Graphics graphics) {
        Function.drawRollStrings(graphics, "\u5c0f\u63d0\u793a: " + this._sceneTip, 40, 30, 120, 0xFFFFFF);
    }

    private void gameExit(Graphics graphics) {
        Function.fillScreen(graphics, 0, 0, 320, 240, 0);
        Function.draw3DString(graphics, "\u662f\u5426\u9000\u51fa", 160, 120, 0x10 | 1, 0xFFFFFF, 0);
        int n = 238;
        Function.draw3DString(graphics, "\u662f", 2, n, 4 | 0x20, 0xFFFFFF, 0);
        Function.draw3DString(graphics, "\u5426", 318, n, 8 | 0x20, 0xFFFFFF, 0);
        if (GameMainLogic.isPressConfirmSoftKey()) {
            GameMainLogic._midlet.notifyDestroyed();
        } else if (GameMainLogic.isPressCancelKey()) {
            if (_isInMenu) {
                Function.changeSoundState(PzgScene._curSoundId, -1);
                this._mainLogic.changePage((byte)2);
            } else {
                PzgScene._curSoundId = 6;
                Function.changeSoundState(PzgScene._curSoundId, -1);
                this.changeState(3);
            }
        }
        GameMainLogic.resetCurKey();
    }

    private final void gameOver(Graphics graphics) {
        this.drawMenuBK(graphics);
        Function.draw3DString(graphics, "\u60a8\u5df2\u6218\u8d25", 160, 90, 0x10 | 1, 0xFFFFFF, 10512401);
        Function.draw3DString(graphics, "\u662f\u5426\u8bfb\u53d6\u5b58\u6863\uff1f", 160, 115, 0x10 | 1, 0xFFFFFF, 10512401);
        Function.draw3DString(graphics, "\u662f", 3, 237, 0x20 | 4, 0xFFFFFF, 10512401);
        Function.draw3DString(graphics, "\u5426", 317, 237, 0x20 | 8, 0xFFFFFF, 10512401);
        if (GameMainLogic.isPressConfirmSoftKey()) {
            this.changeState(19);
            this.initGameLoad();
        }
        if (GameMainLogic.isPressCancelKey()) {
            this.changeState(3);
        }
        GameMainLogic.resetCurKey();
    }

    private void gamePassLevel(Graphics graphics) {
        this.startupLoadLevel();
    }

    private void gamePlaySoundSel(Graphics graphics) {
        this.drawSoundPage(graphics);
        this.keyForSound();
    }

    private void gamePlaySoundTip(Graphics graphics) {
        String string;
        String string2;
        this.drawDefaultBackground(graphics);
        Function.draw3DString(graphics, "\u662f\u5426\u5f00\u542f\u58f0\u97f3", 160, 120, 0x10 | 1, 0xFFFFFF, 0);
        graphics.setColor(0xFFFF00);
        graphics.drawString("\u5173\u95ed\u58f0\u97f3\u53ef\u63d0\u9ad8\u6e38\u620f\u901f\u5ea6", 160, 165, 0x10 | 1);
        int n = 238;
        int n2 = 0xFFFFFF;
        int n3 = 0;
        if (this._mainLogic.getConfirmPos() == 0) {
            string2 = "\u662f";
            string = "\u5426";
        } else {
            string2 = "\u5426";
            string = "\u662f";
        }
        Function.draw3DString(graphics, string2, 2, n, 4 | 0x20, n2, n3);
        Function.draw3DString(graphics, string, 318, n, 8 | 0x20, n2, n3);
        boolean bl = false;
        if (GameMainLogic.isPressConfirmKey()) {
            Function.startupSound(true, _soundNum);
            _soundNum = 2;
            Function.setSoundValue(_soundNum * 20, _soundNum);
            GameInterface.openSound();
            bl = true;
        } else if (GameMainLogic.isPressCancelKey()) {
            Function.startupSound(false, _soundNum);
            _soundNum = 0;
            GameInterface.closeSound();
            bl = true;
        }
        if (bl) {
            this._startTime = System.currentTimeMillis();
            GameMainLogic.resetCurKey();
            this.changeState(14);
        }
    }

    private final void gameConfirmClearRecord(Graphics graphics) {
    }

    public void startupLoadGlobal() {
        this._pageIndex = 1;
        this.resetExecuteProcess();
    }

    public void startupLoadLevel() {
        this._pageIndex = 4;
        this._sceneTip = CLWE[Function.Random(CLWE.length, true)];
        this.resetExecuteProcess();
    }

    public void callEnterGame() {
        this.startupLoadGlobal();
    }

    public void drawDefaultBackground(Graphics graphics) {
        Function.fillScreen(graphics, 0, 0, 320, 240, 0);
    }

    public final void changeState(int n) {
        this._pageIndex = n;
        if (this._pageIndex == 9) {
            this.initGameHelp();
        } else if (this._pageIndex == 10) {
            this.initGameAbout();
        } else if (this._pageIndex == 3) {
            // empty if block
        }
    }

    public void finishHandle() {
    }

    public void initGameLoad() {
        this.formatRmsPage();
        this._loadState = 0;
        this.initRmsPage();
        this._title = new String[]{TITLES[0]};
    }

    public void initGameSave() {
        this.formatRmsPage();
        this._loadState = 1;
        this.initRmsPage();
        this._title = new String[]{TITLES[1]};
    }

    public void gameRmsPage(Graphics graphics) {
        this.paintRmsPageInfo(graphics);
    }

    public void updateForRmsPage() {
        if (GameMainLogic.isPressConfirmKey()) {
            if (GameRms.isExistRecord(this._curRmsIndex)) {
                GameRms.loadGame(this._curRmsIndex);
                AnalyzePuzzle.resetLifeLength();
                int[] nArray = new int[]{GameRms._rmsGameTimeHour[this._curRmsIndex], GameRms._rmsGameTimeMinut[this._curRmsIndex]};
                GameMainLogic.getInstance().setContinueGameTime(nArray);
                this.startupLoadLevel();
            }
            GameMainLogic.resetCurKey();
            return;
        }
        if (GameMainLogic.isPressCancelKey()) {
            this.changeState(3);
            GameMainLogic.resetCurKey();
            return;
        }
        int n = GameMainLogic.getCurKey();
        GameMainLogic.resetCurKey();
        switch (n) {
            case 4: {
                this.preRmsIndex();
                break;
            }
            case 8: {
                this.nextRmsIndex();
                break;
            }
            case 1: {
                break;
            }
        }
    }

    private String getSaveName(int n) {
        if (GameRms._rmsGameScenario[n] >= 95) {
            return "\u7b2c\u4e8c\u7ae0";
        }
        if (GameRms._rmsGameScenario[n] >= 200) {
            return "\u7b2c\u4e09\u7ae0";
        }
        return "\u7b2c\u4e00\u7ae0";
    }

    private void paintRmsPageInfo(Graphics graphics) {
        int n = 0;
        while (n < 2) {
            boolean bl = false;
            GameFunction.initAlphaArray(14409431, 60, 1);
            GameFunction.drawAlpha1(graphics, this._drawStartX, 37 + (this._drawH + this._space) * n, this._drawW, this._drawH);
            graphics.setColor(5860205);
            graphics.drawRoundRect(this._drawStartX + 1, 38 + (this._drawH + this._space) * n, this._drawW - 3, this._drawH - 3, 10, 10);
            graphics.drawRoundRect(this._drawStartX + 2, 39 + (this._drawH + this._space) * n, this._drawW - 5, this._drawH - 5, 10, 10);
            graphics.setClip(0, 0, 320, 240);
            if (this._curRmsIndex == n) {
                GameFunction.initAlphaArray(16626313, 60, 1);
                GameFunction.drawAlpha1(graphics, this._drawStartX + 3, 40 + (this._drawH + this._space) * n, this._drawW - 6, this._drawH - 6);
            }
            if (!GameRms._existRms[n]) {
                graphics.setColor(0);
                graphics.drawString("\u65e0\u5b58\u6863", 160, 40 + n * (this._drawH + this._space) + this._drawH / 3, 1 | 0x10);
            } else {
                graphics.setColor(0);
                graphics.drawString(this.getSaveName(n), this._drawStartX + 5, 40 + n * (this._drawH + this._space), 4 | 0x10);
                graphics.drawString(PzgScene._sceneName[GameRms._rmsGameSceneID[n]], 160, 40 + n * (this._drawH + this._space) + this._drawH / 2, 1 | 0x10);
                GameFunction.drawTime(graphics, GameRms._rmsGameTimeHour[n], GameRms._rmsGameTimeMinut[n], this._drawStartX + 80, 40 + n * (this._drawH + this._space));
            }
            ++n;
        }
    }

    private void formatRmsPage() {
        this._titleX = 80;
        this._titleY = 15;
        this._drawStartX = 66;
        this._drawStartY = this._titleY + 30;
        this._space = 10;
        this._drawW = 186;
        this._drawH = 65;
        this._rmsPageTimeX = 320 - this._drawStartX - 5;
        this._roleStartY = this._drawStartY + this._drawH - 15;
        this._roleStartX = this._drawStartX + 25 + Function.C_WORD_W * 2;
        this._roleSpace = (320 - this._drawStartX - this._roleStartX) / 4;
    }

    public void initRmsPage() {
    }

    public void preRmsIndex() {
        --this._curRmsIndex;
        if (this._curRmsIndex < 0) {
            this._curRmsIndex = 1;
        }
    }

    public void nextRmsIndex() {
        ++this._curRmsIndex;
        if (this._curRmsIndex > 1) {
            this._curRmsIndex = 0;
        }
    }

    public int getCurRmsIndex() {
        return this._curRmsIndex;
    }

    public void initSoundPage() {
        this._titleY = 34;
        this._soundButtonX = 106;
        this._soundButtonSpace = 40;
        this._soundButtonY = 144;
        if (_soundNum > 0) {
            GameInterface.openSound();
        } else {
            GameInterface.closeSound();
        }
    }

    public void drawSoundPage(Graphics graphics) {
        Function.draw3DString(graphics, TITLES[2], 160, this._titleY + 4, 0x10 | 1, 0xFFFFFF, 0);
        Function.draw3DString(graphics, "\u97f3\u91cf", this._soundButtonX + 10, 120, 0x10 | 1, 0xFFFFFF, 0);
        Function.draw3DString(graphics, 20 * _soundNum + "", this._soundButtonX + 15 + this._soundButtonSpace, 120, 0x10 | 1, 0xFFFFFF, 0);
        this.drawLife(graphics);
    }

    public void drawLife(Graphics graphics) {
        this._curLifeLength = _soundNum * 23;
        graphics.setClip(0, 0, 320, 240);
        graphics.setColor(6845039);
        graphics.drawRect(106, this._soundButtonY + 1, 117, 9);
        graphics.setColor(5842992);
        graphics.fillRect(107, this._soundButtonY + 2, 116, 7);
        graphics.setColor(5216853);
        graphics.fillRect(107, this._soundButtonY + 2, this._curLifeLength, 7);
        graphics.setColor(10806948);
        graphics.drawLine(107, this._soundButtonY + 3, 106 + this._curLifeLength, this._soundButtonY + 3);
        graphics.setColor(3432752);
        graphics.drawRect(107, this._soundButtonY + 2, this._curLifeLength, 6);
        graphics.setColor(0xFFFFFF);
        graphics.drawLine(107, this._soundButtonY, 222, this._soundButtonY);
        graphics.drawLine(107, this._soundButtonY + 9, 222, this._soundButtonY + 9);
        graphics.drawLine(105, this._soundButtonY + 1, 105, this._soundButtonY + 9);
        graphics.drawLine(224, this._soundButtonY + 1, 224, this._soundButtonY + 9);
        graphics.drawLine(97, this._soundButtonY + 1, 91, this._soundButtonY + 4);
        graphics.drawLine(91, this._soundButtonY + 5, 97, this._soundButtonY + 9);
        graphics.drawLine(233, this._soundButtonY + 1, 239, this._soundButtonY + 4);
        graphics.drawLine(240, this._soundButtonY + 5, 233, this._soundButtonY + 9);
    }

    public void keyForSound() {
        if (GameMainLogic.isPressConfirmKey()) {
            // empty if block
        }
        if (GameMainLogic.isPressCancelKey()) {
            this.changeState(3);
        }
        int n = GameMainLogic.getCurKey();
        switch (n) {
            case 1: {
                if (--_soundNum <= 0) {
                    _soundNum = 0;
                    GameInterface.closeSound();
                }
                Function.setSoundValue(_soundNum * 20, _soundNum);
                Function.continuePlaySound();
                break;
            }
            case 2: {
                if (++_soundNum > 0) {
                    GameInterface.openSound();
                }
                if (_soundNum >= 5) {
                    _soundNum = 5;
                }
                Function.setSoundValue(_soundNum * 20, _soundNum);
                Function.continuePlaySound();
            }
        }
        GameMainLogic.resetCurKey();
    }

    public static void openSound() {
        _isOpenSound = true;
    }

    public static void closeSound() {
        _isOpenSound = false;
    }

    private void drawMenu(Graphics graphics) {
        int n = 0;
        int n2 = 20;
        this.drawMenuBK(graphics);
        this.drawGameTitle(graphics, n2);
        this.gamePressKey(graphics);
        n = 160;
        n2 = 200;
        int n3 = Function.C_WORD_W * 7;
        if (this._menuItem == 3) {
            GameInterface.C_GAME_MENU[this._menuItem] = "< " + GameMainLogic._midlet.getAppProperty("GameCenterName") + " >";
            Function.draw3DString(graphics, C_GAME_MENU[this._menuItem], n + 82, n2, 1 | 0x10, 0xFF0000, 0);
        } else {
            S_GAME_MENU.draw(graphics, n - _menuSptOffX[this._menuItem], n2, _menuSpt[this._menuItem], 0, 0x10 | 1);
            S_GAME_MENU.draw(graphics, n + 82 + S_GAME_MENU.getSptWidth(_menuSpt[this._menuItem]) / 2 + 8, n2 + 8, 8, 0, 0x10 | 1);
            S_GAME_MENU.draw(graphics, n + 82 - S_GAME_MENU.getSptWidth(_menuSpt[this._menuItem]) / 2 - 10, n2 + 7, 9, 0, 0x10 | 1);
        }
    }

    public void drawMenuBK(Graphics graphics) {
        graphics.setClip(0, 0, 320, 240);
        Function.fillScreen(graphics, 0, 0, 320, 240, 0);
    }

    private void drawGameTitle(Graphics graphics, int n) {
        Function.draw3DString(graphics, "\u5c11\u5e74\u540d\u4fa6\u63a2", 160, 80, 0x10 | 1, 0xFFFFFF, 0);
        graphics.setColor(0xFFFFFF);
        graphics.drawString("- \u88ab\u8bc5\u5492\u7684\u8c0b\u6740", 280, 110, 0x10 | 8);
    }

    public void cancelHandle() {
        this._menu = null;
        this._gameMenu = null;
        this.startNewGame();
    }

    public void resultHandle(int n) {
        this._menu = null;
        this._gameMenu = null;
        if (n == 0) {
            this._pageIndex = 19;
            PzgScene._w1Image = null;
            PzgScene._w2Image = null;
            PzgScene._w3Image = null;
            this.initGameLoad();
        } else {
            this.changeToCG();
            PzgScene._curSoundId = 1;
            Function.changeSoundState(PzgScene._curSoundId, -1);
        }
    }

    private void initGamePara() {
        this.changeToCG();
    }

    private void gameItemSelect(Graphics graphics) {
        Function.fillScreen(graphics, 0, 0, 320, 240, 0);
        int n = 0;
        while (n < _paraInfo.length) {
            if (this._infoItem == n) {
                Function.draw3DString(graphics, _paraInfo[n], this._infoX, this._infoY + n * Function.C_WORD_H, 0x10 | 4, 0xFFFFFF, 0);
                Function.draw3DString(graphics, String.valueOf(_paraValue[n]), 320 - this._infoX, this._infoY + n * Function.C_WORD_H, 0x10 | 8, 0xFFFFFF, 0);
            } else {
                Function.draw3DString(graphics, _paraInfo[n], this._infoX, this._infoY + n * Function.C_WORD_H, 0x10 | 4, 0, 0xFFFFFF);
                Function.draw3DString(graphics, String.valueOf(_paraValue[n]), 320 - this._infoX, this._infoY + n * Function.C_WORD_H, 0x10 | 8, 0, 0xFFFFFF);
            }
            ++n;
        }
        Function.draw3DString(graphics, "\u4e0b\u4e00\u9879", 2, 238, 0x20 | 4, 0xFFFFFF, 0);
        Function.draw3DString(graphics, "\u7ee7\u7eed", 318, 238, 0x20 | 8, 0xFFFFFF, 0);
        int n2 = GameMainLogic.getCurKey();
        switch (n2) {
            case 262144: {
                if (++this._infoItem > _paraInfo.length) {
                    this._infoItem = 0;
                }
                this._valueIndex = 0;
                GameMainLogic.resetCurKey();
                break;
            }
            case 524288: {
                int n3;
                boolean[] blArray;
                int n4 = 0;
                while (n4 < _paraValue.length) {
                    if (_paraValue[n4] != 0) break;
                    ++n4;
                }
                if (n4 >= _paraValue.length) {
                    _openPramInfo = false;
                    _closePartInfo = true;
                }
                this.startNewGame();
                ClueList clueList = PzgScene.getInstance()._analyzePuzzle._clueList;
                if (_paraValue[2] != 0) {
                    blArray = ClueList.getToolList();
                    n3 = 0;
                    while (n3 < ClueList.getToolList().length) {
                        blArray[n3] = true;
                        ++n3;
                    }
                }
                if (_paraValue[3] != 0) {
                    blArray = ClueList.getClueList();
                    n3 = 1;
                    while (n3 < 27) {
                        blArray[n3] = true;
                        ++n3;
                    }
                }
                PzgScene.getInstance()._reasoningInterface.addNewClue(PzgScene.getInstance()._analyzePuzzle._clueList.getCurrentName(52));
                PzgScene.getInstance()._reasoningInterface.addNewClue(PzgScene.getInstance()._analyzePuzzle._clueList.getCurrentName(55));
                GameMainLogic._gameScenario = _paraValue[1];
                GameMainLogic.resetCurKey();
                break;
            }
            default: {
                this.gameParaSet(this.getNumberOfKey(n2));
                GameMainLogic.resetCurKey();
            }
        }
    }

    private void gameParaSet(int n) {
        if (n < 0) {
            return;
        }
        if (this._valueIndex > 0) {
            int n2 = this._infoItem;
            _paraValue[n2] = _paraValue[n2] * 10;
        }
        GameInterface._paraValue[this._infoItem] = n + _paraValue[this._infoItem];
        ++this._valueIndex;
        if (this._valueIndex > 3) {
            this._valueIndex = 0;
            GameInterface._paraValue[this._infoItem] = 0;
        }
    }

    private int getNumberOfKey(int n) {
        switch (n) {
            case 1024: {
                return 1;
            }
            case 4: {
                return 2;
            }
            case 4096: {
                return 3;
            }
            case 1: {
                return 4;
            }
            case 16: {
                return 5;
            }
            case 2: {
                return 6;
            }
            case 32768: {
                return 7;
            }
            case 8: {
                return 8;
            }
            case 131072: {
                return 9;
            }
            case 512: {
                return 0;
            }
        }
        return -1;
    }

    private void changeToCG() {
        SptSet.setImageBackgroundColor(0xFF00FF);
        PromptInterface._integral = 0;
        this._pageIndex = 21;
        this._caseCG = new CaseCG();
        this._caseCG.load();
        PzgScene.getInstance().resetNewGame();
        this._mainLogic.resetGamePlayingTime();
        PzgScene._w1Image = null;
        PzgScene._w2Image = null;
        PzgScene._w3Image = null;
    }

    public final void gLogo(Graphics graphics) {
        switch (this._gLogoProcess) {
            case 0: {
                int n = Function.getSoundKind();
                GameMainLogic.getInstance();
                this._gLogo = Logo.createLogos(3, this, n, 320, 240, GameMainLogic._midlet);
                ++this._gLogoProcess;
                break;
            }
            case 1: {
                Function.fillScreen(graphics, 0, 0, 320, 240, 0);
                this._gLogo.paint(graphics);
                if (!this._gLogo.getIfFinish()) break;
                this.finishGLogo();
                this._gLogo = null;
            }
        }
    }

    public final void finishGLogo() {
        this._loadProcess = 0;
        this._pageIndex = 0;
    }

    public void browseWap(String string, boolean bl) {
        try {
            GameMainLogic.getInstance();
            GameMainLogic._midlet.platformRequest(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void mortGameTip(Graphics graphics) {
        String string;
        String string2;
        this.drawDefaultBackground(graphics);
        int n = 0;
        while (n < str_into.length) {
            Function.draw3DString(graphics, str_into[n], 160, 120 + (n - 1) * Function.C_WORD_H, 0x10 | 1, 0xFFFFFF, 0);
            ++n;
        }
        int n2 = 232;
        int n3 = 0xFFFFFF;
        int n4 = 0;
        if (this._mainLogic.getConfirmPos() == 0) {
            string2 = "\u662f";
            string = "\u5426";
        } else {
            string2 = "\u5426";
            string = "\u662f";
        }
        Function.draw3DString(graphics, string2, 10, n2, 4 | 0x20, n3, n4);
        Function.draw3DString(graphics, string, 310, n2, 8 | 0x20, n3, n4);
        boolean bl = false;
        if (GameMainLogic.isPressConfirmSoftKey()) {
            this.changeState(3);
            Function._isContinue = false;
            GameMainLogic._smsUi.linkQQGameUrl();
            bl = true;
        } else if (GameMainLogic.isPressCancelKey()) {
            this.changeState(3);
            PzgScene._curSoundId = 6;
            Function.changeSoundState(PzgScene._curSoundId, -1);
            bl = true;
        }
        if (bl) {
            GameMainLogic.resetCurKey();
        }
    }

    public void mortGameExit(Graphics graphics) {
        String string;
        String string2;
        Function.fillScreen(graphics, 0, 0, 320, 240, 0);
        if (this._img_last == null) {
            try {
                this._img_last = R.loadPng("/res/logoPng.bin", 13);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        graphics.drawImage(this._img_last, 320 - this._img_last.getWidth() >> 1, 240 - this._img_last.getHeight() >> 1, 0);
        int n = 0;
        while (n < str_exit.length) {
            Function.draw3DString(graphics, str_exit[n], 160, 90 + n * Function.C_WORD_H, 1 | 0x10, 0xFFFFFF, 0);
            ++n;
        }
        int n2 = 232;
        int n3 = 0xFFFFFF;
        int n4 = 0;
        if (this._mainLogic.getConfirmPos() == 0) {
            string2 = str_lr_tip[0];
            string = str_lr_tip[1];
        } else {
            string2 = str_lr_tip[1];
            string = str_lr_tip[0];
        }
        Function.draw3DString(graphics, string2, 10, n2, 4 | 0x20, n3, n4);
        Function.draw3DString(graphics, string, 310, n2, 8 | 0x20, n3, n4);
        boolean bl = false;
        if (GameMainLogic.isPressConfirmSoftKey()) {
            this.browseWap("http://go.i139.cn/gcomm1/portal/spchannel.do?url=http://gamepie.i139.cn/wap/s.do?j=3channel", false);
            bl = true;
        } else if (GameMainLogic.isPressCancelKey()) {
            bl = true;
        }
        if (bl) {
            this._mainLogic.exitGame();
        }
    }

    public int getKeyStatus() {
        int n = GameMainLogic.getCurKey();
        switch (n) {
            case 262144: {
                return 65536;
            }
            case 524288: {
                return 131072;
            }
        }
        return 0;
    }

    static {
        C_GAME_MENU = new String[]{"\u65b0\u7684\u6545\u4e8b", "\u65e7\u7684\u56de\u5fc6", "\u58f0\u97f3", "QQ\u6e38\u620f\u4e2d\u5fc3", "\u5e2e\u52a9", "\u5173\u4e8e", "\u79bb\u5f00\u6e38\u620f"};
        sound = new String[]{"/res/0.mid", "/res/1.mid", "/res/2.mid", "/res/3.mid", "/res/4.mid", "/res/5.mid", "/res/6.mid"};
        _font1 = Font.getFont((int)0, (int)1, (int)16);
        _font2 = Font.getFont((int)0, (int)0, (int)0);
        _font3 = Font.getFont((int)0, (int)0, (int)8);
        _alpha = 255;
        YESORNO = new String[]{"\u662f", "\u5426"};
        _gameM = new String[]{"\u662f", "\u5426"};
        C_HANDSET_KIND = 2;
        _info = new int[5];
        CLWE = new String[]{"\u5728\u573a\u666f\u4e2d\u591a\u591a\u4f7f\u7528\u6570\u5b57\u952e\uff15\u6765\u83b7\u5f97\u610f\u60f3\u4e0d\u5230\u7684\u6863\u6848\u60c5\u62a5\u6216\u8005\u7269\u54c1\u54e6\uff01", "\u5728\u8be2\u95ee\u8fc7\u7a0b\u4e2d\uff0c\u201c\u8ffd\u95ee\u201d\u4e0d\u4f1a\u51cf\u4fe1\u5fc3\u503c\uff0c\u6240\u4ee5\u591a\u591a\u4f7f\u7528\u8ffd\u95ee\u6ca1\u6709\u574f\u5904\u54e6\uff01", "\u6570\u5b57\u952e\u201c1\u201d\u53ef\u4ee5\u5207\u6362\u201c\u8d70\u8def\u201d\u4e0e\u201c\u8dd1\u6b65\u201d\u3002", "\u8c03\u67e5\u8fc7\u7a0b\u4e2d\uff0c\u63d0\u793a\u4eae\u70b9\u53ea\u6709\u9760\u8fd1\u624d\u4f1a\u663e\u793a\u3002", "\u5728\u6e38\u620f\u529f\u80fd\u83dc\u5355\u201c\u8bb0\u4e8b\u672c\u201d\u4e2d\u6709\u4efb\u52a1\u63d0\u793a\uff0c\u53ef\u4ee5\u968f\u65f6\u67e5\u770b\u3002", "\u6e38\u620f\u8fdb\u884c\u4e2d\u5f97\u5230\u65b0\u7684\u7ebf\u7d22\u540e\u53ca\u65f6\u67e5\u770b\u6709\u52a9\u4e8e\u5728\u4e3e\u8bc1\u4e2d\u7684\u4f7f\u7528\u3002", "\u5982\u679c\u662f\u52a8\u4f5c\u8fbe\u4eba\uff0c\u53ef\u4ee5\u201c\u4e0d\u8d70\u5bfb\u5e38\u8def\u201d\u54e6\uff01", "\u6e38\u620f\u4e2d\u4ed4\u7ec6\u9605\u8bfb\u5bf9\u8bdd\u5185\u5bb9\u6709\u52a9\u4e8e\u4e4b\u540e\u7684\u8be2\u95ee\u3002", "\u52a8\u4f5c\u5173\u5361\u5931\u8d25\u540e\u5730\u56fe\u8d77\u70b9\u91cd\u65b0\u5f00\u59cb\u3002", "\u52a8\u4f5c\u5173\u5361\u4e2d\uff0c\u4e00\u5b9a\u8981\u4ed4\u7ec6\u89c2\u5bdf\u518d\u8fdb\u884c\u884c\u52a8\u54e6\uff01", "\u5e73\u65f6\u591a\u6ce8\u610f\u5b58\u6863\u6ca1\u6709\u574f\u5904\u54e6\uff01"};
        TITLES = new String[]{"\u8bfb\u6863", "\u5b58\u6863", "\u58f0\u97f3"};
        _menuSpt = new int[]{4, 0, 6, 3, 7, 5, 2};
        _menuSptOffX = new int[]{-82, -82, -82, -82, -82, -82, -82};
        _paraInfo = new String[]{"\u573a\u666f\u5207\u6362", "\u5267\u60c5\u4e4b\u4fee\u6539", "\u662f\u5426\u5f00\u542f\u5168\u9053\u5177", "\u662f\u5426\u6dfb\u52a0\u5168\u90e8\u7ebf\u7d22"};
        _isZuoBi = false;
        str_exit = new String[]{"\u66f4\u591a\u7cbe\u5f69\u6e38\u620f", "\u5c3d\u5728\u6e38\u620f\u9891\u9053", "wap.xjoys.com"};
        str_into = new String[]{"\u662f\u5426\u8fdb\u5165", "QQ\u6e38\u620f\u4e2d\u5fc3\uff1f"};
        str_lr_tip = new String[]{"\u786e\u8ba4", "\u9000\u51fa"};
    }
}

