/*
 * Decompiled with CFR 0.152.
 */
package module.ekernel.map.mutilayers;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import module.ekernel.map.mutilayers.BaseLayer;
import module.ekernel.map.mutilayers.Pattern;
import module.ekernel.map.mutilayers.TiledLayer;
import module.ekernel.map.mutilayers.UnitsLayer;
import pzg.extend.game.GameInterface;
import pzg.extend.game.GameMainLogic;
import pzg.extend.gameUtil.ImageUtil;

public class Map {
    public int _cw;
    public int _ch;
    public static int _mapx;
    public static int _mapy;
    public static int _bkw;
    public static int _bkh;
    public static int _bktw;
    public static int _bkth;
    protected int _layers;
    protected Image[] _tileKitImg;
    protected Pattern[] _pattern;
    protected String[] _dependUrls;
    protected int[] _dependTypes;
    protected int[] _dependVersions;
    protected BaseLayer[] _layer;
    private static int _prevMapX0;
    private static int _prevMapY0;
    private static int _prevMapX1;
    private static int _prevMapY1;
    private static Image _backImg;
    private static Graphics _gb;

    public Map(int n, int n2) {
        this._cw = n;
        this._ch = n2;
    }

    public void loadData(DataInputStream dataInputStream) {
        try {
            this.loadDependence(dataInputStream);
            this.loadDependElements();
            this.loadMapData(dataInputStream);
            this.setFastMode(this._cw, this._ch);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    protected void loadDependence(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readInt();
        int n2 = dataInputStream.readInt();
        int n3 = dataInputStream.readInt();
        int n4 = dataInputStream.readShort();
        if (n4 > 0) {
            this._dependUrls = new String[n4];
            this._dependTypes = new int[n4];
            this._dependVersions = new int[n4];
            int n5 = 0;
            while (n5 < n4) {
                this._dependUrls[n5] = dataInputStream.readUTF();
                this._dependTypes[n5] = dataInputStream.readInt();
                this._dependVersions[n5] = dataInputStream.readInt();
                ++n5;
            }
        }
    }

    protected void loadDependElements() throws IOException {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (n3 < this._dependTypes.length) {
            switch (this._dependTypes[n3]) {
                case 1: {
                    ++n;
                    break;
                }
                case 22: {
                    ++n2;
                }
            }
            ++n3;
        }
        this._tileKitImg = new Image[n];
        this._pattern = new Pattern[n2];
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        while (n6 < this._dependUrls.length) {
            switch (this._dependTypes[n6]) {
                case 1: {
                    this._tileKitImg[n4++] = this.getResourceImage("/res" + this._dependUrls[n6]);
                    if (!GameMainLogic.WHILT_BACK_FALG || GameInterface.C_HANDSET_KIND != 2) break;
                    this._tileKitImg[--n4] = ImageUtil.getInstacne().effect_black_white(this._tileKitImg[n4]);
                    break;
                }
                case 22: {
                    this._pattern[n5++] = this.loadPattern("/res" + this._dependUrls[n6]);
                }
            }
            ++n6;
        }
    }

    private Image getResourceImage(String string) throws IOException {
        DataInputStream dataInputStream = new DataInputStream(string.getClass().getResourceAsStream(string));
        int n = dataInputStream.readInt();
        int n2 = dataInputStream.readInt();
        int n3 = dataInputStream.readInt();
        short s = dataInputStream.readShort();
        Image image = Image.createImage((InputStream)dataInputStream);
        dataInputStream.close();
        return image;
    }

    private Pattern loadPattern(String string) throws IOException {
        Pattern pattern = new Pattern();
        pattern.loadData(string);
        return pattern;
    }

    protected void loadMapData(DataInputStream dataInputStream) throws IOException {
        _bkw = dataInputStream.readShort();
        _bkh = dataInputStream.readShort();
        _bktw = dataInputStream.readByte();
        _bkth = dataInputStream.readByte();
        this._layers = dataInputStream.readByte();
        this._layer = new BaseLayer[this._layers];
        int n = 0;
        while (n < this._layers) {
            byte by = dataInputStream.readByte();
            switch (by) {
                case 0: {
                    this._layer[n] = new TiledLayer(this);
                    break;
                }
                case 1: {
                    this._layer[n] = new UnitsLayer(this);
                }
            }
            if (this._layer[n] != null) {
                this._layer[n].loadData(dataInputStream);
            }
            ++n;
        }
    }

    public void setPositionInMap(int n, int n2) {
        _mapx = n;
        _mapy = n2;
    }

    public void init() {
        _prevMapX0 = -1;
        _prevMapY0 = -1;
    }

    public int getMapWidth() {
        return _bktw * _bkw;
    }

    public int getMapHeight() {
        return _bkth * _bkh;
    }

    public int getPhyBlock(int n, int n2) {
        BaseLayer baseLayer = null;
        int n3 = 0;
        int n4 = 0;
        while (n4 < this._layers) {
            baseLayer = this._layer[n4];
            n3 = baseLayer.getPhyBlock(n / _bktw, n2 / _bkth);
            if (n3 > 0) break;
            ++n4;
        }
        return n3;
    }

    public void drawToGraphics(Graphics graphics, int n, int n2) {
        this.fastDraw(graphics, _mapx + n, _mapy + n2, this._cw, this._ch);
        int n3 = 0;
        while (n3 < this._layers) {
            BaseLayer baseLayer = this._layer[n3];
            baseLayer.initLastDrawShelter();
            ++n3;
        }
    }

    public void directDrawShelter(Graphics graphics, int n, int n2, int n3, int n4) {
        graphics.setClip(0, 0, this._cw, this._ch);
        int n5 = 0;
        while (n5 < this._layers) {
            BaseLayer baseLayer = this._layer[n5];
            baseLayer.drawShelter(graphics, _mapx, _mapy, this._cw, this._ch, n, n2, n3, n4);
            ++n5;
        }
    }

    public void lastDrawShlter(Graphics graphics) {
        graphics.setClip(0, 0, this._cw, this._ch);
        int n = 0;
        while (n < this._layers) {
            BaseLayer baseLayer = this._layer[n];
            baseLayer.lastDrawShelter(graphics, _mapx, _mapy, this._cw, this._ch);
            ++n;
        }
    }

    public void dispose() {
        int n = 0;
        while (n < this._layers) {
            BaseLayer baseLayer = this._layer[n];
            baseLayer.dispose();
            this._layer[n] = null;
            ++n;
        }
        this._layer = null;
        int n2 = 0;
        while (n2 < this._tileKitImg.length) {
            this._tileKitImg[n2] = null;
            ++n2;
        }
        this._tileKitImg = null;
        int n3 = 0;
        while (n3 < this._pattern.length) {
            this._pattern[n3].release();
            this._pattern[n3] = null;
            ++n3;
        }
        this._pattern = null;
        this._dependUrls = null;
        this._dependTypes = null;
        this._dependVersions = null;
        System.gc();
    }

    protected void fastDraw(Graphics graphics, int n, int n2, int n3, int n4) {
        int n5 = _backImg.getWidth();
        int n6 = _backImg.getHeight();
        _gb.setColor(0xFFFFFF);
        _gb.setClip(0, 0, n5, n6);
        int n7 = n - n % _bktw;
        int n8 = n2 - n2 % _bkth;
        int n9 = n + n5 - _bktw - (n + n5 - _bktw) % _bktw;
        int n10 = n2 + n6 - _bkth - (n2 + n6 - _bkth) % _bkth;
        if (_prevMapX0 < 0) {
            this.mappedDraw(_gb, n7, n8, n9, n10, n5, n6);
            _prevMapX0 = n7;
            _prevMapY0 = n8;
            _prevMapX1 = n9;
            _prevMapY1 = n10;
        } else {
            int n11;
            int n12;
            if (_prevMapX0 != n7) {
                if (_prevMapX0 < n7) {
                    n12 = _prevMapX1 + _bktw;
                    n11 = n9;
                } else {
                    n12 = n7;
                    n11 = _prevMapX0 - _bktw;
                }
                this.mappedDraw(_gb, n12, n8, n11, n10, n5, n6);
                _prevMapX0 = n7;
                _prevMapX1 = n9;
            }
            if (_prevMapY0 != n8) {
                if (_prevMapY0 < n8) {
                    n12 = _prevMapY1 + _bkth;
                    n11 = n10;
                } else {
                    n12 = n8;
                    n11 = _prevMapY0 - _bkth;
                }
                this.mappedDraw(_gb, n7, n12, n9, n11, n5, n6);
                _prevMapY0 = n8;
                _prevMapY1 = n10;
            }
        }
        int n13 = n % n5;
        int n14 = n2 % n6;
        int n15 = (n + n3) % n5;
        int n16 = (n2 + n4) % n6;
        graphics.setClip(0, 0, n3, n4);
        if (n15 > n13) {
            if (n16 > n14) {
                this.copyFromBackImage(graphics, n13, n14, n3, n4, 0, 0);
            } else {
                this.copyFromBackImage(graphics, n13, n14, n3, n4 - n16, 0, 0);
                this.copyFromBackImage(graphics, n13, 0, n3, n16, 0, n4 - n16);
            }
        } else if (n16 > n14) {
            this.copyFromBackImage(graphics, n13, n14, n3 - n15, n4, 0, 0);
            this.copyFromBackImage(graphics, 0, n14, n15, n4, n3 - n15, 0);
        } else {
            this.copyFromBackImage(graphics, n13, n14, n3 - n15, n4 - n16, 0, 0);
            this.copyFromBackImage(graphics, n13, 0, n3 - n15, n16, 0, n4 - n16);
            this.copyFromBackImage(graphics, 0, n14, n15, n4 - n16, n3 - n15, 0);
            this.copyFromBackImage(graphics, 0, 0, n15, n16, n3 - n15, n4 - n16);
        }
    }

    protected void mappedDraw(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = 0;
        while (n7 < this._layers) {
            BaseLayer baseLayer = this._layer[n7];
            baseLayer.drawToBuffer(graphics, n, n2, n3, n4, n5, n6);
            ++n7;
        }
    }

    private final void copyFromBackImage(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        graphics.setClip(n5, n6, n3, n4);
        graphics.drawImage(_backImg, n5 - n, n6 - n2, 4 | 0x10);
    }

    private void setFastMode(int n, int n2) {
        if (_backImg == null) {
            int n3 = n % _bktw == 0 ? n + _bktw : n - n % _bktw + _bktw * 2;
            int n4 = n2 % _bkth == 0 ? this._ch + _bkth : n2 - n2 % _bkth + _bkth * 2;
            _backImg = Image.createImage((int)n3, (int)n4);
            _gb = _backImg.getGraphics();
        }
        this.init();
    }
}

