/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.util.zip;

import de.enough.polish.util.zip.ZipHelper;
import de.enough.polish.util.zip.ZipIntMultShortHashMap;
import java.io.IOException;
import java.io.OutputStream;

public class GZipOutputStream
extends OutputStream {
    public static final int TYPE_DEFLATE = 0;
    public static final int TYPE_GZIP = 1;
    private OutputStream outStream;
    private byte[] outputWindow;
    private byte[] plainDataWindow;
    private int outProcessed;
    private int plainPointer;
    private static final int HASHMAP_COUNT = 4;
    ZipIntMultShortHashMap[] HM = new ZipIntMultShortHashMap[5];
    private byte[] inputBuffer;
    private int inEnd;
    private int inStart;
    private int[] smallCodeBuffer;
    int[] huffmanCode;
    byte[] huffmanCodeLength;
    int[] distHuffCode;
    byte[] distHuffCodeLength;
    private int[] litCount;
    private int[] distCount;
    private int isize;
    private int crc32;
    private int[] crc32Table = new int[256];
    private int status;
    private static final int STREAM_INIT = 0;
    private static final int STREAMING = 4;
    private boolean lastBlock;
    private boolean lz77active;
    private int BTYPE;

    public GZipOutputStream(OutputStream outputStream, int size, int compressionType, int plainWindowSize, int huffmanWindowSize) throws IOException {
        this.outStream = outputStream;
        this.inputBuffer = new byte[size + 300];
        this.litCount = new int[286];
        this.distCount = new int[30];
        this.smallCodeBuffer = new int[2];
        if (plainWindowSize > 32768) {
            throw new IllegalArgumentException("plainWindowSize > 32768");
        }
        if (plainWindowSize >= 100) {
            this.plainDataWindow = new byte[plainWindowSize / 4 * 4];
            this.lz77active = true;
        } else {
            this.plainDataWindow = null;
            this.lz77active = false;
        }
        if (huffmanWindowSize > 32768) {
            throw new IllegalArgumentException("plainWindowSize > 32768");
        }
        if (huffmanWindowSize < 1024 && huffmanWindowSize > 0) {
            huffmanWindowSize = 1024;
        }
        this.outputWindow = new byte[huffmanWindowSize];
        if (huffmanWindowSize == 0) {
            this.lastBlock = true;
            this.BTYPE = 1;
            this.newBlock();
            this.status = 4;
        } else {
            this.BTYPE = 2;
            this.status = 0;
        }
        for (int i2 = 0; i2 < 4; ++i2) {
            this.HM[i2] = new ZipIntMultShortHashMap(2048);
        }
        if (compressionType == 1) {
            this.outStream.write(31);
            this.outStream.write(139);
            this.outStream.write(8);
            this.outStream.write(new byte[6]);
            this.outStream.write(255);
        }
    }

    public void close() throws IOException {
        this.flush();
        if (this.BTYPE == 2) {
            if (this.outProcessed + 8 + (this.inEnd - this.inStart) * 8 / 3 > this.outputWindow.length) {
                this.compileOutput();
            }
            this.LZ77(true);
            this.lastBlock = true;
            this.compileOutput();
        } else {
            this.LZ77(true);
        }
        this.writeFooter();
        this.outStream = null;
        this.outputWindow = null;
        this.inputBuffer = null;
        this.litCount = null;
    }

    public void flush() throws IOException {
        this.LZ77(false);
    }

    public void write(int b2) throws IOException {
        if (this.inputBuffer.length == this.inEnd) {
            this.LZ77(false);
        }
        this.inputBuffer[this.inEnd++] = (byte)b2;
        ++this.isize;
        byte[] bb = new byte[]{(byte)b2};
        this.crc32 = ZipHelper.crc32(this.crc32Table, this.crc32, bb, 0, 1);
    }

    public void write(byte[] b2) throws IOException {
        this.write(b2, 0, b2.length);
    }

    public void write(byte[] b2, int off, int len) throws IOException {
        int processed = 0;
        this.crc32 = ZipHelper.crc32(this.crc32Table, this.crc32, b2, off, len);
        this.isize += len;
        while (processed != len) {
            if (this.inputBuffer.length - this.inEnd >= len - processed) {
                System.arraycopy(b2, processed + off, this.inputBuffer, this.inEnd, len - processed);
                this.inEnd += len - processed;
                processed = len;
            } else {
                System.arraycopy(b2, processed + off, this.inputBuffer, this.inEnd, this.inputBuffer.length - this.inEnd);
                processed += this.inputBuffer.length - this.inEnd;
                this.inEnd = this.inputBuffer.length;
            }
            this.LZ77(false);
        }
    }

    private boolean search4LZ77(int[] bestPointer, int position) {
        ZipIntMultShortHashMap.Element found = null;
        int[] pointer = new int[2];
        bestPointer[1] = 0;
        for (int i2 = 0; i2 < 4; ++i2) {
            found = null;
            found = this.HM[i2].get(128 + this.inputBuffer[position] << 16 | 128 + this.inputBuffer[position + 1] << 8 | 128 + this.inputBuffer[position + 2]);
            if (found == null || found.size == 0) continue;
            this.searchHM4LZ77(found, pointer, position);
            if (pointer[1] <= bestPointer[1]) continue;
            bestPointer[0] = pointer[0];
            bestPointer[1] = pointer[1];
        }
        return bestPointer[1] != 0;
    }

    private void searchHM4LZ77(ZipIntMultShortHashMap.Element found, int[] pointer, int position) {
        int bestK = 0;
        int bestLength = 0;
        for (int k2 = found.size - 1; k2 >= 0; --k2) {
            int length;
            int comparePointer = 100000;
            for (length = 3; length < 258 && position + length < this.inputBuffer.length && this.inputBuffer[position + length] == this.plainDataWindow[comparePointer = found.values[k2] < this.plainPointer ? (found.values[k2] + length % (this.plainPointer - found.values[k2])) % this.plainDataWindow.length : (found.values[k2] + length % (this.plainPointer + this.plainDataWindow.length - found.values[k2])) % this.plainDataWindow.length]; ++length) {
            }
            if (length <= bestLength) continue;
            bestK = k2;
            bestLength = length;
            if (length == 258) break;
        }
        pointer[0] = (this.plainPointer - found.values[bestK] + this.plainDataWindow.length) % this.plainDataWindow.length;
        pointer[1] = bestLength;
    }

    private void encodePointer(int distance, int length) throws IOException {
        int di = ZipHelper.encodeCode(ZipHelper.LENGTH_CODE, length);
        int litlen = 257 + di;
        byte litextra = (byte)(length - ZipHelper.LENGTH_CODE[di * 2 + 1]);
        di = ZipHelper.encodeCode(ZipHelper.DISTANCE_CODE, distance);
        int distExtra = distance - ZipHelper.DISTANCE_CODE[di * 2 + 1];
        if (this.outputWindow.length != 0) {
            this.outputWindow[this.outProcessed] = -1;
            this.outputWindow[this.outProcessed + 1] = (byte)(litlen - 255);
            this.outputWindow[this.outProcessed + 2] = litextra;
            this.outputWindow[this.outProcessed + 3] = (byte)di;
            this.outputWindow[this.outProcessed + 4] = (byte)(distExtra & 0xFF);
            this.outputWindow[this.outProcessed + 5] = (byte)(distExtra >> 8 & 0xFF);
            this.outputWindow[this.outProcessed + 6] = (byte)(distExtra >> 16 & 0xFF);
            this.outProcessed += 6;
            int n2 = litlen;
            this.litCount[n2] = this.litCount[n2] + 1;
            int n3 = di;
            this.distCount[n3] = this.distCount[n3] + 1;
        } else {
            this.pushSmallBuffer(this.huffmanCode[litlen], this.huffmanCodeLength[litlen]);
            this.pushSmallBuffer(litextra, (byte)ZipHelper.LENGTH_CODE[2 * (litlen - 257)]);
            this.pushSmallBuffer(this.distHuffCode[di], this.distHuffCodeLength[di]);
            this.pushSmallBuffer(distExtra, (byte)ZipHelper.DISTANCE_CODE[di * 2]);
        }
    }

    private void encodeChar(int position) throws IOException {
        int val = this.inputBuffer[position] + 256 & 0xFF;
        if (this.outputWindow.length != 0) {
            int n2 = val;
            this.litCount[n2] = this.litCount[n2] + 1;
            this.outputWindow[this.outProcessed] = (byte)val;
            if (val == 255) {
                ++this.outProcessed;
                this.outputWindow[this.outProcessed] = 0;
            }
        } else {
            this.pushSmallBuffer(this.huffmanCode[val], this.huffmanCodeLength[val]);
        }
    }

    private void LZ77(boolean finish) throws IOException {
        int i2;
        int length;
        if (this.inStart != 0) {
            System.arraycopy(this.inputBuffer, this.inStart, this.inputBuffer, 0, this.inEnd - this.inStart);
            this.inEnd -= this.inStart;
            this.inStart = 0;
        }
        int upTo = finish ? this.inEnd : this.inEnd - 300;
        int[] pointer = new int[2];
        int[] lastpointer = new int[2];
        for (i2 = 0; i2 < upTo; i2 += length) {
            length = 1;
            int distance = 0;
            if (this.lz77active && i2 < upTo - 2 && this.search4LZ77(pointer, i2)) {
                if (pointer[1] > lastpointer[1]) {
                    lastpointer[0] = pointer[0];
                    lastpointer[1] = pointer[1];
                } else {
                    distance = pointer[0];
                    length = pointer[1];
                }
            }
            if (finish && upTo - i2 < length) {
                length = upTo - i2;
            }
            if (length > 2) {
                this.encodePointer(distance, length);
            } else {
                this.encodeChar(i2);
            }
            if (this.outputWindow.length != 0) {
                ++this.outProcessed;
                if (this.outProcessed + 8 > this.outputWindow.length) {
                    this.compileOutput();
                }
            }
            if (!this.lz77active) continue;
            for (int k2 = 0; k2 < length; ++k2) {
                this.plainDataWindow[this.plainPointer] = this.inputBuffer[i2 + k2];
                this.HM[this.plainPointer / (this.plainDataWindow.length / 4)].put(128 + this.inputBuffer[i2 + k2] << 16 | 128 + this.inputBuffer[i2 + k2 + 1] << 8 | 128 + this.inputBuffer[i2 + k2 + 2], (short)this.plainPointer);
                if (++this.plainPointer % (this.plainDataWindow.length / 4) != 0) continue;
                if (this.plainPointer == this.plainDataWindow.length) {
                    this.plainPointer = 0;
                }
                this.HM[this.plainPointer / (this.plainDataWindow.length / 4) % 4].clear();
            }
        }
        this.inStart = i2;
    }

    private void newBlock() throws IOException {
        if (this.status == 0) {
            this.status = 4;
        } else {
            this.pushSmallBuffer(this.huffmanCode[256], this.huffmanCodeLength[256]);
        }
        if (this.lastBlock) {
            this.pushSmallBuffer(1, (byte)1);
        } else {
            this.pushSmallBuffer(0, (byte)1);
        }
        this.pushSmallBuffer(this.BTYPE, (byte)2);
        this.huffmanCode = new int[286];
        this.huffmanCodeLength = new byte[286];
        this.distHuffCode = new int[30];
        this.distHuffCodeLength = new byte[30];
        if (this.BTYPE == 1) {
            ZipHelper.genFixedTree(this.huffmanCode, this.huffmanCodeLength, this.distHuffCode, this.distHuffCodeLength);
        } else if (this.BTYPE == 2) {
            int i2;
            for (i2 = 0; i2 < 2; ++i2) {
                if (this.distCount[i2] != 0) continue;
                this.distCount[i2] = 1;
            }
            this.litCount[256] = 1;
            ZipHelper.genTreeLength(this.litCount, this.huffmanCodeLength, 15);
            ZipHelper.genHuffTree(this.huffmanCode, this.huffmanCodeLength);
            ZipHelper.revHuffTree(this.huffmanCode, this.huffmanCodeLength);
            ZipHelper.genTreeLength(this.distCount, this.distHuffCodeLength, 15);
            ZipHelper.genHuffTree(this.distHuffCode, this.distHuffCodeLength);
            ZipHelper.revHuffTree(this.distHuffCode, this.distHuffCodeLength);
            this.compressTree(this.huffmanCodeLength, this.distHuffCodeLength);
            for (i2 = 0; i2 < 286; ++i2) {
                this.litCount[i2] = 0;
            }
            for (i2 = 0; i2 < 30; ++i2) {
                this.distCount[i2] = 0;
            }
        }
    }

    private void compileOutput() throws IOException {
        this.newBlock();
        int val = 0;
        for (int i2 = 0; i2 < this.outProcessed; ++i2) {
            val = this.outputWindow[i2];
            if (val < 0) {
                val += 256;
            }
            if (val != 255) {
                this.pushSmallBuffer(this.huffmanCode[val], this.huffmanCodeLength[val]);
                continue;
            }
            if (val != 255) continue;
            if (this.outputWindow[++i2] == 0) {
                this.pushSmallBuffer(this.huffmanCode[255], this.huffmanCodeLength[255]);
                continue;
            }
            if (this.outputWindow[i2] > 0) {
                int litlen = 255 + this.outputWindow[i2];
                byte litextra = this.outputWindow[++i2];
                byte di = this.outputWindow[++i2];
                int distExtra = this.outputWindow[++i2] + 256 & 0xFF | (this.outputWindow[i2 + 1] + 256 & 0xFF) << 8 | (this.outputWindow[i2 + 2] + 256 & 0xFF) << 16;
                i2 += 3;
                this.pushSmallBuffer(this.huffmanCode[litlen], this.huffmanCodeLength[litlen]);
                this.pushSmallBuffer(litextra, (byte)ZipHelper.LENGTH_CODE[2 * (litlen - 257)]);
                this.pushSmallBuffer(this.distHuffCode[di], this.distHuffCodeLength[di]);
                this.pushSmallBuffer(distExtra, (byte)ZipHelper.DISTANCE_CODE[di * 2]);
                --i2;
                continue;
            }
            throw new IOException("illegal code decoded");
        }
        this.outProcessed = 0;
    }

    private void writeFooter() throws IOException {
        this.pushSmallBuffer(this.huffmanCode[256], this.huffmanCodeLength[256]);
        if ((this.smallCodeBuffer[1] & 7) != 0) {
            this.pushSmallBuffer(0, (byte)(8 - (this.smallCodeBuffer[1] & 7)));
        }
        this.outStream.write(this.crc32 & 0xFF);
        this.outStream.write(this.crc32 >>> 8 & 0xFF);
        this.outStream.write(this.crc32 >>> 16 & 0xFF);
        this.outStream.write(this.crc32 >>> 24 & 0xFF);
        this.outStream.write(this.isize & 0xFF);
        this.outStream.write(this.isize >>> 8 & 0xFF);
        this.outStream.write(this.isize >>> 16 & 0xFF);
        this.outStream.write(this.isize >>> 24 & 0xFF);
        this.outStream.flush();
        this.outStream.close();
    }

    private void compressTree(byte[] huffmanCodeLength, byte[] distHuffCodeLength) throws IOException {
        int HCLEN;
        int i2;
        int HLIT;
        int HDIST = 29;
        for (HLIT = 285; huffmanCodeLength[HLIT] == 0 && HLIT > 29; --HLIT) {
        }
        ++HLIT;
        while (distHuffCodeLength[HDIST] == 0 && HDIST > 0) {
            --HDIST;
        }
        byte[] len = new byte[HLIT + ++HDIST];
        int j2 = 0;
        for (i2 = 0; i2 < HLIT; ++i2) {
            len[j2] = huffmanCodeLength[i2];
            ++j2;
        }
        for (i2 = 0; i2 < HDIST; ++i2) {
            len[j2] = distHuffCodeLength[i2];
            ++j2;
        }
        int[] miniHuffData = new int[]{16, 17, 18, 0, 8, 7, 9, 6, 10, 5, 11, 4, 12, 3, 13, 2, 14, 1, 15};
        byte[] outLitLenDist = new byte[HLIT + HDIST];
        int outCount = 0;
        int[] miniCodeCount = new int[19];
        for (int i3 = 0; i3 < len.length; ++i3) {
            if (i3 + 3 < len.length && len[i3] == len[i3 + 1] && len[i3] == len[i3 + 2] && len[i3] == len[i3 + 3]) {
                int k2;
                if (len[i3] == 0) {
                    outLitLenDist[outCount] = 0;
                    for (k2 = 4; i3 + k2 < len.length && len[i3] == len[i3 + k2] && k2 < 139; k2 = (int)((short)(k2 + 1))) {
                    }
                    if (k2 < 12) {
                        outLitLenDist[outCount + 1] = 17;
                        outLitLenDist[outCount + 2] = (byte)(k2 - 3 - 1);
                    } else {
                        outLitLenDist[outCount + 1] = 18;
                        outLitLenDist[outCount + 2] = (byte)(k2 - 11 - 1);
                    }
                    i3 += k2 - 1;
                } else {
                    outLitLenDist[outCount] = len[i3];
                    outLitLenDist[outCount + 1] = 16;
                    for (k2 = 4; i3 + k2 < len.length && len[i3] == len[i3 + k2] && k2 < 7; k2 = (int)((short)(k2 + 1))) {
                    }
                    outLitLenDist[outCount + 2] = (byte)(k2 - 4);
                    i3 += k2 - 1;
                }
                byte by = outLitLenDist[outCount];
                miniCodeCount[by] = miniCodeCount[by] + 1;
                byte by2 = outLitLenDist[outCount + 1];
                miniCodeCount[by2] = miniCodeCount[by2] + 1;
                outCount += 2;
            } else {
                outLitLenDist[outCount] = len[i3];
                byte by = outLitLenDist[outCount];
                miniCodeCount[by] = miniCodeCount[by] + 1;
            }
            ++outCount;
        }
        byte[] miniHuffCodeLength = new byte[19];
        int[] miniHuffCode = new int[19];
        int i4 = 0;
        ZipHelper.genTreeLength(miniCodeCount, miniHuffCodeLength, 7);
        ZipHelper.genHuffTree(miniHuffCode, miniHuffCodeLength);
        ZipHelper.revHuffTree(miniHuffCode, miniHuffCodeLength);
        this.pushSmallBuffer(HLIT - 257, (byte)5);
        this.pushSmallBuffer(HDIST - 1, (byte)5);
        for (HCLEN = 18; miniHuffCodeLength[miniHuffData[HCLEN]] == 0 && HCLEN > 0; --HCLEN) {
        }
        this.pushSmallBuffer(++HCLEN - 4, (byte)4);
        for (i4 = 0; i4 < HCLEN; ++i4) {
            this.pushSmallBuffer(miniHuffCodeLength[miniHuffData[i4]], (byte)3);
        }
        block13: for (i4 = 0; i4 < outCount; ++i4) {
            this.pushSmallBuffer(miniHuffCode[outLitLenDist[i4]], miniHuffCodeLength[outLitLenDist[i4]]);
            if (outLitLenDist[i4] <= 15) continue;
            switch (outLitLenDist[i4]) {
                case 16: {
                    this.pushSmallBuffer(outLitLenDist[i4 + 1], (byte)2);
                    ++i4;
                    continue block13;
                }
                case 17: {
                    this.pushSmallBuffer(outLitLenDist[i4 + 1], (byte)3);
                    ++i4;
                    continue block13;
                }
                default: {
                    this.pushSmallBuffer(outLitLenDist[i4 + 1], (byte)7);
                    ++i4;
                }
            }
        }
    }

    private void pushSmallBuffer(int val, byte len) throws IOException {
        int smallBuffer0 = this.smallCodeBuffer[0];
        int smallBuffer1 = this.smallCodeBuffer[1];
        smallBuffer0 &= ~((1 << len) - 1 << smallBuffer1);
        smallBuffer0 |= val << smallBuffer1;
        smallBuffer1 += len;
        while (smallBuffer1 >= 8) {
            this.outStream.write(smallBuffer0 & 0xFF);
            smallBuffer0 >>>= 8;
            smallBuffer1 -= 8;
        }
        this.smallCodeBuffer[0] = smallBuffer0;
        this.smallCodeBuffer[1] = smallBuffer1;
    }
}

