/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.util.base64;

import de.enough.polish.util.base64.Base64;
import java.io.IOException;
import java.io.InputStream;

public class Base64InputStream
extends InputStream {
    private static final int BUFFER_LENGTH = 3;
    private int position;
    private byte[] buffer;
    private int numSigBytes;
    private int lineLength;
    private int options;
    private byte[] decodabet;
    private final InputStream in;

    public Base64InputStream(InputStream in) {
        this(in, 0);
    }

    public Base64InputStream(InputStream in, int options) {
        this.in = in;
        this.buffer = new byte[3];
        this.position = -1;
        this.lineLength = 0;
        this.options = options;
        this.decodabet = Base64.getDecodabet(options);
    }

    public int read() throws IOException {
        if (this.position < 0) {
            byte[] b4 = new byte[4];
            int i2 = 0;
            for (i2 = 0; i2 < 4; ++i2) {
                int b2 = 0;
                while ((b2 = this.in.read()) >= 0 && this.decodabet[b2 & 0x7F] <= -5) {
                }
                if (b2 < 0) break;
                b4[i2] = (byte)b2;
            }
            if (i2 == 4) {
                this.numSigBytes = Base64.decode4to3(b4, 0, this.buffer, 0, this.options);
                this.position = 0;
            } else {
                if (i2 == 0) {
                    return -1;
                }
                throw new IOException("Improperly padded Base64 input.");
            }
        }
        if (this.position >= 0) {
            if (this.position >= this.numSigBytes) {
                return -1;
            }
            ++this.lineLength;
            byte b3 = this.buffer[this.position++];
            if (this.position >= 3) {
                this.position = -1;
            }
            return b3 & 0xFF;
        }
        throw new IOException("Error in Base64 code reading stream.");
    }

    public int read(byte[] dest, int off, int len) throws IOException {
        int i2;
        for (i2 = 0; i2 < len; ++i2) {
            int b2 = this.read();
            if (b2 < 0) {
                if (i2 != 0) break;
                return -1;
            }
            dest[off + i2] = (byte)b2;
        }
        return i2;
    }

    public int read(byte[] data) throws IOException {
        return this.read(data, 0, data.length);
    }

    public int available() throws IOException {
        return 0;
    }

    public void close() throws IOException {
        this.in.close();
    }

    public void mark(int readLimit) {
    }

    public boolean markSupported() {
        return false;
    }

    public void reset() throws IOException {
        throw new IOException();
    }

    public long skip(long n2) throws IOException {
        return this.in.skip(n2);
    }
}

