/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.util;

import de.enough.polish.util.ArrayList;
import javax.microedition.lcdui.Font;

public final class TextUtil {
    private static final String UNRESERVED = "-_.!~*'()\"";

    public static String[] split(String value, char delimiter) {
        char[] valueChars = value.toCharArray();
        int lastIndex = 0;
        ArrayList strings = null;
        for (int i2 = 0; i2 < valueChars.length; ++i2) {
            char c2 = valueChars[i2];
            if (c2 != delimiter) continue;
            if (strings == null) {
                strings = new ArrayList();
            }
            strings.add(new String(valueChars, lastIndex, i2 - lastIndex));
            lastIndex = i2 + 1;
        }
        if (strings == null) {
            return new String[]{value};
        }
        strings.add(new String(valueChars, lastIndex, valueChars.length - lastIndex));
        return (String[])strings.toArray(new String[strings.size()]);
    }

    public static String[] splitAndTrim(String value, char delimiter) {
        String[] result = TextUtil.split(value, delimiter);
        for (int i2 = 0; i2 < result.length; ++i2) {
            result[i2] = result[i2].trim();
        }
        return result;
    }

    public static String[] split(String value, char delimiter, int numberOfChunks) {
        char[] valueChars = value.toCharArray();
        int lastIndex = 0;
        String[] chunks = new String[numberOfChunks];
        int chunkIndex = 0;
        for (int i2 = 0; i2 < valueChars.length; ++i2) {
            char c2 = valueChars[i2];
            if (c2 != delimiter) continue;
            chunks[chunkIndex] = value.substring(lastIndex, i2);
            lastIndex = i2 + 1;
            if (++chunkIndex == numberOfChunks) break;
        }
        if (chunkIndex < numberOfChunks) {
            chunks[chunkIndex] = value.substring(lastIndex, valueChars.length);
        }
        return chunks;
    }

    public static String[] split(String value, Font font, int firstLineWidth, int lineWidth) {
        return TextUtil.wrap(value, font, firstLineWidth, lineWidth);
    }

    public static String[] wrap(String value, Font font, int firstLineWidth, int lineWidth) {
        if (firstLineWidth <= 0 || lineWidth <= 0) {
            return new String[]{value};
        }
        boolean hasLineBreaks = value.indexOf(10) != -1;
        int completeWidth = font.stringWidth(value);
        if (completeWidth <= firstLineWidth && !hasLineBreaks) {
            return new String[]{value};
        }
        ArrayList lines = new ArrayList();
        if (!hasLineBreaks) {
            TextUtil.wrap(value, font, completeWidth, firstLineWidth, lineWidth, lines);
        } else {
            char[] valueChars = value.toCharArray();
            int lastIndex = 0;
            int c2 = 32;
            int lineBreakCount = 0;
            for (int i2 = 0; i2 < valueChars.length; ++i2) {
                boolean isCRLF;
                c2 = valueChars[i2];
                boolean bl = isCRLF = c2 == 13 && i2 < valueChars.length - 1 && valueChars[i2 + 1] == '\n';
                if (c2 != 10 && i2 != valueChars.length - 1 && !isCRLF) continue;
                ++lineBreakCount;
                String line = null;
                line = i2 == valueChars.length - 1 ? new String(valueChars, lastIndex, i2 + 1 - lastIndex) : new String(valueChars, lastIndex, i2 - lastIndex);
                completeWidth = font.stringWidth(line);
                if (completeWidth <= firstLineWidth) {
                    lines.add(line);
                } else {
                    TextUtil.wrap(line, font, completeWidth, firstLineWidth, lineWidth, lines);
                }
                if (isCRLF) {
                    ++i2;
                }
                lastIndex = i2 + 1;
                firstLineWidth = lineWidth;
            }
            if (lineBreakCount > 1 && (c2 == 10 || c2 == 10)) {
                lines.add("");
            }
        }
        return (String[])lines.toArray(new String[lines.size()]);
    }

    public static void split(String value, Font font, int completeWidth, int firstLineWidth, int lineWidth, ArrayList list) {
        TextUtil.wrap(value, font, completeWidth, firstLineWidth, lineWidth, list);
    }

    public static void wrap(String value, Font font, int completeWidth, int firstLineWidth, int lineWidth, ArrayList list) {
        char[] valueChars = value.toCharArray();
        int startPos = 0;
        int lastSpacePos = -1;
        int lastSpacePosLength = 0;
        int currentLineWidth = 0;
        for (int i2 = 0; i2 < valueChars.length; ++i2) {
            char c2 = valueChars[i2];
            currentLineWidth += font.charWidth(c2);
            if (c2 == '\n') {
                list.add(new String(valueChars, startPos, i2 - startPos));
                lastSpacePos = -1;
                startPos = i2 + 1;
                currentLineWidth = 0;
                firstLineWidth = lineWidth;
                i2 = startPos;
                continue;
            }
            if (currentLineWidth >= firstLineWidth && i2 > 0) {
                if (lastSpacePos == -1) {
                    list.add(new String(valueChars, startPos, --i2 - startPos));
                    startPos = i2;
                    currentLineWidth = 0;
                } else {
                    currentLineWidth -= lastSpacePosLength;
                    list.add(new String(valueChars, startPos, lastSpacePos - startPos));
                    startPos = lastSpacePos + 1;
                    lastSpacePos = -1;
                }
                firstLineWidth = lineWidth;
                continue;
            }
            if (c2 != ' ' && c2 != '\t') continue;
            lastSpacePos = i2;
            lastSpacePosLength = currentLineWidth;
        }
        list.add(new String(valueChars, startPos, valueChars.length - startPos));
    }

    private static char toHexChar(int digitValue) {
        if (digitValue < 10) {
            return (char)(48 + digitValue);
        }
        return (char)(65 + (digitValue - 10));
    }

    public static String encodeUrl(String url) {
        StringBuffer encodedUrl = new StringBuffer();
        int len = url.length();
        for (int i2 = 0; i2 < len; ++i2) {
            char c2 = url.charAt(i2);
            if (c2 >= '0' && c2 <= '9' || c2 >= 'a' && c2 <= 'z' || c2 >= 'A' && c2 <= 'Z') {
                encodedUrl.append(c2);
                continue;
            }
            int imark = UNRESERVED.indexOf(c2);
            if (imark >= 0) {
                encodedUrl.append(c2);
                continue;
            }
            encodedUrl.append('%');
            encodedUrl.append(TextUtil.toHexChar((c2 & 0xF0) >> 4));
            encodedUrl.append(TextUtil.toHexChar(c2 & 0xF));
        }
        return encodedUrl.toString();
    }

    public static String replace(String input, String search, String replacement) {
        int pos = input.indexOf(search);
        if (pos != -1) {
            StringBuffer buffer = new StringBuffer();
            int lastPos = 0;
            do {
                buffer.append(input.substring(lastPos, pos)).append(replacement);
            } while ((pos = input.indexOf(search, lastPos = pos + search.length())) != -1);
            buffer.append(input.substring(lastPos));
            input = buffer.toString();
        }
        return input;
    }

    public static String replaceFirst(String input, String search, String replacement) {
        int pos = input.indexOf(search);
        if (pos != -1) {
            input = input.substring(0, pos) + replacement + input.substring(pos + search.length());
        }
        return input;
    }

    public static String replaceLast(String input, String search, String replacement) {
        int pos = input.indexOf(search);
        if (pos != -1) {
            int lastPos = pos;
            while ((pos = input.indexOf(search, lastPos + 1)) != -1) {
                lastPos = pos;
            }
            input = input.substring(0, lastPos) + replacement + input.substring(lastPos + search.length());
        }
        return input;
    }

    public static int lastIndexOf(String text, String match) {
        int lastIndex = -1;
        int index = text.indexOf(match);
        while (index != -1) {
            lastIndex = index;
            index = text.indexOf(match, lastIndex + 1);
        }
        return lastIndex;
    }

    public static boolean equalsIgnoreCase(String str1, String str2) {
        return str1.equalsIgnoreCase(str2);
    }

    public static String reverseForRtlLanguage(String input) {
        StringBuffer output = new StringBuffer(input.length());
        StringBuffer ltrCharacters = new StringBuffer();
        boolean isCurrRTL = true;
        int size = input.length();
        int index = size - 1;
        while (index >= 0) {
            char nextChr;
            char curr;
            while (isCurrRTL && index >= 0) {
                curr = input.charAt(index);
                nextChr = '\u0000';
                nextChr = index > 0 ? input.charAt(index - 1) : curr;
                if (TextUtil.isEnglishChar(curr) || TextUtil.isEnglishChar(nextChr)) {
                    isCurrRTL = false;
                    continue;
                }
                if (curr == '(') {
                    output.append(')');
                } else if (curr == ')') {
                    output.append('(');
                } else {
                    output.append(curr);
                }
                --index;
            }
            ltrCharacters.delete(0, ltrCharacters.length());
            while (!isCurrRTL && index >= 0) {
                curr = input.charAt(index);
                nextChr = '\u0000';
                nextChr = index > 0 ? input.charAt(index - 1) : curr;
                if (TextUtil.isEnglishChar(curr) || TextUtil.isEnglishChar(nextChr)) {
                    ltrCharacters.insert(0, curr);
                    --index;
                    continue;
                }
                isCurrRTL = true;
            }
            output.append((Object)ltrCharacters);
        }
        return output.toString();
    }

    private static boolean isEnglishChar(char chr) {
        return chr < '\u0080' && (chr >= 'a' && chr <= 'z' || chr >= 'A' && chr <= 'Z' || chr >= '0' && chr <= '9' || chr == '+');
    }
}

