/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.util;

import de.enough.polish.util.Iterator;
import de.enough.polish.util.Map;

public class HashMap
implements Map {
    public static final int DEFAULT_INITIAL_CAPACITY = 16;
    public static final int DEFAULT_LOAD_FACTOR = 75;
    private final int loadFactor;
    Element[] buckets;
    private final boolean isPowerOfTwo;
    int size;

    public HashMap() {
        this(16, 75);
    }

    public HashMap(int initialCapacity) {
        this(initialCapacity, 75);
    }

    public HashMap(int initialCapacity, int loadFactor) {
        int capacity;
        if (initialCapacity <= 0) {
            throw new IllegalArgumentException();
        }
        initialCapacity = initialCapacity * 100 / loadFactor;
        for (capacity = 1; initialCapacity > capacity; capacity <<= 1) {
        }
        this.isPowerOfTwo = capacity == initialCapacity;
        this.buckets = new Element[initialCapacity];
        this.loadFactor = loadFactor;
    }

    public Object put(Object key, Object value) {
        if (key == null || value == null) {
            throw new IllegalArgumentException("HashMap cannot accept null key [" + key + "] or value [" + value + "].");
        }
        if (this.size * 100 / this.buckets.length > this.loadFactor) {
            this.increaseSize();
        }
        int hashCode = key.hashCode();
        int index = this.isPowerOfTwo ? hashCode & Integer.MAX_VALUE & this.buckets.length - 1 : (hashCode & Integer.MAX_VALUE) % this.buckets.length;
        Element element = this.buckets[index];
        if (element == null) {
            this.buckets[index] = element = new Element(hashCode, key, value);
            ++this.size;
            return null;
        }
        Element lastElement = element;
        do {
            if (element.key.equals(key)) {
                Object oldValue = element.value;
                element.value = value;
                return oldValue;
            }
            lastElement = element;
        } while ((element = element.next) != null);
        lastElement.next = element = new Element(hashCode, key, value);
        ++this.size;
        return null;
    }

    public Object get(Object key) {
        if (key == null) {
            throw new IllegalArgumentException();
        }
        int index = this.isPowerOfTwo ? key.hashCode() & Integer.MAX_VALUE & this.buckets.length - 1 : (key.hashCode() & Integer.MAX_VALUE) % this.buckets.length;
        Element element = this.buckets[index];
        if (element == null) {
            return null;
        }
        do {
            if (!element.key.equals(key)) continue;
            return element.value;
        } while ((element = element.next) != null);
        return null;
    }

    public Object remove(Object key) {
        if (key == null) {
            throw new IllegalArgumentException();
        }
        int index = this.isPowerOfTwo ? key.hashCode() & Integer.MAX_VALUE & this.buckets.length - 1 : (key.hashCode() & Integer.MAX_VALUE) % this.buckets.length;
        Element element = this.buckets[index];
        if (element == null) {
            return null;
        }
        Element lastElement = null;
        do {
            if (element.key.equals(key)) {
                if (lastElement == null) {
                    this.buckets[index] = element.next;
                } else {
                    lastElement.next = element.next;
                }
                --this.size;
                return element.value;
            }
            lastElement = element;
        } while ((element = element.next) != null);
        return null;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public int size() {
        return this.size;
    }

    public boolean containsKey(Object key) {
        return this.get(key) != null;
    }

    public boolean containsValue(Object value) {
        for (int i2 = 0; i2 < this.buckets.length; ++i2) {
            Element element = this.buckets[i2];
            while (element != null) {
                if (element.value.equals(value)) {
                    return true;
                }
                element = element.next;
            }
        }
        return false;
    }

    public void clear() {
        for (int i2 = 0; i2 < this.buckets.length; ++i2) {
            this.buckets[i2] = null;
        }
        this.size = 0;
    }

    public Object[] values() {
        return this.values(new Object[this.size]);
    }

    public Object[] values(Object[] objects) {
        int index = 0;
        for (int i2 = 0; i2 < this.buckets.length; ++i2) {
            Element element = this.buckets[i2];
            while (element != null) {
                objects[index] = element.value;
                ++index;
                element = element.next;
            }
        }
        return objects;
    }

    public Object[] keys() {
        return this.keys(new Object[this.size]);
    }

    public Object[] keys(Object[] objects) {
        int index = 0;
        for (int i2 = 0; i2 < this.buckets.length; ++i2) {
            Element element = this.buckets[i2];
            while (element != null) {
                objects[index] = element.key;
                ++index;
                element = element.next;
            }
        }
        return objects;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(this.size * 23);
        buffer.append(super.toString()).append("{\n");
        Object[] values = this.values();
        for (int i2 = 0; i2 < values.length; ++i2) {
            buffer.append(values[i2]);
            buffer.append('\n');
        }
        buffer.append('}');
        return buffer.toString();
    }

    private void increaseSize() {
        int newCapacity = this.isPowerOfTwo ? this.buckets.length << 1 : (this.buckets.length << 1) - 1;
        Element[] newBuckets = new Element[newCapacity];
        for (int i2 = 0; i2 < this.buckets.length; ++i2) {
            Element element = this.buckets[i2];
            while (element != null) {
                int index = this.isPowerOfTwo ? element.hashCodeValue & Integer.MAX_VALUE & newCapacity - 1 : (element.hashCodeValue & Integer.MAX_VALUE) % newCapacity;
                Element newElement = newBuckets[index];
                if (newElement == null) {
                    newBuckets[index] = element;
                } else {
                    while (newElement.next != null) {
                        newElement = newElement.next;
                    }
                    newElement.next = element;
                }
                Element lastElement = element;
                element = element.next;
                lastElement.next = null;
            }
        }
        this.buckets = newBuckets;
    }

    public Iterator keysIterator() {
        return new HashMapIterator();
    }

    private final class HashMapIterator
    implements Iterator {
        private int position;
        private Element current;
        private int lastBucketIndex;
        private int iteratorSize;

        HashMapIterator() {
            this.iteratorSize = HashMap.this.size;
        }

        public boolean hasNext() {
            return this.position < this.iteratorSize;
        }

        public Object next() {
            if (this.current != null) {
                this.current = this.current.next;
            }
            if (this.current == null) {
                for (int i2 = this.lastBucketIndex; i2 < HashMap.this.buckets.length; ++i2) {
                    Element element = HashMap.this.buckets[i2];
                    if (element == null) continue;
                    this.current = element;
                    this.lastBucketIndex = i2 + 1;
                    ++this.position;
                    return element.key;
                }
                throw new IllegalStateException("no more elements");
            }
            ++this.position;
            return this.current.key;
        }

        public void remove() {
            if (this.current == null) {
                throw new IllegalStateException("no current element");
            }
            for (int i2 = this.lastBucketIndex - 1; i2 >= 0; --i2) {
                Element element = HashMap.this.buckets[i2];
                if (element == this.current) {
                    HashMap.this.buckets[i2] = this.current.next;
                    --HashMap.this.size;
                    return;
                }
                Element last = element;
                while (element != null) {
                    if (element == this.current) {
                        last.next = element.next;
                        --HashMap.this.size;
                        return;
                    }
                    last = element;
                    element = element.next;
                }
            }
            throw new IllegalStateException("unable to locate current element");
        }
    }

    private static final class Element {
        public final Object key;
        public final int hashCodeValue;
        public Object value;
        public Element next;

        public Element(int hashCode, Object key, Object value) {
            this.hashCodeValue = hashCode;
            this.key = key;
            this.value = value;
        }
    }
}

