/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.util;

import de.enough.polish.util.Comparator;

public final class Arrays
implements Comparator {
    private static final Comparator STRING_COMPARATOR = new Arrays();

    private Arrays() {
    }

    public int compare(Object o1, Object o2) {
        return o1.toString().compareTo(o2.toString());
    }

    public static void sort(Object[] obj) {
        Arrays.sort(obj, STRING_COMPARATOR);
    }

    public static void shellSort(Object[] array) {
        Arrays.shellSort(array, STRING_COMPARATOR);
    }

    public static void shellSort(Object[] array, Comparator comparator) {
        int increment = 3;
        while (true) {
            for (int i2 = 0; i2 < array.length; ++i2) {
                Object temp = array[i2];
                for (int j2 = i2; j2 >= increment && comparator.compare(array[j2 - increment], temp) > 0; j2 -= increment) {
                    array[j2] = array[j2 - increment];
                }
                array[j2] = temp;
            }
            if (increment == 1) break;
            increment >>= 1;
        }
    }

    public static void quicksort(Object[] obj) {
        Arrays.quicksort(obj, obj.length, STRING_COMPARATOR);
    }

    public static void iQuick(int[] array, int elements) {
        int left = 0;
        int right = elements - 1;
        int top = 0;
        int sSize = elements / 2;
        int[] lStack = new int[sSize];
        int[] rStack = new int[sSize];
        lStack[top] = left;
        rStack[top] = right;
        while (top >= 0) {
            left = lStack[top];
            right = rStack[top];
            --top;
            while (left < right) {
                int i2 = left;
                int j2 = right;
                int x2 = array[(left + right) / 2];
                while (i2 <= j2) {
                    while (array[i2] < x2) {
                        ++i2;
                    }
                    while (array[j2] > x2) {
                        --j2;
                    }
                    if (i2 > j2) continue;
                    int tmp = array[i2];
                    array[i2] = array[j2];
                    array[j2] = tmp;
                    ++i2;
                    --j2;
                }
                if (j2 - left < right - i2) {
                    if (i2 < right) {
                        lStack[++top] = i2;
                        rStack[top] = right;
                    }
                    right = j2;
                    continue;
                }
                if (left < j2) {
                    lStack[++top] = left;
                    rStack[top] = j2;
                }
                left = i2;
            }
        }
    }

    public static void quicksort(Object[] obj, int elements, Comparator comparator) {
        int left = 0;
        int right = elements - 1;
        int top = 0;
        int sSize = elements / 2;
        int[] lStack = new int[sSize];
        int[] rStack = new int[sSize];
        lStack[top] = left;
        rStack[top] = right;
        while (top >= 0) {
            left = lStack[top];
            right = rStack[top];
            --top;
            while (left < right) {
                int i2 = left;
                int j2 = right;
                Object tmp = obj[(left + right) / 2];
                while (i2 <= j2) {
                    while (comparator.compare(tmp, obj[i2]) > 0) {
                        ++i2;
                    }
                    while (comparator.compare(tmp, obj[j2]) < 0) {
                        --j2;
                    }
                    if (i2 > j2) continue;
                    tmp = obj[i2];
                    obj[i2] = obj[j2];
                    obj[j2] = tmp;
                    ++i2;
                    --j2;
                }
                if (j2 - left < right - i2) {
                    if (i2 < right) {
                        lStack[++top] = i2;
                        rStack[top] = right;
                    }
                    right = j2;
                    continue;
                }
                if (left < j2) {
                    lStack[++top] = left;
                    rStack[top] = j2;
                }
                left = i2;
            }
        }
    }

    public static void sort(Object[] obj, Comparator comparator) {
        Arrays.shellSort(obj, comparator);
    }

    public static boolean equals(Object array1, Object array2) {
        if (array1 instanceof byte[]) {
            byte[] pa1 = (byte[])array1;
            byte[] pa2 = (byte[])array2;
            if (pa1.length != pa2.length) {
                return false;
            }
            for (int i2 = 0; i2 < pa1.length; ++i2) {
                byte p1 = pa1[i2];
                byte p2 = pa2[i2];
                if (p1 == p2) continue;
                return false;
            }
        } else if (array1 instanceof short[]) {
            short[] pa1 = (short[])array1;
            short[] pa2 = (short[])array2;
            if (pa1.length != pa2.length) {
                return false;
            }
            for (int i3 = 0; i3 < pa1.length; ++i3) {
                short p1 = pa1[i3];
                short p2 = pa2[i3];
                if (p1 == p2) continue;
                return false;
            }
        } else if (array1 instanceof int[]) {
            int[] pa1 = (int[])array1;
            int[] pa2 = (int[])array2;
            if (pa1.length != pa2.length) {
                return false;
            }
            for (int i4 = 0; i4 < pa1.length; ++i4) {
                int p1 = pa1[i4];
                int p2 = pa2[i4];
                if (p1 == p2) continue;
                return false;
            }
        } else if (array1 instanceof long[]) {
            long[] pa1 = (long[])array1;
            long[] pa2 = (long[])array2;
            if (pa1.length != pa2.length) {
                return false;
            }
            for (int i5 = 0; i5 < pa1.length; ++i5) {
                long p1 = pa1[i5];
                long p2 = pa2[i5];
                if (p1 == p2) continue;
                return false;
            }
        } else if (array1 instanceof boolean[]) {
            boolean[] pa1 = (boolean[])array1;
            boolean[] pa2 = (boolean[])array2;
            if (pa1.length != pa2.length) {
                return false;
            }
            for (int i6 = 0; i6 < pa1.length; ++i6) {
                boolean p1 = pa1[i6];
                boolean p2 = pa2[i6];
                if (p1 == p2) continue;
                return false;
            }
        } else if (array1 instanceof float[]) {
            float[] pa1 = (float[])array1;
            float[] pa2 = (float[])array2;
            if (pa1.length != pa2.length) {
                return false;
            }
            for (int i7 = 0; i7 < pa1.length; ++i7) {
                float p1 = pa1[i7];
                float p2 = pa2[i7];
                if (p1 == p2) continue;
                return false;
            }
        } else if (array1 instanceof double[]) {
            double[] pa1 = (double[])array1;
            double[] pa2 = (double[])array2;
            if (pa1.length != pa2.length) {
                return false;
            }
            for (int i8 = 0; i8 < pa1.length; ++i8) {
                double p1 = pa1[i8];
                double p2 = pa2[i8];
                if (p1 == p2) continue;
                return false;
            }
        } else if (array1 instanceof Object[]) {
            Object[] oa1 = (Object[])array1;
            Object[] oa2 = (Object[])array2;
            if (oa1.length != oa2.length) {
                return false;
            }
            for (int i9 = 0; i9 < oa1.length; ++i9) {
                Object o1 = oa1[i9];
                Object o2 = oa2[i9];
                if ((o1 != null || o2 == null) && o1.equals(o2)) continue;
                return false;
            }
        } else {
            return array1.equals(array2);
        }
        return true;
    }
}

