/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.multimedia;

import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.media.PlayerListener;

public class AudioPlayer
implements PlayerListener {
    private static final Hashtable AUDIO_TYPES = new Hashtable();
    private final boolean doCachePlayer;
    private Player player;
    private PlayerListener listener;
    private final String defaultContentType;

    public AudioPlayer() {
        this(false, null, null);
    }

    public AudioPlayer(boolean doCachePlayer) {
        this(doCachePlayer, null, null);
    }

    public AudioPlayer(String contentType) {
        this(false, contentType, null);
    }

    public AudioPlayer(boolean doCachePlayer, String contentType) {
        this(doCachePlayer, contentType, null);
    }

    public AudioPlayer(boolean doCachePlayer, String contentType, PlayerListener listener) {
        this.listener = listener;
        this.doCachePlayer = doCachePlayer;
        if (contentType != null) {
            String correctContentType;
            if (!contentType.startsWith("audio/")) {
                contentType = "audio/" + contentType;
            }
            if ((correctContentType = AudioPlayer.getAudioType(contentType, null)) != null) {
                contentType = correctContentType;
            }
        }
        this.defaultContentType = contentType;
    }

    public void play(String url, String type) throws MediaException, IOException {
        InputStream in = this.getClass().getResourceAsStream(url);
        if (in == null) {
            throw new IOException("not found: " + url);
        }
        this.play(in, type);
    }

    public void play(InputStream in, String type) throws MediaException, IOException {
        String correctType = AudioPlayer.getAudioType(type, "file");
        if (correctType == null && (correctType = AudioPlayer.getAudioType(type, null)) == null) {
            correctType = type;
        }
        this.player = Manager.createPlayer((InputStream)in, (String)correctType);
        this.player.addPlayerListener((PlayerListener)this);
        this.player.start();
    }

    public void play(String url) throws MediaException, IOException {
        InputStream in = this.getClass().getResourceAsStream(url);
        if (in == null) {
            throw new IOException("not found: " + url);
        }
        this.play(in);
    }

    public void play(InputStream in) throws MediaException, IOException {
        String correctType = this.defaultContentType;
        this.player = Manager.createPlayer((InputStream)in, (String)correctType);
        this.player.addPlayerListener((PlayerListener)this);
        this.player.start();
    }

    public void play() throws MediaException {
        if (this.player != null) {
            this.player.start();
        }
    }

    public Player getPlayer() {
        return this.player;
    }

    public static String getAudioType(String type, String protocol) {
        String[] supportedContentTypes;
        if (AUDIO_TYPES.size() == 0) {
            AudioPlayer.addTypes(new String[]{"audio/3gpp", "audio/3gp"});
            AudioPlayer.addTypes(new String[]{"audio/x-mp3", "audio/mp3", "audio/x-mp3", "audio/mpeg3", "audio/x-mpeg3", "audio/mpeg-3"});
            AudioPlayer.addTypes(new String[]{"audio/midi", "audio/x-midi", "audio/mid", "audio/x-mid", "audio/sp-midi"});
            AudioPlayer.addTypes(new String[]{"audio/wav", "audio/x-wav"});
            AudioPlayer.addTypes(new String[]{"audio/amr", "audio/x-amr"});
            AudioPlayer.addTypes(new String[]{"audio/mpeg4", "audio/mpeg-4", "audio/mp4", "audio/mp4a-latm"});
            AudioPlayer.addTypes(new String[]{"audio/imelody", "audio/x-imelody", "audio/imy", "audio/x-imy"});
        }
        if ((supportedContentTypes = Manager.getSupportedContentTypes((String)protocol)) == null || supportedContentTypes.length == 0) {
            return null;
        }
        Hashtable mappings = (Hashtable)AUDIO_TYPES.get(type);
        if (mappings == null) {
            for (int i2 = 0; i2 < supportedContentTypes.length; ++i2) {
                String contentType = supportedContentTypes[i2];
                if (!contentType.equals(type)) continue;
                return type;
            }
        } else {
            for (int i3 = 0; i3 < supportedContentTypes.length; ++i3) {
                String contentType = supportedContentTypes[i3];
                if (!mappings.containsKey(contentType)) continue;
                return contentType;
            }
        }
        return null;
    }

    public boolean isPlaying() {
        if (this.player == null) {
            return false;
        }
        return this.player.getState() == 400;
    }

    private static final void addTypes(String[] types) {
        Hashtable<String, String> nestedMap = new Hashtable<String, String>();
        for (int i2 = 0; i2 < types.length; ++i2) {
            String type = types[i2];
            nestedMap.put(type, type);
            AUDIO_TYPES.put(type, nestedMap);
        }
    }

    public void playerUpdate(Player p2, String event, Object data) {
        if (this.listener != null) {
            this.listener.playerUpdate(p2, event, data);
        }
        if (!this.doCachePlayer && "endOfMedia".equals(event)) {
            p2.removePlayerListener((PlayerListener)this);
            this.cleanUpPlayer();
        }
    }

    public void cleanUpPlayer() {
        if (this.player != null) {
            this.player.deallocate();
            this.player.close();
            this.player = null;
        }
    }
}

