/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.math;

import java.util.Random;
import java.util.Stack;

public class BigInteger {
    private static final int[][] primeLists = new int[][]{{3, 5, 7, 11, 13, 17, 19, 23}, {29, 31, 37, 41, 43}, {47, 53, 59, 61, 67}, {71, 73, 79, 83}, {89, 97, 101, 103}, {107, 109, 113, 127}, {131, 137, 139, 149}, {151, 157, 163, 167}, {173, 179, 181, 191}, {193, 197, 199, 211}, {223, 227, 229}, {233, 239, 241}, {251, 257, 263}, {269, 271, 277}, {281, 283, 293}, {307, 311, 313}, {317, 331, 337}, {347, 349, 353}, {359, 367, 373}, {379, 383, 389}, {397, 401, 409}, {419, 421, 431}, {433, 439, 443}, {449, 457, 461}, {463, 467, 479}, {487, 491, 499}, {503, 509, 521}, {523, 541, 547}, {557, 563, 569}, {571, 577, 587}, {593, 599, 601}, {607, 613, 617}, {619, 631, 641}, {643, 647, 653}, {659, 661, 673}, {677, 683, 691}, {701, 709, 719}, {727, 733, 739}, {743, 751, 757}, {761, 769, 773}, {787, 797, 809}, {811, 821, 823}, {827, 829, 839}, {853, 857, 859}, {863, 877, 881}, {883, 887, 907}, {911, 919, 929}, {937, 941, 947}, {953, 967, 971}, {977, 983, 991}, {997, 1009, 1013}, {1019, 1021, 1031}};
    private static int[] primeProducts;
    private static final long IMASK = 0xFFFFFFFFL;
    private static final int[] ZERO_MAGNITUDE;
    public static final BigInteger ZERO;
    public static final BigInteger ONE;
    private static final BigInteger TWO;
    private static final BigInteger THREE;
    private int sign;
    private int[] magnitude;
    private int nBits = -1;
    private int nBitLength = -1;
    private long mQuote = -1L;
    private static final int BITS_PER_BYTE = 8;
    private static final int BYTES_PER_INT = 4;
    private static final byte[] rndMask;
    private static final byte[] bitCounts;

    private BigInteger() {
    }

    private BigInteger(int signum, int[] mag) {
        if (mag.length > 0) {
            int i2;
            this.sign = signum;
            for (i2 = 0; i2 < mag.length && mag[i2] == 0; ++i2) {
            }
            if (i2 == 0) {
                this.magnitude = mag;
            } else {
                int[] newMag = new int[mag.length - i2];
                System.arraycopy(mag, i2, newMag, 0, newMag.length);
                this.magnitude = newMag;
                if (newMag.length == 0) {
                    this.sign = 0;
                }
            }
        } else {
            this.magnitude = mag;
            this.sign = 0;
        }
    }

    public BigInteger(String sval) throws NumberFormatException {
        this(sval, 10);
    }

    public BigInteger(String sval, int rdx) throws NumberFormatException {
        if (sval.length() == 0) {
            throw new NumberFormatException("Zero length BigInteger");
        }
        if (rdx < 2 || rdx > 36) {
            throw new NumberFormatException("Radix out of range");
        }
        int index = 0;
        this.sign = 1;
        if (sval.charAt(0) == '-') {
            if (sval.length() == 1) {
                throw new NumberFormatException("Zero length BigInteger");
            }
            this.sign = -1;
            index = 1;
        }
        while (index < sval.length() && Character.digit(sval.charAt(index), rdx) == 0) {
            ++index;
        }
        if (index >= sval.length()) {
            this.sign = 0;
            this.magnitude = new int[0];
            return;
        }
        BigInteger b2 = ZERO;
        BigInteger r2 = BigInteger.valueOf(rdx);
        while (index < sval.length()) {
            b2 = b2.multiply(r2).add(BigInteger.valueOf(Character.digit(sval.charAt(index), rdx)));
            ++index;
        }
        this.magnitude = b2.magnitude;
    }

    public BigInteger(byte[] bval) throws NumberFormatException {
        if (bval.length == 0) {
            throw new NumberFormatException("Zero length BigInteger");
        }
        this.sign = 1;
        if (bval[0] < 0) {
            this.sign = -1;
        }
        this.magnitude = this.makeMagnitude(bval, this.sign);
        if (this.magnitude.length == 0) {
            this.sign = 0;
        }
    }

    private int[] makeMagnitude(byte[] bval, int sign) {
        int i2;
        int firstSignificant;
        if (sign >= 0) {
            int firstSignificant2;
            for (firstSignificant2 = 0; firstSignificant2 < bval.length && bval[firstSignificant2] == 0; ++firstSignificant2) {
            }
            if (firstSignificant2 >= bval.length) {
                return new int[0];
            }
            int nInts = (bval.length - firstSignificant2 + 3) / 4;
            int bCount = (bval.length - firstSignificant2) % 4;
            if (bCount == 0) {
                bCount = 4;
            }
            int[] mag = new int[nInts];
            int v2 = 0;
            int magnitudeIndex = 0;
            for (int i3 = firstSignificant2; i3 < bval.length; ++i3) {
                v2 <<= 8;
                v2 |= bval[i3] & 0xFF;
                if (--bCount > 0) continue;
                mag[magnitudeIndex] = v2;
                ++magnitudeIndex;
                bCount = 4;
                v2 = 0;
            }
            return mag;
        }
        for (firstSignificant = 0; firstSignificant < bval.length - 1 && bval[firstSignificant] == 255; ++firstSignificant) {
        }
        int nBytes = bval.length;
        boolean leadingByte = false;
        if (bval[firstSignificant] == 128) {
            for (i2 = firstSignificant + 1; i2 < bval.length && bval[i2] == 0; ++i2) {
            }
            if (i2 == bval.length) {
                ++nBytes;
                leadingByte = true;
            }
        }
        int nInts = (nBytes - firstSignificant + 3) / 4;
        int bCount = (nBytes - firstSignificant) % 4;
        if (bCount == 0) {
            bCount = 4;
        }
        int[] mag = new int[nInts];
        int v3 = 0;
        int magnitudeIndex = 0;
        if (leadingByte && --bCount <= 0) {
            ++magnitudeIndex;
            bCount = 4;
        }
        for (i2 = firstSignificant; i2 < bval.length; ++i2) {
            v3 <<= 8;
            v3 |= ~bval[i2] & 0xFF;
            if (--bCount > 0) continue;
            mag[magnitudeIndex] = v3;
            ++magnitudeIndex;
            bCount = 4;
            v3 = 0;
        }
        if ((mag = this.inc(mag))[0] == 0) {
            int[] tmp = new int[mag.length - 1];
            System.arraycopy(mag, 1, tmp, 0, tmp.length);
            mag = tmp;
        }
        return mag;
    }

    public BigInteger(int sign, byte[] mag) throws NumberFormatException {
        if (sign < -1 || sign > 1) {
            throw new NumberFormatException("Invalid sign value");
        }
        if (sign == 0) {
            this.sign = 0;
            this.magnitude = new int[0];
            return;
        }
        this.magnitude = this.makeMagnitude(mag, 1);
        this.sign = sign;
    }

    public BigInteger(int numBits, Random rnd) throws IllegalArgumentException {
        if (numBits < 0) {
            throw new IllegalArgumentException("numBits must be non-negative");
        }
        this.nBits = -1;
        this.nBitLength = -1;
        if (numBits == 0) {
            this.magnitude = ZERO_MAGNITUDE;
            return;
        }
        int nBytes = (numBits + 7) / 8;
        byte[] b2 = new byte[nBytes];
        this.nextRndBytes(rnd, b2);
        b2[0] = (byte)(b2[0] & rndMask[8 * nBytes - numBits]);
        this.magnitude = this.makeMagnitude(b2, 1);
        this.sign = this.magnitude.length < 1 ? 0 : 1;
    }

    private void nextRndBytes(Random rnd, byte[] bytes) {
        int numRequested = bytes.length;
        int numGot = 0;
        int r2 = 0;
        block0: while (true) {
            int i2 = 0;
            while (true) {
                if (i2 >= 4) continue block0;
                if (numGot == numRequested) {
                    return;
                }
                r2 = i2 == 0 ? rnd.nextInt() : r2 >> 8;
                bytes[numGot++] = (byte)r2;
                ++i2;
            }
            break;
        }
    }

    /*
     * Unable to fully structure code
     */
    public BigInteger(int bitLength, int certainty, Random rnd) throws ArithmeticException {
        super();
        if (bitLength < 2) {
            throw new ArithmeticException("bitLength < 2");
        }
        this.sign = 1;
        this.nBitLength = bitLength;
        if (bitLength == 2) {
            this.magnitude = rnd.nextInt() < 0 ? BigInteger.TWO.magnitude : BigInteger.THREE.magnitude;
            return;
        }
        nBytes = (bitLength + 7) / 8;
        xBits = 8 * nBytes - bitLength;
        mask = BigInteger.rndMask[xBits];
        b = new byte[nBytes];
        block0: while (true) {
            this.nextRndBytes(rnd, b);
            b[0] = (byte)(b[0] & mask);
            b[0] = (byte)(b[0] | (byte)(1 << 7 - xBits));
            v0 = nBytes - 1;
            b[v0] = (byte)(b[v0] | 1);
            this.magnitude = this.makeMagnitude(b, 1);
            this.nBits = -1;
            this.mQuote = -1L;
            if (certainty < 1 || this.isProbablePrime(certainty)) break;
            if (bitLength <= 32) continue;
            rep = 0;
            while (true) {
                if (rep < 10000) ** break;
                continue block0;
                n = 33 + (rnd.nextInt() >>> 1) % (bitLength - 2);
                v1 = this.magnitude.length - (n >>> 5);
                this.magnitude[v1] = this.magnitude[v1] ^ 1 << (n & 31);
                v2 = this.magnitude.length - 1;
                this.magnitude[v2] = this.magnitude[v2] ^ rnd.nextInt() << 1;
                this.mQuote = -1L;
                if (this.isProbablePrime(certainty)) {
                    return;
                }
                ++rep;
            }
            break;
        }
    }

    public BigInteger abs() {
        return this.sign >= 0 ? this : this.negate();
    }

    private int[] add(int[] a2, int[] b2) {
        int tI = a2.length - 1;
        int vI = b2.length - 1;
        long m2 = 0L;
        while (vI >= 0) {
            a2[tI--] = (int)(m2 += ((long)a2[tI] & 0xFFFFFFFFL) + ((long)b2[vI--] & 0xFFFFFFFFL));
            m2 >>>= 32;
        }
        while (tI >= 0 && m2 != 0L) {
            a2[tI--] = (int)(m2 += (long)a2[tI] & 0xFFFFFFFFL);
            m2 >>>= 32;
        }
        return a2;
    }

    private int[] inc(int[] a2) {
        int tI = a2.length - 1;
        long m2 = 0L;
        m2 = ((long)a2[tI] & 0xFFFFFFFFL) + 1L;
        a2[tI--] = (int)m2;
        m2 >>>= 32;
        while (tI >= 0 && m2 != 0L) {
            a2[tI--] = (int)(m2 += (long)a2[tI] & 0xFFFFFFFFL);
            m2 >>>= 32;
        }
        return a2;
    }

    public BigInteger add(BigInteger val) throws ArithmeticException {
        if (val.sign == 0 || val.magnitude.length == 0) {
            return this;
        }
        if (this.sign == 0 || this.magnitude.length == 0) {
            return val;
        }
        if (val.sign < 0) {
            if (this.sign > 0) {
                return this.subtract(val.negate());
            }
        } else if (this.sign < 0) {
            return val.subtract(this.negate());
        }
        return this.addToMagnitude(val.magnitude);
    }

    private BigInteger addToMagnitude(int[] magToAdd) {
        int[] small;
        int[] big;
        if (this.magnitude.length < magToAdd.length) {
            big = magToAdd;
            small = this.magnitude;
        } else {
            big = this.magnitude;
            small = magToAdd;
        }
        int limit = Integer.MAX_VALUE;
        if (big.length == small.length) {
            limit -= small[0];
        }
        boolean possibleOverflow = (big[0] ^ Integer.MIN_VALUE) >= limit;
        int extra = possibleOverflow ? 1 : 0;
        int[] bigCopy = new int[big.length + extra];
        System.arraycopy(big, 0, bigCopy, extra, big.length);
        bigCopy = this.add(bigCopy, small);
        return new BigInteger(this.sign, bigCopy);
    }

    public BigInteger and(BigInteger value) {
        if (this.sign == 0 || value.sign == 0) {
            return ZERO;
        }
        int[] aMag = this.sign > 0 ? this.magnitude : this.add((BigInteger)BigInteger.ONE).magnitude;
        int[] bMag = value.sign > 0 ? value.magnitude : value.add((BigInteger)BigInteger.ONE).magnitude;
        boolean resultNeg = this.sign < 0 && value.sign < 0;
        int resultLength = Math.max(aMag.length, bMag.length);
        int[] resultMag = new int[resultLength];
        int aStart = resultMag.length - aMag.length;
        int bStart = resultMag.length - bMag.length;
        for (int i2 = 0; i2 < resultMag.length; ++i2) {
            int bWord;
            int aWord = i2 >= aStart ? aMag[i2 - aStart] : 0;
            int n2 = bWord = i2 >= bStart ? bMag[i2 - bStart] : 0;
            if (this.sign < 0) {
                aWord ^= 0xFFFFFFFF;
            }
            if (value.sign < 0) {
                bWord ^= 0xFFFFFFFF;
            }
            resultMag[i2] = aWord & bWord;
            if (!resultNeg) continue;
            resultMag[i2] = ~resultMag[i2];
        }
        BigInteger result = new BigInteger(1, resultMag);
        if (resultNeg) {
            result = result.not();
        }
        return result;
    }

    public BigInteger andNot(BigInteger value) {
        return this.and(value.not());
    }

    public int bitCount() {
        if (this.nBits == -1) {
            if (this.sign < 0) {
                this.nBits = this.not().bitCount();
            } else {
                int sum = 0;
                for (int i2 = 0; i2 < this.magnitude.length; ++i2) {
                    sum += bitCounts[this.magnitude[i2] & 0xFF];
                    sum += bitCounts[this.magnitude[i2] >> 8 & 0xFF];
                    sum += bitCounts[this.magnitude[i2] >> 16 & 0xFF];
                    sum += bitCounts[this.magnitude[i2] >> 24 & 0xFF];
                }
                this.nBits = sum;
            }
        }
        return this.nBits;
    }

    private int bitLength(int indx, int[] mag) {
        if (mag.length == 0) {
            return 0;
        }
        while (indx != mag.length && mag[indx] == 0) {
            ++indx;
        }
        if (indx == mag.length) {
            return 0;
        }
        int bitLength = 32 * (mag.length - indx - 1);
        bitLength += BigInteger.bitLen(mag[indx]);
        if (this.sign < 0) {
            boolean pow2 = bitCounts[mag[indx] & 0xFF] + bitCounts[mag[indx] >> 8 & 0xFF] + bitCounts[mag[indx] >> 16 & 0xFF] + bitCounts[mag[indx] >> 24 & 0xFF] == 1;
            for (int i2 = indx + 1; i2 < mag.length && pow2; ++i2) {
                pow2 = mag[i2] == 0;
            }
            bitLength -= pow2 ? 1 : 0;
        }
        return bitLength;
    }

    public int bitLength() {
        if (this.nBitLength == -1) {
            this.nBitLength = this.sign == 0 ? 0 : this.bitLength(0, this.magnitude);
        }
        return this.nBitLength;
    }

    static int bitLen(int w2) {
        return w2 < 32768 ? (w2 < 128 ? (w2 < 8 ? (w2 < 2 ? (w2 < 1 ? (w2 < 0 ? 32 : 0) : 1) : (w2 < 4 ? 2 : 3)) : (w2 < 32 ? (w2 < 16 ? 4 : 5) : (w2 < 64 ? 6 : 7))) : (w2 < 2048 ? (w2 < 512 ? (w2 < 256 ? 8 : 9) : (w2 < 1024 ? 10 : 11)) : (w2 < 8192 ? (w2 < 4096 ? 12 : 13) : (w2 < 16384 ? 14 : 15)))) : (w2 < 0x800000 ? (w2 < 524288 ? (w2 < 131072 ? (w2 < 65536 ? 16 : 17) : (w2 < 262144 ? 18 : 19)) : (w2 < 0x200000 ? (w2 < 0x100000 ? 20 : 21) : (w2 < 0x400000 ? 22 : 23))) : (w2 < 0x8000000 ? (w2 < 0x2000000 ? (w2 < 0x1000000 ? 24 : 25) : (w2 < 0x4000000 ? 26 : 27)) : (w2 < 0x20000000 ? (w2 < 0x10000000 ? 28 : 29) : (w2 < 0x40000000 ? 30 : 31))));
    }

    private boolean quickPow2Check() {
        return this.sign > 0 && this.nBits == 1;
    }

    public int compareTo(Object o2) {
        return this.compareTo((BigInteger)o2);
    }

    private int compareTo(int xIndx, int[] x2, int yIndx, int[] y2) {
        while (xIndx != x2.length && x2[xIndx] == 0) {
            ++xIndx;
        }
        while (yIndx != y2.length && y2[yIndx] == 0) {
            ++yIndx;
        }
        return this.compareNoLeadingZeroes(xIndx, x2, yIndx, y2);
    }

    private int compareNoLeadingZeroes(int xIndx, int[] x2, int yIndx, int[] y2) {
        int diff = x2.length - y2.length - (xIndx - yIndx);
        if (diff != 0) {
            return diff < 0 ? -1 : 1;
        }
        while (xIndx < x2.length) {
            int v2;
            int v1;
            if ((v1 = x2[xIndx++]) == (v2 = y2[yIndx++])) continue;
            return (v1 ^ Integer.MIN_VALUE) < (v2 ^ Integer.MIN_VALUE) ? -1 : 1;
        }
        return 0;
    }

    public int compareTo(BigInteger val) {
        if (this.sign < val.sign) {
            return -1;
        }
        if (this.sign > val.sign) {
            return 1;
        }
        if (this.sign == 0) {
            return 0;
        }
        return this.sign * this.compareTo(0, this.magnitude, 0, val.magnitude);
    }

    private int[] divide(int[] x2, int[] y2) {
        int[] count;
        int xyCmp = this.compareTo(0, x2, 0, y2);
        if (xyCmp > 0) {
            int[] c2;
            int shift = this.bitLength(0, x2) - this.bitLength(0, y2);
            if (shift > 1) {
                c2 = this.shiftLeft(y2, shift - 1);
                count = this.shiftLeft(BigInteger.ONE.magnitude, shift - 1);
                if (shift % 32 == 0) {
                    int[] countSpecial = new int[shift / 32 + 1];
                    System.arraycopy(count, 0, countSpecial, 1, countSpecial.length - 1);
                    countSpecial[0] = 0;
                    count = countSpecial;
                }
            } else {
                c2 = new int[x2.length];
                count = new int[1];
                System.arraycopy(y2, 0, c2, c2.length - y2.length, y2.length);
                count[0] = 1;
            }
            int[] iCount = new int[count.length];
            this.subtract(0, x2, 0, c2);
            System.arraycopy(count, 0, iCount, 0, count.length);
            int xStart = 0;
            int cStart = 0;
            int iCountStart = 0;
            while (true) {
                int cmp = this.compareTo(xStart, x2, cStart, c2);
                while (cmp >= 0) {
                    this.subtract(xStart, x2, cStart, c2);
                    this.add(count, iCount);
                    cmp = this.compareTo(xStart, x2, cStart, c2);
                }
                xyCmp = this.compareTo(xStart, x2, 0, y2);
                if (xyCmp <= 0) break;
                if (x2[xStart] == 0) {
                    ++xStart;
                }
                if ((shift = this.bitLength(cStart, c2) - this.bitLength(xStart, x2)) == 0) {
                    c2 = this.shiftRightOneInPlace(cStart, c2);
                    iCount = this.shiftRightOneInPlace(iCountStart, iCount);
                } else {
                    c2 = this.shiftRightInPlace(cStart, c2, shift);
                    iCount = this.shiftRightInPlace(iCountStart, iCount, shift);
                }
                if (c2[cStart] == 0) {
                    ++cStart;
                }
                if (iCount[iCountStart] != 0) continue;
                ++iCountStart;
            }
            if (xyCmp == 0) {
                this.add(count, BigInteger.ONE.magnitude);
                for (int i2 = xStart; i2 != x2.length; ++i2) {
                    x2[i2] = 0;
                }
            }
        } else {
            count = xyCmp == 0 ? new int[]{1} : new int[]{0};
        }
        return count;
    }

    public BigInteger divide(BigInteger val) throws ArithmeticException {
        if (val.sign == 0) {
            throw new ArithmeticException("Divide by zero");
        }
        if (this.sign == 0) {
            return ZERO;
        }
        if (val.compareTo(ONE) == 0) {
            return this;
        }
        int[] mag = new int[this.magnitude.length];
        System.arraycopy(this.magnitude, 0, mag, 0, mag.length);
        return new BigInteger(this.sign * val.sign, this.divide(mag, val.magnitude));
    }

    public BigInteger[] divideAndRemainder(BigInteger val) throws ArithmeticException {
        if (val.sign == 0) {
            throw new ArithmeticException("Divide by zero");
        }
        BigInteger[] biggies = new BigInteger[2];
        if (this.sign == 0) {
            biggies[0] = biggies[1] = ZERO;
            return biggies;
        }
        if (val.compareTo(ONE) == 0) {
            biggies[0] = this;
            biggies[1] = ZERO;
            return biggies;
        }
        int[] remainder = new int[this.magnitude.length];
        System.arraycopy(this.magnitude, 0, remainder, 0, remainder.length);
        int[] quotient = this.divide(remainder, val.magnitude);
        biggies[0] = new BigInteger(this.sign * val.sign, quotient);
        biggies[1] = new BigInteger(this.sign, remainder);
        return biggies;
    }

    public boolean equals(Object val) {
        if (val == this) {
            return true;
        }
        if (!(val instanceof BigInteger)) {
            return false;
        }
        BigInteger biggie = (BigInteger)val;
        if (biggie.sign != this.sign || biggie.magnitude.length != this.magnitude.length) {
            return false;
        }
        for (int i2 = 0; i2 < this.magnitude.length; ++i2) {
            if (biggie.magnitude[i2] == this.magnitude[i2]) continue;
            return false;
        }
        return true;
    }

    public BigInteger gcd(BigInteger val) {
        if (val.sign == 0) {
            return this.abs();
        }
        if (this.sign == 0) {
            return val.abs();
        }
        BigInteger u2 = this;
        BigInteger v2 = val;
        while (v2.sign != 0) {
            BigInteger r2 = u2.mod(v2);
            u2 = v2;
            v2 = r2;
        }
        return u2;
    }

    public int hashCode() {
        int hc = this.magnitude.length;
        if (this.magnitude.length > 0) {
            hc ^= this.magnitude[0];
            if (this.magnitude.length > 1) {
                hc ^= this.magnitude[this.magnitude.length - 1];
            }
        }
        return this.sign < 0 ? ~hc : hc;
    }

    public int intValue() {
        if (this.magnitude.length == 0) {
            return 0;
        }
        if (this.sign < 0) {
            return -this.magnitude[this.magnitude.length - 1];
        }
        return this.magnitude[this.magnitude.length - 1];
    }

    public byte byteValue() {
        return (byte)this.intValue();
    }

    public boolean isProbablePrime(int certainty) {
        if (certainty <= 0) {
            return true;
        }
        if (this.sign == 0) {
            return false;
        }
        BigInteger n2 = this.abs();
        if (!n2.testBit(0)) {
            return n2.equals(TWO);
        }
        if (n2.equals(ONE)) {
            return false;
        }
        int numLists = Math.min(n2.bitLength() - 1, primeLists.length);
        for (int i2 = 0; i2 < numLists; ++i2) {
            int test = n2.remainder(primeProducts[i2]);
            int[] primeList = primeLists[i2];
            for (int j2 = 0; j2 < primeList.length; ++j2) {
                int prime = primeList[j2];
                int qRem = test % prime;
                if (qRem != 0) continue;
                return n2.bitLength() < 16 && n2.intValue() == prime;
            }
        }
        BigInteger nMinusOne = n2.subtract(ONE);
        int s2 = nMinusOne.getLowestSetBit();
        BigInteger r2 = nMinusOne.shiftRight(s2);
        Random random = new Random();
        while (true) {
            BigInteger a2;
            if ((a2 = new BigInteger(n2.bitLength(), random)).compareTo(ONE) <= 0 || a2.compareTo(nMinusOne) >= 0) {
                continue;
            }
            BigInteger y2 = a2.modPow(r2, n2);
            if (!y2.equals(ONE)) {
                int j3 = 0;
                while (!y2.equals(nMinusOne)) {
                    if (++j3 == s2) {
                        return false;
                    }
                    if (!(y2 = y2.modPow(TWO, n2)).equals(ONE)) continue;
                    return false;
                }
            }
            if ((certainty -= 2) <= 0) break;
        }
        return true;
    }

    public long longValue() {
        long val = 0L;
        if (this.magnitude.length == 0) {
            return 0L;
        }
        val = this.magnitude.length > 1 ? (long)this.magnitude[this.magnitude.length - 2] << 32 | (long)this.magnitude[this.magnitude.length - 1] & 0xFFFFFFFFL : (long)this.magnitude[this.magnitude.length - 1] & 0xFFFFFFFFL;
        if (this.sign < 0) {
            return -val;
        }
        return val;
    }

    public BigInteger max(BigInteger val) {
        return this.compareTo(val) > 0 ? this : val;
    }

    public BigInteger min(BigInteger val) {
        return this.compareTo(val) < 0 ? this : val;
    }

    public BigInteger mod(BigInteger m2) throws ArithmeticException {
        if (m2.sign <= 0) {
            throw new ArithmeticException("BigInteger: modulus is not positive");
        }
        BigInteger biggie = this.remainder(m2);
        return biggie.sign >= 0 ? biggie : biggie.add(m2);
    }

    public BigInteger modInverse(BigInteger m2) throws ArithmeticException {
        if (m2.sign != 1) {
            throw new ArithmeticException("Modulus must be positive");
        }
        BigInteger x2 = new BigInteger();
        BigInteger gcd = BigInteger.extEuclid(this, m2, x2, null);
        if (!gcd.equals(ONE)) {
            throw new ArithmeticException("Numbers not relatively prime.");
        }
        if (x2.compareTo(ZERO) < 0) {
            x2 = x2.add(m2);
        }
        return x2;
    }

    private static BigInteger extEuclid(BigInteger a2, BigInteger b2, BigInteger u1Out, BigInteger u2Out) {
        BigInteger u1 = ONE;
        BigInteger u3 = a2;
        BigInteger v1 = ZERO;
        BigInteger v3 = b2;
        while (v3.sign > 0) {
            BigInteger[] q2 = u3.divideAndRemainder(v3);
            BigInteger tn = u1.subtract(v1.multiply(q2[0]));
            u1 = v1;
            v1 = tn;
            u3 = v3;
            v3 = q2[1];
        }
        if (u1Out != null) {
            u1Out.sign = u1.sign;
            u1Out.magnitude = u1.magnitude;
        }
        if (u2Out != null) {
            BigInteger res = u3.subtract(u1.multiply(a2)).divide(b2);
            u2Out.sign = res.sign;
            u2Out.magnitude = res.magnitude;
        }
        return u3;
    }

    private void zero(int[] x2) {
        for (int i2 = 0; i2 != x2.length; ++i2) {
            x2[i2] = 0;
        }
    }

    public BigInteger modPow(BigInteger exponent, BigInteger m2) throws ArithmeticException {
        BigInteger tmp;
        if (m2.sign < 1) {
            throw new ArithmeticException("Modulus must be positive");
        }
        if (m2.equals(ONE)) {
            return ZERO;
        }
        if (exponent.sign == 0) {
            return ONE;
        }
        if (this.sign == 0) {
            return ZERO;
        }
        int[] zVal = null;
        int[] yAccum = null;
        boolean useMonty = (m2.magnitude[m2.magnitude.length - 1] & 1) == 1;
        long mQ = 0L;
        if (useMonty) {
            mQ = m2.getMQuote();
            tmp = this.shiftLeft(32 * m2.magnitude.length).mod(m2);
            zVal = tmp.magnitude;
            boolean bl = useMonty = zVal.length <= m2.magnitude.length;
            if (useMonty) {
                yAccum = new int[m2.magnitude.length + 1];
                if (zVal.length < m2.magnitude.length) {
                    int[] longZ = new int[m2.magnitude.length];
                    System.arraycopy(zVal, 0, longZ, longZ.length - zVal.length, zVal.length);
                    zVal = longZ;
                }
            }
        }
        if (!useMonty) {
            if (this.magnitude.length <= m2.magnitude.length) {
                zVal = new int[m2.magnitude.length];
                System.arraycopy(this.magnitude, 0, zVal, zVal.length - this.magnitude.length, this.magnitude.length);
            } else {
                tmp = this.remainder(m2);
                zVal = new int[m2.magnitude.length];
                System.arraycopy(tmp.magnitude, 0, zVal, zVal.length - tmp.magnitude.length, tmp.magnitude.length);
            }
            yAccum = new int[m2.magnitude.length * 2];
        }
        int[] yVal = new int[m2.magnitude.length];
        for (int i2 = 0; i2 < exponent.magnitude.length; ++i2) {
            int v2 = exponent.magnitude[i2];
            int bits = 0;
            if (i2 == 0) {
                while (v2 > 0) {
                    v2 <<= 1;
                    ++bits;
                }
                System.arraycopy(zVal, 0, yVal, 0, zVal.length);
                v2 <<= 1;
                ++bits;
            }
            while (v2 != 0) {
                if (useMonty) {
                    this.multiplyMonty(yAccum, yVal, yVal, m2.magnitude, mQ);
                } else {
                    this.square(yAccum, yVal);
                    this.remainder(yAccum, m2.magnitude);
                    System.arraycopy(yAccum, yAccum.length - yVal.length, yVal, 0, yVal.length);
                    this.zero(yAccum);
                }
                ++bits;
                if (v2 < 0) {
                    if (useMonty) {
                        this.multiplyMonty(yAccum, yVal, zVal, m2.magnitude, mQ);
                    } else {
                        this.multiply(yAccum, yVal, zVal);
                        this.remainder(yAccum, m2.magnitude);
                        System.arraycopy(yAccum, yAccum.length - yVal.length, yVal, 0, yVal.length);
                        this.zero(yAccum);
                    }
                }
                v2 <<= 1;
            }
            while (bits < 32) {
                if (useMonty) {
                    this.multiplyMonty(yAccum, yVal, yVal, m2.magnitude, mQ);
                } else {
                    this.square(yAccum, yVal);
                    this.remainder(yAccum, m2.magnitude);
                    System.arraycopy(yAccum, yAccum.length - yVal.length, yVal, 0, yVal.length);
                    this.zero(yAccum);
                }
                ++bits;
            }
        }
        if (useMonty) {
            this.zero(zVal);
            zVal[zVal.length - 1] = 1;
            this.multiplyMonty(yAccum, yVal, zVal, m2.magnitude, mQ);
        }
        BigInteger result = new BigInteger(1, yVal);
        return exponent.sign > 0 ? result : result.modInverse(m2);
    }

    private int[] square(int[] w2, int[] x2) {
        long u2;
        long u1;
        int wBase = w2.length - 1;
        for (int i2 = x2.length - 1; i2 != 0; --i2) {
            long v2 = (long)x2[i2] & 0xFFFFFFFFL;
            u1 = v2 * v2;
            u2 = u1 >>> 32;
            u1 &= 0xFFFFFFFFL;
            w2[wBase] = (int)(u1 += (long)w2[wBase] & 0xFFFFFFFFL);
            long c2 = u2 + (u1 >> 32);
            for (int j2 = i2 - 1; j2 >= 0; --j2) {
                u1 = ((long)x2[j2] & 0xFFFFFFFFL) * v2;
                u2 = u1 >>> 31;
                u1 = (u1 & Integer.MAX_VALUE) << 1;
                w2[wBase] = (int)(u1 += ((long)w2[--wBase] & 0xFFFFFFFFL) + c2);
                c2 = u2 + (u1 >>> 32);
            }
            w2[wBase] = (int)(c2 += (long)w2[--wBase] & 0xFFFFFFFFL);
            if (--wBase >= 0) {
                w2[wBase] = (int)(c2 >> 32);
            }
            wBase += i2;
        }
        u1 = (long)x2[0] & 0xFFFFFFFFL;
        u1 *= u1;
        u2 = u1 >>> 32;
        u1 &= 0xFFFFFFFFL;
        w2[wBase] = (int)(u1 += (long)w2[wBase] & 0xFFFFFFFFL);
        if (--wBase >= 0) {
            w2[wBase] = (int)(u2 + (u1 >> 32) + (long)w2[wBase]);
        }
        return w2;
    }

    private int[] multiply(int[] x2, int[] y2, int[] z2) {
        int i2 = z2.length;
        if (i2 < 1) {
            return x2;
        }
        int xBase = x2.length - y2.length;
        while (true) {
            long a2 = (long)z2[--i2] & 0xFFFFFFFFL;
            long val = 0L;
            for (int j2 = y2.length - 1; j2 >= 0; --j2) {
                x2[xBase + j2] = (int)(val += a2 * ((long)y2[j2] & 0xFFFFFFFFL) + ((long)x2[xBase + j2] & 0xFFFFFFFFL));
                val >>>= 32;
            }
            --xBase;
            if (i2 < 1) {
                if (xBase < 0) break;
                x2[xBase] = (int)val;
                break;
            }
            x2[xBase] = (int)val;
        }
        return x2;
    }

    private long _extEuclid(long a2, long b2, long[] uOut) {
        long res;
        long u1 = 1L;
        long u3 = a2;
        long v1 = 0L;
        long v3 = b2;
        while (v3 > 0L) {
            long q2 = u3 / v3;
            long tn = u1 - v1 * q2;
            u1 = v1;
            v1 = tn;
            tn = u3 - v3 * q2;
            u3 = v3;
            v3 = tn;
        }
        uOut[0] = u1;
        uOut[1] = res = (u3 - u1 * a2) / b2;
        return u3;
    }

    private long _modInverse(long v2, long m2) throws ArithmeticException {
        if (m2 < 0L) {
            throw new ArithmeticException("Modulus must be positive");
        }
        long[] x2 = new long[2];
        long gcd = this._extEuclid(v2, m2, x2);
        if (gcd != 1L) {
            throw new ArithmeticException("Numbers not relatively prime.");
        }
        if (x2[0] < 0L) {
            x2[0] = x2[0] + m2;
        }
        return x2[0];
    }

    private long getMQuote() {
        if (this.mQuote != -1L) {
            return this.mQuote;
        }
        if ((this.magnitude[this.magnitude.length - 1] & 1) == 0) {
            return -1L;
        }
        long v2 = (long)(~this.magnitude[this.magnitude.length - 1] | 1) & 0xFFFFFFFFL;
        this.mQuote = this._modInverse(v2, 0x100000000L);
        return this.mQuote;
    }

    private void multiplyMonty(int[] a2, int[] x2, int[] y2, int[] m2, long mQuote) {
        int i2;
        int n2 = m2.length;
        int nMinus1 = n2 - 1;
        long y_0 = (long)y2[n2 - 1] & 0xFFFFFFFFL;
        for (i2 = 0; i2 <= n2; ++i2) {
            a2[i2] = 0;
        }
        for (i2 = n2; i2 > 0; --i2) {
            long x_i = (long)x2[i2 - 1] & 0xFFFFFFFFL;
            long u2 = (((long)a2[n2] & 0xFFFFFFFFL) + (x_i * y_0 & 0xFFFFFFFFL) & 0xFFFFFFFFL) * mQuote & 0xFFFFFFFFL;
            long prod1 = x_i * y_0;
            long prod2 = u2 * ((long)m2[n2 - 1] & 0xFFFFFFFFL);
            long tmp = ((long)a2[n2] & 0xFFFFFFFFL) + (prod1 & 0xFFFFFFFFL) + (prod2 & 0xFFFFFFFFL);
            long carry = (prod1 >>> 32) + (prod2 >>> 32) + (tmp >>> 32);
            for (int j2 = nMinus1; j2 > 0; --j2) {
                prod1 = x_i * ((long)y2[j2 - 1] & 0xFFFFFFFFL);
                prod2 = u2 * ((long)m2[j2 - 1] & 0xFFFFFFFFL);
                tmp = ((long)a2[j2] & 0xFFFFFFFFL) + (prod1 & 0xFFFFFFFFL) + (prod2 & 0xFFFFFFFFL) + (carry & 0xFFFFFFFFL);
                carry = (carry >>> 32) + (prod1 >>> 32) + (prod2 >>> 32) + (tmp >>> 32);
                a2[j2 + 1] = (int)tmp;
            }
            a2[1] = (int)(carry += (long)a2[0] & 0xFFFFFFFFL);
            a2[0] = (int)(carry >>> 32);
        }
        if (this.compareTo(0, a2, 0, m2) >= 0) {
            this.subtract(0, a2, 0, m2);
        }
        System.arraycopy(a2, 1, x2, 0, n2);
    }

    public BigInteger multiply(BigInteger val) {
        if (this.sign == 0 || val.sign == 0) {
            return ZERO;
        }
        int maxBitLength = this.bitLength() + val.bitLength();
        int resLength = (maxBitLength + 31) / 32;
        int[] res = new int[resLength];
        if (val == this) {
            this.square(res, this.magnitude);
        } else {
            this.multiply(res, this.magnitude, val.magnitude);
        }
        return new BigInteger(this.sign * val.sign, res);
    }

    public BigInteger negate() {
        if (this.sign == 0) {
            return this;
        }
        return new BigInteger(-this.sign, this.magnitude);
    }

    public BigInteger not() {
        return this.add(ONE).negate();
    }

    public BigInteger pow(int exp) throws ArithmeticException {
        if (exp < 0) {
            throw new ArithmeticException("Negative exponent");
        }
        if (this.sign == 0) {
            return exp == 0 ? ONE : this;
        }
        BigInteger y2 = ONE;
        BigInteger z2 = this;
        while (exp != 0) {
            if ((exp & 1) == 1) {
                y2 = y2.multiply(z2);
            }
            if ((exp >>= 1) == 0) continue;
            z2 = z2.multiply(z2);
        }
        return y2;
    }

    public static BigInteger probablePrime(int bitLength, Random random) {
        return new BigInteger(bitLength, 100, random);
    }

    private int remainder(int m2) {
        long acc = 0L;
        for (int pos = 0; pos < this.magnitude.length; ++pos) {
            acc = (acc << 32 | (long)this.magnitude[pos] & 0xFFFFFFFFL) % (long)m2;
        }
        return (int)acc;
    }

    private int[] remainder(int[] x2, int[] y2) {
        int yStart;
        int xStart;
        for (xStart = 0; xStart < x2.length && x2[xStart] == 0; ++xStart) {
        }
        for (yStart = 0; yStart < y2.length && y2[yStart] == 0; ++yStart) {
        }
        int xyCmp = this.compareNoLeadingZeroes(xStart, x2, yStart, y2);
        if (xyCmp > 0) {
            int[] c2;
            int yBitLength = this.bitLength(yStart, y2);
            int xBitLength = this.bitLength(xStart, x2);
            int shift = xBitLength - yBitLength;
            int cStart = 0;
            int cBitLength = yBitLength;
            if (shift > 0) {
                c2 = this.shiftLeft(y2, shift);
                cBitLength += shift;
            } else {
                int len = y2.length - yStart;
                c2 = new int[len];
                System.arraycopy(y2, yStart, c2, 0, len);
            }
            block2: while (true) {
                if (cBitLength < xBitLength || this.compareNoLeadingZeroes(xStart, x2, cStart, c2) >= 0) {
                    this.subtract(xStart, x2, cStart, c2);
                    while (x2[xStart] == 0) {
                        if (++xStart != x2.length) continue;
                        return x2;
                    }
                    xyCmp = this.compareNoLeadingZeroes(xStart, x2, yStart, y2);
                    if (xyCmp <= 0) break;
                    xBitLength = 32 * (x2.length - xStart - 1) + BigInteger.bitLen(x2[xStart]);
                }
                if ((shift = cBitLength - xBitLength) < 2) {
                    c2 = this.shiftRightOneInPlace(cStart, c2);
                    --cBitLength;
                } else {
                    c2 = this.shiftRightInPlace(cStart, c2, shift);
                    cBitLength -= shift;
                }
                while (true) {
                    if (c2[cStart] != 0) continue block2;
                    ++cStart;
                }
                break;
            }
        }
        if (xyCmp == 0) {
            for (int i2 = xStart; i2 < x2.length; ++i2) {
                x2[i2] = 0;
            }
        }
        return x2;
    }

    public BigInteger remainder(BigInteger n2) throws ArithmeticException {
        int[] res;
        int val;
        if (n2.sign == 0) {
            throw new ArithmeticException("BigInteger: Divide by zero");
        }
        if (this.sign == 0) {
            return ZERO;
        }
        if (n2.magnitude.length == 1 && (val = n2.magnitude[0]) > 0) {
            if (val == 1) {
                return ZERO;
            }
            int rem = this.remainder(val);
            return rem == 0 ? ZERO : new BigInteger(this.sign, new int[]{rem});
        }
        if (this.compareTo(0, this.magnitude, 0, n2.magnitude) < 0) {
            return this;
        }
        if (n2.quickPow2Check()) {
            res = this.lastNBits(n2.abs().bitLength() - 1);
        } else {
            res = new int[this.magnitude.length];
            System.arraycopy(this.magnitude, 0, res, 0, res.length);
            res = this.remainder(res, n2.magnitude);
        }
        return new BigInteger(this.sign, res);
    }

    private int[] lastNBits(int n2) {
        if (n2 < 1) {
            return ZERO_MAGNITUDE;
        }
        int numWords = (n2 + 31) / 32;
        numWords = Math.min(numWords, this.magnitude.length);
        int[] result = new int[numWords];
        System.arraycopy(this.magnitude, this.magnitude.length - numWords, result, 0, numWords);
        int hiBits = n2 % 32;
        if (hiBits != 0) {
            result[0] = result[0] & ~(-1 << hiBits);
        }
        return result;
    }

    private int[] shiftLeft(int[] mag, int n2) {
        int nInts = n2 >>> 5;
        int nBits = n2 & 0x1F;
        int magLen = mag.length;
        int[] newMag = null;
        if (nBits == 0) {
            newMag = new int[magLen + nInts];
            System.arraycopy(mag, 0, newMag, 0, magLen);
        } else {
            int i2 = 0;
            int nBits2 = 32 - nBits;
            int highBits = mag[0] >>> nBits2;
            if (highBits != 0) {
                newMag = new int[magLen + nInts + 1];
                newMag[i2++] = highBits;
            } else {
                newMag = new int[magLen + nInts];
            }
            int m2 = mag[0];
            for (int j2 = 0; j2 < magLen - 1; ++j2) {
                int next = mag[j2 + 1];
                newMag[i2++] = m2 << nBits | next >>> nBits2;
                m2 = next;
            }
            newMag[i2] = mag[magLen - 1] << nBits;
        }
        return newMag;
    }

    public BigInteger shiftLeft(int n2) {
        if (this.sign == 0 || this.magnitude.length == 0) {
            return ZERO;
        }
        if (n2 == 0) {
            return this;
        }
        if (n2 < 0) {
            return this.shiftRight(-n2);
        }
        BigInteger result = new BigInteger(this.sign, this.shiftLeft(this.magnitude, n2));
        if (this.nBits != -1) {
            int n3 = result.nBits = this.sign > 0 ? this.nBits : this.nBits + n2;
        }
        if (this.nBitLength != -1) {
            result.nBitLength = this.nBitLength + n2;
        }
        return result;
    }

    private int[] shiftRightInPlace(int start, int[] mag, int n2) {
        int nInts = (n2 >>> 5) + start;
        int nBits = n2 & 0x1F;
        int magEnd = mag.length - 1;
        if (nInts != start) {
            int i2;
            int delta = nInts - start;
            for (i2 = magEnd; i2 >= nInts; --i2) {
                mag[i2] = mag[i2 - delta];
            }
            for (i2 = nInts - 1; i2 >= start; --i2) {
                mag[i2] = 0;
            }
        }
        if (nBits != 0) {
            int nBits2 = 32 - nBits;
            int m2 = mag[magEnd];
            for (int i3 = magEnd; i3 >= nInts + 1; --i3) {
                int next = mag[i3 - 1];
                mag[i3] = m2 >>> nBits | next << nBits2;
                m2 = next;
            }
            int n3 = nInts;
            mag[n3] = mag[n3] >>> nBits;
        }
        return mag;
    }

    private int[] shiftRightOneInPlace(int start, int[] mag) {
        int magEnd = mag.length - 1;
        int m2 = mag[magEnd];
        for (int i2 = magEnd; i2 > start; --i2) {
            int next = mag[i2 - 1];
            mag[i2] = m2 >>> 1 | next << 31;
            m2 = next;
        }
        int n2 = start;
        mag[n2] = mag[n2] >>> 1;
        return mag;
    }

    public BigInteger shiftRight(int n2) {
        if (n2 == 0) {
            return this;
        }
        if (n2 < 0) {
            return this.shiftLeft(-n2);
        }
        if (n2 >= this.bitLength()) {
            return this.sign < 0 ? BigInteger.valueOf(-1L) : ZERO;
        }
        int[] res = new int[this.magnitude.length];
        System.arraycopy(this.magnitude, 0, res, 0, res.length);
        return new BigInteger(this.sign, this.shiftRightInPlace(0, res, n2));
    }

    public int signum() {
        return this.sign;
    }

    private int[] subtract(int xStart, int[] x2, int yStart, int[] y2) {
        int iT = x2.length;
        int iV = y2.length;
        int borrow = 0;
        do {
            long m2 = ((long)x2[--iT] & 0xFFFFFFFFL) - ((long)y2[--iV] & 0xFFFFFFFFL) + (long)borrow;
            x2[iT] = (int)m2;
            borrow = (int)(m2 >> 63);
        } while (iV > yStart);
        if (borrow != 0) {
            int n2;
            do {
                n2 = --iT;
            } while ((x2[n2] = x2[n2] - 1) == -1);
        }
        return x2;
    }

    public BigInteger subtract(BigInteger val) {
        BigInteger littlun;
        BigInteger bigun;
        if (val.sign == 0 || val.magnitude.length == 0) {
            return this;
        }
        if (this.sign == 0 || this.magnitude.length == 0) {
            return val.negate();
        }
        if (this.sign != val.sign) {
            return this.add(val.negate());
        }
        int compare = this.compareTo(0, this.magnitude, 0, val.magnitude);
        if (compare == 0) {
            return ZERO;
        }
        if (compare < 0) {
            bigun = val;
            littlun = this;
        } else {
            bigun = this;
            littlun = val;
        }
        int[] res = new int[bigun.magnitude.length];
        System.arraycopy(bigun.magnitude, 0, res, 0, res.length);
        return new BigInteger(this.sign * compare, this.subtract(0, res, 0, littlun.magnitude));
    }

    public byte[] toByteArray() {
        if (this.sign == 0) {
            return new byte[1];
        }
        int bitLength = this.bitLength();
        byte[] bytes = new byte[bitLength / 8 + 1];
        int magIndex = this.magnitude.length;
        int bytesIndex = bytes.length;
        if (this.sign > 0) {
            while (magIndex > 1) {
                int mag = this.magnitude[--magIndex];
                bytes[--bytesIndex] = (byte)mag;
                bytes[--bytesIndex] = (byte)(mag >>> 8);
                bytes[--bytesIndex] = (byte)(mag >>> 16);
                bytes[--bytesIndex] = (byte)(mag >>> 24);
            }
            int lastMag = this.magnitude[0];
            while ((lastMag & 0xFFFFFF00) != 0) {
                bytes[--bytesIndex] = (byte)lastMag;
                lastMag >>>= 8;
            }
            bytes[--bytesIndex] = (byte)lastMag;
        } else {
            boolean carry = true;
            while (magIndex > 1) {
                int mag = ~this.magnitude[--magIndex];
                if (carry) {
                    carry = ++mag == 0;
                }
                bytes[--bytesIndex] = (byte)mag;
                bytes[--bytesIndex] = (byte)(mag >>> 8);
                bytes[--bytesIndex] = (byte)(mag >>> 16);
                bytes[--bytesIndex] = (byte)(mag >>> 24);
            }
            int lastMag = this.magnitude[0];
            if (carry) {
                --lastMag;
            }
            while ((lastMag & 0xFFFFFF00) != 0) {
                bytes[--bytesIndex] = (byte)(~lastMag);
                lastMag >>>= 8;
            }
            bytes[--bytesIndex] = (byte)(~lastMag);
            if (bytesIndex > 0) {
                bytes[--bytesIndex] = -1;
            }
        }
        return bytes;
    }

    public BigInteger xor(BigInteger val) {
        if (this.sign == 0) {
            return val;
        }
        if (val.sign == 0) {
            return this;
        }
        int[] aMag = this.sign > 0 ? this.magnitude : this.add((BigInteger)BigInteger.ONE).magnitude;
        int[] bMag = val.sign > 0 ? val.magnitude : val.add((BigInteger)BigInteger.ONE).magnitude;
        boolean resultNeg = this.sign < 0 && val.sign >= 0 || this.sign >= 0 && val.sign < 0;
        int resultLength = Math.max(aMag.length, bMag.length);
        int[] resultMag = new int[resultLength];
        int aStart = resultMag.length - aMag.length;
        int bStart = resultMag.length - bMag.length;
        for (int i2 = 0; i2 < resultMag.length; ++i2) {
            int bWord;
            int aWord = i2 >= aStart ? aMag[i2 - aStart] : 0;
            int n2 = bWord = i2 >= bStart ? bMag[i2 - bStart] : 0;
            if (this.sign < 0) {
                aWord ^= 0xFFFFFFFF;
            }
            if (val.sign < 0) {
                bWord ^= 0xFFFFFFFF;
            }
            resultMag[i2] = aWord ^ bWord;
            if (!resultNeg) continue;
            resultMag[i2] = ~resultMag[i2];
        }
        BigInteger result = new BigInteger(1, resultMag);
        if (resultNeg) {
            result = result.not();
        }
        return result;
    }

    public BigInteger or(BigInteger value) {
        if (this.sign == 0) {
            return value;
        }
        if (value.sign == 0) {
            return this;
        }
        int[] aMag = this.sign > 0 ? this.magnitude : this.add((BigInteger)BigInteger.ONE).magnitude;
        int[] bMag = value.sign > 0 ? value.magnitude : value.add((BigInteger)BigInteger.ONE).magnitude;
        boolean resultNeg = this.sign < 0 || value.sign < 0;
        int resultLength = Math.max(aMag.length, bMag.length);
        int[] resultMag = new int[resultLength];
        int aStart = resultMag.length - aMag.length;
        int bStart = resultMag.length - bMag.length;
        for (int i2 = 0; i2 < resultMag.length; ++i2) {
            int bWord;
            int aWord = i2 >= aStart ? aMag[i2 - aStart] : 0;
            int n2 = bWord = i2 >= bStart ? bMag[i2 - bStart] : 0;
            if (this.sign < 0) {
                aWord ^= 0xFFFFFFFF;
            }
            if (value.sign < 0) {
                bWord ^= 0xFFFFFFFF;
            }
            resultMag[i2] = aWord | bWord;
            if (!resultNeg) continue;
            resultMag[i2] = ~resultMag[i2];
        }
        BigInteger result = new BigInteger(1, resultMag);
        if (resultNeg) {
            result = result.not();
        }
        return result;
    }

    public BigInteger setBit(int n2) throws ArithmeticException {
        if (n2 < 0) {
            throw new ArithmeticException("Bit address less than zero");
        }
        if (this.testBit(n2)) {
            return this;
        }
        if (this.sign > 0 && n2 < this.bitLength() - 1) {
            return this.flipExistingBit(n2);
        }
        return this.or(ONE.shiftLeft(n2));
    }

    public BigInteger clearBit(int n2) throws ArithmeticException {
        if (n2 < 0) {
            throw new ArithmeticException("Bit address less than zero");
        }
        if (!this.testBit(n2)) {
            return this;
        }
        if (this.sign > 0 && n2 < this.bitLength() - 1) {
            return this.flipExistingBit(n2);
        }
        return this.andNot(ONE.shiftLeft(n2));
    }

    public BigInteger flipBit(int n2) throws ArithmeticException {
        if (n2 < 0) {
            throw new ArithmeticException("Bit address less than zero");
        }
        if (this.sign > 0 && n2 < this.bitLength() - 1) {
            return this.flipExistingBit(n2);
        }
        return this.xor(ONE.shiftLeft(n2));
    }

    private BigInteger flipExistingBit(int n2) {
        int[] mag = new int[this.magnitude.length];
        System.arraycopy(this.magnitude, 0, mag, 0, mag.length);
        int n3 = mag.length - 1 - (n2 >>> 5);
        mag[n3] = mag[n3] ^ 1 << (n2 & 0x1F);
        return new BigInteger(this.sign, mag);
    }

    public String toString() {
        return this.toString(10);
    }

    public String toString(int rdx) {
        if (this.magnitude == null) {
            return "null";
        }
        if (this.sign == 0) {
            return "0";
        }
        StringBuffer sb = new StringBuffer();
        if (rdx == 16) {
            for (int i2 = 0; i2 < this.magnitude.length; ++i2) {
                String h2 = "0000000" + Integer.toHexString(this.magnitude[i2]);
                h2 = h2.substring(h2.length() - 8);
                sb.append(h2);
            }
        } else if (rdx == 2) {
            sb.append('1');
            for (int i3 = this.bitLength() - 2; i3 >= 0; --i3) {
                sb.append(this.testBit(i3) ? (char)'1' : '0');
            }
        } else {
            Stack<String> S = new Stack<String>();
            BigInteger biBase = new BigInteger(Integer.toString(rdx, rdx), rdx);
            BigInteger u2 = this.abs();
            while (!u2.equals(ZERO)) {
                BigInteger b2 = u2.mod(biBase);
                if (b2.equals(ZERO)) {
                    S.push("0");
                } else {
                    S.push(Integer.toString(b2.magnitude[0], rdx));
                }
                u2 = u2.divide(biBase);
            }
            while (!S.empty()) {
                sb.append((String)S.pop());
            }
        }
        String s2 = sb.toString();
        while (s2.length() > 1 && s2.charAt(0) == '0') {
            s2 = s2.substring(1);
        }
        if (s2.length() == 0) {
            s2 = "0";
        } else if (this.sign == -1) {
            s2 = "-" + s2;
        }
        return s2;
    }

    public static BigInteger valueOf(long val) {
        if (val == 0L) {
            return ZERO;
        }
        if (val < 0L) {
            if (val == Long.MIN_VALUE) {
                return BigInteger.valueOf(val ^ 0xFFFFFFFFFFFFFFFFL).not();
            }
            return BigInteger.valueOf(-val).negate();
        }
        byte[] b2 = new byte[8];
        for (int i2 = 0; i2 < 8; ++i2) {
            b2[7 - i2] = (byte)val;
            val >>= 8;
        }
        return new BigInteger(b2);
    }

    public int getLowestSetBit() {
        int b2;
        if (this.sign == 0) {
            return -1;
        }
        int w2 = this.magnitude.length;
        while (--w2 > 0 && this.magnitude[w2] == 0) {
        }
        int word = this.magnitude[w2];
        int n2 = (word & 0xFFFF) == 0 ? ((word & 0xFF0000) == 0 ? 7 : 15) : (b2 = (word & 0xFF) == 0 ? 23 : 31);
        while (b2 > 0 && word << b2 != Integer.MIN_VALUE) {
            --b2;
        }
        return (this.magnitude.length - w2) * 32 - (b2 + 1);
    }

    public boolean testBit(int n2) throws ArithmeticException {
        if (n2 < 0) {
            throw new ArithmeticException("Bit position must not be negative");
        }
        if (this.sign < 0) {
            return !this.not().testBit(n2);
        }
        int wordNum = n2 / 32;
        if (wordNum >= this.magnitude.length) {
            return false;
        }
        int word = this.magnitude[this.magnitude.length - 1 - wordNum];
        return (word >> n2 % 32 & 1) > 0;
    }

    static {
        ZERO_MAGNITUDE = new int[0];
        ZERO = new BigInteger(0, ZERO_MAGNITUDE);
        ONE = BigInteger.valueOf(1L);
        TWO = BigInteger.valueOf(2L);
        THREE = BigInteger.valueOf(3L);
        BigInteger.ZERO.nBits = 0;
        BigInteger.ZERO.nBitLength = 0;
        BigInteger.ONE.nBits = 1;
        BigInteger.ONE.nBitLength = 1;
        BigInteger.TWO.nBits = 1;
        BigInteger.TWO.nBitLength = 2;
        primeProducts = new int[primeLists.length];
        for (int i2 = 0; i2 < primeLists.length; ++i2) {
            int[] primeList = primeLists[i2];
            int product = 1;
            for (int j2 = 0; j2 < primeList.length; ++j2) {
                product *= primeList[j2];
            }
            BigInteger.primeProducts[i2] = product;
        }
        rndMask = new byte[]{-1, 127, 63, 31, 15, 7, 3, 1};
        bitCounts = new byte[]{0, 1, 1, 2, 1, 2, 2, 3, 1, 2, 2, 3, 2, 3, 3, 4, 1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5, 1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8};
    }
}

