/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.log.http;

import de.enough.polish.log.LogEntry;
import de.enough.polish.log.LogHandler;
import de.enough.polish.util.ArrayList;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import javax.microedition.io.Connector;
import javax.microedition.io.HttpConnection;

public class HttpLogHandler
extends LogHandler
implements Runnable {
    public static final String SERVER_URL = null;
    private static final String HTTP_VALUE_LANGUAGE = "en-DE";
    private static final String HTTP_KEY_LANGUAGE = "Content-Language";
    private static final String HTTP_VALUE_USER_AGENT = "Profile/MIDP-2.0 Confirguration/CLDC-1.0";
    private static final String HTTP_KEY_USER_AGENT = "User-Agent";
    private static final String HTTP_VALUE_IF_MODIFIER = "10 Nov 2000 17:29:12 GMT";
    private static final String HTTP_KEY_IF_MODIFIER = "IF-Modified-Since";
    private volatile ArrayList logStack = new ArrayList();
    private Thread logThread;
    private volatile boolean keepRunning = true;

    public HttpLogHandler() {
        if (SERVER_URL != null) {
            this.logThread = new Thread(this);
            this.logThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleLogEntry(LogEntry logEntry) throws Exception {
        ArrayList arrayList = this.logStack;
        synchronized (arrayList) {
            this.logStack.add(logEntry);
        }
    }

    public void run() {
        while (this.keepRunning) {
            LogEntry entryToLog = this.getNextEntry();
            if (entryToLog == null) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            this.logCurrentEntry(entryToLog);
        }
    }

    public void exit() {
        this.keepRunning = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logCurrentEntry(LogEntry logEntry) {
        HttpConnection connection = null;
        Object outputStream = null;
        Object inputStream = null;
        try {
            connection = this.initHttpConnection(this.getUrl(logEntry));
            connection.getResponseCode();
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        finally {
            this.closeStreams(connection, inputStream, outputStream);
            connection = null;
            inputStream = null;
            outputStream = null;
        }
    }

    private void closeStreams(HttpConnection c2, InputStream is, OutputStream os) {
        if (is != null) {
            try {
                is.close();
            }
            catch (IOException exc) {
                // empty catch block
            }
        }
        if (os != null) {
            try {
                os.close();
            }
            catch (IOException exc) {
                // empty catch block
            }
        }
        if (c2 != null) {
            try {
                c2.close();
            }
            catch (IOException exc) {
                // empty catch block
            }
        }
    }

    private String getUrl(LogEntry logEntry) {
        StringBuffer url = new StringBuffer();
        Date timeDate = new Date(logEntry.time);
        url.append(SERVER_URL).append("?");
        url.append("time=").append(this.encodeURL(timeDate.toString()));
        url.append("&message=").append(this.encodeURL(logEntry.message));
        url.append("&classname=").append(logEntry.className);
        url.append("&lineNumber=").append(logEntry.lineNumber);
        url.append("&exception=").append(this.encodeURL(logEntry.exception));
        url.append("&level=").append(logEntry.level);
        return url.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LogEntry getNextEntry() {
        if (this.logStack.size() == 0) {
            return null;
        }
        ArrayList arrayList = this.logStack;
        synchronized (arrayList) {
            return (LogEntry)this.logStack.remove(0);
        }
    }

    private HttpConnection initHttpConnection(String url) throws IOException {
        String string = url;
        Object var3_3 = null;
        XConnection xConnection = null;
        XConnection xConnection2 = new XConnection();
        xConnection = string.startsWith("sms") ? xConnection2 : Connector.open((String)string);
        HttpConnection logConnection = (HttpConnection)xConnection;
        logConnection.setRequestMethod("GET");
        logConnection.setRequestProperty(HTTP_KEY_IF_MODIFIER, HTTP_VALUE_IF_MODIFIER);
        logConnection.setRequestProperty(HTTP_KEY_USER_AGENT, HTTP_VALUE_USER_AGENT);
        logConnection.setRequestProperty(HTTP_KEY_LANGUAGE, HTTP_VALUE_LANGUAGE);
        return logConnection;
    }

    public String encodeURL(String url) {
        String newurl = "";
        int urllen = url.length();
        for (int i2 = 0; i2 < urllen; ++i2) {
            char c2 = url.charAt(i2);
            newurl = this.isCharEncodingNotNecessary(c2) ? newurl + c2 : (c2 == ' ' ? newurl + '+' : newurl + this.encodeChar(c2));
        }
        return newurl;
    }

    private boolean isCharEncodingNotNecessary(char c2) {
        return c2 >= 'a' && c2 <= 'z' || c2 >= 'A' && c2 <= 'Z' || c2 >= '0' && c2 <= '9' || c2 == '.' || c2 == '-' || c2 == '*' || c2 == '_' || c2 == '/' || c2 == '~';
    }

    private String encodeChar(char c2) {
        String encchar = "%";
        encchar = encchar + Integer.toHexString(c2 / 16 % 16).toUpperCase();
        encchar = encchar + Integer.toHexString(c2 % 16).toUpperCase();
        return encchar;
    }
}

