/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.io;

import java.io.IOException;
import java.io.Reader;

public class StringReader
extends Reader {
    private int index = 0;
    private int mark;
    private int len;
    private String str;

    public StringReader(String str) {
        this.str = str;
        this.len = str.length();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.str = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mark(int readAheadLimit) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.str == null) {
                throw new IOException("stream closed");
            }
            this.mark = this.index;
        }
    }

    public boolean markSupported() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.str == null) {
                throw new IOException("stream closed");
            }
            if (this.index >= this.len) {
                return -1;
            }
            return this.str.charAt(this.index++) & 0xFFFF;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(char[] cbuf, int off, int length) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.str == null) {
                throw new IOException("stream closed");
            }
            if (off < 0 || length < 0 || off + length > cbuf.length) {
                throw new ArrayIndexOutOfBoundsException();
            }
            if (this.index >= this.len) {
                return -1;
            }
            int lastChar = Math.min(this.len, this.index + length);
            this.str.getChars(this.index, lastChar, cbuf, off);
            int numChars = lastChar - this.index;
            this.index = lastChar;
            return numChars;
        }
    }

    public boolean ready() throws IOException {
        if (this.str == null) {
            throw new IOException("stream closed");
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.str == null) {
                throw new IOException("stream closed");
            }
            this.index = this.mark;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long skip(long n2) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            long skipped = Math.min((long)(this.len - this.index), n2 < 0L ? 0L : n2);
            this.index = (int)((long)this.index + skipped);
            return skipped;
        }
    }
}

