/*
 * Decompiled with CFR 0.152.
 */
package com.game5a.script;

import com.game5a.common.GZIP;
import com.game5a.common.Tool;
import com.game5a.common.XFont;
import com.game5a.script.ScriptProcessor;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class DoScript {
    private static final String FUNC_FLAG = "x";
    private static final char[] NUM_OP = new char[]{'+', '-', '*', '/', '%'};
    private static final char[] COMP_OP = new char[]{'<', '>', '!', '='};
    private static final byte COMP_LES = 0;
    private static final byte COMP_GRE = 1;
    private static final byte COMP_NOT = 2;
    private static final byte COMP_EQU = 3;
    private static final byte COMP_LE = 4;
    private static final byte COMP_GE = 5;
    private static final String STR_NUMERIC = "0123456789";
    private static final int KEYWORD_IF = 0;
    private static final int KEYWORD_ELSE = 1;
    private static final int KEYWORD_ENDIF = 2;
    private static final int KEYWORD_RET = 3;
    private static final byte LOGIC_AND = 0;
    private static final byte LOGIC_OR = 1;
    private String[] srcCode;
    public ScriptProcessor scriptProcessor;
    private boolean bPause;
    private boolean bFinished;
    private int pauseTime;
    private int pauseTotalTime;
    int pointer;
    private static Hashtable globalValueHT = new Hashtable();

    public DoScript(ScriptProcessor processor) {
        this.scriptProcessor = processor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initScript() {
        globalValueHT.clear();
        FilterInputStream din = null;
        try {
            din = new DataInputStream("".getClass().getResourceAsStream("/var.tbd"));
            int num = ((DataInputStream)din).readInt();
            for (int i2 = 0; i2 < num; ++i2) {
                DoScript.addVar(((DataInputStream)din).readUTF().toLowerCase(), 0);
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        finally {
            try {
                if (din != null) {
                    din.close();
                    din = null;
                }
            }
            catch (Exception e3) {
                e3.printStackTrace();
            }
        }
    }

    public void startScript(String file) {
        this.srcCode = null;
        this.load(file);
        this.pointer = 0;
        this.scriptProcessor.setScriptState((byte)1);
        this.bPause = false;
        this.bFinished = false;
        this.runScript(0);
    }

    public void pause() {
        this.pause(0);
    }

    public void pause(int time) {
        this.pauseTotalTime = time;
        this.pauseTime = 0;
        this.scriptProcessor.setScriptState((byte)2);
        this.bPause = true;
    }

    public void continueProcess() {
        if (this.scriptProcessor.getScriptState() != 2) {
            return;
        }
        this.bPause = false;
        this.scriptProcessor.setScriptState((byte)1);
        this.runScript(this.pointer);
    }

    public void finish() {
        this.bFinished = true;
        this.scriptProcessor.setScriptState((byte)3);
    }

    public void cycle() {
        if (this.bPause && this.pauseTotalTime > 0) {
            ++this.pauseTime;
            if (this.pauseTime > this.pauseTotalTime) {
                this.continueProcess();
            }
        }
    }

    private void load(String path) {
        InputStream in = this.getClass().getResourceAsStream(path);
        byte[] data = null;
        try {
            data = Tool.getBytesFromInput(in);
            data = GZIP.inflate(data);
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        if (data == null) {
            return;
        }
        ByteArrayInputStream bin = new ByteArrayInputStream(data);
        DataInputStream din = new DataInputStream(bin);
        Vector<String> vCode = new Vector<String>();
        int count = 0;
        try {
            while (true) {
                String str = din.readUTF();
                vCode.addElement(str);
                ++count;
            }
        }
        catch (EOFException e2) {
        }
        catch (IOException e3) {
            e3.printStackTrace();
        }
        try {
            din.close();
            bin.close();
        }
        catch (Exception e4) {
            e4.printStackTrace();
        }
        this.srcCode = new String[count];
        for (int i2 = 0; i2 < count; ++i2) {
            this.srcCode[i2] = (String)vCode.elementAt(i2);
        }
    }

    private void runScript(int index) {
        this.pointer = index;
        try {
            while (this.pointer < this.srcCode.length) {
                if (this.bFinished || this.bPause) {
                    return;
                }
                this.processCommand(this.srcCode[this.pointer]);
                ++this.pointer;
            }
        }
        catch (Exception e2) {
            Tool.reportException(e2);
        }
        this.finish();
    }

    public static void addVar(String key, int value) throws Exception {
        String lowKey = key.toLowerCase();
        if (globalValueHT.containsKey(lowKey)) {
            throw new Exception("Var Exist.." + lowKey);
        }
        globalValueHT.put(lowKey, new Integer(value));
    }

    public static void setVar(String key, int value) throws Exception {
        String lowKey = key.toLowerCase();
        if (!globalValueHT.containsKey(lowKey)) {
            throw new Exception("No Var.." + lowKey);
        }
        globalValueHT.put(lowKey, new Integer(value));
    }

    public static int getVar(String key) throws Exception {
        String lowKey = key.toLowerCase();
        Object ob = globalValueHT.get(lowKey);
        if (ob == null) {
            throw new Exception("No Var.." + lowKey);
        }
        return (Integer)ob;
    }

    public static boolean isHasVar(String key) {
        String lowKey = key.toLowerCase();
        return globalValueHT.containsKey(lowKey);
    }

    public static Object[] getAllValues() {
        if (globalValueHT.size() == 0) {
            return null;
        }
        System.out.println("globalValueHT.size() = " + globalValueHT.size());
        Object[] obs = new Object[globalValueHT.size() * 2];
        Enumeration em = globalValueHT.keys();
        int count = 0;
        while (em.hasMoreElements()) {
            String key = (String)em.nextElement();
            obs[count * 2] = key;
            obs[count * 2 + 1] = globalValueHT.get(key);
            ++count;
        }
        System.out.println("count = " + count);
        return obs;
    }

    private int getFuncID(String cmdStr) {
        if (cmdStr.startsWith(FUNC_FLAG)) {
            int lpIndex = cmdStr.indexOf(40);
            String func = lpIndex >= 0 ? cmdStr.substring(1, lpIndex) : cmdStr.substring(1);
            return Integer.parseInt(func, 16);
        }
        return -1;
    }

    private String[] getParams(String cmdStr) {
        int lpIndex = cmdStr.indexOf(40);
        int rpIndex = cmdStr.lastIndexOf(41);
        if (lpIndex < 0 || rpIndex <= lpIndex + 1) {
            return null;
        }
        Vector<String> paramV = new Vector<String>();
        StringBuffer sb = new StringBuffer();
        boolean bInDqm = false;
        for (int i2 = lpIndex + 1; i2 < rpIndex; ++i2) {
            boolean bParaEnd = false;
            char ch = cmdStr.charAt(i2);
            if (ch == '\"') {
                bInDqm = !bInDqm;
                sb.append(ch);
            } else if (ch == ' ') {
                if (bInDqm) {
                    sb.append(ch);
                }
            } else if (ch == ',') {
                if (bInDqm) {
                    sb.append(ch);
                } else {
                    bParaEnd = true;
                }
            } else {
                sb.append(ch);
            }
            if (i2 == rpIndex - 1) {
                bParaEnd = true;
            }
            if (!bParaEnd) continue;
            paramV.addElement(sb.toString());
            sb.setLength(0);
        }
        Object[] params = new String[paramV.size()];
        paramV.copyInto(params);
        return params;
    }

    private int getValue(String str) throws Exception {
        if (this.isNumeric(str.charAt(0))) {
            return Integer.parseInt(str);
        }
        return DoScript.getVar(str);
    }

    private int processCommand(String cmdStr) throws Exception {
        System.out.println("\u3010" + cmdStr + "\u3011");
        int funcID = this.getFuncID(cmdStr);
        String[] params = this.getParams(cmdStr);
        block1 : switch (funcID) {
            case 0: {
                if (this.processIF(params[0])) break;
                int countIf = 1;
                for (int i2 = this.pointer + 1; i2 < this.srcCode.length; ++i2) {
                    int fid = this.getFuncID(this.srcCode[i2]);
                    if (fid == 0) {
                        ++countIf;
                    } else if (fid == 2) {
                        --countIf;
                    }
                    if (fid == 1 && countIf == 1) {
                        this.pointer = i2;
                        break block1;
                    }
                    if (fid != 2 || countIf != 0) continue;
                    this.pointer = i2;
                    break block1;
                }
                break;
            }
            case 1: {
                int countIf = 1;
                for (int i3 = this.pointer + 1; i3 < this.srcCode.length; ++i3) {
                    int fid = this.getFuncID(this.srcCode[i3]);
                    if (fid == 0) {
                        ++countIf;
                    } else if (fid == 2) {
                        --countIf;
                    }
                    if (fid != 2 || countIf != 0) continue;
                    this.pointer = i3;
                    break block1;
                }
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                this.finish();
                break;
            }
            case 4: {
                this.processAssign(params[0]);
                break;
            }
            case 5: {
                try {
                    System.out.println("    echo: " + DoScript.getStrParam(params, 0));
                }
                catch (Exception e2) {
                    System.out.println("    echo: " + params[0] + " = " + this.getValue(params[0]));
                }
                break;
            }
            case 6: {
                System.out.println("00000000000000000000000000000");
                this.pause(DoScript.getIntParam(params, 0));
                break;
            }
            default: {
                this.scriptProcessor.call(params, funcID);
            }
        }
        return 0;
    }

    private void processAssign(String cmdStr) throws Exception {
        String[] strs = XFont.getStringArray(cmdStr, '=');
        if (strs.length != 2) {
            throw new Exception("Error Assign Format..");
        }
        for (int i2 = 0; i2 < strs.length; ++i2) {
            strs[i2] = strs[i2].trim();
        }
        if (!DoScript.isHasVar(strs[0])) {
            throw new Exception("No Var.." + strs[0]);
        }
        int opPos = 0;
        int op = 0;
        for (int i3 = 0; i3 < NUM_OP.length; ++i3) {
            opPos = strs[1].indexOf(NUM_OP[i3]);
            if (opPos < 0) continue;
            op = NUM_OP[i3];
            break;
        }
        int result = 0;
        if (op > 0) {
            String p1 = strs[1].substring(0, opPos).trim();
            String p2 = strs[1].substring(opPos + 1).trim();
            int p1v = this.getValue(p1);
            int p2v = this.getValue(p2);
            switch (op) {
                case 43: {
                    result = p1v + p2v;
                    break;
                }
                case 45: {
                    result = p1v - p2v;
                    break;
                }
                case 42: {
                    result = p1v * p2v;
                    break;
                }
                case 47: {
                    result = p1v / p2v;
                    break;
                }
                case 37: {
                    result = p1v % p2v;
                    break;
                }
            }
            DoScript.setVar(strs[0], result);
        } else {
            result = this.getValue(strs[1]);
            DoScript.setVar(strs[0], result);
        }
    }

    private boolean processBoolean(String express) throws Exception {
        int op = 0;
        int opPos = 0;
        int opOffset = 1;
        for (int i2 = 0; i2 < COMP_OP.length; ++i2) {
            opPos = express.indexOf(COMP_OP[i2]);
            if (opPos < 0) continue;
            if (i2 == 0) {
                if (express.charAt(opPos + 1) == COMP_OP[3]) {
                    op = 4;
                    opOffset = 2;
                    break;
                }
            } else if (i2 == 1) {
                if (express.charAt(opPos + 1) == COMP_OP[3]) {
                    op = 5;
                    opOffset = 2;
                    break;
                }
            } else if ((i2 == 2 || i2 == 3) && express.charAt(opPos + 1) == COMP_OP[3]) {
                opOffset = 2;
            }
            op = (byte)i2;
            break;
        }
        if (opPos < 0) {
            throw new Exception("Error Express: " + express);
        }
        String leftName = express.substring(0, opPos);
        int leftValue = this.getValue(leftName);
        String rightName = express.substring(opPos + opOffset);
        int rightValue = this.getValue(rightName);
        switch (op) {
            case 0: {
                return leftValue < rightValue;
            }
            case 1: {
                return leftValue > rightValue;
            }
            case 2: {
                return leftValue != rightValue;
            }
            case 3: {
                return leftValue == rightValue;
            }
            case 5: {
                return leftValue >= rightValue;
            }
            case 4: {
                return leftValue <= rightValue;
            }
        }
        throw new Exception("Error Express: " + express);
    }

    private boolean processIF(String express) throws Exception {
        boolean logicOp = false;
        int logicOpIndex = express.indexOf("&&");
        if (logicOpIndex < 0) {
            logicOp = true;
            logicOpIndex = express.indexOf("||");
        }
        if (logicOpIndex > 0) {
            String exp1 = express.substring(0, logicOpIndex).trim();
            String exp2 = express.substring(logicOpIndex + 2).trim();
            if (!logicOp) {
                return this.processBoolean(exp1) && this.processBoolean(exp2);
            }
            if (logicOp) {
                return this.processBoolean(exp1) || this.processBoolean(exp2);
            }
        }
        return this.processBoolean(express);
    }

    public static String getStrParam(String[] params, int index) throws Exception {
        if (params == null) {
            return null;
        }
        if (index >= params.length) {
            return null;
        }
        if (params[index].toLowerCase().compareTo("null") == 0) {
            return null;
        }
        if (!params[index].startsWith("\"") || !params[index].endsWith("\"")) {
            throw new Exception("Error String format: " + params[index]);
        }
        return params[index].substring(1, params[index].length() - 1);
    }

    public static boolean getBoolParam(String[] params, int index) {
        block5: {
            if (params == null) {
                return false;
            }
            if (index >= params.length) {
                return false;
            }
            try {
                if (Integer.parseInt(params[index]) != 0) {
                    return true;
                }
            }
            catch (Exception e2) {
                if (params[index].toLowerCase().compareTo("true") != 0) break block5;
                return true;
            }
        }
        return false;
    }

    public static int getIntParam(String[] params, int index) {
        return DoScript.getIntParam(params, index, 10);
    }

    public static int getIntParam(String[] params, int index, int radix) {
        if (params == null) {
            return 0;
        }
        if (index >= params.length) {
            return 0;
        }
        String str = params[index];
        try {
            return DoScript.getVar(str);
        }
        catch (Exception e2) {
            return Integer.parseInt(str, radix);
        }
    }

    private boolean isNumeric(char ch) {
        return STR_NUMERIC.indexOf(ch) >= 0;
    }
}

