/*
 * Decompiled with CFR 0.152.
 */
package com.game5a.common.styledtext;

import com.game5a.action.ActionSet;
import com.game5a.common.Common;
import com.game5a.common.Tool;
import com.game5a.common.XFont;
import com.game5a.common.styledtext.Style;
import java.util.Stack;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;

public class StyledText {
    private boolean bCheckLineWidth;
    private int lineWidth;
    private XFont xFont;
    private Style defaultStyle;
    private ActionSet iconAs;
    private Vector content;

    public StyledText(String str, int lineW, XFont fn, Style style, ActionSet as) {
        if (lineW <= 0) {
            this.bCheckLineWidth = false;
        } else {
            this.lineWidth = lineW;
            this.bCheckLineWidth = true;
        }
        this.xFont = fn;
        this.defaultStyle = style;
        this.iconAs = as;
        this.content = new Vector();
        this.formatText(str);
    }

    public void formatText(String str) {
        Stack<Style> styleStack = new Stack<Style>();
        if (this.defaultStyle == null) {
            this.defaultStyle = new Style();
        }
        styleStack.push(this.defaultStyle);
        this.content.removeAllElements();
        boolean bNewLine = true;
        int curLineW = 0;
        Vector<String> curLine = null;
        Object itemToAdded = null;
        StringBuffer curSB = null;
        int i2 = 0;
        while (i2 <= str.length()) {
            if (bNewLine) {
                curLine = null;
                curLine = new Vector<String>();
                curLine.addElement((String)styleStack.peek());
                curLineW = 0;
                curSB = new StringBuffer();
                if (itemToAdded != null) {
                    if (itemToAdded instanceof Character) {
                        curSB.append(((Character)itemToAdded).charValue());
                    } else if (itemToAdded instanceof Style && ((Style)itemToAdded).type == 2 && this.iconAs != null) {
                        curLine.addElement((String)itemToAdded);
                        curLineW += this.iconAs.getWidthOfAction(((Style)itemToAdded).iconID);
                    }
                    itemToAdded = null;
                }
                this.content.addElement(curLine);
                bNewLine = false;
            }
            if (i2 == str.length()) {
                curLine.addElement(curSB.toString());
                break;
            }
            char ch = str.charAt(i2);
            boolean bChar = false;
            if (ch == '\n') {
                if (curSB.length() > 0) {
                    curLine.addElement(curSB.toString());
                }
                ++i2;
                bNewLine = true;
            } else if (ch == '<') {
                char ch1 = str.charAt(i2 + 1);
                int flagID = Style.getFlagID(ch1);
                if (flagID >= 0) {
                    Style sty = null;
                    int fendi = str.indexOf(62, i2);
                    if (fendi >= 0) {
                        String flagStr = str.substring(i2 + 1, fendi);
                        sty = Style.createStyle(flagStr);
                    }
                    if (sty == null) {
                        bChar = true;
                    } else if (sty.type == 0) {
                        if (curSB.length() > 0) {
                            curLine.addElement(curSB.toString());
                            curLineW += this.xFont.stringWidth(curSB.toString());
                            curSB = new StringBuffer();
                        }
                        if (styleStack.size() > 1) {
                            styleStack.pop();
                        }
                        curLine.addElement((String)styleStack.peek());
                        i2 = fendi + 1;
                    } else if (sty.type == 1) {
                        if (curSB.length() > 0) {
                            curLine.addElement(curSB.toString());
                            curLineW += this.xFont.stringWidth(curSB.toString());
                            curSB = new StringBuffer();
                        }
                        curLine.addElement((String)((Object)styleStack.push(sty)));
                        i2 = fendi + 1;
                    } else if (sty.type == 2) {
                        if (this.iconAs != null) {
                            if (curSB.length() > 0) {
                                curLine.addElement(curSB.toString());
                                curLineW += this.xFont.stringWidth(curSB.toString());
                                curSB = new StringBuffer();
                            }
                            int iconWidth = this.iconAs.getWidthOfAction(sty.iconID);
                            int newLineW = curLineW + iconWidth;
                            if (this.bCheckLineWidth && newLineW > this.lineWidth) {
                                bNewLine = true;
                                itemToAdded = sty;
                            } else {
                                curLine.addElement((String)((Object)sty));
                                curLineW += iconWidth;
                            }
                        }
                        i2 = fendi + 1;
                    }
                } else {
                    bChar = true;
                }
            } else {
                bChar = true;
            }
            if (!bChar) continue;
            int newLineW = curLineW + this.xFont.stringWidth(curSB.toString()) + this.xFont.charWidth(ch);
            if (this.bCheckLineWidth && newLineW > this.lineWidth) {
                if (curSB.length() > 0) {
                    curLine.addElement(curSB.toString());
                }
                bNewLine = true;
                itemToAdded = new Character(ch);
            } else {
                curSB.append(ch);
                if (i2 == str.length() - 1) {
                    curLine.addElement(curSB.toString());
                    break;
                }
            }
            ++i2;
        }
    }

    public void clearContent() {
        if (this.content != null) {
            this.content.removeAllElements();
        }
    }

    public int getLineNum() {
        if (this.content == null) {
            return 0;
        }
        return this.content.size();
    }

    public void drawLine(Graphics g2, int index, int dx, int dy) {
        if (index < 0 || index >= this.content.size()) {
            return;
        }
        Vector line = (Vector)this.content.elementAt(index);
        this.drawLine(g2, line, dx, dy);
    }

    public void drawLine(Graphics g2, Vector line, int dx, int dy) {
        Style style = new Style();
        for (int i2 = 0; i2 < line.size(); ++i2) {
            Object ob = line.elementAt(i2);
            if (ob instanceof Style) {
                Style sty = (Style)ob;
                if (sty.type == 1) {
                    style = sty;
                    continue;
                }
                if (sty.type != 2 || this.iconAs == null) continue;
                int actIndex = sty.iconID;
                if (sty.iconID >= this.iconAs.actionNum) {
                    actIndex = 0;
                }
                this.iconAs.drawFrameCycle(g2, actIndex, Tool.countTimes, dx, dy + this.xFont.getHeight(), false);
                Common.setUIClip(g2);
                int iconWidth = this.iconAs.getWidthOfAction(sty.iconID);
                dx += iconWidth;
                continue;
            }
            if (!(ob instanceof String)) continue;
            String str = (String)ob;
            this.xFont.drawString(g2, str, dx, dy, style.fontColor, style.backColor, style.fontType);
            dx += this.xFont.stringWidth(str);
        }
    }

    public int getWidth() {
        return this.lineWidth;
    }

    public int getLineWidth(Vector line) {
        int w2 = 0;
        for (int i2 = 0; i2 < line.size(); ++i2) {
            Object ob = line.elementAt(i2);
            if (ob instanceof Style) {
                Style sty = (Style)ob;
                if (sty.type != 2 || this.iconAs == null) continue;
                int iconWidth = this.iconAs.getWidthOfAction(sty.iconID);
                w2 += iconWidth;
                continue;
            }
            if (!(ob instanceof String)) continue;
            w2 += this.xFont.stringWidth((String)ob);
        }
        return w2;
    }

    public int getLineWidth(int index) {
        if (index < 0 || index >= this.content.size()) {
            return 0;
        }
        return this.getLineWidth((Vector)this.content.elementAt(index));
    }
}

