/*
 * Decompiled with CFR 0.152.
 */
package com.game5a.common;

import com.game5a.common.Common;
import com.game5a.common.MovingString;
import com.game5a.common.XFont;
import javax.microedition.lcdui.Graphics;

public class XList {
    private Object[] objects;
    private MovingString[] itemStrs;
    private int itemWidth;
    private int itemHeight;
    private int itemShowNum;
    private int itemShowFirst;
    private int focusIndex;
    private XFont xFont;
    private boolean bFocusChanged;
    public static final String STR_NULL = "...";
    public static int[] DefaultFormat = new int[]{0xFFFFFF, -1, 1};
    public static int[] DefaultFocuesFormat = new int[]{0xFFFFFF, 255, 1};
    public static int[] StrColour;
    boolean bChangeStrColour;

    public XList(Object[] os, int iw, int ih, int sn, XFont fn) {
        this.objects = os;
        this.itemWidth = iw;
        this.itemHeight = ih;
        this.itemShowNum = sn;
        this.xFont = fn;
        this.itemShowFirst = 0;
        this.focusIndex = 0;
        this.itemStrs = new MovingString[this.objects.length];
        for (int i2 = 0; i2 < this.itemStrs.length; ++i2) {
            this.itemStrs[i2] = this.objects[i2] != null ? new MovingString(this.objects[i2].toString(), this.itemWidth, 2) : new MovingString(STR_NULL, this.itemWidth, 2);
        }
        this.itemStrs[this.focusIndex].start();
    }

    public XList(Object[] os, int iw, int ih, int sn, XFont fn, boolean bAutoHeight) {
        this(os, iw, ih, sn, fn);
        if (bAutoHeight && this.itemShowNum > os.length) {
            this.itemShowNum = os.length;
        }
    }

    public int getWidth() {
        return this.itemWidth;
    }

    public int getHeight() {
        return this.itemHeight * this.itemShowNum;
    }

    public int getItemHeight() {
        return this.itemHeight;
    }

    public boolean focusChanged() {
        return this.bFocusChanged;
    }

    public Object getFocusItem() {
        return this.objects[this.focusIndex];
    }

    public int getFocusIndex() {
        return this.focusIndex;
    }

    public void setFocusIndex(int index) {
        this.setFocusIndex(index, false);
    }

    public void setFocusIndex(int index, boolean bSetFistIndex) {
        if (index < 0 || index >= this.objects.length) {
            return;
        }
        this.focusIndex = index;
        this.itemStrs[this.focusIndex].start();
        if (bSetFistIndex) {
            this.itemShowFirst = this.focusIndex - this.itemShowNum + 1;
            if (this.itemShowFirst < 0) {
                this.itemShowFirst = 0;
            }
        }
    }

    public int getFocusIndexInPage() {
        return this.focusIndex - this.itemShowFirst;
    }

    public int getFirstIndexShown() {
        return this.itemShowFirst;
    }

    public int getItemNum() {
        return this.objects.length;
    }

    public Object getItemAt(int index) {
        if (index < 0 || index >= this.objects.length) {
            return null;
        }
        return this.objects[index];
    }

    public MovingString getItemStrAt(int index) {
        if (index < 0 || index >= this.itemStrs.length) {
            return null;
        }
        return this.itemStrs[index];
    }

    public Object getItemShownAt(int index) {
        return this.getItemAt(this.itemShowFirst + index);
    }

    public int getItemNumShown() {
        return this.itemShowNum > this.objects.length ? this.objects.length : this.itemShowNum;
    }

    public void handleKey() {
        this.bFocusChanged = false;
        if (Common.isAnyKeyPressed()) {
            int lastFocused = this.focusIndex;
            if (Common.isKeyPressed(0, true) || Common.isKeyPressed(13, true)) {
                --this.focusIndex;
                if (this.focusIndex < 0) {
                    this.focusIndex = this.objects.length - 1;
                    this.itemShowFirst = this.focusIndex - this.itemShowNum + 1;
                    if (this.itemShowFirst < 0) {
                        this.itemShowFirst = 0;
                    }
                } else if (this.itemShowFirst > this.focusIndex) {
                    this.itemShowFirst = this.focusIndex;
                }
            } else if (Common.isKeyPressed(1, true) || Common.isKeyPressed(19, true)) {
                ++this.focusIndex;
                if (this.focusIndex >= this.objects.length) {
                    this.focusIndex = 0;
                    this.itemShowFirst = 0;
                } else if (this.itemShowFirst < this.focusIndex - this.itemShowNum + 1) {
                    this.itemShowFirst = this.focusIndex - this.itemShowNum + 1;
                }
            }
            if (lastFocused != this.focusIndex) {
                this.itemStrs[lastFocused].stop();
                this.itemStrs[this.focusIndex].start();
                this.bFocusChanged = true;
            }
        }
    }

    public void cycle() {
        this.itemStrs[this.focusIndex].cycle();
    }

    public void draw(Graphics g2, int listX, int listY) {
        this.draw(g2, listX, listY, DefaultFormat, DefaultFocuesFormat, (byte)1);
    }

    public void draw(Graphics g2, int listX, int listY, int[] format, int[] focusFormat, byte vType) {
        int dh = 0;
        if (vType == 0) {
            dh = this.itemHeight - this.xFont.getHeight() >> 1;
        } else if (vType == 2) {
            dh = this.itemHeight - this.xFont.getHeight();
        }
        for (int i2 = 0; i2 < this.itemShowNum; ++i2) {
            int index;
            if (this.bChangeStrColour) {
                format[0] = StrColour[i2];
            }
            if ((index = i2 + this.itemShowFirst) >= this.objects.length) break;
            if (this.focusIndex == index) {
                if (this.bChangeStrColour) {
                    focusFormat[0] = StrColour[i2];
                }
                this.itemStrs[index].draw(g2, listX, listY + this.itemHeight * i2 + dh, focusFormat[0], focusFormat[1], (byte)focusFormat[2], this.xFont);
                continue;
            }
            this.itemStrs[index].draw(g2, listX, listY + this.itemHeight * i2 + dh, format[0], format[1], (byte)format[2], this.xFont);
        }
        this.bChangeStrColour = false;
    }

    public void setStrsClour(int[] strsclour) {
        this.bChangeStrColour = true;
        StrColour = strsclour;
    }
}

