/*
 * Decompiled with CFR 0.152.
 */
package com.game5a.common;

import com.game5a.common.Tool;
import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Vector;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public class XFont {
    private byte fontType;
    public static final byte XFONT_TYPE_DOT = 0;
    public static final byte XFONT_TYPE_SYSTEM = 1;
    public static final byte FONT_TYPE_NULL = 0;
    public static final byte FONT_TYPE_EDGE = 1;
    public static final byte FONT_TYPE_SHADOW = 2;
    private int fontWidth;
    private int fontHeight;
    private int fontNum;
    private int dotNum;
    private Hashtable fontTable;
    private int[] fontRGB;
    public static final int LETTER_MAX = 127;
    public static final byte FONT_COLOR_V = 0;
    public static final byte FONT_COLOR_H = 1;
    Font sysFont;
    public static String marks = ",.!\"'?";

    public XFont(String file) {
        this.fontType = 0;
        this.fontTable = new Hashtable();
        this.load(file);
    }

    public XFont(Font fn) {
        this.fontType = 1;
        this.sysFont = fn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load(String file) {
        InputStream in = null;
        FilterInputStream din = null;
        try {
            in = "".getClass().getResourceAsStream(file);
            din = new DataInputStream(in);
            this.fontWidth = ((DataInputStream)din).readByte();
            this.fontHeight = ((DataInputStream)din).readByte();
            this.fontNum = ((DataInputStream)din).readShort();
            System.out.println("Font Num: " + this.fontNum);
            System.out.println("Font Width: " + this.fontWidth);
            System.out.println("Font Height: " + this.fontHeight);
            this.dotNum = this.fontWidth * this.fontHeight;
            int len = 0;
            len = this.dotNum % 8 == 0 ? this.dotNum / 8 : this.dotNum / 8 + 1;
            for (int i2 = 0; i2 < this.fontNum; ++i2) {
                char ch = ((DataInputStream)din).readChar();
                byte[] data = new byte[len];
                ((DataInputStream)din).read(data, 0, len);
                this.fontTable.put(new Character(ch), data);
            }
            System.out.println("FontTable Size: " + this.fontTable.size());
            this.fontRGB = new int[this.dotNum];
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        finally {
            try {
                if (din != null) {
                    din.close();
                }
            }
            catch (Exception e3) {
                e3.printStackTrace();
            }
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception e4) {
                e4.printStackTrace();
            }
        }
    }

    public int getWidth() {
        if (this.fontType == 0) {
            return this.fontWidth;
        }
        return this.sysFont.charWidth('\u6e38');
    }

    public int getHeight() {
        if (this.fontType == 0) {
            return this.fontHeight;
        }
        return this.sysFont.getHeight();
    }

    public int charWidth(char ch) {
        if (this.fontType == 0) {
            if (ch <= '\u007f') {
                return this.fontWidth >> 1;
            }
            return this.fontWidth;
        }
        return this.sysFont.charWidth(ch);
    }

    public int stringWidth(String str) {
        return this.substringWidth(str, 0, str.length());
    }

    public int substringWidth(String str, int offset, int len) {
        if (this.fontType == 0) {
            int w2 = 0;
            for (int i2 = 0; i2 < len; ++i2) {
                w2 += this.charWidth(str.charAt(i2));
            }
            return w2;
        }
        return this.sysFont.substringWidth(str, offset, len);
    }

    public String[] getStringArray(String s2, int drawWidth) {
        int begin = 0;
        int lineWidth = 0;
        Vector<String> vS = new Vector<String>();
        s2 = s2 + '\n';
        for (int i2 = 0; i2 < s2.length(); ++i2) {
            boolean blineEnd = false;
            if (s2.charAt(i2) == '\n') {
                blineEnd = true;
            } else {
                lineWidth = this.substringWidth(s2, begin, i2 - begin + 1);
                if (lineWidth >= drawWidth) {
                    blineEnd = true;
                }
            }
            if (!blineEnd) continue;
            vS.addElement(s2.substring(begin, i2));
            begin = i2;
            if (s2.charAt(i2) != '\n') continue;
            ++begin;
        }
        Object[] strs = new String[vS.size()];
        vS.copyInto(strs);
        return strs;
    }

    public boolean getFontRGB(char ch, int argb) {
        Object ob = this.fontTable.get(new Character(ch));
        if (ob == null) {
            System.out.println("No Char: " + ch);
            return false;
        }
        byte[] data = (byte[])ob;
        for (int i2 = 0; i2 < data.length; ++i2) {
            int begin = i2 * 8;
            for (int j2 = 0; j2 < 8 && begin + j2 < this.dotNum; ++j2) {
                this.fontRGB[begin + j2] = (data[i2] & 1 << j2) == 0 ? 0 : argb;
            }
        }
        return true;
    }

    public void drawChar(Graphics g2, char ch, int x2, int y2, int argb) {
        if (this.fontType == 0) {
            if ((argb >> 24 & 0xFF) == 0) {
                argb |= 0xFF000000;
            }
            if (this.getFontRGB(ch, argb)) {
                g2.drawRGB(this.fontRGB, 0, this.fontWidth, x2, y2, this.fontWidth, this.fontHeight, true);
            }
        } else {
            g2.setFont(this.sysFont);
            g2.setColor(argb);
            g2.drawChar(ch, x2, y2, Tool.TOP_LEFT);
        }
    }

    public void drawChar(Graphics g2, char ch, int x2, int y2, int frontColor, int bgColor, byte type) {
        if (type == 1) {
            this.drawChar(g2, ch, x2, y2 - 1, bgColor);
            this.drawChar(g2, ch, x2, y2 + 1, bgColor);
            this.drawChar(g2, ch, x2 - 1, y2, bgColor);
            this.drawChar(g2, ch, x2 + 1, y2, bgColor);
        } else if (type == 2) {
            this.drawChar(g2, ch, x2 + 1, y2 + 1, bgColor);
        }
        this.drawChar(g2, ch, x2, y2, frontColor);
    }

    public void drawString(Graphics g2, String str, int x2, int y2, int argb) {
        if (this.fontType == 0) {
            int dx = x2;
            for (int i2 = 0; i2 < str.length(); ++i2) {
                char ch = str.charAt(i2);
                this.drawChar(g2, str.charAt(i2), dx, y2, argb);
                dx += this.charWidth(ch);
            }
        } else {
            g2.setFont(this.sysFont);
            g2.setColor(argb);
            g2.drawString(str, x2, y2, Tool.TOP_LEFT);
        }
    }

    public void drawString(Graphics g2, String str, int x2, int y2, int frontColor, int bgColor, byte type) {
        if (type == 1) {
            this.drawString(g2, str, x2, y2 - 1, bgColor);
            this.drawString(g2, str, x2, y2 + 1, bgColor);
            this.drawString(g2, str, x2 - 1, y2, bgColor);
            this.drawString(g2, str, x2 + 1, y2, bgColor);
        } else if (type == 2) {
            this.drawString(g2, str, x2 + 1, y2 + 1, bgColor);
        }
        this.drawString(g2, str, x2, y2, frontColor);
    }

    public void drawString(Graphics g2, String s2, int x2, int y2, int frontColor, int bgColor, int jrange, byte type) {
        if (jrange == 0) {
            this.drawString(g2, s2, x2, y2, frontColor, bgColor, type);
        } else {
            int dx = x2;
            for (int i2 = 0; i2 < s2.length(); ++i2) {
                char ch = s2.charAt(i2);
                this.drawChar(g2, ch, dx, y2 + Tool.WAVE_POS[(i2 + Tool.countTimes % Tool.WAVE_POS.length) % Tool.WAVE_POS.length] * jrange, frontColor, bgColor, type);
                dx += this.charWidth(ch);
            }
        }
    }

    public boolean getFontRGB(char ch, int[] argbs, byte colorDir) {
        Object ob = this.fontTable.get(new Character(ch));
        if (ob == null) {
            System.out.println("No Char: " + ch);
            return false;
        }
        byte[] data = (byte[])ob;
        for (int i2 = 0; i2 < data.length; ++i2) {
            int begin = i2 * 8;
            for (int j2 = 0; j2 < 8 && begin + j2 < this.dotNum; ++j2) {
                this.fontRGB[begin + j2] = (data[i2] & 1 << j2) == 0 ? 0 : (colorDir == 0 ? argbs[(begin + j2) / this.fontWidth % argbs.length] : argbs[(begin + j2) % this.fontWidth % argbs.length]);
            }
        }
        return true;
    }

    public void drawChar(Graphics g2, char ch, int x2, int y2, int[] argbs, byte colorDir) {
        if (this.fontType == 0) {
            if (this.getFontRGB(ch, argbs, colorDir)) {
                g2.drawRGB(this.fontRGB, 0, this.fontWidth, x2, y2, this.fontWidth, this.fontHeight, true);
            }
        } else {
            g2.setFont(this.sysFont);
            g2.setColor(argbs[0]);
            g2.drawChar(ch, x2, y2, Tool.TOP_LEFT);
        }
    }

    public void drawString(Graphics g2, String str, int x2, int y2, int[] argbs, byte colorDir) {
        if (this.fontType == 0) {
            int dx = x2;
            for (int i2 = 0; i2 < str.length(); ++i2) {
                char ch = str.charAt(i2);
                this.drawChar(g2, str.charAt(i2), dx, y2, argbs, colorDir);
                dx += this.charWidth(ch);
            }
        } else {
            g2.setFont(this.sysFont);
            g2.setColor(argbs[0]);
            g2.drawString(str, x2, y2, Tool.TOP_LEFT);
        }
    }

    public void drawString(Graphics g2, String str, int x2, int y2, int[] argbs, byte colorDir, int bgColor, byte type) {
        if (type == 1) {
            this.drawString(g2, str, x2, y2 - 1, bgColor);
            this.drawString(g2, str, x2, y2 + 1, bgColor);
            this.drawString(g2, str, x2 - 1, y2, bgColor);
            this.drawString(g2, str, x2 + 1, y2, bgColor);
        } else if (type == 2) {
            this.drawString(g2, str, x2 + 1, y2 + 1, bgColor);
        }
        this.drawString(g2, str, x2, y2, argbs, colorDir);
    }

    public static String[] getStringArray(String s2, char ch) {
        if (s2.length() == 0) {
            return null;
        }
        int startIndex = 0;
        int endIndex = 0;
        Vector<String> vS = new Vector<String>();
        while (true) {
            if ((endIndex = s2.indexOf(ch, startIndex)) == -1) break;
            vS.addElement(s2.substring(startIndex, endIndex));
            startIndex = endIndex + 1;
        }
        vS.addElement(s2.substring(startIndex));
        Object[] strs = new String[vS.size()];
        vS.copyInto(strs);
        return strs;
    }

    public static String[] getStringArray(String s2, String sep) {
        if (s2.length() == 0) {
            return null;
        }
        int startIndex = 0;
        int endIndex = 0;
        Vector<String> vS = new Vector<String>();
        while (true) {
            if ((endIndex = s2.indexOf(sep, startIndex)) == -1) break;
            vS.addElement(s2.substring(startIndex, endIndex));
            startIndex = endIndex + sep.length();
        }
        vS.addElement(s2.substring(startIndex));
        Object[] strs = new String[vS.size()];
        vS.copyInto(strs);
        return strs;
    }

    public static String[] getStringArray(String s2) {
        return XFont.getStringArray(s2, '\n');
    }
}

