/*
 * Decompiled with CFR 0.152.
 */
package com.game5a.common;

import com.game5a.common.Rectangle;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Random;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Tool {
    public static final int UI_RATATE_90 = 90;
    public static final int UI_RATATE_180 = 180;
    public static final int UI_RATATE_270 = 270;
    public static final int UI_FLIP_HORIZONTAL = 8192;
    public static final int UI_FLIP_VERTICAL = 16384;
    public static final int TRANS_NONE = 0;
    public static final int TRANS_MIRROR_ROT180 = 1;
    public static final int TRANS_MIRROR = 2;
    public static final int TRANS_ROT180 = 3;
    public static final int TRANS_ROT90 = 5;
    public static final int TRANS_ROT270 = 6;
    public static int CENTER = 3;
    public static int TOP_LEFT = 20;
    public static final byte H_CENTER = 0;
    public static final byte H_LEFT = 1;
    public static final byte H_RIGHT = 2;
    public static final byte V_CENTER = 0;
    public static final byte V_TOP = 1;
    public static final byte V_BOTTOM = 2;
    public static final byte[] PNG_HEAD = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10, 0, 0, 0, 13, 73, 72, 68, 82};
    public static final byte[] PNG_END = new byte[]{0, 0, 0, 0, 73, 69, 78, 68, -82, 66, 96, -126};
    public static final int P_CHUNK_SIZE = 100;
    public static int countTimes = 0;
    public static Random rnd = new Random(System.currentTimeMillis());
    private static int[] alphaColors;
    private static final String FREE_MEMORY = "FreeMemory = ";
    public static int imageCreatedColor;
    public static boolean bChinese;
    public static String IMAGE_PNG;
    public static String IMAGE_P;
    public static String IMAGE_NUM_STYLE0;
    public static String IMAGE_NUM_STYLE1;
    public static String IMAGE_NUM_STYLE2;
    public static int[] WAVE_POS;

    public static void init() {
        Image img = Image.createImage((int)1, (int)1);
        int[] rgbData = Tool.getImageRGB(img, 0, 0, 1, 1);
        imageCreatedColor = rgbData[0];
    }

    public static void cycle() {
        ++countTimes;
    }

    public static Image createImage(String str) {
        try {
            if (str.endsWith(IMAGE_PNG)) {
                return Image.createImage((String)str);
            }
            return Tool.loadPImage(str);
        }
        catch (Exception e2) {
            e2.printStackTrace();
            return null;
        }
    }

    public static int getMirrorTransType(int dt) {
        int mdt = 0;
        switch (dt) {
            case 0: {
                mdt = 2;
                break;
            }
            case 2: {
                mdt = 0;
                break;
            }
            case 1: {
                mdt = 3;
                break;
            }
            case 3: {
                mdt = 1;
                break;
            }
        }
        return mdt;
    }

    public static void drawRegion(Graphics g2, Image image, int x_src, int y_src, int width, int height, int transType, int x_dest, int y_dest) {
        if (transType < 4) {
            g2.setClip(x_dest, y_dest, width, height);
        } else {
            g2.setClip(x_dest, y_dest, height, width);
        }
        g2.drawRegion(image, x_src, y_src, width, height, transType, x_dest, y_dest, TOP_LEFT);
    }

    public static int[] getImageRGB(Image image, int x_src, int y_src, int width, int height) {
        int length = width * height;
        int[] rgbData = new int[length];
        image.getRGB(rgbData, 0, width, x_src, y_src, width, height);
        return rgbData;
    }

    public static void drawRegionAlphaColor(Graphics g2, Image image, int x_src, int y_src, int width, int height, int transType, int x_dest, int y_dest, int alphaColor) {
        int length = width * height;
        int[] rgbData = new int[length];
        image.getRGB(rgbData, 0, width, x_src, y_src, width, height);
        int alpha = alphaColor >>> 24;
        int alphaR = alphaColor >>> 16 & 0xFF;
        int alphaG = alphaColor >>> 8 & 0xFF;
        int alphaB = alphaColor & 0xFF;
        Hashtable<String, String> colorHT = new Hashtable<String, String>();
        int count = 0;
        for (int i2 = 0; i2 < length; ++i2) {
            if (rgbData[i2] == imageCreatedColor) {
                rgbData[i2] = 0;
                continue;
            }
            if (rgbData[i2] >>> 24 == 0) continue;
            String rgbKey = Integer.toString(rgbData[i2]);
            if (colorHT.containsKey(rgbKey)) {
                rgbData[i2] = Integer.parseInt((String)colorHT.get(rgbKey));
                continue;
            }
            int red = rgbData[i2] >>> 16 & 0xFF;
            int green = rgbData[i2] >>> 8 & 0xFF;
            int blue = rgbData[i2] & 0xFF;
            red = red * (255 - alpha) / 255 + alphaR * alpha / 255;
            green = green * (255 - alpha) / 255 + alphaG * alpha / 255;
            blue = blue * (255 - alpha) / 255 + alphaB * alpha / 255;
            rgbData[i2] = red << 16 | green << 8 | blue | 0xFF000000;
            colorHT.put(rgbKey, Integer.toString(rgbData[i2]));
            ++count;
        }
        Tool.drawRGB(g2, rgbData, x_dest, y_dest, width, height, transType, true);
    }

    public static void drawImageAlphaColor(Graphics g2, Image i2, int x2, int y2, int transType, int alphaColor) {
        Tool.drawRegionAlphaColor(g2, i2, 0, 0, i2.getWidth(), i2.getHeight(), transType, x2, y2, alphaColor);
    }

    public static void drawRegionAlpha(Graphics g2, Image image, int x_src, int y_src, int width, int height, int transType, int x_dest, int y_dest, int alphaValue) {
        if (alphaValue <= 0) {
            return;
        }
        if (alphaValue >= 255) {
            Tool.drawRegion(g2, image, x_src, y_src, width, height, transType, x_dest, y_dest);
            return;
        }
        int alpha = alphaValue << 24;
        int length = width * height;
        int[] rgbData = new int[length];
        image.getRGB(rgbData, 0, width, x_src, y_src, width, height);
        for (int i2 = 0; i2 < length; ++i2) {
            if (rgbData[i2] == imageCreatedColor) {
                rgbData[i2] = 0;
                continue;
            }
            if (rgbData[i2] >>> 24 == 0) continue;
            rgbData[i2] = rgbData[i2] & 0xFFFFFF | alpha;
        }
        Tool.drawRGB(g2, rgbData, x_dest, y_dest, width, height, transType, true);
    }

    public static void drawImageAlpha(Graphics g2, Image i2, int x2, int y2, int transType, int alphaValue) {
        Tool.drawRegionAlpha(g2, i2, 0, 0, i2.getWidth(), i2.getHeight(), transType, x2, y2, alphaValue);
    }

    public static void drawRGB(Graphics g2, int[] rgbData, int x_dest, int y_dest, int width, int height, int transType, boolean processAlpha) {
        if (transType < 4) {
            g2.setClip(x_dest, y_dest, width, height);
        } else {
            g2.setClip(x_dest, y_dest, height, width);
        }
        int length = width * height;
        switch (transType) {
            case 1: {
                int[] rgb = new int[length];
                for (int i2 = 0; i2 < height; ++i2) {
                    System.arraycopy(rgbData, i2 * width, rgb, (height - i2 - 1) * width, width);
                }
                g2.drawRGB(rgb, 0, width, x_dest, y_dest, width, height, processAlpha);
                break;
            }
            case 2: {
                int[] rgb = new int[length];
                for (int i3 = 0; i3 < height; ++i3) {
                    for (int j2 = 0; j2 < width; ++j2) {
                        rgb[i3 * width + j2] = rgbData[i3 * width + width - j2 - 1];
                    }
                }
                g2.drawRGB(rgb, 0, width, x_dest, y_dest, width, height, processAlpha);
                break;
            }
            case 3: {
                int[] rgb = new int[length];
                for (int i4 = 0; i4 < height; ++i4) {
                    for (int j3 = 0; j3 < width; ++j3) {
                        rgb[i4 * width + j3] = rgbData[(height - i4 - 1) * width + width - j3 - 1];
                    }
                }
                g2.drawRGB(rgb, 0, width, x_dest, y_dest, width, height, processAlpha);
                break;
            }
            case 5: {
                int[] rgb = new int[length];
                for (int i5 = 0; i5 < width; ++i5) {
                    for (int j4 = 0; j4 < height; ++j4) {
                        rgb[i5 * height + j4] = rgbData[(height - j4 - 1) * width + i5];
                    }
                }
                g2.drawRGB(rgb, 0, height, x_dest, y_dest, height, width, processAlpha);
                break;
            }
            case 6: {
                int[] rgb = new int[length];
                for (int i6 = 0; i6 < width; ++i6) {
                    for (int j5 = 0; j5 < height; ++j5) {
                        rgb[i6 * height + j5] = rgbData[j5 * width + width - i6 - 1];
                    }
                }
                g2.drawRGB(rgb, 0, height, x_dest, y_dest, height, width, processAlpha);
                break;
            }
            default: {
                g2.drawRGB(rgbData, 0, width, x_dest, y_dest, width, height, processAlpha);
            }
        }
    }

    public static void drawTile(Graphics g2, Image image, int id, int fwidth, int fheight, int type, int dx, int dy) {
        int cols = image.getWidth() / fwidth;
        Tool.drawRegion(g2, image, id % cols * fwidth, id / cols * fheight, fwidth, fheight, type, dx, dy);
    }

    public static void drawImage(Graphics g2, Image i2, int x2, int y2, int transType) {
        if (transType == 0) {
            g2.setClip(x2, y2, i2.getWidth(), i2.getHeight());
            g2.drawImage(i2, x2, y2, TOP_LEFT);
        } else {
            Tool.drawRegion(g2, i2, 0, 0, i2.getWidth(), i2.getHeight(), transType, x2, y2);
        }
    }

    public static boolean getNextRndBoolean() {
        return Math.abs(rnd.nextInt()) % 2 == 0;
    }

    public static int getNextRnd(int min, int max) {
        if (max == min) {
            return min;
        }
        if (max < min) {
            return min - Math.abs(rnd.nextInt()) % (min - max);
        }
        return min + Math.abs(rnd.nextInt()) % (max - min);
    }

    public static int getNextRnd() {
        return rnd.nextInt();
    }

    public static int getNextOdds() {
        return Math.abs(rnd.nextInt()) % 100;
    }

    public static int getOddsResult(byte[] odds, boolean bMustRet) {
        int rnd = Tool.getNextOdds();
        int temp = 0;
        for (int ret = 0; ret < odds.length; ++ret) {
            if (rnd >= (temp += odds[ret])) continue;
            return ret;
        }
        if (bMustRet) {
            return Tool.getNextRnd(0, odds.length);
        }
        return -1;
    }

    public static int power(int base, int exp) {
        if (exp < 0) {
            return 0;
        }
        int result = 1;
        for (int i2 = 0; i2 < exp; ++i2) {
            result *= base;
        }
        return result;
    }

    public static void drawImageNum(Graphics g2, Image img, String numStr, int dx, int dy, int fontWidth, int offSet) {
        int ih = img.getHeight();
        for (int i2 = 0; i2 < numStr.length(); ++i2) {
            char ch = numStr.charAt(i2);
            int id = ch - 48;
            int x2 = dx + i2 * (fontWidth + offSet);
            Tool.drawTile(g2, img, id, fontWidth, ih, 0, x2, dy);
        }
    }

    public static void drawImageNum(Graphics g2, Image img, String numStr, int dx, int dy, int fontWidth, int offSet, int alphaColor) {
        int ih = img.getHeight();
        for (int i2 = 0; i2 < numStr.length(); ++i2) {
            char ch = numStr.charAt(i2);
            int id = ch - 48;
            int x2 = dx + i2 * (fontWidth + offSet);
            int cols = fontWidth;
            Tool.drawRegionAlpha(g2, img, id % cols * fontWidth, 0, fontWidth, ih, 0, x2, dy, alphaColor);
        }
    }

    public static void drawImageNum(Graphics g2, Image img, String numStr, int dx, int dy, int fontWidth, int offSet, String imgDes) {
        int ih = img.getHeight();
        for (int i2 = 0; i2 < numStr.length(); ++i2) {
            char ch = numStr.charAt(i2);
            int id = imgDes.indexOf(ch);
            if (id < 0) continue;
            int x2 = dx + i2 * (fontWidth + offSet);
            Tool.drawTile(g2, img, id, fontWidth, ih, 0, x2, dy);
        }
    }

    public static void drawImageRect(Graphics g2, Image rImage, int rx, int ry, int rw, int rh, int bgColor) {
        int i2;
        int fw = rImage.getWidth() / 3;
        int fh = rImage.getHeight() / 3;
        if (rh < fh) {
            ry += rh - fh * 2 >> 1;
            rh = fh * 2;
        }
        int rwb = rw;
        int rhb = rh;
        int w2 = rw / fw;
        int h2 = rh / fh;
        if (w2 * fw < rw) {
            rw = fw * (w2 + 1);
            rx += rwb - rw >> 1;
        }
        if (h2 * fh < rh) {
            rh = fh * (h2 + 1);
            ry += rhb - rh >> 1;
        }
        if (bgColor >= 0) {
            g2.setColor(bgColor);
            g2.fillRect(rx + fw, ry + fh, rw - fw * 2, rh - fh * 2);
        }
        for (i2 = 0; i2 < rw / fw - 2; ++i2) {
            Tool.drawTile(g2, rImage, 1, fw, fh, 0, rx + fw * (i2 + 1), ry);
            Tool.drawTile(g2, rImage, 7, fw, fh, 0, rx + fw * (i2 + 1), ry + rh - fh);
        }
        for (i2 = 0; i2 < rh / fh - 2; ++i2) {
            Tool.drawTile(g2, rImage, 3, fw, fh, 0, rx, ry + fh * (i2 + 1));
            Tool.drawTile(g2, rImage, 5, fw, fh, 0, rx + rw - fw, ry + fh * (i2 + 1));
        }
        Tool.drawTile(g2, rImage, 0, fw, fh, 0, rx, ry);
        Tool.drawTile(g2, rImage, 2, fw, fh, 0, rx + rw - fw, ry);
        Tool.drawTile(g2, rImage, 6, fw, fh, 0, rx, ry + rh - fh);
        Tool.drawTile(g2, rImage, 8, fw, fh, 0, rx + rw - fw, ry + rh - fh);
    }

    public static void fillAlphaRect(Graphics g2, int argb, int x2, int y2, int width, int height) {
        g2.setClip(x2, y2, width, height);
        int alpha = argb >>> 24;
        if (alpha == 0) {
            return;
        }
        if (alpha == 255) {
            g2.setColor(argb & 0xFFFFFF);
            g2.fillRect(x2, y2, width, height);
            return;
        }
        boolean bnew = false;
        if (alphaColors == null) {
            bnew = true;
        } else if (width != alphaColors.length || argb != alphaColors[0]) {
            bnew = true;
        }
        if (bnew) {
            alphaColors = new int[width];
            for (int i2 = 0; i2 < width; ++i2) {
                Tool.alphaColors[i2] = argb;
            }
        }
        g2.drawRGB(alphaColors, 0, 0, x2, y2, width, height, true);
    }

    public static void clearUpMemory() {
        System.out.println(FREE_MEMORY + Runtime.getRuntime().freeMemory());
    }

    public static boolean isRectIntersected(int ax, int ay, int aw, int ah, int bx, int by, int bw, int bh) {
        return by + bh >= ay && by <= ay + ah && bx + bw >= ax && bx <= ax + aw;
    }

    public static boolean isRectIntersected(int ax, int ay, Rectangle aRect, int bx, int by, Rectangle bRect) {
        return Tool.isRectIntersected(ax + aRect.x, ay + aRect.y, aRect.width, aRect.height, bx + bRect.x, by + bRect.y, bRect.width, bRect.height);
    }

    public static byte[] getBytesFromInput(InputStream in) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int rd = 0;
        int len = 0;
        byte[] buf = new byte[64];
        while ((rd = in.read(buf)) != -1) {
            len += rd;
            out.write(buf, 0, rd);
        }
        byte[] rt = out.toByteArray();
        out.close();
        in.close();
        return rt;
    }

    public static String toUTF(byte[] data, int off, int len) {
        char[] infoStr = new char[len * 2];
        int i2 = 0;
        int charCount = 0;
        while (i2 < len) {
            try {
                char ch;
                if ((data[i2 + off] & 0x80) != 0) {
                    if ((data[i2 + off] & 0x20) != 0) {
                        ch = (char)((data[i2 + off] & 0xF) << 12);
                        ch = (char)(ch + ((char)(data[i2 + 1 + off] & 0x3F) << 6));
                        ch = (char)(ch + (data[i2 + 2 + off] & 0x3F));
                        i2 += 3;
                    } else {
                        ch = (char)((data[i2 + off] & 0x1F) << 6);
                        ch = (char)(ch + (data[i2 + 1 + off] & 0x3F));
                        i2 += 2;
                    }
                } else {
                    ch = (char)data[i2 + off];
                    ++i2;
                }
                infoStr[charCount++] = ch;
            }
            catch (Exception _ex) {}
        }
        return new String(infoStr, 0, charCount);
    }

    public static void reportException(Exception e2) {
        e2.printStackTrace();
    }

    public static String decryptString(String srcStr, int version) {
        String desStr = srcStr;
        if (version == 1) {
            int length = srcStr.length() / 2;
            char[] chs = new char[length];
            for (int i2 = 0; i2 < length; ++i2) {
                char ch0 = srcStr.charAt(i2 * 2);
                char ch1 = srcStr.charAt(i2 * 2 + 1);
                chs[i2] = (char)((ch0 - 65) / 8 * 24 + (ch1 - 97));
            }
            desStr = new String(chs);
        }
        return desStr;
    }

    public static Image loadPImage(String file) throws Exception {
        Image img = null;
        InputStream in = "".getClass().getResourceAsStream(file);
        byte[] lens = new byte[4];
        in.read(lens);
        int len = ((lens[0] & 0xFF) << 24) + ((lens[1] & 0xFF) << 16) + ((lens[2] & 0xFF) << 8) + (lens[3] & 0xFF);
        byte[] pngData = new byte[PNG_HEAD.length + len + PNG_END.length];
        System.arraycopy(PNG_HEAD, 0, pngData, 0, PNG_HEAD.length);
        System.arraycopy(PNG_END, 0, pngData, pngData.length - PNG_END.length, PNG_END.length);
        int blockNum = len / 100;
        int oddSize = len % 100;
        int off = PNG_HEAD.length + len;
        if (oddSize != 0) {
            in.read(pngData, off -= oddSize, oddSize);
        }
        for (int i2 = blockNum - 1; i2 >= 0; --i2) {
            in.read(pngData, off -= 100, 100);
        }
        in.close();
        in = null;
        img = Image.createImage((byte[])pngData, (int)0, (int)pngData.length);
        return img;
    }

    public static Image loadPPImage(String file, String palette) throws Exception {
        Image img = null;
        InputStream in = "".getClass().getResourceAsStream(file);
        byte[] lens = new byte[4];
        in.read(lens);
        int len = ((lens[0] & 0xFF) << 24) + ((lens[1] & 0xFF) << 16) + ((lens[2] & 0xFF) << 8) + (lens[3] & 0xFF);
        byte[] pngData = new byte[PNG_HEAD.length + len + PNG_END.length];
        System.arraycopy(PNG_HEAD, 0, pngData, 0, PNG_HEAD.length);
        System.arraycopy(PNG_END, 0, pngData, pngData.length - PNG_END.length, PNG_END.length);
        int blockNum = len / 100;
        int oddSize = len % 100;
        int off = PNG_HEAD.length + len;
        if (oddSize != 0) {
            in.read(pngData, off -= oddSize, oddSize);
        }
        for (int i2 = blockNum - 1; i2 >= 0; --i2) {
            in.read(pngData, off -= 100, 100);
        }
        in.close();
        in = null;
        byte[] ptData = Tool.getBytesFromInput("".getClass().getResourceAsStream(palette));
        System.arraycopy(ptData, 4, pngData, 41, ptData.length - 4);
        img = Image.createImage((byte[])pngData, (int)0, (int)pngData.length);
        return img;
    }

    public static void fillRect(Graphics g2, int x2, int y2, int width, int height, int bgClr, int edgeClr, boolean hasVertex) {
        if (edgeClr < 0) {
            g2.setColor(bgClr);
            g2.fillRect(x2, y2, width, height);
        } else {
            g2.setColor(bgClr);
            g2.fillRect(x2 + 1, y2 + 1, width - 2, height - 2);
            g2.setColor(edgeClr);
            if (hasVertex) {
                g2.drawRect(x2, y2, width - 1, height - 1);
            } else {
                g2.fillRect(x2 + 1, y2, width - 2, 1);
                g2.fillRect(x2 + 1, y2 + height - 1, width - 2, 1);
                g2.fillRect(x2, y2 + 1, 1, height - 2);
                g2.fillRect(x2 + width - 1, y2 + 1, 1, height - 2);
            }
        }
    }

    public static final int sqrt(int value) {
        int sqrt = 0;
        for (int k2 = 0x40000000; k2 != 0; k2 >>= 2) {
            int tmp = sqrt + k2;
            sqrt >>= 1;
            if (tmp > value) continue;
            value -= tmp;
            sqrt += k2;
        }
        return sqrt;
    }

    public static void drawImageString(Graphics g2, Image img, String str, String fontStoreroom, int x2, int y2, int anchor, int space) {
        int clipW = img.getWidth() / fontStoreroom.length();
        int clipH = img.getHeight();
        StringBuffer sb = new StringBuffer();
        sb.append(str);
        str = sb.toString();
        int strLength = str.length();
        int offset = Tool.getAnchorOffset(anchor, 0, strLength * clipW + space, clipH);
        x2 -= (offset & 0xFFFF0000) >> 16;
        y2 -= offset & 0xFFFF;
        int i2 = 0;
        while (i2 < strLength) {
            int charId = fontStoreroom.indexOf(str.charAt(i2));
            if (charId != -1) {
                Tool.drawRegion(g2, img, charId * clipW, 0, clipW, clipH, 0, x2, y2);
            }
            ++i2;
            x2 += clipW + space;
        }
    }

    public static int getAnchorOffset(int anchor, int transform, int w2, int h2) {
        int offX = 0;
        int offY = 0;
        if ((transform & 4) != 0) {
            int tW = w2;
            w2 = h2;
            h2 = tW;
        }
        if ((anchor & 0x40) != 0) {
            throw new IllegalArgumentException();
        }
        if ((anchor & 1) != 0) {
            offX = w2 >> 1;
        } else if ((anchor & 8) != 0) {
            offX = w2;
        }
        if ((anchor & 2) != 0) {
            offY = h2 >> 1;
        } else if ((anchor & 0x20) != 0) {
            offY = h2;
        }
        return offX << 16 | offY;
    }

    public static String[] formatText(String str, int width, int fontW) {
        Vector<String> text = new Vector<String>();
        int fW = 0;
        if (width % fontW != 0) {
            fW = width / fontW * fontW - fontW;
        }
        str = str + '\n';
        int strBgin = 0;
        int strEnd = 0;
        int counter = 0;
        for (int i2 = 0; i2 < str.length(); ++i2) {
            String sub;
            boolean out;
            char ch = str.charAt(i2);
            boolean isNewline = ch == '\n';
            boolean bl = out = ++counter * fontW > fW;
            if (isNewline) {
                strEnd = i2;
                sub = str.substring(strBgin, strEnd);
                text.addElement(sub);
                strBgin = strEnd + 1;
                counter = -1;
                out = false;
            }
            if (!out) continue;
            strEnd = i2;
            sub = str.substring(strBgin, strEnd);
            text.addElement(sub);
            strBgin = strEnd;
            counter = 0;
        }
        String[] strText = new String[text.size()];
        for (int i3 = 0; i3 < text.size(); ++i3) {
            strText[i3] = text.elementAt(i3).toString();
        }
        return strText;
    }

    public static int[] countSpeed(int starX, int starY, int toX, int toY, int speed) {
        int tempSqrt = (starX - toX) * (starX - toX) + (starY - toY) * (starY - toY);
        int[] xy = new int[2];
        int l2 = Tool.sqrt(tempSqrt);
        if (l2 != 0) {
            xy[0] = (starX - toX << 10) / l2;
            xy[1] = (starY - toY << 10) / l2;
        }
        int[] move = new int[]{speed * xy[0] >> 10, speed * xy[1] >> 10};
        return move;
    }

    static {
        bChinese = true;
        IMAGE_PNG = ".png";
        IMAGE_P = ".p";
        IMAGE_NUM_STYLE0 = "0123456789";
        IMAGE_NUM_STYLE1 = "+0123456789";
        IMAGE_NUM_STYLE2 = "-0123456789";
        WAVE_POS = new int[]{-1, 0, 1, 0};
    }
}

