/*
 * Decompiled with CFR 0.152.
 */
package com.game5a.common;

import com.game5a.common.XFont;
import javax.microedition.lcdui.Graphics;

public class MovingString {
    private String content;
    private int movingTimes;
    private int stayTimes;
    public static final int STAY_TIMES_MAX = 5;
    private int width;
    private int step;
    private boolean bMove;
    private boolean bEnd;

    public MovingString(String str, int drawWidth, int moveStep) {
        this.content = str;
        this.movingTimes = 0;
        this.stayTimes = 0;
        this.width = drawWidth;
        this.step = moveStep;
        this.bMove = false;
        this.bEnd = false;
    }

    public void start() {
        this.bMove = true;
    }

    public void stop() {
        this.movingTimes = 0;
        this.stayTimes = 0;
        this.bMove = false;
        this.bEnd = false;
    }

    public void pause() {
        this.bMove = false;
    }

    public boolean isEnd() {
        return this.bEnd;
    }

    public void setContent(String str) {
        this.content = str;
        this.movingTimes = 0;
        this.bMove = false;
        this.bEnd = false;
    }

    public String getContent() {
        return this.content;
    }

    public void setPositionLeft() {
        this.movingTimes = -(this.width / this.step + 1);
    }

    public void cycle() {
        if (this.content == null) {
            return;
        }
        if (this.bMove) {
            ++this.stayTimes;
            if (this.stayTimes > 5) {
                ++this.movingTimes;
            }
        }
    }

    public void draw(Graphics g2, int x2, int y2, int frontColor, int bgColor, byte type, XFont xFont) {
        if (this.content == null) {
            return;
        }
        g2.setClip(x2 - 1, y2, this.width, xFont.getHeight());
        int sw = xFont.stringWidth(this.content);
        if (sw <= this.width) {
            xFont.drawString(g2, this.content, x2, y2, frontColor, bgColor, type);
        } else {
            int dx = this.movingTimes * this.step;
            if (dx >= sw) {
                this.bEnd = true;
                this.movingTimes = -(this.width / this.step + 1);
            }
            xFont.drawString(g2, this.content, x2 - dx, y2, frontColor, bgColor, type);
        }
    }
}

