/*
 * Decompiled with CFR 0.152.
 */
package com.game5a.client;

import com.game5a.client.Equip;
import com.game5a.client.Game;
import com.game5a.client.Item;
import com.game5a.client.MapSprite;
import com.game5a.client.Pet;
import com.game5a.client.data.EquipData;
import com.game5a.client.data.RoleData;
import com.game5a.client.data.SkillData;
import com.game5a.common.Tool;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;

public class Role
extends MapSprite {
    public static final byte LV_MAX = 99;
    public static final int LEFT_NUM_MAX = 99999;
    public static final int ATT_NUM_MAX = 9999;
    public static final int NATURE_NUM_MAX = 100;
    public static final int TALENT_LEVEL = 10;
    public RoleData data;
    public static final byte EQUIP_PART_WEAPON = 0;
    public static final byte EQUIP_PART_ARMOR = 1;
    public static final byte EQUIP_PART_JEWELRY = 2;
    public static final byte EQUIP_PART_HAT = 3;
    public static final byte EQUIP_PART_SHOES = 4;
    public static final int EQUIP_NUM = 5;
    public Equip[] equips = new Equip[5];
    public byte[] equipTypes = new byte[5];
    public static Pet pet;
    public int curExp;
    public int nextExp;
    public int toplimitHp;
    public int toplimitMp;
    public int toplimitAtt;
    public int toplimitDef;
    public int toplimitCrit;
    public int toplimitMiss;
    public int suitHp;
    public int suitMp;
    public int suitAtt;
    public int suitAttMax;
    public int suitDef;
    public int suitMiss;
    public int suitCrit;
    public int suitAgile;
    public int recodrdID;
    public int level;
    public int hp;
    public int hpMax;
    public int hpMaxFinal;
    public int mp;
    public int mpMax;
    public int mpMaxFinal;
    public int attack;
    public int attackFinal;
    public int attackMax;
    public int attackMaxFinal;
    public int def;
    public int defFinal;
    public int crit;
    public int critFinal;
    public int onceKill;
    public int onceKillFinal;
    public int miss;
    public int missFinal;
    public int swim;
    public int swimFinal;
    public int poison;
    public int poisonFinal;
    public byte immuneType;
    public byte agile;
    public byte agileFinal;
    public int talentLv = -1;
    public int TalentHpMax;
    public int TalentMpMax;
    public int TalentAttack;
    public int TalentDefend;
    public int TalentCrit;
    public int TalentMiss;
    public boolean bShowSword;
    boolean bSwordFront;
    static final int[] SWORD_D_Xs;
    static final int[] SWORD_D_Ys;
    int swordCurPosIndex;
    int swordNextPosIndex;
    public boolean bShowLevelUp;
    int showLevelUpTime;
    public byte order = 1;
    public int propIndex;
    public Vector skills = new Vector();
    public Vector skillsMenu = new Vector();
    public Vector mp_skill = new Vector();
    public Vector sp_skill = new Vector();
    public Vector learnSkills = new Vector();
    public Vector gemSkills = new Vector();
    public int skillIndex;
    public int skillHuan;

    public Role() {
        this.initCountTime();
        this.setLevel(1);
        this.type = 0;
    }

    public Role(RoleData roleData) {
        this.initCountTime();
        this.type = 0;
        this.data = roleData;
        this.initData();
        this.setLevel(1);
        this.checkSkillToLearn();
    }

    public void initData() {
        this.sortID = this.data.sortID;
        this.ID = this.data.sortID;
        this.equipTypes[0] = this.data.weaponType;
        this.equipTypes[1] = this.data.armorType;
        this.equipTypes[2] = 7;
        this.equipTypes[3] = 5;
        this.equipTypes[4] = 6;
        this.level = 1;
        this.hp = this.data.hp;
        this.hpMax = this.data.hp;
        this.mp = this.data.mp;
        this.mpMax = this.data.mp;
        this.attack = this.data.attack;
        this.attackMax = this.data.attackMax;
        this.def = this.data.defend;
        this.crit = this.data.doubleHurt;
        this.miss = this.data.miss;
        this.agile = this.data.agile;
        this.refreshNature();
        this.bCheckMapBlock = true;
    }

    public void loadRes() {
        this.loadRes(this.data.actionFile, this.data.imageFiles);
        this.initAct();
    }

    public void setData(RoleData roleData) {
        this.data = roleData;
        this.sortID = this.data.sortID;
        this.ID = this.data.sortID;
    }

    public void checkProperty() {
        if (this.equips[1] == null) {
            return;
        }
    }

    public void checkSkillToLearn() {
        for (int i2 = 0; i2 < this.data.skillLearnData.length; ++i2) {
            if (this.data.skillLearnData[i2][0] > this.level) continue;
            for (int j2 = 1; j2 < this.data.skillLearnData[i2].length; ++j2) {
                this.addSkill(Game.getSkillData(this.data.skillLearnData[i2][j2]));
            }
        }
    }

    public void getLvLearnSkill() {
        this.learnSkills.removeAllElements();
        for (int i2 = 0; i2 < this.data.skillLearnData.length; ++i2) {
            if (this.data.skillLearnData[i2][0] > this.level) continue;
            for (int j2 = 1; j2 < this.data.skillLearnData[i2].length; ++j2) {
                this.addLearnSkill(Game.getSkillData(this.data.skillLearnData[i2][j2]));
            }
        }
    }

    public boolean addLearnSkill(SkillData skill) {
        for (int i2 = 0; i2 < this.skills.size(); ++i2) {
            SkillData sk = (SkillData)this.skills.elementAt(i2);
            if (sk.sortID < skill.sortID && sk.contrastType == skill.contrastType) {
                this.removeSkill(sk);
                continue;
            }
            if (sk.contrastType != skill.contrastType) continue;
            return false;
        }
        this.learnSkills.addElement(skill);
        return true;
    }

    public boolean setMenuShowSkill() {
        SkillData sk;
        int i2;
        if (this.skills.isEmpty() && this.gemSkills.isEmpty()) {
            return false;
        }
        this.skillsMenu = new Vector();
        for (i2 = 0; i2 < this.skills.size(); ++i2) {
            sk = (SkillData)this.skills.elementAt(i2);
            if (sk.mpUsed <= 0) continue;
            this.skillsMenu.addElement(sk);
        }
        for (i2 = 0; i2 < this.gemSkills.size(); ++i2) {
            sk = (SkillData)this.gemSkills.elementAt(i2);
            if (sk.mpUsed <= 0 && sk.spUsed <= 0) continue;
            this.skillsMenu.addElement(sk);
        }
        return true;
    }

    public boolean addSkill(SkillData skill) {
        for (int i2 = 0; i2 < this.skills.size(); ++i2) {
            SkillData sk = (SkillData)this.skills.elementAt(i2);
            if (sk.sortID < skill.sortID && sk.contrastType == skill.contrastType) {
                this.removeSkill(sk);
                continue;
            }
            if (sk.contrastType != skill.contrastType) continue;
            return false;
        }
        int sing = 0;
        for (int i3 = 0; i3 < this.skills.size(); ++i3) {
            SkillData sk = (SkillData)this.skills.elementAt(i3);
            if (skill.sortID < sk.sortID) {
                sing = i3;
                break;
            }
            sing = -1;
        }
        if (sing != -1) {
            this.skills.insertElementAt(skill, sing);
        } else {
            this.skills.addElement(skill);
        }
        return true;
    }

    public boolean addSkill(SkillData skill, int place) {
        for (int i2 = 0; i2 < this.skills.size(); ++i2) {
            SkillData sk = (SkillData)this.skills.elementAt(i2);
            if (sk.sortID != skill.sortID) continue;
            return false;
        }
        this.skills.insertElementAt(skill, place);
        this.setMenuShowSkill();
        return true;
    }

    public SkillData removeSkill(SkillData skill) {
        for (int i2 = 0; i2 < this.skills.size(); ++i2) {
            SkillData sk = (SkillData)this.skills.elementAt(i2);
            if (sk.sortID != skill.sortID) continue;
            this.skills.removeElementAt(i2);
            return sk;
        }
        return null;
    }

    public int getSkillPlace(SkillData skill) {
        for (int i2 = 0; i2 < this.skills.size(); ++i2) {
            SkillData sk = (SkillData)this.skills.elementAt(i2);
            if (sk.sortID != skill.sortID) continue;
            return i2;
        }
        return 0;
    }

    public boolean act(byte act) {
        if (this.actID == act) {
            return false;
        }
        if (this.bActFinished) {
            this.actID = act;
            this.curFrameIndex = 0;
            this.bActFinished = this.actID == 0 || this.actID == 1;
            this.curActionLoopTotalTime = -1;
            this.updateFrameCurData();
            return true;
        }
        return false;
    }

    public void setDir(byte dir) {
        if (dir < 0) {
            return;
        }
        this.curDir = dir;
        this.setSwordPos(false);
    }

    public void showSword(boolean bShow) {
        if (!this.bShowSword && bShow) {
            this.setSwordPos(true);
        }
        this.bShowSword = bShow;
    }

    public void setSwordPos(boolean bSet) {
        this.swordNextPosIndex = this.curDir == 0 || this.curDir == 2 ? 0 : 6;
        if (bSet) {
            this.swordCurPosIndex = this.swordNextPosIndex;
        }
    }

    public void updateFrameCurData() {
        if (this.actionSet == null) {
            return;
        }
        this.curAction = this.actionSet.actionDatas[(this.actID << 2) + this.curDir];
        this.curFrame = this.actionSet.frameDatas[this.curAction.frameID[this.curFrameIndex]];
        this.curVy = this.curAction.vY[this.curFrameIndex];
        this.curVx = this.bMirror ? -this.curAction.vX[this.curFrameIndex] : this.curAction.vX[this.curFrameIndex];
    }

    public void processNextAction() {
        ++this.curFrameIndex;
        if (this.curFrameIndex >= this.curAction.frameNum) {
            if (this.curActionLoopTotalTime == 0) {
                this.curFrameIndex = 0;
            } else if (this.curActionLoopTotalTime > 0) {
                ++this.curActionLoopTime;
                if (this.curActionLoopTime < this.curActionLoopTotalTime) {
                    this.curFrameIndex = 0;
                } else {
                    this.initAct();
                }
            } else if (this.actID == 0 || this.actID == 1) {
                this.curFrameIndex = 0;
            }
        }
    }

    public void cycleActionCurData() {
        if (this.curFrameIndex >= this.curAction.frameNum) {
            this.initAct();
        } else {
            this.updateFrameCurData();
        }
    }

    public void cycleAction() {
        this.cycleActionCurData();
        if (this.swordCurPosIndex != this.swordNextPosIndex) {
            ++this.swordCurPosIndex;
            this.swordCurPosIndex %= SWORD_D_Xs.length;
        }
        this.bSwordFront = this.swordCurPosIndex >= 6;
    }

    public void drawSword(Graphics g2, int drawX, int drawY) {
        if (!this.bShowSword) {
            return;
        }
        int sx = SWORD_D_Xs[this.swordCurPosIndex] * 7;
        int sy = SWORD_D_Ys[this.swordCurPosIndex] * 2;
        sy += Tool.WAVE_POS[(Tool.countTimes >> 1) % Tool.WAVE_POS.length];
    }

    public void drawBack(Graphics g2, int drawX, int drawY) {
        if (this.bDisappear) {
            return;
        }
    }

    public void drawFront(Graphics g2, int drawX, int drawY) {
        if (this.bDisappear) {
            return;
        }
        if (this.bShowLevelUp) {
            // empty if block
        }
    }

    public String getInfo() {
        String info = "LV " + this.level;
        info = info + "\n\u751f\u547d " + this.hp + "/" + this.hpMax;
        info = info + "\n\u9b54\u6cd5 " + this.mp + "/" + this.mpMax;
        return info;
    }

    public void setLevel(int lev) {
        int bfLevel = this.level;
        this.level = lev;
        if (this.level == 1) {
            this.curExp = 0;
            this.nextExp = this.level * this.level + 3;
        } else {
            for (int i2 = 1; i2 <= this.level - bfLevel; ++i2) {
                int upLevel = bfLevel + i2;
                int percent = this.getPerCent(upLevel);
                this.refreshGrowUp(upLevel);
                this.curExp -= this.nextExp;
                this.nextExp = upLevel * upLevel + percent;
            }
        }
        int n2 = this.curExp = this.curExp > 0 ? this.curExp : 0;
        if (this.level > 99) {
            this.level = 99;
            this.curExp = 0;
            this.nextExp = 100;
        }
        this.refreshNature();
    }

    public void addLevel(int lv, boolean bShowLv) {
        this.setLevel(this.level + lv);
        if (bShowLv) {
            this.showLevelUp();
        }
    }

    public void showLevelUp() {
        this.bShowLevelUp = true;
        this.showLevelUpTime = 0;
    }

    public void addHp(int value) {
        this.hp += value;
        if (this.hp > this.hpMaxFinal) {
            this.hp = this.hpMaxFinal;
        }
    }

    public void addMp(int value) {
        this.mp += value;
        if (this.mp > this.mpMaxFinal) {
            this.mp = this.mpMaxFinal;
        }
    }

    public void addSp(int value) {
    }

    public void addExp(int exp) {
        this.curExp += exp;
    }

    public int[] leveUpNature(int lv) {
        int[] nature = new int[4];
        nature[0] = this.hpMax + (lv + this.data.hpGrowUp) - lv / 2;
        nature[1] = this.mpMax + (lv + this.data.mpGrowUp) - lv / 2;
        int upAtt = 1 + lv / this.data.attackGrowUp + 20;
        nature[2] = this.attack + upAtt;
        int upDef = 1 + lv / this.data.defendGrowUp + 10;
        nature[3] = this.def + upDef;
        return nature;
    }

    public void refreshGrowUp(int lv) {
        this.hp = this.hpMax = this.hpMax + (lv + this.data.hpGrowUp) - lv / 2;
        this.mp = this.mpMax = this.mpMax + (lv + this.data.mpGrowUp) - lv / 2;
        int upAtt = 1 + lv / this.data.attackGrowUp + 20;
        this.attack += upAtt;
        this.attackMax += upAtt;
        int upDef = 1 + lv / this.data.defendGrowUp + 10;
        this.def += upDef;
    }

    public boolean bLevelUp() {
        return this.curExp >= this.nextExp;
    }

    public int getLevelNum() {
        int nExp = this.nextExp;
        int lv = this.level;
        int i2 = 0;
        for (int exp = this.curExp; exp >= nExp; exp -= nExp) {
            ++i2;
            int percent = this.getPerCent(++lv);
            nExp = lv * lv + percent;
        }
        return i2;
    }

    private int getPerCent(int level) {
        int per = 0;
        per = level <= 9 ? 3 : (level >= 10 && level < 30 ? 30 : (level >= 30 && level < 50 ? 300 : (level >= 50 && level < 70 ? 3000 : 7000)));
        return per;
    }

    public void refreshNature() {
        int[] nature = new int[11];
        for (int i2 = 0; i2 < this.equips.length; ++i2) {
            if (this.equips[i2] == null) continue;
            int[] stoneNature = this.equips[i2].getStoneNature();
            nature[0] = nature[0] + (this.equips[i2].data.hpMax + stoneNature[2]);
            nature[1] = nature[1] + (this.equips[i2].data.mpMax + stoneNature[3]);
            nature[2] = nature[2] + this.equips[i2].data.doubleHurt;
            nature[3] = nature[3] + this.equips[i2].data.attackMin;
            nature[4] = nature[4] + (this.equips[i2].data.attackMax + stoneNature[0]);
            nature[5] = nature[5] + (this.equips[i2].data.defend + stoneNature[1]);
            nature[6] = nature[6] + this.equips[i2].data.miss;
            nature[7] = nature[7] + this.equips[i2].data.swim;
            nature[8] = nature[8] + this.equips[i2].data.poison;
            nature[9] = nature[9] + this.equips[i2].data.onceKill;
            nature[10] = nature[10] + this.equips[i2].data.agile;
        }
        this.refreshSuit();
        this.hpMaxFinal = this.hpMax + nature[0] + this.toplimitHp + this.TalentHpMax + this.suitHp;
        this.mpMaxFinal = this.mpMax + nature[1] + this.toplimitMp + this.TalentMpMax + this.suitMp;
        this.critFinal = this.crit + nature[2] + this.TalentCrit + this.toplimitCrit + this.suitCrit;
        this.attackFinal = this.attack + nature[3] + this.toplimitAtt + this.TalentAttack + this.suitAtt;
        this.attackMaxFinal = this.attackMax + nature[4] + this.toplimitAtt + this.TalentAttack + this.suitAttMax;
        this.defFinal = this.def + nature[5] + this.toplimitDef + this.TalentDefend + this.suitDef;
        this.missFinal = this.miss + nature[6] + this.toplimitMiss + this.TalentMiss + this.suitMiss;
        this.swimFinal = this.swim + nature[7];
        this.poisonFinal = this.poison + nature[8];
        this.onceKillFinal = this.onceKill + nature[9];
        this.agileFinal = (byte)(this.agile + nature[10] + this.suitAgile);
        this.upDataLimits();
        this.refreshGemSkills();
    }

    public void upDataLimits() {
        if (this.hpMaxFinal > 99999) {
            this.hpMaxFinal = 99999;
        }
        if (this.mpMaxFinal > 99999) {
            this.mpMaxFinal = 99999;
        }
        if (this.critFinal > 9999) {
            this.critFinal = 9999;
        }
        if (this.attackFinal > 9999) {
            this.attackFinal = 9999;
        }
        if (this.attackMaxFinal > 9999) {
            this.attackMaxFinal = 9999;
        }
        if (this.defFinal > 9999) {
            this.defFinal = 9999;
        }
        if (this.missFinal > 100) {
            this.missFinal = 100;
        }
        if (this.swimFinal > 100) {
            this.swimFinal = 100;
        }
        if (this.poisonFinal > 100) {
            this.poisonFinal = 100;
        }
        if (this.onceKillFinal > 100) {
            this.onceKillFinal = 100;
        }
        if (this.hp > this.hpMaxFinal) {
            this.hp = this.hpMaxFinal;
        }
        if (this.mp > this.mpMaxFinal) {
            this.mp = this.mpMaxFinal;
        }
    }

    public void refreshSuit() {
        int[] suitID = new int[this.equips.length];
        int[] num = new int[this.equips.length];
        int[] type = new int[this.equips.length];
        for (int i2 = 0; i2 < this.equips.length; ++i2) {
            suitID[i2] = this.equips[i2] != null ? (int)this.equips[i2].data.suitType : -1;
            num[i2] = 0;
            type[i2] = -1;
        }
        int index = 0;
        int counter = 0;
        do {
            int i3;
            int tp = 0;
            for (i3 = 0; i3 < suitID.length; ++i3) {
                if (suitID[i3] == -1) continue;
                tp = suitID[i3];
                break;
            }
            for (i3 = 0; i3 < suitID.length; ++i3) {
                if (tp != suitID[i3]) continue;
                type[index] = suitID[i3];
                int n2 = index;
                num[n2] = num[n2] + 1;
                suitID[i3] = -1;
            }
            for (i3 = 0; i3 < suitID.length; ++i3) {
                if (suitID[i3] != -1) continue;
                ++counter;
            }
            ++index;
        } while (counter < suitID.length);
        for (int i4 = 0; i4 < type.length; ++i4) {
            if (type[i4] == -1) continue;
            for (int j2 = 0; j2 < Game.suitDatas.length; ++j2) {
                if (type[i4] != Game.suitDatas[j2].type || num[i4] != Game.suitDatas[j2].num) continue;
                this.suitHp = Game.suitDatas[j2].hpMax;
                this.suitMp = Game.suitDatas[j2].mpMax;
                this.suitAtt = Game.suitDatas[j2].attack;
                this.suitAttMax = Game.suitDatas[j2].attackMax;
                this.suitDef = Game.suitDatas[j2].defend;
                this.suitMiss = Game.suitDatas[j2].miss;
                this.suitCrit = Game.suitDatas[j2].doubleHurt;
                this.suitAgile = Game.suitDatas[j2].agile;
            }
        }
    }

    public int getSuitNum(EquipData data) {
        if (data == null) {
            return 0;
        }
        int num = 0;
        for (int i2 = 0; i2 < this.equips.length; ++i2) {
            if (this.equips[i2] == null || this.equips[i2].data.suitType != data.suitType) continue;
            ++num;
        }
        return num;
    }

    public void skillCure(SkillData data) {
        this.hp += data.addHpValue;
        this.hp += data.addHpRate * this.hpMaxFinal / 100;
        if (this.hp > this.hpMaxFinal) {
            this.hp = this.hpMaxFinal;
        }
    }

    public boolean itemUseToMe(Item item) {
        int hp = item.data.addHpValue + item.data.addHpRate * this.hpMaxFinal / 100;
        int mp = item.data.addMpValue + item.data.addMpRate * this.mpMaxFinal / 100;
        short sp = item.data.addsp;
        this.addHp(hp);
        this.addMp(mp);
        this.addSp(sp);
        this.toplimitHp += item.data.addHpMax;
        this.toplimitMp += item.data.addMpMax;
        this.toplimitAtt += item.data.addAttack;
        this.toplimitDef += item.data.addDefend;
        this.toplimitCrit += item.data.addCrit;
        this.toplimitMiss += item.data.addMiss;
        return Game.bag.addItem(item.data, -1) > 0;
    }

    public void changeEquip(int eqIndex, Equip eq) {
        if (eqIndex < 0 && eqIndex >= 5) {
            return;
        }
        if (this.equips[eqIndex] != null) {
            Game.bag.addEquip(this.equips[eqIndex], 1);
        }
        if (eq != null) {
            if (eq.data.type == this.equipTypes[eqIndex]) {
                this.equips[eqIndex] = eq;
                Game.bag.addEquip(eq, -1);
            }
        } else {
            this.equips[eqIndex] = null;
        }
        this.refreshNature();
    }

    public boolean IsCanAddSkill(int skillId) {
        for (int i2 = 0; i2 < this.gemSkills.size(); ++i2) {
            SkillData sk = (SkillData)this.gemSkills.elementAt(i2);
            if (skillId != sk.sortID) continue;
            return false;
        }
        return true;
    }

    public void refreshGemSkills() {
        this.gemSkills.removeAllElements();
        for (int i2 = 0; i2 < this.equips.length; ++i2) {
            if (this.equips[i2] == null || this.equips[i2].skillID < 0 || !this.IsCanAddSkill(this.equips[i2].skillID)) continue;
            SkillData sk = Game.getSkillData(this.equips[i2].skillID);
            this.gemSkills.addElement(sk);
        }
    }

    public int getEquip(EquipData equipData) {
        int equipNum = 0;
        for (int i2 = 0; i2 < this.equips.length; ++i2) {
            if (this.equips[i2] == null || this.equips[i2].data.sortID != equipData.sortID) continue;
            ++equipNum;
        }
        return equipNum;
    }

    public void removeEquip(EquipData data) {
        if (data == null) {
            return;
        }
        for (int i2 = 0; i2 < 5; ++i2) {
            if (this.equips[i2] == null || this.equips[i2].data.sortID != data.sortID) continue;
            this.equips[i2] = null;
            Game.bag.addEquip(new Equip(data), 1);
        }
        this.refreshNature();
    }

    public boolean getPartEquip(int partID) {
        return this.equips[partID] != null;
    }

    public static void changePet(int raeIndex) {
        if (raeIndex < 0) {
            pet = null;
            Game.mapPet = null;
            Game.instance.deletMapPet();
        } else {
            pet = (Pet)Game.bagFire.elementAt(raeIndex);
            Pet.setMapPet(raeIndex);
        }
    }

    public static boolean bRareEquip() {
        return pet != null;
    }

    public void fullStatus() {
        this.hp = this.hpMaxFinal;
        this.mp = this.mpMaxFinal;
    }

    public int getFinalLv() {
        return this.level;
    }

    public int getFinalHp() {
        return this.hpMaxFinal;
    }

    public int getFinalMp() {
        return this.mpMaxFinal;
    }

    public int getFinalAtt() {
        return this.attackMaxFinal;
    }

    public int getFinalDef() {
        return this.defFinal;
    }

    public int getFinalCrit() {
        return this.critFinal;
    }

    public void TalentCount(int id) {
        this.TalentHpMax += Game.talentDatas[id].hpMax;
        this.TalentMpMax += Game.talentDatas[id].mpMax;
        this.TalentAttack += Game.talentDatas[id].attack;
        this.TalentDefend += Game.talentDatas[id].defend;
        this.TalentCrit += Game.talentDatas[id].crit;
        this.TalentMiss += Game.talentDatas[id].miss;
    }

    static {
        SWORD_D_Xs = new int[]{3, 2, 1, 0, -1, -2, -3, -2, -1, 0, 1, 2};
        SWORD_D_Ys = new int[]{0, -2, -3, -4, -3, -2, 0, 2, 3, 4, 3, 2};
    }
}

