/*
 * Decompiled with CFR 0.152.
 */
package com.game5a.client;

import com.game5a.common.Common;
import com.game5a.common.ScrollStyledText;
import com.game5a.common.XFont;
import com.tencent.mbox.MBoxClient;
import com.tencent.mbox.cp.InfoListener;
import com.tencent.mbox.cp.OppUserInfo;
import com.tencent.mbox.cp.PlayerInfo;
import com.tencent.mbox.cp.ResponseInfo;
import com.tencent.mbox.cp.UserInfo;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.midlet.MIDlet;

public class QQNetWork
implements InfoListener {
    public UserInfo userInfo;
    public OppUserInfo oppUserInfo;
    public PlayerInfo[] playerInfos;
    public static final int RANK_NUM = 10;
    public String[] rankScores = new String[10];
    public String[] rankNames = new String[10];
    public boolean bRequestNotified;
    public String[] infoStrs;
    public MBoxClient qqBox;
    public int width;
    public int height;
    public ScrollStyledText infoST;
    public int score;
    public boolean bScoreUploaded;
    public boolean bClosed;

    public QQNetWork(MIDlet app, Display display, Displayable dis, int gameID, int cpID) {
        this.qqBox = new MBoxClient(app, display, dis, this, Common.uiWidth, Common.uiHeight, -6, -7, gameID, cpID, "");
    }

    public void notify(int status, ResponseInfo obj) {
        this.bRequestNotified = true;
        int code = obj.getCode();
        String message = obj.getMessage();
        if (status == 12) {
            if (code == 0) {
                if (message == null) {
                    this.infoStrs = null;
                } else {
                    this.parseRankData(message);
                    this.infoStrs = Common.sysFont.getStringArray(message, Common.uiWidth - 20);
                }
            }
        } else if (status == 3 && code == 0) {
            this.infoStrs = message == null ? null : Common.sysFont.getStringArray(message, Common.uiWidth - 40);
        }
    }

    public void parseRankData(String scoreStr) {
        if (scoreStr == null) {
            return;
        }
        String[] list = XFont.getStringArray(scoreStr, "|#|");
        if (list == null) {
            this.rankScores = null;
            this.rankNames = null;
            return;
        }
        this.rankScores = new String[10];
        this.rankNames = new String[10];
        for (int i2 = 0; i2 < 10 && i2 < list.length; ++i2) {
            String[] data = XFont.getStringArray(list[i2], '|');
            this.rankScores[i2] = data[0];
            this.rankNames[i2] = data[1];
        }
    }

    public void startMBox(int pageId) {
        this.qqBox.startMBox(1, pageId);
    }

    public void requestData(int dataType) {
        this.bRequestNotified = false;
        this.qqBox.requestData(dataType);
    }

    public void gotoRank(int w2, int h2) {
        this.width = w2;
        this.height = h2;
        this.requestData(2005);
        this.bRequestNotified = false;
        this.bClosed = false;
    }

    public void rankHandleKey() {
        if (Common.isKeyPressed(10, true)) {
            this.bClosed = true;
        } else if (Common.isKeyPressed(9, true)) {
            this.startMBox(10);
        }
    }

    public void drawRank(Graphics g2, int x2, int y2) {
        g2.setClip(x2, y2, this.width, this.height);
        String str = "QQ\u793e\u533a";
        Common.sysFont.drawString(g2, str, x2, y2 + this.height - Common.sysFont.getHeight(), 0xFFFFFF, 0, (byte)1);
        str = "\u8fd4\u56de";
        Common.sysFont.drawString(g2, str, x2 + this.width - Common.sysFont.stringWidth(str), y2 + this.height - Common.sysFont.getHeight(), 0xFFFFFF, 0, (byte)1);
        if (this.bRequestNotified) {
            if (this.rankScores == null || this.rankNames == null) {
                str = "\u6ca1\u6709\u76f8\u5173\u6570\u636e\uff0c\u8bf7\u8fd4\u56de";
                Common.sysFont.drawString(g2, str, x2 + (this.width - Common.sysFont.stringWidth(str)) >> 1, y2 + (this.height - Common.sysFont.getHeight()) >> 1, 255, 0xFFFFFF, (byte)1);
            } else {
                str = "\u79ef\u5206\u699c\u5355";
                Common.sysFont.drawString(g2, str, x2 + (this.width - Common.sysFont.stringWidth(str)) >> 1, y2, 0xFFFF00, -1, (byte)1);
                String rankStr = "\u6392\u540d";
                String scoreStr = "\u79ef\u5206";
                String nameStr = "\u6635\u79f0";
                int dy = y2 + Common.sysFont.getHeight() + 5;
                int rankX = x2;
                int scoreX = rankX + Common.sysFont.stringWidth(rankStr) + 15;
                int nameX = scoreX + Common.sysFont.stringWidth(scoreStr) * 2;
                Common.sysFont.drawString(g2, rankStr, rankX, dy, 255, 0xFFFFFF, (byte)1);
                Common.sysFont.drawString(g2, scoreStr, scoreX, dy, 255, 0xFFFFFF, (byte)1);
                Common.sysFont.drawString(g2, nameStr, nameX, dy, 255, 0xFFFFFF, (byte)1);
                dy += Common.sysFont.getHeight() + 5;
                for (int i2 = 0; i2 < 10 && this.rankScores[i2] != null && this.rankNames[i2] != null; ++i2) {
                    Common.sysFont.drawString(g2, String.valueOf(i2 + 1), rankX, dy, 0xFFFFFF, 0, (byte)1);
                    Common.sysFont.drawString(g2, this.rankScores[i2], scoreX, dy, 0xFFFFFF, 0, (byte)1);
                    Common.sysFont.drawString(g2, this.rankNames[i2], nameX, dy, 0xFFFFFF, 0, (byte)1);
                    dy += Common.sysFont.getHeight();
                }
            }
        } else {
            str = "\u6b63\u5728\u8bfb\u53d6\uff0c\u8bf7\u7a0d\u5019";
            Common.sysFont.drawString(g2, str, x2 + (this.width - Common.sysFont.stringWidth(str)) >> 1, y2 + (this.height - Common.sysFont.getHeight()) >> 1, 255, 0xFFFFFF, (byte)1);
        }
    }

    public void gotoUploadScore(int value, String content, int w2, int h2) {
        this.score = value;
        String scoreContent = content + "\n\u60a8\u53ef\u4ee5\u514d\u8d39\u4e0a\u4f20QQ\u6e38\u620f\u79ef\u5206\uff08\u4e0d\u542b\u901a\u8bdd\u8d39\uff09\uff0c\u53c2\u4e0e\u6392\u540d\u3002\u4e0e\u672c\u6e38\u620f\u7684\u5176\u4ed6\u73a9\u5bb6\u548cQQ\u597d\u53cb\u8fdb\u884c\u6311\u6218\uff0c\u8fd8\u6709\u673a\u4f1a\u8d62\u5f97\u6e38\u620f\u5956\u52b1\uff01\u8fdb\u5165\u6e38\u620f\u8bba\u575b\u67e5\u770b\u66f4\u591a\u8be6\u7ec6PK\u6218\u51b5\uff01";
        this.width = w2;
        this.height = h2;
        this.infoST = new ScrollStyledText(scoreContent, this.width, Common.sysFont, null, 1);
        this.infoST.setScrollParam(this.height - Common.sysFont.getHeight() - 5, Common.sysFont.getHeight(), 2);
        this.bScoreUploaded = false;
        this.bRequestNotified = false;
        this.bClosed = false;
    }

    public void uploadScore() {
        this.bScoreUploaded = true;
        this.qqBox.uploadUserData(this.score, "", 0, 0, "", "", "1:\u5bcc\u7532\u5929\u4e0b");
    }

    public void uploadScoreHandleKey() {
        if (Common.isKeyPressed(10, true)) {
            this.bClosed = true;
        } else if (Common.isKeyPressed(9, true)) {
            if (this.bScoreUploaded) {
                this.startMBox(10);
            } else {
                this.uploadScore();
            }
        }
    }

    public void drawUploadScore(Graphics g2, int x2, int y2) {
        if (this.bScoreUploaded) {
            if (this.bRequestNotified && this.infoStrs != null) {
                int infoDY = y2 + (this.height - Common.sysFont.getHeight() * this.infoStrs.length) >> 1;
                for (int i2 = 0; i2 < this.infoStrs.length; ++i2) {
                    Common.sysFont.drawString(g2, this.infoStrs[i2], x2 + (this.width - Common.sysFont.stringWidth(this.infoStrs[i2])) >> 1, infoDY + Common.sysFont.getHeight() * i2, 0xFFFFFF, 0, (byte)1);
                }
            } else {
                String str = "\u662f\u5426\u8fd4\u56de\u6e38\u620f\uff1f";
                Common.sysFont.drawString(g2, str, x2 + (this.width - Common.sysFont.stringWidth(str)) >> 1, y2 + (this.height - Common.sysFont.getHeight()) >> 1, 0xFFFFFF, 0, (byte)1);
            }
            Common.setUIClip(g2);
            String str = "QQ\u793e\u533a";
            Common.sysFont.drawString(g2, str, x2, y2 + this.height - Common.sysFont.getHeight(), 0xFFFFFF, 0, (byte)1);
            str = "\u8fd4\u56de";
            Common.sysFont.drawString(g2, str, x2 + this.width - Common.sysFont.stringWidth(str), y2 + this.height - Common.sysFont.getHeight(), 0xFFFFFF, 0, (byte)1);
        } else {
            if (this.infoST != null) {
                this.infoST.draw(g2, x2, y2);
                this.infoST.cycle();
            }
            Common.setUIClip(g2);
            String str = "\u514d\u8d39\u4e0a\u4f20";
            Common.sysFont.drawString(g2, str, x2, y2 + this.height - Common.sysFont.getHeight(), 0xFFFFFF, 0, (byte)1);
            str = "\u53d6\u6d88";
            Common.sysFont.drawString(g2, str, x2 + this.width - Common.sysFont.stringWidth(str), y2 + this.height - Common.sysFont.getHeight(), 0xFFFFFF, 0, (byte)1);
        }
    }
}

