/*
 * Decompiled with CFR 0.152.
 */
package com.game5a.client;

import com.game5a.action.ActionData;
import com.game5a.action.ActionSet;
import com.game5a.action.FrameData;
import com.game5a.client.MapElement;
import com.game5a.client.MapSprite;
import com.game5a.client.data.SkillData;
import com.game5a.common.Rectangle;
import javax.microedition.lcdui.Graphics;

public class Particle
extends MapElement {
    public ActionSet actionSet;
    public ActionData actionData;
    public FrameData curFrame;
    public int curFrameIndex;
    public int Vx;
    public int Vy;
    public int life;
    public int aliveTimes;
    public MapSprite owner;
    public SkillData skill;
    public boolean isBottomLayer;
    int[] args;
    public int particleType;
    public static final int PARTICLE_TYPE_WAVE = 1;
    public static final int PARTICLE_TYPE_ROLLING = 2;

    public Particle() {
        this.type = (byte)5;
    }

    public Particle(ActionSet set, int actid, int mx, int my, int vx, int vy, MapSprite fs) {
        this.type = (byte)5;
        this.actionSet = set;
        this.actionData = this.actionSet.actionDatas[actid];
        this.mapX = mx;
        this.mapY = my;
        this.Vx = vx;
        this.Vy = vy;
        this.owner = fs;
        this.bMirror = this.owner.bMirror;
    }

    public Particle(ActionSet set, int actid, int mx, int my, int vx, int vy) {
        this.type = (byte)5;
        this.actionSet = set;
        this.actionData = this.actionSet.actionDatas[actid];
        this.mapX = mx;
        this.mapY = my;
        this.Vx = vx;
        this.Vy = vy;
    }

    public Particle(ActionSet set, int actid, int mx, int my, int vx, int vy, MapSprite fs, boolean bm) {
        this.type = (byte)5;
        this.actionSet = set;
        this.actionData = this.actionSet.actionDatas[actid];
        this.mapX = mx;
        this.mapY = my;
        this.Vx = vx;
        this.Vy = vy;
        this.owner = fs;
        this.bMirror = bm;
    }

    public Particle(ActionSet set, int actid, int mx, int my, int vx, int vy, boolean isBottomLayer, MapSprite fs) {
        this(set, actid, mx, my, vx, vy, fs);
        this.isBottomLayer = isBottomLayer;
    }

    public Particle(ActionSet set, int actid, int mx, int my, int vx, int vy, MapSprite fs, int particleType) {
        this(set, actid, mx, my, vx, vy, fs);
        this.particleType = particleType;
    }

    public void setArgs(int particleType, int[] args) {
        this.args = args;
        this.particleType = particleType;
    }

    public void setLife(int lf) {
        this.life = lf;
    }

    public void cycle() {
        if (this.life > 0) {
            ++this.aliveTimes;
            if (this.aliveTimes > this.life) {
                this.bDisappear = true;
            }
            if (this.curFrameIndex >= this.actionData.frameNum) {
                this.curFrameIndex = 0;
            }
            this.curFrame = this.actionSet.frameDatas[this.actionData.frameID[this.curFrameIndex]];
        } else if (this.curFrameIndex >= this.actionData.frameNum) {
            this.bDisappear = true;
        } else {
            this.curFrame = this.actionSet.frameDatas[this.actionData.frameID[this.curFrameIndex]];
        }
        ++this.curFrameIndex;
        switch (this.particleType) {
            case 1: {
                this.mapX += this.Vx;
                this.mapY += this.Vy;
                if (this.args[0] > 0) {
                    this.Vy -= this.args[1];
                    if (this.Vy > -this.args[0]) break;
                    this.Vy = -this.args[0];
                    this.args[0] = -this.args[0];
                    break;
                }
                this.Vy += this.args[1];
                if (this.Vy < -this.args[0]) break;
                this.Vy = -this.args[0];
                this.args[0] = -this.args[0];
                break;
            }
            case 2: {
                int temDir = this.curFrameIndex % 8;
                int temR = this.args[2] + this.args[3] * this.curFrameIndex;
                if (this.curFrameIndex == 0) break;
                this.mapX = this.args[0] + this.getRX(temR, temDir);
                this.mapY = this.args[1] + this.getRY(temR, temDir);
                break;
            }
            default: {
                this.mapX += this.Vx;
                this.mapY += this.Vy;
            }
        }
    }

    private int getRX(int r2, int angleIndex) {
        switch (angleIndex) {
            case 0: {
                return r2;
            }
            case 1: 
            case 7: {
                return r2 * 1000 / 1414;
            }
            case 2: 
            case 6: {
                return 0;
            }
            case 3: 
            case 5: {
                return -r2 * 1000 / 1414;
            }
            case 4: {
                return -r2;
            }
        }
        return 0;
    }

    private int getRY(int r2, int angleIndex) {
        switch (angleIndex) {
            case 0: 
            case 4: {
                return 0;
            }
            case 1: 
            case 3: {
                return r2 * 1000 / 1414;
            }
            case 2: {
                return r2;
            }
            case 5: 
            case 7: {
                return -r2 * 1000 / 1414;
            }
            case 6: {
                return -r2;
            }
        }
        return 0;
    }

    public void draw(Graphics g2, int viewMapX, int viewMapY, int dx, int dy) {
        if (this.bDisappear) {
            return;
        }
        int drawX = this.mapX - viewMapX + dx;
        int drawY = this.mapY - viewMapY + dy;
        this.actionSet.drawFrame(g2, this.curFrame, drawX, drawY, this.bMirror);
    }

    public boolean isInScreen(int viewMapX, int viewMapY, int viewWidth, int viewHeight) {
        return true;
    }

    public Rectangle getAttackRect() {
        return this.actionSet.getAttackRect(this.curFrame, this.bMirror);
    }

    public boolean attack(MapSprite spr) {
        if (this.bDisappear) {
            return false;
        }
        if (this.curFrame == null) {
            return false;
        }
        return false;
    }
}

