/*
 * Decompiled with CFR 0.152.
 */
package com.game5a.client;

import com.game5a.action.ActionData;
import com.game5a.action.ActionSet;
import com.game5a.action.FrameData;
import com.game5a.client.Game;
import com.game5a.client.MapElement;
import com.game5a.client.data.NpcData;
import com.game5a.common.Common;
import com.game5a.common.Rectangle;
import com.game5a.common.Tool;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class MapSprite
extends MapElement {
    public static final byte ACT_STAND = 0;
    public static final byte ACT_WALK = 1;
    public byte actID;
    public static final byte ACT_STATE_NORMAL = 0;
    public static final byte ACT_STATE_ACTION = 1;
    public static final byte ACT_STATE_SAY = 2;
    public static final byte ACT_STATE_AUTOMOVE = 3;
    public static final byte ACT_STATE_AIM = 4;
    public byte actState;
    public NpcData data;
    public int sortID;
    public ActionSet actionSet;
    public ActionData curAction;
    public FrameData curFrame;
    public int curFrameIndex;
    public boolean bActFinished;
    public int curActionLoopTotalTime;
    public int curActionLoopTime;
    public int curVx;
    public int curVy;
    public static final int DOUQI_DX = 20;
    public static final int DOUQI_DY = 20;
    public static final int TALK_DX = 20;
    public static final int TALK_DY = 10;
    public static final int FIGHT_DX = 5;
    public static final int FIGHT_DY = 5;
    public static final int EYESHOT_DX = 40;
    public static final int EYESHOT_DY = 40;
    public int recodrdID;
    public int moveDistance;
    int initMapX;
    int initMapY;
    byte initDir;
    boolean bMoveBack;
    boolean bMoveStay;
    int moveStayTime;
    public static final int MOVE_STAY_TIME_MAX = 40;
    byte sayBakDir;
    boolean bSayTurnDir;
    boolean bSayKeepAct;
    public boolean bHasResInCache;
    public String script;
    public int DQ_ID;
    public static final byte FACE_SURPRISE = 0;
    public static final byte FACE_MAD = 1;
    public static final byte FACE_SHAMED = 2;
    public static final byte FACE_LOVELY = 3;
    public static final byte FACE_GLAD = 4;
    public static final byte FACE_SHY = 5;
    public static final byte FACE_SAD = 6;
    public static final byte FACE_ANGER = 7;
    public static final byte FACE_SPEECHLESS = 8;
    public static final byte FACE_QUERY = 9;
    byte faceID;
    boolean bShowFace;
    int showFaceTime;
    int showFaceTotalTime;
    String actionFile;
    String[] imageFiles;
    byte autoMoveType;
    public static final byte AUTO_MOVE_DES = 0;
    public static final byte AUTO_MOVE_TIME = 1;
    int autoMoveTotalTime;
    int autoMoveVx;
    int autoMoveVy;
    int autoMoveTime;
    int autoMoveToX;
    int autoMoveToY;
    int autoMoveFromX;
    int autoMoveFromY;
    public int curMoveX;
    public int curMoveY;
    public int nextDesTime;
    public int desTime;
    public int desPosX;
    public int desPosY;
    private MapSprite aimSpr;
    public boolean bAttackedByXiXing;
    public static final int PATROL_WIDTH = 40;
    public static final int PATROL_HEIGHT = 60;
    public Rectangle patrolRect;
    public boolean bMoveAble;

    public MapSprite() {
        this.initCountTime();
        this.type = 1;
        this.bMoveAble = true;
        this.bCheckMapBlock = true;
    }

    public MapSprite(int id, NpcData npcData, int mx, int my, byte dir) {
        this.initCountTime();
        this.ID = id;
        if (npcData.type == 20) {
            this.type = (byte)2;
        } else if (npcData.type == 30) {
            this.type = (byte)3;
        } else if (npcData.type == 40) {
            this.type = (byte)4;
        } else if (npcData.type == 60) {
            this.type = (byte)6;
        } else if (npcData.type == 70) {
            this.type = (byte)7;
        } else if (npcData.type == 80) {
            this.type = (byte)8;
        } else if (npcData.type == 90) {
            this.type = (byte)9;
        } else {
            this.type = 1;
            if (npcData.type == 10) {
                this.bSayTurnDir = true;
                this.bSayKeepAct = false;
            } else if (npcData.type == 11) {
                this.bSayTurnDir = false;
                this.bSayKeepAct = false;
            } else {
                this.bSayTurnDir = false;
                this.bSayKeepAct = true;
            }
        }
        this.loadRes(npcData);
        this.initMapX = this.mapX = mx;
        this.initMapY = this.mapY = my;
        this.initDir = dir;
        this.nextDesTime = 0;
        this.desTime = 0;
        this.setDir(dir);
        this.initAct();
        this.bMoveAble = true;
        this.bCheckMapBlock = true;
    }

    public void loadRes(NpcData sprData) {
        this.data = sprData;
        this.sortID = this.data.sortID;
        this.bBlock = this.data.blockType > 0;
        this.loadRes(this.data.actionFile, this.data.imageFiles);
    }

    public void loadRes(String actFile, String[] imgFiles) {
        if (this.sortID != 41 && this.sortID != 42) {
            this.imageFiles = new String[imgFiles.length];
            Image[] imgs = new Image[imgFiles.length];
            for (int i2 = 0; i2 < imgFiles.length; ++i2) {
                this.imageFiles[i2] = "/action/" + imgFiles[i2] + "" + Game.IMG_TYPE;
                imgs[i2] = Common.getImageFromCache(this.imageFiles[i2]);
            }
            this.actionFile = "/action/" + actFile + ".a2";
            if (Common.resCache.containsKey(this.actionFile)) {
                this.actionSet = (ActionSet)Common.resCache.get(this.actionFile);
                this.bHasResInCache = true;
            } else {
                this.actionSet = ActionSet.createActionSet(this.actionFile, imgs);
                Common.resCache.put(this.actionFile, this.actionSet);
                this.bHasResInCache = false;
            }
        } else {
            this.actionSet = this.sortID == 41 ? Game.instance.roleAs2 : Game.instance.roleAs3;
        }
        this.footWidth = this.actionSet.footWidth;
        this.footHeight = this.actionSet.footHeight;
    }

    public void freeRes() {
        if (this.imageFiles != null) {
            for (int i2 = 0; i2 < this.imageFiles.length; ++i2) {
                Common.resCache.remove(this.imageFiles[i2]);
            }
        }
        if (this.actionFile != null) {
            Common.resCache.remove(this.actionFile);
        }
        this.actionSet = null;
    }

    public void initAct() {
        this.actID = 0;
        this.actState = 0;
        this.curFrameIndex = 0;
        this.bActFinished = true;
        this.curVy = 0;
        this.curVx = 0;
        this.curActionLoopTotalTime = -1;
        this.clearFace();
        this.updateFrameCurData();
    }

    public boolean act(byte act) {
        if (this.actID == act) {
            return false;
        }
        if (this.bActFinished) {
            this.actID = act;
            this.curFrameIndex = 0;
            this.bActFinished = this.actID == 0 || this.actID == 1;
            this.curActionLoopTotalTime = -1;
            this.updateFrameCurData();
            return true;
        }
        return false;
    }

    public void act(byte act, boolean bStop) {
        if (bStop) {
            this.initAct();
        }
        this.act(act);
    }

    public void act(byte act, boolean bStop, int loopTime) {
        if (bStop) {
            this.initAct();
        }
        if (this.act(act)) {
            this.curActionLoopTotalTime = loopTime;
            this.curActionLoopTime = 0;
        }
    }

    public void updateFrameCurData() {
        if (this.actionSet == null) {
            return;
        }
        this.curAction = this.actionSet.actionDatas[(this.actID << 2) + this.curDir];
        this.curFrame = this.actionSet.frameDatas[this.curAction.frameID[this.curFrameIndex]];
        this.curVy = this.curAction.vY[this.curFrameIndex];
        this.curVx = this.bMirror ? -this.curAction.vX[this.curFrameIndex] : this.curAction.vX[this.curFrameIndex];
    }

    public void cycleActionCurData() {
        if (this.curFrameIndex >= this.curAction.frameNum) {
            this.initAct();
        } else {
            this.updateFrameCurData();
        }
    }

    public void processNextAction() {
        ++this.curFrameIndex;
        if (this.curFrameIndex >= this.curAction.frameNum) {
            if (this.curActionLoopTotalTime == 0) {
                this.curFrameIndex = 0;
            } else if (this.curActionLoopTotalTime > 0) {
                ++this.curActionLoopTime;
                if (this.curActionLoopTime < this.curActionLoopTotalTime) {
                    this.curFrameIndex = 0;
                } else {
                    this.initAct();
                }
            } else if (this.actID == 0 || this.actID == 1) {
                this.curFrameIndex = 0;
            }
        }
    }

    public void cycleAction() {
        this.cycleActionCurData();
    }

    public void move() {
        this.move(this.curVx, this.curVy);
    }

    public void move(int vx, int vy) {
        this.curMoveX = vx;
        this.curMoveY = vy;
        this.mapX += this.curMoveX;
        this.mapY += this.curMoveY;
    }

    public void setDir(byte dir) {
        if (this.curDir != dir) {
            this.curFrameIndex = 0;
        }
        this.curDir = dir;
    }

    public void setPos(int mx, int my) {
        this.mapX = mx;
        this.mapY = my;
    }

    public int getFootCenterX() {
        return this.mapX + (this.footWidth >> 1);
    }

    public int getFootCenterY() {
        return this.mapX + (this.footHeight >> 1);
    }

    public void processNpcDes() {
        if (this.moveDistance <= 0) {
            return;
        }
        if (this.actState != 0) {
            return;
        }
        if (this.bMoveStay) {
            ++this.moveStayTime;
            if (this.moveStayTime > 40) {
                this.moveStayTime = 0;
                this.bMoveStay = false;
                if (this.bMoveBack) {
                    this.setDir(MapSprite.getOpDir(this.initDir));
                } else {
                    this.setDir(this.initDir);
                }
            } else if (this.countTime % 10 == 0) {
                this.setDir((byte)Tool.getNextRnd(0, 4));
            }
            this.act((byte)0);
        } else {
            if (this.bMoveBack) {
                if (this.isAtInitPos()) {
                    this.bMoveStay = true;
                    this.bMoveBack = false;
                }
            } else if (this.isAtDesPos()) {
                this.bMoveStay = true;
                this.bMoveBack = true;
            }
            this.act((byte)1);
            this.move();
        }
    }

    public void setAim(MapSprite spr) {
        this.aimSpr = spr;
    }

    public void processEnemyDes() {
        if (this.moveDistance <= 0) {
            return;
        }
        if (this.actState != 0) {
            return;
        }
        ++this.desTime;
        if (this.desTime >= this.nextDesTime) {
            this.desTime = 0;
            this.nextDesTime = Tool.getNextRnd(10, 20);
            if (this.aimSpr == null) {
                this.desPosX = this.initMapX + Tool.getNextRnd(-this.moveDistance, this.moveDistance);
                this.desPosY = this.initMapY + Tool.getNextRnd(-this.moveDistance, this.moveDistance);
            } else {
                this.desPosX = this.aimSpr.mapX;
                this.desPosY = this.aimSpr.mapY;
            }
            int fcx = this.mapX;
            int fcy = this.mapY;
            if (fcx != this.desPosX || fcy != this.desPosY) {
                this.act((byte)1);
            } else {
                this.act((byte)0);
            }
            int rnd = Tool.getNextRnd(0, 100);
            if (rnd < 50) {
                if (Math.abs(this.desPosX - fcx) >= Math.abs(this.curVx)) {
                    if (this.desPosX > fcx) {
                        this.setDir((byte)3);
                    } else {
                        this.setDir((byte)2);
                    }
                } else if (Math.abs(this.desPosY - fcy) >= Math.abs(this.curVy)) {
                    if (this.desPosY > fcy) {
                        this.setDir((byte)1);
                    } else {
                        this.setDir((byte)0);
                    }
                }
            } else if (Math.abs(this.desPosY - fcy) >= Math.abs(this.curVy)) {
                if (this.desPosY > fcy) {
                    this.setDir((byte)1);
                } else {
                    this.setDir((byte)0);
                }
            } else if (Math.abs(this.desPosX - fcx) >= Math.abs(this.curVx)) {
                if (this.desPosX > fcx) {
                    this.setDir((byte)3);
                } else {
                    this.setDir((byte)2);
                }
            }
        } else if (Game.canSpriteMove(this)) {
            this.act((byte)1);
            this.move();
        } else {
            Game.spriteOffMove(this, 4);
        }
    }

    public void autoMove(int vx, int vy, int time) {
        this.autoMoveVx = vx;
        this.autoMoveVy = vy;
        this.autoMoveTotalTime = time;
        this.autoMoveTime = 0;
        this.autoMoveType = 1;
        this.actState = (byte)3;
    }

    public void autoMoveTo(int mx, int my, int time) {
        this.autoMoveFromX = this.mapX;
        this.autoMoveFromY = this.mapY;
        this.autoMoveToX = mx;
        this.autoMoveToY = my;
        this.autoMoveTotalTime = time;
        this.autoMoveTime = 0;
        this.autoMoveType = 0;
        this.actState = (byte)3;
    }

    public void processAutoMove() {
        if (this.actState != 3) {
            return;
        }
        ++this.autoMoveTime;
        if (this.autoMoveTime > this.autoMoveTotalTime) {
            this.act((byte)0);
            this.actState = 0;
        } else {
            this.act((byte)1);
            if (this.autoMoveType == 1) {
                this.move(this.autoMoveVx, this.autoMoveVy);
            } else if (this.autoMoveType == 0) {
                int nextX = this.autoMoveFromX + (this.autoMoveToX - this.autoMoveFromX) * this.autoMoveTime / this.autoMoveTotalTime;
                int nextY = this.autoMoveFromY + (this.autoMoveToY - this.autoMoveFromY) * this.autoMoveTime / this.autoMoveTotalTime;
                this.move(nextX - this.mapX, nextY - this.mapY);
            }
        }
    }

    public boolean isAtInitPos() {
        return this.curDir == 0 || this.curDir == 1 ? Math.abs(this.mapY - this.initMapY) < Math.abs(this.curMoveY) : Math.abs(this.mapX - this.initMapX) < Math.abs(this.curMoveX);
    }

    public boolean isAtDesPos() {
        return this.curDir == 0 || this.curDir == 1 ? Math.abs(this.mapY - this.initMapY) > this.moveDistance : Math.abs(this.mapX - this.initMapX) > this.moveDistance;
    }

    public void updatePatrolRect() {
        if (this.type != 4) {
            return;
        }
        if (this.patrolRect == null) {
            this.patrolRect = new Rectangle();
        }
        switch (this.curDir) {
            case 0: {
                this.patrolRect.x = this.footWidth - 40 >> 1;
                this.patrolRect.y = (this.footHeight >> 1) - 60;
                this.patrolRect.width = 40;
                this.patrolRect.height = 60;
                break;
            }
            case 1: {
                this.patrolRect.x = this.footWidth - 40 >> 1;
                this.patrolRect.y = this.footHeight >> 1;
                this.patrolRect.width = 40;
                this.patrolRect.height = 60;
                break;
            }
            case 2: {
                this.patrolRect.x = (this.footWidth >> 1) - 60;
                this.patrolRect.y = this.footHeight - 40 >> 1;
                this.patrolRect.width = 60;
                this.patrolRect.height = 40;
                break;
            }
            case 3: {
                this.patrolRect.x = this.footWidth >> 1;
                this.patrolRect.y = this.footHeight - 40 >> 1;
                this.patrolRect.width = 60;
                this.patrolRect.height = 40;
                break;
            }
        }
    }

    public boolean isSpriteInPatrol(MapSprite spr) {
        if (this.type != 4) {
            return false;
        }
        return Tool.isRectIntersected(this.mapX + this.patrolRect.x, this.mapY + this.patrolRect.y, this.patrolRect.width, this.patrolRect.height, spr.mapX, spr.mapY, spr.footWidth, spr.footHeight);
    }

    public void cycle() {
        ++this.countTime;
        if (this.bDisappear) {
            this.clearFace();
            return;
        }
        this.cycleAction();
        this.cycleFace();
        if (this.bMoveAble) {
            if (this.type == 3) {
                if (this.bAttackedByXiXing) {
                    this.processAutoMove();
                } else {
                    this.processEnemyDes();
                }
            } else {
                this.processAutoMove();
                this.processNpcDes();
            }
        }
        this.updatePatrolRect();
        this.processNextAction();
    }

    public void setFace(byte fid, int tm) {
        if (fid < 0 || tm < 0) {
            this.clearFace();
        } else {
            this.faceID = fid;
            this.showFaceTotalTime = tm == 0 ? tm : (int)Game.faceAs.actionDatas[this.faceID].frameNum;
            this.showFaceTime = 0;
            this.bShowFace = true;
        }
    }

    public void clearFace() {
        this.bShowFace = false;
    }

    public void cycleFace() {
        if (this.bShowFace) {
            if (this.showFaceTotalTime > 0 && this.showFaceTime >= this.showFaceTotalTime) {
                this.clearFace();
            }
            ++this.showFaceTime;
        }
    }

    public void drawFace(Graphics g2, int drawX, int drawY) {
        if (this.bDisappear) {
            return;
        }
        if (this.bShowFace) {
            Rectangle er = this.actionSet.getEdgeRect(this.curFrame, this.bMirror);
            int fdx = drawX + (this.actionSet.footWidth - Game.faceAs.footWidth) / 2;
            int fdy = drawY + er.y - 5;
            Game.faceAs.drawFrameCycle(g2, this.faceID, this.showFaceTime, fdx, fdy, false);
        }
    }

    public void drawAction(Graphics g2, int drawX, int drawY) {
        if (this.actionSet != null) {
            this.actionSet.drawFrame(g2, this.curFrame, drawX, drawY, this.bMirror);
        }
    }

    public int getDrawX(int viewMapX, int dx) {
        return this.mapX - viewMapX + dx;
    }

    public int getDrawY(int viewMapY, int dy) {
        return this.mapY - viewMapY + dy;
    }

    public void drawBack(Graphics g2, int drawX, int drawY) {
        if (this.type == 4 && (Tool.countTimes & 7) > 1) {
            Common.setUIClip(g2);
            Tool.fillAlphaRect(g2, -1996488705, drawX + this.patrolRect.x, drawY + this.patrolRect.y, this.patrolRect.width, this.patrolRect.height);
        }
    }

    public void drawFront(Graphics g2, int drawX, int drawY) {
        if (this.bAttackedByXiXing) {
            // empty if block
        }
    }

    public void draw(Graphics g2, int viewMapX, int viewMapY, int dx, int dy) {
        if (this.bDisappear) {
            return;
        }
        int drawX = this.mapX - viewMapX + dx;
        int drawY = this.mapY - viewMapY + dy;
        this.drawBack(g2, drawX, drawY);
        this.drawAction(g2, drawX, drawY);
        this.drawFace(g2, drawX, drawY);
        this.drawFront(g2, drawX, drawY);
    }

    public boolean isInScreen(int viewMapX, int viewMapY, int viewWidth, int viewHeight) {
        return Tool.isRectIntersected(this.mapX + this.curFrame.edgeRect.x, this.mapY + this.curFrame.edgeRect.y, this.curFrame.edgeRect.width, this.curFrame.edgeRect.height, viewMapX, viewMapY, viewWidth, viewHeight);
    }

    public boolean isInDouQiOf(MapSprite spr) {
        return Tool.isRectIntersected(this.mapX, this.mapY, this.footWidth, this.footHeight, spr.mapX, spr.mapY - 20, spr.footWidth, spr.footHeight + 40);
    }

    public boolean isInAnimalOf(MapSprite spr) {
        return Tool.isRectIntersected(this.mapX, this.mapY, this.footWidth, this.footHeight, spr.mapX, spr.mapY - 40, spr.footWidth + 20, spr.footHeight + 80);
    }

    public boolean isInTalkRangeOf(MapSprite spr) {
        return Tool.isRectIntersected(this.mapX, this.mapY, this.footWidth, this.footHeight, spr.mapX - 20, spr.mapY - 10, spr.footWidth + 40, spr.footHeight + 20);
    }

    public boolean isInFightRangeOf(MapSprite spr) {
        return Tool.isRectIntersected(this.mapX, this.mapY, this.footWidth, this.footHeight, spr.mapX - 5, spr.mapY - 5, spr.footWidth + 10, spr.footHeight + 10);
    }

    public boolean isInEyeshotOf(MapSprite spr) {
        return Tool.isRectIntersected(this.mapX, this.mapY, this.footWidth, this.footHeight, spr.mapX - 40, spr.mapY - 40, spr.footWidth + 80, spr.footHeight + 80);
    }

    public void faceTo(MapSprite spr) {
        int dy;
        int fcx = this.mapX + (this.footWidth >> 1);
        int fcy = this.mapY + (this.footHeight >> 1);
        int spx = spr.mapX + (spr.footWidth >> 1);
        int spy = spr.mapY + (spr.footHeight >> 1);
        int dx = Math.abs(fcx - spx);
        if (dx >= (dy = Math.abs(fcy - spy))) {
            if (fcx < spx) {
                this.setDir((byte)3);
            } else {
                this.setDir((byte)2);
            }
        } else if (fcy < spy) {
            this.setDir((byte)1);
        } else {
            this.setDir((byte)0);
        }
    }

    public void sayTo(MapSprite spr) {
        if (!this.bSayKeepAct) {
            if (this.bSayTurnDir) {
                if (this.actState != 2) {
                    this.sayBakDir = this.curDir;
                }
                this.faceTo(spr);
            }
            this.initAct();
        }
        this.actState = (byte)2;
    }

    public void sayFinished() {
        if (!this.bSayKeepAct) {
            this.initAct();
            if (this.bSayTurnDir) {
                this.setDir(this.sayBakDir);
            }
        }
        this.actState = 0;
    }
}

