/*
 * Decompiled with CFR 0.152.
 */
package com.game5a.client;

import com.game5a.common.Common;

public class GameRectPack {
    int packRow;
    int packRank;
    int focusRow;
    int focusRank;
    int focusIndex;
    int firstLine;
    int lastLine;
    int length;
    int rowSize;

    public GameRectPack(int size, int row, int rank) {
        this.packRow = row;
        this.packRank = rank;
        this.length = size;
        this.focusIndex = 0;
        this.rowSize = this.length / this.packRank;
    }

    public int getRow() {
        return this.packRow;
    }

    public int getRank() {
        return this.packRank;
    }

    public int getFocusIndex() {
        return this.focusIndex;
    }

    public int getFocusRow() {
        return this.focusRow;
    }

    public int getFocusRank() {
        return this.focusRank;
    }

    private void setFirstLine() {
        this.firstLine = this.focusRow - this.packRow;
        if (this.firstLine < 0) {
            this.firstLine = 0;
        }
    }

    private void setLastLine() {
        this.lastLine = this.focusRow < this.packRow ? this.packRow : this.focusRow;
    }

    public void upDataSize(int size) {
        this.length = size;
        this.rowSize = this.length / this.packRank;
        if (this.focusIndex >= this.length) {
            this.focusIndex = 0;
            if (this.focusIndex < 0) {
                this.focusIndex = 0;
            }
        }
    }

    public void cycle() {
        this.focusRow = this.focusIndex / this.packRank;
        this.focusRank = this.focusIndex % this.packRank;
        this.setFirstLine();
        this.setLastLine();
    }

    public void handleKey() {
        if (Common.isKeyPressed(0, true) || Common.isKeyPressed(13, true)) {
            this.focusIndex -= this.packRank;
            if (this.focusIndex < 0) {
                this.focusIndex = this.length - 1;
            }
        } else if (Common.isKeyPressed(1, true) || Common.isKeyPressed(19, true)) {
            this.focusIndex += this.packRank;
            int bfRow = (this.focusIndex - this.packRank) / this.packRank;
            if (bfRow < this.rowSize) {
                if (this.focusIndex > this.length - 1) {
                    this.focusIndex = this.length - 1;
                }
            } else if (this.focusIndex > this.length - 1) {
                this.focusIndex = 0;
            }
        } else if (Common.isKeyPressed(2, true) || Common.isKeyPressed(15, true)) {
            --this.focusIndex;
            int bfRow = (this.focusIndex + 1) / this.packRank;
            if (this.rowSize > this.focusRow) {
                if (bfRow > 0) {
                    if (this.focusIndex <= bfRow * this.packRank - 1) {
                        this.focusIndex = (bfRow + 1) * this.packRank - 1;
                    }
                } else if (this.focusIndex < 0) {
                    this.focusIndex = this.packRank - 1;
                }
            } else if (this.focusIndex <= bfRow * this.packRank - 1) {
                this.focusIndex = this.length - 1;
            }
        } else if (Common.isKeyPressed(3, true) || Common.isKeyPressed(17, true)) {
            ++this.focusIndex;
            int bfRow = (this.focusIndex - 1) / this.packRank;
            if (this.rowSize > this.focusRow) {
                if (bfRow > 0) {
                    if (this.focusIndex > (bfRow + 1) * this.packRank - 1) {
                        this.focusIndex = bfRow * this.packRank;
                    }
                } else if (this.focusIndex > this.packRank - 1) {
                    this.focusIndex = 0;
                }
            } else if (this.focusIndex > this.length - 1) {
                this.focusIndex = bfRow * this.packRank;
            }
        }
    }
}

