/*
 * Decompiled with CFR 0.152.
 */
package com.game5a.client;

import com.game5a.client.Game;
import com.game5a.client.data.EquipData;
import com.game5a.client.data.ItemData;

public class Equip {
    public EquipData data;
    public ItemData[] stone;
    public int skillID = -1;

    public Equip(EquipData dt) {
        this.data = dt;
        if (this.data.holeNum > 0) {
            this.stone = new ItemData[dt.holeNum];
        }
    }

    public boolean IsCanInlay() {
        if (this.stone == null || this.stone.length <= 0) {
            return false;
        }
        int index = 0;
        for (int i2 = 0; i2 < this.stone.length; ++i2) {
            if (this.stone[i2] != null) continue;
            ++index;
        }
        return index > 0;
    }

    public boolean IsCanInskill(ItemData it) {
        return this.skillID == -1;
    }

    public boolean inlayStone(ItemData it) {
        for (int i2 = 0; i2 < this.stone.length; ++i2) {
            if (this.stone[i2] != null) continue;
            this.stone[i2] = it;
            this.skillID = this.stone[i2].SkillID;
            return true;
        }
        return false;
    }

    public boolean demolish(int index) {
        if (this.stone.length > index) {
            this.stone[index] = null;
            return true;
        }
        return false;
    }

    public ItemData demolishPerfect(int index) {
        if (this.stone.length > index && this.stone[index] != null) {
            ItemData itdata = this.stone[index];
            this.stone[index] = null;
            return itdata;
        }
        return null;
    }

    public String toString() {
        return this.data.name;
    }

    public String[] getStoneNature_str() {
        String[] Nature = new String[this.data.holeNum];
        for (int i2 = 0; i2 < this.stone.length; ++i2) {
            Nature[i2] = "";
            if (this.stone[i2] != null) {
                ItemData it = this.stone[i2];
                if (it.addAttack > 0) {
                    int n2 = i2;
                    Nature[n2] = Nature[n2] + it.name + "\u63d0\u5347\u653b\u51fb" + it.addAttack + "\u70b9\n";
                }
                if (it.addDefend > 0) {
                    int n3 = i2;
                    Nature[n3] = Nature[n3] + it.name + "\u63d0\u5347\u9632\u5fa1" + it.addDefend + "\u70b9\n";
                }
                if (it.addHpMax > 0) {
                    int n4 = i2;
                    Nature[n4] = Nature[n4] + it.name + "\u63d0\u5347\u751f\u547d" + it.addHpMax + "\u70b9\n";
                }
                if (it.addMpMax > 0) {
                    int n5 = i2;
                    Nature[n5] = Nature[n5] + it.name + "\u63d0\u5347\u771f\u6c14" + it.addMpMax + "\u70b9\n";
                }
                if (it.SkillID < 0) continue;
                int n6 = i2;
                Nature[n6] = Nature[n6] + it.name + "\u9644\u52a0\u6280\u80fd " + Game.getSkillData((int)it.SkillID).name + "\n";
                continue;
            }
            Nature[i2] = "\u6ca1\u6709\u9576\u5d4c\u5b9d\u77f3\n";
        }
        return Nature;
    }

    public ItemData getStone(int index) {
        if (index > this.data.holeNum) {
            return null;
        }
        if (this.stone[index] != null) {
            return this.stone[index];
        }
        return null;
    }

    public String toDescribe() {
        return this.data.description;
    }

    public String toNature() {
        String nature = "";
        if (this.data.hpMax > 0) {
            nature = nature + "\n\u589e\u52a0" + this.data.hpMax + "\u70b9\u751f\u547d";
        }
        if (this.data.mpMax > 0) {
            nature = nature + "\n\u589e\u52a0" + this.data.mpMax + "\u70b9\u771f\u6c14";
        }
        if (this.data.attackMin > 0) {
            nature = nature + "\n\u653b\u51fb" + this.data.attackMax;
        }
        if (this.data.defend > 0) {
            nature = nature + "\n\u9632\u5fa1" + this.data.defend;
        }
        if (this.data.miss > 0) {
            nature = nature + "\n\u95ea\u907f" + this.data.miss;
        }
        if (this.data.doubleHurt > 0) {
            nature = nature + "\n\u66b4\u51fb" + this.data.doubleHurt;
        }
        if (this.data.swim > 0) {
            nature = nature + "\n\u7729\u6655" + this.data.swim;
        }
        if (this.data.poison > 0) {
            nature = nature + "\n\u4e2d\u6bd2" + this.data.poison;
        }
        if (this.data.sleep > 0) {
            nature = nature + "\n\u660f\u7761" + this.data.sleep;
        }
        if (this.data.onceKill > 0) {
            nature = nature + "\n\u79d2\u6740" + this.data.onceKill;
        }
        if (this.data.agile > 0) {
            nature = nature + "\n\u654f\u6377" + this.data.agile;
        }
        nature = nature.substring(1);
        return nature;
    }

    public String toStoneNature() {
        String nature = "";
        if (this.data.holeNum > 0) {
            String[] str = this.getStoneNature_str();
            for (int i2 = 0; i2 < str.length; ++i2) {
                nature = nature + "\n" + str[i2];
            }
        } else {
            nature = "\u6ca1\u6709\u9576\u5d4c\u5b9d\u77f3";
        }
        nature = nature.substring(1);
        return nature;
    }

    public int[] getStoneNature() {
        int[] Nature = new int[4];
        for (int j2 = 0; j2 < this.data.holeNum; ++j2) {
            if (this.stone[j2] == null) continue;
            ItemData it = this.stone[j2];
            if (it.addAttack > 0) {
                Nature[0] = Nature[0] + it.addAttack;
            }
            if (it.addDefend > 0) {
                Nature[1] = Nature[1] + it.addDefend;
            }
            if (it.addHpMax > 0) {
                Nature[2] = Nature[2] + it.addHpMax;
            }
            if (it.addMpMax <= 0) continue;
            Nature[3] = Nature[3] + it.addMpMax;
        }
        return Nature;
    }

    public String GetString() {
        String str = "";
        if (this.data.holeNum > 0) {
            String[] str1 = this.getStoneNature_str();
            for (int i2 = 0; i2 < this.data.holeNum; ++i2) {
                str = str + str1[i2];
            }
        }
        return str;
    }

    public boolean IsDemolish() {
        if (this.stone == null || this.stone.length <= 0) {
            return false;
        }
        int index = 0;
        for (int i2 = 0; i2 < this.stone.length; ++i2) {
            if (this.stone[i2] == null) continue;
            ++index;
        }
        return index > 0;
    }
}

