/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public final class GameMap {
    static int screenWidth;
    static int screenHeight;
    static byte tileWidth;
    static byte tileHight;
    static int[] mapSize;
    static int setOffX;
    static int setOffY;
    static GameEngine engine;
    public static final short L_TILE = 20;
    public static final short L_ROLESD = 30;
    public static final short L_LEV = 31;
    public static final short L_HIGH = 2000;
    public static final short L_TALK = 5000;
    public static final short L_MAX = 9000;
    public static final short L_BBG = 10;
    public static final short L_OVERBBG = 20;
    public static final short L_BFLASH = 350;
    public static final short L_EFF = 40;
    public static final short L_LOOK = 3000;
    short mapID;
    short mapName;
    short fileName;
    static short BGM;
    short enemys;
    static short battleBg;
    short openEffect;
    short closeEffect;
    static short weather;
    public static final byte ITEM_TYPE = 0;
    public static final byte ITEM_X = 1;
    public static final byte ITEM_Y = 2;
    public static final byte ITEM_TR = 3;
    public static final byte OBJ_ID = 0;
    public static final byte OBJ_IMG = 1;
    public static final byte OBJ_ADDX = 2;
    public static final byte OBJ_ADDY = 3;
    public static final byte OBJ_W = 4;
    public static final byte OBJ_H = 5;
    public static final byte OBJ_DL = 6;
    short[][] objData = new short[][]{{-1, 60, -16, 0, 48, 32, 0}, {1, 61, -16, 0, 48, 32, 0}, {2, 72, -16, 0, 48, 32, 0}, {3, 83, 0, 0, 48, 32, 0}, {4, 91, 0, 0, 48, 48, 0}, {5, 93, 0, 0, 32, 64, 0}, {6, 99, 0, 0, 32, 16, 0}, {7, 99, 0, 0, 32, 16, 0}, {8, 99, 0, 0, 32, 16, 0}, {9, 102, 0, 0, 16, 16, 0}, {10, 62, 0, 0, 0, 0, 1}, {11, 63, 0, 0, 0, 0, 1}, {12, 64, 0, 0, 0, 0, 1}, {13, 65, 0, 0, 0, 0, 1}, {14, 66, 0, 0, 0, 0, 1}, {15, 67, 0, 0, 0, 0, 1}, {16, 68, 0, 0, 0, 0, 1}, {17, 69, 0, 0, 32, 64, 1}, {18, 70, 0, 0, 32, 64, 1}, {19, 71, 0, 0, 32, 64, 1}, {20, 73, 0, 0, 32, 64, 1}, {21, 74, 0, 0, 16, 48, -1}, {22, 75, 0, 0, 0, 0, 0}, {23, 76, 0, 0, 0, 0, 0}, {24, 77, 0, 0, 0, 0, 0}, {25, 78, 0, 0, 32, 16, 0}, {26, 79, 0, 0, 32, 16, 0}, {27, 80, 0, 0, 32, 26, 0}, {28, 81, 0, 0, 32, 16, 0}, {29, 82, 0, 0, 64, 80, 0}, {30, 84, 0, 0, 32, 16, 0}, {32, 85, 0, 0, 0, 0, 0}, {33, 85, 0, 0, 0, 0, 0}, {34, 85, 0, 0, 0, 0, 0}, {35, 85, 0, 0, 0, 0, 0}, {36, 85, 0, 0, 0, 0, 0}, {37, 85, 0, 0, 0, 0, 0}, {38, 85, 0, 0, 0, 0, 0}, {39, 85, 0, 0, 0, 0, 0}, {40, 85, 0, 0, 0, 0, 0}, {41, 85, 0, 0, 0, 0, 0}, {42, 85, 0, 0, 0, 0, 0}, {43, 85, 0, 0, 0, 0, 0}, {44, 85, 0, 0, 0, 0, 0}, {45, 85, 0, 0, 0, 0, 0}, {46, 85, 0, 0, 0, 0, 0}, {47, 85, 0, 0, 0, 0, 0}, {48, 85, 0, 0, 0, 0, 0}, {49, 85, 0, 0, 0, 0, 0}, {50, 85, 0, 0, 0, 0, 0}, {51, 85, 0, 0, 0, 0, 0}, {52, 85, 0, 0, 0, 0, 0}, {53, 94, 0, 0, 16, 7, 0}, {54, 95, 0, 0, 96, 80, -1}, {55, 85, 0, 0, 0, 0, 0}, {56, 96, 4, -8, 0, 0, 0}, {57, 85, 0, 0, 0, 0, 0}, {58, 97, -16, 0, 32, 32, 0}, {59, 98, 0, 0, 0, 0, 0}};
    static short[][] decData;
    int[][] lightArray = new int[][]{{0, 0, 26, 90}, {26, 13, 39, 73}, {65, 15, 35, 75}};
    int[][] fishArray = new int[][]{{0, 0, 16, 7}, {0, 8, 16, 6}, {1, 14, 13, 9}, {16, 0, 9, 13}};
    int[][] waterArray = new int[][]{{0, 0, 14, 23}, {14, 0, 19, 31}, {33, 0, 22, 38}, {55, 0, 29, 46}};
    int[][] waterIndent = new int[][]{{0, 0}, {5, 4}, {8, 7}, {14, 12}};
    byte[] transArray;
    byte[] off = new byte[]{0, 1, 2, 1};
    int rad = 4;
    int offIndex;
    static boolean blackBG;
    public static byte SCEEN_MOVE;
    int adjustX;
    int adjustY;
    static boolean isMoveScreen;
    static Event event;
    static int path;
    int miniSize = 2;
    int[] miniColor = new int[]{12376749, 0, 0xFF0000, 65283};
    static boolean openMini;
    static byte[][] mData;
    static short[][] mProperties;
    static String[][] mName;
    static int layer;
    Image mapBuff;
    int buffWidth;
    int buffHeight;
    boolean isBuffNull;
    int lastStartX;
    int lastStartY;
    int lastEndX;
    int lastEndY;
    Graphics g1;
    static int flagMap;
    static int flagX;
    static int flagY;
    public static short[][] starPos;
    public static byte[][] starSpeed;
    public static byte[] starTypes;
    public static short[] starTimes;
    static int starType;
    static int baseSpeedX;
    static int baseSpeedY;
    static int starNum;
    static int showStarTime;
    int weatherIndex;
    short[][] rainData;
    int rainIndex;
    byte[] rndNum;
    static byte[][] flowerClipData;
    public final byte drawAmout = (byte)5;
    int[][] startPos;
    byte[][] rndSpeed;

    public GameMap(GameEngine en, int sw, int sh) {
        screenWidth = sw;
        screenHeight = sh;
        GameMap.setOff(0, 0);
        engine = en;
    }

    public void free() {
        mProperties = null;
        mName = null;
        GameMap.stopStar();
        this.rainFree();
        this.mapBuff = null;
        decData = null;
    }

    public void init(short[] dat) {
        this.mapID = (short)Event.getInt(dat[0]);
        this.mapName = dat[1];
        this.fileName = dat[2];
        weather = (short)Event.getInt(dat[3]);
        battleBg = (short)Event.getInt(dat[4]);
        BGM = (short)Event.getInt(dat[5]);
        this.enemys = dat[6];
    }

    public static void setOff(int x, int y) {
        setOffX = x;
        setOffY = y;
    }

    public void drawDecorations() {
        if (decData == null) {
            return;
        }
        if (++this.offIndex > Integer.MAX_VALUE) {
            this.offIndex = Integer.MAX_VALUE;
        }
        int index = GameMIDlet.gameIndex;
        int i = 0;
        while (i < decData.length) {
            short type = decData[i][0];
            short x = decData[i][1];
            int y = decData[i][2];
            byte trans = (byte)decData[i][3];
            int id = this.getObjIndex(type);
            if (id != -1) {
                short addx = this.objData[id][2];
                short addy = this.objData[id][3];
                short img = this.objData[id][1];
                short dl = this.objData[id][6];
                int drawLevel = y;
                switch (dl) {
                    case -1: {
                        drawLevel = 20;
                        break;
                    }
                    case 0: {
                        drawLevel = (short)(y + 31);
                        break;
                    }
                    case 1: {
                        drawLevel = 2000;
                    }
                }
                if (id == 23 || id == 24) {
                    drawLevel = (short)(y + 64);
                } else if (id == 53) {
                    drawLevel = (short)(y - 80);
                }
                switch (this.objData[id][0]) {
                    case 6: {
                        byte[] motion = new byte[]{0, 0, 0, 0, 1, 1, 1, 1, 2, 2, 2, 2, 1, 1, 1, 1, 0, 0, 0, 0, 3, 3, 3, 3, 4, 4, 4, 4, 3, 3, 3, 3};
                        Tools.drawFrame(img, GameData.offset_d6, GameData.imgDat_d6, (int)x, y, (int)motion[index % motion.length], trans == 1, drawLevel);
                        break;
                    }
                    case 7: {
                        byte[] motion = new byte[]{5, 5, 5, 5, 6, 6, 6, 6, 7, 7, 7, 7, 8, 8, 8, 8, 9, 9, 9, 9, 10, 10, 10, 10, 11, 11, 11, 11};
                        int temp = index % motion.length;
                        if (temp >= motion.length) break;
                        Tools.drawFrame(img, GameData.offset_d6, GameData.imgDat_d6, x + 16 - GameData.indent_d6[motion[temp]][3], y, (int)motion[temp], trans == 1, drawLevel);
                        break;
                    }
                    case 8: {
                        byte[] motion = new byte[]{12, 12, 12, 12, 13, 13, 13, 13, 14, 14, 14, 14, 15, 15, 15, 15, 16, 16, 16, 16, 17, 17, 17, 17, 18, 18, 18, 18};
                        int temp = index % motion.length;
                        if (temp >= motion.length) break;
                        Tools.drawFrame(img, GameData.offset_d6, GameData.imgDat_d6, x + 16 - GameData.indent_d6[motion[temp]][3], y, (int)motion[temp], trans == 1, drawLevel);
                        break;
                    }
                    case 13: 
                    case 14: 
                    case 15: 
                    case 16: {
                        this.drawPaiBian(x + 8, y, trans, drawLevel, img);
                        break;
                    }
                    case 10: 
                    case 11: 
                    case 12: {
                        this.drawPaiBian(x, y, trans, drawLevel, img);
                        break;
                    }
                    case 17: 
                    case 18: 
                    case 19: 
                    case 20: {
                        Tools.addImage(101, x + addx, y + addy, 36, trans, drawLevel);
                        Tools.addImage(101, x + addx + 16, y + addy, 36, (byte)1, drawLevel);
                        Tools.addImage(img, x + addx + 16 - Tools.getImage(img).getWidth() / 2, y + addy - 10, 36, trans, drawLevel);
                        break;
                    }
                    case 22: {
                        byte[] motion = new byte[]{0, 0, 1, 1, 2, 2};
                        Tools.addImage(img, x + addx + 16, y + addy - 26, 36, trans, drawLevel);
                        Tools.addImage(86, x + addx - 5 + 16, y + addy + 18 - 26, motion[index % motion.length] * 25, 0, 24, 21, 36, trans, drawLevel);
                        break;
                    }
                    case 23: {
                        byte[] motion = new byte[]{0, 0, 1, 1, 2, 2};
                        Tools.addImage(img, x + addx, y + addy + 4, motion[index % motion.length] * 8, 0, 8, 11, 36, trans, drawLevel);
                        break;
                    }
                    case 24: {
                        byte[] motion = new byte[]{0, 0, 1, 1, 2, 2};
                        Tools.addImage(img, x + addx, y + addy + 2, motion[index % motion.length] * 8, 0, 8, 11, 36, trans, drawLevel);
                        break;
                    }
                    case 25: 
                    case 26: 
                    case 29: {
                        Tools.addImage(img, x + addx, y + addy, 36, trans, drawLevel);
                        Tools.addImage(img, x + addx + Tools.getImage(img).getWidth(), y + addy, 36, (byte)1, drawLevel);
                        break;
                    }
                    case 28: {
                        byte[] motion = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 2, 2, 2, 1, 1, 1, 1, 1};
                        Tools.addImage(img, x + addx, y + addy, 36, trans, drawLevel);
                        Tools.addImage(87, x + addx + 8, y + addy - 34, 0, motion[index % motion.length] * 8, 15, 8, 36, trans, drawLevel);
                        Tools.addImage(87, x + addx + 18, y + addy - 18, 16, motion[index % motion.length] * 8, 6, 8, 36, trans, drawLevel);
                        break;
                    }
                    case 32: {
                        break;
                    }
                    case 33: {
                        break;
                    }
                    case 34: {
                        break;
                    }
                    case 35: {
                        break;
                    }
                    case 36: {
                        break;
                    }
                    case 37: {
                        break;
                    }
                    case 38: {
                        break;
                    }
                    case 39: {
                        break;
                    }
                    case 40: {
                        break;
                    }
                    case 41: {
                        break;
                    }
                    case 42: {
                        break;
                    }
                    case 43: {
                        break;
                    }
                    case 44: {
                        break;
                    }
                    case 45: {
                        break;
                    }
                    case 46: {
                        break;
                    }
                    case 47: {
                        break;
                    }
                    case 48: {
                        break;
                    }
                    case 49: {
                        break;
                    }
                    case 50: {
                        break;
                    }
                    case 51: {
                        break;
                    }
                    case 52: {
                        break;
                    }
                    case 53: {
                        byte[] motion = (i + this.rad) % 3 == 0 ? new byte[]{0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 2, 2, 2, 2, 2, 3, 3, 3, 4, 4, 4, 5, 5, 5, 5, 5, 7, 7, 7, 7, 7, 5, 5, 5, 5, 5, 6, 6, 6, 6, 6, 8, 8, 8, 9, 9, 0} : ((i + this.rad) % 3 == 1 ? new byte[]{0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 2, 2, 2, 2, 2, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 2, 2, 2, 2, 2, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 0, 0} : ((i + this.rad) % 3 == 2 ? new byte[]{0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 2, 2, 2, 2, 2, 3, 3, 3, 4, 4, 4, 5, 5, 5, 5, 5, 7, 7, 7, 7, 7, 5, 5, 5, 5, 5, 6, 6, 6, 6, 6, 8, 8, 8, 9, 9, 0} : new byte[]{0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 2, 2, 2, 2, 2, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 2, 2, 2, 2, 2, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 0, 0}));
                        int temp = index % motion.length;
                        if (temp < motion.length) {
                            Tools.drawFrame(img, GameData.offset_d53, GameData.imgDat_d53, x + addx - GameData.indent_d53[motion[temp]][3], y + addy - GameData.indent_d53[motion[temp]][5], (int)motion[temp], false, 0);
                        }
                        if (temp != 51) break;
                        this.rad = GameEngine.nextInt(1, 5);
                        temp = 0;
                        break;
                    }
                    case 54: {
                        byte[] motion;
                        Tools.addImage(img, x + addx, y + addy, 36, trans, drawLevel);
                        Tools.addImage(img, x + addx + 48, y + addy, 36, (byte)1, drawLevel);
                        if (GameEngine.on) {
                            motion = new byte[]{0, 0, 1, 1};
                            motion = new byte[]{0, 0, 1, 1, 2, 2, 3, 3};
                            Tools.addImage(88, x + addx + 25 + 7 - this.waterIndent[motion[index % motion.length]][0] + 2, y + addy - 50 - this.waterIndent[motion[index % motion.length]][1] - 2, this.waterArray[motion[index % motion.length]], 20, trans, drawLevel);
                            Tools.addImage(88, x + addx + 25 - 7 + 28 + 2, y + addy - 50 - this.waterIndent[motion[index % motion.length]][1] - 2, this.waterArray[motion[index % motion.length]], 20, (byte)1, drawLevel);
                            if (this.offIndex > 30) {
                                short[][] a = new short[][]{{-64, -43}, {144, -43}, {-48, -107}, {128, -107}, {0, -123}, {80, -123}};
                                int j = 0;
                                while (j < a.length) {
                                    Tools.addImage(337, x + a[j][0], y + a[j][1], 16 * (MyGameCanvas.gameTime % 6 / 2), 0, 16, 33, 20, (byte)0, drawLevel);
                                    ++j;
                                }
                            }
                            if (this.offIndex <= 60 || MyGameCanvas.gameTime % 6 != 0) break;
                            Effect.AddEffectList(x - 35 - 16, y - 46 + 16, 55, 0, drawLevel);
                            Effect.AddEffectList(x - 35 + 165 + 16, y - 46 + 16, 55, 1, drawLevel);
                            Effect.AddEffectList(x - 32 + 13 - 16, y - 91 - 1, 56, 0, drawLevel);
                            Effect.AddEffectList(x - 32 + 13 + 132 + 16, y - 91 - 1, 56, 1, drawLevel);
                            Effect.AddEffectList(x + 13, y - 123 + 15, 57, 0, drawLevel);
                            Effect.AddEffectList(x + 32 + 13 + 37, y - 123 + 15, 57, 1, drawLevel);
                            break;
                        }
                        this.offIndex = 0;
                        break;
                    }
                    case 55: {
                        break;
                    }
                    case 56: {
                        byte[] motion = new byte[]{0, 0, 1, 1, 0, 0, 1, 1};
                        Tools.addImage(img, x + addx, y + addy, 26 * motion[index % motion.length], 0, 26, 46, 36, index % motion.length < 4 ? (byte)0 : 1, 0);
                        break;
                    }
                    case 57: {
                        break;
                    }
                    case 58: {
                        byte[] motion = new byte[]{0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 1, 1, 1, 1, 1, -1, -1, -1, -1, -1};
                        Tools.addImage(img, x + addx + 5, y + addy - 2, 36, trans, drawLevel);
                        Tools.addImage(img, x + addx + Tools.getImage(img).getWidth() + 5, y + addy - 2, 36, (byte)1, drawLevel);
                        if (motion[index % motion.length] == -1) break;
                        Tools.addImage(90, x + addx + 15 + 5, y + addy - 45 - 2, 0, 7 * motion[index % motion.length], 24, 7, 36, trans, drawLevel);
                        Tools.addImage(92, x + addx + 17 + 5, y + addy - 64 - 2, 0, 9 * motion[index % motion.length], 20, 9, 36, trans, drawLevel);
                        break;
                    }
                    case 59: {
                        byte[] motion = i % 2 == 0 ? new byte[]{0, 1, 2, 3} : new byte[]{0, 0, 1, 1, 2, 2, 3, 3, -1, -1};
                        if (motion[index % motion.length] == -1) break;
                        Tools.addImage(img, x + addx, y + addy, 1 + motion[index % motion.length] * 27, 1, 26, 23, 36, trans, drawLevel - 300);
                        break;
                    }
                    default: {
                        Tools.addImage(img, x + addx, y + addy, 36, trans, drawLevel);
                    }
                }
            }
            ++i;
        }
    }

    void drawPaiBian(int x, int y, byte trans, int drawLevel, int img) {
        Tools.addImage(100, x, y, 36, trans, drawLevel);
        Tools.addImage(100, x + 24, y, 36, (byte)1, drawLevel);
        Tools.addImage(img, x + 24 - Tools.getImage(img).getWidth() / 2, y - 3, 36, trans, drawLevel);
    }

    void loadDecorationDat() {
        decData = null;
        decData = engine.readItemData2((this.mapID < 10 ? "0" : "") + this.mapID);
    }

    void loadMapDat() {
        this.loadMap(Event.getString(this.fileName));
        int i = 0;
        while (i < layer) {
            Tools.createImage(mName[i], i + 1);
            ++i;
        }
    }

    public void initMap() {
        this.free();
        this.initMapBuff();
        decData = null;
        this.adjustX = screenWidth / 2;
        this.adjustY = screenHeight / 2 + 20;
        this.loadMapDat();
        this.loadDecorationDat();
    }

    public void drawMapBG(Graphics g) {
        g.setColor(0);
        g.fillRect(setOffX, setOffY, 320, 240);
    }

    public void drawMapFG() {
        this.drawDecorations();
    }

    public void setMap(Graphics g) {
        if (mData != null) {
            if (blackBG) {
                GameEngine.drawColorScreenBG(0, 0);
            } else {
                int index = GameMIDlet.gameIndex;
                switch (this.mapID) {
                    case 0: {
                        byte[] motion = new byte[]{0, 0, 0, 1, 1, 1, 2, 2, 2};
                        Tools.addImage(50, 0, 0, 20, (byte)0, 0);
                        engine.drawFlame(39, 251, 0, 0);
                        engine.drawFlame(266, 251, 0, 0);
                        engine.drawFlame(76, 84, 1, 0);
                        engine.drawFlame(233, 84, 1, 0);
                        break;
                    }
                    case 13: {
                        GameMap.engine.canvas.drawCleanScreen(g, 0);
                        Tools.addImage(49, setOffX, setOffY + (240 - Tools.getImage(49).getHeight()) / 2, index % 56, 0, 56 - index % 56, 163, 20, (byte)0, 0);
                        int i = 0;
                        while (i < 7) {
                            Tools.addImage(49, setOffX + 56 - index % 56 + Tools.getImage(49).getWidth() * i, setOffY + (240 - Tools.getImage(49).getHeight()) / 2, 20, (byte)0, 0);
                            ++i;
                        }
                        if (index % 56 > 40) {
                            Tools.addImage(49, setOffX + 56 - index % 56 + Tools.getImage(49).getWidth() * 4, setOffY + (240 - Tools.getImage(49).getHeight()) / 2, 0, 0, 16 - (56 - index % 56), 163, 20, (byte)0, 0);
                        }
                        Tools.addImage(46, setOffX + 320 - Tools.getImage(46).getWidth(), setOffY + (240 - Tools.getImage(46).getHeight()) / 2, 20, (byte)0, 0);
                        break;
                    }
                    case 14: {
                        GameMap.engine.canvas.drawCleanScreen(g, 0);
                        Tools.addImage(49, setOffX, setOffY + (240 - Tools.getImage(49).getHeight()) / 2, index % 56, 0, 56 - index % 56, 163, 20, (byte)0, 0);
                        int i = 0;
                        while (i < 7) {
                            Tools.addImage(49, setOffX + 56 - index % 56 + Tools.getImage(49).getWidth() * i, setOffY + (240 - Tools.getImage(49).getHeight()) / 2, 20, (byte)0, 0);
                            ++i;
                        }
                        if (index % 56 > 40) {
                            Tools.addImage(49, setOffX + 56 - index % 56 + Tools.getImage(49).getWidth() * 4, setOffY + (240 - Tools.getImage(49).getHeight()) / 2, 0, 0, 16 - (56 - index % 56), 163, 20, (byte)0, 0);
                        }
                        Tools.addImage(46, setOffX, setOffY + (240 - Tools.getImage(46).getHeight()) / 2, 20, (byte)1, 0);
                        break;
                    }
                    default: {
                        this.drawMap(g, setOffX, setOffY);
                        if (GameEngine.showHole || GameEngine.gameRank == 0) break;
                        this.setTile(g);
                    }
                }
                this.drawMapFG();
                this.drawTaskFlag(200);
            }
        }
    }

    public void adjustSrceen(int x, int y) {
        setOffX = x - this.adjustX;
        setOffX = Math.max(setOffX, 0);
        setOffX = Math.min(setOffX, mapSize[0] * tileWidth - screenWidth);
        setOffY = (short)(y - this.adjustY);
        setOffY = (short)Math.min(setOffY, mapSize[1] * tileHight - screenHeight);
        setOffY = (short)Math.max(setOffY, 0);
    }

    public void moveSrceen(int x, int y) {
        setOffX = Math.abs(x - setOffX - this.adjustX) > SCEEN_MOVE ? (x - setOffX - this.adjustX >= SCEEN_MOVE ? (setOffX += SCEEN_MOVE) : (setOffX -= SCEEN_MOVE)) : (int)((short)(x - this.adjustX));
        setOffX = (short)Math.max(setOffX, 0);
        setOffX = (short)Math.min(setOffX, mapSize[0] * tileWidth - screenWidth);
        setOffY = Math.abs(y - setOffY - this.adjustY) > SCEEN_MOVE ? (y - setOffY - this.adjustY >= SCEEN_MOVE ? (setOffY += SCEEN_MOVE) : (setOffY -= SCEEN_MOVE)) : (int)((short)(y - this.adjustY));
        setOffY = (short)Math.max(setOffY, 0);
        setOffY = (short)Math.min(setOffY, mapSize[1] * tileHight - screenHeight);
        if (isMoveScreen && this.checkMoveScreen(x, y)) {
            isMoveScreen = false;
            GameMap.finish();
        }
    }

    public boolean checkMoveScreen(int x, int y) {
        short tempx = (short)(x - this.adjustX);
        tempx = (short)Math.max(tempx, 0);
        tempx = (short)Math.min(tempx, mapSize[0] * tileWidth - screenWidth);
        short tempy = (short)(y - this.adjustY);
        tempy = (short)Math.max(tempy, 0);
        tempy = (short)Math.min(tempy, mapSize[1] * tileHight - screenHeight);
        return setOffX == tempx && setOffY == tempy;
    }

    public static void sender(Event event1, int pathIndex) {
        GameMap.finish();
        event = event1;
        path = pathIndex;
    }

    public static void finish() {
        if (event == null) {
            return;
        }
        event.setEnd(path);
        event = null;
    }

    public boolean canRun(int x, int y) {
        if (x < 0 || x > mapSize[0] * tileHight - tileHight || y < tileHight - 1 || y > mapSize[1] * tileHight) {
            return false;
        }
        int i = layer - 1;
        while (i >= 0) {
            if (GameMap.inMapData(x, y, i) == -1) {
                if (i == 0) {
                    return false;
                }
            } else {
                return this.canRun(x, y, i);
            }
            --i;
        }
        return true;
    }

    public boolean canRun(int x, int y, int lay) {
        if (GameMap.inMapData(x, y, lay) == -1) {
            return false;
        }
        return !Tools.getProperties(mProperties[lay][GameMap.getLow(GameMap.inMapData(x, y, lay))], (byte)15);
    }

    public int repaint(int data) {
        if (data == -1) {
            return 0;
        }
        if (!Tools.getProperties(mProperties[1][GameMap.getLow(data)], (byte)14)) {
            return 1;
        }
        if (!Tools.getProperties(mProperties[1][GameMap.getLow(data)], (byte)13)) {
            return 2;
        }
        return 0;
    }

    public static byte inMapData(int x, int y, int index) {
        int n = x / tileWidth * mapSize[1] + y / tileHight;
        if (n < 0 || n >= mData[index].length) {
            return -1;
        }
        return mData[index][n];
    }

    public void drawMiniMap(int x, int y) {
        Tools.addRect((byte)1, x + screenWidth - mapSize[0] * this.miniSize - 2, y, mapSize[0] * this.miniSize + 2, mapSize[1] * this.miniSize + 2, false, 20, 0xFFFFFF, 9999);
        int i = 0;
        while (i < mapSize[1]) {
            int j = 0;
            while (j < mapSize[0]) {
                if (this.canRun(j * 16, i * 16)) {
                    Tools.addRect((byte)1, x + screenWidth - (mapSize[0] - j) * this.miniSize - 1, y + 1 + i * this.miniSize, this.miniSize, this.miniSize, true, 20, this.miniColor[0], 9999);
                } else {
                    Tools.addRect((byte)1, x + screenWidth - (mapSize[0] - j) * this.miniSize - 1, y + 1 + i * this.miniSize, this.miniSize, this.miniSize, true, 20, this.miniColor[1], 9999);
                }
                ++j;
            }
            ++i;
        }
        int sx = GameEngine.sprite[GameEngine.spriteIndex].x;
        int sy = GameEngine.sprite[GameEngine.spriteIndex].y;
        Tools.addRect((byte)1, x + screenWidth - (mapSize[0] - sx / 16) * this.miniSize - 1, y + 1 + (sy / 16 - 1) * this.miniSize, this.miniSize, this.miniSize, true, 20, this.miniColor[2], 9999);
    }

    public static int getTrans(int v) {
        return v >> 6 & 3;
    }

    public static int get2nd(int v) {
        return v << 1 >> 7 & 1;
    }

    public static int getLow(int v) {
        return v & 0x3F;
    }

    static int bToi(byte byte0) {
        int i = byte0;
        if (byte0 < 0) {
            i += 256;
        }
        return i;
    }

    public void initBattleMap() {
        switch (battleBg) {
            case 0: {
                Tools.getImage(27);
                break;
            }
            case 1: {
                Tools.getImage(29);
                break;
            }
        }
        Tools.getImage(3);
        Tools.getImage(15);
        Tools.getImage(16);
    }

    public static void drawFullScreenBG(int imgIndex, int height, int speed, int level) {
        int imgW = Tools.getImage(imgIndex).getWidth();
        int imgH = Tools.getImage(imgIndex).getHeight();
        int times = screenWidth / imgW + 2;
        int startPos = setOffX * speed * 10 / 1000;
        while (setOffX - startPos >= imgW) {
            startPos += imgW;
        }
        int i = 0;
        while (i < times) {
            Tools.addImage(imgIndex, startPos + i * imgW, height, 0, 0, imgW, imgH, 20, (byte)0, level);
            ++i;
        }
    }

    int getObjIndex(int id) {
        int i = 0;
        while (i < this.objData.length) {
            if (this.objData[i][0] == id) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int hitDecorations(int x, int y) {
        if (decData == null) {
            return -1;
        }
        int i = 0;
        while (i < decData.length) {
            short id = decData[i][0];
            int objIndex = this.getObjIndex(id);
            if (objIndex != -1) {
                short w = this.objData[objIndex][4];
                short h = this.objData[objIndex][5];
                if (w != 0 && h != 0 && x >= decData[i][1] && x < decData[i][1] + w && y < decData[i][2] && y > decData[i][2] - h) {
                    return i;
                }
            }
            ++i;
        }
        return -1;
    }

    public static int getIndex(int v) {
        return v & 0x3F;
    }

    public int getIndex(int x, int y, int index) {
        return GameMap.getIndex(GameMap.inMapData(x, y, index));
    }

    public void loadMap(String file) {
        byte[] array = Tools.getDat("/map.dat", file);
        if (array == null) {
            System.out.println("map file is null!");
            return;
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(array);
        DataInputStream in = new DataInputStream(bais);
        try {
            layer = GameMap.bToi(in.readByte());
            mData = new byte[layer][];
            mProperties = new short[layer][];
            mName = new String[layer][];
            int i = 0;
            while (i < layer) {
                GameMap.mapSize[0] = GameMap.bToi(in.readByte());
                GameMap.mapSize[1] = GameMap.bToi(in.readByte());
                tileWidth = in.readByte();
                tileHight = in.readByte();
                int size = mapSize[0] * mapSize[1];
                GameMap.mData[i] = new byte[size];
                in.read(mData[i]);
                int len = in.readShort();
                GameMap.mName[i] = new String[len];
                GameMap.mProperties[i] = new short[len];
                int j = 0;
                while (j < len) {
                    byte nameLen = in.readByte();
                    byte[] names = new byte[nameLen];
                    in.read(names);
                    GameMap.mName[i][j] = new String(names);
                    GameMap.mProperties[i][j] = in.readShort();
                    ++j;
                }
                ++i;
            }
            in.close();
            bais.close();
        }
        catch (IOException ex) {
            System.out.println("************* Read Map Error !!! ******************");
        }
    }

    public void setTile(Graphics g) {
        int n = setOffX / tileWidth * mapSize[1] + setOffY / tileHight;
        int nw = screenWidth / tileWidth + 2;
        int nh = screenHeight / tileHight + 2;
        int j = 0;
        while (j < nw) {
            int s;
            int i = s = n + j * mapSize[1];
            while (i < s + nh) {
                if (i < mData[1].length && i >= 0) {
                    int dataTemp = GameMap.getLow(mData[1][i]);
                    int temp = this.repaint(mData[1][i]);
                    if (temp != 0) {
                        int x = i / mapSize[1] * tileHight;
                        int y = i % mapSize[1] * tileWidth;
                        Tools.addImage(800 + dataTemp, x, y, 0, 0, tileWidth, tileHight, 20, (byte)GameMap.getTrans(mData[1][i]), temp == 1 ? 2000 : y + 31 + 32);
                    }
                }
                ++i;
            }
            ++j;
        }
    }

    void initMapBuff() {
        this.isBuffNull = true;
        if (this.mapBuff == null) {
            tileWidth = (byte)16;
            tileHight = (byte)16;
            this.buffWidth = screenWidth - screenWidth % tileWidth + tileWidth * 2;
            this.buffHeight = screenHeight - screenHeight % tileHight + tileHight * 2;
            this.mapBuff = Image.createImage((int)this.buffWidth, (int)this.buffHeight);
            this.g1 = this.mapBuff.getGraphics();
        }
    }

    void drawBuff(Graphics g, int clipX, int clipY, int clipW, int clipH, int x, int y) {
        g.setClip(x, y, clipW, clipH);
        g.drawImage(this.mapBuff, x - clipX, y - clipY, 20);
        g.setClip(0, 0, screenWidth, screenHeight);
    }

    void drawMap(Graphics g, int setOffX, int setOffY) {
        int startX = setOffX / tileWidth;
        int endX = startX + screenWidth / tileWidth + 1;
        int startY = setOffY / tileHight;
        int endY = startY + screenHeight / tileHight + 1;
        if (this.isBuffNull) {
            this.isBuffNull = false;
            this.updateBuff(this.g1, startX, startY, endX, endY);
            this.lastStartX = startX;
            this.lastStartY = startY;
            this.lastEndX = endX;
            this.lastEndY = endY;
        }
        if (this.lastStartX != startX) {
            int tmp2;
            int tmp1;
            if (this.lastStartX < startX) {
                tmp1 = this.lastEndX + 1;
                tmp2 = endX;
            } else {
                tmp1 = startX;
                tmp2 = this.lastStartX - 1;
            }
            this.updateBuff(this.g1, tmp1, startY, tmp2, endY);
            this.lastStartX = startX;
            this.lastEndX = endX;
        }
        if (this.lastStartY != startY) {
            int tmp4;
            int tmp3;
            if (this.lastStartY < startY) {
                tmp3 = this.lastEndY + 1;
                tmp4 = endY;
            } else {
                tmp3 = startY;
                tmp4 = this.lastStartY - 1;
            }
            this.updateBuff(this.g1, startX, tmp3, endX, tmp4);
            this.lastStartY = startY;
            this.lastEndY = endY;
        }
        int t1 = setOffX % this.buffWidth;
        int t2 = setOffY % this.buffHeight;
        int t3 = (setOffX + screenWidth) % this.buffWidth;
        int t4 = (setOffY + screenHeight) % this.buffHeight;
        if (t3 > t1) {
            if (t4 > t2) {
                this.drawBuff(g, t1, t2, screenWidth, screenHeight, 0, 0);
            } else {
                this.drawBuff(g, t1, t2, screenWidth, screenHeight - t4, 0, 0);
                this.drawBuff(g, t1, 0, screenWidth, t4, 0, screenHeight - t4);
            }
        } else if (t4 > t2) {
            this.drawBuff(g, t1, t2, screenWidth - t3, screenHeight, 0, 0);
            this.drawBuff(g, 0, t2, t3, screenHeight, screenWidth - t3, 0);
        } else {
            this.drawBuff(g, t1, t2, screenWidth - t3, screenHeight - t4, 0, 0);
            this.drawBuff(g, t1, 0, screenWidth - t3, t4, 0, screenHeight - t4);
            this.drawBuff(g, 0, t2, t3, screenHeight - t4, screenWidth - t3, 0);
            this.drawBuff(g, 0, 0, t3, t4, screenWidth - t3, screenHeight - t4);
        }
    }

    void updateBuff(Graphics g, int startX, int startY, int endX, int endY) {
        int y = startY * tileHight % this.buffHeight;
        int i = startY;
        while (i <= endY) {
            int x = startX * tileWidth % this.buffWidth;
            int j = startX;
            while (j <= endX) {
                int k = 0;
                while (k < layer) {
                    byte mapIndex = GameMap.inMapData(j * tileWidth, i * tileHight, k);
                    int dataTemp = GameMap.getIndex(mapIndex);
                    int transData = GameMap.getTrans(mapIndex);
                    if ((byte)mapIndex != -1) {
                        g.setClip(x, y, (int)tileWidth, (int)tileHight);
                        Tools.drawClipImage(g, 400 * (k + 1) + dataTemp, x, y, 0, 0, tileWidth, tileHight, 20, transData);
                        g.setClip(0, 0, this.buffWidth, this.buffHeight);
                    } else if (k == 0) {
                        g.setClip(x, y, (int)tileWidth, (int)tileHight);
                        g.setColor(0);
                        g.fillRect(x, y, (int)tileWidth, (int)tileHight);
                        g.setClip(0, 0, this.buffWidth, this.buffHeight);
                    }
                    ++k;
                }
                if ((x += tileWidth) >= this.buffWidth) {
                    x -= this.buffWidth;
                }
                ++j;
            }
            if ((y += tileHight) >= this.buffHeight) {
                y -= this.buffHeight;
            }
            ++i;
        }
    }

    public void drawTaskFlag(int lev) {
        if (flagMap == -1 || GameEngine.gameRank != flagMap || MyGameCanvas.gameStatus == 14) {
            return;
        }
        Tools.addImage(325, flagX + 1 - 30, flagY + GameMIDlet.gameIndex % 4, 0, 0, 55, 60, 36, (byte)0, lev + flagY);
        Tools.addImage(325, flagX + 1 + 22 - 30, flagY - 9 + GameMIDlet.gameIndex % 4, 55, 0, 17, 36, 36, (byte)0, lev + flagY);
    }

    static void stopStar() {
        starPos = null;
        starSpeed = null;
        starTypes = null;
        starTimes = null;
        showStarTime = 0;
    }

    public static void initStar(int type, int speedX, int speedY, int num, int time) {
        starType = type;
        baseSpeedX = speedX;
        baseSpeedY = speedY;
        starNum = num;
        starPos = new short[starNum][2];
        starSpeed = new byte[starNum][2];
        starTypes = new byte[starNum];
        starTimes = new short[starNum];
        int i = 0;
        while (i < starNum) {
            GameMap.starPos[i][0] = (short)(GameEngine.nextInt(10000) % 320 + setOffX);
            GameMap.starPos[i][1] = (short)(GameEngine.nextInt(10000) % 240 + setOffY);
            GameMap.starSpeed[i][0] = (byte)(baseSpeedX == 0 ? 0 : GameEngine.nextInt(10000) % 3 * (baseSpeedX > 0 ? 1 : -1) + baseSpeedX);
            GameMap.starSpeed[i][1] = (byte)(baseSpeedY == 0 ? 0 : GameEngine.nextInt(10000) % 3 + baseSpeedY);
            switch (starType) {
                case 1: {
                    GameMap.starTypes[i] = (byte)GameEngine.nextInt(20);
                    GameMap.starTimes[i] = (short)(GameEngine.nextInt(240 / starSpeed[i][1] - 2) + 2);
                    break;
                }
                case 2: {
                    GameMap.starTypes[i] = (byte)GameEngine.nextInt(1);
                    GameMap.starTimes[i] = (short)(GameEngine.nextInt(240 / starSpeed[i][1] - 2) + 2);
                    break;
                }
                case 3: {
                    GameMap.starTypes[i] = (byte)GameEngine.nextInt(2);
                }
            }
            ++i;
        }
        showStarTime = time;
    }

    private static void refreshStarAllMap(int id) {
        GameMap.starSpeed[id][0] = (byte)(baseSpeedX == 0 ? 0 : GameEngine.nextInt(10000) % 3 * (baseSpeedX > 0 ? 1 : -1) + baseSpeedX);
        GameMap.starSpeed[id][1] = (byte)(baseSpeedY == 0 ? 0 : GameEngine.nextInt(10000) % 3 + baseSpeedY);
        switch (starType) {
            case 1: {
                GameMap.starPos[id][0] = (short)(GameEngine.nextInt(10000) % (mapSize[0] * tileHight));
                GameMap.starPos[id][1] = (short)setOffY;
                GameMap.starTypes[id] = (byte)GameEngine.nextInt(20);
                GameMap.starTimes[id] = (short)(GameEngine.nextInt(240 / starSpeed[id][1] - 2) + 2);
                break;
            }
            case 2: {
                GameMap.starPos[id][0] = (short)(GameEngine.nextInt(10000) % (mapSize[0] * tileHight));
                GameMap.starPos[id][1] = (short)setOffY;
                GameMap.starTypes[id] = (byte)GameEngine.nextInt(1);
                GameMap.starTimes[id] = (short)(GameEngine.nextInt(240 / starSpeed[id][1] - 2) + 2);
                break;
            }
            case 3: {
                GameMap.starPos[id][0] = (short)(setOffX + screenWidth);
                GameMap.starPos[id][1] = (short)(GameEngine.nextInt(10000) % 240 * 2 - 120);
                GameMap.starTypes[id] = (byte)GameEngine.nextInt(2);
            }
        }
    }

    public static void moveStar() {
        if (showStarTime == 0) {
            return;
        }
        if (starType == 3) {
            int i = 0;
            while (i < starNum) {
                if (starPos[i][0] < setOffX - 210) {
                    GameMap.refreshStarAllMap(i);
                } else {
                    short[] sArray = starPos[i];
                    sArray[0] = (short)(sArray[0] + starSpeed[i][0]);
                    short[] sArray2 = starPos[i];
                    sArray2[1] = (short)(sArray2[1] + starSpeed[i][1]);
                }
                ++i;
            }
            return;
        }
        int i = 0;
        while (i < starNum) {
            if (starTimes[i] <= 0) {
                GameMap.refreshStarAllMap(i);
            } else {
                short[] sArray = starPos[i];
                sArray[0] = (short)(sArray[0] + starSpeed[i][0]);
                short[] sArray3 = starPos[i];
                sArray3[1] = (short)(sArray3[1] + starSpeed[i][1]);
                int n = i;
                starTimes[n] = (short)(starTimes[n] - 1);
            }
            ++i;
        }
    }

    public static void drawStar(int x, int y, int drawLevel) {
        if (showStarTime == 0) {
            return;
        }
        int i = 0;
        while (i < starNum) {
            switch (starType) {
                case 1: {
                    Tools.addLine((byte)3, x + starPos[i][0], y + starPos[i][1], x + starPos[i][0] - 2, y + starPos[i][1] + starTypes[i] + 10, 0xFFFFFF, drawLevel);
                    break;
                }
                case 2: {
                    Tools.addImage(230, x + starPos[i][0], y + starPos[i][1], GameData.imgDatHua[starTypes[i] * 4 + starTimes[i] % 8 / 2], 20, (byte)0, drawLevel);
                    break;
                }
            }
            ++i;
        }
        if (showStarTime > 0) {
            --showStarTime;
        }
    }

    public void drawWeather(int lev) {
    }

    public void initRainData() {
        this.rainData = new short[10][3];
        this.weatherIndex = 0;
        int i = 0;
        while (i < this.rainData.length) {
            this.rainData[i][0] = (short)(setOffX + GameEngine.nextInt(320));
            this.rainData[i][1] = (short)(setOffY + GameEngine.nextInt(240));
            this.rainData[i][2] = (short)GameEngine.nextInt(2);
            ++i;
        }
        this.rndNum = new byte[]{1, 1, 1, 1, 2, 2, 2, 2};
    }

    public void drawRain(int dl) {
        if (this.weatherIndex == 0) {
            this.initRainData();
        }
        int i = 0;
        while (i < this.rainData.length) {
            short[] sArray = this.rainData[i];
            sArray[0] = (short)(sArray[0] + 6);
            short[] sArray2 = this.rainData[i];
            sArray2[1] = (short)(sArray2[1] + 12);
            if (this.rainData[i][0] >= setOffX + screenWidth + 10 || this.rainData[i][1] >= setOffY + screenHeight + 20) {
                this.rainData[i][0] = (short)(setOffX + GameEngine.nextInt(320));
                this.rainData[i][1] = (short)(setOffY + GameEngine.nextInt(240));
                this.rainData[i][2] = (short)GameEngine.nextInt(2);
                Effect.AddEffectList(this.rainData[i][0], this.rainData[i][1], 59, 0, dl);
            }
            Tools.addImage(266, this.rainData[i][0], this.rainData[i][1], 6 * this.rainData[i][2], 0, 6, 12, 36, (byte)1, dl);
            ++i;
        }
        ++this.weatherIndex;
    }

    void rainFree() {
        this.rainData = null;
        this.rndNum = null;
        this.weatherIndex = 0;
    }

    void drawFlower(int dl) {
        if (this.weatherIndex == 0) {
            this.initFlower(5, 2);
        }
        int i = 0;
        while (i < 5) {
            int[] nArray = this.startPos[i];
            nArray[0] = nArray[0] + GameEngine.nextInt(0, this.rndSpeed[i][0]);
            int[] nArray2 = this.startPos[i];
            nArray2[1] = nArray2[1] + GameEngine.nextInt(1, this.rndSpeed[i][1]);
            Tools.addImage(184, this.startPos[i][0], this.startPos[i][1], flowerClipData[GameEngine.nextInt(7)], 20, (byte)0, dl);
            ++i;
        }
        int i2 = 0;
        while (i2 < 5) {
            if (this.startPos[i2][0] >= setOffX + 320 + 10 || this.startPos[i2][1] >= setOffY + 240) {
                this.initOneFlower(i2);
            }
            ++i2;
        }
        ++this.weatherIndex;
    }

    void initFlower(int xSpeed, int ySpeed) {
        this.startPos = new int[5][2];
        this.rndSpeed = new byte[5][2];
        int i = 0;
        while (i < 5) {
            this.rndSpeed[i][0] = (byte)xSpeed;
            this.rndSpeed[i][1] = (byte)ySpeed;
            this.initOneFlower(i);
            int[] nArray = this.startPos[i];
            nArray[0] = nArray[0] + xSpeed * GameEngine.nextInt(5, 20);
            int[] nArray2 = this.startPos[i];
            nArray2[1] = nArray2[1] + ySpeed * GameEngine.nextInt(5, 25);
            ++i;
        }
        flowerClipData = new byte[][]{{0, 0, 6, 5}, {6, 0, 6, 5}, {12, 0, 6, 5}, {18, 0, 6, 5}, {24, 0, 6, 5}, {30, 0, 6, 5}, {36, 0, 6, 5}, {42, 0, 6, 5}};
    }

    void initOneFlower(int ind) {
        byte rndHB = (byte)GameEngine.nextInt(0, 1);
        if (rndHB == 0) {
            this.startPos[ind][0] = setOffX + GameEngine.nextInt(0, 160);
            this.startPos[ind][1] = setOffY - GameEngine.nextInt(0, 30);
        } else {
            this.startPos[ind][0] = setOffX - GameEngine.nextInt(0, 40);
            this.startPos[ind][1] = setOffY + GameEngine.nextInt(0, 120);
        }
    }

    void flowerFree() {
        this.startPos = null;
        this.rndSpeed = null;
        flowerClipData = null;
    }

    public static void setWeather(int type) {
        weather = (short)type;
        switch (type) {
            case 0: {
                showStarTime = 0;
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                GameMap.initStar(type, -2, 0, 20, -1);
                break;
            }
        }
    }

    static {
        mapSize = new int[2];
        SCEEN_MOVE = (byte)10;
        openMini = false;
        flagMap = -1;
    }
}

