/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.util.Random;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;

public final class GameEngine {
    MyGameCanvas canvas;
    static Battle battle;
    public static GameEngine me;
    public static Equipment[] equip;
    public static Item[] item;
    public static Soul[] soul;
    public static Other[] other;
    public static Talent[] talent;
    static Skill[] skill;
    static GameSprite[] sprite;
    public static GameMap map;
    static Random rnd;
    public static byte spriteIndex;
    static byte gameRank;
    public static boolean gameFinish;
    public static int money;
    static byte[] taskMain;
    static byte[] taskSub;
    public static Vector equips;
    public static Vector items;
    public static Vector souls;
    public static Vector others;
    public static Fighter[] role;
    public static final byte ROLEMAX = 3;
    public static final byte FIGHTERMAX = 36;
    public static byte[] roleTeam;
    public static byte[] enemyTeam;
    public static byte roleIndex;
    static int injueTime;
    static boolean isBattle;
    static boolean isShowGame;
    static boolean isNoMap;
    static boolean ismove;
    static boolean on;
    static boolean erupt;
    boolean canTouch = false;
    byte touchID = (byte)-1;
    static short playX;
    static short playY;
    static short playDir;
    static boolean isVisible;
    static boolean stopBomb;
    static boolean isElite;
    static int filmSwitch;
    int filmH;
    static final int filmHight_Max = 60;
    static int flashTime;
    static int flashMode;
    static byte size;
    static int refreshIndex;
    static int isRefresh;
    static boolean isChangMap;
    static boolean isScreenFlash;
    static byte screenFlashTime;
    static int screenFlashColor;
    public static int posX;
    public static int posY;
    static boolean isToPoint;
    static boolean isShowBox;
    static boolean isToTime;
    int nextEventTime = 1500;
    int eventTime;
    byte[][] boxClip = new byte[][]{{0, 0, 13, 21}, {40, 0, 14, 23}, {14, 0, 25, 23}};
    static int shakeTime;
    static int shakeWave;
    byte areaIndex;
    boolean isAreaName;
    byte[][] buttonData = new byte[][]{{0, 1, 22, 22}, {22, 0, 24, 24}, {46, 10, 10, 14}, {57, 10, 10, 14}};
    int BHIndex = 0;
    int initIndex = 0;
    static byte initRank;
    public static final byte SK_\u8fdc\u6218 = 1;
    public static final byte SK_\u98de\u661f\u51b3 = 3;
    public static final byte SK_\u6708\u7259\u5251\u5149 = 4;
    public static final byte SK_\u70ab\u65e5\u5251 = 5;
    public static final byte SK_\u7834\u65e5\u5251 = 6;
    public static final byte SK_\u52a0\u8840 = 7;
    public static final byte SK_\u5f52\u5143\u5492 = 8;
    public static final byte SK_\u5929\u542f = 9;
    public static final byte SK_\u5e7b\u5203 = 10;
    public static final byte SK_\u9b3c\u6708 = 11;
    public static final byte SK_\u9634\u98ce\u51a5\u7075 = 12;
    public static final byte SK_\u4e07\u90aa\u5929\u706d = 13;
    public static final byte SK_\u5c0f\u55b7\u706b = 14;
    public static final byte SK_\u6bd2\u5355\u4f53 = 15;
    public static final byte SK_\u51a5\u5e7b\u8fd4\u7167 = 16;
    public static final byte SK_\u661f\u4e91\u51b0\u7206 = 17;
    public static final byte SK_\u8840\u7206 = 18;
    public static final byte SK_\u96f7\u5f15 = 19;
    public static final byte SK_\u4e94\u96f7\u8f70\u9876 = 20;
    public static final byte SK_\u5343\u7687\u96f7\u70c8 = 21;
    public static final byte SK_\u8f89\u65e5\u5723\u534e = 22;
    public static final byte SK_\u89c9\u9192 = 23;
    public static final byte SK_\u70c8\u7130\u9707\u51fb = 24;
    public static final byte SK_\u5c38\u6bd2 = 26;
    public static final byte SK_\u90aa\u5251 = 27;
    public static final byte SK_\u8840\u9b54\u8680\u4e3b = 31;
    public static final byte SK_\u5143\u5b9d = 32;
    public static final byte SK_\u9e92\u9e9f\u5410\u706b = 33;
    public static final byte SK_\u706b\u7403 = 34;
    public static final byte SK_\u6444\u9b42 = 35;
    public static final byte SK_\u722a\u75d5 = 36;
    public static final byte SK_\u5c01\u5370 = 37;
    public static final byte SK_\u8fdc\u62182 = 38;
    public static final byte SK_\u8fdc\u62183 = 39;
    public static final byte SK_\u8fdc\u62184 = 40;
    public static final byte SK_\u8fdc\u62185 = 41;
    public static final byte SK_\u8fdc\u62186 = 42;
    int skillFinshTime;
    int skillTime;
    short ex;
    short ey;
    boolean isOver = true;
    int h;
    int qilinx = 0;
    private static Vector vEnemys;
    String[] tings = new String[]{"\u5355\u4f53\u6062\u590d200\u70b9\u53ca20%\u7684\u989d\u5916\u751f\u547d\u503c", "\u5355\u4f53\u6062\u590d1000\u70b9\u53ca60%\u7684\u989d\u5916\u751f\u547d\u503c", "\u5355\u4f53\u6062\u590d150\u70b9\u53ca20%\u7684\u989d\u5916\u7075\u529b\u503c", "\u5355\u4f53\u6062\u590d800\u70b9\u53ca60%\u7684\u989d\u5916\u7075\u529b\u503c", "\u7fa4\u4f53\u6062\u590d1000\u70b9\u53ca50%\u7684\u989d\u5916\u751f\u547d\u503c", "\u7fa4\u4f53\u6062\u590d1000\u70b9\u53ca50%\u7684\u989d\u5916\u7075\u529b\u503c", "\u5355\u4f53\u6062\u590d800\u70b9\u751f\u547d\u503c\u548c600\u70b9\u7075\u529b\u503c", "\u5355\u4f53\u6062\u590d60%\u751f\u547d\u503c\u548c50%\u70b9\u7075\u529b\u503c", "\u5355\u4f53\u89e3\u9664\u6240\u6709\u4e0d\u826f\u72b6\u6001\uff0c\u5b8c\u5168\u6062\u590d", "\u590d\u6d3b\u5355\u4f53\u89d2\u8272\uff0c\u751f\u547d\uff0c\u7075\u529b\u5404\u6062\u590d200\u70b9\u53ca\u989d\u5916\u768420%", "\u89e3\u9664\u6240\u6709\u4e0d\u826f\u72b6\u6001", "\u4f7f\u7528\u540e\u589e\u52a01\u70b9\u6f5c\u529b"};
    byte jn = 1;
    short[][] bombs;
    static boolean showBomb;
    public static final int RANK_MOVE = 12;
    public static final int RANK_ATTACK = 31;
    public static final int BOMB_SPEED = 4;
    public static final byte FOLLOW_MAX = 10;
    public static final byte BOMB_X = 0;
    public static final byte BOMB_Y = 1;
    public static final byte BOMB_DIR = 2;
    public static final byte BOMB_ST = 3;
    public static final byte BOMB_RANK = 4;
    public static final byte BOMB_INDEX = 5;
    public static final byte BOMB_COUNT = 6;
    public static final byte BOMB_TYPE = 7;
    public static final byte BST_STOP = 0;
    public static final byte BST_MOVE = 1;
    public static final byte BST_FOLLOW = 2;
    public static final byte BST_ATTACK = 3;
    public static final byte BST_DEAD = 4;
    public static final byte DIR_RIGHT = 0;
    public static final byte DIR_LEFT = 1;
    public static final byte DIR_DOWN = 2;
    public static final byte DIR_UP = 3;
    static int iconIndex;
    static boolean showIcon;
    static int iconID;
    static byte lightIndex;
    static boolean showLight;
    static short lightX;
    static short lightY;
    static boolean beSmall;
    static byte holeIndex;
    static boolean showHole;
    static short holeX;
    static short holeY;
    static boolean smallHole;
    static final short COUNT = 150;
    static final short DEPTH = 100;
    static int centerX;
    static int centerY;
    static short[] x;
    static short[] y;
    static short[] z;
    static boolean isOpen;
    static short[] Pillars;
    static Event event;
    static int path;
    byte[][] FlameArray = new byte[][]{{0, 103, 18, 28}, {19, 103, 19, 27}, {39, 103, 18, 27}, {62, 110, 13, 20}, {76, 110, 14, 20}, {91, 110, 13, 20}};
    byte[][] swordData = new byte[][]{{30, 0, 11, 22}, {25, 0, 5, 61}, {10, 0, 15, 61}, {0, 0, 10, 61}};
    int runIndex = 0;
    int bglen = 240;

    public GameEngine() {
        me = this;
        this.canvas = MyGameCanvas.me;
        map = new GameMap(this, 320, 240);
        battle = new Battle(this);
    }

    public static void loadTasks() {
        String[] str = Event.splitString(Script.loadTxt("/task.txt"), "\n");
        int len = str.length;
        GameData.tasks = new String[len][2];
        int i = 0;
        while (i < len) {
            GameData.tasks[i] = Event.splitString(str[i], " ");
            ++i;
        }
    }

    public static int getTaskIndex(String key) {
        int i = 0;
        while (i < GameData.tasks.length) {
            if (key.equals(GameData.tasks[i][0])) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static void addTask(int id, boolean isMain) {
        if (id != -1) {
            if (isMain) {
                taskMain = GameEngine.addData(taskMain, (byte)id);
            } else {
                taskSub = GameEngine.addData(taskSub, (byte)id);
            }
        }
    }

    public static void delTask(int id, boolean isMain) {
        if (isMain) {
            taskMain = GameEngine.removeData(taskMain, (byte)id);
        } else {
            taskSub = GameEngine.removeData(taskSub, (byte)id);
        }
    }

    public static void setGameFinish() {
        MyGameCanvas.setST((byte)14);
        gameFinish = true;
    }

    public void ctrlReleased(int keyCode) {
        sprite[spriteIndex].ctrlRelease();
    }

    public void ctrlPlay(int keyCode) {
        sprite[spriteIndex].ctrl(keyCode);
    }

    public int hitSprite(int x, int y) {
        if (sprite.length <= 1) {
            return -1;
        }
        int i = 0;
        while (i < sprite.length) {
            if (i != spriteIndex && GameEngine.sprite[i].visible && !GameEngine.sprite[i].isPass) {
                switch (GameEngine.sprite[i].modle) {
                    case 39: {
                        if (x != GameEngine.sprite[i].ax && x != GameEngine.sprite[i].ax - 16 || y != GameEngine.sprite[i].ay && y != GameEngine.sprite[i].ay - 16) break;
                        return i;
                    }
                    case 41: 
                    case 44: {
                        if (x != GameEngine.sprite[i].ax || y != GameEngine.sprite[i].ay && y != GameEngine.sprite[i].ay - 16) break;
                        return i;
                    }
                    case 45: {
                        if (x != GameEngine.sprite[i].ax && x != GameEngine.sprite[i].ax + 16 && x != GameEngine.sprite[i].ax - 16 || y != GameEngine.sprite[i].ay && y != GameEngine.sprite[i].ay - 32 && y != GameEngine.sprite[i].ay - 16) break;
                        return i;
                    }
                    case 34: {
                        if (x != GameEngine.sprite[i].ax - 32 && x != GameEngine.sprite[i].ax && x != GameEngine.sprite[i].ax - 16 && x != GameEngine.sprite[i].ax + 16 || y != GameEngine.sprite[i].ay && y != GameEngine.sprite[i].ay - 32) break;
                        return i;
                    }
                    case 43: {
                        if (x != GameEngine.sprite[i].ax - 32 && x != GameEngine.sprite[i].ax && x != GameEngine.sprite[i].ax - 16 && x != GameEngine.sprite[i].ax + 16 && x != GameEngine.sprite[i].ax + 16 && x != GameEngine.sprite[i].ax + 32 && x != GameEngine.sprite[i].ax + 48 && x != GameEngine.sprite[i].ax - 48 || y != GameEngine.sprite[i].ay && y != GameEngine.sprite[i].ay - 32 && y != GameEngine.sprite[i].ay - 16) break;
                        return i;
                    }
                    case 37: {
                        this.canTouch = false;
                        int posX = GameEngine.sprite[i].x;
                        int posY = GameEngine.sprite[i].y;
                        switch (GameEngine.sprite[GameEngine.spriteIndex].dir) {
                            case 2: {
                                posX += 0;
                                posY -= 16;
                                break;
                            }
                            case 0: {
                                posX += 0;
                                posY += 16;
                                break;
                            }
                            case 1: {
                                posX -= 16;
                                posY += 0;
                                break;
                            }
                            case 3: {
                                posX += 16;
                                posY += 0;
                            }
                        }
                        if (GameEngine.sprite[GameEngine.spriteIndex].x >= posX && GameEngine.sprite[GameEngine.spriteIndex].x <= posX + 16 && GameEngine.sprite[GameEngine.spriteIndex].y <= posY && GameEngine.sprite[GameEngine.spriteIndex].y >= posY - 16) {
                            this.canTouch = true;
                            this.touchID = (byte)i;
                        }
                        if (x != GameEngine.sprite[i].ax && x != GameEngine.sprite[i].ax + 16 || y != GameEngine.sprite[i].ay && y != GameEngine.sprite[i].ay - 16) break;
                        return i;
                    }
                    case 38: {
                        if (x != GameEngine.sprite[i].ax + 32 && x != GameEngine.sprite[i].ax && x != GameEngine.sprite[i].ax - 32 && x != GameEngine.sprite[i].ax - 16 && x != GameEngine.sprite[i].ax + 16 || y != GameEngine.sprite[i].ay && y != GameEngine.sprite[i].ay - 16) break;
                        return i;
                    }
                    default: {
                        if (x != GameEngine.sprite[i].ax || y != GameEngine.sprite[i].ay) break;
                        return i;
                    }
                }
            }
            ++i;
        }
        return -1;
    }

    public void initSpirateXY() {
        if (playX == -1 || playY == -1 || playDir == -1) {
            return;
        }
        GameEngine.sprite[GameEngine.spriteIndex].x = playX;
        GameEngine.sprite[GameEngine.spriteIndex].y = playY;
        short s = playDir;
        GameEngine.sprite[GameEngine.spriteIndex].nextFaceDir = s;
        GameEngine.sprite[GameEngine.spriteIndex].faceDir = s;
        GameEngine.sprite[GameEngine.spriteIndex].dir = s;
        GameEngine.sprite[GameEngine.spriteIndex].nextDir = s;
        GameEngine.sprite[GameEngine.spriteIndex].visible = isVisible;
        sprite[spriteIndex].setAXY();
    }

    public static void setPlayXY(int x, int y, int dir, boolean visible) {
        playX = (short)x;
        playY = (short)y;
        playDir = (short)dir;
        isVisible = visible;
    }

    public static void initSprite(short[][] npc) {
        sprite = null;
        if (npc == null) {
            System.out.println("Load npc Data Fail");
            return;
        }
        sprite = new GameSprite[npc.length];
        int i = 0;
        while (i < sprite.length) {
            GameEngine.sprite[i] = new GameSprite(me, i);
            sprite[i].init(npc[i]);
            ++i;
        }
    }

    public void moveSprite() {
        if (sprite != null) {
            int i = 0;
            while (i < sprite.length) {
                sprite[i].run();
                ++i;
            }
        }
    }

    public void drawSprite(Graphics g) {
        if (sprite != null) {
            int i = 0;
            while (i < sprite.length) {
                sprite[i].paint();
                ++i;
            }
        }
    }

    public void bomb(boolean elite) {
        isElite = elite;
        this.getEnemyTeam();
        sprite[spriteIndex].setStates(-1);
        Battle.canEscape = true;
        Battle.canLose = false;
        Battle.curBattleEvent = (byte)-1;
        Battle.stopBattle = false;
        MyGameCanvas.setST((byte)20);
    }

    void getEnemyTeam() {
        enemyTeam = null;
        int totalEnemy = this.getEnemyTeamLen();
        enemyTeam = new byte[totalEnemy];
        short[] emys = Event.getArray(GameEngine.map.enemys);
        int i = 0;
        while (i < totalEnemy) {
            GameEngine.enemyTeam[i] = (byte)emys[GameEngine.nextInt(emys.length - 1)];
            ++i;
        }
        if (totalEnemy == 3) {
            if (enemyTeam[0] == enemyTeam[1]) {
                byte temp = enemyTeam[1];
                GameEngine.enemyTeam[1] = enemyTeam[2];
                GameEngine.enemyTeam[2] = temp;
            } else if (enemyTeam[1] == enemyTeam[2]) {
                byte temp = enemyTeam[0];
                GameEngine.enemyTeam[0] = enemyTeam[1];
                GameEngine.enemyTeam[1] = temp;
            }
        }
    }

    int getEnemyTeamLen() {
        switch (roleTeam.length) {
            case 1: {
                return GameEngine.nextInt(1, 2);
            }
        }
        return GameEngine.nextInt(2, 3);
    }

    public void drawFilm() {
        this.filmH += filmSwitch * 5;
        if (this.filmH < 0) {
            this.filmH = 0;
            filmSwitch = 0;
            GameEngine.finish();
        } else if (this.filmH > 60) {
            this.filmH = 60;
            filmSwitch = 0;
            GameEngine.finish();
        }
    }

    public void drawGame(Graphics g) {
        if (flashTime != 0) {
            if (flashTime > 0) {
                --flashTime;
            }
            int col = 0;
            switch (flashMode) {
                case 0: {
                    col = GameMIDlet.gameIndex % 2 == 0 ? 0 : 0xFFFFFF;
                    break;
                }
                case 1: {
                    int n = col = GameMIDlet.gameIndex % 2 == 0 ? -1 : 0xFF0000;
                }
            }
            if (col != -1) {
                Tools.addRect((byte)1, GameMap.setOffX, GameMap.setOffY, 320, 240, true, 20, col, 5000);
                return;
            }
        }
        if (isNoMap) {
            map.setMap(g);
        } else {
            GameEngine.drawColorScreenBG(0, 0);
        }
        this.drawHole();
        this.drawSprite(g);
        if (erupt) {
            this.drawRoleFire(GameEngine.sprite[GameEngine.spriteIndex].x - 8, GameEngine.sprite[GameEngine.spriteIndex].y - 84, GameEngine.sprite[GameEngine.spriteIndex].y);
        }
        this.drawBomb();
        this.drawLight();
        if (!GameMap.blackBG && isNoMap) {
            map.drawWeather(2000);
        }
        this.drawInterFace(g, GameMap.setOffX, GameMap.setOffY, 5000);
        this.drawIcon(GameMap.setOffX, GameMap.setOffY + 20, 2000);
        if (isScreenFlash) {
            MyGameCanvas.drawOpenEft();
        }
        this.drawFilm();
        if (!isShowGame) {
            Tools.addRect((byte)1, GameMap.setOffX, GameMap.setOffY, 320, 240, true, 20, 0, 5000);
        }
        switch (isRefresh) {
            case -1: {
                GameEngine.drawPassEffect(5000);
                break;
            }
            case 1: {
                GameEngine.drawStartEffect(5000);
                break;
            }
            case 2: {
                Tools.addRect((byte)1, GameMap.setOffX, GameMap.setOffY, 320, 240, true, 20, 0, 5000);
            }
        }
    }

    static void drawStartEffect(int lev) {
        int col;
        int hyp = 320 / size + 1;
        int speed = 3;
        int n = col = gameRank == 26 ? 0xFFFFFF : 0;
        if (refreshIndex <= hyp + size / speed) {
            int i = 0;
            while (i < hyp) {
                if (refreshIndex >= i) {
                    Tools.addRect((byte)1, GameMap.setOffX + speed * (refreshIndex - i) + i * size, GameMap.setOffY, Math.max(0, 12 - (refreshIndex - i) * speed), 240, true, 20, col, lev);
                } else {
                    Tools.addRect((byte)1, GameMap.setOffX + i * size, GameMap.setOffY, size, 240, true, 20, col, lev);
                }
                ++i;
            }
            ++refreshIndex;
        } else {
            isRefresh = 0;
            GameEngine.finish();
        }
    }

    static void drawPassEffect(int lev) {
        int hyp = 320 / size + 1;
        int speed = 3;
        int i = 0;
        while (i < hyp) {
            Tools.addRect((byte)1, GameMap.setOffX + i * size, GameMap.setOffY, Math.max(0, Math.min(size, (refreshIndex - i) * speed)), 240, true, 20, 0, lev);
            ++i;
        }
        if (++refreshIndex > hyp + size / speed) {
            isRefresh = 2;
            GameEngine.finish();
        }
    }

    public static int getItemNum(Vector myPack, ItemInterface[] items, int type) {
        int i = myPack.size() - 1;
        while (i >= 0) {
            short[] temp = (short[])myPack.elementAt(i);
            if (temp[0] == type) {
                return temp[1];
            }
            --i;
        }
        return 0;
    }

    public static int getSoulNum(Vector myPack, ItemInterface[] items, int type) {
        int i = myPack.size() - 1;
        while (i >= 0) {
            short[] temp = (short[])myPack.elementAt(i);
            if (temp[0] == type && temp[2] == 0) {
                return temp[1];
            }
            --i;
        }
        return 0;
    }

    public static void getMoney(int num) {
        money += num;
        money = Math.max(0, money);
    }

    public static void setRankEnd(int id) {
        MyGameCanvas.setST((byte)14);
        isChangMap = true;
        gameRank = (byte)id;
        Event.isChangeMap = false;
    }

    public void drawScreenFlash() {
        if (screenFlashTime != 0 && (screenFlashTime = (byte)(screenFlashTime - 1)) % 2 != 0) {
            Tools.addRect((byte)1, GameMap.setOffX, GameMap.setOffY, GameMap.screenWidth, GameMap.screenHeight, true, 20, screenFlashColor, 9000);
        }
    }

    static void setScreenFlash(int time, int color) {
        screenFlashTime = (byte)(time * 2);
        screenFlashColor = color;
    }

    public void runGame() {
        if (MyGameCanvas.chargeDelay == 0) {
            Script.runScript();
        }
        this.moveBomb();
        this.run();
        if (!MyGameCanvas.isJump) {
            this.runSpecialEvent();
        }
    }

    public void run() {
        this.moveSprite();
        if (!isToPoint) {
            posX = GameEngine.sprite[GameEngine.spriteIndex].sx + GameMap.tileWidth / 2;
            posY = GameEngine.sprite[GameEngine.spriteIndex].sy - GameMap.tileWidth / 2;
        }
        map.moveSrceen(posX, posY);
        GameEngine.screenShake();
    }

    void runSpecialEvent() {
        if (!Script.isUserCtrl) {
            return;
        }
        if (this.eventTime > this.nextEventTime) {
            this.eventTime = 0;
        }
        if (++this.eventTime == this.nextEventTime) {
            this.nextEventTime = 3000 + GameEngine.role[0].level / 10 * 600;
            this.eventTime = 0;
        }
        if (isShowBox) {
            String secStr2;
            int sec = GameMIDlet.sleepTime * (this.nextEventTime - this.eventTime) / 1000;
            String secStr1 = sec / 60 > 9 ? sec / 60 + "" : "0" + sec / 60;
            String string = secStr2 = sec % 60 > 9 ? sec % 60 + "" : "0" + sec % 60;
            if (!isToTime && secStr1.equals("00") && secStr2.equals("00")) {
                isToTime = true;
                MyGameCanvas.setInfo("\u63093\u53f7\u952e\u9886\u53d6\u793c\u7269");
            }
            this.drawBox(GameMap.setOffX, GameMap.setOffY);
            if (!isToTime) {
                this.drawTime(sec, GameMap.setOffX + 320 - 48, GameMap.setOffY + 22);
            }
        }
    }

    void drawBox(int x, int y) {
        byte[] motion1 = new byte[]{0, 0, 1, 1};
        Tools.addRect((byte)1, x + 320 - 70, y + 5, 70, 25, true, 20, 65536, 9999);
        if (isToTime) {
            byte var = (byte)(GameMIDlet.gameIndex % 60);
            if (var < 3) {
                Tools.addImage(203, x + 320 - 69, y + 30, this.boxClip[1], 36, (byte)0, 9999);
                Tools.addImage(203, x + 320 - 69 + 14, y + 30, this.boxClip[1], 36, (byte)1, 9999);
            } else {
                Tools.addImage(203, x + 320 - 68, y + 30, this.boxClip[2], 36, (byte)0, 9999);
                Tools.addImage(320, x + 320 - 71, y + 28, 36 * (GameMIDlet.gameIndex % 3), 0, 33, 28, 36, (byte)0, 9999);
            }
            this.drawButton(x + 320 - 35, y + 28, GameMIDlet.gameIndex % 2 == 0, 3, 9999);
        } else {
            byte var = motion1[GameMIDlet.gameIndex % 4];
            Tools.addImage(203, x + 320 - 68 - (var == 0 ? 0 : 1), y + 30, this.boxClip[var], 36, (byte)0, 9999);
            Tools.addImage(203, x + 320 - 68 - (var == 0 ? 0 : 1) + (var == 0 ? 13 : 14), y + 30, this.boxClip[var], 36, (byte)1, 9999);
        }
    }

    void drawTime(int sec, int x, int y) {
        if (sec / 60 > 9) {
            Tools.addImage(255, x + 8, y, sec / 60 / 10 * 7, 0, 7, 10, 36, (byte)0, 9999);
            Tools.addImage(255, x + 16, y, sec / 60 % 10 * 7, 0, 7, 10, 36, (byte)0, 9999);
        } else {
            Tools.addImage(255, x + 8, y, 0, 0, 7, 10, 36, (byte)0, 9999);
            Tools.addImage(255, x + 16, y, sec / 60 * 7, 0, 7, 10, 36, (byte)0, 9999);
        }
        Tools.addImage(260, x + 24, y, 26, 4, 4, 9, 36, (byte)0, 9999);
        if (sec % 60 > 9) {
            Tools.addImage(255, x + 32, y, sec % 60 / 10 * 7, 0, 7, 10, 36, (byte)0, 9999);
            Tools.addImage(255, x + 40, y, sec % 60 % 10 * 7, 0, 7, 10, 36, (byte)0, 9999);
        } else {
            Tools.addImage(255, x + 32, y, 0, 0, 7, 10, 36, (byte)0, 9999);
            Tools.addImage(255, x + 40, y, sec % 60 * 7, 0, 7, 10, 36, (byte)0, 9999);
        }
    }

    void getGift() {
        int rand = GameEngine.nextInt(81);
        if (rand < 30) {
            int num = GameEngine.role[0].level * 10;
            MyGameCanvas.setGiftAbout("\u83b7\u5f97\u91d1\u94b1" + num);
            GameEngine.getMoney(num);
        } else if (rand < 60) {
            int num = GameEngine.role[0].level * 10;
            MyGameCanvas.setGiftAbout("\u83b7\u5f97\u7ecf\u9a8c" + num + "\u70b9");
            int i = 0;
            while (i < role.length) {
                GameEngine.role[i].exp = Math.min(GameEngine.role[i].exp_max - 1, GameEngine.role[i].exp + num);
                ++i;
            }
        } else if (rand < 75) {
            int type = 0;
            type = GameEngine.role[0].level < 10 ? (Tools.percent(50) ? 0 : 5) : (GameEngine.role[0].level < 20 ? (Tools.percent(50) ? 1 : 6) : (GameEngine.role[0].level < 20 ? (Tools.percent(50) ? 2 : 7) : (Tools.percent(50) ? 3 : 8)));
            GameEngine.getItem(items, item, type, 2, true);
        } else if (rand < 78) {
            GameEngine.getItem(items, item, 10, 1, true);
        } else {
            GameEngine.getItem(items, item, 8, 1, true);
        }
    }

    static void toChooseStatus(String chooseTitle, String[] options, boolean rs) {
        MyGameCanvas.title = chooseTitle;
        MyGameCanvas.option = options;
        MyGameCanvas.choice = 0;
        MyGameCanvas.setST((byte)11);
        MyGameCanvas.canUseRS = rs;
    }

    public static void toBlackStatus(int cgName, String content) {
        MyGameCanvas.canPass = false;
        MyGameCanvas.index = 0;
        MyGameCanvas.setST((byte)25);
        MyGameCanvas.blackWord = content.equals("null") ? null : (cgName != 0 ? MyGameCanvas.changeString(content, 7) : MyGameCanvas.changeString(content, 11));
        MyGameCanvas.cgImgID = (short)-1;
        short[] img = new short[]{217, 214, 218, 209, 208, 212, 216, 211, 213, 215, 207, 210};
        if (cgName - 1 < 0) {
            cgName = 0;
        }
        if (cgName != 0) {
            MyGameCanvas.cgImgID = img[cgName - 1];
        }
    }

    public static void screenShake() {
        if (shakeTime == 0) {
            return;
        }
        if (shakeTime > 0) {
            --shakeTime;
        }
        GameMap.setOffY = MyGameCanvas.gameTime % 2 == 0 ? GameMap.setOffY + shakeWave : GameMap.setOffY - shakeWave;
    }

    public static int nextInt(int n) {
        return Math.abs(rnd.nextInt()) % (n + 1);
    }

    public static int nextInt(int n, int m) {
        if (n == m) {
            return n;
        }
        if (n > m) {
            int temp = n;
            n = m;
            m = temp;
        }
        return Math.abs(rnd.nextInt()) % (m - n + 1) + n;
    }

    void drawAreaName(int x, int y, int lev) {
        byte[] areaNameY = new byte[]{-30, -24, -20, -16, -12, -8, -4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -4, -8, -12, -16, -20, -24, -30};
        String mapName = Event.getString(GameEngine.map.mapName);
        byte len = (byte)mapName.length();
        MyGameCanvas.drawFrame_3((short)333, GameData.imgDatFr0, x, y + areaNameY[this.areaIndex], len * 20 + 16, 24, 0x191919, lev);
        Tools.addString((byte)4, mapName, x + (len * 20 + 16) / 2, y + 2 + 10 + areaNameY[this.areaIndex], 33, 0xFFFFFF, lev);
        this.areaIndex = (byte)(this.areaIndex + 1);
        if (this.areaIndex >= areaNameY.length) {
            this.areaIndex = 0;
            this.isAreaName = false;
        }
    }

    public void drawButton(int x, int y, boolean on, int num, int lev) {
        if (on) {
            Tools.addImage(45, x, y, this.buttonData[1], 36, (byte)0, lev);
            Tools.addImage(45, x + 1, y - 1, this.buttonData[0], 36, (byte)0, lev);
            switch (num) {
                case 3: {
                    Tools.addImage(45, x + 7, y - 5, this.buttonData[2], 36, (byte)0, lev);
                    break;
                }
                case 5: {
                    Tools.addImage(45, x + 7, y - 5, this.buttonData[3], 36, (byte)0, lev);
                }
            }
        } else {
            Tools.addImage(45, x, y, this.buttonData[1], 36, (byte)0, lev);
            Tools.addImage(45, x + 1, y - 3, this.buttonData[0], 36, (byte)0, lev);
            switch (num) {
                case 3: {
                    Tools.addImage(45, x + 7, y - 7, this.buttonData[2], 36, (byte)0, lev);
                    break;
                }
                case 5: {
                    Tools.addImage(45, x + 7, y - 7, this.buttonData[3], 36, (byte)0, lev);
                }
            }
        }
    }

    final void drawInterFace(Graphics g, int x, int y, int lev) {
        if (MyGameCanvas.isJump) {
            this.canvas.drawJump();
        } else if (MyGameCanvas.showBlackHole) {
            this.canvas.drawBlackHole();
        } else {
            if (this.isAreaName) {
                this.drawAreaName(x, y, lev);
            }
            if (this.canTouch && GameEngine.sprite[this.touchID].curStates == -1) {
                this.drawButton(GameEngine.sprite[GameEngine.spriteIndex].ax - 2, GameEngine.sprite[GameEngine.spriteIndex].ay - 48, GameMIDlet.gameIndex % 6 == 0, 5, 1000);
            }
        }
    }

    public void drawBlackHole(int x, int y) {
        int w = 13;
        int h = 10;
        ++this.BHIndex;
        Tools.addARC((byte)2, x - w / 2, y - h / 2, w, h, 0, 360, true, 20, 0, 30);
    }

    void free() {
        Tools.removeAllSinleImage(new int[0]);
        Tools.removeAllGroupImage(new int[0]);
        enemyTeam = null;
        battle.free();
        map.free();
        Script.free();
        Effect.EffectV.removeAllElements();
        System.gc();
    }

    public boolean initGame() {
        switch (this.initIndex) {
            case 1: {
                this.free();
                break;
            }
            case 10: {
                showLight = false;
                showHole = false;
                filmSwitch = 0;
                gameFinish = false;
                GameMap.setOff(0, 0);
                roleIndex = 0;
                isToPoint = false;
                Battle.canLose = false;
                GameMap.SCEEN_MOVE = (byte)10;
                Battle.canEscape = true;
                MyGameCanvas.gameTime = 0;
                spriteIndex = 0;
                isBattle = false;
                if (!God.canMissBomb) {
                    stopBomb = false;
                }
                Battle.stopBattle = false;
                isShowGame = true;
                isNoMap = true;
                break;
            }
            case 15: {
                break;
            }
            case 20: {
                if (!isChangMap) break;
                try {
                    Script.loadScript(gameRank);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                isChangMap = false;
                break;
            }
            case 25: {
                this.initSpirateXY();
                break;
            }
            case 30: {
                map.initMap();
                Sound.playmusic(GameMap.BGM, -1);
                break;
            }
            case 35: {
                this.initBomb();
                isChangMap = false;
                break;
            }
            case 38: {
                System.gc();
                break;
            }
            case 40: {
                return Script.runInitEvent();
            }
        }
        ++this.initIndex;
        return false;
    }

    public void allInit() {
        playX = (short)-1;
        playY = (short)-1;
        playDir = (short)-1;
        gameRank = initRank;
        gameFinish = false;
        stopBomb = false;
        taskMain = null;
        taskSub = null;
        Script.scriptVar = new byte[400];
        money = 0;
        roleTeam = new byte[]{0};
        spriteIndex = roleTeam[0];
        Battle.stopBattle = false;
        int i = 0;
        while (i < role.length) {
            role[i].initFighter((byte)i, false);
            ++i;
        }
        items.removeAllElements();
        equips.removeAllElements();
        souls.removeAllElements();
        others.removeAllElements();
        int i2 = 0;
        while (i2 < God.disc.length) {
            God.removeGod(i2);
            ++i2;
        }
        int i3 = 0;
        while (i3 < God.gods.length) {
            God.gods[i3] = God.bGods[i3];
            ++i3;
        }
        God.orders = null;
    }

    public void testAll() {
    }

    public void drawShandow(int x, int y, int w, int h, int color, int drawLevel) {
        Tools.addARC((byte)2, x - w / 2, y - h / 2, w, h, 0, 360, true, 20, color, drawLevel);
    }

    public void initBattle() {
        GameEngine.setPlayXY(GameEngine.sprite[GameEngine.spriteIndex].x, GameEngine.sprite[GameEngine.spriteIndex].y, GameEngine.sprite[GameEngine.spriteIndex].dir, GameEngine.sprite[GameEngine.spriteIndex].visible);
        map.initBattleMap();
        battle.initBattle(roleTeam, enemyTeam, isElite);
        Battle.wait = 0;
        Battle.index = 0;
        battle.setBattleST((byte)-1);
    }

    public static void getItem(Vector myPack, ItemInterface[] items, int type, int num, boolean isInfo) {
        boolean isNew = true;
        int i = myPack.size() - 1;
        while (i >= 0) {
            short[] temp = (short[])myPack.elementAt(i);
            if (temp[0] == type) {
                temp[1] = (short)Math.min(99, temp[1] + num);
                isNew = false;
                break;
            }
            --i;
        }
        if (isNew) {
            myPack.addElement(new short[]{(short)type, (short)num});
        }
        if (MyGameCanvas.showGift) {
            MyGameCanvas.setGiftAbout("\u83b7\u5f97" + items[type].name + "x" + num);
            return;
        }
        if (isInfo) {
            if (((Object)myPack).equals(others)) {
                MyGameCanvas.setInfo(" \u83b7\u5f97\u5267\u60c5\u9053\u5177#G" + items[type].name);
            } else {
                MyGameCanvas.setInfo("\u83b7\u5f97#G" + items[type].name + "#Ax" + num);
            }
        }
    }

    public static boolean dropItem(Vector myPack, int type, int num) {
        int i = myPack.size() - 1;
        while (i >= 0) {
            short[] temp = (short[])myPack.elementAt(i);
            if (temp[0] == type) {
                if (temp[1] <= num) {
                    myPack.removeElementAt(i);
                    return true;
                }
                temp[1] = (short)Math.max(0, temp[1] - num);
                return false;
            }
            --i;
        }
        return true;
    }

    public static void getEquip(int type, boolean isInfo) {
        Equipment eq = equip[type];
        switch (eq.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 5: {
                equips.addElement(new short[]{(short)type, eq.prop1, 0, 0, 0, 0, eq.power});
                break;
            }
            case 4: {
                equips.addElement(new short[]{(short)type, eq.prop1, eq.prop2, 0, 0, eq.prop3, eq.power});
            }
        }
        if (isInfo) {
            MyGameCanvas.setInfo("\u83b7\u5f97#G" + eq.name);
        }
    }

    public static void getEquip(short[] equip) {
        equips.addElement(equip);
    }

    public static void dropEqip(short[] equip) {
        equips.removeElement(equip);
    }

    public static void getSoul(int type, int quality, int lev, int num, boolean isInfo) {
        boolean isNew = true;
        int i = souls.size() - 1;
        while (i >= 0) {
            short[] temp = (short[])souls.elementAt(i);
            if (temp[0] == type && temp[2] == quality && temp[3] == lev) {
                temp[1] = (short)Math.min(99, temp[1] + num);
                isNew = false;
                break;
            }
            --i;
        }
        if (isNew) {
            souls.addElement(new short[]{(short)type, (short)num, (short)quality, (short)lev});
        }
        if (isInfo) {
            String[] col = new String[]{"#W", "#G", "#Y"};
            if (quality == 0) {
                MyGameCanvas.setInfo("\u83b7\u5f97#A" + num + "\u4e2a" + col[lev] + GameEngine.soul[type].name);
            } else {
                MyGameCanvas.setInfo("\u83b7\u5f97#A" + num + "\u4e2a" + col[lev] + GameEngine.soul[type].name + "+" + quality);
            }
        }
    }

    public static void dropSoul(int index, int num) {
        short[] temp = (short[])souls.elementAt(index);
        if (temp[1] > num) {
            temp[1] = (short)(temp[1] - num);
        } else {
            souls.removeElementAt(index);
        }
    }

    public static byte[] addData(byte[] data, byte id) {
        byte[] temp;
        if (data == null) {
            temp = new byte[]{id};
        } else {
            int len = data.length;
            temp = new byte[len + 1];
            System.arraycopy(data, 0, temp, 0, len);
            temp[len] = id;
        }
        return temp;
    }

    public static byte[] removeData(byte[] data, byte id) {
        if (data == null) {
            return data;
        }
        byte[] temp = new byte[data.length];
        int len = 0;
        int i = 0;
        while (i < data.length) {
            if (data[i] != id) {
                ++len;
            }
            ++i;
        }
        if (len == 0) {
            return null;
        }
        temp = new byte[len];
        len = 0;
        int i2 = 0;
        while (i2 < data.length) {
            if (data[i2] != id) {
                temp[len] = data[i2];
                ++len;
            }
            ++i2;
        }
        return temp;
    }

    public static void toBattle(boolean boss, boolean lost) {
        isElite = false;
        int len = vEnemys.size();
        enemyTeam = new byte[len];
        int i = 0;
        while (i < len) {
            byte[] dat = (byte[])vEnemys.elementAt(i);
            GameEngine.enemyTeam[i] = dat[0];
            ++i;
        }
        vEnemys.removeAllElements();
        Battle.canEscape = !boss;
        Battle.canLose = lost;
        MyGameCanvas.setST((byte)20);
    }

    public void initRole() {
        role = new Fighter[3];
        int i = 0;
        while (i < 3) {
            GameEngine.role[i] = new Fighter(this);
            role[i].initFighter((byte)i, false);
            ++i;
        }
    }

    static void drawColorScreenBG(int color, int drawLevel) {
        Tools.addRect((byte)1, GameMap.setOffX, GameMap.setOffY, GameMap.screenWidth, GameMap.screenHeight, true, 20, color, drawLevel);
    }

    public void drawSkillEft(int type, int isMir) {
        switch (type) {
            case 32: {
                this.skillFinshTime = 60;
                int x = 48;
                short h1 = 101;
                short h2 = 120;
                short h3 = 146;
                h1 = (short)(h1 - 10);
                h3 = (short)(h3 + 10);
                short[][] tempxy = new short[][]{{-50, h1}, {0, h2}, {50, h3}, {50, h1}, {10, h2}, {-50, h3}, {0, h2}};
                this.skillEvent(20, x + tempxy[0][0], tempxy[0][1], 46, isMir, 999);
                this.skillEvent(24, x + tempxy[0][0], tempxy[0][1], 46, isMir, 999);
                this.skillEvent(24, x + tempxy[1][0], tempxy[1][1], 46, isMir, 999);
                this.skillEvent(28, x + tempxy[1][0], tempxy[1][1], 46, isMir, 999);
                this.skillEvent(28, x + tempxy[2][0], tempxy[2][1], 46, isMir, 999);
                this.skillEvent(32, x + tempxy[2][0], tempxy[2][1], 46, isMir, 999);
                this.skillEvent(32, x + tempxy[3][0], tempxy[3][1], 46, isMir, 999);
                this.skillEvent(36, x + tempxy[3][0], tempxy[3][1], 46, isMir, 999);
                this.skillEvent(36, x + tempxy[4][0], tempxy[4][1], 46, isMir, 999);
                this.skillEvent(40, x + tempxy[4][0], tempxy[4][1], 46, isMir, 999);
                this.skillEvent(40, x + tempxy[5][0], tempxy[5][1], 46, isMir, 999);
                this.skillEvent(44, x + tempxy[5][0], tempxy[5][1], 46, isMir, 999);
                this.skillEvent(44, x + tempxy[6][0] - 40, tempxy[6][1], 46, isMir, 999);
                this.skillEvent(48, x + tempxy[6][0] - 40, tempxy[6][1], 46, isMir, 999);
                this.skillEvent(44, x + tempxy[6][0], tempxy[6][1], 46, isMir, 999);
                this.skillEvent(48, x + tempxy[6][0], tempxy[6][1], 46, isMir, 999);
                this.skillEvent(44, x + tempxy[6][0] + 40, tempxy[6][1], 5, isMir, 999);
                this.skillEvent(48, x + tempxy[6][0] + 40, tempxy[6][1], 46, isMir, 999);
                break;
            }
            case 17: {
                this.skillFinshTime = 46;
                this.skillEvent(10, GameMap.setOffX + 40, GameMap.setOffY + 76, 28, isMir, 233);
                this.skillEvent(12, GameMap.setOffX + 70, GameMap.setOffY + 100, 28, isMir, 233);
                this.skillEvent(14, GameMap.setOffX + 40, GameMap.setOffY + 150, 28, isMir, 233);
                this.skillEvent(16, GameMap.setOffX + 40, GameMap.setOffY + 76, 28, isMir, 233);
                this.skillEvent(18, GameMap.setOffX + 70, GameMap.setOffY + 100, 28, isMir, 233);
                this.skillEvent(20, GameMap.setOffX + 40, GameMap.setOffY + 150, 28, isMir, 233);
                this.skillEvent(22, GameMap.setOffX + 40, GameMap.setOffY + 76, 28, isMir, 233);
                this.skillEvent(24, GameMap.setOffX + 70, GameMap.setOffY + 100, 28, isMir, 233);
                this.skillEvent(26, GameMap.setOffX + 40, GameMap.setOffY + 150, 28, isMir, 233);
                this.skillEvent(28, GameMap.setOffX + 40, GameMap.setOffY + 76, 29, isMir, 233);
                this.skillEvent(29, GameMap.setOffX + 70, GameMap.setOffY + 100, 29, isMir, 233);
                this.skillEvent(30, GameMap.setOffX + 40, GameMap.setOffY + 150, 29, isMir, 233);
                this.skillEvent(32, GameMap.setOffX + 40, GameMap.setOffY + 76, 29, isMir, 233);
                this.skillEvent(33, GameMap.setOffX + 70, GameMap.setOffY + 100, 29, isMir, 233);
                this.skillEvent(34, GameMap.setOffX + 40, GameMap.setOffY + 150, 29, isMir, 233);
                this.skillEvent(36, GameMap.setOffX + 40, GameMap.setOffY + 76, 29, isMir, 233);
                this.skillEvent(37, GameMap.setOffX + 70, GameMap.setOffY + 100, 29, isMir, 233);
                this.skillEvent(38, GameMap.setOffX + 40, GameMap.setOffY + 150, 29, isMir, 233);
                this.skillEvent(40, GameMap.setOffX + 40, GameMap.setOffY + 76, 29, isMir, 233);
                this.skillEvent(41, GameMap.setOffX + 70, GameMap.setOffY + 100, 29, isMir, 233);
                this.skillEvent(42, GameMap.setOffX + 40, GameMap.setOffY + 150, 29, isMir, 233);
                break;
            }
            case 13: {
                this.skillFinshTime = 70;
                int tempx = GameMap.setOffX;
                int tempy = GameMap.setOffY + 30;
                if (this.skillTime == 60) {
                    shakeTime = 4;
                }
                if (this.skillTime > 7 && this.skillTime < 35) {
                    Tools.addRect((byte)1, GameMap.setOffX, GameMap.setOffY, GameMap.screenWidth, GameMap.screenHeight, true, 20, 0, 2000);
                }
                this.skillEvent(10, tempx + 150, tempy + 90, 34, isMir, 2000);
                this.skillEvent(11, tempx + 90, tempy + 12, 35, isMir, 2000);
                this.skillEvent(12, tempx + 45, tempy + 50, 35, isMir, 2000);
                this.skillEvent(14, tempx + 135, tempy + 50, 35, isMir, 2000);
                this.skillEvent(15, tempx + 163, tempy + 17, 35, isMir, 2000);
                this.skillEvent(16, tempx + 16, tempy + 20, 35, 1, 2000);
                this.skillEvent(21, tempx + 135, tempy + 50, 35, isMir, 2000);
                this.skillEvent(22, tempx + 16, tempy + 20, 35, 1, 2000);
                this.skillEvent(23, tempx + 88, tempy + 12, 35, isMir, 2000);
                this.skillEvent(25, tempx + 70, tempy + 76, 35, isMir, 2000);
                this.skillEvent(27, tempx + 12, tempy + 80, 35, 1, 2000);
                this.skillEvent(27, tempx + 70, tempy + 58, 35, isMir, 2000);
                if (this.skillTime != 33 && this.skillTime != 34) break;
                Tools.addRect((byte)1, GameMap.setOffX, GameMap.setOffY, GameMap.screenWidth, GameMap.screenHeight, true, 20, 0xFFFFFF, 2001);
                break;
            }
            case 21: {
                this.skillFinshTime = 80;
                GameEngine.drawColorScreenBG(0, 20);
                int tempx = isMir == 1 ? GameMap.screenWidth - 48 : 48;
                int tempy = 120;
                if (this.skillTime == 21) {
                    shakeTime = 58;
                }
                int j = 0;
                while (j < 31) {
                    this.skillEvent(20 + j, tempx - 40, 120, 23, isMir, 30);
                    this.skillEvent(26 + j, tempx - 40, 120, 50, isMir, 30);
                    this.skillEvent(25 + j, tempx, 101, 23, isMir, 30);
                    this.skillEvent(31 + j, tempx, 101, 50, isMir, 30);
                    this.skillEvent(30 + j, tempx - 40, 156, 23, isMir, 30);
                    this.skillEvent(36 + j, tempx - 40, 156, 50, isMir, 30);
                    this.skillEvent(35 + j, tempx, 120, 23, isMir, 30);
                    this.skillEvent(41 + j, tempx, 120, 50, isMir, 30);
                    this.skillEvent(40 + j, tempx - 60, 101, 23, isMir, 30);
                    this.skillEvent(46 + j, tempx - 60, 101, 50, isMir, 30);
                    j += 30;
                }
                break;
            }
            case 18: {
                this.skillFinshTime = 60;
                this.skillEvent(15, GameMap.setOffX + 56, GameMap.setOffY + 88, 31, isMir, 233);
                this.skillEvent(36, GameMap.setOffX + 56, GameMap.setOffY + 113, 32, isMir, 233);
                this.skillEvent(37, GameMap.setOffX + 56 - 33, GameMap.setOffY + 113 - 35, 32, isMir, 233);
                this.skillEvent(38, GameMap.setOffX + 60, GameMap.setOffY + 113, 32, isMir, 233);
                this.skillEvent(38, GameMap.setOffX + 10, GameMap.setOffY + 113 + 10, 32, isMir, 233);
                this.skillEvent(40, GameMap.setOffX + 10, GameMap.setOffY + 143, 32, isMir, 233);
                this.skillEvent(43, GameMap.setOffX + 30, GameMap.setOffY + 110, 32, isMir, 233);
                this.skillEvent(46, GameMap.setOffX + 60, GameMap.setOffY + 150, 32, isMir, 233);
                this.skillEvent(50, GameMap.setOffX + 5, GameMap.setOffY + 130, 32, isMir, 233);
            }
        }
        if (++this.skillTime >= this.skillFinshTime) {
            this.skillFinshTime = 0;
            this.skillTime = 0;
            if (this.isOver) {
                this.actionOver();
            }
            this.isOver = true;
            return;
        }
    }

    public void drawRect(int x, int y, int h, int drawLev) {
        Tools.addRect((byte)1, x, y, 60, h, true, 20, 16306264, drawLev);
        Tools.addRect((byte)1, x + 1, y, 58, h, true, 20, 16312464, drawLev);
        Tools.addRect((byte)1, x + 2, y, 56, h, true, 20, 16314528, drawLev);
        Tools.addRect((byte)1, x + 3, y, 54, h, true, 20, 0xF8F8C8, drawLev);
        Tools.addRect((byte)1, x + 6, y, 48, h, true, 20, 0xFFFFFF, drawLev);
    }

    public void drawSkillEft(int type, Fighter[] f, Fighter role, int isMir) {
        int i = 0;
        while (i < f.length) {
            switch (type) {
                case 3: {
                    this.skillFinshTime = 160;
                    this.skillEvent(0, role.x + 10, role.y - 35, 16, 0, role.y + 30);
                    if (this.skillTime >= 11 && this.skillTime <= 17) {
                        f[i].move(f[i].bx - (this.skillTime - 10) * 15, f[i].by);
                        role.move(role.bx - 80 - (this.skillTime - 10) * 15, role.y);
                    }
                    int tx = 0;
                    if (this.skillTime >= 36 && this.skillTime <= 71) {
                        tx = -(this.skillTime - 36) * 2;
                    } else if (this.skillTime > 71) {
                        tx = -70;
                    }
                    if (this.skillTime >= 18 && this.skillTime <= 20) {
                        GameEngine.drawColorScreenBG(this.skillTime % 2 == 0 ? 0 : 0xFFFFFF, 9000);
                        Battle.cleanFighter();
                    }
                    if (this.skillTime == 20) {
                        f[i].move(185 - this.skillTime * 2, 120);
                        role.move(250 - this.skillTime * 2, 120);
                    }
                    if (this.skillTime > 36) {
                        f[i].move(145 + tx, 120);
                        role.move(210 + tx, 120);
                    }
                    if (this.skillTime > 20 && this.skillTime < 30) {
                        GameEngine.drawColorScreenBG(0xFFFFFF, 9999);
                    }
                    if (this.skillTime >= 20 && this.skillTime <= 130) {
                        GameEngine.drawColorScreenBG(0, 20);
                        this.drawSpace(GameMap.setOffX, GameMap.setOffY + 10, 20);
                    }
                    int j = 0;
                    while (j < 10) {
                        this.skillEvent(80 + j, role.x, role.y - 33, 10, 0, role.y + 30 + 1000);
                        j += 5;
                    }
                    this.skillEvent(98, role.x - 21, role.y - 57, 16, 0, role.y + 30 + 1000);
                    this.skillEvent(101, role.x - 21 - 4, role.y - 57 - 8, 16, 0, role.y + 30 + 1000);
                    this.skillEvent(104, role.x - 21 - 4 - 2, role.y - 57 - 8 - 7, 16, 0, role.y + 30 + 1000);
                    this.skillEvent(107, role.x - 21 - 4 - 2 - 2, role.y - 57 - 8 - 7 - 8, 16, 0, role.y + 30 + 1000);
                    this.skillEvent(110, role.x - 21 - 4 - 2 - 2 - 2, role.y - 57 - 8 - 7 - 8 - 7, 16, 0, role.y + 30 + 1000);
                    this.skillEvent(103, role.x - 21 - 4 - 2 - 2 - 2 - 2, role.y - 57 - 8 - 7 - 8 - 7 - 8, 16, 0, role.y + 30 + 1000);
                    if (this.skillTime == 120) {
                        GameEngine.showLight(GameMap.setOffX + 63 + 6, GameMap.setOffY + 117 - 27, false);
                    }
                    if (this.skillTime > 120 && this.skillTime < 140) {
                        this.drawLight();
                    }
                    if (this.skillTime == 125) {
                        Battle.getFighter();
                    }
                    if (this.skillTime == 140) {
                        showLight = false;
                    }
                    if (this.skillTime >= 140 && this.skillTime <= 160) {
                        f[i].move(f[i].bx, f[i].by);
                        GameEngine.drawColorScreenBG(0xFFFFFF, 9999);
                    }
                    this.skillEvent(68, f[i].x, f[i].y - 5, 7, 0, f[i].y + 30 + 1);
                    this.skillEvent(74, f[i].x, f[i].y - 5, 7, 0, f[i].y + 30 + 1);
                    break;
                }
                case 31: {
                    this.skillFinshTime = 50;
                    this.skillEvent(10, f[i].x + 5, f[i].y - 40, 16, 0, f[i].y + 30 + 1);
                    int j = 0;
                    while (j < 24) {
                        this.skillEvent(20 + j, f[i].x + 10, f[i].y, 26, 0, f[i].y + 30 + 1);
                        j += 3;
                    }
                    break;
                }
                case 34: {
                    this.skillFinshTime = 50;
                    if (this.skillTime == 34) {
                        shakeTime = 5;
                    }
                    this.skillEvent(28, f[i].x, f[i].y, 23, isMir, 2000);
                    this.skillEvent(34, f[i].x, f[i].y, 50, isMir, 2000);
                    break;
                }
                case 35: {
                    this.skillFinshTime = 55;
                    this.skillEvent(22, f[i].x + 5, f[i].y - 10, 25, isMir, f[i].y + 30 + 1);
                    this.skillEvent(30, f[i].x + 10, f[i].y - 10, 22, isMir, f[i].y + 30 + 1);
                    break;
                }
                case 36: {
                    this.skillFinshTime = 25;
                    this.skillEvent(8, f[i].x, f[i].y, 45, 0, f[i].y + 30 + 1);
                    this.skillEvent(11, f[i].x, f[i].y, 46, 1, f[i].y + 30 + 1);
                    this.skillEvent(14, f[i].x, f[i].y, 47, 0, f[i].y + 30 + 1);
                    break;
                }
                case 37: {
                    this.skillFinshTime = 35;
                    this.skillEvent(20, GameMap.setOffX + 115, GameMap.setOffY + 195, 24, 0, f[i].y + 30 + 1);
                    break;
                }
                case 33: {
                    this.skillFinshTime = 85;
                    GameEngine.drawColorScreenBG(0, 20);
                    if (this.skillTime == 0) {
                        this.qilinx = 0;
                    }
                    if (this.qilinx < 30 && this.skillTime < 30) {
                        this.qilinx += 3;
                    }
                    if (this.skillTime > 78) {
                        this.qilinx -= 5;
                    }
                    Tools.drawFrame((short)166, GameData.fighterFrameData[23], GameData.fighterClipData[23], GameMap.setOffX + 320 - this.qilinx - 80, GameMap.setOffY + 120, 4, false, 9999);
                    int j = 0;
                    while (j < 43) {
                        this.skillEvent(28 + j, f[i].x, f[i].y, 23, isMir, 2000);
                        this.skillEvent(34 + j, f[i].x, f[i].y, 50, isMir, 2000);
                        j += 6;
                    }
                    break;
                }
                case 1: {
                    this.skillFinshTime = 25;
                    this.skillEvent(14, f[i].x, f[i].y - 15, 62, isMir, f[i].y + 30 + 1);
                    break;
                }
                case 38: {
                    this.skillFinshTime = 11;
                    this.skillEvent(7, f[i].x, f[i].y, 28, isMir, f[i].y + 30 + 1);
                    break;
                }
                case 39: {
                    this.skillFinshTime = 18;
                    this.skillEvent(10, f[i].x, f[i].y, 50, isMir, f[i].y + 30 + 1);
                    break;
                }
                case 40: {
                    this.skillFinshTime = 17;
                    this.skillEvent(10, f[i].x + 5, f[i].y, 51, isMir, f[i].y + 30 + 1);
                    break;
                }
                case 41: {
                    this.skillFinshTime = 18;
                    this.skillEvent(10, f[i].x, f[i].y, 13, isMir, f[i].y + 30 + 1);
                    break;
                }
                case 42: {
                    this.skillFinshTime = 18;
                    this.skillEvent(10, f[i].x, f[i].y, 40, isMir, f[i].y + 30 + 1);
                    break;
                }
                case 20: {
                    this.skillFinshTime = 60;
                    this.skillEvent(43, f[i].x, f[i].y - 25, 27, 0, f[i].y + 30 + 1);
                    this.skillEvent(49, f[i].x, f[i].y - 25, 27, 0, f[i].y + 30 + 1);
                    this.skillEvent(21, f[i].x, f[i].y - 25, 22, 0, f[i].y + 30 + 1);
                    break;
                }
                case 27: {
                    this.skillFinshTime = 55;
                    this.skillEvent(10, f[i].x, f[i].y - 20, 8, 0, f[i].y + 30 + 1);
                    this.skillEvent(25, f[i].x, f[i].y - 20, 8, 1, f[i].y + 30 + 1);
                    this.skillEvent(40, f[i].x, f[i].y - 20, 8, isMir, f[i].y + 30 + 1);
                    break;
                }
                case 6: {
                    this.skillFinshTime = 30;
                    this.skillEvent(15, 40, 120, 14, 0, 350);
                    this.skillEvent(15, 72, 101, 14, 0, 350);
                    this.skillEvent(15, 72, 146, 14, 0, 350);
                    break;
                }
                case 24: {
                    this.skillFinshTime = 30;
                    this.skillEvent(22, f[i].x - 36, f[i].y, 12, 1, f[i].y + 30 + 1);
                    this.skillEvent(24, f[i].x - 18, f[i].y, 12, 1, f[i].y + 30 + 1);
                    this.skillEvent(26, f[i].x, f[i].y, 12, 1, f[i].y + 30 + 1);
                    break;
                }
                case 23: {
                    this.skillFinshTime = 45;
                    int j = 0;
                    while (j < 18) {
                        this.skillEvent(20 + j, f[i].x, f[i].y, 26, 0, f[i].y + 30 + 1);
                        j += 3;
                    }
                    break;
                }
                case 19: {
                    this.skillFinshTime = 90;
                    if (this.skillTime >= 0 && this.skillTime <= 7) {
                        this.drawSword(f[i].x, f[i].y - 98 + this.skillTime % 2 * 2, f[i].y + 30 + 1, 4);
                    }
                    this.skillEvent(6, f[i].x, f[i].y - 80, 16, 0, f[i].y + 30 + 1);
                    if (this.skillTime >= 8 && this.skillTime <= 18) {
                        this.drawSword(f[i].x, f[i].y - 130, f[i].y + 30 + 1, true, (byte)0);
                    }
                    if (this.skillTime >= 18 && this.skillTime <= 20) {
                        GameEngine.drawColorScreenBG(0xFFFFFF, 20);
                    }
                    if (this.skillTime >= 20 && this.skillTime < 40) {
                        this.drawSword(f[i].x - 20, f[i].y - 150, f[i].y + 30 + 1, true, (byte)0);
                        this.drawSword(f[i].x - 20 + 23, f[i].y - 150 - 4, f[i].y + 30 + 1, false, (byte)0);
                        this.drawSword(f[i].x - 20 - 11, f[i].y - 150 + 16, f[i].y + 30 + 1, false, (byte)0);
                        this.drawSword(f[i].x - 20 + 8, f[i].y - 150 + 30, f[i].y + 30 + 1, false, (byte)0);
                        this.drawSword(f[i].x - 20 + 40, f[i].y - 150 + 11, f[i].y + 30 + 1, true, (byte)0);
                        this.drawSword(f[i].x - 20 + 30, f[i].y - 150 + 30, f[i].y + 30 + 1, true, (byte)0);
                    }
                    if (this.skillTime >= 40 && this.skillTime < 42) {
                        this.drawSword(f[i].x - 20 - 3, f[i].y - 150 - 3, f[i].y + 30 + 1, true, (byte)0);
                        this.drawSword(f[i].x - 20 + 23 + 3, f[i].y - 150 - 4 - 3, f[i].y + 30 + 1, false, (byte)0);
                        this.drawSword(f[i].x - 20 - 11 - 6, f[i].y - 150 + 16, f[i].y + 30 + 1, false, (byte)0);
                        this.drawSword(f[i].x - 20 + 8, f[i].y - 150 + 30 + 6, f[i].y + 30 + 1, false, (byte)0);
                        this.drawSword(f[i].x - 20 + 40 + 6, f[i].y - 150 + 11, f[i].y + 30 + 1, true, (byte)0);
                        this.drawSword(f[i].x - 20 + 30, f[i].y - 150 + 30 + 6, f[i].y + 30 + 1, true, (byte)0);
                    }
                    if (this.skillTime >= 42 && this.skillTime < 60) {
                        this.drawSword(f[i].x - 20 - 6, f[i].y - 150 - 6, f[i].y + 30 + 1, true, (byte)0);
                        this.drawSword(f[i].x - 20 + 23 + 6, f[i].y - 150 - 4 - 6, f[i].y + 30 + 1, false, (byte)0);
                        this.drawSword(f[i].x - 20 - 11 - 12, f[i].y - 150 + 16, f[i].y + 30 + 1, false, (byte)0);
                        this.drawSword(f[i].x - 20 + 8 - 3, f[i].y - 150 + 30 + 12, f[i].y + 30 + 1, false, (byte)0);
                        this.drawSword(f[i].x - 20 + 40 + 12, f[i].y - 150 + 11, f[i].y + 30 + 1, true, (byte)0);
                        this.drawSword(f[i].x - 20 + 30 + 3, f[i].y - 150 + 30 + 12, f[i].y + 30 + 1, true, (byte)0);
                    }
                    if (this.skillTime >= 60) {
                        GameEngine.drawColorScreenBG(0, 20);
                    }
                    if (this.skillTime >= 60 && this.skillTime < 64) {
                        this.drawSword(f[i].x - 20 - 6, f[i].y - 150 - 6, f[i].y + 30 + 1, true, (byte)0);
                        this.drawSword(f[i].x - 20 - 11 - 12, f[i].y - 150 + 16, f[i].y + 30 + 1, false, (byte)0);
                        this.drawSword(f[i].x - 20 + 8 - 3, f[i].y - 150 + 30 + 12, f[i].y + 30 + 1, false, (byte)0);
                        this.drawSword(f[i].x - 20 + 40 + 12, f[i].y - 150 + 11, f[i].y + 30 + 1, true, (byte)0);
                        this.drawSword(f[i].x - 20 + 30 + 3, f[i].y - 150 + 30 + 12, f[i].y + 30 + 1, true, (byte)0);
                    }
                    if (this.skillTime == 60) {
                        this.drawSword(f[i].x - 20 + 23 + 6, f[i].y - 150 - 4 - 6, f[i].y + 30 + 1, false, (byte)1);
                    }
                    if (this.skillTime >= 61 && this.skillTime <= 62) {
                        this.drawSword(f[i].x - 20 + 23 + 6, f[i].y - 150 - 4 - 6 - 20, f[i].y + 30 + 1, false, (byte)1);
                    }
                    this.skillEvent(63, f[i].x - 30, f[i].y, 45, 0, 20);
                    if (this.skillTime >= 64 && this.skillTime < 68) {
                        this.drawSword(f[i].x - 20 - 6, f[i].y - 150 - 6, f[i].y + 30 + 1, true, (byte)0);
                        this.drawSword(f[i].x - 20 - 11 - 12, f[i].y - 150 + 16, f[i].y + 30 + 1, false, (byte)0);
                        this.drawSword(f[i].x - 20 + 40 + 12, f[i].y - 150 + 11, f[i].y + 30 + 1, true, (byte)0);
                        this.drawSword(f[i].x - 20 + 30 + 3, f[i].y - 150 + 30 + 12, f[i].y + 30 + 1, true, (byte)0);
                    }
                    if (this.skillTime == 64) {
                        this.drawSword(f[i].x - 20 + 8 - 3, f[i].y - 150 + 30 + 12, f[i].y + 30 + 1, false, (byte)1);
                    }
                    if (this.skillTime >= 65 && this.skillTime <= 66) {
                        this.drawSword(f[i].x - 20 + 8 - 3, f[i].y - 150 + 30 + 12 - 20, f[i].y + 30 + 1, false, (byte)1);
                    }
                    this.skillEvent(67, f[i].x, f[i].y - 30, 48, 0, 20);
                    if (this.skillTime >= 68 && this.skillTime < 72) {
                        this.drawSword(f[i].x - 20 - 6, f[i].y - 150 - 6, f[i].y + 30 + 1, true, (byte)0);
                        this.drawSword(f[i].x - 20 - 11 - 12, f[i].y - 150 + 16, f[i].y + 30 + 1, false, (byte)0);
                        this.drawSword(f[i].x - 20 + 30 + 3, f[i].y - 150 + 30 + 12, f[i].y + 30 + 1, true, (byte)0);
                    }
                    if (this.skillTime == 68) {
                        this.drawSword(f[i].x - 20 + 40 + 12, f[i].y - 150 + 11, f[i].y + 30 + 1, true, (byte)1);
                    }
                    if (this.skillTime >= 69 && this.skillTime <= 70) {
                        this.drawSword(f[i].x - 20 + 40 + 12, f[i].y - 150 + 11 - 20, f[i].y + 30 + 1, true, (byte)1);
                    }
                    this.skillEvent(71, f[i].x - 30, f[i].y, 45, 0, 20);
                    if (this.skillTime >= 72 && this.skillTime < 76) {
                        this.drawSword(f[i].x - 20 - 6, f[i].y - 150 - 6, f[i].y + 30 + 1, true, (byte)0);
                        this.drawSword(f[i].x - 20 + 30 + 3, f[i].y - 150 + 30 + 12, f[i].y + 30 + 1, true, (byte)0);
                    }
                    if (this.skillTime == 72) {
                        this.drawSword(f[i].x - 20 - 11 - 12, f[i].y - 150 + 16, f[i].y + 30 + 1, false, (byte)1);
                    }
                    if (this.skillTime >= 73 && this.skillTime <= 74) {
                        this.drawSword(f[i].x - 20 - 11 - 12, f[i].y - 150 + 16 - 20, f[i].y + 30 + 1, false, (byte)1);
                    }
                    this.skillEvent(75, f[i].x, f[i].y - 40, 46, 0, 20);
                    if (this.skillTime >= 76 && this.skillTime < 80) {
                        this.drawSword(f[i].x - 20 + 30 + 3, f[i].y - 150 + 30 + 12, f[i].y + 30 + 1, true, (byte)0);
                    }
                    if (this.skillTime == 76) {
                        this.drawSword(f[i].x - 20 - 6, f[i].y - 150 - 6, f[i].y + 30 + 1, true, (byte)1);
                    }
                    if (this.skillTime >= 77 && this.skillTime <= 78) {
                        this.drawSword(f[i].x - 20 - 6, f[i].y - 150 - 6 - 20, f[i].y + 30 + 1, true, (byte)1);
                    }
                    this.skillEvent(79, f[i].x - 20, f[i].y - 40, 48, 0, 20);
                    if (this.skillTime < 80 || this.skillTime < 84) {
                        // empty if block
                    }
                    if (this.skillTime == 80) {
                        this.drawSword(f[i].x - 20 + 30 + 3, f[i].y - 150 + 30 + 12, f[i].y + 30 + 1, true, (byte)1);
                    }
                    if (this.skillTime >= 81 && this.skillTime <= 82) {
                        this.drawSword(f[i].x - 20 + 30 + 3, f[i].y - 150 + 30 + 12 - 20, f[i].y + 30 + 1, true, (byte)1);
                    }
                    this.skillEvent(83, f[i].x - 10, f[i].y - 40, 47, 0, 20);
                    break;
                }
                case 16: {
                    this.skillFinshTime = 65;
                    if (this.skillTime > 34 && this.skillTime < 40) {
                        this.h += 50;
                    }
                    if (this.skillTime > 46) {
                        this.h = 0;
                    }
                    this.skillEvent(21, GameMap.setOffX + GameMap.screenWidth / 2 + 20, GameMap.setOffY + GameMap.screenHeight / 2 + 35 - 50, 24, 0, 20);
                    int j = 0;
                    while (j < 21) {
                        this.skillEvent(41 + j, f[i].x + 3, f[i].y + 5, 26, 0, f[i].y - 20);
                        j += 3;
                    }
                    break;
                }
                case 15: {
                    this.skillFinshTime = 11;
                    this.skillEvent(1, f[i].x - 15, f[i].y - 10, 14, 0, f[i].y + 30 + 1);
                    this.skillEvent(4, f[i].x + 5, f[i].y - 5, 14, 0, f[i].y + 30 + 1);
                    this.skillEvent(6, f[i].x - 3, f[i].y + 2, 14, 0, f[i].y + 30 + 1);
                    break;
                }
                case 14: {
                    this.skillFinshTime = 10;
                    this.skillEvent(1, f[i].x - 24, f[i].y, 12, 1, f[i].y + 30 + 1);
                    this.skillEvent(3, f[i].x, f[i].y, 12, 1, f[i].y + 30 + 1);
                    this.skillEvent(5, f[i].x + 24, f[i].y, 12, 1, f[i].y + 30 + 1);
                    this.skillEvent(1, 8);
                    break;
                }
                case 12: {
                    this.skillFinshTime = 80;
                    GameEngine.drawColorScreenBG(0, 20);
                    int tempx = GameMap.setOffX;
                    int tempy = GameMap.setOffY;
                    this.skillEvent(21, tempx + GameMap.screenWidth / 2 - 40, tempy + GameMap.screenHeight / 2 + 10, 24, 0, 20);
                    this.skillFlash(105, 2, 1);
                    this.skillFlash(109, 2, 1);
                    this.skillFlash(113, 2, 1);
                    this.skillFlash(117, 2, 1);
                    this.skillFlash(121, 2, 1);
                    this.skillEvent(51, tempx + 60, tempy + 90, 25, 0, 2000);
                    this.skillEvent(51, tempx + 40, tempy + 120, 25, 0, 2000);
                    this.skillEvent(51, tempx + 80, tempy + 120, 25, 0, 2000);
                    this.skillEvent(51, tempx + 60, tempy + 150, 25, 0, 2000);
                    this.skillEvent(56, tempx + 60, tempy + 60, 25, 0, 2000);
                    this.skillEvent(56, tempx + 60, tempy + 150, 25, 0, 2000);
                    this.skillEvent(56, tempx + 20, tempy + 90, 25, 0, 2000);
                    this.skillEvent(56, tempx + 0, tempy + 120, 25, 0, 2000);
                    this.skillEvent(56, tempx + 20, tempy + 150, 25, 0, 2000);
                    this.skillEvent(56, tempx + 100, tempy + 90, 25, 0, 2000);
                    this.skillEvent(56, tempx + 120, tempy + 120, 25, 0, 2000);
                    this.skillEvent(56, tempx + 100, tempy + 150, 25, 0, 2000);
                    this.skillEvent(61, tempx + 60, tempy + 90, 25, 0, 2000);
                    this.skillEvent(61, tempx + 40, tempy + 120, 25, 0, 2000);
                    this.skillEvent(61, tempx + 80, tempy + 120, 25, 0, 2000);
                    this.skillEvent(61, tempx + 60, tempy + 150, 25, 0, 2000);
                    this.skillEvent(66, tempx + 60, tempy + 60, 25, 0, 2000);
                    this.skillEvent(66, tempx + 60, tempy + 150, 25, 0, 2000);
                    this.skillEvent(66, tempx + 20, tempy + 90, 25, 0, 2000);
                    this.skillEvent(66, tempx + 0, tempy + 120, 25, 0, 2000);
                    this.skillEvent(66, tempx + 20, tempy + 150, 25, 0, 2000);
                    this.skillEvent(66, tempx + 100, tempy + 90, 25, 0, 2000);
                    this.skillEvent(66, tempx + 120, tempy + 120, 25, 0, 2000);
                    this.skillEvent(66, tempx + 100, tempy + 150, 25, 0, 2000);
                    this.skillEvent(71, tempx + 60, tempy + 90, 25, 0, 2000);
                    this.skillEvent(71, tempx + 40, tempy + 120, 25, 0, 2000);
                    this.skillEvent(71, tempx + 80, tempy + 120, 25, 0, 2000);
                    this.skillEvent(71, tempx + 60, tempy + 150, 25, 0, 2000);
                    break;
                }
                case 10: {
                    this.skillFinshTime = 45;
                    this.skillEvent(20, f[i].x, f[i].y, 22, 0, f[i].y + 30);
                    break;
                }
                case 11: {
                    this.skillFinshTime = 60;
                    this.skillEvent(23, f[i].x - 30, f[i].y, 45, 0, 20);
                    this.skillEvent(27, f[i].x, f[i].y - 30, 48, 0, 20);
                    this.skillEvent(31, f[i].x - 30, f[i].y, 45, 0, 20);
                    this.skillEvent(35, f[i].x, f[i].y - 40, 46, 0, 20);
                    this.skillEvent(39, f[i].x - 20, f[i].y - 40, 48, 0, 20);
                    this.skillEvent(43, f[i].x - 10, f[i].y - 40, 47, 0, 20);
                    break;
                }
                case 4: {
                    this.skillFinshTime = 38;
                    break;
                }
                case 5: {
                    this.skillFinshTime = 80;
                    this.skillEvent(10, role.x, role.y, 38, 0, f[i].y + 30);
                    this.skillEvent(16, role.x, role.y, 38, 0, f[i].y + 30);
                    this.skillEvent(16, role.x, role.y, 39, 0, f[i].y + 30);
                    this.skillEvent(20, role.x - 25, role.y + 10, 42, 0, f[i].y + 30);
                    this.skillEvent(30, role.x - 15, role.y - 70, 3, 0, f[i].y + 30);
                    this.skillEvent(20, role.x - 5, role.y + 46, 42, 0, f[i].y + 30);
                    this.skillEvent(30, role.x + 5, role.y + 34, 3, 0, f[i].y + 30);
                    this.skillEvent(40, GameMap.setOffX + 90 - 80, GameMap.setOffY + 130, 43, 0, f[i].y + 30);
                    this.skillEvent(40, GameMap.setOffX + 90 + 60 - 80, GameMap.setOffY + 90, 43, 0, f[i].y + 30);
                    this.skillEvent(46, GameMap.setOffX + 120 - 35, GameMap.setOffY + 60 + 20, 20, 0, f[i].y + 30);
                    this.skillEvent(49, GameMap.setOffX + 120 - 25 - 35, GameMap.setOffY + 90 + 30 + 20, 20, 0, f[i].y + 30);
                    this.skillEvent(52, GameMap.setOffX + 60 - 35, GameMap.setOffY + 120, 20, 0, f[i].y + 30);
                    this.skillEvent(56, GameMap.setOffX + 60 - 35, GameMap.setOffY + 140, 20, 0, f[i].y + 30);
                    this.skillEvent(46, GameMap.setOffX + 80 - 35, GameMap.setOffY + 90, 30, 0, f[i].y + 30);
                    this.skillEvent(50, GameMap.setOffX + 40 - 35, GameMap.setOffY + 130, 30, 0, f[i].y + 30);
                    this.skillEvent(56, GameMap.setOffX + 60 - 35, GameMap.setOffY + 60, 30, 0, f[i].y + 30);
                    break;
                }
                case 7: {
                    this.skillFinshTime = 40;
                    this.skillEvent(1, f[i].x, f[i].y, 16, 0, f[i].y + 30 + 1);
                    break;
                }
                case 8: {
                    this.skillFinshTime = 30;
                    this.skillEvent(20, f[i].x + 5, f[i].y - 20, 36, 0, f[i].y + 30 + 200);
                    break;
                }
                case 22: {
                    this.skillFinshTime = 40;
                    this.skillEvent(10, f[i].x + 5, f[i].y, 60, 0, f[i].y + 30 + 200);
                    break;
                }
                case 9: {
                    this.skillFinshTime = 55;
                    if (this.skillTime > 20) {
                        f[i].isShowRole = false;
                    }
                    if (this.skillTime == 26) {
                        shakeTime = 22;
                    }
                    this.skillFlash(26, 4, 1);
                    int j = 0;
                    while (j < 31) {
                        this.skillEvent(20 + j, f[i].x + 8, f[i].y - 20, 18, 0, f[i].y + 30 + 1000);
                        this.skillEvent(20 + j, f[i].x, f[i].y, 17, 0, f[i].y + 30 + 1);
                        j += 3;
                    }
                    break;
                }
            }
            ++i;
        }
        if (++this.skillTime >= this.skillFinshTime) {
            this.skillFinshTime = 0;
            this.skillTime = 0;
            this.h = 0;
            if (this.isOver) {
                this.actionOver();
            }
            this.isOver = true;
            return;
        }
    }

    void skillFlash(int time, int fTime, int fMode) {
        if (this.skillTime == time) {
            flashTime = (byte)fTime;
            flashMode = fMode;
        }
    }

    void skillEvent(int time, int x, int y, int type, int isMir, int drawLevel) {
        if (this.skillTime == time) {
            Effect.AddEffectList(x, y, type, isMir, drawLevel);
        }
    }

    void skillEvent(int time, int st) {
        if (this.skillTime == time) {
            shakeTime = (byte)st;
        }
    }

    void actionOver() {
        ++Battle.wait;
    }

    public static void addEnemy(int type) {
        vEnemys.addElement(new byte[]{(byte)type});
    }

    static void fullHp() {
        int i = 0;
        while (i < role.length) {
            GameEngine.role[i].hp = GameEngine.role[i].hp_max;
            GameEngine.role[i].mp = GameEngine.role[i].mp_max;
            ++i;
        }
    }

    public static byte getIndex(byte id, byte[] data) {
        int i = 0;
        while (i < data.length) {
            if (id == data[i]) {
                return (byte)i;
            }
            ++i;
        }
        return -1;
    }

    public static short getImageIndex(String name) {
        int i = 0;
        while (i < Tools.FILESNAME.length) {
            if (name.equals(Tools.FILESNAME[i])) {
                return (short)i;
            }
            ++i;
        }
        return -1;
    }

    public void initImageData(int index) {
        Tools.getBuffDat("/datPackage.dat");
        switch (index) {
            case 3: {
                GameData.spriteClipData = new byte[67][][];
                GameData.spriteFrameData = new byte[67][][];
                GameData.spriteMotionData = new byte[67][][][];
                break;
            }
            case 4: {
                int i = 0;
                while (i < 67) {
                    GameData.spriteClipData[i] = this.readClipData("s" + i + "_c");
                    Tools.removeDatBuff("s" + i + "_c");
                    ++i;
                }
                break;
            }
            case 5: {
                int i = 0;
                while (i < 67) {
                    GameData.spriteFrameData[i] = this.readFrameData("s" + i + "_f");
                    Tools.removeDatBuff("s" + i + "_f");
                    ++i;
                }
                break;
            }
            case 6: {
                int i = 0;
                while (i < 67) {
                    GameData.spriteMotionData[i] = this.readMotionData("s" + i + "_m");
                    Tools.removeDatBuff("s" + i + "_m");
                    ++i;
                }
                break;
            }
            case 7: {
                GameData.fighterClipData = new byte[36][][];
                GameData.fighterFrameData = new byte[36][][];
                GameData.fighterMotionData = new byte[36][][][];
                break;
            }
            case 8: {
                int i = 0;
                while (i < 36) {
                    GameData.fighterClipData[i] = this.readClipData("f" + i + "_c");
                    Tools.removeDatBuff("f" + i + "_c");
                    ++i;
                }
                break;
            }
            case 9: {
                int i = 0;
                while (i < 36) {
                    GameData.fighterFrameData[i] = this.readFrameData("f" + i + "_f");
                    Tools.removeDatBuff("f" + i + "_f");
                    ++i;
                }
                break;
            }
            case 10: {
                int i = 0;
                while (i < 36) {
                    GameData.fighterMotionData[i] = this.readMotionData("f" + i + "_m");
                    Tools.removeDatBuff("f" + i + "_m");
                    ++i;
                }
                break;
            }
            case 11: {
                Effect.effectClipData = new short[63][][];
                Effect.effectFrameData = new short[63][][];
                Effect.effectMotionData = new short[63][1][][];
                GameData.effectClipData = new byte[63][][];
                GameData.effectFrameData = new byte[63][][];
                GameData.effectMotionData = new byte[63][][][];
                break;
            }
            case 12: {
                int i = 0;
                while (i < 63) {
                    GameData.effectClipData[i] = this.readClipData("e" + i + "_c");
                    Tools.removeDatBuff("e" + i + "_c");
                    ++i;
                }
                break;
            }
            case 13: {
                int i = 0;
                while (i < 63) {
                    GameData.effectFrameData[i] = this.readFrameData("e" + i + "_f");
                    Tools.removeDatBuff("e" + i + "_f");
                    ++i;
                }
                break;
            }
            case 14: {
                int i = 0;
                while (i < 63) {
                    GameData.effectMotionData[i] = this.readMotionData("e" + i + "_m");
                    Tools.removeDatBuff("e" + i + "_m");
                    ++i;
                }
                break;
            }
            case 15: {
                MyGameCanvas.msg = new MyMessage();
                break;
            }
            case 16: {
                GameEngine gameEngine = this;
                gameEngine.canvas.initDB();
                break;
            }
            case 17: {
                this.canvas.readDB(0, false);
                this.canvas.readDB(1, false);
                break;
            }
            case 18: {
                GameEngine gameEngine = this;
                gameEngine.canvas.readSmsDB();
                GameEngine gameEngine2 = this;
                gameEngine2.canvas.initSmsDat();
                break;
            }
            case 19: {
                break;
            }
            case 20: {
                break;
            }
        }
    }

    public void initEquipment() {
        DataInputStream dis = new DataInputStream(this.getClass().getResourceAsStream("equip.dat"));
        try {
            short len = dis.readShort();
            byte[] strBuff = null;
            equip = new Equipment[len];
            int i = 0;
            while (i < equip.length) {
                GameEngine.equip[i] = new Equipment();
                strBuff = new byte[dis.readShort()];
                dis.read(strBuff);
                GameEngine.equip[i].name = new String(strBuff, "UTF-8");
                GameEngine.equip[i].lev = dis.readByte();
                GameEngine.equip[i].type = dis.readByte();
                GameEngine.equip[i].prop1 = dis.readShort();
                GameEngine.equip[i].prop2 = dis.readShort();
                GameEngine.equip[i].prop3 = dis.readByte();
                GameEngine.equip[i].price = dis.readShort();
                GameEngine.equip[i].power = dis.readShort();
                ++i;
            }
            dis.close();
        }
        catch (Exception e) {
            System.out.println("equipment data error!");
        }
    }

    boolean isGodEquip(int type) {
        return type == 6 || type == 13 || type == 25 || type == 32;
    }

    public void initItem() {
        DataInputStream dis = new DataInputStream(this.getClass().getResourceAsStream("item.dat"));
        try {
            short len = dis.readShort();
            byte[] strBuff = null;
            item = new Item[len];
            int i = 0;
            while (i < item.length) {
                GameEngine.item[i] = new Item();
                strBuff = new byte[dis.readShort()];
                dis.read(strBuff);
                GameEngine.item[i].name = new String(strBuff, "UTF-8");
                strBuff = new byte[dis.readShort()];
                dis.read(strBuff);
                GameEngine.item[i].dis = this.tings[i];
                GameEngine.item[i].range = dis.readByte();
                GameEngine.item[i].limit = dis.readByte();
                GameEngine.item[i].hp1 = dis.readShort();
                GameEngine.item[i].hp2 = dis.readByte();
                GameEngine.item[i].mp1 = dis.readShort();
                GameEngine.item[i].mp2 = dis.readByte();
                GameEngine.item[i].removeBuff = dis.readByte();
                GameEngine.item[i].price = dis.readShort();
                ++i;
            }
            dis.close();
        }
        catch (Exception e) {
            System.out.println("item data error!!!!!!!!!!!!!!!!!!!!!!");
        }
    }

    public void initSoul() {
        DataInputStream dis = new DataInputStream(this.getClass().getResourceAsStream("soul.dat"));
        try {
            short len = dis.readShort();
            byte[] strBuff = null;
            soul = new Soul[len];
            int i = 0;
            while (i < soul.length) {
                GameEngine.soul[i] = new Soul();
                strBuff = new byte[dis.readShort()];
                dis.read(strBuff);
                GameEngine.soul[i].name = new String(strBuff, "UTF-8");
                GameEngine.soul[i].type = dis.readByte();
                GameEngine.soul[i].value = dis.readByte();
                GameEngine.soul[i].price = dis.readShort();
                GameEngine.soul[i].dis = "";
                ++i;
            }
            dis.close();
        }
        catch (Exception e) {
            System.out.println("soul data error!!!!!!!!!!!!!!!!!!!!!!");
        }
    }

    public void initTalent() {
        DataInputStream dis = new DataInputStream(this.getClass().getResourceAsStream("talent.dat"));
        try {
            short len = dis.readShort();
            byte[] strBuff = null;
            talent = new Talent[len];
            int i = 0;
            while (i < talent.length) {
                GameEngine.talent[i] = new Talent();
                strBuff = new byte[dis.readShort()];
                dis.read(strBuff);
                GameEngine.talent[i].name = new String(strBuff, "UTF-8");
                strBuff = new byte[dis.readShort()];
                dis.read(strBuff);
                GameEngine.talent[i].dis = new String(strBuff, "UTF-8");
                GameEngine.talent[i].type = dis.readByte();
                GameEngine.talent[i].skill = dis.readByte();
                GameEngine.talent[i].value = dis.readByte();
                GameEngine.talent[i].max = dis.readByte();
                GameEngine.talent[i].needSkill = dis.readByte();
                GameEngine.talent[i].icon = dis.readByte();
                ++i;
            }
            dis.close();
        }
        catch (Exception e) {
            System.out.println("talent data error!!!!!!!!!!!!!!!!!!!!!!");
        }
    }

    public void initOther() {
        DataInputStream dis = new DataInputStream(this.getClass().getResourceAsStream("other.dat"));
        try {
            short len = dis.readShort();
            byte[] strBuff = null;
            other = new Other[len];
            int i = 0;
            while (i < other.length) {
                GameEngine.other[i] = new Other();
                strBuff = new byte[dis.readShort()];
                dis.read(strBuff);
                GameEngine.other[i].name = new String(strBuff, "UTF-8");
                strBuff = new byte[dis.readShort()];
                dis.read(strBuff);
                GameEngine.other[i].dis = new String(strBuff, "UTF-8");
                ++i;
            }
            dis.close();
        }
        catch (Exception e) {
            System.out.println("other data error!!!!!!!!!!!!!!!!!!!!!!");
        }
    }

    public void initGod() {
        DataInputStream dis = new DataInputStream(this.getClass().getResourceAsStream("god.dat"));
        try {
            int len = dis.readShort();
            byte[] strBuff = null;
            God.name = new String[len];
            God.dis = new String[len];
            God.gods = new byte[len];
            God.power = new byte[len];
            int i = 0;
            while (i < len) {
                strBuff = new byte[dis.readShort()];
                dis.read(strBuff);
                God.name[i] = new String(strBuff, "UTF-8");
                strBuff = new byte[dis.readShort()];
                dis.read(strBuff);
                if (i != 6 && i != 10) {
                    God.dis[i] = new String(strBuff, "UTF-8");
                } else if (i == 10) {
                    God.dis[i] = "\u6218\u6597\u4e2d\u6bcf\u56de\u5408\u81ea\u52a8\u6062\u590d\u4e00\u5b9a\u6570\u91cf\u751f\u547d\u548c\u7075\u529b\u3002";
                } else if (i == 6) {
                    God.dis[i] = "\u6218\u6597\u4e2d\u4f7f\u7528\uff0c\u4f24\u5bb3\u654c\u4eba\u6216\u52a9\u5176\u6062\u590d\u751f\u547d\uff0c\u4e0e\u4eba\u7269\u7b49\u7ea7\u76f8\u5173\u3002";
                }
                God.gods[i] = dis.readByte();
                God.power[i] = dis.readByte();
                ++i;
            }
            God.bGods = new byte[len];
            int i2 = 0;
            while (i2 < len) {
                God.bGods[i2] = God.gods[i2];
                ++i2;
            }
            dis.close();
        }
        catch (Exception e) {
            System.out.println("god data error!!!!!!!!!!!!!!!!!!!!!!");
        }
    }

    public void initFighterData() {
        DataInputStream dis = new DataInputStream(this.getClass().getResourceAsStream("fighter.dat"));
        try {
            int len = dis.readShort();
            byte[] strBuff = null;
            GameData.fighterName = new String[len];
            GameData.hps = new int[len];
            GameData.props = new short[len][13];
            GameData.actions = new byte[len][];
            int i = 0;
            while (i < len) {
                strBuff = new byte[dis.readShort()];
                dis.read(strBuff);
                GameData.fighterName[i] = new String(strBuff, "UTF-8");
                GameData.props[i][0] = dis.readByte();
                strBuff = new byte[dis.readShort()];
                dis.read(strBuff);
                String skill = new String(strBuff, "UTF-8");
                if (skill.equals("null")) {
                    GameData.actions[i] = null;
                } else {
                    String[] params = Event.splitString(skill, ",");
                    GameData.actions[i] = new byte[params.length];
                    int j = 0;
                    while (j < params.length) {
                        GameData.actions[i][j] = (byte)Event.sToi(params[j]);
                        ++j;
                    }
                }
                GameData.props[i][1] = dis.readByte();
                GameData.props[i][2] = dis.readByte();
                GameData.hps[i] = dis.readInt();
                GameData.props[i][3] = dis.readShort();
                GameData.props[i][4] = dis.readShort();
                GameData.props[i][5] = dis.readShort();
                GameData.props[i][6] = dis.readByte();
                GameData.props[i][7] = dis.readByte();
                GameData.props[i][8] = dis.readByte();
                GameData.props[i][9] = dis.readByte();
                GameData.props[i][10] = dis.readByte();
                GameData.props[i][11] = dis.readByte();
                GameData.props[i][12] = dis.readByte();
                ++i;
            }
            dis.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("fighter data error!!!!!!!!!!!!!!!!!");
        }
    }

    public void initSkill() {
        DataInputStream dis = new DataInputStream(this.getClass().getResourceAsStream("skill.dat"));
        try {
            short len = dis.readShort();
            byte[] strBuff = null;
            skill = new Skill[len];
            int i = 0;
            while (i < skill.length) {
                String[] params;
                GameEngine.skill[i] = new Skill();
                strBuff = new byte[dis.readShort()];
                dis.read(strBuff);
                GameEngine.skill[i].name = new String(strBuff, "UTF-8");
                strBuff = new byte[dis.readShort()];
                dis.read(strBuff);
                GameEngine.skill[i].dis = new String(strBuff, "UTF-8");
                GameEngine.skill[i].formula = dis.readByte();
                GameEngine.skill[i].limit = dis.readByte();
                GameEngine.skill[i].range = dis.readByte();
                GameEngine.skill[i].attMode = dis.readByte();
                GameEngine.skill[i].effectType = dis.readByte();
                strBuff = new byte[dis.readShort()];
                dis.read(strBuff);
                String buff = new String(strBuff, "UTF-8");
                if (buff.equals("null")) {
                    GameEngine.skill[i].buff = null;
                } else {
                    params = Event.splitString(buff, ",");
                    GameEngine.skill[i].buff = new short[params.length];
                    int j = 0;
                    while (j < params.length) {
                        GameEngine.skill[i].buff[j] = (short)Event.sToi(params[j]);
                        ++j;
                    }
                }
                strBuff = new byte[dis.readShort()];
                dis.read(strBuff);
                String hits = new String(strBuff, "UTF-8");
                if (hits.equals("null")) {
                    GameEngine.skill[i].hitIndex = null;
                } else {
                    params = Event.splitString(hits, ",");
                    GameEngine.skill[i].hitIndex = new byte[params.length];
                    int j = 0;
                    while (j < params.length) {
                        GameEngine.skill[i].hitIndex[j] = (byte)Event.sToi(params[j]);
                        ++j;
                    }
                }
                strBuff = new byte[dis.readShort()];
                dis.read(strBuff);
                String perHurts = new String(strBuff, "UTF-8");
                if (perHurts.equals("null")) {
                    GameEngine.skill[i].perHurt = null;
                } else {
                    params = Event.splitString(perHurts, ",");
                    GameEngine.skill[i].perHurt = new short[params.length];
                    int j = 0;
                    while (j < params.length) {
                        GameEngine.skill[i].perHurt[j] = (short)Event.sToi(params[j]);
                        ++j;
                    }
                }
                GameEngine.skill[i].incureTime = dis.readByte();
                GameEngine.skill[i].removeBuff = dis.readByte();
                GameEngine.skill[i].lossMP = dis.readShort();
                GameEngine.skill[i].skillIcon = dis.readByte();
                GameEngine.skill[i].cd = dis.readByte();
                ++i;
            }
            dis.close();
        }
        catch (Exception e) {
            System.out.println("skill data error!!!!!!!!!!!!!!!!!!!!");
        }
    }

    public boolean canUseSkill(Fighter r, Skill skill, boolean isBattle) {
        if (skill.limit != 0 && r.mp >= skill.lossMP / this.jn) {
            if (skill.limit == 3) {
                return true;
            }
            return isBattle ? skill.limit == 2 : skill.limit == 1;
        }
        return false;
    }

    void skillReduce(Fighter r, Skill sk, int tType, int tValue) {
        int perLoss = 100;
        if (tType == 14) {
            perLoss = 100 - tValue;
        }
        r.mp -= sk.lossMP * perLoss / 100;
        r.mp = Math.max(0, r.mp);
    }

    void removeBuff(byte type, Fighter f) {
        switch (type) {
            case 11: {
                f.actionTime = (byte)(f.actionTime + 1);
                break;
            }
            case 1: {
                f.reBorn(false);
                break;
            }
            case 9: {
                int i = 0;
                while (i < f.buff.length) {
                    switch (i) {
                        case 5: 
                        case 6: {
                            if (f.buff[i][0] <= 0 || f.buff[i][1] >= 0) break;
                            f.buff[i][0] = 0;
                            f.buff[i][1] = 0;
                            break;
                        }
                        default: {
                            f.buff[i][0] = 0;
                        }
                    }
                    ++i;
                }
                break;
            }
            case 10: {
                f.reBorn(false);
                int i = 0;
                while (i < f.buff.length) {
                    switch (i) {
                        case 5: 
                        case 6: {
                            if (f.buff[i][0] <= 0 || f.buff[i][1] >= 0) break;
                            f.buff[i][0] = 0;
                            f.buff[i][1] = 0;
                            break;
                        }
                        default: {
                            f.buff[i][0] = 0;
                        }
                    }
                    ++i;
                }
                break;
            }
        }
    }

    public void initBomb() {
        showBomb = true;
        this.bombs = null;
        short[][] temp = this.readItemData((GameEngine.map.mapID < 10 ? "0" : "") + GameEngine.map.mapID);
        if (temp == null) {
            return;
        }
        this.bombs = new short[temp.length][8];
        int i = 0;
        while (i < this.bombs.length) {
            this.bombs[i][7] = temp[i][0];
            this.bombs[i][0] = (short)(temp[i][1] + 8);
            this.bombs[i][1] = temp[i][2];
            if (temp[i][4] == -1) {
                this.bombs[i][2] = 0;
                this.bombs[i][3] = 0;
            } else {
                this.bombs[i][2] = temp[i][4];
                this.bombs[i][3] = 1;
                this.bombs[i][4] = (short)GameEngine.nextInt(12);
                switch (this.bombs[i][2]) {
                    case 0: {
                        short[] sArray = this.bombs[i];
                        sArray[0] = (short)(sArray[0] + this.bombs[i][4] * 4);
                        break;
                    }
                    case 2: {
                        short[] sArray = this.bombs[i];
                        sArray[1] = (short)(sArray[1] + this.bombs[i][4] * 4);
                    }
                }
            }
            this.bombs[i][5] = (short)GameEngine.nextInt(2);
            ++i;
        }
    }

    public static short[] getSpeed(int sx, int sy, int ex, int ey, int lot) {
        short[] values = new short[]{(short)((ex - sx) / lot), (short)((ey - sy) / lot)};
        if (values[0] == 0 && values[1] == 0) {
            values[0] = 1;
            values[1] = 1;
        }
        return values;
    }

    public void moveBomb() {
        if (this.bombs == null || !showBomb) {
            return;
        }
        if (!Script.isUserCtrl || Event.isChangeMap) {
            return;
        }
        int objX = GameEngine.sprite[GameEngine.spriteIndex].x + 8;
        int objY = GameEngine.sprite[GameEngine.spriteIndex].y - 8;
        int i = 0;
        while (i < this.bombs.length) {
            if (this.bombs[i][3] != 4) {
                switch (this.bombs[i][3]) {
                    case 0: {
                        if (stopBomb || Math.abs(this.bombs[i][0] - objX) >= 31 || Math.abs(this.bombs[i][1] - objY) >= 31) break;
                        this.bombs[i][3] = 2;
                        this.bombs[i][6] = 10;
                        break;
                    }
                    case 1: {
                        int mx;
                        int n = this.bombs[i][2] == 0 ? 1 : (mx = this.bombs[i][2] == 1 ? -1 : 0);
                        int my = this.bombs[i][2] == 2 ? 1 : (this.bombs[i][2] == 3 ? -1 : 0);
                        short[] sArray = this.bombs[i];
                        sArray[0] = (short)(sArray[0] + 4 * mx);
                        short[] sArray2 = this.bombs[i];
                        sArray2[1] = (short)(sArray2[1] + 4 * my);
                        short[] sArray3 = this.bombs[i];
                        sArray3[4] = (short)(sArray3[4] + 1);
                        if (sArray3[4] > 12) {
                            this.bombs[i][4] = 0;
                            short[] sArray4 = this.bombs[i];
                            sArray4[2] = (short)(sArray4[2] ^ 1);
                        }
                        if (stopBomb || Math.abs(this.bombs[i][0] - objX) >= 31 || Math.abs(this.bombs[i][1] - objY) >= 31) break;
                        this.bombs[i][3] = 2;
                        this.bombs[i][6] = 10;
                        break;
                    }
                    case 2: {
                        if (Math.abs(this.bombs[i][0] - objX) >= 31 || Math.abs(this.bombs[i][1] - objY) >= 31) {
                            this.bombs[i][3] = 0;
                            break;
                        }
                        short[] speed = GameEngine.getSpeed(this.bombs[i][0], this.bombs[i][1], objX, objY, this.bombs[i][6]);
                        if (this.bombs[i][6] > 1) {
                            short[] sArray = this.bombs[i];
                            sArray[6] = (short)(sArray[6] - 1);
                        }
                        short[] sArray = this.bombs[i];
                        sArray[0] = (short)(sArray[0] + speed[0]);
                        short[] sArray5 = this.bombs[i];
                        sArray5[1] = (short)(sArray5[1] + speed[1]);
                        if (Math.abs(this.bombs[i][0] - objX) >= 5 || Math.abs(this.bombs[i][1] - objY) >= 5 || MyGameCanvas.gameStatus != 7 || GameEngine.sprite[GameEngine.spriteIndex].x != GameEngine.sprite[GameEngine.spriteIndex].ax || GameEngine.sprite[GameEngine.spriteIndex].y != GameEngine.sprite[GameEngine.spriteIndex].ay + 1) break;
                        this.bombs[i][3] = 3;
                        this.bomb(this.bombs[i][7] == 1);
                        break;
                    }
                    case 3: {
                        this.bombs[i][3] = 4;
                    }
                }
                short[] sArray = this.bombs[i];
                sArray[5] = (short)(sArray[5] + 1);
                if (sArray[5] >= 3) {
                    this.bombs[i][5] = 0;
                }
            }
            ++i;
        }
    }

    public void drawBomb() {
        if (this.bombs == null || !showBomb) {
            return;
        }
        int i = 0;
        while (i < this.bombs.length) {
            if (this.bombs[i][3] != 4) {
                this.drawShandow(this.bombs[i][0], this.bombs[i][1], 14, 6, 0, 30);
                int img = stopBomb ? 35 : (this.bombs[i][7] == 0 ? 33 : 34);
                Tools.addImage(img, this.bombs[i][0] - 8, this.bombs[i][1] - 4, 20 * this.bombs[i][5], 0, 20, 41, 36, (byte)0, this.bombs[i][1] + 30);
            }
            ++i;
        }
    }

    public short[][] readItemData(String name) {
        byte[] array = Tools.getDat("/bomb.dat", name);
        if (array == null) {
            System.out.println("bomb file is null!");
            return null;
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(array);
        DataInputStream is = new DataInputStream(bais);
        short[][] dat = null;
        try {
            int len = is.readShort();
            dat = new short[len][];
            int i = 0;
            while (i < len) {
                int gLen = is.readByte();
                dat[i] = new short[gLen];
                int j = 0;
                while (j < gLen) {
                    dat[i][j] = is.readShort();
                    ++j;
                }
                ++i;
            }
            is.close();
            bais.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return dat;
    }

    public short[][] readItemData2(String name) {
        byte[] buff = Tools.getMapDataEX(name);
        if (buff == null) {
            return null;
        }
        DataInputStream is = new DataInputStream(new ByteArrayInputStream(buff));
        short[][] dat = null;
        try {
            int len = is.readShort();
            dat = new short[len][];
            int i = 0;
            while (i < len) {
                int gLen = is.readByte();
                dat[i] = new short[gLen];
                int j = 0;
                while (j < gLen) {
                    dat[i][j] = is.readShort();
                    ++j;
                }
                ++i;
            }
            is.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return dat;
    }

    public byte[][][] readMotionData(String name) {
        byte[] buff = Tools.getGameDat(name);
        if (buff == null) {
            return null;
        }
        DataInputStream is = new DataInputStream(new ByteArrayInputStream(buff));
        byte[][][] motion = null;
        int motionLen = 0;
        try {
            motionLen = is.readByte();
            motion = new byte[15][][];
            int i = 0;
            while (i < motionLen) {
                byte st = is.readByte();
                int zs = is.readByte();
                motion[st] = new byte[zs][7];
                int j = 0;
                while (j < zs) {
                    int m = 0;
                    while (m < 7) {
                        motion[st][j][m] = is.readByte();
                        ++m;
                    }
                    ++j;
                }
                ++i;
            }
            is.close();
        }
        catch (Exception e) {
            System.out.println("not find file:" + name);
            e.printStackTrace();
        }
        return motion;
    }

    public byte[][] readClipData(String name) {
        byte[] buff = Tools.getGameDat(name);
        if (buff == null) {
            return null;
        }
        DataInputStream is = new DataInputStream(new ByteArrayInputStream(buff));
        byte[][] clip = null;
        int clipLen = 0;
        try {
            clipLen = is.readShort();
            clip = new byte[clipLen][4];
            int i = 0;
            while (i < clipLen) {
                clip[i][0] = is.readByte();
                clip[i][1] = is.readByte();
                clip[i][2] = is.readByte();
                clip[i][3] = is.readByte();
                ++i;
            }
            is.close();
        }
        catch (Exception e) {
            System.out.println("not find file:" + name);
            e.printStackTrace();
        }
        return clip;
    }

    public byte[][] readFrameData(String name) {
        byte[] buff = Tools.getGameDat(name);
        if (buff == null) {
            return null;
        }
        DataInputStream is = new DataInputStream(new ByteArrayInputStream(buff));
        byte[][] frame = null;
        try {
            int len = is.readByte();
            frame = new byte[len][];
            int i = 0;
            while (i < len) {
                int gLen = is.readByte() * 5;
                frame[i] = new byte[gLen];
                int j = 0;
                while (j < gLen) {
                    frame[i][j] = is.readByte();
                    ++j;
                }
                ++i;
            }
            is.close();
        }
        catch (Exception e) {
            System.out.println("not find file:" + name);
            e.printStackTrace();
        }
        return frame;
    }

    static void noStop() {
        int i = 0;
        while (i < sprite.length) {
            GameEngine.sprite[i].isStop = false;
            ++i;
        }
    }

    public static void showIcon(int icon) {
        showIcon = true;
        iconIndex = 0;
        iconID = icon;
    }

    public void hideIcon() {
        showIcon = false;
    }

    public void drawIcon(int x, int y, int lev) {
        if (!showIcon) {
            return;
        }
        int height = 97;
        Tools.addRect((byte)1, x, y, 320, height, true, 20, 0, lev);
        Tools.addRect((byte)1, x - 1, y, 322, height - 1, false, 20, 0xFFFFFF, lev);
        int num = 2;
        int len = 2;
        int i = 0;
        while (i < len) {
            int startX = -((GameMIDlet.gameIndex * 10 + 58 * i) % 176) + GameMap.setOffX;
            int startY = 52 * i + y;
            int j = 0;
            while (j < num) {
                Tools.addImage(322, startX + j * 176, startY, 20, (byte)0, lev);
                ++j;
            }
            ++i;
        }
        short[] img = new short[]{324, -1, -1, -1, -1};
        if (iconIndex < 18) {
            Tools.addImage(img[iconID], x - 120 + 40 * Math.min(3, iconIndex), y + 5, 20, (byte)0, lev);
        } else {
            Tools.addImage(img[iconID], x - 120 + 40 * Math.max(4, iconIndex - 14), y + 5, 20, (byte)0, lev);
        }
        if (++iconIndex >= 24) {
            this.hideIcon();
            GameEngine.finish();
        }
    }

    static void showLight(int x, int y, boolean smaller) {
        beSmall = smaller;
        showLight = true;
        lightIndex = (byte)(beSmall ? 10 : 0);
        lightX = (short)x;
        lightY = (short)y;
    }

    void drawLight() {
        if (!showLight) {
            return;
        }
        int i = 0;
        while (i < 3) {
            Tools.addARC((byte)2, lightX - 320, lightY - 320, 640, 640, 30 + 120 * i + lightIndex * 75, 30, true, 20, 0xFFFFFF, 3000);
            ++i;
        }
        int r = 1 + 50 * Math.max(0, lightIndex - 3);
        Tools.addARC((byte)2, lightX - r, lightY - r, r + r, r + r, 0, 360, true, 20, 0xFFFFFF, 3000);
        if (beSmall) {
            if ((lightIndex = (byte)(lightIndex - 1)) <= 0) {
                showLight = false;
                lightIndex = 0;
                GameEngine.finish();
            }
        } else if (lightIndex < 10 && (lightIndex = (byte)(lightIndex + 1)) == 10) {
            GameEngine.finish();
            lightIndex = (byte)15;
        }
    }

    static void showHole(int x, int y, boolean smaller) {
        smallHole = smaller;
        showHole = true;
        holeIndex = (byte)(smaller ? 15 : 0);
        holeX = (short)x;
        holeY = (short)y;
    }

    void drawHole() {
        if (!showHole) {
            return;
        }
        int r = 1 + 20 * Math.max(0, holeIndex);
        Tools.addARC((byte)2, holeX - r * 2, holeY - r, r * 4, r * 2, 0, 360, true, 20, 0, 1);
        if (smallHole) {
            if ((holeIndex = (byte)(holeIndex - 1)) <= 0) {
                showHole = false;
                holeIndex = 0;
                GameEngine.finish();
            }
        } else if (holeIndex < 15 && (holeIndex = (byte)(holeIndex + 1)) == 15) {
            GameEngine.finish();
        }
    }

    public void drawStar(Graphics g) {
        g.setColor(0);
        g.fillRect(0, 0, 320, 240);
        this.draw(g);
    }

    static void init() {
        x = new short[150];
        y = new short[150];
        z = new short[150];
        int i = 0;
        while (i < 150) {
            GameEngine.x[i] = (short)((rnd.nextInt() >>> 1) % 320 - centerX);
            GameEngine.y[i] = (short)((rnd.nextInt() >>> 1) % 240 - centerY);
            GameEngine.z[i] = (short)((rnd.nextInt() >>> 1) % 100);
            if (x[i] == 0 && y[i] == 0) {
                GameEngine.x[i] = 10;
            }
            ++i;
        }
    }

    void draw(Graphics g) {
        int i = 0;
        while (i < 150) {
            int n = i;
            z[n] = (short)(z[n] - 4);
            if (z[i] < -31) {
                GameEngine.z[i] = 100;
            }
            int hh = x[i] * 64 / (32 + z[i]);
            int vv = y[i] * 64 / (32 + z[i]);
            int h = hh + centerX;
            int v = vv + centerY;
            if (h < 0 || h > 2 * centerX) {
                GameEngine.z[i] = 100;
            }
            if (v < 0 || v > 2 * centerY) {
                GameEngine.z[i] = 100;
            }
            if (z[i] > 50) {
                g.setColor(0x808080);
            } else if (z[i] > 25) {
                g.setColor(0xC0C0C0);
            } else {
                g.setColor(0xFFFFFF);
            }
            int d = (100 - z[i]) / 50;
            if (d == 0) {
                d = 1;
            }
            g.fillRect(h, v, d, d);
            ++i;
        }
    }

    public static boolean isAllOpen() {
        int i = 0;
        while (i < sprite.length) {
            if (GameEngine.sprite[i].curStates != 7 && GameEngine.sprite[i].modle == 37) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isOpen(int id) {
        return GameEngine.sprite[id].curStates == 7 && GameEngine.sprite[id].modle == 37;
    }

    public static boolean isAllOpen(short[] data) {
        int i = 0;
        while (i < data.length) {
            if (!GameEngine.isOpen(data[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static void sender(Event event1, int pathIndex) {
        GameEngine.finish();
        event = event1;
        path = pathIndex;
    }

    public static void finish() {
        if (event == null) {
            return;
        }
        event.setEnd(path);
        event = null;
    }

    public void drawFlame(int x, int y, int size0_1, int drawLevel) {
        byte[] indent = new byte[]{0, -1, 0, 0, -1, 0};
        byte[] motion = size0_1 == 0 ? new byte[]{0, 0, 1, 1, 2, 2} : new byte[]{3, 3, 4, 4, 5, 5};
        Tools.addImage(293, x + indent[motion[MyGameCanvas.gameTime % motion.length]], y, this.FlameArray[motion[MyGameCanvas.gameTime % motion.length]], 36, (byte)0, drawLevel);
    }

    public void drawSword(int x, int y, int drawLevel, int state) {
        switch (state) {
            case 0: {
                Tools.addImage(234, x - 9, y, this.swordData[3], 20, (byte)0, drawLevel);
                Tools.addImage(234, x, y, this.swordData[3], 20, (byte)1, drawLevel);
                break;
            }
            case 1: {
                Tools.addImage(234, x - 6, y, this.swordData[2], 20, (byte)1, drawLevel);
                break;
            }
            case 2: {
                Tools.addImage(234, x - 1, y, this.swordData[1], 20, (byte)1, drawLevel);
                break;
            }
            case 3: {
                Tools.addImage(234, x - 8, y, this.swordData[2], 20, (byte)0, drawLevel);
                break;
            }
            default: {
                Tools.addImage(234, x - 5, y, this.swordData[0], 20, (byte)0, drawLevel);
            }
        }
    }

    public void drawSword(int x, int y, int drawLevel, boolean isDeasil, byte state) {
        byte[] motion = new byte[]{0, 1, 2, 3};
        switch (state) {
            case 0: {
                motion = isDeasil ? new byte[]{0, 1, 2, 3} : new byte[]{0, 3, 2, 1};
                this.drawSword(x, y, drawLevel, motion[MyGameCanvas.gameTime % 8 / 2]);
                break;
            }
            case 1: {
                this.drawSword(x, y, drawLevel, 0);
                break;
            }
        }
    }

    public void drawStar(int x, int y, int drawLevel) {
        byte[][] clipdata = new byte[][]{{0, 0, 9, 9}, {0, 10, 10, 11}, {0, 22, 11, 11}};
        byte[] motion = new byte[]{0, 1, 2};
        switch (MyGameCanvas.gameTime % 6 / 2) {
            case 0: {
                Tools.addImage(259, x, y, clipdata[motion[0]], 20, (byte)0, drawLevel);
                break;
            }
            case 1: {
                Tools.addImage(259, x, y, clipdata[motion[1]], 20, (byte)0, drawLevel);
                break;
            }
            case 2: {
                Tools.addImage(259, x - 1, y, clipdata[motion[2]], 20, (byte)0, drawLevel);
            }
        }
    }

    public void drawSpace(int x, int y, int drawLevel) {
        this.runIndex += 30;
        if (this.runIndex >= 240) {
            this.runIndex = 0;
        }
        Tools.addImage(221, x + this.bglen + this.runIndex, y, 20, (byte)0, drawLevel);
        Tools.addImage(221, x + this.runIndex, y, 20, (byte)0, drawLevel);
        Tools.addImage(221, x - this.bglen + this.runIndex, y, 20, (byte)0, drawLevel);
    }

    public void drawRoleFire(int x, int y, int drawLevel) {
        int[][] array = new int[][]{{0, 93, 37, 82}, {38, 93, 32, 84}, {71, 93, 36, 78}};
        byte[][] addXY = new byte[][]{{-2, 0}, {0, 0}, {-2, 0}};
        byte[] motion = new byte[]{0, 0, 1, 1, 2, 2};
        byte index = motion[GameMIDlet.gameIndex % motion.length];
        Tools.addImage(297, x + addXY[index][0], y + addXY[index][1], array[index], 20, (byte)0, drawLevel);
    }

    static {
        rnd = new Random();
        gameRank = 0;
        gameFinish = false;
        equips = new Vector();
        items = new Vector();
        souls = new Vector();
        others = new Vector();
        roleTeam = new byte[]{0};
        roleIndex = 0;
        isShowGame = true;
        isNoMap = true;
        ismove = false;
        on = true;
        erupt = false;
        playX = (short)-1;
        playY = (short)-1;
        playDir = (short)-1;
        size = (byte)15;
        screenFlashTime = 0;
        screenFlashColor = 0;
        isToPoint = false;
        isShowBox = true;
        shakeWave = 3;
        initRank = 0;
        vEnemys = new Vector();
        centerX = 160;
        centerY = 120;
        isOpen = false;
    }
}

