/*
 * Decompiled with CFR 0.152.
 */
public final class Fighter {
    public static final byte STATUS_STOP = 0;
    public static final byte STATUS_MAGIC = 1;
    public static final byte STATUS_INJURE = 2;
    public static final byte STATUS_DEAD = 4;
    public static final byte STATUS_ATTACK = 5;
    public static final byte STATUS_BACK = 6;
    public static final byte STATUS_MISS = 7;
    public static final byte STATUS_SKILL1 = 8;
    public static final byte STATUS_SKILL2 = 9;
    public static final byte STATUS_SKILL3 = 10;
    public static final byte STATUS_SKILL4 = 11;
    public static final byte STATUS_SKILLING = 12;
    public static final byte STATUS_SPURTATTACK = 13;
    public static final byte STATUS_SKILL5 = 14;
    public static final byte STATUS_MOVE = 15;
    public static final byte STATUS_CURE = 16;
    byte curStatus;
    int x;
    int y;
    short[][] addXY;
    boolean isMirror;
    int index;
    byte[] motion;
    int sx;
    int sy;
    int bx;
    int by;
    short spurtX;
    short spurtY;
    byte curIndex;
    byte nextStatus;
    byte injureindex;
    static byte levelMax = (byte)60;
    byte type;
    String name;
    byte level = 1;
    int exp;
    int exp_max;
    int hp;
    int hp_max;
    int mp;
    int mp_max;
    short attack;
    short defend;
    short pimm;
    byte crit;
    byte miss;
    byte doubleHit;
    byte suck;
    byte fightBack;
    byte deflect;
    byte resist;
    byte skillCrit;
    byte speed;
    int getMoney;
    public static final byte EQ_\u6b66\u5668 = 0;
    public static final byte EQ_\u9632\u5177 = 1;
    public static final byte EQ_\u9970\u54c11 = 2;
    public static final byte EQ_\u9970\u54c12 = 3;
    short[][] equips = new short[4][7];
    static final byte SK_ID = 0;
    static final byte SK_CD = 1;
    static final byte SK_\u4f24\u5bb3 = 2;
    static final byte SK_\u6d88\u8017 = 3;
    static final byte SK_\u72b6\u6001 = 4;
    static final byte SK_\u9644\u52a0\u51e0\u7387 = 5;
    byte[][] skills;
    byte[] actions;
    byte[][] talentTree;
    short talentPoint = 0;
    short imgRole;
    byte model;
    byte AItype;
    byte attMode;
    int hurtValue;
    byte actionTime;
    public int team;
    short[][] buff = new short[7][2];
    public static final byte B_\u6bd2 = 0;
    public static final byte B_\u7761\u7720 = 1;
    public static final byte B_\u660f = 2;
    public static final byte B_\u5c01\u7269 = 3;
    public static final byte B_\u5c01\u8ba1 = 4;
    public static final byte B_\u653b\u51fb\u53d8\u52a8 = 5;
    public static final byte B_\u9632\u5fa1\u53d8\u52a8 = 6;
    public GameEngine engine;
    Fighter f;
    byte tempx = 0;
    boolean isShowRole = true;
    byte buffIndex;
    byte buffType;
    boolean isBack;
    public static final byte M_CURINDEX = 0;
    public static final byte M_TRANS = 1;
    public static final byte M_FRAMETIMES = 2;
    public static final byte M_ADJUSTX = 3;
    public static final byte M_ADJUSTXDGX = 4;
    public static final byte M_ADJUSTY = 5;
    public static final byte M_ADJUSTYDGX = 6;
    byte adjustX;
    byte adjustY;
    byte frameTimes = 0;
    byte frameNo;
    byte trans;

    public Fighter(GameEngine ge) {
        this.engine = ge;
    }

    public void setObject(Fighter f) {
        this.f = f;
    }

    private void initRole(byte type) {
        this.level = 1;
        this.exp = 0;
        this.exp_max = Fighter.getStandardExpMax(type, this.level);
        this.skills = null;
        this.talentPoint = 1;
        this.talentTree = new byte[15][2];
        int i = 0;
        while (i < this.talentTree.length) {
            this.talentTree[i][0] = GameData.roleTalent[type][i];
            ++i;
        }
        this.upDateProp();
        this.hp = this.hp_max;
        this.mp = this.mp_max;
    }

    public void initFighter(byte type, boolean isElite) {
        int i;
        this.type = type;
        String string = this.name = isElite ? "\u9b42\u4e4b\u5316\u8eab" : GameData.fighterName[type];
        if (GameData.actions[type] != null) {
            this.actions = new byte[GameData.actions[type].length];
            i = 0;
            while (i < this.actions.length) {
                this.actions[i] = GameData.actions[type][i];
                ++i;
            }
        }
        this.AItype = (byte)GameData.props[type][0];
        this.model = (byte)GameData.props[type][1];
        this.level = (byte)GameData.props[type][2];
        this.hp_max = GameData.hps[type] * (isElite ? 2 : 1);
        this.exp = GameData.props[type][3] * (isElite ? 2 : 1);
        this.getMoney = GameData.props[type][4];
        this.attack = (short)(GameData.props[type][5] * (isElite ? 3 : 2) / 2);
        this.speed = (byte)GameData.props[type][6];
        this.pimm = (byte)GameData.props[type][7];
        this.doubleHit = (byte)GameData.props[type][8];
        this.fightBack = (byte)GameData.props[type][9];
        this.deflect = (byte)GameData.props[type][10];
        this.suck = (byte)GameData.props[type][11];
        this.resist = (byte)GameData.props[type][12];
        this.miss = (byte)(type > 2 && this.level < 5 ? 0 : 5);
        this.crit = (byte)(type > 2 && this.level < 5 ? 0 : 5);
        this.skillCrit = 0;
        this.index = 0;
        this.setStatus((byte)0);
        this.actionTime = 1;
        this.hp = this.hp_max;
        this.imgRole = GameEngine.getImageIndex("f" + this.model);
        i = 0;
        while (i < this.equips.length) {
            this.equips[i][0] = -1;
            ++i;
        }
        if (type < 3) {
            this.initRole(type);
            this.setPimm();
        }
        this.attMode = 0;
        if (this.model == 2) {
            this.attMode = 1;
        }
        if (this.model == 5) {
            this.attMode = (byte)39;
        }
        if (this.model == 31) {
            this.attMode = (byte)40;
        }
    }

    public void initBattle(int px, int py) {
        this.bx = this.x = px;
        this.by = this.y = py;
        this.actionTime = 1;
        this.curStatus = 0;
        this.nextStatus = 0;
        this.index = 0;
        this.initBuff();
        this.isMirror = this.team == 0;
    }

    public void initBuff() {
        int i = 0;
        while (i < this.buff.length) {
            int j = 0;
            while (j < this.buff[i].length) {
                this.buff[i][j] = 0;
                ++j;
            }
            ++i;
        }
    }

    public void levelUp() {
        this.level = (byte)(this.level + 1);
        this.upDateProp();
        this.hp = this.hp_max;
        this.mp = this.mp_max;
        this.exp = Math.max(0, this.exp - this.exp_max);
        if (this.level >= levelMax) {
            this.exp = 0;
        }
        this.exp_max = Fighter.getStandardExpMax(this.type, this.level);
        this.talentPoint = (short)(this.talentPoint + 1);
    }

    public void feeLevel() {
        if (this.level <= 57) {
            this.level = (byte)(this.level + 3);
            this.talentPoint = (short)(this.talentPoint + 3);
        } else if (this.level == 58) {
            this.level = (byte)(this.level + 2);
            this.talentPoint = (short)(this.talentPoint + 2);
        } else if (this.level == 59) {
            this.level = (byte)(this.level + 1);
            this.talentPoint = (short)(this.talentPoint + 1);
        }
        this.upDateProp();
        this.hp = this.hp_max;
        this.mp = this.mp_max;
        this.exp = Math.max(0, this.exp - this.exp_max);
        if (this.level >= levelMax) {
            this.exp = 0;
        }
        this.exp_max = Fighter.getStandardExpMax(this.type, this.level);
    }

    void setLevel(int lev) {
        this.level = (byte)lev;
        this.upDateProp();
        this.hp = this.hp_max;
        this.mp = this.mp_max;
        this.exp_max = Fighter.getStandardExpMax(this.type, this.level);
        this.talentPoint = this.level;
    }

    public void addSkill(byte skillID) {
        if (this.skills == null) {
            this.skills = new byte[][]{{skillID, 0, -1, 0}};
        } else {
            byte[][] newSkill = new byte[this.skills.length + 1][4];
            System.arraycopy(this.skills, 0, newSkill, 0, this.skills.length);
            newSkill[this.skills.length][0] = skillID;
            newSkill[this.skills.length][2] = -1;
            this.skills = newSkill;
        }
    }

    public void reduceAllSkill() {
        this.skills = null;
    }

    public void reduceSkill(byte skillID) {
        if (this.skills == null) {
            return;
        }
        boolean hasSkill = false;
        int i = 0;
        while (i < this.skills.length) {
            if (skillID == this.skills[i][0]) {
                hasSkill = true;
            }
            ++i;
        }
        if (hasSkill) {
            if (this.skills.length == 1) {
                this.skills = null;
            } else {
                byte[][] newSkill = new byte[this.skills.length - 1][2];
                int max = 0;
                int i2 = 0;
                while (i2 < newSkill.length) {
                    if (skillID != this.skills[i2][0]) {
                        newSkill[max][0] = this.skills[i2][0];
                        newSkill[max][2] = this.skills[i2][2];
                        newSkill[max][3] = this.skills[i2][3];
                        ++max;
                    }
                    ++i2;
                }
                this.skills = newSkill;
            }
        }
    }

    public void paint(int offY) {
        if (!this.isShowRole) {
            return;
        }
        if (this.imgRole == -1 || this.model > 2 && this.index < 0) {
            return;
        }
        this.drawBuff(GameData.fighterOff[this.model]);
        int dl = this.y + 30 + offY;
        Tools.drawFrame(this.imgRole, GameData.fighterFrameData[this.model], GameData.fighterClipData[this.model], this.sx + this.adjustX, this.sy + this.adjustY, (int)this.curIndex, this.trans != 0, dl);
        this.engine.drawShandow(this.x + GameData.fighterOff[this.model][2] * (this.isMirror ? 1 : -1), this.y, GameData.fighterOff[this.model][3], GameMIDlet.gameIndex % 6 / 3 == 0 ? 6 : 8, 0x1F1F1F, 30);
        if (God.showHP && this.team == 0) {
            Tools.addRect((byte)1, this.x - 15, this.y + 3, this.hp * 30 / this.hp_max, 5, true, 20, 0xFF0000, dl);
            Tools.addRect((byte)1, this.x - 15, this.y + 3, 29, 4, false, 20, 0, dl);
        }
    }

    boolean canAction() {
        return this.buff[1][0] == 0 && this.buff[2][0] == 0;
    }

    void drawBuff(byte[] offset) {
        int temp;
        if (this.hp <= 0) {
            return;
        }
        if (this.buff[this.buffType][0] == 0) {
            int i = 1;
            while (i < this.buff.length) {
                byte next = (byte)((this.buffType + i) % this.buff.length);
                if (this.buff[next][0] != 0) {
                    this.buffType = next;
                    break;
                }
                ++i;
            }
        }
        byte tempX = this.isMirror ? -offset[0] : offset[0];
        int tempY = offset[1] + 7;
        if (this.buff[0][0] != 0 && this.buffType == 0) {
            Tools.addImage(315, this.x - 14 + tempX, this.y - tempY, MyGameCanvas.gameTime % 4 * 28, 0, 28, 28, 36, (byte)0, this.y + 31);
        }
        if (this.buff[1][0] != 0 && this.buffType == 1 && (temp = MyGameCanvas.gameTime % 6) < 4) {
            Tools.addImage(316, this.x + 4 + tempX, this.y - tempY, temp * 10, 0, 10, 13, 36, (byte)0, this.y + 31);
        }
        if (this.buff[2][0] != 0 && this.buffType == 2) {
            Tools.addImage(317, this.x - 18 + tempX, this.y + 8 - tempY, 0, MyGameCanvas.gameTime % 3 * 19, 35, 19, 36, (byte)0, this.y + 31);
        }
        if (this.buff[4][0] != 0 && this.buffType == 4) {
            Tools.addImage(318, this.x - 8 + tempX, this.y - tempY, 17 * (MyGameCanvas.gameTime % 4 / 2), 0, 17, 17, 36, (byte)0, this.y + 31);
        }
        if (this.buff[5][0] != 0 && this.buffType == 5) {
            if (this.buff[5][1] > 0) {
                Tools.addImage(22, this.x - 8 + tempX, this.y - tempY, MyGameCanvas.gameTime % 3 * 15, 0, 15, 22, 36, (byte)0, this.y + 31);
                Tools.addImage(335, this.x + 8 + tempX, this.y - tempY, MyGameCanvas.gameTime % 5 * 5, 0, 5, 7, 36, (byte)0, this.y + 31);
            } else {
                Tools.addImage(23, this.x - 4 + tempX, this.y - tempY, 36, (byte)0, this.y + 31);
                Tools.addImage(107, this.x + 4 + tempX, this.y - tempY, MyGameCanvas.gameTime % 5 * 5, 0, 5, 7, 36, (byte)0, this.y + 31);
            }
        }
        if (this.buff[6][0] != 0 && this.buffType == 6) {
            if (this.buff[6][1] > 0) {
                Tools.addImage(103, this.x - 10 + tempX, this.y - tempY, MyGameCanvas.gameTime % 4 * 19, 0, 19, 23, 36, (byte)0, this.y + 31);
                Tools.addImage(335, this.x + 10 + tempX, this.y - tempY, MyGameCanvas.gameTime % 5 * 5, 0, 5, 7, 36, (byte)0, this.y + 31);
            } else {
                Tools.addImage(104, this.x - 6 + tempX, this.y - tempY, 36, (byte)0, this.y + 31);
                Tools.addImage(107, this.x + 6 + tempX, this.y - tempY, MyGameCanvas.gameTime % 5 * 5, 0, 5, 7, 36, (byte)0, this.y + 31);
            }
        }
        if ((this.buffIndex = (byte)(this.buffIndex + 1)) >= 20) {
            this.buffIndex = 0;
            int i = 1;
            while (i < this.buff.length) {
                byte next = (byte)((this.buffType + i) % this.buff.length);
                if (this.buff[next][0] != 0) {
                    this.buffType = next;
                    break;
                }
                ++i;
            }
        }
    }

    void getCurIndex() {
        this.curIndex = this.motion[this.index];
        this.x += this.addXY == null ? 0 : this.addXY[0][this.index] * (this.isMirror ? -1 : 1);
        this.y += this.addXY == null ? 0 : this.addXY[1][this.index];
    }

    public void run() {
        if (this.curStatus != this.nextStatus) {
            this.index = 0;
            this.curStatus = this.nextStatus;
        }
        if (this.isBack) {
            this.isBack = false;
            this.x = this.bx;
            this.y = this.by;
        }
        switch (this.model) {
            default: 
        }
        this.move0();
    }

    public void move0() {
        switch (this.curStatus) {
            case 14: {
                this.setMotionVaules((byte)14, this.isMirror);
                if (this.index == 0) {
                    this.x += this.addXY == null ? 0 : this.addXY[0][0] * (this.trans == 0 ? 1 : -1);
                    this.y += this.addXY == null ? 0 : this.addXY[1][0];
                }
                this.sx = this.x;
                this.sy = this.y;
                this.frameTimes = (byte)(this.frameTimes - 1);
                if (this.frameTimes <= 0) {
                    ++this.index;
                }
                if (this.index == (GameData.fighterMotionData[this.model] == null ? 0 : GameData.fighterMotionData[this.model][14].length)) {
                    this.index = 0;
                    this.frameTimes = 0;
                    this.setStatus((byte)12);
                }
                if (this.index == 0 && this.frameTimes == 11 && this.model == 0) {
                    this.drawCurIndexEffect(0, this.x + 10, this.y - 35, 16, 0, this.y + 30);
                }
                if (this.model != 2) break;
                this.drawCurIndexEffect(4, this.x, this.y - 100, 61, 0, this.y + 30 + 1);
                break;
            }
            case 9: {
                this.setMotionVaules((byte)9, this.isMirror);
                short spurtWidth = (short)Math.abs(this.spurtX - this.bx);
                short spurtHeight = (short)(this.spurtY - this.by);
                this.addXY = new short[][]{{-spurtWidth, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {(short)(spurtHeight == 0 ? 0 : Math.abs(spurtHeight) * (spurtHeight > 0 ? 1 : -1)), 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}};
                if (this.index == 1) {
                    this.x += this.addXY == null ? 0 : this.addXY[0][0] * (this.trans == 0 ? 1 : -1);
                    this.y += this.addXY == null ? 0 : this.addXY[1][0];
                }
                this.sx = this.x;
                this.sy = this.y;
                this.frameTimes = (byte)(this.frameTimes - 1);
                if (this.frameTimes <= 0) {
                    ++this.index;
                }
                if (this.index != (GameData.fighterMotionData[this.model] == null ? 0 : GameData.fighterMotionData[this.model][9].length)) break;
                this.index = 0;
                this.frameTimes = 0;
                this.setStatus((byte)0);
                break;
            }
            case 8: {
                this.setMotionVaules((byte)8, this.isMirror);
                this.x += this.addXY == null ? 0 : this.addXY[0][this.index] * (this.trans == 0 ? 1 : -1);
                this.y += this.addXY == null ? 0 : this.addXY[1][this.index];
                this.sx = this.x;
                this.sy = this.y;
                this.frameTimes = (byte)(this.frameTimes - 1);
                if (this.frameTimes <= 0) {
                    ++this.index;
                }
                if (this.index != (GameData.fighterMotionData[this.model] == null ? 0 : GameData.fighterMotionData[this.model][8].length)) break;
                this.index = 0;
                this.frameTimes = 0;
                this.setStatus((byte)12);
                break;
            }
            case 12: {
                this.setMotionVaules((byte)12, this.isMirror);
                this.addXY = null;
                this.x += this.addXY == null ? 0 : this.addXY[0][this.index] * (this.trans == 0 ? 1 : -1);
                this.y += this.addXY == null ? 0 : this.addXY[1][this.index];
                this.sx = this.x;
                this.sy = this.y;
                this.frameTimes = (byte)(this.frameTimes - 1);
                if (this.frameTimes <= 0) {
                    ++this.index;
                }
                if (this.index != (GameData.fighterMotionData[this.model] == null ? 0 : GameData.fighterMotionData[this.model][12].length)) break;
                this.index = 0;
                this.frameTimes = 0;
                this.setStatus((byte)12);
                break;
            }
            case 10: {
                this.setMotionVaules((byte)10, this.isMirror);
                short spurtWidth = (short)Math.abs(this.spurtX - this.bx);
                short spurtHeight = (short)(this.spurtY - this.by);
                this.addXY = new short[][]{{-spurtWidth, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {(short)(spurtHeight == 0 ? 0 : Math.abs(spurtHeight) * (spurtHeight > 0 ? 1 : -1)), 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}};
                if (this.index == 0) {
                    this.x += this.addXY == null ? 0 : this.addXY[0][0] * (this.trans == 0 ? 1 : -1);
                    this.y += this.addXY == null ? 0 : this.addXY[1][0];
                }
                this.sx = this.x;
                this.sy = this.y;
                this.frameTimes = (byte)(this.frameTimes - 1);
                if (this.frameTimes <= 0) {
                    ++this.index;
                }
                if (this.index == (GameData.fighterMotionData[this.model] == null ? 0 : GameData.fighterMotionData[this.model][10].length)) {
                    this.index = 0;
                    this.frameTimes = 0;
                    this.setStatus((byte)0);
                    this.engine.actionOver();
                    this.engine.isOver = true;
                }
                if (this.index == 11) {
                    GameEngine.shakeTime = 12;
                }
                if (this.index > 10) {
                    GameEngine.drawColorScreenBG(0, 20);
                }
                this.drawCurIndexEffect(12, this.x - 20, this.y, 15, 0, this.y + 30 + 1);
                break;
            }
            case 11: {
                this.setMotionVaules((byte)11, this.isMirror);
                short spurtWidth = (short)Math.abs(this.spurtX - this.bx);
                short spurtHeight = (short)(this.spurtY - this.by);
                this.addXY = new short[][]{{(short)(-(spurtWidth - 8)), -5, -3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {(short)(spurtHeight == 0 ? 0 : (Math.abs(spurtHeight) - 8) * (spurtHeight > 0 ? 1 : -1)), (short)(spurtHeight == 0 ? 0 : 5 * (spurtHeight > 0 ? 1 : -1)), (short)(spurtHeight == 0 ? 0 : 3 * (spurtHeight > 0 ? 1 : -1)), 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}};
                if (this.index == 0 && this.frameTimes > 26) {
                    this.x += this.addXY == null ? 0 : this.addXY[0][30 - this.frameTimes] * (this.trans == 0 ? 1 : -1);
                    this.y += this.addXY == null ? 0 : this.addXY[1][30 - this.frameTimes];
                }
                this.sx = this.x;
                this.sy = this.y;
                this.frameTimes = (byte)(this.frameTimes - 1);
                if (this.frameTimes <= 0) {
                    ++this.index;
                }
                if (this.index == (GameData.fighterMotionData[this.model] == null ? 0 : GameData.fighterMotionData[this.model][11].length)) {
                    this.index = 0;
                    this.frameTimes = 0;
                    this.setStatus((byte)0);
                    this.engine.actionOver();
                }
                if (this.index == 0 && this.frameTimes == 28) {
                    this.drawCurIndexEffect(0, this.x, this.y, 15, 0, this.y + 30 - 1);
                }
                if (this.index == 0 && this.frameTimes == 20) {
                    this.drawCurIndexEffect(0, this.x, this.y, 15, 0, this.y + 30 - 1);
                }
                if (this.index == 0 && this.frameTimes == 12) {
                    this.drawCurIndexEffect(0, this.x, this.y, 15, 0, this.y + 30 - 1);
                }
                this.drawCurIndexEffect(1, this.x - 45, this.y + 5, 14, 0, this.y + 30 - 1);
                break;
            }
            case 13: {
                this.setMotionVaules((byte)13, this.isMirror);
                short spurtWidth = (short)Math.abs(this.spurtX - this.bx);
                short spurtHeight = (short)(this.spurtY - this.by);
                this.addXY = new short[][]{{(short)(-(spurtWidth - 8)), -5, -3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {(short)(spurtHeight == 0 ? 0 : (Math.abs(spurtHeight) - 8) * (spurtHeight > 0 ? 1 : -1)), (short)(spurtHeight == 0 ? 0 : 5 * (spurtHeight > 0 ? 1 : -1)), (short)(spurtHeight == 0 ? 0 : 3 * (spurtHeight > 0 ? 1 : -1)), 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}};
                this.x += this.addXY == null ? 0 : this.addXY[0][this.index] * (this.trans == 0 ? 1 : -1);
                this.y += this.addXY == null ? 0 : this.addXY[1][this.index];
                this.sx = this.x;
                this.sy = this.y;
                ++this.index;
                if (this.index != (GameData.fighterMotionData[this.model] == null ? 0 : GameData.fighterMotionData[this.model][13].length)) break;
                this.index = 0;
                this.frameTimes = 0;
                this.engine.actionOver();
                this.setStatus((byte)0);
                break;
            }
            case 6: {
                this.setMotionVaules((byte)6, this.isMirror);
                short backWidth = (short)Math.abs(this.bx - this.spurtX);
                short backHeight = (short)(this.by - this.spurtY);
                this.addXY = new short[][]{{2, 3, (short)(backWidth - 10), 3, 2, 0, 0, 0}, {(short)(backHeight == 0 ? 0 : 2 * (backHeight > 0 ? 1 : -1)), (short)(backHeight == 0 ? 0 : 3 * (backHeight > 0 ? 1 : -1)), (short)(backHeight == 0 ? 0 : (Math.abs(backHeight) - 10) * (backHeight > 0 ? 1 : -1)), (short)(backHeight == 0 ? 0 : 3 * (backHeight > 0 ? 1 : -1)), (short)(backHeight == 0 ? 0 : 2 * (backHeight > 0 ? 1 : -1)), 0, 0, 0}};
                this.x += this.addXY == null ? 0 : this.addXY[0][this.index] * (this.trans == 0 ? 1 : -1);
                this.y += this.addXY == null ? 0 : this.addXY[1][this.index];
                this.sx = this.x;
                this.sy = this.y;
                ++this.index;
                if (this.index != (GameData.fighterMotionData[this.model] == null ? 0 : GameData.fighterMotionData[this.model][6].length)) break;
                this.frameTimes = 0;
                this.isBack = true;
                this.setStatus((byte)0);
                this.engine.actionOver();
                break;
            }
            case 5: {
                this.addXY = null;
                if (this.index == (GameData.fighterMotionData[this.model] == null ? 0 : GameData.fighterMotionData[this.model][5].length)) {
                    this.index = 0;
                    this.frameTimes = 0;
                    this.setStatus((byte)0);
                    this.engine.actionOver();
                }
                this.x += this.addXY == null ? 0 : this.addXY[0][this.index] * (this.isMirror ? -1 : 1);
                this.y += this.addXY == null ? 0 : this.addXY[1][this.index];
                this.sx = this.x;
                this.sy = this.y;
                this.setMotionVaules((byte)5, this.isMirror);
                int time = GameData.fighterMotionData[this.model][5].length - 1;
                switch (this.model) {
                    case 1: {
                        this.drawCurIndexEffect(time - 2, this.f.x, this.f.y - 15, 4, this.team == 0 ? 1 : 0, this.f.y + 30 + 1);
                        break;
                    }
                    case 5: {
                        break;
                    }
                    case 31: {
                        this.drawCurIndexEffect(time - 7, this.f.x + 5, this.f.y, 50, this.team == 0 ? 1 : 0, this.f.y + 30 + 1);
                    }
                }
                this.frameTimes = (byte)(this.frameTimes - 1);
                if (this.frameTimes > 0) break;
                ++this.index;
                break;
            }
            case 7: {
                this.addXY = null;
                if (this.index == (GameData.fighterMotionData[this.model] == null ? 0 : GameData.fighterMotionData[this.model][7].length)) {
                    this.index = 0;
                    this.frameTimes = 0;
                    this.setStatus((byte)0);
                }
                this.x += this.addXY == null ? 0 : this.addXY[0][this.index] * (this.isMirror ? -1 : 1);
                this.y += this.addXY == null ? 0 : this.addXY[1][this.index];
                this.sx = this.x;
                this.sy = this.y;
                this.setMotionVaules((byte)7, this.isMirror);
                this.frameTimes = (byte)(this.frameTimes - 1);
                if (this.frameTimes > 0) break;
                ++this.index;
                break;
            }
            case 0: {
                this.addXY = null;
                if (this.index == (GameData.fighterMotionData[this.model] == null ? 0 : GameData.fighterMotionData[this.model][0].length)) {
                    this.index = 0;
                    this.frameTimes = 0;
                    this.setStatus((byte)0);
                }
                this.x += this.addXY == null ? 0 : this.addXY[0][this.index] * (this.isMirror ? -1 : 1);
                this.y += this.addXY == null ? 0 : this.addXY[1][this.index];
                this.sx = this.x;
                this.sy = this.y;
                this.setMotionVaules((byte)0, this.isMirror);
                this.frameTimes = (byte)(this.frameTimes - 1);
                if (this.frameTimes > 0) break;
                ++this.index;
                break;
            }
            case 16: {
                this.addXY = null;
                if (this.index == (GameData.fighterMotionData[this.model] == null ? 0 : GameData.fighterMotionData[this.model][16].length)) {
                    this.index = 0;
                    this.frameTimes = 0;
                    this.setStatus((byte)0);
                }
                this.x += this.addXY == null ? 0 : this.addXY[0][this.index] * (this.isMirror ? -1 : 1);
                this.y += this.addXY == null ? 0 : this.addXY[1][this.index];
                this.sx = this.x;
                this.sy = this.y;
                this.setMotionVaules((byte)16, this.isMirror);
                this.frameTimes = (byte)(this.frameTimes - 1);
                if (this.frameTimes > 0) break;
                ++this.index;
                break;
            }
            case 1: {
                this.addXY = null;
                if (this.index == (GameData.fighterMotionData[this.model] == null ? 0 : GameData.fighterMotionData[this.model][1].length)) {
                    this.index = 0;
                    this.frameTimes = 0;
                    this.setStatus((byte)0);
                }
                this.x += this.addXY == null ? 0 : this.addXY[0][this.index] * (this.isMirror ? -1 : 1);
                this.y += this.addXY == null ? 0 : this.addXY[1][this.index];
                this.sx = this.x;
                this.sy = this.y;
                this.setMotionVaules((byte)1, this.isMirror);
                this.frameTimes = (byte)(this.frameTimes - 1);
                if (this.frameTimes <= 0) {
                    ++this.index;
                }
                this.drawCurIndexEffect(0, this.x, this.y - 25, 1, 0, this.y + 30);
                break;
            }
            case 2: {
                if (this.model > 2) {
                    this.addXY = new short[][]{{0, 5, 3, 5, 3, 2, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0}};
                    this.sx = this.x + this.addXY[0][this.injureindex] * (this.isMirror ? -1 : 1);
                    this.sy = this.y;
                    this.setMotionVaules((byte)0, this.isMirror);
                    this.injureindex = (byte)(this.injureindex + 1);
                    if (this.injureindex < this.addXY[0].length) break;
                    this.injureindex = 0;
                    this.setStatus((byte)0);
                    return;
                }
                this.addXY = null;
                if (this.index == (GameData.fighterMotionData[this.model] == null ? 0 : GameData.fighterMotionData[this.model][2].length)) {
                    this.index = 0;
                    this.frameTimes = 0;
                    this.setStatus((byte)0);
                }
                this.x += this.addXY == null ? 0 : this.addXY[0][this.index] * (this.isMirror ? -1 : 1);
                this.y += this.addXY == null ? 0 : this.addXY[1][this.index];
                this.sx = this.x;
                this.sy = this.y;
                this.setMotionVaules((byte)2, this.isMirror);
                this.frameTimes = (byte)(this.frameTimes - 1);
                if (this.frameTimes > 0) break;
                ++this.index;
                break;
            }
            case 4: {
                if (this.index == (GameData.fighterMotionData[this.model] == null ? 0 : GameData.fighterMotionData[this.model][4].length)) {
                    this.index = 0;
                    this.frameTimes = 0;
                    if (this.model > 2) {
                        this.index = -1;
                    }
                    this.setStatus((byte)4);
                    this.godReborn();
                }
                this.setMotionVaules((byte)4, this.isMirror);
                this.spurtX = (short)10;
                this.spurtY = 0;
                this.addXY = new short[][]{{10, 10, 7, 5, 3, this.spurtX, this.spurtX, this.spurtX, this.spurtX, this.spurtX, this.spurtX, this.spurtX, this.spurtX, this.spurtX, this.spurtX, this.spurtX, this.spurtX, 0}, {0, 0, 0, 0, 0, this.spurtY, this.spurtY, this.spurtY, this.spurtY, this.spurtY, this.spurtY, this.spurtY, this.spurtY, this.spurtY, this.spurtY, this.spurtY, this.spurtY, 0}};
                if (this.model > 2) {
                    this.x += this.addXY == null ? 0 : this.addXY[0][0] * (this.isMirror ? -1 : 1);
                    this.y += this.addXY == null ? 0 : this.addXY[1][0];
                }
                this.sx = this.x;
                this.sy = this.y;
                ++this.index;
            }
        }
    }

    public void godReborn() {
        if (this.team == 1 && God.canReborn && this.hp <= 0 && this.mp >= this.mp_max / 2) {
            this.nextStatus = 0;
            this.x = this.bx;
            this.y = this.by;
            this.hp = Math.min(this.hp_max, this.mp);
            this.mp = 0;
            Effect.AddEffectList(this.x, this.y, 36, 0, 40);
        }
    }

    public void reBorn(boolean superRestore) {
        if (superRestore) {
            this.hp = this.hp_max;
            this.mp = this.mp_max;
        }
        this.curStatus = 0;
        this.nextStatus = 0;
        this.index = 0;
        this.frameTimes = 0;
        this.x = this.bx;
        this.y = this.by;
        this.initBuff();
    }

    public void setStatus(byte status) {
        if (this.curStatus != 4) {
            this.nextStatus = status;
        }
        this.index = 0;
        this.frameTimes = 0;
    }

    void drawCurIndexEffect(int zhen, int x, int y, int eftType, int isMir, int drawLevel) {
        if (this.index == zhen) {
            Effect.AddEffectList(GameMap.setOffX + x, GameMap.setOffY + y, eftType, isMir, drawLevel);
        }
    }

    void setSpurtXY(int x, int y) {
        this.spurtX = (short)x;
        this.spurtY = (short)y;
    }

    public static int getStandardExpMax(int type, int level) {
        int a = (3 * (level + 1) + 4 * (level - 1) * level) * (100 + (level - 1) * 1) / 100;
        if (level >= 40) {
            a *= 3;
        }
        if (level >= 30) {
            a *= 2;
        } else if (level >= 20) {
            a = a * 3 / 2;
        }
        return a;
    }

    public static int getStandardAtt(int type, int lev) {
        switch (type) {
            case 0: {
                return 16 + 9 * lev;
            }
            case 1: {
                return 10 + 8 * lev;
            }
            case 2: {
                return 12 + 10 * lev;
            }
        }
        return 0;
    }

    public static int getStandardDef(int type, int lev) {
        switch (type) {
            case 0: {
                return 1 + 2 * lev;
            }
            case 1: {
                return 2 + 1 * lev;
            }
            case 2: {
                return 1 + 1 * lev;
            }
        }
        return 0;
    }

    public static int getStandardHP(int type, int lev) {
        switch (type) {
            case 0: {
                return 230 + 55 * lev;
            }
            case 1: {
                return 200 + 50 * lev;
            }
            case 2: {
                return 180 + 45 * lev;
            }
        }
        return 0;
    }

    public static int getStandardMP(int type, int lev) {
        switch (type) {
            case 0: {
                return 90 + 20 * lev;
            }
            case 1: {
                return 100 + 30 * lev;
            }
            case 2: {
                return 150 + 25 * lev;
            }
        }
        return 0;
    }

    private void getHP_MAX() {
        this.hp_max = Fighter.getStandardHP(this.type, this.level);
        if (this.equips[1][0] != -1) {
            this.hp_max += this.equips[1][3];
        }
    }

    private void getMP_MAX() {
        this.mp_max = Fighter.getStandardMP(this.type, this.level);
        if (this.equips[1][0] != -1) {
            this.mp_max += this.equips[1][4];
        }
    }

    private void getDeflect_MAX() {
        this.deflect = 0;
        if (this.equips[1][0] != -1) {
            this.deflect = (byte)(this.deflect + this.equips[1][5]);
        }
    }

    private void getATT_MAX() {
        this.attack = (short)Fighter.getStandardAtt(this.type, this.level);
        if (this.equips[0][0] != -1) {
            this.attack = (short)(this.attack + this.equips[0][1]);
        }
        if (this.equips[2][0] != -1) {
            this.attack = (short)(this.attack + this.equips[2][1]);
        }
        if (this.equips[3][0] != -1) {
            this.attack = (short)(this.attack + this.equips[3][1]);
        }
    }

    private void getCRIT_MAX() {
        this.crit = (byte)5;
        if (this.equips[0][0] != -1) {
            this.crit = (byte)(this.crit + this.equips[0][2]);
        }
        if (this.equips[2][0] != -1) {
            this.crit = (byte)(this.crit + this.equips[2][3]);
        }
        if (this.equips[3][0] != -1) {
            this.crit = (byte)(this.crit + this.equips[3][3]);
        }
    }

    private void getDEF_MAX() {
        this.defend = (short)Fighter.getStandardDef(this.type, this.level);
        if (this.equips[1][0] != -1) {
            this.defend = (short)(this.defend + this.equips[1][1]);
        }
        if (this.equips[2][0] != -1) {
            this.defend = (short)(this.defend + this.equips[2][2]);
        }
        if (this.equips[3][0] != -1) {
            this.defend = (short)(this.defend + this.equips[3][2]);
        }
        this.setPimm();
    }

    private void getMISS_MAX() {
        this.miss = (byte)5;
        if (this.equips[1][0] != -1) {
            this.miss = (byte)(this.miss + this.equips[1][2]);
        }
        if (this.equips[2][0] != -1) {
            this.miss = (byte)(this.miss + this.equips[2][4]);
        }
        if (this.equips[3][0] != -1) {
            this.miss = (byte)(this.miss + this.equips[3][4]);
        }
    }

    private void getDoubleHit_MAX() {
        this.doubleHit = 0;
        if (this.equips[0][0] != -1) {
            this.doubleHit = (byte)(this.doubleHit + this.equips[0][3]);
        }
    }

    private void getFightBack_MAX() {
        this.fightBack = 0;
        if (this.equips[0][0] != -1) {
            this.fightBack = (byte)(this.fightBack + this.equips[0][4]);
        }
    }

    private void getSuck_MAX() {
        this.suck = 0;
        if (this.equips[0][0] != -1) {
            this.suck = (byte)(this.suck + this.equips[0][5]);
        }
    }

    private void getResist_MAX() {
        this.resist = 0;
        if (this.equips[2][0] != -1) {
            this.resist = (byte)(this.resist + this.equips[2][5]);
        }
        if (this.equips[3][0] != -1) {
            this.resist = (byte)(this.resist + this.equips[3][5]);
        }
    }

    int getCurAtt() {
        if (this.buff[5][0] > 0) {
            return this.attack * (100 + this.buff[5][1]) / 100;
        }
        return this.attack;
    }

    int getCurPimm() {
        if (this.buff[6][0] > 0) {
            return this.pimm * (100 + this.buff[6][1]) / 100;
        }
        return this.pimm;
    }

    public void injure(int value, boolean isCrit, boolean canMiss, boolean canDef, boolean isLast) {
        this.hurtValue = 0;
        if (canMiss && Tools.percent(this.miss) && this.hp > 0 && this.canAction()) {
            this.setStatus((byte)7);
            Battle.canDoubleHit = false;
            Battle.addHitNum(0, 5, this.x, this.y, 0);
        } else {
            if (isCrit) {
                value *= 2;
            }
            value = Math.max(1, value);
            this.hp = Math.max(0, this.hp - value);
            Battle.addHitNum(value, isCrit ? 3 : 0, this.x, this.y, 0);
            Effect.AddEffectList(this.x, this.y - 20, 7, this.team == 0 ? 1 : 0, this.y + 100);
            this.hurtValue = value;
            if (this.hp <= 0 && isLast && this.curStatus != 4) {
                this.setSpurtXY(GameEngine.nextInt(10, 12), GameEngine.nextInt(20) * (GameEngine.nextInt(1) == 0 ? -1 : 1));
                this.setStatus((byte)4);
            } else {
                this.setStatus((byte)2);
            }
            this.buff[1][0] = 0;
        }
    }

    public void deflect(int value) {
        this.hp = Math.max(0, this.hp - value);
        Battle.addHitNum(value, 4, this.x, this.y, this.team == 0 ? -1 : 1);
        if (this.hp <= 0 && this.curStatus != 4) {
            this.setSpurtXY(GameEngine.nextInt(10, 12), GameEngine.nextInt(20) * (GameEngine.nextInt(1) == 0 ? -1 : 1));
            this.setStatus((byte)4);
        } else {
            this.setStatus((byte)2);
        }
    }

    public void restore(int R_HP1, int R_HP2, int R_MP1, int R_MP2, boolean isFlash) {
        int value = 0;
        int off = 0;
        if (R_MP1 > 0 || R_MP2 > 0) {
            int tempMPMAX = this.mp_max;
            value = R_MP1 + R_MP2 * tempMPMAX / 100;
            this.mp = Math.min(tempMPMAX, this.mp + value);
            Battle.addHitNum(value, 2, this.x, this.y, 0);
            off = 20;
        }
        if (R_HP1 > 0 || R_HP2 > 0) {
            int tempHPMAX = this.hp_max;
            value = (R_HP1 + R_HP2 * tempHPMAX / 100) * (isFlash ? 2 : 1);
            this.hp = Math.min(tempHPMAX, this.hp + value);
            Battle.addHitNum(value, 1, this.x, this.y - off, 0);
        }
    }

    public void resetHPMP() {
        if (this.hp > this.hp_max) {
            this.hp = this.hp_max;
        }
        if (this.mp > this.mp_max) {
            this.mp = this.mp_max;
        }
    }

    void equip(short[] equipment, int pos) {
        if (this.equips[pos][0] != -1) {
            GameEngine.getEquip(this.equips[pos]);
        }
        this.equips[pos] = equipment;
        GameEngine.dropEqip(equipment);
        this.upDateProp();
    }

    void remove(int pos) {
        if (this.equips[pos][0] != -1) {
            GameEngine.getEquip(this.equips[pos]);
            this.equips[pos] = null;
            this.equips[pos] = new short[]{-1, 0, 0, 0, 0, 0, 0};
            this.upDateProp();
        }
    }

    void useItem(int itemID) {
        Item item = GameEngine.item[itemID];
        switch (itemID) {
            case 11: {
                this.talentPoint = (short)(this.talentPoint + 1);
                return;
            }
        }
        this.hp += item.hp1 + item.hp2 * this.hp_max / 100;
        this.mp += item.mp1 + item.mp2 * this.mp_max / 100;
        this.resetHPMP();
    }

    boolean canUse(int itemID) {
        Item item = GameEngine.item[itemID];
        if (item.removeBuff > 0) {
            return true;
        }
        if (this.hp <= 0) {
            return false;
        }
        if (!(item.hp1 <= 0 && item.hp2 <= 0 || item.mp1 <= 0 && item.mp2 <= 0)) {
            return this.hp != this.hp_max || this.mp != this.mp_max;
        }
        if (item.hp1 > 0 || item.hp2 > 0) {
            return this.hp != this.hp_max;
        }
        if (item.mp1 > 0 || item.mp2 > 0) {
            return this.mp != this.mp_max;
        }
        return true;
    }

    public void useSkill(Fighter role, int skillID) {
        Skill skill = GameEngine.skill[skillID];
        MyGameCanvas.setInfo("\u4f7f\u7528\u4e86#B" + skill.name);
        byte value = role.skills[role.getSkillPos(skillID)][3];
        switch (skill.formula) {
            case 4: {
                this.hp += role.attack * skill.perHurt[0] / 100 * (100 + value) / 100;
                break;
            }
            case 6: {
                this.hp += this.hp_max * (skill.perHurt[0] + value) / 100;
            }
        }
        this.hp = Math.min(this.hp_max, this.hp);
    }

    boolean canUseSkill(int skillID) {
        if (GameEngine.skill[skillID].formula == 0) {
            return true;
        }
        return this.hp < this.hp_max;
    }

    public void setMotionVaules(byte states, boolean mir) {
        this.curIndex = this.getMotinVaule(states, (byte)0);
        this.trans = (byte)(mir ? this.getMotinVaule(states, (byte)1) ^ 1 : this.getMotinVaule(states, (byte)1));
        this.adjustX = (byte)(this.getMotinVaule(states, mir ? (byte)4 : 3) * -1);
        this.adjustY = (byte)(this.getMotinVaule(states, (byte)5) * -1);
        if (this.frameTimes <= 0) {
            this.frameTimes = this.getMotinVaule(states, (byte)2);
        }
    }

    public byte getMotinVaule(byte st, byte quality) {
        if (this.model == -1) {
            return 0;
        }
        if (GameData.fighterMotionData[this.model] == null) {
            return 0;
        }
        if (GameData.fighterMotionData[this.model][st] == null) {
            return GameData.fighterMotionData[this.model][0][0][quality];
        }
        if (this.model == 0) {
            // empty if block
        }
        return GameData.fighterMotionData[this.model][st][this.index][quality];
    }

    int getSkillPos(int skill) {
        if (this.skills == null) {
            return -1;
        }
        int i = 0;
        while (i < this.skills.length) {
            if (this.skills[i][0] == skill) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void setPimm() {
        this.pimm = (short)(300 * this.defend / (4 * (this.defend + 300)));
    }

    void upDateProp() {
        this.skillCrit = 0;
        this.getATT_MAX();
        this.getDEF_MAX();
        this.getHP_MAX();
        this.getMP_MAX();
        this.getMISS_MAX();
        this.getCRIT_MAX();
        this.getResist_MAX();
        this.getDoubleHit_MAX();
        this.getSuck_MAX();
        this.getFightBack_MAX();
        this.getDeflect_MAX();
        int i = 0;
        while (i < this.talentTree.length) {
            if (this.talentTree[i][1] > 0) {
                Talent talent = GameEngine.talent[this.talentTree[i][0]];
                int value = talent.value * this.talentTree[i][1];
                switch (talent.type) {
                    case 17: {
                        this.fightBack = (byte)(this.fightBack + value);
                        break;
                    }
                    case 12: {
                        this.miss = (byte)(this.miss + value);
                        break;
                    }
                    case 7: {
                        this.attack = (short)(this.attack * (100 + value) / 100);
                        break;
                    }
                    case 10: {
                        this.mp_max = this.mp_max * (100 + value) / 100;
                        break;
                    }
                    case 9: {
                        this.hp_max = this.hp_max * (100 + value) / 100;
                        break;
                    }
                    case 16: {
                        this.doubleHit = (byte)(this.doubleHit + value);
                        break;
                    }
                    case 11: {
                        this.crit = (byte)(this.crit + value);
                        break;
                    }
                    case 8: {
                        this.defend = (short)(this.defend * (100 + value) / 100);
                        this.setPimm();
                        break;
                    }
                    case 13: {
                        this.skillCrit = (byte)(this.skillCrit + value);
                    }
                }
            }
            ++i;
        }
        this.resetHPMP();
    }

    public void move(int objX, int objY) {
        this.x = objX;
        this.y = objY;
    }

    public void setInitPos() {
        this.y = this.by;
        this.x = this.bx;
        this.isBack = true;
    }
}

