/*
 * Decompiled with CFR 0.152.
 */
package src;

import java.io.DataInputStream;
import java.io.InputStream;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class SpriteG {
    public static final int TRANS_NONE = 0;
    public static final int TRANS_ROT90 = 5;
    public static final int TRANS_ROT180 = 3;
    public static final int TRANS_ROT270 = 6;
    public static final int TRANS_MIRROR = 2;
    public static final int TRANS_MIRROR_ROT90 = 7;
    public static final int TRANS_MIRROR_ROT180 = 1;
    public static final int TRANS_MIRROR_ROT270 = 4;
    public static final int ANTICLOCKWISE_90 = 0;
    public static final int DEASIL_90 = 1;
    public static final int HORIZONTAL = 2;
    public static final int VERTICAL = 3;
    public static final int DIRECTION_NONE = 0;
    public static final int DIRECTION_UP = 1;
    public static final int DIRECTION_DOWN = 2;
    public static final int DIRECTION_LEFT = 3;
    public static final int DIRECTION_RIGHT = 4;
    public static final int FRAME_HEADER_SIZE = 6;
    public static final int FRAME_TILE_COUNT_BIT = 1;
    public static final int FRAME_TOP_POS_BIT = 2;
    public static final int FRAME_BOTTOM_POS_BIT = 3;
    public static final int FRAME_LEFT_POS_BIT = 4;
    public static final int FRAME_RIGHT_POS_BIT = 5;
    public static final int ACTION_HEADER_SIZE = 3;
    public static final int ACTION_SEQUENCE_LENGTH_BIT = 1;
    public static final int ACTION_TRANSFORM_BIT = 2;
    private static final int INVERTED_AXES = 4;
    public static final int[][] TRANSFORM_TABLE;
    public static final int[][] ROTATE_TABLE;
    private short[][] frameData;
    private int frameCount;
    private short[][] tileData;
    private int tileCount;
    private Image image;
    private boolean visible;
    private int type;
    private int dir;
    private int dirX;
    private int offy = 0;

    static {
        int[][] nArrayArray = new int[8][];
        int[] nArray = new int[8];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        nArray[4] = 4;
        nArray[5] = 5;
        nArray[6] = 6;
        nArray[7] = 7;
        nArrayArray[0] = nArray;
        int[] nArray2 = new int[8];
        nArray2[0] = 1;
        nArray2[2] = 3;
        nArray2[3] = 2;
        nArray2[4] = 5;
        nArray2[5] = 4;
        nArray2[6] = 7;
        nArray2[7] = 6;
        nArrayArray[1] = nArray2;
        int[] nArray3 = new int[8];
        nArray3[0] = 2;
        nArray3[1] = 3;
        nArray3[3] = 1;
        nArray3[4] = 6;
        nArray3[5] = 7;
        nArray3[6] = 4;
        nArray3[7] = 5;
        nArrayArray[2] = nArray3;
        int[] nArray4 = new int[8];
        nArray4[0] = 3;
        nArray4[1] = 2;
        nArray4[2] = 1;
        nArray4[4] = 7;
        nArray4[5] = 6;
        nArray4[6] = 5;
        nArray4[7] = 4;
        nArrayArray[3] = nArray4;
        int[] nArray5 = new int[8];
        nArray5[0] = 4;
        nArray5[1] = 6;
        nArray5[2] = 5;
        nArray5[3] = 7;
        nArray5[5] = 2;
        nArray5[6] = 1;
        nArray5[7] = 3;
        nArrayArray[4] = nArray5;
        int[] nArray6 = new int[8];
        nArray6[0] = 5;
        nArray6[1] = 7;
        nArray6[2] = 4;
        nArray6[3] = 6;
        nArray6[4] = 1;
        nArray6[5] = 3;
        nArray6[7] = 2;
        nArrayArray[5] = nArray6;
        int[] nArray7 = new int[8];
        nArray7[0] = 6;
        nArray7[1] = 4;
        nArray7[2] = 7;
        nArray7[3] = 5;
        nArray7[4] = 2;
        nArray7[6] = 3;
        nArray7[7] = 1;
        nArrayArray[6] = nArray7;
        int[] nArray8 = new int[8];
        nArray8[0] = 7;
        nArray8[1] = 5;
        nArray8[2] = 6;
        nArray8[3] = 4;
        nArray8[4] = 3;
        nArray8[5] = 1;
        nArray8[6] = 2;
        nArrayArray[7] = nArray8;
        TRANSFORM_TABLE = nArrayArray;
        int[][] nArrayArray2 = new int[8][];
        nArrayArray2[0] = new int[]{6, 5, 2, 1};
        int[] nArray9 = new int[4];
        nArray9[0] = 7;
        nArray9[1] = 4;
        nArray9[2] = 3;
        nArrayArray2[1] = nArray9;
        int[] nArray10 = new int[4];
        nArray10[0] = 4;
        nArray10[1] = 7;
        nArray10[3] = 3;
        nArrayArray2[2] = nArray10;
        nArrayArray2[3] = new int[]{5, 6, 1, 2};
        nArrayArray2[4] = new int[]{1, 2, 5, 6};
        int[] nArray11 = new int[4];
        nArray11[1] = 3;
        nArray11[2] = 4;
        nArray11[3] = 7;
        nArrayArray2[5] = nArray11;
        int[] nArray12 = new int[4];
        nArray12[0] = 3;
        nArray12[2] = 7;
        nArray12[3] = 4;
        nArrayArray2[6] = nArray12;
        nArrayArray2[7] = new int[]{2, 1, 6, 5};
        ROTATE_TABLE = nArrayArray2;
    }

    public SpriteG(String spxName) {
        this.ReadSpx(spxName);
    }

    public SpriteG(String spxName, Image image) {
        this.loadSpx(spxName, image);
    }

    public SpriteG(String spxName, String imageName) {
        Image spximg = null;
        try {
            spximg = Image.createImage((String)imageName);
        }
        catch (Exception ex) {
            System.out.println("can't load spx image\n");
        }
        this.loadSpx(spxName, spximg);
    }

    public void loadSpx(String spxName, Image image) {
        this.ReadSpx(spxName);
        this.setImage(image);
        this.visible = true;
    }

    public void ReadSpx(String spxName) {
        try {
            InputStream is = this.getClass().getResourceAsStream(spxName);
            DataInputStream data = new DataInputStream(is);
            this.tileCount = data.readShort();
            this.tileData = new short[this.tileCount][4];
            int i = 0;
            while (i < this.tileCount) {
                this.tileData[i][0] = data.readShort();
                this.tileData[i][1] = data.readShort();
                this.tileData[i][2] = data.readShort();
                this.tileData[i][3] = data.readShort();
                i = (short)(i + 1);
            }
            this.frameCount = data.readShort();
            this.frameData = new short[this.frameCount][];
            i = 0;
            while (i < this.frameCount) {
                short frameTileCount = data.readShort();
                short length = (short)(6 + frameTileCount * 4);
                this.frameData[i] = new short[length];
                this.frameData[i][0] = data.readShort();
                this.frameData[i][1] = data.readShort();
                this.frameData[i][2] = data.readShort();
                this.frameData[i][3] = data.readShort();
                this.frameData[i][4] = data.readShort();
                this.frameData[i][5] = data.readShort();
                int offset = 6;
                short j = 0;
                while (j < frameTileCount) {
                    this.frameData[i][0 + offset] = data.readShort();
                    this.frameData[i][1 + offset] = data.readShort();
                    this.frameData[i][2 + offset] = data.readShort();
                    this.frameData[i][3 + offset] = data.readShort();
                    offset = (short)(offset + 4);
                    j = (short)(j + 1);
                }
                i = (short)(i + 1);
            }
            is.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public int getFrameTopPos(int index, int y) {
        return this.frameData[index][2] + y;
    }

    public int getFrameBottomPos(int index, int y) {
        return this.frameData[index][3] + y;
    }

    public int getFrameLeftPos(int index, int x) {
        return this.frameData[index][4] + x;
    }

    public int getFrameLeftPosX(int index) {
        return this.frameData[index][4];
    }

    public int getFrameTopPosX(int index) {
        return this.frameData[index][2];
    }

    public int getFrameRightPosX(int index) {
        return this.frameData[index][5];
    }

    public int getFrameBottomPosX(int index) {
        return this.frameData[index][3];
    }

    public int getFrameRightPos(int index, int x) {
        if (this.frameData == null) {
            System.out.println("frameData:\t" + this.frameData);
            return 10;
        }
        if (this.frameData[index] == null) {
            System.out.println("frameData[" + index + "]:\t" + this.frameData[index]);
            return 10;
        }
        return this.frameData[index][5] + x;
    }

    public int getFrameWidth(int index, int x) {
        return this.getFrameRightPos(index, x) - this.getFrameLeftPos(index, x);
    }

    public int getFrameHeight(int index, int y) {
        return this.getFrameBottomPos(index, y) - this.getFrameTopPos(index, y);
    }

    public void setImage(Image image) {
        if (image == null) {
            throw new NullPointerException();
        }
        this.image = image;
    }

    public Image getImage() {
        return this.image;
    }

    public void freeImg() {
        this.image = null;
        System.gc();
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void paint(Graphics g, int x, int y, int frameIndex, int actionTransform) {
        block21: {
            if (g == null) {
                System.out.println("NullPointerException()");
                return;
            }
            if (!this.visible) break block21;
            if (actionTransform == 0) {
                int tileCount = this.frameData[frameIndex][1];
                int offset = 6;
                int i = 0;
                while (i < tileCount) {
                    short tileIndex = this.frameData[frameIndex][0 + offset];
                    int dx = this.frameData[frameIndex][1 + offset] + x;
                    int dy = this.frameData[frameIndex][2 + offset] + y + this.offy;
                    short transform = this.frameData[frameIndex][3 + offset];
                    short tx = this.tileData[tileIndex][0];
                    short ty = this.tileData[tileIndex][1];
                    short tw = this.tileData[tileIndex][2];
                    short th = this.tileData[tileIndex][3];
                    SpriteG.drawRegion(g, this.image, tx, ty, tw, th, transform, dx, dy, 20);
                    offset += 4;
                    ++i;
                }
            } else {
                int tileCount = this.frameData[frameIndex][1];
                int offset = 6;
                int i = 0;
                while (i < tileCount) {
                    int th;
                    int tw;
                    short tileIndex = this.frameData[frameIndex][0 + offset];
                    int dx = this.frameData[frameIndex][1 + offset] + x;
                    int dy = this.frameData[frameIndex][2 + offset] + y;
                    int transform = this.frameData[frameIndex][3 + offset];
                    short tx = this.tileData[tileIndex][0];
                    short ty = this.tileData[tileIndex][1];
                    switch (transform) {
                        case 4: 
                        case 5: 
                        case 6: 
                        case 7: {
                            tw = this.tileData[tileIndex][3];
                            th = this.tileData[tileIndex][2];
                            break;
                        }
                        default: {
                            tw = this.tileData[tileIndex][2];
                            th = this.tileData[tileIndex][3];
                        }
                    }
                    int cx = x - dx;
                    int cy = y - dy;
                    transform = TRANSFORM_TABLE[transform][actionTransform];
                    switch (actionTransform) {
                        case 0: {
                            break;
                        }
                        case 5: {
                            dx = x - (th - cy);
                            dy = y - cx;
                            break;
                        }
                        case 3: {
                            dx = x - (tw - cx);
                            dy = y - (th - cy);
                            break;
                        }
                        case 6: {
                            dx = x - cy;
                            dy = y - (tw - cx);
                            break;
                        }
                        case 2: {
                            dx = x - (tw - cx);
                            break;
                        }
                        case 7: {
                            dx = x - (th - cy);
                            dy = y - (tw - cx);
                            break;
                        }
                        case 1: {
                            dy = y - (th - cy);
                            break;
                        }
                        case 4: {
                            dx = x - cy;
                            dy = y - cx;
                        }
                    }
                    switch (transform) {
                        case 4: 
                        case 5: 
                        case 6: 
                        case 7: {
                            tw ^= th;
                            th ^= tw;
                            tw ^= th;
                        }
                    }
                    SpriteG.drawRegion(g, this.image, tx, ty, tw, th, transform, dx, dy += this.offy, 20);
                    offset += 4;
                    ++i;
                }
            }
        }
    }

    public static void drawRegionMIDP1(Graphics g, Image src, int x_src, int y_src, int width, int height, int transform, int x_dest, int y_dest, int anchor) {
        if (g == null) {
            throw new NullPointerException();
        }
        if (src == null) {
            throw new NullPointerException();
        }
        switch (anchor) {
            case 0: 
            case 3: 
            case 6: 
            case 10: 
            case 17: 
            case 20: 
            case 24: 
            case 33: 
            case 36: 
            case 40: {
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        if (transform < 0 || transform > 7) {
            throw new IllegalArgumentException();
        }
        if (width < 0 || height < 0 || x_src < 0 || y_src < 0 || x_src + width > src.getWidth() || y_src + height > src.getHeight()) {
            throw new IllegalArgumentException();
        }
        int clipX = g.getClipX();
        int clipY = g.getClipY();
        int clipWidth = g.getClipWidth();
        int clipHeight = g.getClipHeight();
        if ((4 & transform) == 0) {
            if (anchor != 0) {
                if ((anchor & 0x20) != 0) {
                    y_dest -= height;
                }
                if ((anchor & 8) != 0) {
                    x_dest -= width;
                }
                if ((anchor & 1) != 0) {
                    x_dest -= width / 2;
                }
                if ((anchor & 2) != 0) {
                    y_dest -= height / 2;
                }
            }
            g.clipRect(x_dest, y_dest, width, height);
        } else {
            if (anchor != 0) {
                if ((anchor & 0x20) != 0) {
                    y_dest -= width;
                }
                if ((anchor & 8) != 0) {
                    x_dest -= height;
                }
                if ((anchor & 1) != 0) {
                    x_dest -= height / 2;
                }
                if ((anchor & 2) != 0) {
                    y_dest -= width / 2;
                }
            }
            g.clipRect(x_dest, y_dest, height, width);
        }
        int x_offset = 0;
        int y_offset = 0;
        int srcWidth = src.getWidth();
        int srcHeight = src.getHeight();
        switch (transform) {
            case 0: {
                g.drawImage(src, x_dest - x_src, y_dest - y_src, 20);
                g.setClip(clipX, clipY, clipWidth, clipHeight);
                return;
            }
            case 5: {
                x_offset = srcHeight - (y_src + height);
                y_offset = x_src;
                break;
            }
            case 3: {
                x_offset = srcWidth - (x_src + width);
                y_offset = srcHeight - (y_src + height);
                break;
            }
            case 6: {
                x_offset = y_src;
                y_offset = srcWidth - (x_src + width);
                break;
            }
            case 2: {
                x_offset = srcWidth - (x_src + width);
                y_offset = y_src;
                break;
            }
            case 7: {
                x_offset = srcHeight - (y_src + height);
                y_offset = srcWidth - (x_src + width);
                break;
            }
            case 1: {
                x_offset = x_src;
                y_offset = srcHeight - (y_src + height);
                break;
            }
            case 4: {
                x_offset = y_src;
                y_offset = x_src;
            }
        }
        x_dest -= x_offset;
        y_dest -= y_offset;
        int clipX1 = g.getClipX();
        int clipY1 = g.getClipY();
        int clipX2 = g.getClipX() + g.getClipWidth();
        int clipY2 = g.getClipY() + g.getClipHeight();
        if ((4 & transform) != 0) {
            int temp = srcWidth;
            srcWidth = srcHeight;
            srcHeight = temp;
        }
        int src_start_x = Math.max(0, clipX1 - x_dest);
        int src_start_y = Math.max(0, clipY1 - y_dest);
        int dest_start_x = Math.max(clipX1, x_dest);
        int dest_start_y = Math.max(clipY1, y_dest);
        int dest_right = x_dest + srcWidth;
        int dest_bottom = y_dest + srcHeight;
        int copy_width = srcWidth - src_start_x;
        int copy_height = srcHeight - src_start_y;
        copy_width -= Math.max(0, dest_right - clipX2);
        copy_height -= Math.max(0, dest_bottom - clipY2);
        int px = 0;
        int py = 0;
        int i = 0;
        while (i < copy_height) {
            int j = 0;
            while (j < copy_width) {
                switch (transform) {
                    case 5: {
                        px = src_start_y + i;
                        py = srcWidth - 1 - j - src_start_x;
                        break;
                    }
                    case 3: {
                        px = srcWidth - 1 - j - src_start_x;
                        py = srcHeight - 1 - i - src_start_y;
                        break;
                    }
                    case 6: {
                        px = srcHeight - 1 - i - src_start_y;
                        py = src_start_x + j;
                        break;
                    }
                    case 2: {
                        px = srcWidth - 1 - j - src_start_x;
                        py = src_start_y + i;
                        break;
                    }
                    case 7: {
                        px = srcHeight - 1 - i - src_start_y;
                        py = srcWidth - 1 - j - src_start_x;
                        break;
                    }
                    case 1: {
                        px = src_start_x + j;
                        py = srcHeight - 1 - i - src_start_y;
                        break;
                    }
                    case 4: {
                        px = src_start_y + i;
                        py = src_start_x + j;
                    }
                }
                g.setClip(dest_start_x + j, dest_start_y + i, 1, 1);
                g.drawImage(src, dest_start_x + j - px, dest_start_y + i - py, 20);
                ++j;
            }
            ++i;
        }
        g.setClip(clipX, clipY, clipWidth, clipHeight);
    }

    public void paintX(Graphics g, Image imgB, int x, int y, int frameIndex, int actionTransform) {
        int bx = 0;
        int by = 0;
        int bxx = 0;
        int bxy = 0;
        int bw = this.getFrameWidth(frameIndex, x);
        int bh = this.getFrameHeight(frameIndex, y);
        switch (actionTransform) {
            case 2: {
                bx = x - this.getFrameRightPosX(frameIndex);
                by = this.getFrameTopPos(frameIndex, y);
                bxx = this.getFrameRightPosX(frameIndex);
                bxy = -this.getFrameTopPosX(frameIndex);
                break;
            }
            default: {
                bx = this.getFrameLeftPos(frameIndex, x);
                by = this.getFrameTopPos(frameIndex, y);
                bxx = -this.getFrameLeftPosX(frameIndex);
                bxy = -this.getFrameTopPosX(frameIndex);
            }
        }
        Image imageT = Image.createRGBImage((int[])new int[bw * bh], (int)bw, (int)bh, (boolean)true);
        Graphics gt = imageT.getGraphics();
        this.paint(gt, bxx, bxy, frameIndex, actionTransform);
        Image imageT1 = this.XXJDImage_1(imgB, imageT, bx, by);
        if (imageT1 != null) {
            if (bx < 0) {
                bx = 0;
            }
            if (by < 0) {
                by = 0;
            }
            g.drawImage(imageT1, bx, by, 0);
        }
    }

    private Image XXJDImage_1(Image imgB, Image imgF, int XinB, int YinB) {
        if (imgB == null) {
            System.out.println("origin Image: img == null");
            return null;
        }
        int xf = XinB;
        int yf = YinB;
        int wf = imgF.getWidth();
        int hf = imgF.getHeight();
        int imgWB = imgB.getWidth();
        int imgHB = imgB.getHeight();
        int xb = xf;
        int yb = yf;
        if (xf < 0) {
            if (xf + wf < 0) {
                return null;
            }
            wf += xf;
            xb = 0;
            xf = -xf;
        } else {
            if (xf >= imgWB) {
                return null;
            }
            if (xf + wf > imgWB) {
                wf = imgWB - xf;
                xf = 0;
            } else {
                xf = 0;
            }
        }
        if (yf < 0) {
            if (yf + hf < 0) {
                return null;
            }
            hf += yf;
            yb = 0;
            yf = -yf;
        } else {
            if (yf >= imgHB) {
                return null;
            }
            if (yf + hf > imgHB) {
                hf = imgHB - yf;
                yf = 0;
            } else {
                yf = 0;
            }
        }
        int wb = wf;
        int hb = hf;
        if (wf <= 0 || hf <= 0) {
            return null;
        }
        Image imgFn = Image.createImage((Image)imgF, (int)xf, (int)yf, (int)wf, (int)hf, (int)0);
        Image imgBn = Image.createImage((Image)imgB, (int)xb, (int)yb, (int)wb, (int)hb, (int)0);
        int[] imgBRGBData = new int[wb * hb];
        imgBn.getRGB(imgBRGBData, 0, wb, 0, 0, wb, hb);
        int[] imgFRGBData = new int[wf * hf];
        imgFn.getRGB(imgFRGBData, 0, wf, 0, 0, wf, hf);
        int RB = 0;
        int GB = 0;
        int BB = 0;
        int RF = 0;
        int GF = 0;
        int BF = 0;
        int RT = 0;
        int GT = 0;
        int BT = 0;
        int IndexT = 0;
        int i = 0;
        while (i < wf) {
            int j = 0;
            while (j < hf) {
                IndexT = i + j * wf;
                if ((imgFRGBData[IndexT] >> 24 & 0xFF) != 0) {
                    RB = imgBRGBData[IndexT] >> 16 & 0xFF;
                    GB = imgBRGBData[IndexT] >> 8 & 0xFF;
                    BB = imgBRGBData[IndexT] & 0xFF;
                    RF = imgFRGBData[IndexT] >> 16 & 0xFF;
                    GF = imgFRGBData[IndexT] >> 8 & 0xFF;
                    BF = imgFRGBData[IndexT] & 0xFF;
                    RT = RB + RF > 255 ? 255 : RB + RF;
                    GT = GB + GF > 255 ? 255 : GB + GF;
                    BT = BB + BF > 255 ? 255 : BB + BF;
                    imgBRGBData[IndexT] = RT << 16 | GT << 8 | BT + -16777216;
                }
                ++j;
            }
            ++i;
        }
        return Image.createRGBImage((int[])imgBRGBData, (int)wf, (int)hf, (boolean)true);
    }

    public static void drawRegion(Graphics g, Image src, int x_src, int y_src, int width, int height, int transform, int x_dest, int y_dest, int anchor) {
        g.drawRegion(src, x_src, y_src, width, height, transform, x_dest, y_dest, anchor);
    }

    public int getDir() {
        return this.dir;
    }

    public void setDir(int dir) {
        this.dir = dir;
    }

    public int getDirX() {
        return this.dirX;
    }

    public void setDirX(int dirX) {
        this.dirX = dirX;
    }

    public int getFrameCount() {
        return this.frameCount;
    }

    public void setFrameCount(int frameCount) {
        this.frameCount = frameCount;
    }

    public short[][] getFrameData() {
        return this.frameData;
    }

    public void setFrameData(short[][] frameData) {
        this.frameData = frameData;
    }

    public int getOffy() {
        return this.offy;
    }

    public void setOffy(int offy) {
        this.offy = offy;
    }

    public int getTileCount() {
        return this.tileCount;
    }

    public void setTileCount(int tileCount) {
        this.tileCount = tileCount;
    }

    public short[][] getTileData() {
        return this.tileData;
    }

    public void setTileData(short[][] tileData) {
        this.tileData = tileData;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }
}

