/*
 * Decompiled with CFR 0.152.
 */
import java.util.Random;

public class Slugs {
    private Ship oShip;
    private int shipposx;
    private int shipposy;
    private int[][] pos;
    private int[][] vec;
    private int deltax;
    private int deltay;
    private int tcount;
    private int screenw;
    private int screenh;
    private Random random;
    private int slugsnum;
    private final int maxslugs;
    private final int initslugs;
    private final int width;
    private final int height;
    private final int shootpar1;
    private final int shootpar2;
    private final int incrate;

    public Slugs(Ship ship) {
        this.maxslugs = 50;
        this.initslugs = 20;
        this.width = 3;
        this.height = 3;
        this.shootpar1 = 10;
        this.shootpar2 = 30;
        this.incrate = 40;
        this.oShip = ship;
        this.tcount = 1;
        this.screenw = 100;
        this.screenh = 100;
        this.random = new Random();
        this.pos = new int[50][2];
        this.vec = new int[50][2];
        this.init();
    }

    public void init() {
        int n = 0;
        while (n < 50) {
            this.pos[n][0] = -11;
            this.pos[n][1] = -11;
            this.vec[n][0] = 0;
            this.vec[n][1] = 0;
            ++n;
        }
        this.slugsnum = 20;
    }

    public int getwidth() {
        return 3;
    }

    public int getheight() {
        return 3;
    }

    public void move() {
        this.setshippos();
        int n = 0;
        while (n < this.slugsnum) {
            int[] nArray = this.pos[n];
            nArray[0] = nArray[0] + this.vec[n][0];
            int[] nArray2 = this.pos[n];
            nArray2[1] = nArray2[1] + this.vec[n][1];
            ++n;
        }
        this.checkslugs();
        ++this.tcount;
    }

    protected void checkslugs() {
        int n = 0;
        while (n < this.slugsnum) {
            if (this.pos[n][0] < -10 || this.pos[n][0] > this.screenw + 10 || this.pos[n][1] < -10 || this.pos[n][1] > this.screenh + 10) {
                this.setpos(n);
                this.setvec(n);
            }
            ++n;
        }
        int n2 = 0;
        while (n2 < this.slugsnum) {
            if (this.pos[n2][0] > this.shipposx - 2 && this.pos[n2][0] < this.shipposx + 2 && (this.pos[n2][1] > this.shipposy - 1 && this.pos[n2][1] < this.shipposy + 3 || this.pos[n2][1] + 3 > this.shipposy - 1 && this.pos[n2][1] + 3 < this.shipposy + 3) || this.pos[n2][0] + 3 > this.shipposx - 2 && this.pos[n2][0] + 3 < this.shipposx + 2 && (this.pos[n2][1] > this.shipposy - 1 && this.pos[n2][1] < this.shipposy + 3 || this.pos[n2][1] + 3 > this.shipposy - 1 && this.pos[n2][1] + 3 < this.shipposy + 3)) {
                this.oShip.die();
            }
            ++n2;
        }
    }

    public int getposx(int n) {
        return this.pos[n][0];
    }

    public int getposy(int n) {
        return this.pos[n][1];
    }

    public int getslugsnum() {
        return this.slugsnum;
    }

    protected void setpos(int n) {
        switch (Math.abs(this.random.nextInt() % 4)) {
            case 0: {
                this.pos[n][0] = Math.abs(this.random.nextInt()) % (this.screenw + 10);
                this.pos[n][1] = -(Math.abs(this.random.nextInt()) % 10);
                break;
            }
            case 1: {
                this.pos[n][0] = this.screenw + Math.abs(this.random.nextInt()) % 10;
                this.pos[n][1] = Math.abs(this.random.nextInt()) % (this.screenh + 10);
                break;
            }
            case 2: {
                this.pos[n][0] = Math.abs(this.random.nextInt()) % (this.screenw + 10) - 10;
                this.pos[n][1] = Math.abs(this.random.nextInt()) % 10 + this.screenh;
                break;
            }
            case 3: {
                this.pos[n][0] = -(Math.abs(this.random.nextInt()) % 10);
                this.pos[n][1] = Math.abs(this.random.nextInt()) % (this.screenh + 10) - 10;
            }
        }
    }

    protected void setvec(int n) {
        this.deltax = this.shipposx - this.pos[n][0];
        this.deltay = this.shipposy - this.pos[n][1];
        this.vec[n][0] = this.deltax / 30;
        this.vec[n][1] = this.deltay / 30;
        if (this.vec[n][0] == 0 && this.vec[n][1] == 0) {
            if (this.deltax > this.deltay) {
                this.vec[n][0] = this.deltax > 0 ? 1 : -1;
            } else {
                this.vec[n][1] = this.deltay > 0 ? 1 : -1;
            }
        }
    }

    public void setscreen(int n, int n2) {
        this.screenw = n;
        this.screenh = n2;
        int n3 = 0;
        while (n3 < 20) {
            this.setpos(n3);
            this.setvec(n3);
            ++n3;
        }
    }

    public void incslugsnum() {
        if (this.tcount >= 40) {
            ++this.slugsnum;
            if (this.slugsnum > 50) {
                this.slugsnum = 50;
            }
            this.tcount = 1;
        }
    }

    protected void setshippos() {
        this.shipposx = this.oShip.getposx();
        this.shipposy = this.oShip.getposy();
    }
}

