/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;

public class ImageUtil {
    public static final int TURN_LEFT = 1;
    public static final int TURN_RIGHT = 2;

    public int[] getPixels(Image src) {
        int w2 = src.getWidth();
        int h2 = src.getHeight();
        int[] pixels = new int[w2 * h2];
        src.getRGB(pixels, 0, w2, 0, 0, w2, h2);
        return pixels;
    }

    public Image drawPixels(int[] pixels, int w2, int h2) {
        Image image = Image.createRGBImage((int[])pixels, (int)w2, (int)h2, (boolean)true);
        pixels = null;
        return image;
    }

    public Image effect_resizeImage(Image src, int destW, int destH) {
        int srcW = src.getWidth();
        int srcH = src.getHeight();
        int[] destPixels = new int[destW * destH];
        int[] srcPixels = this.getPixels(src);
        int destY = 0;
        while (destY < destH) {
            int destX = 0;
            while (destX < destW) {
                int srcX = destX * srcW / destW;
                int srcY = destY * srcH / destH;
                destPixels[destX + destY * destW] = srcPixels[srcX + srcY * srcW];
                ++destX;
            }
            ++destY;
        }
        return this.drawPixels(destPixels, destW, destH);
    }

    public Image effect_light_contrast(Image src, double contrast, int light) {
        int srcW = src.getWidth();
        int srcH = src.getHeight();
        int[] srcPixels = this.getPixels(src);
        int r2 = 0;
        int g2 = 0;
        int b2 = 0;
        int a2 = 0;
        int i2 = 0;
        while (i2 < srcH) {
            int ii = 0;
            while (ii < srcW) {
                int argb = srcPixels[i2 * srcW + ii];
                a2 = (argb & 0xFF000000) >> 24;
                r2 = (argb & 0xFF0000) >> 16;
                g2 = (argb & 0xFF00) >> 8;
                b2 = argb & 0xFF;
                r2 = (int)((double)r2 * contrast + (double)light);
                g2 = (int)((double)g2 * contrast + (double)light);
                b2 = (int)((double)b2 * contrast + (double)light);
                if (r2 > 255) {
                    r2 = 255;
                } else if (r2 < 0) {
                    r2 = 0;
                }
                if (g2 > 255) {
                    g2 = 255;
                } else if (g2 < 0) {
                    g2 = 0;
                }
                if (b2 > 255) {
                    b2 = 255;
                } else if (b2 < 0) {
                    b2 = 0;
                }
                srcPixels[i2 * srcW + ii] = a2 << 24 | r2 << 16 | g2 << 8 | b2;
                ++ii;
            }
            ++i2;
        }
        return this.drawPixels(srcPixels, srcW, srcH);
    }

    public Image effect_cut(Image src, int cut_xpos, int cut_ypos, int cut_width, int cut_height) {
        int srcW = src.getWidth();
        int srcH = src.getHeight();
        int[] srcPixels = this.getPixels(src);
        int[] desPixels = new int[cut_width * cut_height];
        int num = 0;
        int i2 = 0;
        while (i2 < srcH) {
            if (i2 >= cut_ypos && i2 < cut_height + cut_ypos) {
                int ii = 0;
                while (ii < srcW) {
                    if (ii >= cut_xpos && ii < cut_width + cut_xpos) {
                        desPixels[num] = srcPixels[i2 * srcW + ii];
                        ++num;
                    }
                    ++ii;
                }
            }
            ++i2;
        }
        return this.drawPixels(desPixels, cut_width, cut_height);
    }

    public Image effect_image_add_image(Image src, Image image, int x_pos, int y_pos) {
        Image temp = Image.createImage((int)src.getWidth(), (int)src.getHeight());
        Graphics g2 = temp.getGraphics();
        int alpha = 168;
        int[] srcRgbdata = new int[src.getWidth() * src.getHeight()];
        int[] desRgbdata = new int[image.getWidth() * image.getHeight()];
        src.getRGB(srcRgbdata, 0, src.getWidth(), 0, 0, src.getWidth(), src.getHeight());
        image.getRGB(desRgbdata, 0, image.getWidth(), 0, 0, image.getWidth(), image.getHeight());
        g2.drawRGB(this.getTransImg(alpha, srcRgbdata, desRgbdata), 0, src.getWidth(), 0, 0, src.getWidth(), src.getHeight(), false);
        src = null;
        image = null;
        return temp;
    }

    public Image effect_image_add_str(Image src, String str, int x_pos, int y_pos) {
        Image temp = Image.createImage((int)src.getWidth(), (int)src.getHeight());
        Graphics g2 = temp.getGraphics();
        g2.drawImage(src, 0, 0, 20);
        g2.setColor(0);
        g2.drawString(str, x_pos, y_pos, 20);
        return temp;
    }

    public Image effect_negative(Image src) {
        int srcW = src.getWidth();
        int srcH = src.getHeight();
        int[] srcPixels = this.getPixels(src);
        int r2 = 0;
        int g2 = 0;
        int b2 = 0;
        int a2 = 0;
        int i2 = 0;
        while (i2 < srcH) {
            int ii = 0;
            while (ii < srcW) {
                int argb = srcPixels[i2 * srcW + ii];
                a2 = (argb & 0xFF000000) >> 24;
                r2 = 255 - ((argb & 0xFF0000) >> 16);
                g2 = 255 - ((argb & 0xFF00) >> 8);
                b2 = 255 - (argb & 0xFF);
                srcPixels[i2 * srcW + ii] = a2 << 24 | r2 << 16 | g2 << 8 | b2;
                ++ii;
            }
            ++i2;
        }
        return this.drawPixels(srcPixels, srcW, srcH);
    }

    public Image effect_black_white(Image src) {
        int srcW = src.getWidth();
        int srcH = src.getHeight();
        int[] srcPixels = this.getPixels(src);
        int r2 = 0;
        int g2 = 0;
        int b2 = 0;
        int a2 = 0;
        int i2 = 0;
        while (i2 < srcH) {
            int ii = 0;
            while (ii < srcW) {
                int temp;
                int argb = srcPixels[i2 * srcW + ii];
                a2 = (argb & 0xFF000000) >> 24;
                r2 = (argb & 0xFF0000) >> 16;
                g2 = (argb & 0xFF00) >> 8;
                b2 = argb & 0xFF;
                r2 = temp = (int)(0.299 * (double)r2 + 0.587 * (double)g2 + 0.114 * (double)b2);
                g2 = temp;
                b2 = temp;
                srcPixels[i2 * srcW + ii] = a2 << 24 | r2 << 16 | g2 << 8 | b2;
                ++ii;
            }
            ++i2;
        }
        return this.drawPixels(srcPixels, srcW, srcH);
    }

    public Image effect_crayon(Image src) {
        int srcW = src.getWidth();
        int srcH = src.getHeight();
        int[] srcPixels = this.getPixels(src);
        int r2 = 0;
        int g2 = 0;
        int b2 = 0;
        int a2 = 0;
        int r1 = 0;
        int g1 = 0;
        int b1 = 0;
        boolean a1 = false;
        int r22 = 0;
        int g22 = 0;
        int b22 = 0;
        boolean a22 = false;
        int i2 = 0;
        while (i2 < srcH) {
            int ii = 0;
            while (ii < srcW) {
                int argb = srcPixels[i2 * srcW + ii];
                a2 = (argb & 0xFF000000) >> 24;
                r2 = (argb & 0xFF0000) >> 16;
                g2 = (argb & 0xFF00) >> 8;
                b2 = argb & 0xFF;
                if (i2 + 1 == srcH) {
                    r1 = 0;
                    g1 = 0;
                    b1 = 0;
                } else {
                    argb = srcPixels[(i2 + 1) * srcW + ii];
                    r1 = (argb & 0xFF0000) >> 16;
                    g1 = (argb & 0xFF00) >> 8;
                    b1 = argb & 0xFF;
                }
                if (ii + 1 == srcW) {
                    r22 = 0;
                    g22 = 0;
                    b22 = 0;
                } else {
                    argb = srcPixels[i2 * srcW + ii + 1];
                    r22 = (argb & 0xFF0000) >> 16;
                    g22 = (argb & 0xFF00) >> 8;
                    b22 = argb & 0xFF;
                }
                r2 = (int)Math.sqrt(2 * (r2 - r1) * (r2 - r1) + (r2 - r22) * (r2 - r22));
                g2 = (int)Math.sqrt(2 * (g2 - g1) * (g2 - g1) + (g2 - g22) * (g2 - g22));
                b2 = (int)Math.sqrt(2 * (b2 - b1) * (b2 - b1) + (b2 - b22) * (b2 - b22));
                r2 = 255 - r2;
                g2 = 255 - g2;
                b2 = 255 - b2;
                srcPixels[i2 * srcW + ii] = a2 << 24 | r2 << 16 | g2 << 8 | b2;
                ++ii;
            }
            ++i2;
        }
        return this.drawPixels(srcPixels, srcW, srcH);
    }

    public Image effect_hoodwink(Image src) {
        int srcW = src.getWidth();
        int srcH = src.getHeight();
        int[] srcPixels = this.getPixels(src);
        int r2 = 0;
        int g2 = 0;
        int b2 = 0;
        int a2 = 0;
        int i2 = 0;
        while (i2 < srcH) {
            int ii = 0;
            while (ii < srcW) {
                int argb = srcPixels[i2 * srcW + ii];
                a2 = (argb & 0xFF000000) >> 24;
                r2 = (argb & 0xFF0000) >> 16;
                g2 = (argb & 0xFF00) >> 8;
                b2 = argb & 0xFF;
                r2 = (int)(0.299 * (double)r2);
                g2 = (int)(0.587 * (double)g2);
                b2 = (int)(0.114 * (double)b2);
                srcPixels[i2 * srcW + ii] = a2 << 24 | r2 << 16 | g2 << 8 | b2;
                ++ii;
            }
            ++i2;
        }
        return this.drawPixels(srcPixels, srcW, srcH);
    }

    private int[] getTransImg(int alpha, int[] srcRgbdata, int[] desRgbdata) {
        int[] tempRgbData = new int[desRgbdata.length];
        int i2 = 0;
        while (i2 < desRgbdata.length) {
            int sr = (srcRgbdata[i2] & 0xFF0000) >> 16;
            int sg = (srcRgbdata[i2] & 0xFF00) >> 8;
            int sb = srcRgbdata[i2] & 0xFF;
            int dr = (desRgbdata[i2] & 0xFF0000) >> 16;
            int dg = (desRgbdata[i2] & 0xFF00) >> 8;
            int db = desRgbdata[i2] & 0xFF;
            int tr = (sr * alpha + dr * (255 - alpha)) / 255;
            int tg = (sg * alpha + dg * (255 - alpha)) / 255;
            int tb = (sb * alpha + db * (255 - alpha)) / 255;
            tempRgbData[i2] = tr << 16 | tg << 8 | tb;
            ++i2;
        }
        return tempRgbData;
    }

    public Image effect_rotate(Image src, int direction) {
        Sprite sprite = new Sprite(src);
        switch (direction) {
            case 1: {
                sprite.setTransform(6);
                break;
            }
            case 2: {
                sprite.setTransform(5);
            }
        }
        Image temp = Image.createImage((int)src.getHeight(), (int)src.getWidth());
        Graphics g2 = temp.getGraphics();
        sprite.setPosition(0, 0);
        sprite.paint(g2);
        return temp;
    }

    public Image effect_neonLight(Image src) {
        int srcW = src.getWidth();
        int srcH = src.getHeight();
        int[] srcPixels = this.getPixels(src);
        int r2 = 0;
        int g2 = 0;
        int b2 = 0;
        int a2 = 0;
        int r1 = 0;
        int g1 = 0;
        int b1 = 0;
        boolean a1 = false;
        int r22 = 0;
        int g22 = 0;
        int b22 = 0;
        boolean a22 = false;
        int i2 = 0;
        while (i2 < srcH) {
            int ii = 0;
            while (ii < srcW) {
                int argb = srcPixels[i2 * srcW + ii];
                a2 = (argb & 0xFF000000) >> 24;
                r2 = (argb & 0xFF0000) >> 16;
                g2 = (argb & 0xFF00) >> 8;
                b2 = argb & 0xFF;
                if (i2 + 1 == srcH) {
                    r1 = 0;
                    g1 = 0;
                    b1 = 0;
                } else {
                    argb = srcPixels[(i2 + 1) * srcW + ii];
                    r1 = (argb & 0xFF0000) >> 16;
                    g1 = (argb & 0xFF00) >> 8;
                    b1 = argb & 0xFF;
                }
                if (ii + 1 == srcW) {
                    r22 = 0;
                    g22 = 0;
                    b22 = 0;
                } else {
                    argb = srcPixels[i2 * srcW + ii + 1];
                    r22 = (argb & 0xFF0000) >> 16;
                    g22 = (argb & 0xFF00) >> 8;
                    b22 = argb & 0xFF;
                }
                r2 = (int)Math.sqrt(2 * (r2 - r1) * (r2 - r1) + (r2 - r22) * (r2 - r22));
                g2 = (int)Math.sqrt(2 * (g2 - g1) * (g2 - g1) + (g2 - g22) * (g2 - g22));
                b2 = (int)Math.sqrt(2 * (b2 - b1) * (b2 - b1) + (b2 - b22) * (b2 - b22));
                srcPixels[i2 * srcW + ii] = a2 << 24 | r2 << 16 | g2 << 8 | b2;
                ++ii;
            }
            ++i2;
        }
        return this.drawPixels(srcPixels, srcW, srcH);
    }
}

