/*
 * Decompiled with CFR 0.152.
 */
package org.luaj.kahluafork.compiler;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Hashtable;
import org.luaj.kahluafork.compiler.FuncState;
import org.luaj.kahluafork.compiler.InstructionPtr;
import se.krka.kahlua.vm.LuaException;
import se.krka.kahlua.vm.LuaPrototype;

public class LexState {
    public int nCcalls;
    Hashtable strings = new Hashtable();
    protected static final String RESERVED_LOCAL_VAR_FOR_CONTROL = "(for control)";
    protected static final String RESERVED_LOCAL_VAR_FOR_STATE = "(for state)";
    protected static final String RESERVED_LOCAL_VAR_FOR_GENERATOR = "(for generator)";
    protected static final String RESERVED_LOCAL_VAR_FOR_STEP = "(for step)";
    protected static final String RESERVED_LOCAL_VAR_FOR_LIMIT = "(for limit)";
    protected static final String RESERVED_LOCAL_VAR_FOR_INDEX = "(for index)";
    protected static final String[] RESERVED_LOCAL_VAR_KEYWORDS;
    private static final Hashtable RESERVED_LOCAL_VAR_KEYWORDS_TABLE;
    private static final int EOZ = -1;
    private static final int MAXSRC = 80;
    private static final int MAX_INT = 0x7FFFFFFD;
    private static final int UCHAR_MAX = 255;
    private static final int LUAI_MAXCCALLS = 200;
    static final int NO_JUMP = -1;
    static final int OPR_ADD = 0;
    static final int OPR_SUB = 1;
    static final int OPR_MUL = 2;
    static final int OPR_DIV = 3;
    static final int OPR_MOD = 4;
    static final int OPR_POW = 5;
    static final int OPR_CONCAT = 6;
    static final int OPR_NE = 7;
    static final int OPR_EQ = 8;
    static final int OPR_LT = 9;
    static final int OPR_LE = 10;
    static final int OPR_GT = 11;
    static final int OPR_GE = 12;
    static final int OPR_AND = 13;
    static final int OPR_OR = 14;
    static final int OPR_NOBINOPR = 15;
    static final int OPR_MINUS = 0;
    static final int OPR_NOT = 1;
    static final int OPR_LEN = 2;
    static final int OPR_NOUNOPR = 3;
    static final int VVOID = 0;
    static final int VNIL = 1;
    static final int VTRUE = 2;
    static final int VFALSE = 3;
    static final int VK = 4;
    static final int VKNUM = 5;
    static final int VLOCAL = 6;
    static final int VUPVAL = 7;
    static final int VGLOBAL = 8;
    static final int VINDEXED = 9;
    static final int VJMP = 10;
    static final int VRELOCABLE = 11;
    static final int VNONRELOC = 12;
    static final int VCALL = 13;
    static final int VVARARG = 14;
    int current;
    int linenumber;
    int lastline;
    final Token t = new Token();
    final Token lookahead = new Token();
    FuncState fs;
    InputStream z;
    byte[] buff;
    int nbuff;
    String source;
    byte decpoint;
    static final String[] luaX_tokens;
    static final int TK_AND = 257;
    static final int TK_BREAK = 258;
    static final int TK_DO = 259;
    static final int TK_ELSE = 260;
    static final int TK_ELSEIF = 261;
    static final int TK_END = 262;
    static final int TK_FALSE = 263;
    static final int TK_FOR = 264;
    static final int TK_FUNCTION = 265;
    static final int TK_IF = 266;
    static final int TK_IN = 267;
    static final int TK_LOCAL = 268;
    static final int TK_NIL = 269;
    static final int TK_NOT = 270;
    static final int TK_OR = 271;
    static final int TK_REPEAT = 272;
    static final int TK_RETURN = 273;
    static final int TK_THEN = 274;
    static final int TK_TRUE = 275;
    static final int TK_UNTIL = 276;
    static final int TK_WHILE = 277;
    static final int TK_CONCAT = 278;
    static final int TK_DOTS = 279;
    static final int TK_EQ = 280;
    static final int TK_GE = 281;
    static final int TK_LE = 282;
    static final int TK_NE = 283;
    static final int TK_NUMBER = 284;
    static final int TK_NAME = 285;
    static final int TK_STRING = 286;
    static final int TK_EOS = 287;
    static final int FIRST_RESERVED = 257;
    static final int NUM_RESERVED = 21;
    static final Hashtable RESERVED;
    static final int[] priorityLeft;
    static final int[] priorityRight;
    static final int UNARY_PRIORITY = 8;

    private static final String LUA_QS(String s2) {
        return "'" + s2 + "'";
    }

    private static final String LUA_QL(Object o2) {
        return LexState.LUA_QS(String.valueOf(o2));
    }

    public static boolean isReservedKeyword(String varName) {
        return RESERVED_LOCAL_VAR_KEYWORDS_TABLE.containsKey(varName);
    }

    private boolean isalnum(int c2) {
        return c2 >= 48 && c2 <= 57 || c2 >= 97 && c2 <= 122 || c2 >= 65 && c2 <= 90 || c2 == 95;
    }

    private boolean isalpha(int c2) {
        return c2 >= 97 && c2 <= 122 || c2 >= 65 && c2 <= 90;
    }

    private boolean isdigit(int c2) {
        return c2 >= 48 && c2 <= 57;
    }

    private boolean isspace(int c2) {
        return c2 <= 32;
    }

    public static LuaPrototype compile(int firstByte, InputStream z2, String name) {
        LexState lexstate = new LexState(z2);
        FuncState funcstate = new FuncState();
        lexstate.setinput(firstByte, z2, name);
        lexstate.open_func(funcstate);
        funcstate.isVararg = 2;
        funcstate.f.name = "@" + name;
        lexstate.next();
        lexstate.chunk();
        lexstate.check(287);
        lexstate.close_func();
        FuncState._assert(funcstate.prev == null);
        FuncState._assert(funcstate.f.numUpvalues == 0);
        FuncState._assert(lexstate.fs == null);
        return funcstate.f;
    }

    public LexState(InputStream stream) {
        this.z = stream;
        this.buff = new byte[32];
    }

    void nextChar() {
        try {
            this.current = this.z.read();
        }
        catch (IOException e2) {
            e2.printStackTrace();
            this.current = -1;
        }
    }

    boolean currIsNewline() {
        return this.current == 10 || this.current == 13;
    }

    void save_and_next() {
        this.save(this.current);
        this.nextChar();
    }

    void save(int c2) {
        if (this.buff == null || this.nbuff + 1 > this.buff.length) {
            this.buff = FuncState.realloc(this.buff, this.nbuff * 2 + 1);
        }
        this.buff[this.nbuff++] = (byte)c2;
    }

    String token2str(int token) {
        if (token < 257) {
            return LexState.iscntrl(token) ? "char(" + token + ")" : String.valueOf((char)token);
        }
        return luaX_tokens[token - 257];
    }

    private static boolean iscntrl(int token) {
        return token < 32;
    }

    String txtToken(int token) {
        switch (token) {
            case 284: 
            case 285: 
            case 286: {
                return new String(this.buff, 0, this.nbuff);
            }
        }
        return this.token2str(token);
    }

    void lexerror(String msg, int token) {
        String cid = this.chunkid(this.source.toString());
        String errorMessage = token != 0 ? cid + ":" + this.linenumber + ": " + msg + " near `" + this.txtToken(token) + "`" : cid + ":" + this.linenumber + ": " + msg;
        throw new LuaException((Object)errorMessage);
    }

    String chunkid(String source) {
        if (source.startsWith("=")) {
            return source.substring(1);
        }
        String end = "";
        if (source.startsWith("@")) {
            source = source.substring(1);
        } else {
            source = "[string \"" + source;
            end = "\"]";
        }
        int n2 = source.length() + end.length();
        if (n2 > 80) {
            source = source.substring(0, 80 - end.length() - 3) + "...";
        }
        return source + end;
    }

    void syntaxerror(String msg) {
        this.lexerror(msg, this.t.token);
    }

    String newstring(String s2) {
        return this.newTString(s2);
    }

    String newstring(byte[] chars, int offset, int len) {
        try {
            String s2 = new String(chars, offset, len, "UTF-8");
            return this.newTString(s2);
        }
        catch (UnsupportedEncodingException e2) {
            return null;
        }
    }

    public String newTString(String s2) {
        String t2 = (String)this.strings.get(s2);
        if (t2 == null) {
            t2 = s2;
            this.strings.put(t2, t2);
        }
        return t2;
    }

    void inclinenumber() {
        int old = this.current;
        FuncState._assert(this.currIsNewline());
        this.nextChar();
        if (this.currIsNewline() && this.current != old) {
            this.nextChar();
        }
        if (++this.linenumber >= 0x7FFFFFFD) {
            this.syntaxerror("chunk has too many lines");
        }
    }

    void setinput(int firstByte, InputStream z2, String source) {
        this.decpoint = (byte)46;
        this.lookahead.token = 287;
        this.z = z2;
        this.fs = null;
        this.linenumber = 1;
        this.lastline = 1;
        this.source = source;
        this.nbuff = 0;
        this.current = firstByte;
        this.skipShebang();
    }

    private void skipShebang() {
        if (this.current == 35) {
            while (!this.currIsNewline() && this.current != -1) {
                this.nextChar();
            }
        }
    }

    boolean check_next(String set) {
        if (set.indexOf(this.current) < 0) {
            return false;
        }
        this.save_and_next();
        return true;
    }

    void buffreplace(byte from, byte to) {
        int n2 = this.nbuff;
        byte[] p2 = this.buff;
        while (--n2 >= 0) {
            if (p2[n2] != from) continue;
            p2[n2] = to;
        }
    }

    boolean str2d(String str, Token token) {
        int d2 = (str = str.trim()).startsWith("0x") ? Integer.parseInt(str.substring(2), 16) : Integer.parseInt(str);
        token.r = d2;
        return true;
    }

    void read_numeral(Token token) {
        FuncState._assert(this.isdigit(this.current));
        do {
            this.save_and_next();
        } while (this.isdigit(this.current) || this.current == 46);
        if (this.check_next("Ee")) {
            this.check_next("+-");
        }
        while (this.isalnum(this.current) || this.current == 95) {
            this.save_and_next();
        }
        this.save(0);
        this.buffreplace((byte)46, this.decpoint);
        String str = new String(this.buff, 0, this.nbuff);
        this.str2d(str, token);
    }

    int skip_sep() {
        int count = 0;
        int s2 = this.current;
        FuncState._assert(s2 == 91 || s2 == 93);
        this.save_and_next();
        while (this.current == 61) {
            this.save_and_next();
            ++count;
        }
        return this.current == s2 ? count : -count - 1;
    }

    void read_long_string(Token token, int sep) {
        int cont = 0;
        this.save_and_next();
        if (this.currIsNewline()) {
            this.inclinenumber();
        }
        boolean endloop = false;
        block6: while (!endloop) {
            switch (this.current) {
                case -1: {
                    this.lexerror(token != null ? "unfinished long string" : "unfinished long comment", 287);
                    continue block6;
                }
                case 91: {
                    if (this.skip_sep() != sep) continue block6;
                    this.save_and_next();
                    ++cont;
                    continue block6;
                }
                case 93: {
                    if (this.skip_sep() != sep) continue block6;
                    this.save_and_next();
                    endloop = true;
                    continue block6;
                }
                case 10: 
                case 13: {
                    this.save(10);
                    this.inclinenumber();
                    if (token != null) continue block6;
                    this.nbuff = 0;
                    continue block6;
                }
            }
            if (token != null) {
                this.save_and_next();
                continue;
            }
            this.nextChar();
        }
        if (token != null) {
            token.ts = this.newstring(this.buff, 2 + sep, this.nbuff - 2 * (2 + sep));
        }
    }

    void read_string(int del, Token token) {
        this.save_and_next();
        block16: while (this.current != del) {
            switch (this.current) {
                case -1: {
                    this.lexerror("unfinished string", 287);
                    continue block16;
                }
                case 10: 
                case 13: {
                    this.lexerror("unfinished string", 286);
                    continue block16;
                }
                case 92: {
                    int c2;
                    this.nextChar();
                    switch (this.current) {
                        case 97: {
                            c2 = 7;
                            break;
                        }
                        case 98: {
                            c2 = 8;
                            break;
                        }
                        case 102: {
                            c2 = 12;
                            break;
                        }
                        case 110: {
                            c2 = 10;
                            break;
                        }
                        case 114: {
                            c2 = 13;
                            break;
                        }
                        case 116: {
                            c2 = 9;
                            break;
                        }
                        case 118: {
                            c2 = 11;
                            break;
                        }
                        case 10: 
                        case 13: {
                            this.save(10);
                            this.inclinenumber();
                            continue block16;
                        }
                        case -1: {
                            continue block16;
                        }
                        default: {
                            if (!this.isdigit(this.current)) {
                                this.save_and_next();
                                continue block16;
                            }
                            int i2 = 0;
                            c2 = 0;
                            do {
                                c2 = 10 * c2 + (this.current - 48);
                                this.nextChar();
                            } while (++i2 < 3 && this.isdigit(this.current));
                            if (c2 > 255) {
                                this.lexerror("escape sequence too large", 286);
                            }
                            this.save(c2);
                            continue block16;
                        }
                    }
                    this.save(c2);
                    this.nextChar();
                    continue block16;
                }
            }
            this.save_and_next();
        }
        this.save_and_next();
        token.ts = this.newstring(this.buff, 1, this.nbuff - 2);
    }

    int llex(Token token) {
        this.nbuff = 0;
        block12: while (true) {
            switch (this.current) {
                case 10: 
                case 13: {
                    this.inclinenumber();
                    continue block12;
                }
                case 45: {
                    int sep;
                    this.nextChar();
                    if (this.current != 45) {
                        return 45;
                    }
                    this.nextChar();
                    if (this.current == 91) {
                        sep = this.skip_sep();
                        this.nbuff = 0;
                        if (sep >= 0) {
                            this.read_long_string(null, sep);
                            this.nbuff = 0;
                            continue block12;
                        }
                    }
                    while (true) {
                        if (this.currIsNewline() || this.current == -1) continue block12;
                        this.nextChar();
                    }
                }
                case 91: {
                    int sep = this.skip_sep();
                    if (sep >= 0) {
                        this.read_long_string(token, sep);
                        return 286;
                    }
                    if (sep == -1) {
                        return 91;
                    }
                    this.lexerror("invalid long string delimiter", 286);
                }
                case 61: {
                    this.nextChar();
                    if (this.current != 61) {
                        return 61;
                    }
                    this.nextChar();
                    return 280;
                }
                case 60: {
                    this.nextChar();
                    if (this.current != 61) {
                        return 60;
                    }
                    this.nextChar();
                    return 282;
                }
                case 62: {
                    this.nextChar();
                    if (this.current != 61) {
                        return 62;
                    }
                    this.nextChar();
                    return 281;
                }
                case 126: {
                    this.nextChar();
                    if (this.current != 61) {
                        return 126;
                    }
                    this.nextChar();
                    return 283;
                }
                case 34: 
                case 39: {
                    this.read_string(this.current, token);
                    return 286;
                }
                case 46: {
                    this.save_and_next();
                    if (this.check_next(".")) {
                        if (this.check_next(".")) {
                            return 279;
                        }
                        return 278;
                    }
                    if (!this.isdigit(this.current)) {
                        return 46;
                    }
                    this.read_numeral(token);
                    return 284;
                }
                case -1: {
                    return 287;
                }
            }
            if (!this.isspace(this.current)) break;
            FuncState._assert(!this.currIsNewline());
            this.nextChar();
        }
        if (this.isdigit(this.current)) {
            this.read_numeral(token);
            return 284;
        }
        if (this.isalpha(this.current) || this.current == 95) {
            do {
                this.save_and_next();
            } while (this.isalnum(this.current) || this.current == 95);
            String ts = this.newstring(this.buff, 0, this.nbuff);
            if (RESERVED.containsKey(ts)) {
                return (Integer)RESERVED.get(ts);
            }
            token.ts = ts;
            return 285;
        }
        int c2 = this.current;
        this.nextChar();
        return c2;
    }

    void next() {
        this.lastline = this.linenumber;
        if (this.lookahead.token != 287) {
            this.t.set(this.lookahead);
            this.lookahead.token = 287;
        } else {
            this.t.token = this.llex(this.t);
        }
    }

    void lookahead() {
        FuncState._assert(this.lookahead.token == 287);
        this.lookahead.token = this.llex(this.lookahead);
    }

    boolean hasmultret(int k2) {
        return k2 == 13 || k2 == 14;
    }

    void error_expected(int token) {
        this.syntaxerror(LexState.LUA_QS(this.token2str(token)) + " expected");
    }

    boolean testnext(int c2) {
        if (this.t.token == c2) {
            this.next();
            return true;
        }
        return false;
    }

    void check(int c2) {
        if (this.t.token != c2) {
            this.error_expected(c2);
        }
    }

    void checknext(int c2) {
        this.check(c2);
        this.next();
    }

    void check_condition(boolean c2, String msg) {
        if (!c2) {
            this.syntaxerror(msg);
        }
    }

    void check_match(int what, int who, int where) {
        if (!this.testnext(what)) {
            if (where == this.linenumber) {
                this.error_expected(what);
            } else {
                this.syntaxerror(LexState.LUA_QS(this.token2str(what)) + " expected " + "(to close " + LexState.LUA_QS(this.token2str(who)) + " at line " + where + ")");
            }
        }
    }

    String str_checkname() {
        this.check(285);
        String ts = this.t.ts;
        this.next();
        return ts;
    }

    void codestring(expdesc e2, String s2) {
        e2.init(4, this.fs.stringK(s2));
    }

    void checkname(expdesc e2) {
        this.codestring(e2, this.str_checkname());
    }

    int registerlocalvar(String varname) {
        FuncState fs = this.fs;
        if (fs.locvars == null || fs.nlocvars + 1 > fs.locvars.length) {
            fs.locvars = FuncState.realloc(fs.locvars, fs.nlocvars * 2 + 1);
        }
        fs.locvars[fs.nlocvars] = varname;
        return fs.nlocvars++;
    }

    void new_localvarliteral(String v2, int n2) {
        String ts = this.newstring(v2);
        this.new_localvar(ts, n2);
    }

    void new_localvar(String name, int n2) {
        FuncState fs = this.fs;
        fs.checklimit(fs.nactvar + n2 + 1, 200, "local variables");
        fs.actvar[fs.nactvar + n2] = (short)this.registerlocalvar(name);
    }

    void adjustlocalvars(int nvars) {
        FuncState fs = this.fs;
        fs.nactvar += nvars;
    }

    void removevars(int tolevel) {
        FuncState fs = this.fs;
        fs.nactvar = tolevel;
    }

    void singlevar(expdesc var) {
        FuncState fs = this.fs;
        String varname = this.str_checkname();
        if (fs.singlevaraux(varname, var, 1) == 8) {
            var.info = fs.stringK(varname);
        }
    }

    void adjust_assign(int nvars, int nexps, expdesc e2) {
        FuncState fs = this.fs;
        int extra = nvars - nexps;
        if (this.hasmultret(e2.k)) {
            if (++extra < 0) {
                extra = 0;
            }
            fs.setreturns(e2, extra);
            if (extra > 1) {
                fs.reserveregs(extra - 1);
            }
        } else {
            if (e2.k != 0) {
                fs.exp2nextreg(e2);
            }
            if (extra > 0) {
                int reg = fs.freereg;
                fs.reserveregs(extra);
                fs.nil(reg, extra);
            }
        }
    }

    void enterlevel() {
        if (++this.nCcalls > 200) {
            this.lexerror("chunk has too many syntax levels", 0);
        }
    }

    void leavelevel() {
        --this.nCcalls;
    }

    void pushclosure(FuncState func, expdesc v2) {
        FuncState fs = this.fs;
        LuaPrototype f2 = fs.f;
        if (f2.prototypes == null || fs.np + 1 > f2.prototypes.length) {
            f2.prototypes = FuncState.realloc(f2.prototypes, fs.np * 2 + 1);
        }
        f2.prototypes[fs.np++] = func.f;
        v2.init(11, fs.codeABx(36, 0, fs.np - 1));
        for (int i2 = 0; i2 < func.f.numUpvalues; ++i2) {
            int o2 = func.upvalues_k[i2] == 6 ? 0 : 4;
            fs.codeABC(o2, 0, func.upvalues_info[i2], 0);
        }
    }

    void open_func(FuncState fs) {
        LuaPrototype f2 = new LuaPrototype();
        if (this.fs != null) {
            f2.name = this.fs.f.name;
        }
        fs.f = f2;
        fs.prev = this.fs;
        fs.ls = this;
        this.fs = fs;
        fs.pc = 0;
        fs.lasttarget = -1;
        fs.jpc = -1;
        fs.freereg = 0;
        fs.nk = 0;
        fs.np = 0;
        fs.nlocvars = 0;
        fs.nactvar = 0;
        fs.bl = null;
        f2.maxStacksize = 2;
        fs.htable = new Hashtable();
    }

    void close_func() {
        FuncState fs = this.fs;
        LuaPrototype f2 = fs.f;
        f2.isVararg = fs.isVararg != 0;
        this.removevars(0);
        fs.ret(0, 0);
        f2.code = FuncState.realloc(f2.code, fs.pc);
        f2.lines = FuncState.realloc(f2.lines, fs.pc);
        f2.constants = FuncState.realloc(f2.constants, fs.nk);
        f2.prototypes = FuncState.realloc(f2.prototypes, fs.np);
        fs.locvars = FuncState.realloc(fs.locvars, fs.nlocvars);
        fs.upvalues = FuncState.realloc(fs.upvalues, f2.numUpvalues);
        FuncState._assert(fs.bl == null);
        this.fs = fs.prev;
    }

    void field(expdesc v2) {
        FuncState fs = this.fs;
        expdesc key = new expdesc();
        fs.exp2anyreg(v2);
        this.next();
        this.checkname(key);
        fs.indexed(v2, key);
    }

    void yindex(expdesc v2) {
        this.next();
        this.expr(v2);
        this.fs.exp2val(v2);
        this.checknext(93);
    }

    void recfield(ConsControl cc2) {
        FuncState fs = this.fs;
        int reg = this.fs.freereg;
        expdesc key = new expdesc();
        expdesc val = new expdesc();
        if (this.t.token == 285) {
            fs.checklimit(cc2.nh, 0x7FFFFFFD, "items in a constructor");
            this.checkname(key);
        } else {
            this.yindex(key);
        }
        ++cc2.nh;
        this.checknext(61);
        int rkkey = fs.exp2RK(key);
        this.expr(val);
        fs.codeABC(9, cc2.t.info, rkkey, fs.exp2RK(val));
        fs.freereg = reg;
    }

    void listfield(ConsControl cc2) {
        this.expr(cc2.v);
        this.fs.checklimit(cc2.na, 0x7FFFFFFD, "items in a constructor");
        ++cc2.na;
        ++cc2.tostore;
    }

    void constructor(expdesc t2) {
        FuncState fs = this.fs;
        int line = this.linenumber;
        int pc = fs.codeABC(10, 0, 0, 0);
        ConsControl cc2 = new ConsControl();
        cc2.tostore = 0;
        cc2.nh = 0;
        cc2.na = 0;
        cc2.t = t2;
        t2.init(11, pc);
        cc2.v.init(0, 0);
        fs.exp2nextreg(t2);
        this.checknext(123);
        do {
            FuncState._assert(cc2.v.k == 0 || cc2.tostore > 0);
            if (this.t.token == 125) break;
            fs.closelistfield(cc2);
            switch (this.t.token) {
                case 285: {
                    this.lookahead();
                    if (this.lookahead.token != 61) {
                        this.listfield(cc2);
                        break;
                    }
                    this.recfield(cc2);
                    break;
                }
                case 91: {
                    this.recfield(cc2);
                    break;
                }
                default: {
                    this.listfield(cc2);
                }
            }
        } while (this.testnext(44) || this.testnext(59));
        this.check_match(125, 123, line);
        fs.lastlistfield(cc2);
        InstructionPtr i2 = new InstructionPtr(fs.f.code, pc);
        FuncState.SETARG_B(i2, LexState.luaO_int2fb(cc2.na));
        FuncState.SETARG_C(i2, LexState.luaO_int2fb(cc2.nh));
    }

    static int luaO_int2fb(int x2) {
        int e2 = 0;
        while (x2 >= 16) {
            x2 = x2 + 1 >> 1;
            ++e2;
        }
        if (x2 < 8) {
            return x2;
        }
        return e2 + 1 << 3 | x2 - 8;
    }

    void parlist() {
        FuncState fs = this.fs;
        LuaPrototype f2 = fs.f;
        int nparams = 0;
        fs.isVararg = 0;
        if (this.t.token != 41) {
            do {
                switch (this.t.token) {
                    case 285: {
                        this.new_localvar(this.str_checkname(), nparams++);
                        break;
                    }
                    case 279: {
                        this.next();
                        fs.isVararg |= 2;
                        break;
                    }
                    default: {
                        this.syntaxerror("<name> or " + LexState.LUA_QL("...") + " expected");
                    }
                }
            } while (fs.isVararg == 0 && this.testnext(44));
        }
        this.adjustlocalvars(nparams);
        f2.numParams = fs.nactvar - (fs.isVararg & 1);
        fs.reserveregs(fs.nactvar);
    }

    void body(expdesc e2, boolean needself, int line) {
        FuncState new_fs = new FuncState();
        this.open_func(new_fs);
        new_fs.linedefined = line;
        this.checknext(40);
        if (needself) {
            this.new_localvarliteral("self", 0);
            this.adjustlocalvars(1);
        }
        this.parlist();
        this.checknext(41);
        this.chunk();
        new_fs.lastlinedefined = this.linenumber;
        this.check_match(262, 265, line);
        this.close_func();
        this.pushclosure(new_fs, e2);
    }

    int explist1(expdesc v2) {
        int n2 = 1;
        this.expr(v2);
        while (this.testnext(44)) {
            this.fs.exp2nextreg(v2);
            this.expr(v2);
            ++n2;
        }
        return n2;
    }

    void funcargs(expdesc f2) {
        int nparams;
        FuncState fs = this.fs;
        expdesc args = new expdesc();
        int line = this.linenumber;
        switch (this.t.token) {
            case 40: {
                if (line != this.lastline) {
                    this.syntaxerror("ambiguous syntax (function call x new statement)");
                }
                this.next();
                if (this.t.token == 41) {
                    args.k = 0;
                } else {
                    this.explist1(args);
                    fs.setmultret(args);
                }
                this.check_match(41, 40, line);
                break;
            }
            case 123: {
                this.constructor(args);
                break;
            }
            case 286: {
                this.codestring(args, this.t.ts);
                this.next();
                break;
            }
            default: {
                this.syntaxerror("function arguments expected");
                return;
            }
        }
        FuncState._assert(f2.k == 12);
        int base = f2.info;
        if (this.hasmultret(args.k)) {
            nparams = -1;
        } else {
            if (args.k != 0) {
                fs.exp2nextreg(args);
            }
            nparams = fs.freereg - (base + 1);
        }
        f2.init(13, fs.codeABC(28, base, nparams + 1, 2));
        fs.fixline(line);
        fs.freereg = base + 1;
    }

    void prefixexp(expdesc v2) {
        switch (this.t.token) {
            case 40: {
                int line = this.linenumber;
                this.next();
                this.expr(v2);
                this.check_match(41, 40, line);
                this.fs.dischargevars(v2);
                return;
            }
            case 285: {
                this.singlevar(v2);
                return;
            }
        }
        this.syntaxerror("unexpected symbol");
    }

    void primaryexp(expdesc v2) {
        FuncState fs = this.fs;
        this.prefixexp(v2);
        block6: while (true) {
            switch (this.t.token) {
                case 46: {
                    this.field(v2);
                    continue block6;
                }
                case 91: {
                    expdesc key = new expdesc();
                    fs.exp2anyreg(v2);
                    this.yindex(key);
                    fs.indexed(v2, key);
                    continue block6;
                }
                case 58: {
                    expdesc key = new expdesc();
                    this.next();
                    this.checkname(key);
                    fs.self(v2, key);
                    this.funcargs(v2);
                    continue block6;
                }
                case 40: 
                case 123: 
                case 286: {
                    fs.exp2nextreg(v2);
                    this.funcargs(v2);
                    continue block6;
                }
            }
            break;
        }
    }

    void simpleexp(expdesc v2) {
        switch (this.t.token) {
            case 284: {
                v2.init(5, 0);
                v2.setNval(this.t.r);
                break;
            }
            case 286: {
                this.codestring(v2, this.t.ts);
                break;
            }
            case 269: {
                v2.init(1, 0);
                break;
            }
            case 275: {
                v2.init(2, 0);
                break;
            }
            case 263: {
                v2.init(3, 0);
                break;
            }
            case 279: {
                FuncState fs = this.fs;
                this.check_condition(fs.isVararg != 0, "cannot use " + LexState.LUA_QL("...") + " outside a vararg function");
                fs.isVararg &= 0xFFFFFFFB;
                v2.init(14, fs.codeABC(37, 0, 1, 0));
                break;
            }
            case 123: {
                this.constructor(v2);
                return;
            }
            case 265: {
                this.next();
                this.body(v2, false, this.linenumber);
                return;
            }
            default: {
                this.primaryexp(v2);
                return;
            }
        }
        this.next();
    }

    int getunopr(int op) {
        switch (op) {
            case 270: {
                return 1;
            }
            case 45: {
                return 0;
            }
            case 35: {
                return 2;
            }
        }
        return 3;
    }

    int getbinopr(int op) {
        switch (op) {
            case 43: {
                return 0;
            }
            case 45: {
                return 1;
            }
            case 42: {
                return 2;
            }
            case 47: {
                return 3;
            }
            case 37: {
                return 4;
            }
            case 94: {
                return 5;
            }
            case 278: {
                return 6;
            }
            case 283: {
                return 7;
            }
            case 280: {
                return 8;
            }
            case 60: {
                return 9;
            }
            case 282: {
                return 10;
            }
            case 62: {
                return 11;
            }
            case 281: {
                return 12;
            }
            case 257: {
                return 13;
            }
            case 271: {
                return 14;
            }
        }
        return 15;
    }

    int subexpr(expdesc v2, int limit) {
        this.enterlevel();
        int uop = this.getunopr(this.t.token);
        if (uop != 3) {
            this.next();
            this.subexpr(v2, 8);
            this.fs.prefix(uop, v2);
        } else {
            this.simpleexp(v2);
        }
        int op = this.getbinopr(this.t.token);
        while (op != 15 && priorityLeft[op] > limit) {
            expdesc v22 = new expdesc();
            this.next();
            this.fs.infix(op, v2);
            int nextop = this.subexpr(v22, priorityRight[op]);
            this.fs.posfix(op, v2, v22);
            op = nextop;
        }
        this.leavelevel();
        return op;
    }

    void expr(expdesc v2) {
        this.subexpr(v2, 0);
    }

    boolean block_follow(int token) {
        switch (token) {
            case 260: 
            case 261: 
            case 262: 
            case 276: 
            case 287: {
                return true;
            }
        }
        return false;
    }

    void block() {
        FuncState fs = this.fs;
        FuncState.BlockCnt bl2 = new FuncState.BlockCnt();
        fs.enterblock(bl2, false);
        this.chunk();
        FuncState._assert(bl2.breaklist == -1);
        fs.leaveblock();
    }

    void check_conflict(LHS_assign lh, expdesc v2) {
        FuncState fs = this.fs;
        int extra = fs.freereg;
        boolean conflict = false;
        while (lh != null) {
            if (lh.v.k == 9) {
                if (lh.v.info == v2.info) {
                    conflict = true;
                    lh.v.info = extra;
                }
                if (lh.v.aux == v2.info) {
                    conflict = true;
                    lh.v.aux = extra;
                }
            }
            lh = lh.prev;
        }
        if (conflict) {
            fs.codeABC(0, fs.freereg, v2.info, 0);
            fs.reserveregs(1);
        }
    }

    void assignment(LHS_assign lh, int nvars) {
        expdesc e2 = new expdesc();
        this.check_condition(6 <= lh.v.k && lh.v.k <= 9, "syntax error");
        if (this.testnext(44)) {
            LHS_assign nv = new LHS_assign();
            nv.prev = lh;
            this.primaryexp(nv.v);
            if (nv.v.k == 6) {
                this.check_conflict(lh, nv.v);
            }
            this.assignment(nv, nvars + 1);
        } else {
            this.checknext(61);
            int nexps = this.explist1(e2);
            if (nexps != nvars) {
                this.adjust_assign(nvars, nexps, e2);
                if (nexps > nvars) {
                    this.fs.freereg -= nexps - nvars;
                }
            } else {
                this.fs.setoneret(e2);
                this.fs.storevar(lh.v, e2);
                return;
            }
        }
        e2.init(12, this.fs.freereg - 1);
        this.fs.storevar(lh.v, e2);
    }

    int cond() {
        expdesc v2 = new expdesc();
        this.expr(v2);
        if (v2.k == 1) {
            v2.k = 3;
        }
        this.fs.goiftrue(v2);
        return v2.f;
    }

    void breakstat() {
        FuncState fs = this.fs;
        FuncState.BlockCnt bl2 = fs.bl;
        boolean upval = false;
        while (bl2 != null && !bl2.isbreakable) {
            upval |= bl2.upval;
            bl2 = bl2.previous;
        }
        if (bl2 == null) {
            this.syntaxerror("no loop to break");
        }
        if (upval) {
            fs.codeABC(35, bl2.nactvar, 0, 0);
        }
        bl2.breaklist = fs.concat(bl2.breaklist, fs.jump());
    }

    void whilestat(int line) {
        FuncState fs = this.fs;
        FuncState.BlockCnt bl2 = new FuncState.BlockCnt();
        this.next();
        int whileinit = fs.getlabel();
        int condexit = this.cond();
        fs.enterblock(bl2, true);
        this.checknext(259);
        this.block();
        fs.patchlist(fs.jump(), whileinit);
        this.check_match(262, 277, line);
        fs.leaveblock();
        fs.patchtohere(condexit);
    }

    void repeatstat(int line) {
        FuncState fs = this.fs;
        int repeat_init = fs.getlabel();
        FuncState.BlockCnt bl1 = new FuncState.BlockCnt();
        FuncState.BlockCnt bl2 = new FuncState.BlockCnt();
        fs.enterblock(bl1, true);
        fs.enterblock(bl2, false);
        this.next();
        this.chunk();
        this.check_match(276, 272, line);
        int condexit = this.cond();
        if (!bl2.upval) {
            fs.leaveblock();
            fs.patchlist(condexit, repeat_init);
        } else {
            this.breakstat();
            fs.patchtohere(condexit);
            fs.leaveblock();
            fs.patchlist(fs.jump(), repeat_init);
        }
        fs.leaveblock();
    }

    int exp1() {
        expdesc e2 = new expdesc();
        this.expr(e2);
        int k2 = e2.k;
        this.fs.exp2nextreg(e2);
        return k2;
    }

    void forbody(int base, int line, int nvars, boolean isnum) {
        FuncState.BlockCnt bl2 = new FuncState.BlockCnt();
        FuncState fs = this.fs;
        this.adjustlocalvars(3);
        this.checknext(259);
        int prep = isnum ? fs.codeAsBx(32, base, -1) : fs.jump();
        fs.enterblock(bl2, false);
        this.adjustlocalvars(nvars);
        fs.reserveregs(nvars);
        this.block();
        fs.leaveblock();
        fs.patchtohere(prep);
        int endfor = isnum ? fs.codeAsBx(31, base, -1) : fs.codeABC(33, base, 0, nvars);
        fs.fixline(line);
        fs.patchlist(isnum ? endfor : fs.jump(), prep + 1);
    }

    void fornum(String varname, int line) {
        FuncState fs = this.fs;
        int base = fs.freereg;
        this.new_localvarliteral(RESERVED_LOCAL_VAR_FOR_INDEX, 0);
        this.new_localvarliteral(RESERVED_LOCAL_VAR_FOR_LIMIT, 1);
        this.new_localvarliteral(RESERVED_LOCAL_VAR_FOR_STEP, 2);
        this.new_localvar(varname, 3);
        this.checknext(61);
        this.exp1();
        this.checknext(44);
        this.exp1();
        if (this.testnext(44)) {
            this.exp1();
        } else {
            fs.codeABx(1, fs.freereg, fs.numberK(1));
            fs.reserveregs(1);
        }
        this.forbody(base, line, 1, true);
    }

    void forlist(String indexname) {
        FuncState fs = this.fs;
        expdesc e2 = new expdesc();
        int nvars = 0;
        int base = fs.freereg;
        this.new_localvarliteral(RESERVED_LOCAL_VAR_FOR_GENERATOR, nvars++);
        this.new_localvarliteral(RESERVED_LOCAL_VAR_FOR_STATE, nvars++);
        this.new_localvarliteral(RESERVED_LOCAL_VAR_FOR_CONTROL, nvars++);
        this.new_localvar(indexname, nvars++);
        while (this.testnext(44)) {
            this.new_localvar(this.str_checkname(), nvars++);
        }
        this.checknext(267);
        int line = this.linenumber;
        this.adjust_assign(3, this.explist1(e2), e2);
        fs.checkstack(3);
        this.forbody(base, line, nvars - 3, false);
    }

    void forstat(int line) {
        FuncState fs = this.fs;
        FuncState.BlockCnt bl2 = new FuncState.BlockCnt();
        fs.enterblock(bl2, true);
        this.next();
        String varname = this.str_checkname();
        switch (this.t.token) {
            case 61: {
                this.fornum(varname, line);
                break;
            }
            case 44: 
            case 267: {
                this.forlist(varname);
                break;
            }
            default: {
                this.syntaxerror(LexState.LUA_QL("=") + " or " + LexState.LUA_QL("in") + " expected");
            }
        }
        this.check_match(262, 264, line);
        fs.leaveblock();
    }

    int test_then_block() {
        this.next();
        int condexit = this.cond();
        this.checknext(274);
        this.block();
        return condexit;
    }

    void ifstat(int line) {
        FuncState fs = this.fs;
        int escapelist = -1;
        int flist = this.test_then_block();
        while (this.t.token == 261) {
            escapelist = fs.concat(escapelist, fs.jump());
            fs.patchtohere(flist);
            flist = this.test_then_block();
        }
        if (this.t.token == 260) {
            escapelist = fs.concat(escapelist, fs.jump());
            fs.patchtohere(flist);
            this.next();
            this.block();
        } else {
            escapelist = fs.concat(escapelist, flist);
        }
        fs.patchtohere(escapelist);
        this.check_match(262, 266, line);
    }

    void localfunc() {
        expdesc v2 = new expdesc();
        expdesc b2 = new expdesc();
        FuncState fs = this.fs;
        this.new_localvar(this.str_checkname(), 0);
        v2.init(6, fs.freereg);
        fs.reserveregs(1);
        this.adjustlocalvars(1);
        this.body(b2, false, this.linenumber);
        fs.storevar(v2, b2);
    }

    void localstat() {
        int nexps;
        int nvars = 0;
        expdesc e2 = new expdesc();
        do {
            this.new_localvar(this.str_checkname(), nvars++);
        } while (this.testnext(44));
        if (this.testnext(61)) {
            nexps = this.explist1(e2);
        } else {
            e2.k = 0;
            nexps = 0;
        }
        this.adjust_assign(nvars, nexps, e2);
        this.adjustlocalvars(nvars);
    }

    boolean funcname(expdesc v2) {
        boolean needself = false;
        this.singlevar(v2);
        while (this.t.token == 46) {
            this.field(v2);
        }
        if (this.t.token == 58) {
            needself = true;
            this.field(v2);
        }
        return needself;
    }

    void funcstat(int line) {
        expdesc v2 = new expdesc();
        expdesc b2 = new expdesc();
        this.next();
        boolean needself = this.funcname(v2);
        this.body(b2, needself, line);
        this.fs.storevar(v2, b2);
        this.fs.fixline(line);
    }

    void exprstat() {
        FuncState fs = this.fs;
        LHS_assign v2 = new LHS_assign();
        this.primaryexp(v2.v);
        if (v2.v.k == 13) {
            FuncState.SETARG_C(fs.getcodePtr(v2.v), 1);
        } else {
            v2.prev = null;
            this.assignment(v2, 1);
        }
    }

    void retstat() {
        int first;
        int nret;
        FuncState fs = this.fs;
        expdesc e2 = new expdesc();
        this.next();
        if (this.block_follow(this.t.token) || this.t.token == 59) {
            nret = 0;
            first = 0;
        } else {
            nret = this.explist1(e2);
            if (this.hasmultret(e2.k)) {
                fs.setmultret(e2);
                if (e2.k == 13 && nret == 1) {
                    FuncState.SET_OPCODE(fs.getcodePtr(e2), 29);
                    FuncState._assert(FuncState.GETARG_A(fs.getcode(e2)) == fs.nactvar);
                }
                first = fs.nactvar;
                nret = -1;
            } else if (nret == 1) {
                first = fs.exp2anyreg(e2);
            } else {
                fs.exp2nextreg(e2);
                first = fs.nactvar;
                FuncState._assert(nret == fs.freereg - first);
            }
        }
        fs.ret(first, nret);
    }

    boolean statement() {
        int line = this.linenumber;
        switch (this.t.token) {
            case 266: {
                this.ifstat(line);
                return false;
            }
            case 277: {
                this.whilestat(line);
                return false;
            }
            case 259: {
                this.next();
                this.block();
                this.check_match(262, 259, line);
                return false;
            }
            case 264: {
                this.forstat(line);
                return false;
            }
            case 272: {
                this.repeatstat(line);
                return false;
            }
            case 265: {
                this.funcstat(line);
                return false;
            }
            case 268: {
                this.next();
                if (this.testnext(265)) {
                    this.localfunc();
                } else {
                    this.localstat();
                }
                return false;
            }
            case 273: {
                this.retstat();
                return true;
            }
            case 258: {
                this.next();
                this.breakstat();
                return true;
            }
        }
        this.exprstat();
        return false;
    }

    void chunk() {
        boolean islast = false;
        this.enterlevel();
        while (!islast && !this.block_follow(this.t.token)) {
            islast = this.statement();
            this.testnext(59);
            FuncState._assert(this.fs.f.maxStacksize >= this.fs.freereg && this.fs.freereg >= this.fs.nactvar);
            this.fs.freereg = this.fs.nactvar;
        }
        this.leavelevel();
    }

    static {
        int i2;
        RESERVED_LOCAL_VAR_KEYWORDS = new String[]{RESERVED_LOCAL_VAR_FOR_CONTROL, RESERVED_LOCAL_VAR_FOR_GENERATOR, RESERVED_LOCAL_VAR_FOR_INDEX, RESERVED_LOCAL_VAR_FOR_LIMIT, RESERVED_LOCAL_VAR_FOR_STATE, RESERVED_LOCAL_VAR_FOR_STEP};
        RESERVED_LOCAL_VAR_KEYWORDS_TABLE = new Hashtable();
        for (i2 = 0; i2 < RESERVED_LOCAL_VAR_KEYWORDS.length; ++i2) {
            RESERVED_LOCAL_VAR_KEYWORDS_TABLE.put(RESERVED_LOCAL_VAR_KEYWORDS[i2], LuaPrototype.bTRUE);
        }
        luaX_tokens = new String[]{"and", "break", "do", "else", "elseif", "end", "false", "for", "function", "if", "in", "local", "nil", "not", "or", "repeat", "return", "then", "true", "until", "while", "..", "...", "==", ">=", "<=", "~=", "<number>", "<name>", "<string>", "<eof>"};
        RESERVED = new Hashtable();
        for (i2 = 0; i2 < 21; ++i2) {
            String ts = luaX_tokens[i2];
            RESERVED.put(ts, new Integer(257 + i2));
        }
        priorityLeft = new int[]{6, 6, 7, 7, 7, 10, 5, 3, 3, 3, 3, 3, 3, 2, 1};
        priorityRight = new int[]{6, 6, 7, 7, 7, 9, 4, 3, 3, 3, 3, 3, 3, 2, 1};
    }

    static class LHS_assign {
        LHS_assign prev;
        expdesc v = new expdesc();

        LHS_assign() {
        }
    }

    static class ConsControl {
        expdesc v = new expdesc();
        expdesc t;
        int nh;
        int na;
        int tostore;

        ConsControl() {
        }
    }

    static class expdesc {
        int k;
        int info;
        int aux;
        private int _nval;
        private boolean has_nval;
        int t;
        int f;

        expdesc() {
        }

        public void setNval(int r2) {
            this._nval = r2;
            this.has_nval = true;
        }

        public int nval() {
            return this.has_nval ? this._nval : this.info;
        }

        void init(int k2, int i2) {
            this.f = -1;
            this.t = -1;
            this.k = k2;
            this.info = i2;
        }

        boolean hasjumps() {
            return this.t != this.f;
        }

        boolean isnumeral() {
            return this.k == 5 && this.t == -1 && this.f == -1;
        }

        public void setvalue(expdesc other) {
            this.k = other.k;
            this._nval = other._nval;
            this.has_nval = other.has_nval;
            this.info = other.info;
            this.aux = other.aux;
            this.t = other.t;
            this.f = other.f;
        }
    }

    private static class Token {
        int token;
        int r;
        String ts;

        private Token() {
        }

        public void set(Token other) {
            this.token = other.token;
            this.r = other.r;
            this.ts = other.ts;
        }
    }
}

