/*
 * Decompiled with CFR 0.152.
 */
package se.krka.kahlua.vm;

import java.io.InputStream;
import java.io.PrintStream;
import java.util.Random;
import se.krka.kahlua.stdlib.BaseLib;
import se.krka.kahlua.stdlib.CoroutineLib;
import se.krka.kahlua.stdlib.TableLib;
import se.krka.kahlua.vm.JavaFunction;
import se.krka.kahlua.vm.LuaCallFrame;
import se.krka.kahlua.vm.LuaClosure;
import se.krka.kahlua.vm.LuaException;
import se.krka.kahlua.vm.LuaPrototype;
import se.krka.kahlua.vm.LuaTable;
import se.krka.kahlua.vm.LuaTableImpl;
import se.krka.kahlua.vm.LuaThread;
import se.krka.kahlua.vm.UpValue;

public class LuaState {
    public static final int FIELDS_PER_FLUSH = 50;
    public static final int OP_MOVE = 0;
    public static final int OP_LOADK = 1;
    public static final int OP_LOADBOOL = 2;
    public static final int OP_LOADNIL = 3;
    public static final int OP_GETUPVAL = 4;
    public static final int OP_GETGLOBAL = 5;
    public static final int OP_GETTABLE = 6;
    public static final int OP_SETGLOBAL = 7;
    public static final int OP_SETUPVAL = 8;
    public static final int OP_SETTABLE = 9;
    public static final int OP_NEWTABLE = 10;
    public static final int OP_SELF = 11;
    public static final int OP_ADD = 12;
    public static final int OP_SUB = 13;
    public static final int OP_MUL = 14;
    public static final int OP_DIV = 15;
    public static final int OP_MOD = 16;
    public static final int OP_POW = 17;
    public static final int OP_UNM = 18;
    public static final int OP_NOT = 19;
    public static final int OP_LEN = 20;
    public static final int OP_CONCAT = 21;
    public static final int OP_JMP = 22;
    public static final int OP_EQ = 23;
    public static final int OP_LT = 24;
    public static final int OP_LE = 25;
    public static final int OP_TEST = 26;
    public static final int OP_TESTSET = 27;
    public static final int OP_CALL = 28;
    public static final int OP_TAILCALL = 29;
    public static final int OP_RETURN = 30;
    public static final int OP_FORLOOP = 31;
    public static final int OP_FORPREP = 32;
    public static final int OP_TFORLOOP = 33;
    public static final int OP_SETLIST = 34;
    public static final int OP_CLOSE = 35;
    public static final int OP_CLOSURE = 36;
    public static final int OP_VARARG = 37;
    public LuaThread currentThread;
    public Random random = new Random();
    public LuaTable userdataMetatables;
    public PrintStream out;
    static final int MAX_INDEX_RECURSION = 100;
    private static final String[] meta_ops = new String[38];
    private static boolean bWait;
    private static boolean bNoRun;

    public LuaState(PrintStream stream) {
        this(stream, true);
    }

    public LuaState() {
        this(System.out, true);
    }

    protected LuaState(PrintStream stream, boolean callReset) {
        this.out = stream;
        if (callReset) {
            this.reset();
        }
    }

    protected final void reset() {
        this.currentThread = new LuaThread(this, new LuaTableImpl());
        this.userdataMetatables = new LuaTableImpl();
        this.getEnvironment().rawset("_G", (Object)this.getEnvironment());
        this.getEnvironment().rawset("_VERSION", (Object)"Lua 5.1 for CLDC 1.1");
        BaseLib.register(this);
        CoroutineLib.register(this);
        TableLib.register(this);
    }

    public int call(int nArguments) {
        int top = this.currentThread.getTop();
        int base = top - nArguments - 1;
        Object o2 = this.currentThread.objectStack[base];
        if (o2 == null) {
            throw new RuntimeException("tried to call nil");
        }
        if (o2 instanceof JavaFunction) {
            return this.callJava((JavaFunction)o2, base + 1, base, nArguments);
        }
        if (!(o2 instanceof LuaClosure)) {
            throw new RuntimeException("tried to call a non-function");
        }
        LuaCallFrame callFrame = this.currentThread.pushNewCallFrame((LuaClosure)o2, base + 1, base, nArguments, false, false);
        callFrame.init();
        this.luaMainloop();
        int nReturnValues = this.currentThread.getTop() - base;
        this.currentThread.stackTrace = "";
        return nReturnValues;
    }

    private boolean checkWait() {
        return LuaState.getbWait() || LuaState.getbNoRun();
    }

    public static synchronized boolean getbWait() {
        return bWait;
    }

    public static synchronized boolean getbNoRun() {
        return bNoRun;
    }

    public static synchronized void setbWait(boolean b2) {
        bWait = b2;
    }

    public static synchronized void setbNoRun(boolean b2) {
        bNoRun = b2;
    }

    private synchronized int callJava(JavaFunction f2, int localBase, int returnBase, int nArguments) {
        LuaThread thread = this.currentThread;
        LuaCallFrame callFrame = thread.pushNewCallFrame(null, localBase, returnBase, nArguments, false, false);
        int nReturnValues = f2.call(callFrame, nArguments);
        while (this.checkWait()) {
            try {
                this.wait(50L);
            }
            catch (Exception e2) {}
        }
        int top = callFrame.getTop();
        int actualReturnBase = top - nReturnValues;
        callFrame.stackCopy(actualReturnBase, -1, nReturnValues);
        callFrame.setTop(nReturnValues - 1);
        thread.popCallFrame();
        return nReturnValues;
    }

    private final Object prepareMetatableCall(Object o2) {
        if (o2 instanceof JavaFunction || o2 instanceof LuaClosure) {
            return o2;
        }
        Object f2 = this.getMetaOp(o2, "__call");
        return f2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void luaMainloop() {
        LuaCallFrame callFrame = this.currentThread.currentCallFrame();
        LuaClosure closure = callFrame.closure;
        LuaPrototype prototype = closure.prototype;
        int[] opcodes = prototype.code;
        int returnBase = callFrame.returnBase;
        block39: while (true) {
            try {
                while (true) {
                    int op = opcodes[callFrame.pc++];
                    int opcode = op & 0x3F;
                    switch (opcode) {
                        case 0: {
                            int a2 = LuaState.getA8(op);
                            int b2 = LuaState.getB9(op);
                            callFrame.set(a2, callFrame.get(b2));
                            break;
                        }
                        case 1: {
                            int a2 = LuaState.getA8(op);
                            int b2 = LuaState.getBx(op);
                            callFrame.set(a2, prototype.constants[b2]);
                            break;
                        }
                        case 2: {
                            int a2 = LuaState.getA8(op);
                            int b2 = LuaState.getB9(op);
                            int c2 = LuaState.getC9(op);
                            Boolean bool = b2 == 0 ? LuaPrototype.bFALSE : LuaPrototype.bTRUE;
                            callFrame.set(a2, bool);
                            if (c2 == 0) break;
                            ++callFrame.pc;
                            break;
                        }
                        case 3: {
                            int a2 = LuaState.getA8(op);
                            int b2 = LuaState.getB9(op);
                            callFrame.stackClear(a2, b2);
                            break;
                        }
                        case 4: {
                            int a2 = LuaState.getA8(op);
                            int b2 = LuaState.getB9(op);
                            UpValue uv = closure.upvalues[b2];
                            callFrame.set(a2, uv.getValue());
                            break;
                        }
                        case 5: {
                            int a2 = LuaState.getA8(op);
                            int b2 = LuaState.getBx(op);
                            Object res = this.tableGet(closure.env, prototype.constants[b2]);
                            callFrame.set(a2, res);
                            break;
                        }
                        case 6: {
                            int a2 = LuaState.getA8(op);
                            int b2 = LuaState.getB9(op);
                            int c2 = LuaState.getC9(op);
                            Object bObj = callFrame.get(b2);
                            Object key = this.getRegisterOrConstant(callFrame, c2, prototype);
                            Object res = this.tableGet(bObj, key);
                            callFrame.set(a2, res);
                            break;
                        }
                        case 7: {
                            int a2 = LuaState.getA8(op);
                            int b2 = LuaState.getBx(op);
                            Object value = callFrame.get(a2);
                            Object key = prototype.constants[b2];
                            this.tableSet(closure.env, key, value);
                            break;
                        }
                        case 8: {
                            int a2 = LuaState.getA8(op);
                            int b2 = LuaState.getB9(op);
                            UpValue uv = closure.upvalues[b2];
                            uv.setValue(callFrame.get(a2));
                            break;
                        }
                        case 9: {
                            int a2 = LuaState.getA8(op);
                            int b2 = LuaState.getB9(op);
                            int c2 = LuaState.getC9(op);
                            Object aObj = callFrame.get(a2);
                            Object key = this.getRegisterOrConstant(callFrame, b2, prototype);
                            Object value = this.getRegisterOrConstant(callFrame, c2, prototype);
                            this.tableSet(aObj, key, value);
                            break;
                        }
                        case 10: {
                            int a2 = LuaState.getA8(op);
                            LuaTableImpl t2 = new LuaTableImpl();
                            callFrame.set(a2, t2);
                            break;
                        }
                        case 11: {
                            int a2 = LuaState.getA8(op);
                            int b2 = LuaState.getB9(op);
                            int c2 = LuaState.getC9(op);
                            Object key = this.getRegisterOrConstant(callFrame, c2, prototype);
                            Object bObj = callFrame.get(b2);
                            Object fun = this.tableGet(bObj, key);
                            callFrame.set(a2, fun);
                            callFrame.set(a2 + 1, bObj);
                            break;
                        }
                        case 12: 
                        case 13: 
                        case 14: 
                        case 15: 
                        case 16: 
                        case 17: {
                            int a2 = LuaState.getA8(op);
                            int b2 = LuaState.getB9(op);
                            int c2 = LuaState.getC9(op);
                            Object bo2 = this.getRegisterOrConstant(callFrame, b2, prototype);
                            Object co = this.getRegisterOrConstant(callFrame, c2, prototype);
                            Integer bd2 = null;
                            Integer cd2 = null;
                            Object res = null;
                            bd2 = BaseLib.rawTonumber(bo2);
                            if (bd2 == null || (cd2 = BaseLib.rawTonumber(co)) == null) {
                                String meta_op = meta_ops[opcode];
                                Object metafun = this.getBinMetaOp(bo2, co, meta_op);
                                if (metafun == null) {
                                    BaseLib.fail(meta_op + " not defined for operands");
                                }
                                res = this.call(metafun, bo2, co, null);
                            } else {
                                res = this.primitiveMath(bd2, cd2, opcode);
                            }
                            callFrame.set(a2, res);
                            break;
                        }
                        case 18: {
                            Object res;
                            int a2 = LuaState.getA8(op);
                            int b2 = LuaState.getB9(op);
                            Object aObj = callFrame.get(b2);
                            Integer aInteger = BaseLib.rawTonumber(aObj);
                            if (aInteger != null) {
                                res = LuaState.toInt(-LuaState.fromInt(aInteger));
                            } else {
                                Object metafun = this.getMetaOp(aObj, "__unm");
                                res = this.call(metafun, aObj, null, null);
                            }
                            callFrame.set(a2, res);
                            break;
                        }
                        case 19: {
                            int a2 = LuaState.getA8(op);
                            int b2 = LuaState.getB9(op);
                            Object aObj = callFrame.get(b2);
                            callFrame.set(a2, LuaState.toBoolean(!LuaState.boolEval(aObj)));
                            break;
                        }
                        case 20: {
                            Object res;
                            int a2 = LuaState.getA8(op);
                            int b2 = LuaState.getB9(op);
                            Object o2 = callFrame.get(b2);
                            if (o2 instanceof LuaTable) {
                                LuaTable t3 = (LuaTable)o2;
                                res = LuaState.toInt(t3.len());
                            } else if (o2 instanceof String) {
                                String s2 = (String)o2;
                                res = LuaState.toInt(s2.length());
                            } else {
                                Object f2 = this.getMetaOp(o2, "__len");
                                BaseLib.luaAssert(f2 != null, "__len not defined for operand");
                                res = this.call(f2, o2, null, null);
                            }
                            callFrame.set(a2, res);
                            break;
                        }
                        case 21: {
                            int a2 = LuaState.getA8(op);
                            int b2 = LuaState.getB9(op);
                            int c2 = LuaState.getC9(op);
                            int first = b2;
                            int last = c2;
                            Object res = callFrame.get(last);
                            --last;
                            while (first <= last) {
                                String resStr = BaseLib.rawTostring(res);
                                if (res != null) {
                                    int nStrings = 0;
                                    int pos = last;
                                    while (first <= pos) {
                                        Object o3 = callFrame.get(pos);
                                        --pos;
                                        if (BaseLib.rawTostring(o3) == null) break;
                                        ++nStrings;
                                    }
                                    if (nStrings > 0) {
                                        StringBuffer concatBuffer = new StringBuffer();
                                        for (int firstString = last - nStrings + 1; firstString <= last; ++firstString) {
                                            concatBuffer.append(BaseLib.rawTostring(callFrame.get(firstString)));
                                        }
                                        concatBuffer.append(resStr);
                                        res = concatBuffer.toString();
                                        last -= nStrings;
                                    }
                                }
                                if (first > last) continue;
                                Object leftConcat = callFrame.get(last);
                                Object metafun = this.getBinMetaOp(leftConcat, res, "__concat");
                                if (metafun == null) {
                                    BaseLib.fail("__concat not defined for operands: " + leftConcat + " and " + res);
                                }
                                res = this.call(metafun, leftConcat, res, null);
                                --last;
                            }
                            callFrame.set(a2, res);
                            break;
                        }
                        case 22: {
                            callFrame.pc += LuaState.getSBx(op);
                            break;
                        }
                        case 23: 
                        case 24: 
                        case 25: {
                            boolean resBool;
                            int a2 = LuaState.getA8(op);
                            int b2 = LuaState.getB9(op);
                            int c2 = LuaState.getC9(op);
                            Object bo3 = this.getRegisterOrConstant(callFrame, b2, prototype);
                            Object co = this.getRegisterOrConstant(callFrame, c2, prototype);
                            if (bo3 instanceof Integer && co instanceof Integer) {
                                int bd_primitive = LuaState.fromInt(bo3);
                                int cd_primitive = LuaState.fromInt(co);
                                if (opcode == 23) {
                                    if (bd_primitive == cd_primitive != (a2 == 0)) continue block39;
                                    ++callFrame.pc;
                                    break;
                                }
                                if (opcode == 24) {
                                    if (bd_primitive < cd_primitive != (a2 == 0)) continue block39;
                                    ++callFrame.pc;
                                    break;
                                }
                                if (bd_primitive <= cd_primitive != (a2 == 0)) continue block39;
                                ++callFrame.pc;
                                break;
                            }
                            if (bo3 instanceof String && co instanceof String) {
                                if (opcode == 23) {
                                    if (bo3.equals(co) != (a2 == 0)) break;
                                    ++callFrame.pc;
                                    break;
                                }
                                String bs2 = (String)bo3;
                                String cs = (String)co;
                                int cmp = bs2.compareTo(cs);
                                if (opcode == 24) {
                                    if (cmp < 0 != (a2 == 0)) continue block39;
                                    ++callFrame.pc;
                                    break;
                                }
                                if (cmp <= 0 != (a2 == 0)) continue block39;
                                ++callFrame.pc;
                                break;
                            }
                            if (bo3 == co) {
                                resBool = true;
                            } else {
                                boolean invert = false;
                                String meta_op = meta_ops[opcode];
                                Object metafun = this.getCompMetaOp(bo3, co, meta_op);
                                if (metafun == null && opcode == 25) {
                                    metafun = this.getCompMetaOp(bo3, co, "__lt");
                                    Object tmp = bo3;
                                    bo3 = co;
                                    co = tmp;
                                    invert = true;
                                }
                                if (metafun == null && opcode == 23) {
                                    resBool = LuaState.luaEquals(bo3, co);
                                } else {
                                    if (metafun == null) {
                                        BaseLib.fail(meta_op + " not defined for operand");
                                    }
                                    Object res = this.call(metafun, bo3, co, null);
                                    resBool = LuaState.boolEval(res);
                                }
                                if (invert) {
                                    resBool = !resBool;
                                }
                            }
                            if (resBool != (a2 == 0)) continue block39;
                            ++callFrame.pc;
                            break;
                        }
                        case 26: {
                            int a2 = LuaState.getA8(op);
                            int c2 = LuaState.getC9(op);
                            Object value = callFrame.get(a2);
                            if (LuaState.boolEval(value) != (c2 == 0)) break;
                            ++callFrame.pc;
                            break;
                        }
                        case 27: {
                            int a2 = LuaState.getA8(op);
                            int b2 = LuaState.getB9(op);
                            int c2 = LuaState.getC9(op);
                            Object value = callFrame.get(b2);
                            if (LuaState.boolEval(value) != (c2 == 0)) {
                                callFrame.set(a2, value);
                                break;
                            }
                            ++callFrame.pc;
                            break;
                        }
                        case 28: {
                            int a2 = LuaState.getA8(op);
                            int b2 = LuaState.getB9(op);
                            int c2 = LuaState.getC9(op);
                            int nArguments2 = b2 - 1;
                            if (nArguments2 != -1) {
                                callFrame.setTop(a2 + nArguments2 + 1);
                            } else {
                                nArguments2 = callFrame.getTop() - a2 - 1;
                            }
                            callFrame.restoreTop = c2 != 0;
                            int base = callFrame.localBase;
                            int localBase2 = base + a2 + 1;
                            int returnBase2 = base + a2;
                            Object funObject = callFrame.get(a2);
                            BaseLib.luaAssert(funObject != null, "Tried to call nil");
                            Object fun = this.prepareMetatableCall(funObject);
                            if (fun == null) {
                                BaseLib.fail("Object " + funObject + " did not have __call metatable set");
                            }
                            if (fun != funObject) {
                                localBase2 = returnBase2;
                                ++nArguments2;
                            }
                            if (fun instanceof LuaClosure) {
                                LuaCallFrame newCallFrame = this.currentThread.pushNewCallFrame((LuaClosure)fun, localBase2, returnBase2, nArguments2, true, callFrame.insideCoroutine);
                                newCallFrame.init();
                                callFrame = newCallFrame;
                                closure = newCallFrame.closure;
                                prototype = closure.prototype;
                                opcodes = prototype.code;
                                returnBase = callFrame.returnBase;
                                break;
                            }
                            if (!(fun instanceof JavaFunction)) throw new RuntimeException("Tried to call a non-function: " + fun);
                            this.callJava((JavaFunction)fun, base + a2 + 1, base + a2, nArguments2);
                            callFrame = this.currentThread.currentCallFrame();
                            if (callFrame.isJava()) {
                                return;
                            }
                            closure = callFrame.closure;
                            prototype = closure.prototype;
                            opcodes = prototype.code;
                            returnBase = callFrame.returnBase;
                            if (!callFrame.restoreTop) break;
                            callFrame.setTop(prototype.maxStacksize);
                            break;
                        }
                        case 29: {
                            int base = callFrame.localBase;
                            this.currentThread.closeUpvalues(base);
                            int a2 = LuaState.getA8(op);
                            int b2 = LuaState.getB9(op);
                            int nArguments2 = b2 - 1;
                            if (nArguments2 == -1) {
                                nArguments2 = callFrame.getTop() - a2 - 1;
                            }
                            callFrame.restoreTop = false;
                            Object funObject = callFrame.get(a2);
                            BaseLib.luaAssert(funObject != null, "Tried to call nil");
                            Object fun = this.prepareMetatableCall(funObject);
                            if (fun == null) {
                                BaseLib.fail("Object " + funObject + " did not have __call metatable set");
                            }
                            int localBase2 = returnBase + 1;
                            if (fun != funObject) {
                                localBase2 = returnBase;
                                ++nArguments2;
                            }
                            this.currentThread.stackCopy(base + a2, returnBase, nArguments2 + 1);
                            this.currentThread.setTop(returnBase + nArguments2 + 1);
                            if (fun instanceof LuaClosure) {
                                callFrame.localBase = localBase2;
                                callFrame.nArguments = nArguments2;
                                callFrame.closure = (LuaClosure)fun;
                                callFrame.init();
                            } else {
                                if (!(fun instanceof JavaFunction)) {
                                    BaseLib.fail("Tried to call a non-function: " + fun);
                                }
                                LuaThread oldThread = this.currentThread;
                                this.callJava((JavaFunction)fun, localBase2, returnBase, nArguments2);
                                callFrame = this.currentThread.currentCallFrame();
                                oldThread.popCallFrame();
                                if (oldThread != this.currentThread) {
                                    if (oldThread.isDead() && this.currentThread.parent == oldThread) {
                                        this.currentThread.parent = oldThread.parent;
                                        oldThread.parent = null;
                                        this.currentThread.parent.currentCallFrame().push(LuaPrototype.bTRUE);
                                    }
                                    if ((callFrame = this.currentThread.currentCallFrame()).isJava()) {
                                        return;
                                    }
                                } else {
                                    if (!callFrame.fromLua) {
                                        return;
                                    }
                                    callFrame = this.currentThread.currentCallFrame();
                                    if (callFrame.restoreTop) {
                                        callFrame.setTop(callFrame.closure.prototype.maxStacksize);
                                    }
                                }
                            }
                            closure = callFrame.closure;
                            prototype = closure.prototype;
                            opcodes = prototype.code;
                            returnBase = callFrame.returnBase;
                            break;
                        }
                        case 30: {
                            int a2 = LuaState.getA8(op);
                            int b2 = LuaState.getB9(op) - 1;
                            int base = callFrame.localBase;
                            this.currentThread.closeUpvalues(base);
                            if (b2 == -1) {
                                b2 = callFrame.getTop() - a2;
                            }
                            this.currentThread.stackCopy(callFrame.localBase + a2, returnBase, b2);
                            this.currentThread.setTop(returnBase + b2);
                            if (callFrame.fromLua) {
                                if (callFrame.insideCoroutine && this.currentThread.callFrameTop == 1) {
                                    callFrame.localBase = callFrame.returnBase;
                                    LuaThread thread = this.currentThread;
                                    CoroutineLib.yieldHelper(callFrame, callFrame, b2);
                                    thread.popCallFrame();
                                    callFrame = this.currentThread.currentCallFrame();
                                    if (callFrame.isJava()) {
                                        return;
                                    }
                                } else {
                                    this.currentThread.popCallFrame();
                                }
                                callFrame = this.currentThread.currentCallFrame();
                                closure = callFrame.closure;
                                prototype = closure.prototype;
                                opcodes = prototype.code;
                                returnBase = callFrame.returnBase;
                                if (!callFrame.restoreTop) break;
                                callFrame.setTop(prototype.maxStacksize);
                                break;
                            }
                            this.currentThread.popCallFrame();
                            return;
                        }
                        case 32: {
                            int a2 = LuaState.getA8(op);
                            int b2 = LuaState.getSBx(op);
                            int iter = LuaState.fromInt(callFrame.get(a2));
                            int step = LuaState.fromInt(callFrame.get(a2 + 2));
                            callFrame.set(a2, LuaState.toInt(iter - step));
                            callFrame.pc += b2;
                            break;
                        }
                        case 31: {
                            int b2;
                            int a2 = LuaState.getA8(op);
                            int iter = LuaState.fromInt(callFrame.get(a2));
                            int end = LuaState.fromInt(callFrame.get(a2 + 1));
                            int step = LuaState.fromInt(callFrame.get(a2 + 2));
                            Integer iterInteger = LuaState.toInt(iter += step);
                            callFrame.set(a2, iterInteger);
                            if (step > 0 ? iter <= end : iter >= end) {
                                b2 = LuaState.getSBx(op);
                                callFrame.pc += b2;
                                callFrame.set(a2 + 3, iterInteger);
                                break;
                            }
                            callFrame.clearFromIndex(a2);
                            break;
                        }
                        case 33: {
                            int a2 = LuaState.getA8(op);
                            int c2 = LuaState.getC9(op);
                            callFrame.setTop(a2 + 6);
                            callFrame.stackCopy(a2, a2 + 3, 3);
                            this.call(2);
                            callFrame.clearFromIndex(a2 + 3 + c2);
                            callFrame.setPrototypeStacksize();
                            Object aObj3 = callFrame.get(a2 + 3);
                            if (aObj3 != null) {
                                callFrame.set(a2 + 2, aObj3);
                                break;
                            }
                            ++callFrame.pc;
                            break;
                        }
                        case 34: {
                            int a2 = LuaState.getA8(op);
                            int b2 = LuaState.getB9(op);
                            int c2 = LuaState.getC9(op);
                            if (b2 == 0) {
                                b2 = callFrame.getTop() - a2 - 1;
                            }
                            if (c2 == 0) {
                                c2 = opcodes[callFrame.pc++];
                            }
                            int offset = (c2 - 1) * 50;
                            LuaTable t4 = (LuaTable)callFrame.get(a2);
                            int i2 = 1;
                            while (true) {
                                if (i2 > b2) continue block39;
                                Integer key = LuaState.toInt(offset + i2);
                                Object value = callFrame.get(a2 + i2);
                                t4.rawset(key, value);
                                ++i2;
                            }
                        }
                        case 35: {
                            int a2 = LuaState.getA8(op);
                            callFrame.closeUpvalues(a2);
                            break;
                        }
                        case 36: {
                            int a2 = LuaState.getA8(op);
                            int b2 = LuaState.getBx(op);
                            LuaPrototype newPrototype = prototype.prototypes[b2];
                            LuaClosure newClosure = new LuaClosure(newPrototype, closure.env);
                            callFrame.set(a2, newClosure);
                            int numUpvalues = newPrototype.numUpvalues;
                            int i3 = 0;
                            while (true) {
                                if (i3 >= numUpvalues) continue block39;
                                op = opcodes[callFrame.pc++];
                                opcode = op & 0x3F;
                                b2 = LuaState.getB9(op);
                                switch (opcode) {
                                    case 0: {
                                        newClosure.upvalues[i3] = callFrame.findUpvalue(b2);
                                        break;
                                    }
                                    case 4: {
                                        newClosure.upvalues[i3] = closure.upvalues[b2];
                                        break;
                                    }
                                }
                                ++i3;
                            }
                        }
                        case 37: {
                            int a2 = LuaState.getA8(op);
                            int b2 = LuaState.getB9(op) - 1;
                            callFrame.pushVarargs(a2, b2);
                            break;
                        }
                    }
                }
            }
            catch (RuntimeException e2) {
                while (!(callFrame = this.currentThread.currentCallFrame()).isLua()) {
                    this.currentThread.addStackTrace(callFrame);
                    this.currentThread.popCallFrame();
                }
                boolean rethrow = true;
                do {
                    if ((callFrame = this.currentThread.currentCallFrame()) == null) {
                        LuaThread parent = this.currentThread.parent;
                        if (parent == null) break;
                        this.currentThread.parent = null;
                        LuaCallFrame nextCallFrame = parent.currentCallFrame();
                        nextCallFrame.push(LuaPrototype.bFALSE);
                        nextCallFrame.push(e2.getMessage());
                        nextCallFrame.push(this.currentThread.stackTrace);
                        this.currentThread.state.currentThread = parent;
                        this.currentThread = parent;
                        callFrame = this.currentThread.currentCallFrame();
                        closure = callFrame.closure;
                        prototype = closure.prototype;
                        opcodes = prototype.code;
                        returnBase = callFrame.returnBase;
                        rethrow = false;
                        break;
                    }
                    this.currentThread.addStackTrace(callFrame);
                    this.currentThread.popCallFrame();
                } while (callFrame.fromLua);
                if (callFrame != null) {
                    callFrame.closeUpvalues(0);
                }
                if (rethrow) throw e2;
                continue;
            }
            break;
        }
    }

    public Object getMetaOp(Object o2, String meta_op) {
        LuaTable meta = (LuaTable)this.getmetatable(o2, true);
        if (meta == null) {
            return null;
        }
        return meta.rawget(meta_op);
    }

    private final Object getCompMetaOp(Object a2, Object b2, String meta_op) {
        LuaTable meta2;
        LuaTable meta1 = (LuaTable)this.getmetatable(a2, true);
        if (meta1 != (meta2 = (LuaTable)this.getmetatable(b2, true)) || meta1 == null) {
            return null;
        }
        return meta1.rawget(meta_op);
    }

    private final Object getBinMetaOp(Object a2, Object b2, String meta_op) {
        Object op = this.getMetaOp(a2, meta_op);
        if (op != null) {
            return op;
        }
        return this.getMetaOp(b2, meta_op);
    }

    public void setUserdataMetatable(Class type, LuaTable metatable) {
        this.userdataMetatables.rawset(type, (Object)metatable);
    }

    private final Object getRegisterOrConstant(LuaCallFrame callFrame, int index, LuaPrototype prototype) {
        int cindex = index - 256;
        if (cindex < 0) {
            return callFrame.get(index);
        }
        return prototype.constants[cindex];
    }

    private static final int getA8(int op) {
        return op >>> 6 & 0xFF;
    }

    private static final int getC9(int op) {
        return op >>> 14 & 0x1FF;
    }

    private static final int getB9(int op) {
        return op >>> 23 & 0x1FF;
    }

    private static final int getBx(int op) {
        return op >>> 14;
    }

    private static final int getSBx(int op) {
        return (op >>> 14) - 131071;
    }

    private Integer primitiveMath(Integer x2, Integer y2, int opcode) {
        int v1 = LuaState.fromInt(x2);
        int v2 = LuaState.fromInt(y2);
        int res = 0;
        switch (opcode) {
            case 12: {
                res = v1 + v2;
                break;
            }
            case 13: {
                res = v1 - v2;
                break;
            }
            case 14: {
                res = v1 * v2;
                break;
            }
            case 15: {
                res = v1 / v2;
                break;
            }
            case 16: {
                if (v2 == 0) break;
                int ipart = v1 / v2;
                res = v1 - ipart * v2;
                break;
            }
        }
        return LuaState.toInt(res);
    }

    public Object call(Object fun, Object arg1, Object arg2, Object arg3) {
        int oldTop = this.currentThread.getTop();
        int argslen = 3;
        this.currentThread.setTop(oldTop + 1 + 3);
        this.currentThread.objectStack[oldTop] = fun;
        this.currentThread.objectStack[oldTop + 1] = arg1;
        this.currentThread.objectStack[oldTop + 2] = arg2;
        this.currentThread.objectStack[oldTop + 3] = arg3;
        int nReturnValues = this.call(3);
        Object ret = null;
        if (nReturnValues >= 1) {
            ret = this.currentThread.objectStack[oldTop];
        }
        this.currentThread.setTop(oldTop);
        return ret;
    }

    public Object call(Object fun, Object[] args) {
        int oldTop = this.currentThread.getTop();
        int argslen = args == null ? 0 : args.length;
        this.currentThread.setTop(oldTop + 1 + argslen);
        this.currentThread.objectStack[oldTop] = fun;
        for (int i2 = 1; i2 <= argslen; ++i2) {
            this.currentThread.objectStack[oldTop + i2] = args[i2 - 1];
        }
        int nReturnValues = this.call(argslen);
        Object ret = null;
        if (nReturnValues >= 1) {
            ret = this.currentThread.objectStack[oldTop];
        }
        this.currentThread.setTop(oldTop);
        return ret;
    }

    public Object tableGet(Object table, Object key) {
        Object curObj = table;
        for (int i2 = 100; i2 > 0; --i2) {
            LuaTable t2;
            Object res;
            boolean isTable = curObj instanceof LuaTable;
            if (isTable && (res = (t2 = (LuaTable)curObj).rawget(key)) != null) {
                return res;
            }
            Object metaOp = this.getMetaOp(curObj, "__index");
            if (metaOp == null) {
                if (isTable) {
                    return null;
                }
                throw new RuntimeException("attempted index of non-table: " + curObj);
            }
            if (metaOp instanceof JavaFunction || metaOp instanceof LuaClosure) {
                res = this.call(metaOp, table, key, null);
                return res;
            }
            curObj = metaOp;
        }
        throw new RuntimeException("loop in gettable");
    }

    public void tableSet(Object table, Object key, Object value) {
        Object curObj = table;
        for (int i2 = 100; i2 > 0; --i2) {
            Object metaOp;
            if (curObj instanceof LuaTable) {
                LuaTable t2 = (LuaTable)curObj;
                if (t2.rawget(key) != null) {
                    t2.rawset(key, value);
                    return;
                }
                metaOp = this.getMetaOp(curObj, "__newindex");
                if (metaOp == null) {
                    t2.rawset(key, value);
                    return;
                }
            } else {
                metaOp = this.getMetaOp(curObj, "__newindex");
                BaseLib.luaAssert(metaOp != null, "attempted index of non-table");
            }
            if (metaOp instanceof JavaFunction || metaOp instanceof LuaClosure) {
                this.call(metaOp, table, key, value);
                return;
            }
            curObj = metaOp;
        }
        throw new RuntimeException("loop in settable");
    }

    public Object getmetatable(Object o2, boolean raw) {
        Object meta2;
        LuaTable metatable;
        if (o2 == null) {
            return null;
        }
        if (o2 instanceof LuaTable) {
            LuaTable t2 = (LuaTable)o2;
            metatable = t2.getMetatable();
        } else {
            metatable = (LuaTable)this.userdataMetatables.rawget(o2.getClass());
        }
        if (!raw && metatable != null && (meta2 = metatable.rawget("__metatable")) != null) {
            return meta2;
        }
        return metatable;
    }

    public Object[] pcall(Object fun, Object[] args) {
        int nArgs = args == null ? 0 : args.length;
        LuaThread thread = this.currentThread;
        int oldTop = thread.getTop();
        thread.setTop(oldTop + 1 + nArgs);
        thread.objectStack[oldTop] = fun;
        if (nArgs > 0) {
            System.arraycopy(args, 0, thread.objectStack, oldTop + 1, nArgs);
        }
        int nRet = this.pcall(nArgs);
        BaseLib.luaAssert(thread == this.currentThread, "Internal Kahlua error - thread changed in pcall");
        Object[] ret = new Object[nRet];
        System.arraycopy(thread.objectStack, oldTop, ret, 0, nRet);
        thread.setTop(oldTop);
        return ret;
    }

    public Object[] pcall(Object fun) {
        return this.pcall(fun, null);
    }

    public int pcall(int nArguments) {
        Object errorMessage;
        Throwable exception;
        LuaThread thread = this.currentThread;
        LuaCallFrame currentCallFrame = thread.currentCallFrame();
        thread.stackTrace = "";
        int oldBase = thread.getTop() - nArguments - 1;
        try {
            int nValues = this.call(nArguments);
            int newTop = oldBase + nValues + 1;
            thread.setTop(newTop);
            thread.stackCopy(oldBase, oldBase + 1, nValues);
            thread.objectStack[oldBase] = LuaPrototype.bTRUE;
            return 1 + nValues;
        }
        catch (LuaException e2) {
            exception = e2;
            errorMessage = e2.errorMessage;
        }
        catch (Throwable e3) {
            exception = e3;
            errorMessage = e3.getMessage();
        }
        BaseLib.luaAssert(thread == this.currentThread, "Internal Kahlua error - thread changed in pcall");
        if (currentCallFrame != null) {
            currentCallFrame.closeUpvalues(0);
        }
        thread.cleanCallFrames(currentCallFrame);
        if (errorMessage instanceof String) {
            errorMessage = (String)errorMessage;
        }
        thread.setTop(oldBase + 4);
        thread.objectStack[oldBase] = LuaPrototype.bFALSE;
        thread.objectStack[oldBase + 1] = errorMessage;
        thread.objectStack[oldBase + 2] = thread.stackTrace;
        thread.objectStack[oldBase + 3] = exception;
        thread.stackTrace = "";
        return 4;
    }

    public LuaTable getEnvironment() {
        return this.currentThread.environment;
    }

    public static boolean luaEquals(Object a2, Object b2) {
        if (a2 == null || b2 == null) {
            return a2 == b2;
        }
        if (a2 instanceof Integer && b2 instanceof Integer) {
            Integer ai2 = (Integer)a2;
            Integer bi2 = (Integer)b2;
            return ai2.intValue() == bi2.intValue();
        }
        return a2 == b2;
    }

    public static Integer toInt(int i2) {
        return new Integer(i2);
    }

    public static int fromInt(Object o2) {
        return (Integer)o2;
    }

    public static boolean boolEval(Object o2) {
        return o2 != null && o2 != LuaPrototype.bFALSE;
    }

    public static Boolean toBoolean(boolean b2) {
        return b2 ? LuaPrototype.bTRUE : LuaPrototype.bFALSE;
    }

    public LuaClosure loadByteCodeFromResource(String name, LuaTable environment) {
        InputStream stream = this.getClass().getResourceAsStream(name + ".lbc");
        if (stream == null) {
            return null;
        }
        try {
            return LuaPrototype.loadByteCode(stream, environment);
        }
        catch (Exception e2) {
            System.out.println("!!!:" + e2.toString());
            throw new RuntimeException(e2.getMessage());
        }
    }

    public void lock() {
    }

    public void unlock() {
    }

    static {
        LuaState.meta_ops[12] = "__add";
        LuaState.meta_ops[13] = "__sub";
        LuaState.meta_ops[14] = "__mul";
        LuaState.meta_ops[15] = "__div";
        LuaState.meta_ops[16] = "__mod";
        LuaState.meta_ops[17] = "__pow";
        LuaState.meta_ops[23] = "__eq";
        LuaState.meta_ops[24] = "__lt";
        LuaState.meta_ops[25] = "__le";
        bWait = false;
        bNoRun = false;
    }
}

