/*
 * Decompiled with CFR 0.152.
 */
package com.game.util;

import com.game.util.OString;
import com.game.util.Tools;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public final class Graphics2D {
    public static final int G_LT = 20;
    public static final int G_RT = 24;
    public static final int G_LB = 36;
    public static final int G_RB = 40;
    public static final int G_LV = 6;
    public static final int G_RV = 10;
    public static final int G_TH = 17;
    public static final int G_BH = 33;
    public static final int G_HV = 3;
    public static final int TRANS_NONE = 0;
    public static final int TRANS_ROT90 = 5;
    public static final int TRANS_ROT180 = 3;
    public static final int TRANS_ROT270 = 6;
    public static final int TRANS_MIRROR = 2;
    public static final int TRANS_MIRROR_ROT90 = 7;
    public static final int TRANS_MIRROR_ROT180 = 1;
    public static final int TRANS_MIRROR_ROT270 = 4;
    private static final boolean stringMiaobian = false;
    private final Graphics g2d;
    private final int width;
    private final int height;
    private int translateX;
    private int translateY;

    public Graphics2D(Image awtImage) {
        this(awtImage.getGraphics(), awtImage.getWidth(), awtImage.getHeight());
    }

    public void setTuanState(int x, int y) {
        this.translateX = x;
        this.translateY = y;
    }

    public Graphics2D(Graphics g, int width, int height) {
        this.g2d = g;
        this.width = width;
        this.height = height;
        this.g2d.setClip(0, 0, width, height);
    }

    public static final int getAnchorX(int anchor, int width) {
        int desX = 0;
        if ((anchor & 8) != 0) {
            desX = width;
        }
        if ((anchor & 1) != 0) {
            desX = width / 2;
        }
        return desX;
    }

    public static final int getAnchorY(int anchor, int height) {
        int desY = 0;
        if ((anchor & 0x20) != 0) {
            desY = height;
        }
        if ((anchor & 2) != 0) {
            desY = height / 2;
        }
        return desY;
    }

    public final void drawString(String s, int x, int y, int anchor) {
        int cx = x;
        int cy = y;
        if (anchor != 0) {
            cx = x - Graphics2D.getAnchorX(anchor, Tools.getStringWidth(s));
            cy = y - Graphics2D.getAnchorY(anchor, Tools.DEFAUL_FONT_HEIGHT);
        }
        this.g2d.drawString(s, cx - this.translateX, cy - this.translateY, 20);
    }

    public final void drawString(String s, int x, int y, int anchor, int color) {
        this.drawString(s, x, y, anchor, color, false, 0);
    }

    public final void drawSubstring(String str, int offset, int len, int x, int y, int anchor) {
        this.drawString(str.substring(offset, len), x, y, anchor);
    }

    public final void drawString(String str, int x, int y, int anchor, int color, boolean miaobian, int blackColor) {
        if (miaobian) {
            int len = str.length();
            int lw = 0;
            int cx = x;
            int cy = y;
            if (anchor != 0) {
                cx = x - Graphics2D.getAnchorX(anchor, Tools.getStringWidth(str));
                cy = y - Graphics2D.getAnchorY(anchor, Tools.DEFAUL_FONT_HEIGHT);
            }
            for (int i = 0; i < len; ++i) {
                char c = str.charAt(i);
                this.drawChar(c, cx + lw, cy, color, miaobian, blackColor, 20);
                lw += Tools.getCharWidth(c);
            }
        } else {
            this.setColor(color);
            this.drawString(str, x, y, anchor);
        }
    }

    public final int drawString(OString str, int x, int y, int w) {
        return this.drawString(str, x, y, w, 0, 0, Integer.MAX_VALUE);
    }

    public final int drawString(OString str, int x, int y, int w, int h) {
        return this.drawString(str, x, y, w, h, 0, Integer.MAX_VALUE);
    }

    public final int drawString(OString str, int x, int y, int w, int h, int sline, int eline) {
        return this.drawString(str, x, y, w, h, sline, eline, false, 0);
    }

    public final int drawString(OString str, int x, int y, int w, int h, int sline, int eline, boolean miaobian, int blackColor) {
        int j = 0;
        int count = 0;
        int len = str.length();
        int lw = 0;
        int color = 0;
        int hc = 0;
        while (j < len) {
            if ((count + 1) * Tools.DEFAUL_FONT_HEIGHT > h) {
                hc = 1;
            }
            if (count >= eline) break;
            char c = str.charAt(j);
            if (c == '\n') {
                lw = 0;
                ++count;
                ++j;
                continue;
            }
            if (count >= sline && count < eline) {
                color = str.getColor(j);
                this.drawChar(c, x + lw, y + Tools.DEFAUL_FONT_HEIGHT * (count - sline), color, miaobian, blackColor, 20);
            }
            lw += Tools.getCharWidth(c);
            if (++j >= len) continue;
            c = str.charAt(j);
            if (lw <= w && lw + Tools.getCharWidth(c) <= w || c == '\n') continue;
            lw = 0;
            ++count;
        }
        if (hc > 0) {
            hc = (count + 1) * Tools.DEFAUL_FONT_HEIGHT;
        }
        return hc;
    }

    public final void drawChars(char[] chars, int ofs, int len, int x, int y, int anchor) {
        this.drawString(new String(chars, ofs, len), x, y, anchor);
    }

    public final void drawChar(char c, int x, int y, int anchor) {
        this.drawChar(c, x, y, this.g2d.getColor(), false, 0, anchor);
    }

    public final void drawChar(char c, int x, int y, int color, boolean miaobian, int borderColor, int anchor) {
        x = x - Graphics2D.getAnchorX(anchor, Tools.getCharWidth(c)) - this.translateX;
        y = y - Graphics2D.getAnchorY(anchor, Tools.DEFAUL_FONT_HEIGHT) - this.translateY;
        if (miaobian) {
            this.g2d.setColor(borderColor);
            this.g2d.drawChar(c, x - 1, y, 0);
            this.g2d.drawChar(c, x + 1, y, 0);
            this.g2d.drawChar(c, x, y + 1, 0);
            this.g2d.drawChar(c, x, y - 1, 0);
            this.g2d.drawChar(c, x, y + 2, 0);
            this.g2d.drawChar(c, x + 2, y, 0);
        }
        this.g2d.setColor(color);
        this.g2d.drawChar(c, x, y, 0);
    }

    public final void drawRGB(int[] rgbData, int offset, int scanlength, int x, int y, int width, int height, boolean processAlpha) {
        if (rgbData == null) {
            return;
        }
        if (width == 0 || height == 0) {
            return;
        }
        this.g2d.drawRGB(rgbData, offset, scanlength, x - this.translateX, y - this.translateY, width, height, processAlpha);
    }

    public final void drawRGB(int[] rgb, int sw, int x, int y, int width, int height) {
        this.drawRGB(rgb, 0, sw, x, y, width, height, true);
    }

    public final void fillRGB(int[] rpg, int rw, int rh, int x, int y, int w, int h) {
        int clipX = this.g2d.getClipX();
        int clipY = this.g2d.getClipY();
        int clipWidth = this.g2d.getClipWidth();
        int clipHeight = this.g2d.getClipHeight();
        this.setClip(x, y, w, h);
        int row = h % rh == 0 ? h / rh : h / rh + 1;
        int col = w % rw == 0 ? w / rw : w / rw + 1;
        for (int i = 0; i < row; ++i) {
            for (int j = 0; j < col; ++j) {
                this.drawRGB(rpg, rw, x + rw * j, y + rh * i, rw, rh);
            }
        }
        this.g2d.setClip(clipX, clipY, clipWidth, clipHeight);
    }

    public final void translate(int x, int y) {
        this.translateX += x;
        this.translateY += y;
    }

    public final void setColor(int r, int g, int b) {
        this.setColor(r << 16 | g << 8 | b);
    }

    public final void setColor(int pixel) {
        this.g2d.setColor(pixel);
    }

    public final void setFont(Font font) {
        this.g2d.setFont(font);
    }

    public final int getClipX() {
        return this.g2d.getClipX() + this.translateX;
    }

    public final int getClipY() {
        return this.g2d.getClipY() + this.translateY;
    }

    public final int getClipWidth() {
        return this.g2d.getClipWidth();
    }

    public final int getClipHeight() {
        return this.g2d.getClipHeight();
    }

    public final void clipRect(int x, int y, int width, int height) {
        this.setClip(x, y, width, height);
    }

    public final void setClip(int x, int y, int width, int height) {
        this.g2d.setClip(x - this.translateX, y - this.translateY, width, height);
    }

    public final void drawLine(int x1, int y1, int x2, int y2) {
        this.g2d.drawLine(x1 - this.translateX, y1 - this.translateY, x2, y2);
    }

    public final void fillRect(int x, int y, int width, int height) {
        this.g2d.fillRect(x - this.translateX, y - this.translateY, width, height);
    }

    public final void clearRect() {
        this.g2d.setColor(0);
        this.g2d.fillRect(0, 0, this.width, this.height);
        this.g2d.setClip(0, 0, this.width, this.height);
    }

    public final void drawRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.g2d.drawRoundRect(x - this.translateX, y - this.translateY, width, height, arcWidth, arcHeight);
    }

    public final void fillRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.g2d.fillRoundRect(x - this.translateX, y - this.translateY, width, height, arcWidth, arcHeight);
    }

    public final void drawArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.g2d.drawArc(x - this.translateX, y - this.translateY, width, height, startAngle, arcAngle);
    }

    public final void fillArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.g2d.fillArc(x - this.translateX, y - this.translateY, width, height, startAngle, arcAngle);
    }

    public final void drawIamgeTansform(Image image, int x, int y, int transform, int anchor) {
        this.drawRegion(image, 0, 0, image.getWidth(), image.getHeight(), transform, x, y, anchor);
    }

    public final void drawImageClip(Image image, int x, int y, int frameWidth, int frameHeight, int transform, int currenFrame, int anchor) {
        int clipX = this.getClipX();
        int clipY = this.getClipY();
        int clipWidth = this.getClipWidth();
        int clipHeight = this.getClipHeight();
        int cx = x;
        int cy = y;
        if (anchor != 0) {
            cx = x - Graphics2D.getAnchorX(anchor, frameWidth);
            cy = y - Graphics2D.getAnchorY(anchor, frameHeight);
        }
        if (!Tools.intersectRect(cx, cy, frameWidth, frameHeight, clipX, clipY, clipWidth, clipHeight)) {
            return;
        }
        int widthNumber = image.getWidth() / frameWidth;
        int tx = currenFrame % widthNumber * frameWidth;
        int ty = currenFrame / widthNumber * frameHeight;
        this.drawRegion(image, tx, ty, frameWidth, frameHeight, transform, x, y, anchor);
    }

    public final void drawImage(Image img, int x, int y, int anchor) {
        this.g2d.drawImage(img, x - this.translateX, y - this.translateY, anchor);
    }

    public final void drawRegion(Image src, int x_src, int y_src, int width, int height, int transform, int x_dest, int y_dest, int anchor) {
        this.g2d.drawRegion(src, x_src, y_src, width, height, transform, x_dest - this.translateX, y_dest - this.translateY, anchor);
    }

    public final void fillImage(Image src, int x, int y, int w, int h) {
        int clipX = this.g2d.getClipX();
        int clipY = this.g2d.getClipY();
        int clipWidth = this.g2d.getClipWidth();
        int clipHeight = this.g2d.getClipHeight();
        int rh = src.getHeight();
        int rw = src.getWidth();
        this.setClip(x, y, w, h);
        int row = h % rh == 0 ? h / rh : h / rh + 1;
        int col = w % rw == 0 ? w / rw : w / rw + 1;
        for (int i = 0; i < row; ++i) {
            for (int j = 0; j < col; ++j) {
                this.drawImage(src, x + rw * j, y + rh * i, 20);
            }
        }
        this.g2d.setClip(clipX, clipY, clipWidth, clipHeight);
    }

    public final void drawRect(int x, int y, int width, int height) {
        this.g2d.drawRect(x - this.translateX, y - this.translateY, width, height);
    }

    public Graphics getGraphics() {
        return this.g2d;
    }

    public final void drawNumber(Image img, int number, int x, int y, int frameWidth, int frameHight) {
        int numberLength = this.numberLength(number);
        if (number == 0) {
            this.drawImageClip(img, x, y, frameWidth, frameHight, 0, 0, 0);
        }
        for (int i = 0; i < numberLength; ++i) {
            this.drawImageClip(img, x + (frameWidth + 2) * i, y, frameWidth, frameHight, 0, Integer.parseInt(String.valueOf(number).charAt(i) + ""), 0);
        }
    }

    private final int numberLength(int number) {
        int numberLength = 0;
        while (number != 0) {
            number /= 10;
            ++numberLength;
        }
        return numberLength;
    }
}

