/*
 * Decompiled with CFR 0.152.
 */
package com.game.cannonball;

import com.game.cannonball.ICannonball;
import com.game.cannonball.RectCoordinate;
import com.game.monster.IMonster;
import com.game.monster.Monster;
import com.game.sprite.SpriteX;
import com.game.util.Graphics2D;
import javax.microedition.lcdui.Image;

public class CannonballPineapple
extends SpriteX
implements ICannonball {
    private int hp;
    private int speed;
    private int cannonballId;
    private int state;
    private IMonster monster = null;
    private RectCoordinate rect = null;
    private int[] arrayInt = new int[]{-1, -1, -1, -1, -1, -1};

    public CannonballPineapple(byte[] path, Image img, int id) {
        super(path, img);
        this.rect = new RectCoordinate();
        this.rect.setWidth(this.getWidth());
        this.rect.setHeight(30);
        this.cannonballId = id;
    }

    public int getCannonballId() {
        return this.cannonballId;
    }

    public void logic() {
        if (this.y <= -70) {
            this.state = 1;
        }
        switch (this.state) {
            case 0: {
                this.move(0, -this.speed);
                break;
            }
            case 4: {
                if (this.getFrame() < this.getSequenceLength() - 1) break;
                this.state = 1;
            }
        }
    }

    public final void paint(Graphics2D g) {
        super.paint(g);
    }

    public void setBallPosition(int x, int y) {
        this.setPosition(x, y);
    }

    public boolean collisionWithMonster(Monster monster, int monsterIndex) {
        this.rect.setX(this.getX() - this.getWidth() / 2);
        this.rect.setY(this.getY() - this.getHeight() / 2);
        if (!this.rect.collisionWithMonster(monster.getRect())) {
            return false;
        }
        this.monster = monster;
        if (this.state == 4) {
            if (this.getFrame() >= 0 && this.getFrame() <= 3) {
                for (int i = 0; i < this.arrayInt.length; ++i) {
                    if (this.arrayInt[i] == monsterIndex) {
                        return false;
                    }
                    if (this.arrayInt[i] != -1) continue;
                    this.arrayInt[i] = monsterIndex;
                    monster.changeState(4);
                    monster.isDeath(this.hp);
                    return false;
                }
            }
        } else if (this.state != 1) {
            this.rect.setWidth(60);
            this.rect.setHeight(40);
            this.setAction(1);
            this.setState(4);
        }
        return true;
    }

    public void setState(int state) {
        this.state = state;
    }

    public int getState() {
        return this.state;
    }

    public void setSpeed(int speed) {
        this.speed = speed;
    }

    public void setHp(int hp) {
        this.hp = hp;
    }

    public int getHp() {
        return this.hp;
    }
}

