/*
 * Decompiled with CFR 0.152.
 */
package com.game.cannonball;

import com.game.cannonball.ICannonball;
import com.game.cannonball.RectCoordinate;
import com.game.monster.Monster;
import com.game.sprite.SpriteX;
import com.game.util.Graphics2D;
import javax.microedition.lcdui.Image;

public class CannonballApple
extends SpriteX
implements ICannonball {
    private int cannonballId;
    private int state = 3;
    private RectCoordinate rect = null;
    private int speed;
    private int hp;

    public int getCannonballId() {
        return this.cannonballId;
    }

    public void setCannonballId(int cannonballId) {
        this.cannonballId = cannonballId;
    }

    public CannonballApple(byte[] flie, Image img, int id) {
        super(flie, img);
        this.cannonballId = id;
        this.rect = new RectCoordinate();
        this.rect.setWidth(this.getWidth());
        this.rect.setHeight(15);
        this.setAction(0);
    }

    public final void logic() {
        switch (this.state) {
            case 0: {
                this.move(0, -this.speed);
                break;
            }
            case 4: {
                if (this.getFrame() < this.getSequenceLength() - 1) break;
                this.setState(1);
            }
        }
    }

    public final void paint(Graphics2D g) {
        super.paint(g);
    }

    public boolean collisionWithMonster(Monster monster, int monsterIndex) {
        this.rect.setX(this.getX() - this.getWidth() / 2);
        this.rect.setY(this.getY() - this.getHeight() / 2);
        if (!this.rect.collisionWithMonster(monster.getRect())) {
            return false;
        }
        this.setAction(1);
        this.setState(4);
        monster.changeState(4);
        return true;
    }

    public void setBallPosition(int x, int y) {
        this.setPosition(x, y - 30);
    }

    public void setState(int state) {
        this.state = state;
    }

    public int getState() {
        return this.state;
    }

    public void setSpeed(int speed) {
        this.speed = speed;
    }

    public void setHp(int hp) {
        this.hp = hp;
    }

    public int getHp() {
        return this.hp;
    }
}

