/*
 * Decompiled with CFR 0.152.
 */
package shotimg;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.microedition.lcdui.Image;
import shotimg.DCT;
import shotimg.Huffman;
import shotimg.JpegInfo;

public class JpegEncoder {
    private DataOutputStream a;
    private JpegInfo b;
    private Huffman c;
    private DCT d;
    private int e;
    private int f;
    private int g;
    public static int[] jpegNaturalOrder = new int[]{0, 1, 8, 16, 9, 2, 3, 10, 17, 24, 32, 25, 18, 11, 4, 5, 12, 19, 26, 33, 40, 48, 41, 34, 27, 20, 13, 6, 7, 14, 21, 28, 35, 42, 49, 56, 57, 50, 43, 36, 29, 22, 15, 23, 30, 37, 44, 51, 58, 59, 52, 45, 38, 31, 39, 46, 53, 60, 61, 54, 47, 55, 62, 63};

    public JpegEncoder(Image image, int n, OutputStream outputStream) {
        this.g = n;
        this.b = new JpegInfo(image);
        this.e = this.b.imageHeight;
        this.f = this.b.imageWidth;
        this.a = new DataOutputStream(outputStream);
        this.d = new DCT(this.g);
        this.c = new Huffman(this.f, this.e);
        this.Compress();
    }

    public void setQuality(int n) {
        this.d = new DCT(n);
    }

    public int getQuality() {
        return this.g;
    }

    public void Compress() {
        this.WriteHeaders(this.a);
        this.WriteCompressedData(this.a);
        this.WriteEOI(this.a);
        try {
            this.a.flush();
            return;
        }
        catch (IOException iOException) {
            System.out.println("IO Error: " + iOException.getMessage());
            return;
        }
    }

    public void WriteCompressedData(DataOutputStream object) {
        int n;
        int n2;
        int n3;
        int n4;
        float[][] fArray = new float[8][8];
        int[] nArray = new int[this.b.NumberOfComponents];
        int n5 = this.f % 8 != 0 ? (int)(Math.floor((double)this.f / 8.0) + 1.0) << 3 : this.f;
        int n6 = this.e % 8 != 0 ? (int)(Math.floor((double)this.e / 8.0) + 1.0) << 3 : this.e;
        for (n4 = 0; n4 < this.b.NumberOfComponents; ++n4) {
            n5 = Math.min(n5, this.b.BlockWidth[n4]);
            n6 = Math.min(n6, this.b.BlockHeight[n4]);
        }
        for (n3 = 0; n3 < n6; ++n3) {
            for (int i = 0; i < n5; ++i) {
                int n7 = i << 3;
                int n8 = n3 << 3;
                for (n4 = 0; n4 < this.b.NumberOfComponents; ++n4) {
                    float[][] fArray2 = (float[][])this.b.Components[n4];
                    for (int j = 0; j < this.b.VsampFactor[n4]; ++j) {
                        for (n2 = 0; n2 < this.b.HsampFactor[n4]; ++n2) {
                            int n9 = n2 << 3;
                            int n10 = j << 3;
                            for (int k = 0; k < 8; ++k) {
                                for (int i2 = 0; i2 < 8; ++i2) {
                                    fArray[k][i2] = fArray2[n8 + n10 + k][n7 + n9 + i2];
                                }
                            }
                            Object object2 = this.d.forwardDCT(fArray);
                            object2 = this.d.quantizeBlock((double[][])object2, this.b.QtableNumber[n4]);
                            this.c.HuffmanBlockEncoder((DataOutputStream)object, (int[])object2, nArray[n4], this.b.DCtableNumber[n4], this.b.ACtableNumber[n4]);
                            nArray[n4] = (int)object2[0];
                        }
                    }
                }
            }
        }
        DataOutputStream dataOutputStream = object;
        object = this.c;
        n2 = ((Huffman)object).b;
        for (n = ((Huffman)object).a; n >= 8; n -= 8) {
            n3 = n2 >> 16 & 0xFF;
            try {
                dataOutputStream.write(n3);
            }
            catch (IOException iOException) {
                System.out.println("IO Error: " + iOException.getMessage());
            }
            if (n3 == 255) {
                try {
                    dataOutputStream.write(0);
                }
                catch (IOException iOException) {
                    System.out.println("IO Error: " + iOException.getMessage());
                }
            }
            n2 <<= 8;
        }
        if (n > 0) {
            n3 = n2 >> 16 & 0xFF;
            try {
                dataOutputStream.write(n3);
                return;
            }
            catch (IOException iOException) {
                System.out.println("IO Error: " + iOException.getMessage());
            }
        }
    }

    public void WriteEOI(DataOutputStream dataOutputStream) {
        byte[] byArray = new byte[]{-1, -39};
        JpegEncoder.a(byArray, dataOutputStream);
    }

    public void WriteHeaders(DataOutputStream dataOutputStream) {
        Object[] objectArray;
        Object object = new byte[]{-1, -40};
        JpegEncoder.a(object, dataOutputStream);
        byte[] byArray = new byte[18];
        object = byArray;
        byArray[0] = -1;
        object[1] = -32;
        object[2] = 0;
        object[3] = 16;
        object[4] = 74;
        object[5] = 70;
        object[6] = 73;
        object[7] = 70;
        object[8] = 0;
        object[9] = 1;
        object[10] = 0;
        object[11] = 0;
        object[12] = 0;
        object[13] = 1;
        object[14] = 0;
        object[15] = 1;
        object[16] = 0;
        object[17] = 0;
        JpegEncoder.b(object, dataOutputStream);
        new String();
        String string = this.b.getComment();
        object = string;
        int n = string.length();
        byte[] byArray2 = new byte[n + 4];
        byte[] byArray3 = byArray2;
        byArray2[0] = -1;
        byArray3[1] = -2;
        byArray3[2] = (byte)(n >> 8);
        byArray3[3] = (byte)n;
        System.arraycopy(this.b.a.getBytes(), 0, byArray3, 4, this.b.a.length());
        JpegEncoder.b(byArray3, dataOutputStream);
        byte[] byArray4 = new byte[134];
        byte[] byArray5 = byArray4;
        byArray4[0] = -1;
        byArray5[1] = -37;
        byArray5[2] = 0;
        byArray5[3] = -124;
        int n2 = 4;
        for (n = 0; n < 2; ++n) {
            byArray5[n2++] = (byte)(n + 0);
            objectArray = (int[])this.d.quantum[n];
            for (int i = 0; i < 64; ++i) {
                byArray5[n2++] = (byte)objectArray[jpegNaturalOrder[i]];
            }
        }
        JpegEncoder.b(byArray5, dataOutputStream);
        byte[] byArray6 = new byte[19];
        byArray3 = byArray6;
        byArray6[0] = -1;
        byArray3[1] = -64;
        byArray3[2] = 0;
        byArray3[3] = 17;
        byArray3[4] = (byte)this.b.Precision;
        byArray3[5] = (byte)(this.b.imageHeight >> 8);
        byArray3[6] = (byte)this.b.imageHeight;
        byArray3[7] = (byte)(this.b.imageWidth >> 8);
        byArray3[8] = (byte)this.b.imageWidth;
        byArray3[9] = (byte)this.b.NumberOfComponents;
        n2 = 10;
        for (n = 0; n < byArray3[9]; ++n) {
            byArray3[n2++] = (byte)this.b.CompID[n];
            byArray3[n2++] = (byte)((this.b.HsampFactor[n] << 4) + this.b.VsampFactor[n]);
            byArray3[n2++] = (byte)this.b.QtableNumber[n];
        }
        JpegEncoder.b(byArray3, dataOutputStream);
        n2 = 4;
        int n3 = 4;
        objectArray = new byte[17];
        byte[] byArray7 = new byte[4];
        byte[] byArray8 = byArray7;
        byArray7[0] = -1;
        byArray8[1] = -60;
        for (n = 0; n < 4; ++n) {
            int n4;
            int n5 = 0;
            objectArray[n2++ - n3] = (byte)((int[])this.c.bits.elementAt(n))[0];
            for (n4 = 1; n4 < 17; ++n4) {
                int n6 = ((int[])this.c.bits.elementAt(n))[n4];
                objectArray[n2++ - n3] = (byte)n6;
                n5 += n6;
            }
            int n7 = n2;
            byArray5 = new byte[n5];
            for (n4 = 0; n4 < n5; ++n4) {
                byArray5[n2++ - n7] = (byte)((int[])this.c.val.elementAt(n))[n4];
            }
            byArray3 = new byte[n2];
            System.arraycopy(byArray8, 0, byArray3, 0, n3);
            System.arraycopy(objectArray, 0, byArray3, n3, 17);
            System.arraycopy(byArray5, 0, byArray3, n3 + 17, n5);
            byArray8 = byArray3;
            n3 = n2;
        }
        byArray8[2] = (byte)(n2 - 2 >> 8);
        byArray8[3] = (byte)(n2 - 2);
        JpegEncoder.b(byArray8, dataOutputStream);
        byte[] byArray9 = new byte[14];
        byArray3 = byArray9;
        byArray9[0] = -1;
        byArray3[1] = -38;
        byArray3[2] = 0;
        byArray3[3] = 12;
        byArray3[4] = (byte)this.b.NumberOfComponents;
        n2 = 5;
        for (n = 0; n < byArray3[4]; ++n) {
            byArray3[n2++] = (byte)this.b.CompID[n];
            byArray3[n2++] = (byte)((this.b.DCtableNumber[n] << 4) + this.b.ACtableNumber[n]);
        }
        byArray3[n2++] = (byte)this.b.Ss;
        byArray3[n2++] = (byte)this.b.Se;
        byArray3[n2] = (byte)((this.b.Ah << 4) + this.b.Al);
        JpegEncoder.b(byArray3, dataOutputStream);
    }

    private static void a(byte[] byArray, DataOutputStream dataOutputStream) {
        try {
            dataOutputStream.write(byArray, 0, 2);
            return;
        }
        catch (IOException iOException) {
            System.out.println("IO Error: " + iOException.getMessage());
            return;
        }
    }

    private static void b(byte[] byArray, DataOutputStream dataOutputStream) {
        try {
            int n = ((byArray[2] & 0xFF) << 8) + (byArray[3] & 0xFF) + 2;
            dataOutputStream.write(byArray, 0, n);
            return;
        }
        catch (IOException iOException) {
            System.out.println("IO Error: " + iOException.getMessage());
            return;
        }
    }
}

