/*
 * Decompiled with CFR 0.152.
 */
package json;

import java.util.Hashtable;
import java.util.Vector;

public class JSONObject {
    private Hashtable a;
    private Vector b;
    private int c;
    private String d;

    public JSONObject() {
        this.a = new Hashtable();
    }

    public JSONObject(JSONObject jSONObject) {
        this();
        if (jSONObject.nextClean() != '{') {
            throw jSONObject.syntaxError("ERR:0");
        }
        block8: while (true) {
            char c2 = jSONObject.nextClean();
            switch (c2) {
                case '\u0000': {
                    throw jSONObject.syntaxError("ERR:1");
                }
                case '}': {
                    return;
                }
            }
            jSONObject.back();
            String string = jSONObject.nextValue().toString();
            c2 = jSONObject.nextClean();
            if (c2 == '=') {
                if (jSONObject.next() != '>') {
                    jSONObject.back();
                }
            } else if (c2 != ':') {
                throw jSONObject.syntaxError("ERR:2");
            }
            this.put(string, jSONObject.nextValue());
            switch (jSONObject.nextClean()) {
                case ',': 
                case ';': {
                    if (jSONObject.nextClean() == '}') {
                        return;
                    }
                    jSONObject.back();
                    continue block8;
                }
                case '}': {
                    return;
                }
            }
            break;
        }
        throw jSONObject.syntaxError("ERR:3");
    }

    public JSONObject(String string) {
        this.newJSONTokener(string);
    }

    public JSONObject put(String string, Object object) {
        if (string == null) {
            throw new Exception("Null key.");
        }
        if (object != null) {
            this.a.put(string, object);
        } else {
            this.remove(string);
        }
        return this;
    }

    public Object remove(String string) {
        return this.a.remove(string);
    }

    public Object get(String string) {
        if ((this = ((JSONObject)this).opt(string)) == null) {
            throw new Exception("JSONObject not found.");
        }
        return this;
    }

    public String getString(String string) {
        return this.get(string).toString();
    }

    public Object opt(String string) {
        if (string == null) {
            return null;
        }
        return this.a.get(string);
    }

    public void newJSONArray() {
        this.b = new Vector();
    }

    public void newJSONArray(JSONObject jSONObject) {
        this.newJSONArray();
        if (jSONObject.nextClean() != '[') {
            throw jSONObject.syntaxError("ERR:4");
        }
        if (jSONObject.nextClean() == ']') {
            return;
        }
        jSONObject.back();
        block4: while (true) {
            if (jSONObject.nextClean() == ',') {
                jSONObject.back();
                this.b.addElement(null);
            } else {
                jSONObject.back();
                this.b.addElement(jSONObject.nextValue());
            }
            switch (jSONObject.nextClean()) {
                case ',': 
                case ';': {
                    if (jSONObject.nextClean() == ']') {
                        return;
                    }
                    jSONObject.back();
                    continue block4;
                }
                case ']': {
                    return;
                }
            }
            break;
        }
        throw jSONObject.syntaxError("ERR:5");
    }

    public void newJSONArray(String string) {
        this.newJSONArray(new JSONObject(string));
    }

    public Object get(int n) {
        if ((this = ((JSONObject)this).opt(n)) == null) {
            throw new Exception("JSONArray[" + n + "] not found.");
        }
        return this;
    }

    public int length() {
        return this.b.size();
    }

    public Object opt(int n) {
        if (n < 0 || n >= this.length()) {
            return null;
        }
        return this.b.elementAt(n);
    }

    public void newJSONTokener(String string) {
        this.c = 0;
        this.d = string;
    }

    public void back() {
        if (this.c > 0) {
            --this.c;
        }
    }

    public char next() {
        if (this.c < this.d.length()) {
            char c2 = this.d.charAt(this.c);
            ++this.c;
            return c2;
        }
        return '\u0000';
    }

    public String next(int n) {
        int n2 = this.c;
        int n3 = n2 + n;
        if (n3 >= this.d.length()) {
            throw this.syntaxError("Substring bounds error");
        }
        this.c += n;
        return this.d.substring(n2, n3);
    }

    public char nextClean() {
        char c2;
        block4: while (true) {
            if ((c2 = this.next()) == '/') {
                switch (this.next()) {
                    case '/': {
                        while ((c2 = this.next()) != '\n' && c2 != '\r' && c2 != '\u0000') {
                        }
                        continue block4;
                    }
                    case '*': {
                        while (true) {
                            if ((c2 = this.next()) == '\u0000') {
                                throw this.syntaxError("Unclosed comment.");
                            }
                            if (c2 != '*') continue;
                            if (this.next() == '/') continue block4;
                            this.back();
                        }
                    }
                }
                this.back();
                return '/';
            }
            if (c2 == '#') {
                while ((c2 = this.next()) != '\n' && c2 != '\r' && c2 != '\u0000') {
                }
                continue;
            }
            if (c2 == '\u0000' || c2 > ' ') break;
        }
        return c2;
    }

    public String nextString(char c2) {
        StringBuffer stringBuffer = new StringBuffer();
        block13: while (true) {
            char c3 = this.next();
            switch (c3) {
                case '\u0000': 
                case '\n': 
                case '\r': {
                    throw this.syntaxError("Unterminated string");
                }
                case '\\': {
                    c3 = this.next();
                    switch (c3) {
                        case 'b': {
                            stringBuffer.append('\b');
                            continue block13;
                        }
                        case 't': {
                            stringBuffer.append('\t');
                            continue block13;
                        }
                        case 'n': {
                            stringBuffer.append('\n');
                            continue block13;
                        }
                        case 'f': {
                            stringBuffer.append('\f');
                            continue block13;
                        }
                        case 'r': {
                            stringBuffer.append('\r');
                            continue block13;
                        }
                        case 'u': {
                            stringBuffer.append((char)Integer.parseInt(this.next(4), 16));
                            continue block13;
                        }
                        case 'x': {
                            stringBuffer.append((char)Integer.parseInt(this.next(2), 16));
                            continue block13;
                        }
                    }
                    stringBuffer.append(c3);
                    continue block13;
                }
            }
            if (c3 == c2) {
                return stringBuffer.toString();
            }
            stringBuffer.append(c3);
        }
    }

    public Object nextValue() {
        char c2 = this.nextClean();
        switch (c2) {
            case '\"': 
            case '\'': {
                return this.nextString(c2);
            }
            case '{': {
                this.back();
                return new JSONObject(this);
            }
            case '[': {
                throw new Exception("ERR:6");
            }
        }
        StringBuffer stringBuffer = new StringBuffer();
        while (c2 >= ' ' && ",:]}/\\\"[{;=#".indexOf(c2) < 0) {
            stringBuffer.append(c2);
            c2 = this.next();
        }
        this.back();
        String string = stringBuffer.toString().trim();
        if (string.equals("")) {
            throw this.syntaxError("Missing value.");
        }
        return string;
    }

    public Exception syntaxError(String string) {
        return new Exception(string + this.toString());
    }
}

