package com.mglib.mission;

import java.io.*;

import game.*;

/**
 * <p>Title: engine of RPG game</p>
 * <p>Description: RPG ϷĶ, v3.0ʱӵ</p>
 * <p>Copyright: Copyright (c) 2007</p>
 * <p>Company: mig</p>
 * @author lianghao chen
 * @version 1.0
 */
public class MissionGroup
{
    /** а */
    public static final int MISSION_GROUP_CAPACITY = 15;
    /**  */
    public static final int MAX_GROUP_COUNT = 10;

    /**  */
    public static short missionGroupSize;
    /** 鼯 */
    public static MissionGroup[] missionGroup;


    /** id */
    public byte id;
    /**  */
    public String name;
    /**  */
    public String desc;

    /**  */
    public short size;
    /** ID */
    public byte[] group = new byte[MISSION_GROUP_CAPACITY];

    /**
     * ʼ
     **/
    public MissionGroup ()
    {
	//ʼϢ
	size = 0;
	for ( int i = 0; i < MISSION_GROUP_CAPACITY; i++ )
	{
	    group[i] = -1;
	}
    }

    /**
     * ȡϢ
     * @param dis DataInputStream
     */
    public static void loadMissionGroups (DataInputStream dis) throws Exception
    {
	MissionGroup.missionGroup = new MissionGroup[MAX_GROUP_COUNT];

	int count = dis.readShort ();
	if ( CDebug.showDebugInfo )
	{
	    if ( count > MAX_GROUP_COUNT )
	    {
		throw new Exception ( ">>WARNING:  Ѿ޸ģ" + MAX_GROUP_COUNT + ", ǰ" + count );
	    }
	}

	for ( int i = 0; i < count; i++ )
	{
	    MissionGroup mg = MissionGroup.missionGroup[MissionGroup.missionGroupSize++] = new MissionGroup ();
	    mg.id = dis.readByte ();
	    mg.name = dis.readUTF ();
	    mg.desc = dis.readUTF ();
	    int mc = dis.readShort ();
	    if ( CDebug.showDebugInfo )
	    {
		if ( mc > MISSION_GROUP_CAPACITY )
		{
		    throw new Exception ( ">>WARNING:  Ѿ޸ģ" + MISSION_GROUP_CAPACITY + ", ǰ" + mc + "; id="+mg.id+", name="+mg.name);
		}
	    }

	    for ( int j = 0; j < mc; j++ )
	    {
		mg.group[mg.size++] = dis.readByte ();
	    }
	}
    }

}
