/*
 * Decompiled with CFR 0.152.
 */
package com.npc.sms;

import com.npc.sms.Arguments;
import com.npc.sms.Record;
import com.npc.sms.Sender;
import javax.microedition.midlet.MIDlet;

public class Payment {
    private String[] prefixs;
    private String[] ports;
    private int price;
    private String version;
    private String edition;
    private String site;

    public Payment(MIDlet midlet, Arguments arguments) {
        this.version = midlet.getAppProperty("MIDlet-Version").substring(0, 1);
        this.edition = arguments.getString("Edition");
        this.site = arguments.getString("Site");
        this.price = arguments.getNumber("SMSPrice");
        int count = 0;
        int i2 = 1;
        while (i2 < 5) {
            if (arguments.getString("SMSPort_" + i2) == null) break;
            count = i2++;
        }
        this.prefixs = new String[count];
        this.ports = new String[count];
        i2 = 0;
        while (i2 < count) {
            int j2 = i2 + 1;
            this.prefixs[i2] = arguments.getString("SMSPrefix_" + j2);
            this.ports[i2] = arguments.getString("SMSPort_" + j2);
            ++i2;
        }
        Record.load();
    }

    public int getHistory() {
        return Record.historyPayment;
    }

    public int getCurrent() {
        return Record.currentPayment;
    }

    public int getPrice() {
        return this.price;
    }

    public boolean pay(int kind) {
        int index = Record.serial % this.prefixs.length;
        String port = this.ports[index];
        StringBuffer buff = new StringBuffer();
        buff.append(this.prefixs[index]);
        buff.append(":").append(this.version);
        buff.append(":").append(kind);
        buff.append(":").append(this.site);
        buff.append(":").append(this.edition);
        String text = buff.toString();
        if (!Sender.sendMessage(port, text)) {
            return false;
        }
        Record.currentPayment += this.price;
        ++Record.serial;
        Record.save();
        return true;
    }

    public void end() {
        Record.historyPayment += Record.currentPayment;
        Record.currentPayment = 0;
        Record.save();
    }
}

