/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.game.GameCanvas;

public class PlayCanvas
extends GameCanvas
implements Runnable {
    Graphics g = null;
    Loading loadingCanvas = null;
    boolean keyEvent = false;
    boolean key_up = false;
    boolean key_down = false;
    boolean key_left = false;
    boolean key_right = false;
    boolean key_fire = false;
    boolean needFire = false;
    BulletManager bulletManager;
    EnemyManager enemyManager;
    ExplosionManager explosionManager;
    CloudManager cloudManager;
    PlayerManager playerManager;
    BackgroundManager backgroundManager;

    protected PlayCanvas(boolean suppressKeyEvents) {
        super(false);
        this.setFullScreenMode(true);
        try {
            Thread t = new Thread(this);
            t.start();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void init() {
        System.gc();
        this.g = this.getGraphics();
        Util.screenWidth = this.getWidth();
        Util.screenHeight = this.getHeight();
        System.gc();
        this.backgroundManager = new BackgroundManager(Util.stage);
        this.backgroundManager.initGameBackground(Util.stage);
        Util.backgroundManager = this.backgroundManager;
        System.gc();
        this.playerManager = new PlayerManager(Util.playerSelected);
        this.playerManager.initStageData();
        Util.playerManager = this.playerManager;
        System.gc();
        this.bulletManager = new BulletManager(Util.stage);
        this.bulletManager.initStageData();
        Util.bulletManager = this.bulletManager;
        System.gc();
        this.enemyManager = new EnemyManager(Util.stage);
        this.enemyManager.initStageData();
        Util.enemyManager = this.enemyManager;
        System.gc();
        Util.explosionManager = this.explosionManager = new ExplosionManager(Util.stage);
        System.gc();
        Util.cloudManager = this.cloudManager = new CloudManager(Util.stage);
        System.gc();
    }

    protected void keyPressed(int code) {
        if (code == KeyCode.getLeftKey()) {
            this.playerManager.masterSkillFire(1);
        }
        if (code == KeyCode.getRightKey()) {
            Util.gotoPasue();
        }
        if (code == 42) {
            this.playerManager.masterSkillFire(1);
        }
    }

    public void paint(Graphics g) {
        g.setColor(0, 0, 0);
        g.fillRect(0, 0, Util.screenWidth, Util.screenHeight);
        if (this.loadingCanvas != null) {
            this.loadingCanvas.draw(g);
        }
    }

    public void run() {
        System.gc();
        this.loadingCanvas = null;
        this.loadingCanvas = new Loading();
        System.gc();
        int i = 0;
        while (i < 6) {
            this.loadingCanvas.gotoNextFrame();
            this.repaint();
            try {
                Thread.sleep(300L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++i;
        }
        this.loadingCanvas = null;
        this.repaint();
        this.init();
        boolean memoryClearTimeIndex = false;
        while (GameMIDlet.f_playcanvas) {
            this.gameKeyInput();
            if (!Util.pasue) {
                this.gameDataUpdate();
            }
            this.gameScreenDraw();
            try {
                Thread.sleep(25L);
                System.gc();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void gameKeyInput() {
        this.keyEvent = false;
        this.key_up = false;
        this.key_down = false;
        this.key_left = false;
        this.key_right = false;
        this.key_fire = false;
        int keyState = this.getKeyStates();
        if ((keyState & 4) != 0) {
            this.keyEvent = true;
            this.key_left = true;
        }
        if ((keyState & 0x20) != 0) {
            this.keyEvent = true;
            this.key_right = true;
        }
        if ((keyState & 0x40) != 0) {
            this.keyEvent = true;
            this.key_down = true;
        }
        if ((keyState & 2) != 0) {
            this.keyEvent = true;
            this.key_up = true;
        }
        if ((keyState & 0x100) != 0) {
            this.keyEvent = true;
            this.key_fire = true;
        }
    }

    private void gameDataUpdate() {
        this.playersDataUpdate();
        this.otherDataUpdate();
        this.enemyDataUpdate();
    }

    private void otherDataUpdate() {
        this.backgroundManager.calcScrollScreen();
        this.bulletManager.calcBullet();
        this.explosionManager.calcExplosion();
        this.cloudManager.calcCloud();
    }

    private void gameScreenDraw() {
        this.g.setColor(0xFFFFFF);
        this.g.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (this.backgroundManager != null) {
            this.backgroundManager.paint(this.g);
        }
        if (this.cloudManager != null) {
            this.cloudManager.paint(this.g);
        }
        if (this.bulletManager != null) {
            this.bulletManager.paint(this.g);
        }
        if (this.enemyManager != null) {
            this.enemyManager.paint(this.g);
        }
        if (this.playerManager != null) {
            this.playerManager.paint(this.g);
        }
        if (this.explosionManager != null) {
            this.explosionManager.paint(this.g);
        }
        this.flushGraphics();
    }

    private void playersDataUpdate() {
        if (this.keyEvent) {
            if (this.key_up) {
                this.playerManager.moveTo(0, -this.playerManager.getCurrentPlayer().getDY());
                this.playerManager.setPlayerFlyMode(0);
            }
            if (this.key_down) {
                this.playerManager.moveTo(0, this.playerManager.getCurrentPlayer().getDY() + 2);
                this.playerManager.setPlayerFlyMode(0);
            }
            if (this.key_left) {
                this.playerManager.moveTo(-this.playerManager.getCurrentPlayer().getDX(), 0);
                this.playerManager.setPlayerFlyMode(1);
            }
            if (this.key_right) {
                this.playerManager.moveTo(this.playerManager.getCurrentPlayer().getDX(), 0);
                this.playerManager.setPlayerFlyMode(2);
            }
            if (this.key_fire) {
                this.needFire = !this.needFire;
            }
        } else {
            this.playerManager.setPlayerFlyMode(0);
        }
        if (this.needFire) {
            this.playerManager.fire(Util.int_fire_bulletSelect);
        }
        this.playerManager.calcPlayer(this.bulletManager);
    }

    private void enemyDataUpdate() {
        this.enemyManager.autoCreateEnemyPlane();
        this.enemyManager.calcEnemyPlane(this.bulletManager);
        this.enemyManager.meetCheck(this.bulletManager, this.explosionManager);
    }
}

