/*
 * Decompiled with CFR 0.152.
 */
import java.util.Random;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;

public class BulletManager {
    public static final int BULLET_TYPE_RED = 10;
    public static final int BULLET_TYPE_GREEN = 4;
    public static final int BULLET_TYPE_ROCKETS = 3;
    public static final int BULLET_TYPE_TRIANGLE = 2;
    public static final int BULLET_TYPE_TWINS = 1;
    public static final int BULLET_TYPE_HAT = 0;
    public static final int BULLET_TYPE_STICK = 7;
    public static final int BULLET_TYPE_DIAMOND = 20;
    public static final int BULLET_TYPE_SHOTGUN = 6;
    public static final int MASTERSKILL_BULLET_TYPE_LASER = 1;
    public static final int MASTERSKILL_BULLET_TYPE_CONCUSSION = 2;
    Sprite sprite;
    Sprite diamondSprite;
    Vector bulletVector;

    public BulletManager(int stage) {
        this.init();
    }

    public void initStageData() {
        this.bulletVector.removeAllElements();
        System.gc();
    }

    private void init() {
        this.bulletVector = new Vector();
        Image img = null;
        try {
            img = Image.createImage((String)"/bullet.png");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.sprite = new Sprite(img, img.getWidth() / 2, img.getHeight() / 6);
        try {
            img = Image.createImage((String)"/diamondbullet.png");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.diamondSprite = new Sprite(img, img.getWidth() / 2, img.getHeight());
    }

    public void createMasterSkillBullet(int x, int y, int bulletType) {
        MasterSkillLaserBullet bl = null;
        switch (bulletType) {
            case 1: {
                bl = new MasterSkillLaserBullet(this.sprite, x, y);
            }
        }
        if (bl != null) {
            this.bulletVector.addElement(bl);
        }
    }

    private void createEnemyBullet(int x, int y, int bulletType) {
        if (this.bulletVector.size() > 100) {
            return;
        }
        BasicBullet bl = null;
        switch (bulletType) {
            case 10: {
                bl = new RedBullet(this.sprite, x, y, true);
                break;
            }
            case 4: {
                bl = new GreenBullet(this.sprite, x, y, true);
                break;
            }
            case 3: {
                bl = new RocketsBullet(this.sprite, x, y, true);
                break;
            }
            case 2: {
                bl = new TriangleBullet(this.sprite, x, y, true);
                break;
            }
            case 1: {
                bl = new TwinsBullet(this.sprite, x, y, true);
                break;
            }
            case 0: {
                bl = new HatBullet(this.sprite, x, y, true);
                break;
            }
            case 7: {
                bl = new StickBullet(this.sprite, x, y, true);
                break;
            }
            case 20: {
                bl = new DiamondBullet(this.diamondSprite, x, y, true);
            }
        }
        if (bl != null) {
            this.bulletVector.addElement(bl);
        }
    }

    private void createPlayerBullet(int x, int y, int bulletType) {
        BasicBullet bl = null;
        switch (bulletType) {
            case 10: {
                bl = new RedBullet(this.sprite, x, y, false);
                break;
            }
            case 4: {
                bl = new GreenBullet(this.sprite, x, y, false);
                break;
            }
            case 3: {
                bl = new RocketsBullet(this.sprite, x, y, false);
                break;
            }
            case 2: {
                bl = new TriangleBullet(this.sprite, x, y, false);
                break;
            }
            case 1: {
                bl = new TwinsBullet(this.sprite, x, y, false);
                break;
            }
            case 0: {
                bl = new HatBullet(this.sprite, x, y, false);
                break;
            }
            case 7: {
                bl = new StickBullet(this.sprite, x, y, false);
                break;
            }
            case 6: {
                bl = new ShotgunBullet(this.sprite, x, y, false, 5);
                if (bl != null) {
                    this.bulletVector.addElement(bl);
                }
                if ((bl = new ShotgunBullet(this.sprite, x, y, false, 6)) != null) {
                    this.bulletVector.addElement(bl);
                }
                if ((bl = new ShotgunBullet(this.sprite, x, y, false, 7)) != null) {
                    this.bulletVector.addElement(bl);
                }
                if ((bl = new ShotgunBullet(this.sprite, x, y, false, 8)) != null) {
                    this.bulletVector.addElement(bl);
                }
                bl = new ShotgunBullet(this.sprite, x, y, false, 9);
            }
        }
        if (bl != null) {
            this.bulletVector.addElement(bl);
        }
    }

    public void createBullet(int x, int y, boolean isEnemyBullet, int bulletType) {
        if (isEnemyBullet) {
            this.createEnemyBullet(x, y, bulletType);
        } else {
            this.createPlayerBullet(x, y, bulletType);
        }
    }

    private void createBossEgeBullet(int x, int y) {
        this.createBullet(x - 20, y + 20, true, 4);
        this.createBullet(x + 20, y + 20, true, 4);
        this.createBullet(x, y + 20, true, 20);
    }

    private void createBossNormalBullet(int x, int y) {
        BasicBullet bl = null;
        Random rn = new Random();
        int moveRate = 3;
        int range = 24;
        int i = 0;
        while (i < 20) {
            if (i < 15) {
                if (i % 3 == 0) {
                    bl = new RedBullet(this.sprite, x + rn.nextInt(range), y + rn.nextInt(range), true);
                    bl.dx = -rn.nextInt(moveRate);
                    bl.dy = 1 + rn.nextInt(moveRate);
                } else if (i % 5 == 0) {
                    bl = new GreenBullet(this.sprite, x + rn.nextInt(range), y + rn.nextInt(range), true);
                    bl.dx = -rn.nextInt(moveRate);
                    bl.dy = 1 + rn.nextInt(moveRate);
                }
            } else if (i % 2 == 0) {
                bl = new RedBullet(this.sprite, x + rn.nextInt(range), y + rn.nextInt(range), true);
                bl.dx = -rn.nextInt(moveRate);
                bl.dy = 1 + rn.nextInt(moveRate);
            } else if (i % 7 == 0) {
                bl = new GreenBullet(this.sprite, x + rn.nextInt(range), y + rn.nextInt(range), true);
                bl.dx = -rn.nextInt(moveRate);
                bl.dy = 1 + rn.nextInt(moveRate);
            }
            bl = this.ChangeBulletStopToMove(bl);
            this.bulletVector.addElement(bl);
            ++i;
        }
        i = 0;
        while (i < 20) {
            if (i < 15) {
                if (i % 2 == 0) {
                    bl = new RedBullet(this.sprite, x + rn.nextInt(range), y + rn.nextInt(range), true);
                    bl.dx = rn.nextInt(moveRate);
                    bl.dy = 1 + rn.nextInt(moveRate);
                } else {
                    bl = new GreenBullet(this.sprite, x + rn.nextInt(range), y + rn.nextInt(range), true);
                    bl.dx = rn.nextInt(moveRate);
                    bl.dy = 1 + rn.nextInt(moveRate);
                }
            } else if (i % 2 == 0) {
                bl = new RedBullet(this.sprite, x + rn.nextInt(range), y + rn.nextInt(range), true);
                bl.dx = rn.nextInt(moveRate);
                bl.dy = -1 - rn.nextInt(moveRate);
            } else {
                bl = new GreenBullet(this.sprite, x + rn.nextInt(range), y + rn.nextInt(range), true);
                bl.dx = rn.nextInt(moveRate);
                bl.dy = -1 - rn.nextInt(moveRate);
            }
            bl = this.ChangeBulletStopToMove(bl);
            this.bulletVector.addElement(bl);
            ++i;
        }
    }

    private void createBossPowerBullet(int x, int y) {
        BasicBullet bl = null;
        Random rn = new Random();
        int moveRate = 4;
        int range = 32;
        int i = 0;
        while (i < 30) {
            if (i < 20) {
                if (i % 2 == 0) {
                    bl = new RedBullet(this.sprite, x + rn.nextInt(range), y + rn.nextInt(range), true);
                    bl.dx = -rn.nextInt(moveRate);
                    bl.dy = 1 + rn.nextInt(moveRate);
                } else {
                    bl = new GreenBullet(this.sprite, x + rn.nextInt(range), y + rn.nextInt(range), true);
                    bl.dx = -rn.nextInt(moveRate);
                    bl.dy = 1 + rn.nextInt(moveRate);
                }
            } else if (i % 2 == 0) {
                bl = new DiamondBullet(this.diamondSprite, x + rn.nextInt(range), y + rn.nextInt(range), true);
                bl.dx = -rn.nextInt(moveRate);
                bl.dy = 1 + rn.nextInt(moveRate);
            } else {
                bl = new GreenBullet(this.sprite, x + rn.nextInt(range), y + rn.nextInt(range), true);
                bl.dx = -rn.nextInt(moveRate);
                bl.dy = 1 + rn.nextInt(moveRate);
            }
            bl = this.ChangeBulletStopToMove(bl);
            this.bulletVector.addElement(bl);
            ++i;
        }
        i = 0;
        while (i < 30) {
            if (i < 20) {
                if (i % 2 == 0) {
                    bl = new RedBullet(this.sprite, x + rn.nextInt(range), y + rn.nextInt(range), true);
                    bl.dx = rn.nextInt(moveRate);
                    bl.dy = 1 + rn.nextInt(moveRate);
                } else {
                    bl = new DiamondBullet(this.diamondSprite, x + rn.nextInt(range), y + rn.nextInt(range), true);
                    bl.dx = rn.nextInt(moveRate);
                    bl.dy = 1 + rn.nextInt(moveRate);
                }
            } else if (i % 2 == 0) {
                bl = new RedBullet(this.sprite, x + rn.nextInt(range), y + rn.nextInt(range), true);
                bl.dx = rn.nextInt(moveRate);
                bl.dy = -1 - rn.nextInt(moveRate);
            } else {
                bl = new GreenBullet(this.sprite, x + rn.nextInt(range), y + rn.nextInt(range), true);
                bl.dx = rn.nextInt(moveRate);
                bl.dy = -1 - rn.nextInt(moveRate);
            }
            bl = this.ChangeBulletStopToMove(bl);
            this.bulletVector.addElement(bl);
            ++i;
        }
    }

    private void createBossMasterBullet(int x, int y) {
        BasicBullet bl = null;
        Random rn = new Random();
        int moveRate = 5;
        int range = 40;
        int i = 0;
        while (i < 40) {
            if (i < 30) {
                if (i % 2 != 0) {
                    bl = new GreenBullet(this.sprite, x + rn.nextInt(range), y + rn.nextInt(range), true);
                    bl.dx = -rn.nextInt(moveRate);
                    bl.dy = 1 + rn.nextInt(moveRate);
                }
            } else if (i % 7 == 0) {
                bl = new RedBullet(this.sprite, x + rn.nextInt(range), y + rn.nextInt(range), true);
                bl.dx = -rn.nextInt(moveRate);
                bl.dy = 1 + rn.nextInt(moveRate);
            } else {
                bl = new GreenBullet(this.sprite, x + rn.nextInt(range), y + rn.nextInt(range), true);
                bl.dx = -rn.nextInt(moveRate);
                bl.dy = 1 + rn.nextInt(moveRate);
            }
            bl = this.ChangeBulletStopToMove(bl);
            this.bulletVector.addElement(bl);
            ++i;
        }
        i = 0;
        while (i < 40) {
            if (i < 30) {
                if (i % 3 == 0) {
                    bl = new RedBullet(this.sprite, x + rn.nextInt(range), y + rn.nextInt(range), true);
                    bl.dx = rn.nextInt(moveRate);
                    bl.dy = 1 + rn.nextInt(moveRate);
                } else {
                    bl = new GreenBullet(this.sprite, x + rn.nextInt(range), y + rn.nextInt(range), true);
                    bl.dx = rn.nextInt(moveRate);
                    bl.dy = 1 + rn.nextInt(moveRate);
                }
            } else if (i % 5 != 0) {
                bl = new GreenBullet(this.sprite, x + rn.nextInt(range), y + rn.nextInt(range), true);
                bl.dx = rn.nextInt(moveRate);
                bl.dy = -1 - rn.nextInt(moveRate);
            }
            bl = this.ChangeBulletStopToMove(bl);
            this.bulletVector.addElement(bl);
            ++i;
        }
    }

    private BasicBullet ChangeBulletStopToMove(BasicBullet bl) {
        if (bl.dx == 0 && bl.dy == 1) {
            Random rn = new Random();
            if (rn.nextInt() % 2 == 0) {
                if (rn.nextInt() % 2 == 0) {
                    bl.dx = 1;
                } else {
                    bl.dy = 2;
                }
            } else if (rn.nextInt() % 2 == 0) {
                bl.dx = -1;
            } else {
                bl.dy = -1;
            }
        }
        return bl;
    }

    public void createBossBullet(int x, int y, int bossType) {
        switch (bossType) {
            case 1: {
                this.createBossEgeBullet(x, y);
                break;
            }
            case 2: {
                this.createBossNormalBullet(x, y);
                break;
            }
            case 3: {
                this.createBossPowerBullet(x, y);
                break;
            }
            case 4: {
                this.createBossMasterBullet(x, y);
            }
        }
    }

    public void paint(Graphics g) {
        int i = 0;
        while (i < this.bulletVector.size()) {
            BasicBullet bl = (BasicBullet)this.bulletVector.elementAt(i);
            bl.draw(g);
            ++i;
        }
    }

    public void calcBullet() {
        BasicBullet bl;
        int i = 0;
        while (i < this.bulletVector.size()) {
            bl = (BasicBullet)this.bulletVector.elementAt(i);
            bl.move();
            ++i;
        }
        i = 0;
        while (i < this.bulletVector.size()) {
            bl = (BasicBullet)this.bulletVector.elementAt(i);
            if (bl.canDestroySelf()) {
                this.bulletVector.removeElement(bl);
                if (--i < 0) {
                    i = 0;
                }
            }
            ++i;
        }
    }
}

