/*
 * Decompiled with CFR 0.152.
 */
package de.exitgames.neutron.client;

import de.exitgames.neutron.client.GpOperation;
import de.exitgames.neutron.client.Neutron;
import de.exitgames.neutron.client.NeutronSession;
import java.util.Hashtable;

public class NeutronGame {
    private final String footprint;
    public int minPlayers;
    public int maxPlayers;
    public int playerLocalActorNr;
    public String name;
    public byte gamePool = (byte)-1;
    public byte state = 1;
    public static final byte STATE_SETUP = 1;
    public static final byte STATE_RUNNING = 2;
    public static final byte STATE_ENDED = 3;
    public static final int PLAYER_ACTIVE = 1;
    public static final int PLAYER_INACTIVE = 2;
    public static final int PLAYER_LEFT = 3;
    private NeutronSession _session;
    private String _actorSessionId;
    static final Integer REPLAY_COUNT = new Integer(15);
    String[][] arrPlayers;
    String[] arrPlayerData;
    static final int ACTORS_VALCOUNT = 6;
    static final String ACTORS_VALUES = "{n}$${un}$${s}$${k}$${ui}$${ul}";
    public static final int PLAYERD_ACTORNR = 0;
    public static final int PLAYERD_USERNAME = 1;
    public static final int PLAYERD_STATUS = 2;
    public static final int PLAYERD_SKILL = 3;
    public static final int PLAYERD_USERID = 4;
    public static final int PLAYERD_USERLOBBY = 5;
    private static final int PLAYERD_MAX = 5;

    protected NeutronGame(GpOperation gpOperation, NeutronSession neutronSession) {
        this.footprint = "{Footprint.Client.Game}";
        this._actorSessionId = (String)gpOperation.getRetVal(Neutron.P_ASID);
        this._session = neutronSession;
        this.name = (String)gpOperation.getRetVal(Neutron.P_NAME);
        if (gpOperation.getRetVal(Neutron.P_POOL) != null) {
            this.gamePool = (Byte)gpOperation.getRetVal(Neutron.P_POOL);
        }
        if (gpOperation.getRetVal(Neutron.P_INFO) != null) {
            this.state = (Byte)gpOperation.getRetVal(Neutron.P_INFO);
        }
        this.maxPlayers = (Integer)gpOperation.getRetVal(Neutron.P_MAXAS);
        this.minPlayers = (Integer)gpOperation.getRetVal(Neutron.P_MINAS);
        String[] stringArray = (String[])gpOperation.getRetVal(Neutron.P_ACTORS);
        this.arrPlayers = new String[this.maxPlayers + 1][];
        int n = stringArray.length / 6;
        for (int i = 0; i < n; ++i) {
            this.arrPlayers[i] = new String[6];
            System.arraycopy(stringArray, i * 6, this.arrPlayers[i], 0, 6);
        }
        this.playerLocalActorNr = (Integer)gpOperation.getRetVal(Neutron.P_ACTORNR);
        Neutron.millisecondsToWait = Neutron.pollingInGame;
    }

    public String getASID() {
        return this._actorSessionId;
    }

    public byte getGamePool() {
        return this.gamePool;
    }

    public String playerGetUserName(int n) {
        return this.playerGetDataByActorNr(n, 1);
    }

    public int playerGetStatus(int n) {
        String string = this.playerGetDataByActorNr(n, 2);
        return string == null ? -1 : Integer.valueOf(string);
    }

    public int playerGetSkill(int n) {
        String string = this.playerGetDataByActorNr(n, 3);
        return string == null ? -1 : Integer.valueOf(string);
    }

    public String playerGetUserID(int n) {
        return this.playerGetDataByActorNr(n, 4);
    }

    public String playerGetUserLobby(int n) {
        return this.playerGetDataByActorNr(n, 5);
    }

    public int playerGetActorNumber(String string) {
        int n = this.playerGetIndexByField(string, 1);
        if (n != -1) {
            return Integer.valueOf(this.arrPlayers[n][0]);
        }
        return -1;
    }

    public int playerGetActorNumberByUserID(String string) {
        int n = this.playerGetIndexByField(string, 4);
        if (n != -1) {
            return Integer.valueOf(this.arrPlayers[n][0]);
        }
        return -1;
    }

    public int playerGetCount() {
        int n = 0;
        String string = String.valueOf(3);
        for (int i = 0; i < this.maxPlayers; ++i) {
            this.arrPlayerData = this.arrPlayers[i];
            if (this.arrPlayerData == null || string.equals(this.arrPlayerData[2])) continue;
            ++n;
        }
        return n;
    }

    public int playerGetNext(int n) {
        int n2 = this.playerGetNextWithStatus(n, -1);
        if (n2 == -1) {
            n2 = this.playerGetNextWithStatus(0, -1);
        }
        return n2;
    }

    public int playerGetNextActive(int n) {
        int n2 = this.playerGetNextWithStatus(n, 1);
        if (n2 == -1) {
            n2 = this.playerGetNextWithStatus(0, 1);
        }
        return n2;
    }

    public int playerGetFirstActive() {
        return this.playerGetNextWithStatus(0, 1);
    }

    public int playerGetNextWithStatus(int n, int n2) {
        int n3 = 999;
        String string = n2 == -1 ? null : String.valueOf(n2);
        for (int i = 0; i < this.maxPlayers; ++i) {
            int n4;
            this.arrPlayerData = this.arrPlayers[i];
            if (this.arrPlayerData == null || string != null && !this.arrPlayerData[2].equals(string) || (n4 = Integer.parseInt(this.arrPlayerData[0])) <= n || n4 >= n3) continue;
            n3 = n4;
        }
        return n3 == 999 ? -1 : n3;
    }

    public int playerGetLocal() {
        return this.playerLocalActorNr;
    }

    public void printPlayerArrays() {
        System.out.println("\nPlayers Array");
        for (int i = 0; i <= this.maxPlayers; ++i) {
            this.arrPlayerData = this.arrPlayers[i];
            if (this.arrPlayerData == null) {
                System.out.println("index " + i + " is null.\n");
                continue;
            }
            System.out.println("index " + i);
            if (i == this.maxPlayers) {
                System.out.println("(LAST QUIT PLAYER)");
            }
            System.out.println("actor " + this.arrPlayerData[0]);
            System.out.println("name " + this.arrPlayerData[1]);
            System.out.println("id " + this.arrPlayerData[4]);
            System.out.println("status " + this.arrPlayerData[2]);
            System.out.println("skill " + this.arrPlayerData[3]);
            System.out.println("\n");
        }
    }

    public final String playerGetDataByActorNr(int n, int n2) {
        if (n2 > 5 || n2 < 0) {
            return null;
        }
        String string = String.valueOf(n);
        for (int i = 0; i < this.arrPlayers.length; ++i) {
            this.arrPlayerData = this.arrPlayers[i];
            if (this.arrPlayerData == null || !string.equals(this.arrPlayerData[0])) continue;
            return this.arrPlayerData[n2];
        }
        return null;
    }

    final int playerGetIndexByField(String string, int n) {
        for (int i = 0; i < this.maxPlayers; ++i) {
            this.arrPlayerData = this.arrPlayers[i];
            if (this.arrPlayerData == null || !string.equals(this.arrPlayerData[n])) continue;
            return i;
        }
        return -1;
    }

    void playerAdd(String[] stringArray) {
        int n;
        for (n = 0; this.arrPlayers[n] != null && n < this.arrPlayers.length; ++n) {
        }
        this.arrPlayers[n] = new String[6];
        System.arraycopy(stringArray, 0, this.arrPlayers[n], 0, 6);
        System.out.println("playerAdd done");
    }

    void playerRemove(Integer n) {
        int n2 = this.playerGetIndexByField(n.toString(), 0);
        if (n2 != -1) {
            this.arrPlayers[n2][2] = String.valueOf(3);
            this.arrPlayers[this.maxPlayers] = this.arrPlayers[n2];
            this.arrPlayers[n2] = null;
        }
    }

    final void playerSetStatus(Integer n, int n2) {
        int n3 = this.playerGetIndexByField(n.toString(), 0);
        if (n3 != -1) {
            this.arrPlayers[n3][2] = String.valueOf(n2);
        }
    }

    void eventAction(int n, Hashtable hashtable) {
        Integer n2 = (Integer)hashtable.get("ActorNr");
        switch (n) {
            case 5: {
                String string = (String)hashtable.get("Status");
                if (string == null) {
                    string = String.valueOf(1);
                }
                if (this.playerGetUserName(n2) != null) {
                    return;
                }
                this.playerAdd(new String[]{n2.toString(), (String)hashtable.get("Username"), string, hashtable.get("Skill").toString(), (String)hashtable.get("UserID"), (String)hashtable.get("Lobby")});
                return;
            }
            case 4: {
                this.state = (byte)2;
                return;
            }
            case 3: {
                this.state = (byte)3;
                return;
            }
            case 0: {
                this.playerSetStatus(n2, 1);
                return;
            }
            case 1: {
                this.playerSetStatus(n2, 2);
                return;
            }
            case 2: {
                if (this.state == 1) {
                    this.playerRemove(n2);
                } else {
                    this.playerSetStatus(n2, 3);
                }
                return;
            }
            case 53: {
                int n3 = (Integer)hashtable.get("PollFreq");
                if (n3 >= 0) {
                    Neutron.pollingInGame = n3;
                }
                if ((n3 = ((Integer)hashtable.get("PollIdle")).intValue()) >= 0) {
                    Neutron.emptyPollsBeforeIdling = n3;
                }
                if ((n3 = ((Integer)hashtable.get("PollMult")).intValue()) < 0) break;
                Neutron.maxWaitMultiplier = n3;
            }
        }
    }

    public void deactivate() {
        GpOperation gpOperation = new GpOperation(this._session.serverUrl, this._session.sid, 17);
        gpOperation.addParameter(Neutron.P_ASID, this._actorSessionId);
        Neutron.sendQueue.addElement(gpOperation);
    }

    public void start() {
        GpOperation gpOperation = new GpOperation(this._session.serverUrl, this._session.sid, 30);
        gpOperation.addParameter(Neutron.P_ASID, this._actorSessionId);
        Neutron.sendQueue.addElement(gpOperation);
    }

    public void end() {
        GpOperation gpOperation = new GpOperation(this._session.serverUrl, this._session.sid, 27);
        gpOperation.addParameter(Neutron.P_ASID, this._actorSessionId);
        Neutron.sendQueue.addElement(gpOperation);
    }

    public void quit() {
        GpOperation gpOperation = new GpOperation(this._session.serverUrl, this._session.sid, 31);
        gpOperation.addParameter(Neutron.P_ASID, this._actorSessionId);
        Neutron.sendQueue.addElement(gpOperation);
    }

    public void invite(String[] stringArray, boolean bl) {
        GpOperation gpOperation = new GpOperation(this._session.serverUrl, this._session.sid, 73);
        gpOperation.addParameter(Neutron.P_ASID, this._actorSessionId);
        gpOperation.addParameter(Neutron.P_ACTORS, stringArray);
        gpOperation.addParameter(Neutron.P_RESERVE, new Boolean(bl));
        Neutron.sendQueue.addElement(gpOperation);
    }

    public final void sendData(Object object) {
        GpOperation gpOperation = new GpOperation(this._session.serverUrl, this._session.sid, 29);
        gpOperation.addParameter(Neutron.P_ASID, this._actorSessionId);
        gpOperation.addParameter(Neutron.P_DATA, object);
        Neutron.sendQueue.addElement(gpOperation);
    }

    public final void raiseEvent(Hashtable hashtable) {
        GpOperation gpOperation = new GpOperation(this._session.serverUrl, this._session.sid, 21);
        gpOperation.addParameter(Neutron.P_ASID, this._actorSessionId);
        gpOperation.addParameter(Neutron.P_DATA, hashtable);
        Neutron.sendQueue.addElement(gpOperation);
    }

    public void sendTextMsg(String string) {
        GpOperation gpOperation = new GpOperation(this._session.serverUrl, this._session.sid, 12);
        gpOperation.addParameter(Neutron.P_ASID, this._actorSessionId);
        gpOperation.addParameter(Neutron.P_MSG, string);
        Neutron.sendQueue.addElement(gpOperation);
    }

    public void handoverTurn(Object object, int n) {
        GpOperation gpOperation = new GpOperation(this._session.serverUrl, this._session.sid, 28);
        gpOperation.addParameter(Neutron.P_ASID, this._actorSessionId);
        gpOperation.addParameter(Neutron.P_ACTORNR, new Integer(n));
        gpOperation.addParameter(Neutron.P_DATA, object);
        Neutron.sendQueue.addElement(gpOperation);
    }

    public void rename(String string) {
        GpOperation gpOperation = new GpOperation(this._session.serverUrl, this._session.sid, 14);
        gpOperation.addParameter(Neutron.P_ASID, this._actorSessionId);
        gpOperation.addParameter(Neutron.P_NAME, string);
        Neutron.sendQueue.addElement(gpOperation);
    }

    public void getEventHistory(String string) {
        string = "";
        GpOperation gpOperation = new GpOperation(this._session.serverUrl, this._session.sid, 42);
        gpOperation.addParameter(Neutron.P_ASID, this._actorSessionId);
        gpOperation.addParameter(Neutron.P_COUNT, REPLAY_COUNT);
        gpOperation.addParameter(Neutron.P_FILTER, string);
        Neutron.sendQueue.addElement(gpOperation);
    }
}

