/*
 * Decompiled with CFR 0.152.
 */
package sk.inlogic.mini;

import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;
import sk.inlogic.graphics.GFont;
import sk.inlogic.mini.Bod;
import sk.inlogic.mini.Tools;

public class Button {
    public Bod Poloha = null;
    public int Width = 0;
    public int Height = 0;
    public int Id = -1;
    String text;
    boolean IsSelected;

    public Button() {
    }

    public Button(int x, int y, int width, int height) {
        this.Width = width;
        this.Height = height;
        this.Poloha = new Bod(x, y);
    }

    public Button(int x, int y, int width, int height, String text, GFont font) {
        this.Width = width;
        this.Height = height;
        int sirkaTextu = font.stringWidth(this.text.toCharArray());
        if (this.Width <= sirkaTextu) {
            this.Width = sirkaTextu;
        }
        if (this.Height <= font.getHeight()) {
            this.Height = font.getHeight();
        }
        this.Poloha = new Bod(x, y);
    }

    public void SetButton(int id, String text, GFont font) {
        this.Id = id;
        this.text = text;
        int sirkaTextu = font.stringWidth(this.text.toCharArray());
        if (this.Width <= sirkaTextu) {
            this.Width = sirkaTextu;
        }
        if (this.Height <= font.getHeight()) {
            this.Height = font.getHeight();
        }
    }

    public void SetText(String text) {
        this.text = text;
    }

    public void SetText(String text, GFont font) {
        this.text = text;
        if (font != null) {
            int sirkaTextu = font.stringWidth(this.text.toCharArray());
            if (this.Width <= sirkaTextu) {
                this.Width = sirkaTextu;
            }
            if (this.Height <= font.getHeight()) {
                this.Height = font.getHeight();
            }
        }
    }

    public void SetText(String text, GFont font, int marginWidth, int marginHeight) {
        this.text = text;
        if (font != null) {
            int sirkaTextu = font.stringWidth(this.text.toCharArray());
            if (this.Width <= sirkaTextu) {
                this.Width = sirkaTextu + marginWidth;
            }
            if (this.Height <= font.getHeight()) {
                int ys = this.Poloha.Y - (this.Height >> 1);
                this.Height = font.getHeight() + marginHeight;
                this.SetTop(ys);
            }
        }
    }

    public void SetTopLeft(int x, int y) {
        this.Poloha.X = x + (this.Width >> 1);
        this.Poloha.Y = y + (this.Height >> 1);
    }

    public void SetVelkost(int width, int height) {
        this.Width = width;
        this.Height = height;
    }

    public void SetTop(int y) {
        this.Poloha.Y = y + (this.Height >> 1);
    }

    public void SetLeft(int x) {
        this.Poloha.X = x + (this.Width >> 1);
    }

    public void SetRight(int x) {
        this.Poloha.X = x - (this.Width >> 1);
    }

    public void SetBottom(int y) {
        this.Poloha.Y = y - (this.Height >> 1);
    }

    public int GetTop() {
        return this.Poloha.Y - (this.Height >> 1);
    }

    public int GetLeft() {
        return this.Poloha.X - (this.Width >> 1);
    }

    public int GetRight() {
        return this.Poloha.X + (this.Width >> 1);
    }

    public int GetBottom() {
        return this.Poloha.Y + (this.Height >> 1);
    }

    public void SetButton(int id, String text) {
        this.Id = id;
        this.text = text;
    }

    public void Draw(Graphics g, Sprite sprTable) {
        Tools.paintTable(g, sprTable, this.Poloha.X, this.Poloha.Y, this.Width, this.Height);
    }

    public void Draw(Graphics g, Sprite sprTable, GFont font) {
        Tools.paintTable(g, sprTable, this.Poloha.X, this.Poloha.Y, this.Width, this.Height);
        if (font != null) {
            font.drawString(g, this.text.toCharArray(), this.Poloha.X, this.Poloha.Y, 3);
        }
    }

    public void DrawOne(Graphics g, Sprite sprTable, GFont font) {
        Tools.DrawPruzokOne(g, sprTable, this.GetLeft(), this.GetTop(), this.Width);
        if (font != null) {
            font.drawString(g, this.text.toCharArray(), this.Poloha.X, this.Poloha.Y, 3);
        }
    }

    public void Draw(Graphics g, Sprite spr, int frame) {
        spr.setFrame(frame);
        spr.setPosition(this.GetLeft(), this.GetTop());
        spr.paint(g);
    }

    public void Draw(Graphics g, Sprite spr, int frame, GFont font) {
        spr.setFrame(frame);
        spr.setPosition(this.GetLeft(), this.GetTop());
        spr.paint(g);
        if (font == null || this.text != null) {
            // empty if block
        }
    }

    public void Draw(Graphics g, Image img, GFont font) {
        if (img != null) {
            g.drawImage(img, this.Poloha.X, this.Poloha.Y, 3);
        }
        if (font == null || this.text != null) {
            // empty if block
        }
    }

    public void Draw(Graphics g, Image img) {
        if (img != null) {
            g.drawImage(img, this.Poloha.X, this.Poloha.Y, 3);
        }
    }

    public boolean click(int px, int py) {
        return px >= this.GetLeft() && px <= this.GetRight() && py >= this.GetTop() && py <= this.GetBottom();
    }

    public boolean click(int select) {
        return this.Id == select;
    }
}

