/*
 * Decompiled with CFR 0.152.
 */
package Game.Screen;

import Game.ExtraClass.Point;
import Game.ExtraClass.globalVariable;
import Game.ExtraClass.mMath;
import Game.Screen.Map;
import java.io.IOException;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;

public class Ball
extends Sprite {
    private int type;
    private float sYDelay = 0.0f;
    private float sXDelay = 0.0f;
    private long f;
    private float vY;
    private float vX;
    private int maxAngleToRoll = 30;
    private float aX;
    private float aY;
    private int g = 200;
    private boolean flagRoll;
    private static String ballImageResource = "/Resource/ballArray32.png";
    private static int ballWidth = 32;
    private static int ballHeight = 32;
    private int posX;
    private int posY;
    private int screenWidth;
    private int screenHeight;
    private Map map;
    private Point pMap;
    private boolean isMeetTarget = false;
    private boolean paused = true;
    private int[] arrayElastic = new int[]{700, 650, 600, 500, 620};
    private int tmpMaSat = 995;
    private int[][] objectPoints;
    private int numPoints;
    int specialMoveCount = 0;
    int oldComeAngle = 0;
    boolean cacFlag = false;

    public Ball(int screenWidth, int screenHeight, long framePerSecond, Map map, Point pStart, Point pMap) throws IOException {
        super(Image.createImage((String)ballImageResource), ballWidth, ballHeight);
        this.type = globalVariable.ballType;
        this.f = framePerSecond;
        this.ReInit(pStart);
        this.screenHeight = screenHeight;
        this.screenWidth = screenWidth;
        this.setRefPixelPosition(this.posX, this.posY);
        this.setVisible(true);
        this.loadBallPoints();
        this.pMap = pMap;
        this.map = map;
    }

    public void ReInit(Point pStart) {
        this.type = globalVariable.ballType;
        this.setFrame(this.type);
        this.posX = pStart.x;
        this.posY = pStart.y;
        this.vY = 0.0f;
        this.vX = 0.0f;
        this.aX = 0.0f;
        this.aY = this.g;
        this.flagRoll = false;
        this.setPause(true);
    }

    public int moveY() {
        float deltaSY = (double)mMath.abs(this.aY) < 0.001 ? 2.0f * this.vY / (float)this.f : 2.0f * this.vY / (float)this.f + this.aY / ((float)this.f * (float)this.f);
        if ((double)mMath.abs(this.sYDelay) > 0.001) {
            deltaSY += this.sYDelay;
            this.vY += this.aY / (float)this.f;
        }
        int sInt = mMath.getInt(deltaSY);
        this.sYDelay = deltaSY - (float)sInt;
        return sInt;
    }

    public int moveX() {
        float deltaSX;
        if ((double)mMath.abs(this.aX) < 0.001) {
            deltaSX = 2.0f * this.vX / (float)this.f;
        } else {
            deltaSX = 2.0f * this.vX / (float)this.f + this.aX / ((float)this.f * (float)this.f);
            this.vX += this.aX / (float)this.f;
        }
        if ((double)mMath.abs(this.sXDelay) > 0.001) {
            deltaSX += this.sXDelay;
        }
        int sInt = mMath.getInt(deltaSX);
        this.sXDelay = deltaSX - (float)sInt;
        return sInt;
    }

    public void advance(long timeNow) {
        this.ballMove(1.0f, 0.0f, 0.0f, 0.0f, 0);
    }

    public void ballMove(float rateMove, float special, float angle1, float angle2, int count) {
        if (!this.paused) {
            float[] rate;
            int y;
            boolean flagMove = false;
            int x = mMath.getInt((float)this.moveX() * rateMove);
            int objectType = this.checkMeetObject(x, y = mMath.getInt((float)this.moveY() * rateMove), rate = new float[7], special);
            if (objectType == 99 && !this.isMeetTarget) {
                this.isMeetTarget = true;
            }
            if (objectType != 0 && objectType != 99) {
                double angle = rate[3];
                int gocToi = this.tinhGocToi();
                if ((double)mMath.abs(rate[4] - 0.0f) >= 0.001 && ((double)mMath.abs(rate[5] - 0.0f) >= 0.001 || (double)mMath.abs(rate[6] - 0.0f) >= 0.001)) {
                    angle = rate[4];
                }
                if ((double)mMath.abs(rate[4] - special) < 0.001 && (double)mMath.abs(rate[4] - 0.0f) > 0.001 && (mMath.abs(angle - (double)angle1) < 0.001 || mMath.abs(angle - (double)angle2) < 0.001)) {
                    gocToi = this.oldComeAngle;
                }
                float[] vReturn = new float[2];
                this.oldComeAngle = gocToi;
                int gocPhanXa = this.tinhGocPhanXa(gocToi, mMath.getInt(angle));
                boolean flagNay = this.checkNay(gocToi, gocPhanXa, mMath.getInt(angle), vReturn);
                if (flagNay && !this.flagRoll) {
                    this.vX = vReturn[0];
                    this.vY = vReturn[1];
                } else if (!this.flagRoll) {
                    this.setRoll(angle, gocPhanXa, objectType);
                }
                if ((double)rate[2] >= 0.95) {
                    x = (int)rate[0];
                    y = (int)rate[1];
                } else {
                    this.posX += (int)rate[0];
                    this.posY += (int)rate[1];
                    if (++count <= 500) {
                        this.ballMove(1.0f - rate[2], rate[4], rate[5], rate[6], ++count);
                    }
                    return;
                }
            }
            if (this.flagRoll) {
                this.Roll(objectType);
            }
            this.posX += x;
            this.posY += y;
            if (this.posY >= this.screenHeight - this.getHeight()) {
                this.posY = this.screenHeight - this.getHeight();
                this.vY = -this.vY * 0.93f;
                if ((double)this.vY < 0.001) {
                    flagMove = true;
                }
            }
            if (this.posX <= 0) {
                this.posX = 0;
                this.vX = -this.vX;
            }
            if (this.posX >= this.screenWidth - this.getWidth()) {
                this.posX = this.screenWidth - this.getWidth();
                this.vX = -this.vX;
            }
            if (this.posY < 10) {
                this.vY = 0.0f;
            }
            if (flagMove) {
                this.vX *= 0.984f;
            }
        }
        this.setRefPixelPosition(this.posX + this.pMap.x, this.posY + this.pMap.y);
    }

    public int checkMeetObject(int x, int y, float[] rate, float special) {
        int objectType = 0;
        boolean flagSwap = false;
        if (Math.abs(x) < Math.abs(y)) {
            int swap = y;
            y = x;
            x = swap;
            flagSwap = true;
        }
        int unit = 1;
        if (x < 0) {
            unit = -1;
        }
        int i = unit;
        while (mMath.abs(i) <= mMath.abs(x)) {
            int j = mMath.getInt((float)(y * i) / (float)x);
            int sumAngle = 0;
            int num = 0;
            boolean flagConflict = false;
            boolean flagMeetSpecial = false;
            int angleSpecial = 0;
            for (int k = 0; k < this.numPoints; ++k) {
                int pointOnMap;
                int a = this.objectPoints[k][0];
                int b = this.objectPoints[k][1];
                if (flagSwap) {
                    int swap = j;
                    j = i;
                    i = swap;
                }
                if ((pointOnMap = this.map.getPoint(this.posX + i + a, this.posY + j + b)) != 0) {
                    int[] specialPoints = new int[2];
                    int shockAngle = pointOnMap / 100;
                    if (this.isSpecial(this.posX + i + a, this.posY + j + b, specialPoints)) {
                        shockAngle = this.angleOnBallFromCenter(a, b);
                        flagMeetSpecial = true;
                        angleSpecial = shockAngle;
                        num = 1;
                        sumAngle = shockAngle;
                    }
                    if (!flagMeetSpecial) {
                        if (angleSpecial > 90 && shockAngle == 0) {
                            shockAngle = 180;
                        }
                        sumAngle += shockAngle;
                        ++num;
                    }
                    objectType = pointOnMap % 100;
                    flagConflict = true;
                }
                if (!flagSwap) continue;
                int swap = j;
                j = i;
                i = swap;
            }
            if (flagConflict) {
                j = mMath.getInt((float)(y * (i -= unit)) / (float)x);
                if (flagSwap) {
                    int swap = j;
                    j = i;
                    i = swap;
                    swap = y;
                    y = x;
                    x = swap;
                }
                rate[0] = i;
                rate[1] = j;
                rate[2] = i == 0 && y != 0 ? (float)j / (float)y : (j == 0 && x != 0 ? (float)i / (float)x : ((float)j / (float)y + (float)i / (float)x) / 2.0f);
                if ((double)rate[2] > 0.95) {
                    rate[2] = 1.0f;
                }
                rate[3] = (float)sumAngle / ((float)num * 10.0f);
                return objectType;
            }
            i += unit;
        }
        return objectType;
    }

    public int fixRoll(double angle, int type, int x, int y) {
        boolean flagFixed = false;
        int result = 0;
        while (!flagFixed) {
            int k = 0;
            for (k = 0; k < this.numPoints; ++k) {
                int a = this.objectPoints[k][0];
                int b = this.objectPoints[k][1];
                if ((double)this.map.getPoint(x + a, y + b - result) != angle * 10.0 + (double)type) continue;
                ++result;
                break;
            }
            if (k != this.numPoints) continue;
            flagFixed = true;
        }
        return result;
    }

    public void setRoll(double angle, int gocPhanXa, int type) {
        float sinB = (float)Math.sin(Math.toRadians(angle));
        float cosB = (float)Math.cos(Math.toRadians(angle));
        this.aY = (float)this.g * sinB * sinB;
        this.aX = (float)(-this.g) * sinB * cosB;
        float d = this.aY / this.aX;
        this.vY = gocPhanXa < 0 || gocPhanXa > 180 ? mMath.abs(this.vX * d) : -mMath.abs(this.vX * d);
        this.flagRoll = true;
    }

    public void Roll(int type) {
        if (this.checkFallDown(type)) {
            this.flagRoll = false;
            this.aX = 0.0f;
            this.aY = this.g;
        } else {
            this.vX *= (float)(this.tmpMaSat / 1000);
            this.vY *= (float)(this.tmpMaSat / 1000);
        }
    }

    public boolean checkFallDown(int type) {
        boolean flagFallDown = true;
        for (int i = 0; i < this.numPoints; ++i) {
            if (this.objectPoints[i][1] < (this.getHeight() - 1) / 2 + 1 || this.map.getPoint(this.posX + this.objectPoints[i][0], this.posY + this.objectPoints[i][1] - 1) % 100 == 0 && this.map.getPoint(this.posX + this.objectPoints[i][0], this.posY + this.objectPoints[i][1]) % 100 == 0 && this.map.getPoint(this.posX + this.objectPoints[i][0], this.posY + this.objectPoints[i][1] + 1) % 100 == 0 && this.map.getPoint(this.posX + this.objectPoints[i][0], this.posY + this.objectPoints[i][1] + 2) % 100 == 0 && this.map.getPoint(this.posX + this.objectPoints[i][0], this.posY + this.objectPoints[i][1] + 3) % 100 == 0) continue;
            flagFallDown = false;
        }
        return flagFallDown;
    }

    public int tinhGocToi() {
        this.vY = -this.vY;
        int gocToi = 0;
        if ((double)Math.abs(this.vX) < 0.01) {
            gocToi = this.vY > 0.0f ? 90 : 270;
        } else if ((double)Math.abs(this.vY) < 0.01) {
            gocToi = this.vX > 0.0f ? 0 : 180;
        } else {
            gocToi = (int)Math.toDegrees(mMath.atan(this.vY / this.vX));
            if (this.vX < 0.0f && this.vY < 0.0f || this.vY > 0.0f && this.vX < 0.0f) {
                gocToi += 180;
            }
        }
        this.vY = -this.vY;
        return gocToi;
    }

    public int tinhGocPhanXa(int gocToi, int matNghieng) {
        int result = 0;
        result = 2 * matNghieng - gocToi;
        return result;
    }

    public boolean checkNay(int gocToi, int gocPhanXa, int gocNghieng, float[] vReturn) {
        boolean flagNay = true;
        float huyen = (float)Math.sqrt(this.vY * this.vY + this.vX * this.vX);
        int doNay = this.arrayElastic[this.type];
        if (gocNghieng > 90) {
            gocNghieng = 180 - gocNghieng;
        }
        float gocNay = (float)this.maxAngleToRoll * (1.0f - (float)gocNghieng / 90.0f);
        float cos = (float)mMath.abs(Math.cos(Math.toRadians(gocNghieng)));
        doNay = 1000 - mMath.getInt((float)(1000 - doNay) * cos);
        vReturn[0] = (float)(Math.cos(Math.toRadians(gocPhanXa)) * (double)huyen * (double)doNay / 1000.0);
        vReturn[1] = -((float)(Math.sin(Math.toRadians(gocPhanXa)) * (double)huyen * (double)doNay / 1000.0));
        if (gocNghieng != 90) {
            if (gocToi < 0) {
                gocToi += 360;
            }
            if (gocPhanXa < 0) {
                gocPhanXa += 360;
            }
            if (vReturn[1] < 0.0f && vReturn[1] * vReturn[1] + vReturn[0] * vReturn[0] < 2000.0f * cos) {
                flagNay = false;
            }
        }
        return flagNay;
    }

    public void loadBallPoints() {
        double tmp;
        int D = this.getWidth() - 1;
        this.objectPoints = new int[D * 4][2];
        this.numPoints = 0;
        int r = D / 2;
        float r1 = (float)D / 2.0f;
        int x = 0;
        int y = 0;
        for (y = r; y >= r / 2 - 1; --y) {
            tmp = (double)r1 - Math.sqrt(r1 * r1 - ((float)y - r1) * ((float)y - r1));
            if (tmp - (double)(x = (int)tmp) >= 0.5) {
                // empty if block
            }
            this.objectPoints[this.numPoints][0] = ++x;
            this.objectPoints[this.numPoints][1] = y;
            ++this.numPoints;
            this.objectPoints[this.numPoints][0] = D - x;
            this.objectPoints[this.numPoints][1] = y;
            ++this.numPoints;
            this.objectPoints[this.numPoints][0] = D - x;
            this.objectPoints[this.numPoints][1] = D - y;
            ++this.numPoints;
            this.objectPoints[this.numPoints][0] = x;
            this.objectPoints[this.numPoints][1] = D - y;
            ++this.numPoints;
        }
        ++x;
        while (x <= r + (D + 1) % 2) {
            tmp = (double)r1 - Math.sqrt(r1 * r1 - ((float)x - r1) * ((float)x - r1));
            if (tmp - (double)(y = (int)tmp) >= 0.5) {
                // empty if block
            }
            this.objectPoints[this.numPoints][0] = x;
            this.objectPoints[this.numPoints][1] = ++y;
            ++this.numPoints;
            this.objectPoints[this.numPoints][0] = D - x;
            this.objectPoints[this.numPoints][1] = y;
            ++this.numPoints;
            this.objectPoints[this.numPoints][0] = D - x;
            this.objectPoints[this.numPoints][1] = D - y;
            ++this.numPoints;
            this.objectPoints[this.numPoints][0] = x++;
            this.objectPoints[this.numPoints][1] = D - y;
            ++this.numPoints;
        }
    }

    public void setPause(boolean isPaused) {
        this.paused = isPaused;
    }

    public boolean isSpecial(int x, int y, int[] specialPoints) {
        boolean flag = true;
        int point = this.map.getPoint(x, y);
        int[] a = new int[]{this.map.getPoint(x - 1, y - 1), this.map.getPoint(x, y - 1), this.map.getPoint(x + 1, y - 1), this.map.getPoint(x - 1, y), this.map.getPoint(x + 1, y), this.map.getPoint(x - 1, y + 1), this.map.getPoint(x, y + 1), this.map.getPoint(x + 1, y + 1)};
        int j = 0;
        for (int i = 0; i < 8; ++i) {
            if (a[i] == 0) continue;
            if (a[i] == point) {
                flag = false;
                continue;
            }
            if (j >= 2) continue;
            specialPoints[j++] = a[i];
        }
        return flag;
    }

    public int angleOnBallFromCenter(int a, int b) {
        int xcenter = this.getWidth() / 2;
        int ycenter = this.getHeight() / 2;
        if (a == xcenter) {
            return 0;
        }
        if (b == ycenter) {
            return 900;
        }
        int angle = mMath.getInt(Math.toDegrees(mMath.atan((float)(a - xcenter) / (float)(b - ycenter))) * 10.0);
        if (angle < 0) {
            angle += 1800;
        }
        return angle;
    }

    public boolean isMeetTarget() {
        return this.isMeetTarget;
    }
}

