/*
 * Decompiled with CFR 0.152.
 */
package Game.Screen;

import Game.ExtraClass.Point;
import Game.ExtraClass.SoundPlayer;
import Game.ExtraClass.globalVariable;
import Game.ExtraClass.mMath;
import Game.Item.Item;
import Game.Screen.AbstractLayer;
import Game.Screen.GameManager;
import Game.Screen.TaskBarLayer;
import java.util.Vector;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Layer;

public class ObjectLayer
extends AbstractLayer {
    int itemClicking = -1;
    private Vector items = new Vector();
    int[][] mapBlock;
    int width;
    int height;
    long timerstart = 0L;
    long timeend = 0L;

    public ObjectLayer(GameManager manager, int width, int height) {
        super(manager, new Point(0, 0));
        this.width = width;
        this.height = height;
        this.mapBlock = manager.getMapBlock();
    }

    public Vector getItem() {
        return this.items;
    }

    public void clear() {
        this.itemClicking = -1;
    }

    public boolean pointerPressed(int x, int y) {
        if (this.manager.startGame != 0) {
            return false;
        }
        this.itemClicking = -1;
        for (int i = 0; i < this.items.size(); ++i) {
            if (!((Item)((Object)this.items.elementAt(i))).CheckPoint(x, y)) continue;
            this.itemClicking = i;
        }
        return false;
    }

    public void Update(long milisecond) {
        if (this.manager.startGame != 0) {
            return;
        }
        this.timeend = milisecond;
        if (this.itemClicking != -1 && this.manager.getItemClick() == -1) {
            if (this.timerstart == 0L) {
                this.timerstart = milisecond;
            }
            if (this.timeend - this.timerstart >= 1000L) {
                this.manager.setItemClick(this.itemClicking);
                Item item = (Item)((Object)this.items.elementAt(this.manager.getItemClick()));
                item.removePosinMapBlock(this.mapBlock);
                this.changeSizeItem(item, 1);
            }
        } else {
            this.timerstart = 0L;
        }
    }

    public boolean pointerDragged(int x, int y) {
        if (this.manager.startGame != 0) {
            return false;
        }
        if (this.manager.getItemClick() != -1) {
            Item item = (Item)((Object)this.items.elementAt(this.manager.getItemClick()));
            item.SetPositionScreen(x - item.getWidth() / 2, y - item.getHeight() / 2);
            return true;
        }
        return false;
    }

    public boolean pointerReleased(int x, int y) {
        if (this.manager.startGame != 0) {
            return false;
        }
        if (this.manager.getItemClick() != -1) {
            Item item = (Item)((Object)this.items.elementAt(this.manager.getItemClick()));
            int xBlock = x / GameManager.sizeBlock * GameManager.sizeBlock / GameManager.sizeBlock;
            int yBlock = y / GameManager.sizeBlock * GameManager.sizeBlock / GameManager.sizeBlock;
            item.SetPositionScreen(x - item.getWidth() / 2, y - item.getHeight() / 2);
            this.changeSizeItem(item, 0);
            if (item.checkFreeLocation(this.mapBlock)) {
                TaskBarLayer layer = (TaskBarLayer)this.manager.getLayer(2);
                layer.IncreaseItem(item.getid());
                this.remove((Layer)item);
                this.items.removeElementAt(this.manager.getItemClick());
                layer.Refresh();
                this.manager.setScore(this.manager.getScore() + item.getCost());
            } else {
                SoundPlayer.playSong(1, 1);
                item.setPosinMapBlock(this.mapBlock);
            }
        }
        this.itemClicking = -1;
        return false;
    }

    private void changeSizeItem(Item item, int type) {
        Image image;
        this.remove((Layer)item);
        int x = 0;
        int y = 0;
        if (type == 0) {
            image = globalVariable.iTaskbar[item.getid() - 1];
            x = mMath.round(item.getRefPixelX() + item.getWidth() / 2 - image.getWidth() / 2, GameManager.sizeBlock);
            y = mMath.round(item.getRefPixelY() + item.getHeight() / 2 - image.getHeight() / 2, GameManager.sizeBlock);
            if (x < 0) {
                x = 0;
            }
            if (x + image.getWidth() > this.width) {
                x = this.width - image.getWidth();
            }
            if (y < 0) {
                y = 0;
            }
            if (y + image.getHeight() > this.height) {
                y = this.height - image.getHeight();
            }
        } else {
            image = globalVariable.iItem[item.getid() - 1];
            x = item.getRefPixelX() + item.getWidth() / 2 - image.getWidth() / 2;
            y = item.getRefPixelY() + item.getHeight() / 2 - image.getHeight() / 2;
        }
        item.SetPositionScreen(x, y);
        item.setImage(image, image.getWidth(), image.getHeight());
        this.append((Layer)item);
    }

    public void updateLayer(int itemIndex) {
        try {
            this.remove((Layer)((Item)((Object)this.items.elementAt(itemIndex))));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.append((Layer)((Item)((Object)this.items.elementAt(itemIndex))));
    }

    public void removeLayer(int itemIndex) {
        this.remove((Layer)((Item)((Object)this.items.elementAt(itemIndex))));
    }

    public void setPositionBackground(Point pBackground) {
        pBackground = new Point(pBackground.x, pBackground.y);
        this.pReal.x = this.pScreen.x - pBackground.x;
        this.pReal.y = this.pScreen.y - pBackground.y;
        for (int j = 0; j < this.items.size(); ++j) {
            ((Item)((Object)this.items.elementAt(j))).SetPositionBackground(pBackground.x, pBackground.y);
        }
    }

    public void DrawtoMap(int[][] map) {
        for (int i = 0; i < this.items.size(); ++i) {
            ((Item)((Object)this.items.elementAt(i))).DrawtoMap(map);
        }
    }
}

